
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#include "mysprintf.h"
#include "config.h"
#include <stdarg.h>
#include <string.h>
/*
static char* PrintInt(char* dest, unsigned short val, unsigned char fixedpoint) {
	char buf[5];
	char* ptr = buf;
	unsigned char digits = 1;

	while( val > 9 ) {
		*ptr++ = '0' + (val % 10);
		val /= 10;
		++digits;
	}
	*dest++ = '0' + val;
	while( --digits ) {
		if( fixedpoint && digits == 1 )
			*dest++ = '.';
		*dest++ = *--ptr;
	}
	return dest;
}
*/
char* mysprintf(char* dest, const rom far char* fmt, ...) {
	cs caddr;
	va_list vl;
	va_start(vl, fmt);

    TBLPTRL = ((csl*)&fmt)->c[0];
    TBLPTRH = ((csl*)&fmt)->c[1];

	while(1) {
		char c;
	    _asm TBLRDPOSTINC _endasm
		if( !(c = TABLAT) )
			break;
		if( c == '%' ) {
		    _asm TBLRDPOSTINC _endasm
			if( !(c = TABLAT) )
				break;

			switch(c) {
//			case '%':
			default:
				*dest++ = c;
				break;
			case 's':
			    caddr.c[0] = TBLPTRL;
    			caddr.c[1] = TBLPTRH;
				dest = mystrcpypgm2ram(dest, (const rom char far*)va_arg(vl, const rom char near*));
			    TBLPTRL = caddr.c[0];
    			TBLPTRH = caddr.c[1];
				break;
			case 'd':
			case 'f':
				{
					unsigned short val = va_arg(vl, unsigned short);
					char buf[5];
					char* ptr = buf;
					unsigned char digits = 1;
				
					while( val > 9 ) {
						*ptr++ = '0' + (val % 10);
						val /= 10;
						++digits;
					}
					*dest++ = '0' + val;
					while( --digits ) {
						if( c == 'f' && digits == 1 )
							*dest++ = '.';
						*dest++ = *--ptr;
					}
//					dest = PrintInt(dest, va_arg(vl, unsigned short), c == 'f');
					break;
				}
			}
		} else {
			*dest++ = c;
		}
	}
	va_end(vl);
	return dest;
}
