
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#ifndef _CONFIG_H_
#define _CONFIG_H_

void config_load(void);
void config_save(void);
void config_erase_all_sounds(void);
unsigned char config_erase_last_sound(void);

typedef union {
  unsigned short s;
  unsigned char c[2];
} cs;

typedef union {
  signed short s;
  unsigned char c[2];
} css;

typedef union {
  unsigned short long sl;
  unsigned char c[3];
} csl;

typedef union {
  unsigned long l;
  unsigned char c[4];
  csl sl;
} cl;

void EraseFlashPage(csl addr);
void MyWriteBlockFlash(csl startaddr, unsigned char num_blocks, unsigned char *flash_array);

#define AUDIO_FLAG_8BIT    1
#define AUDIO_FLAG_16BIT   2
#define AUDIO_FLAG_LOOP    4
#define AUDIO_FLAG_PARTIAL 8
typedef struct {
  csl start_addr;  // should always be on a 64 byte boundary
  csl finish_addr; // should always be one byte before a 64 byte boundary
  csl length_samples;
  csl length_bytes;
  cs sample_rate;
//  unsigned char playback_speed;
  unsigned char flags;
} audio_info;

#define TRIGGER_FLAG_NC         1
#define TRIGGER_FLAG_PRIORITY   2
#define TRIGGER_FLAG_RANDOM     4
typedef struct {
  unsigned char which_sounds_inv;
  unsigned char flags;
} trigger_info;

typedef struct {
  audio_info sounds[8];
  trigger_info triggers[2];
  unsigned char saved;
} config_info;

extern config_info g_config;

#define INTERPOLATION
#ifdef __DEBUG
#define INT_MEM_CFG_ADDR  0x5400
#else//__DEBUG
#define INT_MEM_CFG_ADDR  0x4C00
#endif//__DEBUG
#define INT_MEM_DATA_ADDR (INT_MEM_CFG_ADDR + ((sizeof(g_config)+63)/64)*64)
#define MAX_INT_MEM_BYTES (0x1FC00 - INT_MEM_DATA_ADDR)
#define MAX_EXT_MEM_BYTES ((unsigned short long)(524288UL))
#define PWM_RATE          ((unsigned short long)(187500UL))
#define FREE_RAM_ADDR     1536

#endif//_CONFIG_H_
