
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#ifndef _SPI_H_
#define _SPI_H_

void spi_init(void);
unsigned char spi_send_recv_byte(unsigned char byte);
unsigned char spi_get_flash_chip_presence(unsigned char index);
unsigned char spi_get_flash_chips_presence(void);
void spi_deep_sleep(unsigned char enabled);
unsigned char spi_erase_flash_chip_4k(unsigned char index, unsigned short long addr);
unsigned char spi_truncate_flash_chip_page_4k(unsigned char index, unsigned short long addr);
unsigned char spi_write_flash_chip_64b(unsigned char index, unsigned short long addr, unsigned char num_64b_blocks, const void* data);
void spi_initiate_read(unsigned char index, unsigned short long addr);
void spi_read(unsigned char index, unsigned char* dest, unsigned short long addr, unsigned short length);
void spi_copy_page(unsigned char index, unsigned short long dest_addr, unsigned short long src_addr, unsigned char max_blocks);
void spi_setup_dma(void* dest);
//void spi_initiate_read_dma(unsigned char index, unsigned short long addr, void* dest);
void spi_terminate_read(unsigned char index);
void spi_set_status(unsigned char index, unsigned char status);
void spi_protect_all(unsigned char index);
void spi_unprotect_all(unsigned char index);
unsigned char spi_get_status(unsigned char index);

#endif//_SPI_H_
