
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#include "p18F27J53.h"
#include "flash.h"
#include "audio.h"
#include "spi.h"
#include "config.h"

void audio_init() {
//ANCON0bits.PCFG0 = 1;
//ANCON0bits.PCFG1 = 1;
//ANCON0bits.PCFG4 = 1;
  ANCON0 |= (1   )|(1<<1)|(1<<4);

  PR2 = 64;
  ECCP1CONbits.CCP1M = 12; // PWM
  ECCP2CONbits.CCP2M = 12; // PWM

  TRISAbits.TRISA5 = 0;
  RPOR2 = 14;
  TRISAbits.TRISA0 = 0;
  RPOR0 = 18;
}

void two_thirds(unsigned short long* value) {
  *value = (*value / 3) * 2;
}

void three_quarters(unsigned short long* value) {
  *value = (*value * 3) / 4;
}

unsigned short long audio_get_sound_memory_total() {
	unsigned char flash_chips;

	flash_chips = spi_get_flash_chips_presence();
	if( flash_chips == 0 )
		return MAX_INT_MEM_BYTES;
	else if( flash_chips == 3 )
		return MAX_INT_MEM_BYTES + MAX_EXT_MEM_BYTES * 2;
	else
		return MAX_INT_MEM_BYTES + MAX_EXT_MEM_BYTES;
}

static unsigned char get_last_used_address(csl* here) {
	signed char i;
	for( i = 7; i >= 0; --i ) {
		*here = g_config.sounds[i].finish_addr;
		if( here->c[2] != 0xFF ) {
			return 1;
		}
	}
	return 0;
}

unsigned short long audio_get_sound_memory_used() {
	unsigned char flash_chip_present;
	csl finish_addr;

	if( get_last_used_address(&finish_addr) ) {
		unsigned char flashchip = get_flash_chip(&finish_addr);
		signed short long add;
		finish_addr.c[0] |= 63;
		if( flashchip ) {
			if( flashchip == 2 && (spi_deep_sleep(0), spi_get_flash_chip_presence(0)) )
				return finish_addr.sl + 1 + MAX_INT_MEM_BYTES + MAX_EXT_MEM_BYTES;
			else
				return finish_addr.sl + 1 + MAX_INT_MEM_BYTES;
		} else {
			return finish_addr.sl + 1 - INT_MEM_CFG_ADDR;
		}
	}

	return 0;
}

unsigned short long audio_get_sound_memory_free() {
	return audio_get_sound_memory_total() - audio_get_sound_memory_used();
}

audio_info* audio_get_available_slot(unsigned char* pindex) {
	unsigned char i;

	for( i = 0; i < 8; ++i ) {
		audio_info* psound = &g_config.sounds[i];
		if( psound->start_addr.c[2] == 0xFF ) {
			*pindex = i;
			return psound;
		}
	}
	return 0;
}

unsigned short long audio_get_first_free_address() {
	unsigned char flash_chip_present;
	csl finish_addr;

	if( get_last_used_address(&finish_addr) ) {
		unsigned char flashchip = get_flash_chip(&finish_addr);
		finish_addr.c[0] |= 63;
		++finish_addr.sl;
		if( !flashchip ) {
			if( finish_addr.sl == MAX_INT_MEM_BYTES ) {
				spi_deep_sleep(0);
				if( spi_get_flash_chip_presence(0) )
					return 0x400000UL;
				else if( spi_get_flash_chip_presence(1) )
					return 0x800000UL;
				else
					return 0;
			} else {
				return finish_addr.sl;
			}
		} else {
			if( finish_addr.sl == MAX_EXT_MEM_BYTES ) {
				if( flashchip == 2 )
					return 0;
				spi_deep_sleep(0);
				if( spi_get_flash_chip_presence(1) )
					return 0x800000UL;
				else
					return 0;
			} else {
				finish_addr.c[2] |= flashchip<<6;
				return finish_addr.sl;
			}
		}
	}

	return INT_MEM_DATA_ADDR;
}

unsigned char get_flash_chip(csl* pAddr) {
	unsigned char ret = pAddr->c[2]>>6;
	pAddr->c[2] &= 0x3f;
	return ret;
}
