
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#ifndef _WAV_H
#define _WAV_H

#define RIFF_HEADER_ID		0x46464952	/* "RIFF" Container type */
#define WAV_HEADER_ID		0x45564157	/* "WAVE" WAV file format */
#define DATA_HEADER_ID		0x41544144	/* "DATA" Audio Data */
#define FMT_HEADER_ID		0x20544D46	/* "FMT " Audio Format */
#define LIST_HEADER_ID		0x5453494C	/* "LIST" Track Info */

#define LIST_INFO_ID		0x4F464E49	/* "INFO" inside LIST */
#define ARTIST_INFO_ID		0x54524149	/* "IART" Artist */
#define TRACK_INFO_ID		0x4D414E49	/* "INAM" Name */
#define DATE_INFO_ID		0x44524349  /* "ICRD" Creation Date */
#define COMMENT_INFO_ID		0x544D4349	/* "ICMT" Comment */

#define AUDIO_FMT_PCM		1

#define MAX_TITLE_LENGTH	64
#define MAX_ARTIST_LENGTH	32
#define MAX_DATE_LENGTH		8
#define MAX_COMMENT_LENGTH	32

typedef struct
{
	unsigned long chunkID;
	unsigned long chunkSize;
} CHUNK_HEADER;

typedef struct
{
	CHUNK_HEADER riff;
	unsigned long WAVID;
} RiffHeader;

typedef struct
{
	CHUNK_HEADER data;
	unsigned char* dataPtr;
} DataHeader;
/*
typedef struct
{
	CHUNK_HEADER 	list;
	unsigned long   INFOID;
	unsigned char	trackTitle[MAX_TITLE_LENGTH];
	unsigned char	trackArtist[MAX_ARTIST_LENGTH];
	unsigned char	trackDate[MAX_DATE_LENGTH];
	unsigned char	trackComment[MAX_COMMENT_LENGTH];
} ListHeader;
*/
typedef struct
{
	CHUNK_HEADER 	fmt;
	unsigned int 	audioFormat;	// 2
	unsigned int 	numChannels;	// 2
	unsigned long 	sampleRate;		// 4
	unsigned long 	byteRate;		// 4
	unsigned int 	blockAlign;		// 2
	unsigned int 	bitsPerSample;	// 2
} FmtHeader;

typedef struct
{
	RiffHeader		riffHeader;
	FmtHeader		fmtHeader;
//	ListHeader		listHeader;
	DataHeader		dataHeader;
} WAVHeader;

/*
unsigned int WAVgetInt(unsigned char* inPtr, unsigned int* x);
unsigned int WAVgetLong(unsigned char* inPtr, unsigned long* x);
unsigned int WAVgetID(unsigned char* inPtr, unsigned long* x);
unsigned int WAVreadRiffChunk(unsigned char* inPtr, RiffHeader* riffHeader, unsigned int skipIt);
unsigned int WAVreadDataChunk(unsigned char* inPtr, DataHeader* dataHeader, unsigned int skipIt);
unsigned int WAVreadFmtChunk(unsigned char* inPtr, FmtHeader* fmtHeader, unsigned int skipIt);
unsigned int WAVreadListChunk(unsigned char* inPtr, ListHeader* listHeader, unsigned int skipIt);
unsigned int WAVreadWAVChunk(unsigned char* inPtr, WAVHeader* header, unsigned int* isDataChunk, unsigned int skipIt);
*/
unsigned char WAVreadWAVHeader(unsigned char* inPtr, WAVHeader* header, unsigned int maxBytes);
//void WAVinitHeader(WAVHeader* header);

#endif
