; 2510812
; Rev B. AJB 30/03/2021	Fixed uninitialized CYCLE variable issue.
 
; Woofer Stopper

;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT	

; EEPROM
EEPROM0		equ	H'00'	; non-volatile storage for EEPROM stored flag
EEPROM1		equ	H'01'	; non-volatile storage for OSCCAL

; RAM 

STORE1			equ	H'20'	; delay counter	
STORE2			equ	H'21'	; delay counter
STORE3			equ	H'22'	; delay counter
STORE4			equ	H'23'	; delay counter	
FREQ			equ	H'24'	; frequency value
TIMER			equ	H'25'	; run timer
WOBBLE			equ	H'26'	; frequency vary
WOBBLE1			equ	H'27'	; frequency value
MODE			equ	H'28'	; low/high frequency mode
CYCLE			equ	H'29'	; cycle counter
DEAD			equ	H'2A'	; dead time counter	
GPIO_VALUE		equ	H'2B'	; GPIO Value for GPIO,5 (LED)
CALRUN			equ	H'2C'	; cal flag
COUNT_DOWN		equ	H'2D'	; cal delay for switch
TEMP			equ	H'2E'	; temporary
STORE			equ	H'2F'	; storage

; preprogram EEPROM DATA 
	
	ORG     H'2100'
	DE		H'00'
	DE		H'AB'		;AJB
	DE		H'03'		;AJB

; start at memory 0

	org		0			; reset vector
	goto	MAIN		; interrupt at 4 not used


MAIN ; set oscillator calibration
	call	DELAYms
	call	DELAYms
	call	DELAYms
	call	DELAYms
; check if new OSCAL value written
	movlw	D'00'
	call	EEPROM_READ
	xorlw	D'00'
	btfss	STATUS,Z	; if zero use factory calibration since EEPROM is not written to via frequency adjustment routine
	goto	EEP_VAL
	bsf		STATUS,RP0	; bank 1
	call	H'3FF'		; oscillator calibration value at 3FF
	movwf	OSCCAL
	movwf	STORE
	bcf		STATUS,RP0	; select memory bank 0
	goto	INIT0
EEP_VAL
	movlw	D'01'
	call	EEPROM_READ
	bsf		STATUS,RP0	; bank 1
	movwf	OSCCAL
	movwf	STORE
	bcf		STATUS,RP0	; select memory bank 0

INIT0
; initial conditions
	clrf	GPIO

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00011100'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'10001101'	; settings (pullups disabled) wdt prescaler/32 (18ms x 32 timeout)
	movwf	OPTION_REG
	bsf		INTCON,INTE	; external interrupt enabled for flag (INTF) detect	
; analog inputs, A/D
	movlw	B'01011000'	; AN3 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00001100'	; channel 3 left justified, VDD ref etc
	movwf	ADCON0


; initial condition
	clrf	MODE		; high frequency standard
	clrf	GPIO_VALUE	; I/O levels stored
	clrf	CALRUN		; cal flag
;	movlw	D'10'
;	movwf	TIMER		; pre-load timer
;	movlw	D'3'
;	movwf	CYCLE		; pre-load cycle
; delay
	call	DELAYms

; if start switch closed at power up, change mode
	btfsc	GPIO,2
	goto	STOP
; switch closed
	incf	MODE,f		; low frequency mode

WAIT_OPEN ; wait for switch open

; blink LED as acknowledgement
; delay ~0.5s
	btfss	GPIO,5
	goto	ON_LED_1
	bcf		GPIO,5		; LED off
	goto	DEL_FLSH
ON_LED_1
	bsf		GPIO,5		; LED on	

DEL_FLSH
	movlw	D'1'		; delay extension
	movwf 	STORE3
DEL_CONTX
	clrwdt
	movlw	H'FF'		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONTX

; wait for switch open
	btfss	GPIO,2
	goto	WAIT_OPEN

; delay ~0.5s
; when open add delay
	movlw	D'4'		; delay extension
	movwf 	STORE3
	bsf		GPIO,2
DEL_CONTY
	clrwdt
	movlw	H'FF'		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONTY

; Wait for start button
STOP
	clrf	GPIO		; mosfets off. LED off
; wait for GPIO,2 to be high
GP2_SET
	btfss	GPIO,2
	goto	GP2_SET 
; debounce
	movlw	D'2'		; delay extension
	movwf 	STORE3
DEL_CONT1
	clrwdt
	movlw	H'FF'		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT1

INIT
; set initial start button interrupt operation

	
SLEEPING
	bcf		INTCON,INTF	; clear interrupt flag	
; waits here for low start signal at GP2 or watchdog timeout
	sleep				; wakes on interrupt or watchdog timeout
	nop
; check interrupt source
	btfsc	INTCON,INTF	; if interrupt flag is high then start switch was pressed
	goto 	START

; LED indication alternate on/off for audible test mode

	btfss	MODE,0
	goto	STANDARD
	btfss	GPIO_VALUE,5
	goto	ON_LED
	bcf		GPIO,5		; LED off
	bcf		GPIO_VALUE,5
	goto	SLEEPING
ON_LED
	bsf		GPIO,5		; LED on
	bsf		GPIO_VALUE,5
	goto	SLEEPING
STANDARD
; flash LED
	bsf		GPIO,5
	movlw	D'5'
	call	DELAYX
	bcf		GPIO,5		; LED off
	goto	SLEEPING

START
; switch debounce
	movlw	H'FF'		; delay routine
	call	DELAYX
	bcf		INTCON,INTF	; clear interrupt flag

; measure timer potentiometer
; channel 2 
; routine to wait for A/D conversion
A_D
	bsf		GPIO,5		; LED on and timer trimpot connected
	bsf		ADCON0,ADON	; A/D on
	call	DELAYms
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	clrwdt
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		STATUS,C
	rrf		ADRESH,F	; divide by 2
	movf	ADRESH,w	; look at timer trimpot value
	addlw	D'1'		; 1 minimum
	movwf	TIMER		; load timer
	bcf		ADCON0,ADON	; A/D off
	movlw	D'00'
	movwf	WOBBLE		; initial frequency
;AJB - Added to make the first activation after power on run for the same time
;as successive activations. CYCLE was uninitialized which resulted in the first
;activation being very long.
	movlw	D'3'
	movwf	CYCLE		; pre-load cycle
;AJB
	goto	SOUND_RUN

TIMER_LOOP
	movlw	D'3'
	movwf	CYCLE		; check timer rate
	decfsz	TIMER,f
	goto	SOUND_RUN
END_CALRUN
	clrf	MODE		; high frequency standard default after timeout 
	goto	STOP		; timeout

SOUND_RUN
LOOP
; check if start switch pressed again to stop sound
	btfss	INTCON,INTF
	goto	ON
	clrf	MODE		; high frequency is standard default after switch off 
	goto	STOP
ON
; next frequency

	decf	WOBBLE,f
; check if decremented past 0 
	movf	WOBBLE,w
	sublw	D'12'
	movlw	D'12'
	btfss	STATUS,C	; if > 12 then set at 12	
	movwf	WOBBLE
	movf	WOBBLE,w

; test of frequency 
; start
;	movlw	D'0'
; test end

	movwf	TEMP
	rlf		TEMP,f
	rlf		TEMP,f
	rlf		TEMP,w
	
	bsf		STATUS,RP0	; bank 1
	addwf	STORE,w
	btfsc	STATUS,C	; if carry leave at FF
	movlw	H'FF'
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0
		
	movlw	D'250'
	movwf	STORE2		; burst length
	call	GENERATOR	; driver
	bcf		GPIO,1
	bcf		GPIO,0
; check if cal. routine
	btfsc	CALRUN,0
	goto	END_CALRUN
	decfsz	CYCLE,f		; next frequency
	goto	LOOP		; cycle through frequencies
	goto	TIMER_LOOP
	

; *********************************************
; subroutines


; 25-30kHz generator (set STORE2 before routine for burst length)	
GENERATOR
	btfsc	MODE,0			; if MODE,0 is clear use ultrasonic tone
	goto	GENERATOR_AUDIBLE
	movlw	H'FF'		; delay routine
	call	DELAYX

; if start switch still low (pressed) use oscillator calibration routine
	btfsc	GPIO,2
	goto	NORMAL_RUN
	movlw	D'20'
	movwf	COUNT_DOWN
LOOP_CAL
	movlw	H'FF'		; delay routine
	call	DELAY_VARY
	btfsc	GPIO,2
	goto	NORMAL_RUN
	decfsz	COUNT_DOWN,F
	goto	LOOP_CAL
	btfsc	GPIO,2		; if still pressed cal.
	goto	LOOP_CAL
	goto	CAL_ROUTINE

NORMAL_RUN
	clrf	CALRUN
; soft start
GEN1Sx
	bsf		GPIO,0			; Q2 on
	bcf		GPIO,0
	clrwdt
	nop
	call	SPACE17	
	bsf		GPIO,1
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE17
GEN1S
	bsf		GPIO,0			; Q2 on
	bcf		GPIO,0
	clrwdt
	call	SPACE17	
	bsf		GPIO,1
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE17
GEN1SR
	bsf		GPIO,0			; Q2 on
	bcf		GPIO,0
	clrwdt
	call	SPACE17	
	bsf		GPIO,1
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE17
GEN2S
	bsf		GPIO,0			; Q2 on
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE16
	bsf		GPIO,1
	nop
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE16
GEN2SR
	bsf		GPIO,0			; Q2 on
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE16
	bsf		GPIO,1
	nop
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE16
GEN3S
	bsf		GPIO,0			; Q2 on
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE15
	bsf		GPIO,1
	nop
	nop
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE15
GEN3SR
	bsf		GPIO,0			; Q2 on
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE15
	bsf		GPIO,1
	nop
	nop
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE15
GEN4S
	bsf		GPIO,0			; Q2 on
	nop
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE14
	bsf		GPIO,1
	nop
	nop
	nop
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE14
GEN4SR
	bsf		GPIO,0			; Q2 on
	nop
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE14
	bsf		GPIO,1
	nop
	nop
	nop
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE14
GEN5S
	bsf		GPIO,0			; Q2 on
	call	SPACE4
	bcf		GPIO,0
	clrwdt
	call	SPACE13
	bsf		GPIO,1
	call	SPACE4
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE13
GEN5SR
	bsf		GPIO,0			; Q2 on
	call	SPACE4
	bcf		GPIO,0
	clrwdt
	call	SPACE13
	bsf		GPIO,1
	call	SPACE4
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE13
GEN6S
	bsf		GPIO,0			; Q2 on
	call	SPACE5
	bcf		GPIO,0
	clrwdt
	call	SPACE12
	bsf		GPIO,1
	call	SPACE5
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE12
GEN6SR
	bsf		GPIO,0			; Q2 on
	call	SPACE5
	bcf		GPIO,0
	clrwdt
	call	SPACE12
	bsf		GPIO,1
	call	SPACE5
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE12
GEN7S
	bsf		GPIO,0			; Q2 on
	call	SPACE6
	bcf		GPIO,0
	clrwdt
	call	SPACE11
	bsf		GPIO,1
	call	SPACE6
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE11
GEN7SR
	bsf		GPIO,0			; Q2 on
	call	SPACE6
	bcf		GPIO,0
	clrwdt
	call	SPACE11
	bsf		GPIO,1
	call	SPACE6
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE11
GEN8S
	bsf		GPIO,0			; Q2 on
	call	SPACE7
	bcf		GPIO,0
	clrwdt
	call	SPACE10
	bsf		GPIO,1
	call	SPACE7
	bcf		GPIO,1			; Q1 off
	clrwdt
	call	SPACE10
GEN8SR
	bsf		GPIO,0			; Q2 on
	call	SPACE7
	bcf		GPIO,0
	clrwdt
	call	SPACE10
	bsf		GPIO,1
	call	SPACE7

GEN0

; 25kHz to 30kHz, 
	bcf		GPIO,1			; Q1 off
; dead time 
	clrwdt
	call	SPACE10
	bsf		GPIO,0			; Q2 on

	call	SPACE4
; end of block restriction
; extra nops
	nop
	nop						; nops required to match (decfsz STORE2,f &	goto GEN0 cycles)
	nop	
	bcf		GPIO,0
; dead time
	clrwdt
	call	SPACE10
	bsf		GPIO,1
	call	SPACE4
	decfsz	STORE2,f		;  burst length
	goto	GEN0


GEN8F
	nop
	bcf		GPIO,1
	clrwdt
	call	SPACE10
	bsf		GPIO,0			; Q2 on
	call	SPACE7
	bcf		GPIO,0
	clrwdt
	call	SPACE10
	bsf		GPIO,1
	call	SPACE7
GEN8FR
	bcf		GPIO,1
	clrwdt
	call	SPACE10
	bsf		GPIO,0			; Q2 on
	call	SPACE7
	bcf		GPIO,0
	clrwdt
	call	SPACE10
	bsf		GPIO,1
	call	SPACE7
GEN7F
	bcf		GPIO,1
	clrwdt
	call	SPACE11
	bsf		GPIO,0			; Q2 on
	call	SPACE6
	bcf		GPIO,0
	clrwdt
	call	SPACE11
	bsf		GPIO,1
	call	SPACE6
GEN7FR
	bcf		GPIO,1
	clrwdt
	call	SPACE11
	bsf		GPIO,0			; Q2 on
	call	SPACE6
	bcf		GPIO,0
	clrwdt
	call	SPACE11
	bsf		GPIO,1
	call	SPACE6
GEN6F
	bcf		GPIO,1
	clrwdt
	call	SPACE12
	bsf		GPIO,0			; Q2 on
	call	SPACE5
	bcf		GPIO,0
	clrwdt
	call	SPACE12
	bsf		GPIO,1
	call	SPACE5
GEN6FR
	bcf		GPIO,1
	clrwdt
	call	SPACE12
	bsf		GPIO,0			; Q2 on
	call	SPACE5
	bcf		GPIO,0
	clrwdt
	call	SPACE12
	bsf		GPIO,1
	call	SPACE5
GEN5F
	bcf		GPIO,1
	clrwdt
	call	SPACE13
	bsf		GPIO,0			; Q2 on
	call	SPACE4
	bcf		GPIO,0
	clrwdt
	call	SPACE13
	bsf		GPIO,1
	call	SPACE4	
GEN5FR
	bcf		GPIO,1
	clrwdt
	call	SPACE13
	bsf		GPIO,0			; Q2 on
	call	SPACE4
	bcf		GPIO,0
	clrwdt
	call	SPACE13
	bsf		GPIO,1
	call	SPACE4	
GEN4F
	bcf		GPIO,1
	clrwdt
	call	SPACE14
	bsf		GPIO,0			; Q2 on
	nop
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE14
	bsf		GPIO,1
	nop
	nop
	nop	
GEN4FR
	bcf		GPIO,1
	clrwdt
	call	SPACE14
	bsf		GPIO,0			; Q2 on
	nop
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE14
	bsf		GPIO,1
	nop
	nop
	nop	
GEN3F
	bcf		GPIO,1
	clrwdt
	call	SPACE15
	bsf		GPIO,0			; Q2 on
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE15
	bsf		GPIO,1
	nop
	nop	
GEN3FR
	bcf		GPIO,1
	clrwdt
	call	SPACE15
	bsf		GPIO,0			; Q2 on
	nop
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE15
	bsf		GPIO,1
	nop
	nop	
GEN2F
	bcf		GPIO,1
	clrwdt
	call	SPACE16
	bsf		GPIO,0			; Q2 on
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE16
	bsf		GPIO,1
	nop	
GEN2FR
	bcf		GPIO,1
	clrwdt
	call	SPACE16
	bsf		GPIO,0			; Q2 on
	nop
	bcf		GPIO,0
	clrwdt
	call	SPACE16
	bsf		GPIO,1
	nop	
GEN1F
	bcf		GPIO,1
	clrwdt
	call	SPACE17
	bsf		GPIO,0			; Q2 on
	bcf		GPIO,0
	clrwdt
	call	SPACE17
	bsf		GPIO,1
GEN1FR
	bcf		GPIO,1
	clrwdt
	call	SPACE17
	bsf		GPIO,0			; Q2 on
	bcf		GPIO,0
	clrwdt
	call	SPACE17
	bsf		GPIO,1
GEN1FRx
	bcf		GPIO,1
	clrwdt
	call	SPACE17
	bsf		GPIO,0			; Q2 on
	bcf		GPIO,0
	clrwdt
	call	SPACE17
	bsf		GPIO,1
;	

	bcf		GPIO,1
	bcf		GPIO,1
	bcf		GPIO,0
	bcf		GPIO,0
	return

;***********************************************************

CAL_ROUTINE
	bsf		CALRUN,0	; set cal flag
; next frequency



	decf	WOBBLE,f
; check if decremented past 0 
	movf	WOBBLE,w
	sublw	D'12'
	movlw	D'12'
	btfss	STATUS,C	; if > 12 then set at 12	
	movwf	WOBBLE
	movf	WOBBLE,w

	movwf	TEMP
	rlf		TEMP,f
	rlf		TEMP,f
	rlf		TEMP,w
	
	bsf		STATUS,RP0	; bank 1
	addwf	STORE,w
	btfsc	STATUS,C	; if carry leave at FF
	movlw	H'FF'
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

	movlw	D'250'
	movwf	STORE2		; burst length

	call	GEN1Sx		; burst

	bsf		GPIO,5		; LED on and timer trimpot connected
	bsf		ADCON0,ADON	; A/D on
	call	DELAYms
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV_1
	clrwdt
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV_1
	bcf		GPIO,5
	movf	ADRESH,w	; look at timer trimpot value
	bsf		STATUS,RP0	; bank 1
	movwf	OSCCAL
	movwf	STORE		; store
	bcf		STATUS,RP0	; select memory bank 0
; write 
; set new OSCCAL flag indicator
	movlw	EEPROM0
	call	EEPROM_READ
	movlw	H'FF'
	call	EEPROM_WRITE
	call	DELAYms
; write OSCCAL value 
	movlw	EEPROM1
	call	EEPROM_READ
	bsf		STATUS,RP0	; bank 1
	movf	OSCCAL,w

	bcf		STATUS,RP0	; select memory bank 0
	call	EEPROM_WRITE
	
	call	DELAY_LONG	

; check switch
	btfsc	GPIO,2		; if low continue
	return
	bsf		GPIO,5		; LED on
	goto	CAL_ROUTINE

	

; ~1.5kHz generator (set STORE2 before routine for burst length)	
GENERATOR_AUDIBLE
	movlw	D'208'
	movwf	STORE2	
; flash LED 
	btfss	GPIO_VALUE,5
	goto	ON_LED2
	bcf		GPIO,5		; LED off
	bcf		GPIO_VALUE,5
	goto	GENERATOR_AUDIBLE1
ON_LED2
	bsf		GPIO,5		; LED on
	bsf		GPIO_VALUE,5

GENERATOR_AUDIBLE1
; dead time

	clrwdt
	movlw	D'100'
	movwf	DEAD
DEAD_LOOP2
	decfsz	DEAD,f
	goto	DEAD_LOOP2	
	bsf		GPIO,1			; Q2 on
	clrwdt
	movlw	D'2'			; pulse width 
	movwf	STORE1
DECA
	decfsz	STORE1,f
	goto	DECA
	bcf		GPIO,1
; dead time

	nop
	nop
	clrwdt
	movlw	D'100'
	movwf	DEAD
DEAD_LOOP3
	decfsz	DEAD,f
	goto	DEAD_LOOP3	
	bsf		GPIO,0			; Q1 on
	clrwdt
	movlw	D'2'			;  pulse width
	movwf	STORE1
DECB
	decfsz	STORE1,f
	goto	DECB
	bcf		GPIO,0			; Q1 off
	decfsz	STORE2,f		;  burst length
	goto	GENERATOR_AUDIBLE1
	bcf		GPIO,0
	bcf		GPIO,1
	bcf		GPIO,0
	bcf		GPIO,1
	return

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE4		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE4,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY_LONG
	movlw	H'5F'		; delay value
DELAY_VARY
	movwf	STORE1		; STORE1 is number of loops value
LOOP10	
	movlw	D'255'
	movwf	STORE4		; STORE2 is internal loop value	
LOOP11
	clrwdt
	decfsz	STORE4,f
	goto	LOOP11
	decfsz	STORE1,f
	goto	LOOP10
	return

; read mode
EEPROM_READ
	bsf 	STATUS,RP0 	; Bank 1
	movwf 	EEADR 		; Address to read
	bsf 	EECON1,RD 	; EE Read
	movf 	EEDATA,w 	; Move data to w
	bcf		STATUS,RP0	; Bank 0
	return

; EEPROM write
EEPROM_WRITE
	bsf 	STATUS,RP0 	; Bank 1
	movwf 	EEDATA		; data
	bsf 	EECON1,WREN ; Enable write
	bcf 	INTCON,GIE 	; Disable Interrupts
	movlw 	H'55'		; Unlock write
	movwf 	EECON2 		;
	movlw 	H'AA' 		;
	movwf 	EECON2 ;
	bsf 	EECON1,WR 	; Start the write
	bcf		STATUS,RP0	; Bank 0
	return	

SPACE18
	nop
SPACE17
	nop
SPACE16
	nop
SPACE15
	nop
SPACE14
	nop
SPACE13
	nop
SPACE12
	nop
SPACE11
	nop
SPACE10
	nop
SPACE9
	nop
SPACE8
	nop
SPACE7
	nop
SPACE6
	nop
SPACE5
	nop
SPACE4
	return

	end
