; Bellbird

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

EEPROM1		equ	H'00'	; non-volatile storage for tone

; Bank 0 RAM

COUNTER1	equ	H'20'	; delay counter
STORE1		equ	H'21'	; delay counter
STORE2		equ	H'22'	; delay counter
RAMP		equ	H'23'	; ramp up/dn rate	
LIMIT		equ	H'24'	; ramp up/dn limit
STORE		equ	H'25'	; storage
PWM_STORE	equ	H'26'	; storage of PWM
EXTENT		equ	H'27'	; PWM modulation period
MOD			equ	H'28'	; modulation counter
LOOP		equ	H'29'	; cycle loop
EXTENT_VAL	equ	H'2A'	; extent store
LOOP_COUNT	equ	H'2B'	; lookup table counter (start pointer)	
LOOKEND		equ	H'2C'	; lookup table (end pointer)
TEMPZ		equ H'2D'	; temporary
RAMP_STO	equ	H'2E'	; storage
TEMPA		equ	H'2F'	; temp	
TEMPB		equ	H'30'	; temp
DEL1		equ	H'31'	; delay extn
REPEAT		equ	H'32'	; bell repeat
MEASURED	equ	H'33'	; A/D measured value
LEDS_CNTR	equ	H'34'	; LED counter
CHANGED		equ	H'35'	; OSCTUNE changed flag
STORE_Z		equ	H'36'	; store
BELL_FREQ	equ	H'37'	; frequency of bell (variable with random generator)
BELL_FREQ1	equ	H'38'	; bell frequency base value
COUNTER_STO	equ	H'39'	; restore value for counter1 value

; random number generator registers
BARGB0		equ	H'5D'	; random number generator
BARGB1		equ	H'5E'	; random number generator
BARGB2		equ	H'5F'	; random number generator
AARGB0		equ	H'60'	; random number gen
AARGB1		equ	H'61'	; random number gen
AARGB2		equ	H'62'	; random number gen
AARGB3		equ	H'63'	; random number gen
AARGB4		equ	H'64'	; random number gen
AARGB5		equ	H'65'	; random number gen
AARGB6		equ	H'66'	; random number gen
RANDB0		equ	H'67'	; random number seed
RANDB1		equ	H'68'	; random number seed
RANDB2		equ	H'69'	; random number seed
RANDB3		equ	H'6A'	; random number seed
TEMPB0		equ	H'6B'	; random gen temp files
TEMPB1		equ	H'6C'	; random gen temp files
TEMPB2		equ	H'6D'	; random gen temp files
TEMPB3		equ	H'6E'	; random gen temp files
LOOPCOUNT	equ	H'6F'	; loop counter in random gen

; all banks RAM
SAVE		equ	H'70'	; OSCTUNE counter
STATUS_TMP	equ H'71'	; temp storage for status during interrupt
W_TMP		equ	H'72'	; temporary storage for w during interrupt
LONG_PERIOD	equ	H'73'	; long period gap timer

; preset EEPROM
	ORG     2100	
 
	DE	H'00'	; initially set

	org	0
	goto	SETUP
	nop
	nop
	nop	
	org	4		; interrupt vector

; ..............................................................	
;interrupt starts here
	btfss	INTCON,INTF	; is flag cleared
	goto	SAVE_I
	bcf		INTCON,INTF	; flag cleared
	retfie
SAVE_I
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 

	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1	; select bank 0
	bcf		PIR1,TMR1IF	; timer1 flag 
	
	movlw	D'127'
	movwf	TMR1H		; preset timer 1
; LEDs off
	movlw	H'FF'
	movwf	PORTB
	movwf	PORTA
; drive LEDs
DRV1
	movf	LEDS_CNTR,w
	xorlw	D'0'
	btfsc	STATUS,Z
	bcf		PORTB,6		; LED1

DRV2
	movf	LEDS_CNTR,w
	xorlw	D'1'
	btfsc	STATUS,Z
	bcf		PORTB,7		; LED2

DRV3
	movf	LEDS_CNTR,w
	xorlw	D'2'
	btfsc	STATUS,Z
	bcf		PORTA,7		; LED3

DRV4
	movf	LEDS_CNTR,w
	xorlw	D'3'
	btfsc	STATUS,Z
	bcf		PORTA,6		; LED4

DRV5
	movf	LEDS_CNTR,w
	xorlw	D'4'
	btfsc	STATUS,Z
	bcf		PORTA,3		; LED5

DRV6
	movf	LEDS_CNTR,w
	xorlw	D'5'
	btfsc	STATUS,Z
	bcf		PORTB,1		; LED6

DRV7
	movf	LEDS_CNTR,w
	xorlw	D'6'
	btfsc	STATUS,Z
	bcf		PORTB,2		; LED7

DRV6_R
	movf	LEDS_CNTR,w
	xorlw	D'7'
	btfsc	STATUS,Z
	bcf		PORTB,1		; LED6

DRV5_R
	movf	LEDS_CNTR,w
	xorlw	D'8'
	btfsc	STATUS,Z
	bcf		PORTA,3		; LED5
DRV6_F
	movf	LEDS_CNTR,w
	xorlw	D'9'
	btfsc	STATUS,Z
	bcf		PORTB,1		; LED6

DRV7_F
	movf	LEDS_CNTR,w
	xorlw	D'10'
	btfsc	STATUS,Z
	bcf		PORTB,2		; LED7


DRV_OFF
	movf	LEDS_CNTR,w
	xorlw	D'11'
	btfss	STATUS,Z
	goto	INT_END

; stop timer 1
	bcf		T1CON,0
; clear LEDs
	movlw	H'FF'
	movwf	PORTB
	movwf	PORTA
INT_END
	incf	LEDS_CNTR,f	; next LEDs
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt	
; end of interrupt
; ...............................................................
	
; lookup tables
BELL1
	addwf	PCL,f		; first byte byte is period, second byte is level (PWM)	
	retlw	D'3'		; ms period
	retlw	D'35'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'44'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'40'		; PWM duty (88=50%)
	retlw	D'4'		; ms period
	retlw	D'30'		; PWM duty (88=50%)
	retlw	D'4'		; ms period
	retlw	D'35'		; PWM duty (88=50%)
	retlw	D'3'		; ms period
	retlw	D'30'		; PWM duty (88=50%)
	retlw	D'4'		; ms period
	retlw	D'35'		; PWM duty (88=50%)
	retlw	D'6'		; ms period
	retlw	D'30'		; PWM duty (88=50%)
	retlw	D'7'		; ms period
	retlw	D'35'		; PWM duty (88=50%)
	retlw	D'4'		; ms period
	retlw	D'30'		; PWM duty (88=50%)
	retlw	D'8'		; ms period
	retlw	D'35'		; PWM duty (88=50%)
	retlw	D'6'		; ms period
	retlw	D'30'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'35'		; PWM duty (88=50%)
	retlw	D'7'		; ms period
	retlw	D'30'		; PWM duty (88=50%)
	retlw	D'7'		; ms period
	retlw	D'35'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'30'		; PWM duty (88=50%) Count 31
; lower level from 32 onward	
	retlw	D'5'		; ms period			Count 32
	retlw	D'3'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'1'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'3'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'1'		; PWM duty (88=50%)
	retlw	D'12'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'4'		; PWM duty (88=50%)
	retlw	D'3'		; ms period
	retlw	D'6'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'6'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'4'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'6'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'3'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'4'		; PWM duty (88=50%)
	retlw	D'3'		; ms period
	retlw	D'1'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'4'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'1'		; PWM duty (88=50%)  Count 63
	retlw	D'6'		; ms period			Count 64
	retlw	D'6'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'2'		; PWM duty (88=50%)
	retlw	D'10'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'3'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'11'		; ms period
	retlw	D'4'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'3'		; PWM duty (88=50%)
	retlw	D'8'		; ms period
	retlw	D'6'		; PWM duty (88=50%)
	retlw	D'10'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'4'		; ms period
	retlw	D'6'		; PWM duty (88=50%)
	retlw	D'40'		; ms period
	retlw	D'4'		; PWM duty (88=50%)
	retlw	D'7'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'2'		; PWM duty (88=50%)
	retlw	D'7'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'2'		; ms period
	retlw	D'2'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'5'		; PWM duty (88=50%)
	retlw	D'5'		; ms period
	retlw	D'2'		; PWM duty (88=50%)
	retlw	D'15'		; ms period
	retlw	D'1'		; PWM duty (88=50%)
	retlw	D'11'		; ms period
	retlw	D'5'		; PWM duty (88=50%) Count 99

SETUP
	movlw	H'FF'		; set all outputs high
	movwf	PORTA
	movwf	PORTB

; set inputs/outputs
	
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00010001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'11000000'	; 
	movwf	OPTION_REG	; pullups disabled and interupt on rising edge for RB0
	movlw   B'00110000'	; I/O 
	movwf   TRISA		; port A data direction register
; analog inputs, A/D
	movlw	B'00000000'	; AN3 analog input later
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00100000'	; Fosc, channel4  etc
	movwf	ADCON0
; oscillator
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01010000'	; for 2MHz
	movwf	OSCCON		; osc
; interrupt
	bcf		INTCON,GIE	; interrupts disabled
	bcf		INTCON,INTF	; flag cleared
	bsf		INTCON,INTE	; RBO interrupt only
; pwm set
	movlw	H'B0'		; D176
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	clrf	CCPR1L		; ms byte of PWM
	movlw	B'00000000'
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation

; Timer1
	bcf		PIR1,TMR1IF	; timer1 flag 
	bsf		STATUS,RP0	; select memory bank 1	
	bsf		PIE1,TMR1IE	; timer 1 interrupt enable
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000000'	; timer1 settings
	movwf	T1CON
	bsf		INTCON,PEIE	; peripheral interrupts 
	bsf		INTCON,GIE	; global interrupts enabled

; set initial bell frequency
	movlw	H'B4'
	movwf	BELL_FREQ	; bell frequency
	movwf	BELL_FREQ1	; base value

; set initial seed value
	movlw	0x27		; random seed value
	movwf	RANDB0
	movlw	0xF1
	movwf	RANDB1
	movlw	0x20		; random seed value
	movwf	RANDB2
	movlw	0x49
	movwf	RANDB3
	call	RAND32			; random number generator (1ms subroutine at 2MHz osc (500kHz clock))
; random integer in AARGB0, AARGB1, AARGB2, AARGB3

	clrf	CHANGED			; osctune changed flag
; get EEPROM saved OSCTUNE value	
	clrf	SAVE
	movlw	EEPROM1
	call	EEREAD
	movwf	SAVE
	bsf		STATUS,RP0		; select memory bank 1
	movwf	OSCTUNE
	bcf		STATUS,RP0		; select memory bank 0

; check if S2 pressed for default
	movlw	D'200'
	call	DELAYZ			; 200ms
	btfsc	PORTB,4
	goto	LED_BRIGHT
	clrf	SAVE
	clrw
	call	EEWRITE			; set for default
	clrf	CHANGED
WAIT_OPEN2
	movlw	D'200'
	call	DELAYZ			; 200ms	
	btfss	PORTB,4
	goto	WAIT_OPEN2
	movlw	D'200'
	call	DELAYZ			; 200ms	

LED_BRIGHT
; set LED brightness
; analog inputs, A/D
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00010000'	;  AN4 analog input 
	movwf	ANSEL

; set LED on via RA1 
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output

	movlw   B'00110101'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTB,6		; LED1,8 on

; measure voltage 
	call	ACQUIRE_AD	; get voltage across resistor
	movwf	MEASURED	; A/D value
	comf	MEASURED,f	; reverse sense
	bsf		PORTB,6		; LED1,8 off

; low value means a low battery/cell voltage
; typically the reading is 1V for a 3V cell with 2V across LED, 1V across 240 ohm resistor

; set outputs
; all 4-outputs high (when set as an input, no current is sourced)
	bsf		PORTA,1		; 0 output
	bsf		PORTA,0		; 1 output
	bsf		PORTA,2		; 2 output
	bsf		PORTB,5		; 3 output	
; check readings

	movlw	D'27'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	A_CURRENT	; 0,1,2,3 resistors on			

	movlw	D'29'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	B_CURRENT	; 2,3 resistors on			

	movlw	D'31'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	C_CURRENT	; 0,3 resistors on

	movlw	D'36'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	D_CURRENT	; 0,1,2 resistors on

	movlw	D'43'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	E_CURRENT	; 1,2 resistors on

	movlw	D'50'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	F_CURRENT	; 0,2 resistors on
	
	movlw	D'57'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	G_CURRENT	; 2 resistor on

	movlw	D'78'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	H_CURRENT	; 0,1 resistors on

	movlw	D'100'
	subwf	MEASURED,w
	btfss	STATUS,C
	goto	I_CURRENT	; 1 resistor on

	goto	J_CURRENT	; 0 resistor on

; table for A/D reading versus resistance and outputs on
;A/D reading. R ohms. 	OUT. 	Cell V (LED=1.8V)
;J 104			470		0		>3.3
;I 91         	240  	1    	3.0
;H 73			160		0,1		2.6
;G 57			120		2		2.4
;F 50			96		0,2		2.3
;E 43			80		1,2		2.2
;D 36			68		0,1,2	2.1
;C 31			53		0,3		2.05
;B 29			40		2,3		2.0
;A 27			32		0,1,2,3	1.96

;Resistors (OUT). Paralleled resistors give other values
; 0= 470 ohms
; 1= 240 ohms
; 2= 120 ohms
; 3= 62 ohms

A_CURRENT ;(0,1,2,3 outputs)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110000'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00010001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP
	
B_CURRENT ;(2,3 outputs)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110011'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00010001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP

C_CURRENT ;(0,3 outputs)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110101'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00010001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP

D_CURRENT ;(0,1,2 outputs)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110000'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank c
 	goto	NORMAL_OP

E_CURRENT ;(1,2 outputs)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110010'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP

F_CURRENT ;(0,2 outputs)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110001'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP

G_CURRENT ;(2 output)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110011'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP

H_CURRENT ;(0,1 outputs)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110100'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP

I_CURRENT ;(1 output)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110110'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	goto	NORMAL_OP

J_CURRENT ;(0 output)
; set input/outputs for RA1=0 output, RA0=1 output, RA2=2 output, RB5= 3 output
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00110101'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'00110001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

; ********************************************************************
 
NORMAL_OP ;Normal Operation

; check LDR
; check LDR for light/darkness
CK_LDR

	btfsc	PORTB,0			; if low then stop (LDR in darkness)
	goto 	S2_P

STOP
	bcf		T1CON,0
	bcf		PIR1,TMR1IF		; timer1 flag	
	movlw	H'FF'
	movwf	PORTA			; LEDs off
	movwf	PORTB
	bcf		INTCON,INTF		; flag cleared
; SLEEP, low power mode
	bcf		INTCON,GIE		; global interrupts disabled
	sleep					; stop operations
; awakes with RB0 high
	nop

	bcf		INTCON,INTF		; flag cleared
	bsf		INTCON,GIE		; global interrupts enabled

	goto	LED_BRIGHT		; recheck cell voltage

; is S2 pressed?
S2_P
	btfsc	PORTB,4			; if pressed then change OSCTUNE
	goto	WRITE_EEPROM
	bsf		CHANGED,0
	bsf		STATUS,RP0		; select memory bank 1
	movlw	D'1'
	addwf	SAVE,f			; oscillator frequency
	movf	SAVE,w
	movwf	OSCTUNE
	bcf		STATUS,RP0		; select memory bank 0
	goto	BELL
WRITE_EEPROM
; write to EEPROM
	btfss	CHANGED,0		; when set rewrite to EEPROM
	goto	NO2
	movf	SAVE,w
	call	EEWRITE
	clrf	CHANGED
	
; >>>>>>>>>>>>>>>>>>
BELL
; BELL1 sounds during frequency adjustments
; ramp up
	movlw	D'00'		; PWM start value
	movwf	CCPR1L

; rampup step/rate (1-16)
	movlw	D'1'
	movwf	RAMP

; rampup limit
	movlw	D'88'
	movwf	LIMIT		; PWM limit (88 is 50% duty)
	call	RAMP_UP		; increase 
	
	movlw	D'10'		; ms
	call	DELAYZ

	movf	BELL_FREQ1,w; base bell frequency (B0=2.8kHz)
	call	FREQ_SET	; set frequency

; uses lookup table with ls byte having period and ms byte having level	
	movlw	D'32'
	movwf	LOOKEND		; end of lookup table
	clrf	LOOP_COUNT	; start at 0
	call	LOOP_BELL1
; ramp down
	movlw	D'1'
	movwf	RAMP		; ramp down step
	movlw	D'2'
	movwf	LIMIT
	movlw	D'45'		; 75 is 3 cycles
	movwf	RAMP_STO
	call	RAMP_DN_ADD_DELAY

	movlw	D'2'
	addwf	BELL_FREQ1,w; frequency step	; B0=2.8kHz
	call	FREQ_SET	; set frequency

	movlw	D'50'		; ms
	call	DELAYZ

	btfsc	PORTB,4			; if pressed 
	goto	NO2
	movlw	D'10'
	movwf	COUNTER1
	movlw	H'00'
	movwf	CCPR1L
	movlw	B'00001100'	; set PWM mode and ls bits
	movwf	CCP1CON		; PWM 
EXTRA_LOOPA
	movlw	D'50'
	call	DELAYZ
	decfsz	COUNTER1,f
	goto	EXTRA_LOOPA

	goto	NORMAL_OP
	
; >>>>>>>>>>>>>>>>>>

; normal Bellbird running

NO2	movf	BELL_FREQ,w	; B0=2.8kHz
	call	FREQ_SET	; set frequency

; start timer 1
	clrf	LEDS_CNTR	; start at LED1/8
	movlw	D'127'
	movwf	TMR1H		; preset timer 1
	movlw	B'00000001'	; timer1 settings
	movwf	T1CON

; BELL1 sounds
; ramp up
	movlw	D'00'		; PWM start value
	movwf	CCPR1L

; rampup step/rate (1-5)

; set range from 1 to 5 
	movf	AARGB1,w	; random value
	andlw	B'00000111'	; 0-8 range
	movwf	STORE_Z
	sublw	D'5'
	movf	STORE_Z,w	; original value in w
	btfss	STATUS,C	; if negative (STORE_Z > 5 set at 5)	
	movlw	D'5'		; replace w with a 5 if C=0
	movwf	STORE_Z

	movf	STORE_Z,w
	addlw	D'1'		; minimum of 1
	movwf	RAMP		; 

; rampup limit
	movlw	D'80'
	movwf	LIMIT		; PWM upper limit (88 is 50% duty)

; set repeats
	clrf	REPEAT		; repeat bell flag  
	movlw	D'40'
	subwf	AARGB1,w
	btfss	STATUS,C
	bsf		REPEAT,0	; repeat 2x when <40

	movlw	D'245'
	subwf	AARGB1,w
	btfsc	STATUS,C
	bsf		REPEAT,0	; repeat 2x when >245

; volume set by AARGB3 bits 0, 2 & 5 
VOL
	btfss	AARGB3,0
	goto	BY_RED0
; divide by 2
	bcf		STATUS,C
	rrf		LIMIT,f
BY_RED0
	btfss	AARGB3,5
	goto	BY_RED1
; divide by 2
	bcf		STATUS,C
	rrf		LIMIT,f
; divide by 2
	bcf		STATUS,C
	rrf		LIMIT,f
BY_RED1
	btfss	AARGB3,2
	goto	BY_RED2
; divide by 2 (extra dynamic range) (change at LOOP_BELL1 too)
	bcf		STATUS,C
	rrf		LIMIT,f
BY_RED2
	call	RAMP_UP		; increase PWM to limit
	
	movf	AARGB3,w
	andlw	B'00001111'
	addlw	D'1'		; minimum of 1
	call	DELAYZ

	incf	BELL_FREQ,w	; next bell frequency	
	call	FREQ_SET	; set frequency

; Continuance of bell sound
; uses lookup table with ls byte having period and ms byte having level	
	movlw	D'19'		; 
	movwf	LOOKEND		; end of lookup table
	clrf	LOOP_COUNT	; start at 0
	call	LOOP_BELL1

	btfsc	REPEAT,0	; if repeat bit is set, provide a short continuance
	goto	BY1
	btfss	AARGB1,1
	goto	BY2

	movlw	H'1'
	btfsc	AARGB3,0	; change addition value with bit 0	
	movlw	H'2'
	btfsc	AARGB3,5	; change addition value with bit 5	
	movlw	H'2'
	
	addwf	BELL_FREQ,w	; frequency step
	call	FREQ_SET	; set frequency

	movlw	D'14'
	movwf	LOOP_COUNT	; start at 
	movlw	D'31'
	movwf	LOOKEND		; end of lookup table
	call	LOOP_BELL1
	goto 	BY1
BY2
	movlw	H'1'
	btfsc	AARGB3,0	; change addition value with bit 0	
	movlw	H'2'
	btfsc	AARGB3,5	; change addition value with bit 5	
	movlw	H'2'
	addwf	BELL_FREQ,w	; frequency step
	call	FREQ_SET	; set frequency

	movlw	D'6'
	movwf	LOOP_COUNT	; start at 
	movlw	D'21'
	movwf	LOOKEND		; end of lookup table
	call	LOOP_BELL1
BY1

; ramp down (ringing effect)
RAMPx
	movf	REPEAT,w
	btfsc	STATUS,Z
	goto	VALUES1		; REPEAT=0
	movlw	D'2'
	movwf	RAMP		; ramp down step
	movlw	D'1'
	movwf	LIMIT

; random decay rate

; set range from 30 to 75 (30 is over 6-cycles)
	movf	AARGB0,w	; random value
	andlw	B'00111111'	; 0-64 range
	addlw	D'20'		; add 20 for 20-84 range in value (better than using 0-256)
	movwf	STORE_Z

	sublw	D'75'
	movf	STORE_Z,w	; original value
	btfss	STATUS,C	; if negative (AARGB0 > 75 set at 75)	
	movlw	D'75'
	movwf	STORE_Z

	movf	STORE_Z,w
	sublw	D'30'
	movf	STORE_Z,w
	btfsc	STATUS,C	; if positive (STORE_Z <30) set at 30)
	movlw	D'30'

	movwf	RAMP_STO	; 52 is average

	goto	VALUES_IN

VALUES1

	movlw	D'2'
	movwf	RAMP		; ramp down step
	movlw	D'1'
	movwf	LIMIT		; limit that PWM reduces to (ms bits only)

; set range from 100 to 200 (150 is over 30-cycles)
	movf	AARGB0,w	; random value
	andlw	B'01111111'	; 0-127
	addlw	D'90'		; 90 to 217
	movwf	STORE_Z
	
	sublw	D'200'
	movf	STORE_Z,w
	btfss	STATUS,C	; if negative (STORE_Z >200 set at 200	
	movlw	D'200'
	movwf	STORE_Z

	movf	STORE_Z,w
	sublw	D'100'
	movf	STORE_Z,w
	btfsc	STATUS,C	; if positive (STORE_Z < 100) set at 100
	movlw	D'100'

	movwf	RAMP_STO	; 150 is average

VALUES_IN ; values are set for Ramp, Limit & Ramp Store
	call	RAMP_DN_ADD_DELAY

	movlw	H'2'
	btfsc	AARGB3,0	; change addition value with bit 0	
	movlw	H'3'
	btfsc	AARGB3,5	; change addition value with bit 5	
	movlw	H'3'
	addwf	BELL_FREQ,w	; 2/3 steps in frequency (stays at 2 steps with max volume)
	call	FREQ_SET	; set frequency

	movf	AARGB0,w
	iorlw	B'00010000'	; minimum of 32
	andlw	B'01111111' ; max of 127
	movlw	D'100'		; ms
	call	DELAYZ

; repeat

	movf	REPEAT,w
	btfsc	STATUS,Z
	goto	CONT1		; REPEAT=0
	clrf	REPEAT
	bsf		AARGB3,5	; ensure it is not maximum volume on second bell	

	movf	AARGB2,w
	andlw	B'00000011'	; 4 variations
	addwf	BELL_FREQ1,w; add to base frequency
	movwf	BELL_FREQ
	call	FREQ_SET	; set frequency

	movf	AARGB2,w	; delay in ms between two bells
	andlw	B'01111111'
	addlw	D'10'		; minimum of 10
	call	DELAYZ

	call	RANDOM		; redetermine randomised values
; rampup limit
	movlw	D'80'
	movwf	LIMIT		; PWM upper limit (88 is 50% duty)
	goto	VOL			; run repeat of bell 

CONT1
	movlw	H'2'
	btfsc	AARGB3,0	; change addition value with bit 0	
	movlw	H'3'
	btfsc	AARGB3,5	; change addition value with bit 5	
	movlw	H'3'
	addwf	BELL_FREQ,w	; 2/3 steps in frequency (stays at 2 steps with max volume)	
	call	FREQ_SET	; set frequency

; uses lookup table with ls byte having period and ms byte having level	
	movlw	D'32'
	movwf	LOOP_COUNT	; start at 32

; set range from 74 -88
	movf	AARGB2,w
	andlw	B'00001111'	; 0-15
	addlw	D'74'		; 74-89
	movwf	STORE_Z

	sublw	D'88'
	movf	STORE_Z,w
	btfss	STATUS,C	; if negative (STORE_Z > 88 set at 88	
	movlw	D'88'
	movwf	STORE_Z

	movf	STORE_Z,w
	sublw	D'74'
	movf	STORE_Z,w
	btfsc	STATUS,C	; if positive (STORE_Z <74) set at 74
	movlw	D'74'
	movwf	STORE_Z
	
	movf	STORE_Z,w
	movwf	LOOKEND		; end of lookup table
	call	LOOP_BELL1

	call	RANDOM		; random number generator

; randomly readjust frequency for bell
	
	movf	AARGB0,w
	andlw	B'00000011'	; 4 variations (0,1,2,3)
	addwf	BELL_FREQ1,w; add to base frequency
	movwf	BELL_FREQ

	goto	BLANK

; ****************************************************************************

LOOP_BELL1

	movf	LOOP_COUNT,w
	call	BELL1		; get delay value from lookup table
	movwf	STORE
	incf	LOOP_COUNT,f
	movf	LOOP_COUNT,w
	call	BELL1		; get level value from lookup table
	movwf	TEMPA
; volume

; ls bits
	clrf	TEMPB

	btfss	AARGB3,0
	goto	BY_RED0X
; reduce volume by 2
	bcf		STATUS,C
	rrf		TEMPA,f
	rrf		TEMPB,f
BY_RED0X
	btfss	AARGB3,5
	goto	BY_RED1X
; reduce volume by 2
	bcf		STATUS,C
	rrf		TEMPA,f
	rrf		TEMPB,f
	bcf		STATUS,C
	rrf		TEMPA,f
	rrf		TEMPB,f
BY_RED1X
	btfss	AARGB3,2
	goto	BY_RED2X
; reduce volume by 2 (extra dynamic range) (change at 'VOL' too)
	bcf		STATUS,C
	rrf		TEMPA,f
	rrf		TEMPB,f
BY_RED2X
; move bits from 7,6 to 5,4 (ls bit locations for PWM)
	bcf		STATUS,C
	rrf		TEMPB,f
	bcf		STATUS,C
	rrf		TEMPB,f
	movf	TEMPB,w		; ls bits
	andlw	B'00110000'
	iorlw	B'00001100'	; ensure bits 2 & 3 are set 
	movwf	CCP1CON	
	movf	TEMPA,w		; ms 8-bits
	movwf	CCPR1L		; level data to PWM

; delay value 1=1ms
	movf	STORE,w		; delay value
	call	DELAYZ		; delay	

; next values
	incf	LOOP_COUNT,f
	movf	LOOP_COUNT,w
	subwf	LOOKEND,w		; end of table
	btfsc	STATUS,Z
	return
	btfsc	STATUS,C
	goto	LOOP_BELL1
	return

; ********************************************************************

; off period
BLANK

; clear LEDs
	movlw	H'FF'
	movwf	PORTA
	movwf	PORTB
; Set timeout 

; long break if =0
	movlw	D'0'
	xorwf	AARGB2,w
	btfss	STATUS,Z
	goto	TEST_VALUE1
	movlw	D'5'		; set longer period timer
	movwf	LONG_PERIOD
	movlw	D'255'		; longer break when = 0
	goto	NON_STANDARD
TEST_VALUE1
; long break if =82
	movlw	D'82'
	xorwf	AARGB2,w
	btfss	STATUS,Z
	goto	TEST_VALUE2
	movlw	D'5'		; set longer period timer
	movwf	LONG_PERIOD
	movlw	D'155'		; longer break when = 82
	goto	NON_STANDARD
TEST_VALUE2
; long break if =81
	movlw	D'81'
	xorwf	AARGB2,w
	btfss	STATUS,Z
	goto	TEST_STANDARD
	movlw	D'5'		; set longer period timer
	movwf	LONG_PERIOD
	movlw	D'200'		; longer break when = 81
	goto	NON_STANDARD

TEST_STANDARD
; longer than standard break if <10
	movlw	D'10'
	subwf	AARGB2,w	; compare with 10
	btfsc	STATUS,C
	goto	STANDARD
	movlw	D'1'		; set longer period timer
	movwf	LONG_PERIOD
	movlw	D'20'		; longer break when < 10
	goto	NON_STANDARD
STANDARD
	movlw	D'1'		; set longer period timer
	movwf	LONG_PERIOD
	movlw	D'5'		; standard length
NON_STANDARD
; clear PWM
	movwf	COUNTER1
	movwf	COUNTER_STO
	movlw	H'00'
	movwf	CCPR1L
	movlw	B'00001100'	; set PWM mode and ls bits
	movwf	CCP1CON		; PWM 

EXTRA_LOOP
; check S2
	btfss	PORTB,4
; if low then goto NORMAL_OP so as to run tone changes routine
	goto	NORMAL_OP	; break out of delay if S2 pressed

; swap random bytes
	movf	AARGB3,w
	btfss	AARGB4,2
	movf	AARGB0,w	; variations in period
	btfss	AARGB5,6
	swapf	AARGB2,w

	iorlw	B'00000001'	; minimum set 
	andlw	B'01111001' ; maximum set
	call	DELAYZ
	decfsz	COUNTER1,f
	goto	EXTRA_LOOP
; extra length
	movf	LONG_PERIOD,w
	btfsc	STATUS,Z
	goto	NORMAL_OP	; end of time period if zero
	decfsz	LONG_PERIOD,f
	goto	LONGR		
	goto	NORMAL_OP	; end of time period if 0
LONGR
	movf	COUNTER_STO,w	; restore counter value
	movwf	COUNTER1
	goto	EXTRA_LOOP
	
; ****************************************************

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,ADON	; A/D on
	movlw	D'50'
	call	DELAY2
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		ADCON0,ADON	; A/D off
	movf	ADRESH,w
	return

DELAY1
	movlw	D'5'
DELAY2
	movwf	STORE1
LOOP2
	movlw	D'30'
	movwf	STORE2
LOOP1
	decfsz	STORE2,f
	goto	LOOP1
	decfsz	STORE1,f
	goto	LOOP2
	return


DELAYX
	movwf	STORE1
LOOPX2
	decfsz	STORE1,f
	goto	LOOPX2
	return

DELAYZ
	movwf	STORE1		; delay value 1=1ms
LOOPZ2
	movlw	D'164'
	movwf	STORE2
LOOPZ1
	decfsz	STORE2,f
	goto	LOOPZ1
	decfsz	STORE1,f
	goto	LOOPZ2
	return

; PWM ramp up
RAMP_UP

; ramp up
	movlw	D'25'		; 1 cycle
	call	DELAYX
	movf	RAMP,w		; ramp rate
	addwf	CCPR1L,w
	movwf	STORE
	subwf	LIMIT,w		; ramp up limit
	btfss	STATUS,C
	goto	SET_LIM_UP
	movf	STORE,w
	movwf	CCPR1L
		
SET_LIM_UP
	movf	LIMIT,w
	movwf	CCPR1L
	return

RAMP_DN
RAMP_DN_ADD_DELAY
	movlw	D'3'	;
	movwf	DEL1
R_D	movf	RAMP_STO,w		; 75=3 cycles
	call	DELAYX
	decfsz	DEL1,f
	goto	R_D

; check if zero
	movf	CCPR1L,w
	btfsc	STATUS,Z
	goto	SET_LIM_DN
	movf	RAMP,w		; ramp rate
	subwf	CCPR1L,w
	movwf	STORE
; check if negative
	btfss	STATUS,C
	goto	SET_LIM_DN
	movf	STORE,w
	subwf	LIMIT,w		; ramp down limit
	btfsc	STATUS,C	; if negative then change CCPR1L value
	goto	SET_LIM_DN
	movf	STORE,w
	movwf	CCPR1L
	goto	RAMP_DN
SET_LIM_DN
	movf	LIMIT,w
	movwf	CCPR1L
	return

FREQ_SET
	bsf		STATUS,RP0	; select memory bank 1
; w = H'B0'=2.8kHz
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; select memory bank 0
	return

; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register

	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 


; Random number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	Use:	CALL	RAND32

;	Output:	32 bit random integer in AARGB0, AARGB1, AARGB2, AARGB3

;	Result:	AARG  <--  RAND32( AARG )

;	

;		min	max	mean
;	Timing:	487	487	487	clks



;	Linear congruential random number generator

;		X <- (a * X + c) mod m

;	The calculation is performed exactly, with multiplier a, increment c, and
;	modulus m, selected to achieve high ratings from standard spectral tests.
RANDOM
RAND32
		MOVF		RANDB0,W
		MOVWF		AARGB0
		MOVF		RANDB1,W
		MOVWF		AARGB1
		MOVF		RANDB2,W
		MOVWF		AARGB2
		MOVF		RANDB3,W
		MOVWF		AARGB3

		MOVLW		0x0D			; multiplier a = 1664525
		MOVWF		BARGB2
		MOVLW		0x66
		MOVWF		BARGB1
		MOVLW		0x19
		MOVWF		BARGB0

		CALL		FXM3224U

        INCF        AARGB6,F		; c = 1
        BTFSC       STATUS,Z
        INCF        AARGB5,F
		BTFSC		STATUS,Z
		INCF		AARGB4,F
		BTFSC		STATUS,Z
		INCF		AARGB3,F
		BTFSC       STATUS,Z
        INCF        AARGB2,F
		BTFSC		STATUS,Z
		INCF		AARGB1,F
		BTFSC		STATUS,Z
		INCF		AARGB0,F

		MOVF		AARGB3,W
		MOVWF		RANDB0			; m = 2**32
		MOVF		AARGB4,W
		MOVWF		RANDB1
		MOVF		AARGB5,W
		MOVWF		RANDB2
		MOVF		AARGB6,W
		MOVWF		RANDB3

		RETURN

;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
                CLRF    AARGB4          ; clear partial product
                CLRF    AARGB5
                CLRF    AARGB6
                MOVF  	AARGB0,W
                MOVWF   TEMPB0
                MOVF   	AARGB1,W
                MOVWF   TEMPB1
                MOVF   	AARGB2,W
                MOVWF   TEMPB2
                MOVF   	AARGB3,W
                MOVWF   TEMPB3

                CALL 	UMUL3224L

                RETURN

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L       MOVLW   0x08
                MOVWF   LOOPCOUNT

LOOPUM3224A
                RRF     BARGB2,F
                BTFSC   STATUS,C
                GOTO    ALUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224A

                MOVWF   LOOPCOUNT

LOOPUM3224B
                RRF     BARGB1,F
                BTFSC   STATUS,C
                GOTO    BLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224B

                MOVWF   LOOPCOUNT

LOOPUM3224C
                RRF     BARGB0,F
                BTFSC   STATUS,C
                GOTO    CLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224C

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                CLRF    AARGB3
                RETLW   0x00
                
ALUM3224NAP     BCF     STATUS,C
                GOTO    ALUM3224NA
                
BLUM3224NAP     BCF     STATUS,C
                GOTO    BLUM3224NA
                
CLUM3224NAP     BCF     STATUS,C
                GOTO    CLUM3224NA

ALOOPUM3224
                RRF     BARGB2,F
                BTFSS   STATUS,C
                GOTO    ALUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

ALUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                DECFSZ  LOOPCOUNT,F
                GOTO    ALOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

BLOOPUM3224
                RRF     BARGB1,F
                BTFSS   STATUS,C
                GOTO    BLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

BLUM3224NA
                RRF    	AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                DECFSZ  LOOPCOUNT,F
                GOTO    BLOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

CLOOPUM3224
                RRF     BARGB0,F
                BTFSS   STATUS,C
                GOTO    CLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

CLUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                RRF     AARGB6,F
                DECFSZ  LOOPCOUNT,F
                GOTO    CLOOPUM3224
				RETURN	
                


	end

