/////////////////////////////////////////////////////////////////

#if !defined(ESP8266)
  #error This sketch needs an ESP8266
#else

/////////////////////////////////////////////////////////////////

#include "ESPRotary.h"
#include "Ticker.h" // https://github.com/esp8266/Arduino/tree/master/libraries/Ticker

/////////////////////////////////////////////////////////////////

#define ROTARY_PIN1 D1
#define ROTARY_PIN2 D2

#define CLICKS_PER_STEP 4

#define SERIAL_SPEED    115200

/////////////////////////////////////////////////////////////////

ESPRotary r;
Ticker t;

/////////////////////////////////////////////////////////////////

void setup() {
  Serial.begin(SERIAL_SPEED);
  delay(50);

  r.begin(ROTARY_PIN1, ROTARY_PIN2, CLICKS_PER_STEP);
  r.setChangedHandler(rotate);
  r.setLeftRotationHandler(showDirection);
  r.setRightRotationHandler(showDirection);

  t.attach_ms(10, handleLoop);
}

/////////////////////////////////////////////////////////////////

void rotate(ESPRotary& r) {
   Serial.println(r.getPosition());
}

/////////////////////////////////////////////////////////////////

// on left or right rotation
void showDirection(ESPRotary& r) {
  Serial.println(r.directionToString(r.getDirection()));
}

/////////////////////////////////////////////////////////////////

void handleLoop() {
  r.loop();
}

/////////////////////////////////////////////////////////////////

void loop() {
  delay(1000);
  Serial.print(".");
}

/////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////
