#ifndef  MYPSU_H
#define  MYPSU_H
/* Configuration information for the PSU (slave) control hardware
*/

#define MODEL "LOAD-A"
#define HARD_VERSION 1
#define SOFT_VERSION 3

#define IS_ESP32

// diagnostics
//#define CDEBUG2

#define CS_PIN       10
#define CS_PIN2      0  // not enabled

#ifdef IS_ESP32
  #define VPIN        35   // ADC1_6 Coarse control VO
  #define VPIN_S      34   // ADC1_7
  #define IPIN        32   // ADC1_4
  #define TPIN        33   // ADC1_5
  #define DACPIN      25   // FINE CONTROL VO
  #define EEPROM_SIZE 4096 // bytes available
 // #include "myLESP32ADC.h"

#endif

#ifdef NANO
  #define VPIN        A0   // analog read main output voltage (SENSE_A = GPIO34 = ADC1_6) 
  #define VPIN_S      A1   // analog read SMPS output voltage (SENSE_B = GPIO35 = ADC1_7) 
  #define IPIN        A2   // analog read main output current (SENSE_C = GPIO32 = ADC1_4)
  #define TPIN        A3   // analog read heatsink temp (SENSE_C = GPIO32 = ADC1_4)
  #include "myNANOADC.h"
  // uncorrected ADC
  //hal_cal ADC_HAL = {&readADCHAL, 0.0, 0.0, 4.74, 0, 0, 10, false};
#endif

/**/
#include "myLADS1115.h"
#include "Adafruit_MCP4725RP.h"
// mutex variable for interrupt exclusion, starts open
portMUX_TYPE mux = portMUX_INITIALIZER_UNLOCKED;
#define ADC_CHANNELS 4
#define ADSMUX_START 0  // channel for first reading

#define NUMCHANNELS 1 // number of slave instruments controlled
uint8_t currentChannel = 0; // index value of current channel (local control) - may be different from SCIPchan

struct chPins{
	uint8_t onPin;
	uint8_t offPin;
} chanPins[NUMCHANNELS] = {
	{SW_ON, SW_OFF}
};


/***************** I2C Hardware definitions ***********************/
#define I2C_SPEED	400000

#define DAC_BASE	 0x60 	// MCP 4725 - may be anywhere in 0x60 - 0x67
#define DAC_SCAN	 8
#define DAC_MASK 	 0x0fff  // 12 bits [0..4096]

#define ADS_ADDR 0x48
//#define ADS_RATE ADS1115_REG_CONFIG_DR_128SPS
//#define ADS_RATE ADS1115_REG_CONFIG_DR_250SPS // I2C commands take 500uS, so no point in very fast conversion
//#define ADS_RATE ADS1115_REG_CONFIG_DR_475SPS	// ~10mS for all 4 readings
#define ADS_RATE ADS1115_REG_CONFIG_DR_860SPS // too fast for all the I2C traffic

#define ADS_GAIN GAIN_TWO // FSD: GAIN_ONE = 4.096V; GAIN_TWO = 2.048V 
#define ADS_MAXV 2.048
Adafruit_ADS1115 ads(ADS_ADDR);  
Adafruit_MCP4725 dac;
// ***** Primary ADC - ADS1115 *****
#define ADCsteps 		((1 << 15) -1)
#define ADCMAXVOLTS 	2.048
// **** Secondary ADC - ESP32 ****
#define ADCSTEPS_ESP 	((1 << 12) -1)
#define ADCMAXVOLTS_ESP 3.3 ESP
#define ADC_TOO_LOW 	(-1.0)	// value returned if ADC count is below bottom limit. Test is ( x < 0.0 )

// Control modes
#define ADS_CONTROL 1		// ADS values used, coarse or fine control
#define ESP_CONTROL 2		//  ESP values used, with sense check at low values.
#define COARSE_ITER  10		// number of read/set iterations in FAST control mode
#define C_VARCOARSE	 (0.4)  // abs diff for COARSE / FAST CONTROL
#define C_VARCOARSER (0.4)  // ratio diff for COARSE / FAST CONTROL
#define C_VARFINE	 (0.005)  // abs diff for ADS_CONTROL - 
#define C_VARFINER	 (0.005)  // ratio diff for ADS_CONTROL - 
#define C_DAMPING    (0.6)
#define C_DAMPING2    (0.5)
#define C_DAMPING3    (0.8)
#define C_STEADY 	 1   	// in steady state control
#define C_TRANS  	 2 		// currently slewing in STep mode

#define MINSTEP   5		// mS
/*****************************************************************************************
 ********** NEED TO CHANGE SOFTWARE VERSION (UPDATE PROFILE) IF THESE CHANGE  ************
 *****************************************************************************************/
#define VMAXOP		 (150)	// max output voltage setting (float)
#define OVERVOLTLIM		5	// this is the legitimate max above operating
#define VOMAXLIM	 (VMAXOP+OVERVOLTLIM)	// throw an error and turn off
#define VDROPOUT     (0.2)  // min voltage for proper operation (needs to be > RADSLO_V


#define IDROPOUT	 (0.001)
#define IMAXOP		 (15)	// max set current (double for daughter)
#define OVERAMPSLIM	  5		// this is the legitimate max above operating
#define SHORTCIRCUIT (IMAXOP+OVERAMPSLIM)   // When to trip short circuit protection - saved in HAL profile

#define PDROPOUT	 (0.1)
#define PMAXOP		 (240)

#define RDROPOUT	 (0.11) // // min current for proper operation (needs to be > RADSLO_I)
#define RMAXOP		 (1000)

#define TMAXOP		 (55)	// Deg C
#define MINSLEW 	  (5)	// mS
#define ADSMAXCOUNT	 0x7FFF // 15 bits
#define ESPMAXCOUNT  0x0FFF // 12 bits
#define ESP_SAFE	 100		// counts either side of min/max

#define OUT_OF_RANGE (-1.0)	// real world value returned when count is outside acceptable limits
// design or prototype CAL values
// For voltage and Current measurements, below the "CxxxLO_X" values the real world value is unmeasurable. 
//    -1 will be returned by the measurement routine.
// the exception is ADS voltage, where differential measurement may return small negative values 
//    (> -0.3V) if reverse voltage is applied to the load.
//ADS1115 ADC

/*****************************************************************************************
 ********** NEED TO CHANGE SOFTWARE VERSION (UPDATE PROFILE) IF THESE CHANGE  ************
 *****************************************************************************************/
#define ADC_ADS		1
#define CADSMIN_V 	(CADSBASE_V+2)  	// min viable result - several counts above flatline
// low cal point
#define RADSLO_V	(0.035)		// real world - ADS low Volts (should be lower than min possible setting: VDROPOUT in the HAL)
#define CADSBASE_V	5	// base reading (no volts input). Can't afford to have negative values for main ADC
#define CADSBASEPLUS_V	6	// must be ZERO - can't afford to have negative values for main ADC. 
#define CADSLO_V  	(CADSBASE_V+CADSBASEPLUS_V)		// counts 
// min viable result - may be a bit above flatline
#define RADSMIN_V 	(0.0)  	

#define RADSHI_V	(20.0)	// real world
#define CADSHI_V  	(3620)	// counts

#define CADSBASE_I	6	// base reading (no amps input)
#define RADSLO_I	(0.006) // ADS low Current (should be lower than min possible setting: IDROPOUT)
#define CADSBASEPLUS_I	7	// must be ZERO. can't afford to have negative values for main ADC
#define CADSLO_I	(CADSBASE_I+CADSBASEPLUS_I)
#define RADSMIN_I 	(0.0)  	// min viable result - may be a bit above flatline

#define RADSHI_I	(0.71)
#define CADSHI_I	(766)

//ESP ADC - values will have zero offsets
#define ADC_ESP		2
#define ESPREADS	4	// multiple reads to gain better precision
#define CESPBASE_V	720	// reading at no volts input (flatline) - this gets changed by Cal()
#define RESPLO_V	(1.932) // point at which voltage becomes linear
#define CESPBASEPLUS_V	22 //count offset to the min cal point. (likely non linear, so best compromise may be above zero
#define CESPLO_V	(CESPBASE_V+CESPBASEPLUS_V)	

#define RESPHI_V	(27.310)
#define CESPHI_V	(1083)	
#define RESPMIN_V 	(0.5)  	// min viable result - several counts above flatline

#define CESPBASE_I	720	// reading at no volts input (flatline) - this gets changed by Cal()
#define RESPLO_I	(0.195)	// point at which current becomes linear
#define CESPBASEPLUS_I	16
#define CESPLO_I	(CESPBASE_I+CESPBASEPLUS_I)	// zero offset: count @ I = 0
//#define CESPMIN_I 	()   // min viable result - several counts above flatline
#define RESPMIN_I 	(0.1)  	// min viable result - several counts above flatline

#define RESPHI_I	(1.728)
#define CESPHI_I	(855)	// ESP values will have low value offsets

#define RESPLO_T	(22)
#define CESPLO_T	(1972)	// ESP values will have low value offsets

#define RESPHI_T	(60)
#define CESPHI_T	(800)	// ESP values will have low value offsets

// need to define ADS_GAIN  // FSD:  GAIN_TWO = 2.048V 
// ADS1115: +/- 15 bits 
// Hardware abstraction and calibration for ADCs (HAL) 

//**** MCP4725 DAC
// three point approximation. Non-linear at low values/
#define MAXDAC 		4095
#define RDACLO_I 	(0.006) // double this for daughter!!!
#define CDACLO_I 	(35)	// make this a bit less than the real value to ensure turn off
#define RDACMID_I 	(0.059) // double this for daughter!!!
#define CDACMID_I 	(60)
#define RDACHI_I 	(1.683) // double this for daughter!!!
#define CDACHI_I 	(500)
#define CDAC_OPMAX  (850) // dac for max operational amps ************* FIX, test only **************
#define KICK 		 40  // small DAC setting to move output off zero amps
#define DAC_SMALLJUMP	1
#define DAC_BIGJUMP		10


struct hal_cal {
  // real world values
  float 	minVal;	   	  // limiting safe operating real values
  float 	maxVal;
  float 	minErr;	   	  // manage error if outside these real value limits
  float 	maxErr; 
  // cal real world
  float    	lowCalVal;    // real value at low cal point
  float		midCalVal;	  // three point, if needed (DAC, maybe ESPADC)
  float    	hiCalVal;     // real value at high cal point
  // cal ADC counts
  uint16_t 	lowCalCount;  // counts at low cal point  
  uint16_t	midCalCount;  // three point, if needed
  uint16_t 	hiCalCount;
};

#define NUM_ADC_CHANS 6
#define ADS_V 	0
#define ADS_I 	1
#define ESP_V 	2
#define ESP_I 	3
#define ESP_T 	4
#define DAC		5

// initally set low/high cal values from design params
hal_cal halCal[NUM_ADC_CHANS] = {
	{VDROPOUT, VMAXOP, 0.0, VOMAXLIM,   	RADSLO_V, 0.0, RADSHI_V, CADSLO_V, 0, CADSHI_V}, // ADS_V 
	{IDROPOUT, IMAXOP, 0.0, SHORTCIRCUIT, 	RADSLO_I, 0.0, RADSHI_I, CADSLO_I, 0, CADSHI_I}, // ADS_I
	{VDROPOUT, VMAXOP, 0.0, VOMAXLIM,   	RESPLO_V, 0.0, RESPHI_V, CESPLO_V, 0, CESPHI_V}, // ESP_V
	{IDROPOUT, IMAXOP, 0.0, VOMAXLIM, 		RESPLO_I, 0.0, RESPHI_I, CESPLO_I, 0, CESPHI_I}, // ESP_I
	{10,       TMAXOP,  10, RESPHI_T, 		RESPLO_T, 0.0, RESPHI_T, CESPLO_T, 0, CESPHI_T},  // ESP_T
	{RDACLO_I, IMAXOP, 0.0, VOMAXLIM, 		RDACLO_I, RDACMID_I, RDACHI_I, CDACLO_I, CDACMID_I, CDACHI_I}  // DAC
};


// settings BEFORE saved values have been read from EEPROM
// move most of these to the control profile.

#define MCPMAXVAL 255
/*
// ********** REDUNDANT - remove
#define STEPS_VOLT     (7.88)   // number of coarse setting steps to change vReading by 1V (slightly conservative) 
#define VOLTS_STEP		(0.13)	// volts per coarse setting step
#define F_STEPS_VOLT   (11800)   	// number of fine setting steps to change vReading by 1V (slightly conservative) was 900
#define FPOL            (1)   	// polarity of fine control
#define MS_CYCLE		(16)	// how often control() is called in mS (1/4 of ADS_RATE)
*/
// these alter behaviour of control() stop hunting, control dVdT
#define HYSTERESIS 		0       // (MCP steps) Voltage coarse control. 
#define BIGJUMP			10		// when to damp a coarse jump
#define DAMP_VOLT	    (0.8)	// damping factor for big jumps of coarse voltage
#define FHYSTERESIS 	8       // V fine control (slightly more than half the steps/mV value)
//#define SHYSTERESIS 1         // SMPS control
#define DAMP_ILIMIT     (0.8)   // damping factor for current limiting (to reduce hunting)
#define I_HYST			(0.003)	// hysteresis for iLimit
#define IND_OFF			0		// limiting disabled (indicator)
#define IND_EN			1		// limiting enabled
#define IND_ACT			2		// enabled and actively limiting

#define DVDT			(0.1)	// desired maximum rate of voltage change V per mS - used to stop overshoot with big voltage changes
#define DVDC			(DVDT * MS_CYCLE) // max DV per control cycle

// number of setting steps to change vReadingS by 1V, slightly conservative (damped response)
// for SMPS control, dV per step changes (relatively) inversely linearly over the scale. 
//#define S_DELTA			(3.0)	  // big jump needed if the step is greater than this, else increment current step
//#define STEPS_VOLT_SB   (120) // at the bottom  volt setting
//#define STEPS_VOLT_ST  (1)	  // at the top voltage setting

#define WSTART       (0x00)   // start_up (safe) value for main wiper (VO)
#define DSTART       (DAC_MASK/2)   // start fine control mid-range
//#define WSTART_S     (0x20)   // start_up (safe) value for SMPS wiper (polarity = -1 in this case)
#define VSTART       (0.0)    // start_up main voltage
//#define VSTART_S     (VSTART + VDROPOUT)    // SMPS start voltage (dropout)
//#define ISTART      (0.01)    // current reading - irrelevant

#define VINTERNAL_S   (7)     // SMPS voltage required to sustain internal supplies

#define SMALL_DIFF 0.001	// generic value for "significant" difference to floats
#define MEDIUM_DIFF 0.01	// 99%

//#define VCHANNEL    0    // Main
//#define ICHANNEL    1    // Main
//#define TCHANNEL    2    // Heatsink
//#define VCHANNEL_S  3    // SMPS
//#define ADCBITS     12
//#define MAXADC      ((1 << ADCBITS) - 1) // max adc count

// loadMode values for control
#define LOAD_CV 1
#define LOAD_CC	2
#define LOAD_CR 3
#define LOAD_CP 4
#define LOAD_TR 5
/* not yet implemented
struct control {
} myC; 
*/
// settings.mode
#define C_MODES  5
#define MODE_CV  1
#define MODE_CC  2
#define MODE_CP  3
#define MODE_CR  4
uint8_t inMode[C_MODES]; // used by display to colour buttons

// settings.modeB
#define B_MODES   3
#define MODE_OFF  0	// neither BAT or STEP selected
#define MODE_NOR MODE_OFF
#define MODE_ST   1 //  step
#define MODE_BAT  2 // battery test


// values for _curState
#define BMODE_OFF  0	// unselected  
#define BMODE_SEL 1   	// selected, but idle - for STEP or BAT modes when button pushed. Both exit to NOR mode - controlled by stepCalc() and batCalc().
#define BMODE_RUN  2   	// selected, running
uint8_t isModeB[B_MODES]; // which mode is active?
uint8_t _curState; 		// RUN state for ST selected mode

// STEP mode has N cycles of N steps between N stages (2)
uint16_t _curCycle = 0;	// which cycle are we in for STEP
uint8_t _curStage = 0;	// start with s[0] transient
uint16_t _curStep;		// current step in triangle / sawtooth
bool _slewing = false;
long _stepTzero;	// start of slew or dwell time
bool notSTmode; // see setMode() - may not need this.

// real world converted values
#define ADSMUXV 0	// match readings to ADS channels
#define ADSMUXI 1
struct measurements {
	float ADSvolts;
	float ESPvolts;
	float ADSamps;
	float ESPamps;
	float ESPtemp;
} meas;

float _lastVolts, _lastAmps; // no load voltage used in estimating DUT ESR in CV mode

// raw counts from ADCs
struct ADCcounts {
	int16_t ADSv;
	int16_t ADSa;
	int16_t ESPv;
	int16_t ESPa;
	int16_t ESPt;
} ADCcount;		
// spread the temps for hysteresis
// fan should be full on, moderately above room temp (say 10 deg).
#define TEMP_FANSTART 	(25.0)  // fan idles below this (deg C)
#define TEMP_FANFULL 	(35.0)  // fan at 100%
#define TEMP_SHUTDOWN 	(55.0)  // turn output off
#define FAN_MIN_PWM		30	// percent
// settings to save between sessions
// each 
struct transient {
	float volts;
	float amps;
	uint16_t time; // millis
	uint16_t steps;
};
bool    WifiConnected;	// flag set by WiFi (move this?)
#define NSTAGES 2	// number of transient states 
struct settings {
	float    voltage;		// set point
	float    current;		// set point
	float    resistance;		// set point
	float    power;			// set point
	struct   transient s[NSTAGES];// set points, STEP mode //s1, s2
//	uint16_t steps;			// steps between the two levels in STep mode
	uint16_t slew;		    // STEP mode rise/fall time: millis/A
	uint16_t cycles;		// STEP mode min is 1 
	uint8_t  mode;			// control mode: CC is default
	uint8_t  modeB;			// TR, BATtery test or STep mode
//	bool 	 triangle;		// sawtooth (off) triangle (on) - redundant - remove. Now controlled by T1 & T2
//	bool 	 offAfter;		// turn output off on completion (STEP) - redundant - remove. Always off after STEP or BAT sequence.

} pSet = {10.0, 0.1, 10.0, 10.0 ,{{1.0,0.2,10, 10}, {5.0,2.0,20, 5}},  10, 100, MODE_CC, MODE_OFF};
settings dynSet;

bool	outOn; 			// output is on 
bool 	limiting;  		// set by control()
bool 	isLimiting = false; 
uint8_t daughter_mul;	// set by control_setup(). 1 for none, 2 for daughter board
int 	_lastDAC = 0;	// last DAC setting - to calculate delta in fine mode
//delete these later
struct oldSettings {
	// MOVE OR DELETE THE REST OF THESE - THEY DON'T NEED TO BE SAVED
//	short   temperature;	// set point for fan on - move to #define?	
	bool    limitOn; 		// local current limiting enabled
	bool    trackOn;		// group tracking is enabled
	bool 	trackSa;		// tracking - set current as group
	bool 	trackSv;		// tracking - set volts as group
	bool outOn;	// DEPRECATED use GLOBAL
	uint8_t trackGrp;		// tracking group number - delete
	float eTrack;	
} pSetX;
// other OLD global control variables
/*		   
struct controls { // one per PSU board
	int vSetc, 			// startup setting for MCP
	vSetcS,  			// SMPS start setting - not used
	vfSetting;  		// DAC start setting
	
	float vSetpointX, 	// final value actually used
	vSetpointR, 		// remote tracking
	vSetpointI, 		// current limit
	vSetpointS,     	// nominal setting 
	localLimitRatio,
	vLast,vLastSet, watts;	
	bool iLimit, oldTrack;
	int8_t limitInd, trackInd; // easy indicators: 0==disabled; 1==enabled; 2==limiting/track-limiting
} pContA = {WSTART, 0, DSTART, 
			0,0,0,0,1,0,0,0, 
			false, false,5,7};
*/
// calibration menu
float calOff_I = 0.0,  
	  calOff_V = 0.0; // setting variables for offset calculation 

short  highButton = -1;	// currently selected screen button
// setting PWM properties
#define PWM_FREQ  15000 //21000
#define PWM_RESOLUTION  8
#define MAXPWM  ((1 << PWM_RESOLUTION) -1)
#define FANIND	(MAXPWM/2)
bool fanIsOn; // fan on indicator
int _curPWM;
// SCPI identification 
#define IDN_MANUF "SiliconChip"
#define IDN_MODEL MODEL
#define IDN_SERIAL "2001"
#define IDN_FIRMWARE SOFT_VERSION
#define IDN_OPTS "NONE"

#endif
