/* myInst.h
Basic definitions for all instruments and the Control Module
*/
#ifndef MYLINST_H
#define MYLINST_H

//#define  ILI9488 // select one
//#define  ILI9341 
#define ILI9488

//#define ESP8266
//#define NANO
#define ESP_32

#ifdef ILI9488
// need to include this before the pin (re)definitions
#include <Arduino_GFX_Library.h>
#endif

#include <EEPROM.h>
#include <WiFi.h>

#define EEAUTOSAVE 1	// 1 for save to EEPROM (production), 0 (!= 1) for no save
#define SAVE_EE_AFTER 3	// VL cycles - 3 for production

struct NullStream : public Stream{ // bit bucket for production debug info
 NullStream( void ) { return; }
 int available( void ) { return 0; }
 void flush( void ) { return; }
 int peek( void ) { return -1; }
 int read( void ){ return -1; };
 size_t write( uint8_t u_Data ){ return u_Data, 0x01; }
};
NullStream noDebug;

// switch Serial debugging on and off
#define SDEBUG1 Serial	// testing - information
//#define SDEBUG1 noDebug // production - information

#define SDEBUG2 Serial	// testing - errors
//#define SDEBUG2 noDebug // production - errors

#define IDLEN 16
char dns_id[IDLEN] = "ESP32_5";
// BOARD REV C/D/E - Control v13 onwards
#define ENC_A 		25  // Scrubber control encoder // remapped from 32
#define ENC_B 		33  // Note: Encoder switch is 
#define CNTRL_R 	14	// Scrubber buttons 
#define CNTRL_L 	27

//  ESP ADC (secondary for V & I, primary for T)
#define ADC_BV   	34 //  ESP ADC1
#define ADC_BI   	35 //  ESP ADC1
#define ADC_BT   	32 //  ESP ADC1 
#define PWM_PIN  	26 
#define FANPIN		PWM_PIN  // GPIO 16/17 are NC on WROVER (return to pin 26) - REv C boards (need to patch FAN from CONTROL Pin 10 to pin 14.
#define RXD2 		16 
#define DPRESENT	17
#define TXD2 		17 // don't use for Load.
#define ADSRDY 		2
//#define DACPIN 		255 // was 25

#define SW_ON 		4 	// hi is active 
#define SW_OFF 		12  // hi is active 
#define TFT_TOUCH_CS 15
#define TFT_TOUCH_IRQ 255 // not used - jumper is open

#define L_BUT  CNTRL_L
#define R_BUT  CNTRL_R

// Generics
#define SENSE_A 	34 // GPIO or ADC
#define SENSE_B 	35
#define SENSE_C 	32
#define SENSE_D 	33

#define TFT_SS 		5
#define SPI_SCK 	18
#define MISO 		19
#define MOSI 		23
#define T_IRQ 		2
#define T_CS 		15

#define LTFT_DC 	13
#define LTFT_CS     TFT_SS
#define LTFT_MOSI	MOSI
#define LTFT_CLK 	SPI_SCK
#define LTFT_MISO 	MISO
#define LTFT_RST 	255 //-1
//#define TFT_IRQ 	255  // jumper is open

#define SDA 		21
#define SCL 		22

#define OPTO_IN 	3 	// RXD
#define OPTO_OUT 	1 	// TXD

// ***** rotary encoder and L-R switches
//#define ENCODER_DO_NOT_USE_INTERRUPTS 
#include "ESPRotary.h"
#include "Button2.h"
#define DEBOUNCE 10
#define ENC_CLIX 2
//Button2 but  = Button2(ENC_SW); // not used
Button2 butL = Button2(L_BUT, INPUT_PULLDOWN, false, DEBOUNCE);
Button2 butR = Button2(R_BUT, INPUT_PULLDOWN, false, DEBOUNCE);
ESPRotary enc = ESPRotary(ENC_B, ENC_A, ENC_CLIX);
#define ADSBITS 15



// One record per ADC input
// Contains setpoints for input
// Aids conversion from counts to Real-world values for processing
/* use struct in_hal
struct inADC {
  float curVal;   // last reading in real-world units
  float curVolts; // last reading in volts
  // setPoint belongs in a control struct, not a convert struct - see struct settings
 // float   setPoint;		   // control target in real-world units
  float   lowError;        // trigger error action - value too low
  float   hiError;		   // trigger error action (turn things off) - e.g. overvoltage, short circuit, over temp
  // conversion factors - xxxVal results from  xxxVolts
  float   minVal;          // value in real-world units at minVolts  [ignored for thermistors]
  float   midVal;          // used for 3 point linearity correction. Ignored if threePoint == false. [RSERIES for thermistors]
  float   maxVal;          // value in real-world units at maxVolts [TEMPERATURENOMINAL for thermistors]
 
  float   minVolts;        // min measured value in volts  [THERMISTORNOMINAL R for thermistors]
  float   midVolts;        // used for 3 point linearity correction. Ignored if threePoint == false. [BCOEFFICIENT for thermistors]
  float   maxVolts;        // max measured(V) at [vMax = VCC for thermistors]
 // hal_cal *HALptr;         // pointer to HAL structure for service routines, etc
  char    units[4];        // name of the unit e.g. "mA" or "V"
  char    iname[6];		   // name of the control (e.g. "Vout")
  uint8_t ADCchannel;      // channel within device or ADC pin
  bool    threePoint;      // turn on three-point curve processing (used for IS_ESP32 - non-linear ADC)
  bool    constrainVals;   // constrain values: force minVolts <= readVolts <= maxVolts?  
 // bool	  dummy[3];				// bring it up to a 32 bit boundary
};

struct ADC_callbacks {  // removed from inADC, so that pointers are not stored in EEPROM
  float (* readVolts)(uint8_t channel);  // service routine to convert read from ADC and convert to volts read
  float (* convert)(float volts, inADC * ap);  // service routine to convert volts read to real world value
};
*/
/*
	contains all stored identification data - name, network, etc
*/
#define SSIDLEN 34		// > 32 + null
#define NETPASSLEN 64	// > 63 + null
#define NAMELEN 16		// displayed name, used to identify
uint8_t netCIDR = 24;	// default Class C network - to calculate netmask 

struct netParams { // general network spec
  IPAddress local, gateway, subnet;
  bool autoconnect; // maybe not relevant, other than to enable AP mode?
};

struct wifiParams { // Wifi credentials
  char ssid[SSIDLEN],
       pass[NETPASSLEN];
  bool autoconnect;  
};

#ifdef REALNET
	#define LOCAL_SS "PalHome"
	#define LOCAL_PASS "AF18181F9C4516EE36AF9D79D3"
#else
	#define LOCAL_SS "XP"
	#define LOCAL_PASS "E36AF9D79D3"
#endif	

//wifiParams homeNet = {"PalHome", "AF18181F9C4516EE36AF9D79D3", true};
//wifiParams homeNet = {"XP", "E36AF9D79D3", true};
struct instID {
	IPAddress prefIP;	// preferred IP
	IPAddress gateIP;	
	IPAddress netmask;	
    char local_ssid[SSIDLEN];
	char local_pass[NETPASSLEN];	// always assumes DHCP on WiFi
	char esp_ssid[SSIDLEN];
	char esp_pass[NETPASSLEN];	// always assumes DHCP on WiFi
	bool autoConnect;			// maybe "enabled"?
	char instName[NAMELEN];
};

instID myID = {{192,168,50,1}, {192,168,50,1},{192,168,50,0}, LOCAL_SS, LOCAL_PASS, "ESPINST", "ESPPW99X", true, "MYLOAD"};
bool IamAP = false;	// am I the AP?

// screen pixel limits
// screen pixel limits
#ifdef ILI9341
	#define HMAX 320
	#define VMAX 240
	#define SCREENROT 3 // SCREEN rotation default
	#define TOUCHROT 1
#else // ILI9488
	#define HMAX 480
	#define VMAX 320
	#define SCREENROT 1 // SCREEN rotation default
	#define TOUCHROT 1
#endif

// various global defs
#define UDP_PORT 8888 
#define TELNET_PORT 5025 // SCPI std
#define MAXTRACKGRP 127
#define HOSTLEN 48
IPAddress myIP 			= {192,168,1,200};
IPAddress myBroadcastIP = {192,168,1,255};
IPAddress mySubnetMask  = {255,255,255,0};
char myHostName[HOSTLEN];
char IPstring[16];
uint8_t myNetCDIR = 24;

bool dirtyScreen = true; // any routine can cause the screen to be redrawn
//bool valChanged(VAL_CHGD);
volatile bool changedVal_scrn = false, changedVal_EE = false, changedVal_SCPI = false; // changed settings values need to be addressed by several modules
bool needToSaveEE = false;

// on screen keyboard active - disable various functions
bool oskOn = false;


#define SCPI_BUFLEN 256
#define SCPI_SHORTCMD 4
// SCPI stream timeouts (Seconds) -1 == never
#define SCPIUDPTIMEOUT 		10	// (S)
#define SCPISERIALTIMEOUT 	-1	// (S)
#define SCPITELNETTIMEOUT 	-1	// (S) 
#define HEART_MSG "HEARTBEAT"
/* explicit includes in main prog
#if defined(ESP_32) || defined(ESP_8266)
#include "myLWiFi.h"
//#include "myHTTP.h"
//#include "myUDP.h"
#endif
*/
// test values - not for production
float xDumVal = 0.0;
#endif /* MYINST_H */