/******************************************************************************
 read_CCS811_data.ino
 An Arduino sketch which reads the data output from the CCS811 digital gas
 sensor in modules such as the Keyestudio SEN-CCS811 CO2 air quality monitor
 or the Jaycar/duinotech XC3782 air quality sensor module.
 Adapted from the Keyestudio readData.ino sketch, which uses the Keyestudio
 KS0457 library (CCS811.h and CCS811.cpp), both of which can be downloaded
 from this location: https://fs.keystudio.com/KS0457
 Note that the default I2C address of the CCS811 device in the above modules
 is 0x5A, also that this sketch communicates with the device at 115200 baud.
 Also please note that the 'WAKE' pin of the above modules needs to be
 connected to the Arduino's GND, to ensure reliable communication.
 Adapted by Jim Rowe for Silicon Chip magazine.
 Last revision: 7/10/2021
*****************************************************************************/

#include <CCS811.h>

//CCS811 sensor(&Wire, /*IIC_ADDRESS=*/0x5A);
CCS811 sensor;

void setup(void)
{
    Serial.begin(115200);
    /*Wait for the chip to be initialized completely, and then exit*/
    while(sensor.begin() != 0){
        Serial.println("failed to init chip, please check if the chip connection is fine");
        delay(1000);
    }
    Serial.println("Getting data from the CCS811...");
    /**
     * @brief Set measurement cycle
     * @param cycle:in typedef enum{
     *        eClosed,      //Idle (Measurements are disabled in this mode)
     *        eCycle_1s,    //Constant power mode, IAQ measurement every second
     *        eCycle_10s,   //Pulse heating mode IAQ measurement every 10 seconds
     *        eCycle_60s,   //Low power pulse heating mode IAQ measurement every 60 seconds
     *        eCycle_250ms  //Constant power mode, sensor measurement every 250ms
     *        }eCycle_t;
     */
    sensor.setMeasCycle(sensor.eCycle_250ms);
}
void loop() {
  delay(1000);
    if(sensor.checkDataReady() == true){
        Serial.print("eCO2: ");
        Serial.print(sensor.getCO2PPM());
        Serial.print("ppm, eTVOC: ");
        Serial.print(sensor.getTVOCPPB());
        Serial.println("ppb");
        
    } else {
        Serial.println("Data is not ready!");
    }
    /*!
     * @brief Set baseline
     * @param get from getBaseline.ino
     */
    sensor.writeBaseLine(0x847B);
    //delay cannot be less than measurement cycle
    //delay(1000);
}
