﻿Imports System.Windows.Forms
Imports WarmBreeze_DataLibrary
#Region "Automatically generated DataSet code"
Public Class CodeGen_DS_Spectral
    '=============================================================================================
    'Automatic DataSet code generation. © Jeremy Leach WarmBreeze Software 2016
    'Generated on :03/05/2020 13:00:48
    'Version : 1.0
    'RULES:
    ' - Primary key columns must be integer ID columns.
    ' - Columns can end _id and not be primary keys. It checks which ones are primary.
    ' - All primary and foreign key names should be of the format <tablename>_id. Lowever case.
    ' - All tables MUST have a sort_order column.
    ' - If there is a name column then it must be of the format <tablename>_name.
    '=============================================================================================

#Region "Declarations"
    'DataSet variable
    Private _DSSPECTRAL As New DataSet_Spectral
    Private PLInfo As New WarmBreeze_DataLibrary.PL_Info
    'Table variables
    Private WithEvents _Table_adsr_section As New TableClass_adsr_section(_DSSPECTRAL, Me)
    Private WithEvents _Table_adsr_section_envelope_config As New TableClass_adsr_section_envelope_config(_DSSPECTRAL, Me)
    Private WithEvents _Table_biquad_eq As New TableClass_biquad_eq(_DSSPECTRAL, Me)
    Private WithEvents _Table_biquad_eq_calculated As New TableClass_biquad_eq_calculated(_DSSPECTRAL, Me)
    Private WithEvents _Table_body_resonance_filter As New TableClass_body_resonance_filter(_DSSPECTRAL, Me)
    Private WithEvents _Table_body_resonance_filter_band As New TableClass_body_resonance_filter_band(_DSSPECTRAL, Me)
    Private WithEvents _Table_envelope_control As New TableClass_envelope_control(_DSSPECTRAL, Me)
    Private WithEvents _Table_lfo_envelope_config As New TableClass_lfo_envelope_config(_DSSPECTRAL, Me)
    Private WithEvents _Table_patch As New TableClass_patch(_DSSPECTRAL, Me)
    Private WithEvents _Table_patch_set As New TableClass_patch_set(_DSSPECTRAL, Me)
    Private WithEvents _Table_patch_set_patches As New TableClass_patch_set_patches(_DSSPECTRAL, Me)
    Private WithEvents _Table_performance As New TableClass_performance(_DSSPECTRAL, Me)
    Private WithEvents _Table_performance_channel As New TableClass_performance_channel(_DSSPECTRAL, Me)
    Private WithEvents _Table_performance_processor As New TableClass_performance_processor(_DSSPECTRAL, Me)
    Private WithEvents _Table_system_settings As New TableClass_system_settings(_DSSPECTRAL, Me)
    Private WithEvents _Table_waveform As New TableClass_waveform(_DSSPECTRAL, Me)
    Private WithEvents _Table_waveform_harmonic As New TableClass_waveform_harmonic(_DSSPECTRAL, Me)
    Private WithEvents _Table_waveform_set As New TableClass_waveform_set(_DSSPECTRAL, Me)
    Public Event Event_AfterFileLoad(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_section_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_section_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_section_envelope_config_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_section_envelope_config_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_biquad_eq_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_biquad_eq_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_biquad_eq_calculated_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_biquad_eq_calculated_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_body_resonance_filter_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_body_resonance_filter_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_body_resonance_filter_band_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_body_resonance_filter_band_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_envelope_control_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_envelope_control_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_lfo_envelope_config_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_lfo_envelope_config_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_set_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_set_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_set_patches_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_set_patches_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_performance_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_performance_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_performance_channel_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_performance_channel_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_performance_processor_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_performance_processor_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_system_settings_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_system_settings_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_harmonic_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_harmonic_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_set_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_set_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
#End Region

#Region "Properties"
    Public Property DSSPECTRAL() As DataSet_Spectral
        Get
            Return _DSSPECTRAL
        End Get
        Set(value As DataSet_Spectral)
            _DSSPECTRAL = value
        End Set
    End Property

    Public ReadOnly Property Tables() As DataTableCollection
        Get
            Return _DSSPECTRAL.Tables
        End Get
    End Property

    Public Property Table_adsr_section() As TableClass_adsr_section
        Get
            Return _Table_adsr_section
        End Get
        Set(value As TableClass_adsr_section)
            _Table_adsr_section = value
        End Set
    End Property

    Public Property Table_adsr_section_envelope_config() As TableClass_adsr_section_envelope_config
        Get
            Return _Table_adsr_section_envelope_config
        End Get
        Set(value As TableClass_adsr_section_envelope_config)
            _Table_adsr_section_envelope_config = value
        End Set
    End Property

    Public Property Table_biquad_eq() As TableClass_biquad_eq
        Get
            Return _Table_biquad_eq
        End Get
        Set(value As TableClass_biquad_eq)
            _Table_biquad_eq = value
        End Set
    End Property

    Public Property Table_biquad_eq_calculated() As TableClass_biquad_eq_calculated
        Get
            Return _Table_biquad_eq_calculated
        End Get
        Set(value As TableClass_biquad_eq_calculated)
            _Table_biquad_eq_calculated = value
        End Set
    End Property

    Public Property Table_body_resonance_filter() As TableClass_body_resonance_filter
        Get
            Return _Table_body_resonance_filter
        End Get
        Set(value As TableClass_body_resonance_filter)
            _Table_body_resonance_filter = value
        End Set
    End Property

    Public Property Table_body_resonance_filter_band() As TableClass_body_resonance_filter_band
        Get
            Return _Table_body_resonance_filter_band
        End Get
        Set(value As TableClass_body_resonance_filter_band)
            _Table_body_resonance_filter_band = value
        End Set
    End Property

    Public Property Table_envelope_control() As TableClass_envelope_control
        Get
            Return _Table_envelope_control
        End Get
        Set(value As TableClass_envelope_control)
            _Table_envelope_control = value
        End Set
    End Property

    Public Property Table_lfo_envelope_config() As TableClass_lfo_envelope_config
        Get
            Return _Table_lfo_envelope_config
        End Get
        Set(value As TableClass_lfo_envelope_config)
            _Table_lfo_envelope_config = value
        End Set
    End Property

    Public Property Table_patch() As TableClass_patch
        Get
            Return _Table_patch
        End Get
        Set(value As TableClass_patch)
            _Table_patch = value
        End Set
    End Property

    Public Property Table_patch_set() As TableClass_patch_set
        Get
            Return _Table_patch_set
        End Get
        Set(value As TableClass_patch_set)
            _Table_patch_set = value
        End Set
    End Property

    Public Property Table_patch_set_patches() As TableClass_patch_set_patches
        Get
            Return _Table_patch_set_patches
        End Get
        Set(value As TableClass_patch_set_patches)
            _Table_patch_set_patches = value
        End Set
    End Property

    Public Property Table_performance() As TableClass_performance
        Get
            Return _Table_performance
        End Get
        Set(value As TableClass_performance)
            _Table_performance = value
        End Set
    End Property

    Public Property Table_performance_channel() As TableClass_performance_channel
        Get
            Return _Table_performance_channel
        End Get
        Set(value As TableClass_performance_channel)
            _Table_performance_channel = value
        End Set
    End Property

    Public Property Table_performance_processor() As TableClass_performance_processor
        Get
            Return _Table_performance_processor
        End Get
        Set(value As TableClass_performance_processor)
            _Table_performance_processor = value
        End Set
    End Property

    Public Property Table_system_settings() As TableClass_system_settings
        Get
            Return _Table_system_settings
        End Get
        Set(value As TableClass_system_settings)
            _Table_system_settings = value
        End Set
    End Property

    Public Property Table_waveform() As TableClass_waveform
        Get
            Return _Table_waveform
        End Get
        Set(value As TableClass_waveform)
            _Table_waveform = value
        End Set
    End Property

    Public Property Table_waveform_harmonic() As TableClass_waveform_harmonic
        Get
            Return _Table_waveform_harmonic
        End Get
        Set(value As TableClass_waveform_harmonic)
            _Table_waveform_harmonic = value
        End Set
    End Property

    Public Property Table_waveform_set() As TableClass_waveform_set
        Get
            Return _Table_waveform_set
        End Get
        Set(value As TableClass_waveform_set)
            _Table_waveform_set = value
        End Set
    End Property

#End Region

#Region "Methods - General"
    Public Sub New()
    End Sub

    Public Sub SaveDataToFile(FilePath As String)
        Try
            _DSSPECTRAL.WriteXml(FilePath, XmlWriteMode.IgnoreSchema)
            'Must accept all the changes
            AcceptChangesOnAllFileData()
        Catch ex As Exception
            PLInfo.DisplayExclamation("Error saving to file. Error is :" & ex.Message.ToString)
        End Try
    End Sub

    Public Sub LoadDataFromFile(FilePath As String)
        Try
            ''First delete all data because :If the DataSet already contains data, the new data from the XML is added to the data already present in the DataSet.
            DeleteAllTableContents()
            ''Now read the data
            _DSSPECTRAL.ReadXml(FilePath, XmlWriteMode.IgnoreSchema)
            ''Must accept all the changes
            AcceptChangesOnAllFileData()
            RaiseEvent Event_AfterFileLoad(Nothing, Nothing)
        Catch ex As Exception
            PLInfo.DisplayExclamation("Error loading from file. Error is :" & ex.Message.ToString)
        End Try
    End Sub

    Friend Function HasChildTableDataDependency(parent_table_name As String, parent_table_pk_id As Integer) As Boolean
        Dim parent_table_pk_name As String = parent_table_name & "_id"
        For Each T As DataTable In _DSSPECTRAL.Tables
            If T.TableName <> parent_table_name Then
                For Each C As DataColumn In T.Columns
                    If C.ColumnName = parent_table_pk_name Then
                        If T.Select(C.ColumnName & " = " & parent_table_pk_id, Nothing, DataViewRowState.CurrentRows).Count > 0 Then
                            Return True
                        End If
                    End If
                Next
            End If
        Next
        Return False
    End Function

    Public Function DataHasChanged() As Boolean
        For Each T As DataTable In _DSSPECTRAL.Tables
            If T.GetChanges IsNot Nothing Then
                If T.Rows.Count > 0 Then
                    If T.GetChanges.Rows.Count > 0 Then Return True
                End If
            End If
        Next
        Return False
    End Function

    Public Sub AcceptChangesOnAllFileData()
        For Each T As DataTable In _DSSPECTRAL.Tables
            T.AcceptChanges()
        Next
    End Sub

    Public Sub DisposeOfAllComponents()
        _DSSPECTRAL.Dispose()
        _Table_adsr_section.Table_BindingSource.Dispose()
        _Table_adsr_section_envelope_config.Table_BindingSource.Dispose()
        _Table_biquad_eq.Table_BindingSource.Dispose()
        _Table_biquad_eq_calculated.Table_BindingSource.Dispose()
        _Table_body_resonance_filter.Table_BindingSource.Dispose()
        _Table_body_resonance_filter_band.Table_BindingSource.Dispose()
        _Table_envelope_control.Table_BindingSource.Dispose()
        _Table_lfo_envelope_config.Table_BindingSource.Dispose()
        _Table_patch.Table_BindingSource.Dispose()
        _Table_patch_set.Table_BindingSource.Dispose()
        _Table_patch_set_patches.Table_BindingSource.Dispose()
        _Table_performance.Table_BindingSource.Dispose()
        _Table_performance_channel.Table_BindingSource.Dispose()
        _Table_performance_processor.Table_BindingSource.Dispose()
        _Table_system_settings.Table_BindingSource.Dispose()
        _Table_waveform.Table_BindingSource.Dispose()
        _Table_waveform_harmonic.Table_BindingSource.Dispose()
        _Table_waveform_set.Table_BindingSource.Dispose()
    End Sub

    Public Sub DeleteAllTableContents()
        ''NOTE: Do NOT use DSFT.Tables.Clear() because thiserases the actual tables !!
        For Each T As DataTable In _DSSPECTRAL.Tables
            T.Clear()
        Next
    End Sub

    Public Sub DecoupleAllTableBindings()
        _Table_adsr_section.Table_BindingSource.DataSource = Nothing
        _Table_adsr_section_envelope_config.Table_BindingSource.DataSource = Nothing
        _Table_biquad_eq.Table_BindingSource.DataSource = Nothing
        _Table_biquad_eq_calculated.Table_BindingSource.DataSource = Nothing
        _Table_body_resonance_filter.Table_BindingSource.DataSource = Nothing
        _Table_body_resonance_filter_band.Table_BindingSource.DataSource = Nothing
        _Table_envelope_control.Table_BindingSource.DataSource = Nothing
        _Table_lfo_envelope_config.Table_BindingSource.DataSource = Nothing
        _Table_patch.Table_BindingSource.DataSource = Nothing
        _Table_patch_set.Table_BindingSource.DataSource = Nothing
        _Table_patch_set_patches.Table_BindingSource.DataSource = Nothing
        _Table_performance.Table_BindingSource.DataSource = Nothing
        _Table_performance_channel.Table_BindingSource.DataSource = Nothing
        _Table_performance_processor.Table_BindingSource.DataSource = Nothing
        _Table_system_settings.Table_BindingSource.DataSource = Nothing
        _Table_waveform.Table_BindingSource.DataSource = Nothing
        _Table_waveform_harmonic.Table_BindingSource.DataSource = Nothing
        _Table_waveform_set.Table_BindingSource.DataSource = Nothing
    End Sub

    Public Sub RecoupleAllTableBindings()
        ReCoupleTableBindings(_Table_adsr_section)
        ReCoupleTableBindings(_Table_adsr_section_envelope_config)
        ReCoupleTableBindings(_Table_biquad_eq)
        ReCoupleTableBindings(_Table_biquad_eq_calculated)
        ReCoupleTableBindings(_Table_body_resonance_filter)
        ReCoupleTableBindings(_Table_body_resonance_filter_band)
        ReCoupleTableBindings(_Table_envelope_control)
        ReCoupleTableBindings(_Table_lfo_envelope_config)
        ReCoupleTableBindings(_Table_patch)
        ReCoupleTableBindings(_Table_patch_set)
        ReCoupleTableBindings(_Table_patch_set_patches)
        ReCoupleTableBindings(_Table_performance)
        ReCoupleTableBindings(_Table_performance_channel)
        ReCoupleTableBindings(_Table_performance_processor)
        ReCoupleTableBindings(_Table_system_settings)
        ReCoupleTableBindings(_Table_waveform)
        ReCoupleTableBindings(_Table_waveform_harmonic)
        ReCoupleTableBindings(_Table_waveform_set)
    End Sub

    Private Sub ReCoupleTableBindings(CodeGenTable As I_GenericCodeGenTable)
        For Each ChildCodeGenTable As I_GenericCodeGenTable In CodeGenTable.ChildCodeGenTableList
            ReCoupleTableBindings(ChildCodeGenTable)
        Next
        CodeGenTable.RecoupleTableBindings()
    End Sub

    Public Sub InitialiseForParentTable(ParentCodeGenTable As I_GenericCodeGenTable)
        If ParentCodeGenTable Is Nothing Then Exit Sub
        Dim ParentTableName As String = ParentCodeGenTable.TableName
        Dim ParentTableIDValue As Integer = ParentCodeGenTable.GetTablePKCurrentValue
        For Each ChildCodGenTable As I_GenericCodeGenTable In ParentCodeGenTable.ChildCodeGenTableList
            If ChildCodGenTable.HasForeignKeys = True Then
                ChildCodGenTable.SetDefaultViewFilter(ParentTableName & "_id = " & ParentTableIDValue)
                ChildCodGenTable.SetDefaultForeignKeyValue(ParentTableName & "_id", ParentTableIDValue)
            End If
            InitialiseForParentTable(ChildCodGenTable)
        Next
    End Sub

#End Region

#Region "Private subs"
    Private Sub EventRelay_adsr_section_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_adsr_section.Event_NewRowAdded
        RaiseEvent Event_adsr_section_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_adsr_section_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_adsr_section.Event_BeforeRowDeleted
        RaiseEvent Event_adsr_section_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_adsr_section_envelope_config_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_adsr_section_envelope_config.Event_NewRowAdded
        RaiseEvent Event_adsr_section_envelope_config_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_adsr_section_envelope_config_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_adsr_section_envelope_config.Event_BeforeRowDeleted
        RaiseEvent Event_adsr_section_envelope_config_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_biquad_eq_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_biquad_eq.Event_NewRowAdded
        RaiseEvent Event_biquad_eq_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_biquad_eq_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_biquad_eq.Event_BeforeRowDeleted
        RaiseEvent Event_biquad_eq_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_biquad_eq_calculated_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_biquad_eq_calculated.Event_NewRowAdded
        RaiseEvent Event_biquad_eq_calculated_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_biquad_eq_calculated_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_biquad_eq_calculated.Event_BeforeRowDeleted
        RaiseEvent Event_biquad_eq_calculated_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_body_resonance_filter_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_body_resonance_filter.Event_NewRowAdded
        RaiseEvent Event_body_resonance_filter_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_body_resonance_filter_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_body_resonance_filter.Event_BeforeRowDeleted
        RaiseEvent Event_body_resonance_filter_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_body_resonance_filter_band_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_body_resonance_filter_band.Event_NewRowAdded
        RaiseEvent Event_body_resonance_filter_band_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_body_resonance_filter_band_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_body_resonance_filter_band.Event_BeforeRowDeleted
        RaiseEvent Event_body_resonance_filter_band_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_envelope_control_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_envelope_control.Event_NewRowAdded
        RaiseEvent Event_envelope_control_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_envelope_control_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_envelope_control.Event_BeforeRowDeleted
        RaiseEvent Event_envelope_control_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_lfo_envelope_config_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_lfo_envelope_config.Event_NewRowAdded
        RaiseEvent Event_lfo_envelope_config_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_lfo_envelope_config_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_lfo_envelope_config.Event_BeforeRowDeleted
        RaiseEvent Event_lfo_envelope_config_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_patch.Event_NewRowAdded
        RaiseEvent Event_patch_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_patch.Event_BeforeRowDeleted
        RaiseEvent Event_patch_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_set_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_patch_set.Event_NewRowAdded
        RaiseEvent Event_patch_set_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_set_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_patch_set.Event_BeforeRowDeleted
        RaiseEvent Event_patch_set_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_set_patches_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_patch_set_patches.Event_NewRowAdded
        RaiseEvent Event_patch_set_patches_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_set_patches_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_patch_set_patches.Event_BeforeRowDeleted
        RaiseEvent Event_patch_set_patches_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_performance_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_performance.Event_NewRowAdded
        RaiseEvent Event_performance_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_performance_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_performance.Event_BeforeRowDeleted
        RaiseEvent Event_performance_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_performance_channel_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_performance_channel.Event_NewRowAdded
        RaiseEvent Event_performance_channel_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_performance_channel_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_performance_channel.Event_BeforeRowDeleted
        RaiseEvent Event_performance_channel_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_performance_processor_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_performance_processor.Event_NewRowAdded
        RaiseEvent Event_performance_processor_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_performance_processor_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_performance_processor.Event_BeforeRowDeleted
        RaiseEvent Event_performance_processor_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_system_settings_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_system_settings.Event_NewRowAdded
        RaiseEvent Event_system_settings_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_system_settings_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_system_settings.Event_BeforeRowDeleted
        RaiseEvent Event_system_settings_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_waveform.Event_NewRowAdded
        RaiseEvent Event_waveform_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_waveform.Event_BeforeRowDeleted
        RaiseEvent Event_waveform_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_harmonic_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_waveform_harmonic.Event_NewRowAdded
        RaiseEvent Event_waveform_harmonic_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_harmonic_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_waveform_harmonic.Event_BeforeRowDeleted
        RaiseEvent Event_waveform_harmonic_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_set_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_waveform_set.Event_NewRowAdded
        RaiseEvent Event_waveform_set_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_set_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_waveform_set.Event_BeforeRowDeleted
        RaiseEvent Event_waveform_set_RowDeleted(sender, Nothing)
    End Sub

#End Region

#Region "Sub-classes"
#Region "----------Class : TableClass_adsr_section ------------------------------"
    Public Class TableClass_adsr_section
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.adsr_sectionDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_id As System.Int32
            Dim adsr_section_id As System.Int32
            Dim flag_active As System.Int32
            Dim end_time_ms As System.Int32
            Dim end_time_ms_keyscale_upper As System.Single
            Dim end_time_ms_keyscale_lower As System.Single
            Dim inharmonic_sample_playback_mode_id As System.Int32
            Dim inharmonic_sample_id As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_id As System.Int32 = 0
            Public flag_active As System.Int32 = 0
            Public end_time_ms As System.Int32 = 0
            Public end_time_ms_keyscale_upper As System.Single = 0
            Public end_time_ms_keyscale_lower As System.Single = 0
            Public inharmonic_sample_playback_mode_id As System.Int32 = 0
            Public inharmonic_sample_id As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_id = "patch_id"
            Const adsr_section_id = "adsr_section_id"
            Const flag_active = "flag_active"
            Const end_time_ms = "end_time_ms"
            Const end_time_ms_keyscale_upper = "end_time_ms_keyscale_upper"
            Const end_time_ms_keyscale_lower = "end_time_ms_keyscale_lower"
            Const inharmonic_sample_playback_mode_id = "inharmonic_sample_playback_mode_id"
            Const inharmonic_sample_id = "inharmonic_sample_id"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "adsr_section"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.adsr_sectionDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.adsr_section
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.adsr_section.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.adsr_sectionRow = _DSSPECTRAL.adsr_section.Newadsr_sectionRow
            With R
                .adsr_section_id = GetNewadsr_sectionID()
                .patch_id = _DefaultRowValues.patch_id
                .flag_active = _DefaultRowValues.flag_active
                .end_time_ms = _DefaultRowValues.end_time_ms
                .end_time_ms_keyscale_upper = _DefaultRowValues.end_time_ms_keyscale_upper
                .end_time_ms_keyscale_lower = _DefaultRowValues.end_time_ms_keyscale_lower
                .inharmonic_sample_playback_mode_id = _DefaultRowValues.inharmonic_sample_playback_mode_id
                .inharmonic_sample_id = _DefaultRowValues.inharmonic_sample_id
            End With
            _DSSPECTRAL.adsr_section.Addadsr_sectionRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_id
        End Function

        Public Function AddRow2(patch_id As System.Int32, flag_active As System.Int32, end_time_ms As System.Int32, end_time_ms_keyscale_upper As System.Single, end_time_ms_keyscale_lower As System.Single, inharmonic_sample_playback_mode_id As System.Int32, inharmonic_sample_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.adsr_sectionRow = _DSSPECTRAL.adsr_section.Newadsr_sectionRow
            With R
                .adsr_section_id = GetNewadsr_sectionID()
                .patch_id = patch_id
                .flag_active = flag_active
                .end_time_ms = end_time_ms
                .end_time_ms_keyscale_upper = end_time_ms_keyscale_upper
                .end_time_ms_keyscale_lower = end_time_ms_keyscale_lower
                .inharmonic_sample_playback_mode_id = inharmonic_sample_playback_mode_id
                .inharmonic_sample_id = inharmonic_sample_id
            End With
            _DSSPECTRAL.adsr_section.Addadsr_sectionRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_id
        End Function

        Public Function AddRow3(patch_id As System.Int32, adsr_section_id As System.Int32, flag_active As System.Int32, end_time_ms As System.Int32, end_time_ms_keyscale_upper As System.Single, end_time_ms_keyscale_lower As System.Single, inharmonic_sample_playback_mode_id As System.Int32, inharmonic_sample_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.adsr_sectionRow = _DSSPECTRAL.adsr_section.Newadsr_sectionRow
            With R
                .patch_id = patch_id
                .adsr_section_id = adsr_section_id
                .flag_active = flag_active
                .end_time_ms = end_time_ms
                .end_time_ms_keyscale_upper = end_time_ms_keyscale_upper
                .end_time_ms_keyscale_lower = end_time_ms_keyscale_lower
                .inharmonic_sample_playback_mode_id = inharmonic_sample_playback_mode_id
                .inharmonic_sample_id = inharmonic_sample_id
            End With
            _DSSPECTRAL.adsr_section.Addadsr_sectionRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_id
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function inharmonic_sample_playback_mode_id_ForeignKeyUsed(inharmonic_sample_playback_mode_id) As Boolean
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select("inharmonic_sample_playback_mode_id = " & inharmonic_sample_playback_mode_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function inharmonic_sample_id_ForeignKeyUsed(inharmonic_sample_id) As Boolean
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select("inharmonic_sample_id = " & inharmonic_sample_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select("adsr_section_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_id As Integer, adsr_section_id As Integer) As DataSet_Spectral.adsr_sectionRow
            Return _DSSPECTRAL.adsr_section.FindBypatch_idadsr_section_id(patch_id, adsr_section_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.adsr_section_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.adsr_sectionRow
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("adsr_section", _CurrentRow.adsr_section_id)
        End Function

        Public Sub DeleteRow(patch_id As Integer, adsr_section_id As Integer)
            Dim R As DataSet_Spectral.adsr_sectionRow = GetRow(patch_id, adsr_section_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_section_envelope_config.DeleteRows("patch_id = " & patch_id & " AND " & "adsr_section_id = " & adsr_section_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.adsr_sectionRow = GetRow(CurrentRow.patch_id, CurrentRow.adsr_section_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_section_envelope_config.DeleteRows("patch_id = " & R.patch_id & " AND " & "adsr_section_id = " & R.adsr_section_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.adsr_sectionRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.adsr_sectionRow In RowsToDelete
                DeleteRow(R.patch_id, R.adsr_section_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .adsr_section_id = DGV.CurrentRow.Cells("adsr_section_id").Value
                    .flag_active = DGV.CurrentRow.Cells("flag_active").Value
                    .end_time_ms = DGV.CurrentRow.Cells("end_time_ms").Value
                    .end_time_ms_keyscale_upper = DGV.CurrentRow.Cells("end_time_ms_keyscale_upper").Value
                    .end_time_ms_keyscale_lower = DGV.CurrentRow.Cells("end_time_ms_keyscale_lower").Value
                    .inharmonic_sample_playback_mode_id = DGV.CurrentRow.Cells("inharmonic_sample_playback_mode_id").Value
                    .inharmonic_sample_id = DGV.CurrentRow.Cells("inharmonic_sample_id").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.adsr_sectionRow() = _DSSPECTRAL.adsr_section.Select("adsr_section_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_id = RowSet.First.patch_id
                    .adsr_section_id = RowSet.First.adsr_section_id
                    .flag_active = RowSet.First.flag_active
                    .end_time_ms = RowSet.First.end_time_ms
                    .end_time_ms_keyscale_upper = RowSet.First.end_time_ms_keyscale_upper
                    .end_time_ms_keyscale_lower = RowSet.First.end_time_ms_keyscale_lower
                    .inharmonic_sample_playback_mode_id = RowSet.First.inharmonic_sample_playback_mode_id
                    .inharmonic_sample_id = RowSet.First.inharmonic_sample_id
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetBSFilterForForeignKey_inharmonic_sample_playback_mode_id(inharmonic_sample_playback_mode_id As String)
            _Table_BindingSource.Filter = "inharmonic_sample_playback_mode_id = " & inharmonic_sample_playback_mode_id
        End Sub

        Public Sub SetBSFilterForForeignKey_inharmonic_sample_id(inharmonic_sample_id As String)
            _Table_BindingSource.Filter = "inharmonic_sample_id = " & inharmonic_sample_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
                Case "inharmonic_sample_playback_mode_id"
                    DefaultRowValues.inharmonic_sample_playback_mode_id = KeyValue
                Case "inharmonic_sample_id"
                    DefaultRowValues.inharmonic_sample_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.adsr_section_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewadsr_sectionID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.adsr_section.Compute("MAX(adsr_section_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_adsr_section_envelope_config ------------------------------"
    Public Class TableClass_adsr_section_envelope_config
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.adsr_section_envelope_configDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_id As System.Int32
            Dim adsr_section_id As System.Int32
            Dim adsr_section_envelope_config_id As System.Int32
            Dim depth_env_type_id As System.Int32
            Dim depth_env_target As System.Single
            Dim depth_env_target_keyscale_upper As System.Single
            Dim depth_env_target_keyscale_lower As System.Single
            Dim depth_env_lin_delta As System.Int32
            Dim depth_env_lin_delta_keyscale_upper As System.Single
            Dim depth_env_lin_delta_keyscale_lower As System.Single
            Dim depth_env_exp_multiplier As System.Single
            Dim depth_env_exp_multiplier_keyscale_upper As System.Single
            Dim depth_env_exp_multiplier_keyscale_lower As System.Single
        End Structure

        Public Class Default_Row_Values
            Public patch_id As System.Int32 = 0
            Public adsr_section_id As System.Int32 = 0
            Public depth_env_type_id As System.Int32 = 0
            Public depth_env_target As System.Single = 0
            Public depth_env_target_keyscale_upper As System.Single = 0
            Public depth_env_target_keyscale_lower As System.Single = 0
            Public depth_env_lin_delta As System.Int32 = 0
            Public depth_env_lin_delta_keyscale_upper As System.Single = 0
            Public depth_env_lin_delta_keyscale_lower As System.Single = 0
            Public depth_env_exp_multiplier As System.Single = 0
            Public depth_env_exp_multiplier_keyscale_upper As System.Single = 0
            Public depth_env_exp_multiplier_keyscale_lower As System.Single = 0
        End Class

        Public Structure ColNames
            Const patch_id = "patch_id"
            Const adsr_section_id = "adsr_section_id"
            Const adsr_section_envelope_config_id = "adsr_section_envelope_config_id"
            Const depth_env_type_id = "depth_env_type_id"
            Const depth_env_target = "depth_env_target"
            Const depth_env_target_keyscale_upper = "depth_env_target_keyscale_upper"
            Const depth_env_target_keyscale_lower = "depth_env_target_keyscale_lower"
            Const depth_env_lin_delta = "depth_env_lin_delta"
            Const depth_env_lin_delta_keyscale_upper = "depth_env_lin_delta_keyscale_upper"
            Const depth_env_lin_delta_keyscale_lower = "depth_env_lin_delta_keyscale_lower"
            Const depth_env_exp_multiplier = "depth_env_exp_multiplier"
            Const depth_env_exp_multiplier_keyscale_upper = "depth_env_exp_multiplier_keyscale_upper"
            Const depth_env_exp_multiplier_keyscale_lower = "depth_env_exp_multiplier_keyscale_lower"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "adsr_section_envelope_config"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.adsr_section_envelope_configDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.adsr_section_envelope_config
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.adsr_section_envelope_config.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.adsr_section_envelope_configRow = _DSSPECTRAL.adsr_section_envelope_config.Newadsr_section_envelope_configRow
            With R
                .adsr_section_envelope_config_id = GetNewadsr_section_envelope_configID()
                .patch_id = _DefaultRowValues.patch_id
                .adsr_section_id = _DefaultRowValues.adsr_section_id
                .depth_env_type_id = _DefaultRowValues.depth_env_type_id
                .depth_env_target = _DefaultRowValues.depth_env_target
                .depth_env_target_keyscale_upper = _DefaultRowValues.depth_env_target_keyscale_upper
                .depth_env_target_keyscale_lower = _DefaultRowValues.depth_env_target_keyscale_lower
                .depth_env_lin_delta = _DefaultRowValues.depth_env_lin_delta
                .depth_env_lin_delta_keyscale_upper = _DefaultRowValues.depth_env_lin_delta_keyscale_upper
                .depth_env_lin_delta_keyscale_lower = _DefaultRowValues.depth_env_lin_delta_keyscale_lower
                .depth_env_exp_multiplier = _DefaultRowValues.depth_env_exp_multiplier
                .depth_env_exp_multiplier_keyscale_upper = _DefaultRowValues.depth_env_exp_multiplier_keyscale_upper
                .depth_env_exp_multiplier_keyscale_lower = _DefaultRowValues.depth_env_exp_multiplier_keyscale_lower
            End With
            _DSSPECTRAL.adsr_section_envelope_config.Addadsr_section_envelope_configRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_envelope_config_id
        End Function

        Public Function AddRow2(patch_id As System.Int32, adsr_section_id As System.Int32, depth_env_type_id As System.Int32, depth_env_target As System.Single, depth_env_target_keyscale_upper As System.Single, depth_env_target_keyscale_lower As System.Single, depth_env_lin_delta As System.Int32, depth_env_lin_delta_keyscale_upper As System.Single, depth_env_lin_delta_keyscale_lower As System.Single, depth_env_exp_multiplier As System.Single, depth_env_exp_multiplier_keyscale_upper As System.Single, depth_env_exp_multiplier_keyscale_lower As System.Single) As Integer
            Dim R As DataSet_Spectral.adsr_section_envelope_configRow = _DSSPECTRAL.adsr_section_envelope_config.Newadsr_section_envelope_configRow
            With R
                .adsr_section_envelope_config_id = GetNewadsr_section_envelope_configID()
                .patch_id = patch_id
                .adsr_section_id = adsr_section_id
                .depth_env_type_id = depth_env_type_id
                .depth_env_target = depth_env_target
                .depth_env_target_keyscale_upper = depth_env_target_keyscale_upper
                .depth_env_target_keyscale_lower = depth_env_target_keyscale_lower
                .depth_env_lin_delta = depth_env_lin_delta
                .depth_env_lin_delta_keyscale_upper = depth_env_lin_delta_keyscale_upper
                .depth_env_lin_delta_keyscale_lower = depth_env_lin_delta_keyscale_lower
                .depth_env_exp_multiplier = depth_env_exp_multiplier
                .depth_env_exp_multiplier_keyscale_upper = depth_env_exp_multiplier_keyscale_upper
                .depth_env_exp_multiplier_keyscale_lower = depth_env_exp_multiplier_keyscale_lower
            End With
            _DSSPECTRAL.adsr_section_envelope_config.Addadsr_section_envelope_configRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_envelope_config_id
        End Function

        Public Function AddRow3(patch_id As System.Int32, adsr_section_id As System.Int32, adsr_section_envelope_config_id As System.Int32, depth_env_type_id As System.Int32, depth_env_target As System.Single, depth_env_target_keyscale_upper As System.Single, depth_env_target_keyscale_lower As System.Single, depth_env_lin_delta As System.Int32, depth_env_lin_delta_keyscale_upper As System.Single, depth_env_lin_delta_keyscale_lower As System.Single, depth_env_exp_multiplier As System.Single, depth_env_exp_multiplier_keyscale_upper As System.Single, depth_env_exp_multiplier_keyscale_lower As System.Single) As Integer
            Dim R As DataSet_Spectral.adsr_section_envelope_configRow = _DSSPECTRAL.adsr_section_envelope_config.Newadsr_section_envelope_configRow
            With R
                .patch_id = patch_id
                .adsr_section_id = adsr_section_id
                .adsr_section_envelope_config_id = adsr_section_envelope_config_id
                .depth_env_type_id = depth_env_type_id
                .depth_env_target = depth_env_target
                .depth_env_target_keyscale_upper = depth_env_target_keyscale_upper
                .depth_env_target_keyscale_lower = depth_env_target_keyscale_lower
                .depth_env_lin_delta = depth_env_lin_delta
                .depth_env_lin_delta_keyscale_upper = depth_env_lin_delta_keyscale_upper
                .depth_env_lin_delta_keyscale_lower = depth_env_lin_delta_keyscale_lower
                .depth_env_exp_multiplier = depth_env_exp_multiplier
                .depth_env_exp_multiplier_keyscale_upper = depth_env_exp_multiplier_keyscale_upper
                .depth_env_exp_multiplier_keyscale_lower = depth_env_exp_multiplier_keyscale_lower
            End With
            _DSSPECTRAL.adsr_section_envelope_config.Addadsr_section_envelope_configRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_envelope_config_id
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function adsr_section_id_ForeignKeyUsed(adsr_section_id) As Boolean
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select("adsr_section_id = " & adsr_section_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function depth_env_type_id_ForeignKeyUsed(depth_env_type_id) As Boolean
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select("depth_env_type_id = " & depth_env_type_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select("adsr_section_envelope_config_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_id As Integer, adsr_section_id As Integer, adsr_section_envelope_config_id As Integer) As DataSet_Spectral.adsr_section_envelope_configRow
            Return _DSSPECTRAL.adsr_section_envelope_config.FindBypatch_idadsr_section_idadsr_section_envelope_config_id(patch_id, adsr_section_id, adsr_section_envelope_config_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.adsr_section_envelope_config_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.adsr_section_envelope_configRow
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("adsr_section_envelope_config", _CurrentRow.adsr_section_envelope_config_id)
        End Function

        Public Sub DeleteRow(patch_id As Integer, adsr_section_id As Integer, adsr_section_envelope_config_id As Integer)
            Dim R As DataSet_Spectral.adsr_section_envelope_configRow = GetRow(patch_id, adsr_section_id, adsr_section_envelope_config_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.adsr_section_envelope_configRow = GetRow(CurrentRow.patch_id, CurrentRow.adsr_section_id, CurrentRow.adsr_section_envelope_config_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.adsr_section_envelope_configRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.adsr_section_envelope_configRow In RowsToDelete
                DeleteRow(R.patch_id, R.adsr_section_id, R.adsr_section_envelope_config_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .adsr_section_id = DGV.CurrentRow.Cells("adsr_section_id").Value
                    .adsr_section_envelope_config_id = DGV.CurrentRow.Cells("adsr_section_envelope_config_id").Value
                    .depth_env_type_id = DGV.CurrentRow.Cells("depth_env_type_id").Value
                    .depth_env_target = DGV.CurrentRow.Cells("depth_env_target").Value
                    .depth_env_target_keyscale_upper = DGV.CurrentRow.Cells("depth_env_target_keyscale_upper").Value
                    .depth_env_target_keyscale_lower = DGV.CurrentRow.Cells("depth_env_target_keyscale_lower").Value
                    .depth_env_lin_delta = DGV.CurrentRow.Cells("depth_env_lin_delta").Value
                    .depth_env_lin_delta_keyscale_upper = DGV.CurrentRow.Cells("depth_env_lin_delta_keyscale_upper").Value
                    .depth_env_lin_delta_keyscale_lower = DGV.CurrentRow.Cells("depth_env_lin_delta_keyscale_lower").Value
                    .depth_env_exp_multiplier = DGV.CurrentRow.Cells("depth_env_exp_multiplier").Value
                    .depth_env_exp_multiplier_keyscale_upper = DGV.CurrentRow.Cells("depth_env_exp_multiplier_keyscale_upper").Value
                    .depth_env_exp_multiplier_keyscale_lower = DGV.CurrentRow.Cells("depth_env_exp_multiplier_keyscale_lower").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.adsr_section_envelope_configRow() = _DSSPECTRAL.adsr_section_envelope_config.Select("adsr_section_envelope_config_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_id = RowSet.First.patch_id
                    .adsr_section_id = RowSet.First.adsr_section_id
                    .adsr_section_envelope_config_id = RowSet.First.adsr_section_envelope_config_id
                    .depth_env_type_id = RowSet.First.depth_env_type_id
                    .depth_env_target = RowSet.First.depth_env_target
                    .depth_env_target_keyscale_upper = RowSet.First.depth_env_target_keyscale_upper
                    .depth_env_target_keyscale_lower = RowSet.First.depth_env_target_keyscale_lower
                    .depth_env_lin_delta = RowSet.First.depth_env_lin_delta
                    .depth_env_lin_delta_keyscale_upper = RowSet.First.depth_env_lin_delta_keyscale_upper
                    .depth_env_lin_delta_keyscale_lower = RowSet.First.depth_env_lin_delta_keyscale_lower
                    .depth_env_exp_multiplier = RowSet.First.depth_env_exp_multiplier
                    .depth_env_exp_multiplier_keyscale_upper = RowSet.First.depth_env_exp_multiplier_keyscale_upper
                    .depth_env_exp_multiplier_keyscale_lower = RowSet.First.depth_env_exp_multiplier_keyscale_lower
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetBSFilterForForeignKey_adsr_section_id(adsr_section_id As String)
            _Table_BindingSource.Filter = "adsr_section_id = " & adsr_section_id
        End Sub

        Public Sub SetBSFilterForForeignKey_depth_env_type_id(depth_env_type_id As String)
            _Table_BindingSource.Filter = "depth_env_type_id = " & depth_env_type_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
                Case "adsr_section_id"
                    DefaultRowValues.adsr_section_id = KeyValue
                Case "depth_env_type_id"
                    DefaultRowValues.depth_env_type_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.adsr_section_envelope_config_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewadsr_section_envelope_configID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.adsr_section_envelope_config.Compute("MAX(adsr_section_envelope_config_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_biquad_eq ------------------------------"
    Public Class TableClass_biquad_eq
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.biquad_eqDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_id As System.Int32
            Dim biquad_eq_id As System.Int32
            Dim filter_type_id As System.Int32
            Dim fc As System.Single
            Dim q As System.Single
            Dim peak_gain As System.Single
        End Structure

        Public Class Default_Row_Values
            Public patch_id As System.Int32 = 0
            Public filter_type_id As System.Int32 = 0
            Public fc As System.Single = 0
            Public q As System.Single = 0
            Public peak_gain As System.Single = 0
        End Class

        Public Structure ColNames
            Const patch_id = "patch_id"
            Const biquad_eq_id = "biquad_eq_id"
            Const filter_type_id = "filter_type_id"
            Const fc = "fc"
            Const q = "q"
            Const peak_gain = "peak_gain"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "biquad_eq"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.biquad_eqDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.biquad_eq
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.biquad_eq.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.biquad_eqRow = _DSSPECTRAL.biquad_eq.Newbiquad_eqRow
            With R
                .biquad_eq_id = GetNewbiquad_eqID()
                .patch_id = _DefaultRowValues.patch_id
                .filter_type_id = _DefaultRowValues.filter_type_id
                .fc = _DefaultRowValues.fc
                .q = _DefaultRowValues.q
                .peak_gain = _DefaultRowValues.peak_gain
            End With
            _DSSPECTRAL.biquad_eq.Addbiquad_eqRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.biquad_eq_id
        End Function

        Public Function AddRow2(patch_id As System.Int32, filter_type_id As System.Int32, fc As System.Single, q As System.Single, peak_gain As System.Single) As Integer
            Dim R As DataSet_Spectral.biquad_eqRow = _DSSPECTRAL.biquad_eq.Newbiquad_eqRow
            With R
                .biquad_eq_id = GetNewbiquad_eqID()
                .patch_id = patch_id
                .filter_type_id = filter_type_id
                .fc = fc
                .q = q
                .peak_gain = peak_gain
            End With
            _DSSPECTRAL.biquad_eq.Addbiquad_eqRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.biquad_eq_id
        End Function

        Public Function AddRow3(patch_id As System.Int32, biquad_eq_id As System.Int32, filter_type_id As System.Int32, fc As System.Single, q As System.Single, peak_gain As System.Single) As Integer
            Dim R As DataSet_Spectral.biquad_eqRow = _DSSPECTRAL.biquad_eq.Newbiquad_eqRow
            With R
                .patch_id = patch_id
                .biquad_eq_id = biquad_eq_id
                .filter_type_id = filter_type_id
                .fc = fc
                .q = q
                .peak_gain = peak_gain
            End With
            _DSSPECTRAL.biquad_eq.Addbiquad_eqRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.biquad_eq_id
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.biquad_eqRow() = _DSSPECTRAL.biquad_eq.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function filter_type_id_ForeignKeyUsed(filter_type_id) As Boolean
            Dim RowSet As DataSet_Spectral.biquad_eqRow() = _DSSPECTRAL.biquad_eq.Select("filter_type_id = " & filter_type_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.biquad_eqRow() = _DSSPECTRAL.biquad_eq.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.biquad_eqRow() = _DSSPECTRAL.biquad_eq.Select("biquad_eq_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_id As Integer, biquad_eq_id As Integer) As DataSet_Spectral.biquad_eqRow
            Return _DSSPECTRAL.biquad_eq.FindBypatch_idbiquad_eq_id(patch_id, biquad_eq_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.biquad_eqRow() = _DSSPECTRAL.biquad_eq.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.biquad_eq_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.biquad_eqRow
            Dim RowSet As DataSet_Spectral.biquad_eqRow() = _DSSPECTRAL.biquad_eq.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("biquad_eq", _CurrentRow.biquad_eq_id)
        End Function

        Public Sub DeleteRow(patch_id As Integer, biquad_eq_id As Integer)
            Dim R As DataSet_Spectral.biquad_eqRow = GetRow(patch_id, biquad_eq_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.biquad_eqRow = GetRow(CurrentRow.patch_id, CurrentRow.biquad_eq_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.biquad_eqRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.biquad_eqRow In RowsToDelete
                DeleteRow(R.patch_id, R.biquad_eq_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .biquad_eq_id = DGV.CurrentRow.Cells("biquad_eq_id").Value
                    .filter_type_id = DGV.CurrentRow.Cells("filter_type_id").Value
                    .fc = DGV.CurrentRow.Cells("fc").Value
                    .q = DGV.CurrentRow.Cells("q").Value
                    .peak_gain = DGV.CurrentRow.Cells("peak_gain").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.biquad_eqRow() = _DSSPECTRAL.biquad_eq.Select("biquad_eq_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_id = RowSet.First.patch_id
                    .biquad_eq_id = RowSet.First.biquad_eq_id
                    .filter_type_id = RowSet.First.filter_type_id
                    .fc = RowSet.First.fc
                    .q = RowSet.First.q
                    .peak_gain = RowSet.First.peak_gain
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetBSFilterForForeignKey_filter_type_id(filter_type_id As String)
            _Table_BindingSource.Filter = "filter_type_id = " & filter_type_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
                Case "filter_type_id"
                    DefaultRowValues.filter_type_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.biquad_eq_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewbiquad_eqID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.biquad_eq.Compute("MAX(biquad_eq_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_biquad_eq_calculated ------------------------------"
    Public Class TableClass_biquad_eq_calculated
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.biquad_eq_calculatedDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_id As System.Int32
            Dim biquad_eq_calculated_id As System.Int32
            Dim a0 As System.Single
            Dim a1 As System.Single
            Dim a2 As System.Single
            Dim b1 As System.Single
            Dim b2 As System.Single
        End Structure

        Public Class Default_Row_Values
            Public patch_id As System.Int32 = 0
            Public a0 As System.Single = 0
            Public a1 As System.Single = 0
            Public a2 As System.Single = 0
            Public b1 As System.Single = 0
            Public b2 As System.Single = 0
        End Class

        Public Structure ColNames
            Const patch_id = "patch_id"
            Const biquad_eq_calculated_id = "biquad_eq_calculated_id"
            Const a0 = "a0"
            Const a1 = "a1"
            Const a2 = "a2"
            Const b1 = "b1"
            Const b2 = "b2"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "biquad_eq_calculated"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.biquad_eq_calculatedDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.biquad_eq_calculated
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.biquad_eq_calculated.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.biquad_eq_calculatedRow = _DSSPECTRAL.biquad_eq_calculated.Newbiquad_eq_calculatedRow
            With R
                .biquad_eq_calculated_id = GetNewbiquad_eq_calculatedID()
                .patch_id = _DefaultRowValues.patch_id
                .a0 = _DefaultRowValues.a0
                .a1 = _DefaultRowValues.a1
                .a2 = _DefaultRowValues.a2
                .b1 = _DefaultRowValues.b1
                .b2 = _DefaultRowValues.b2
            End With
            _DSSPECTRAL.biquad_eq_calculated.Addbiquad_eq_calculatedRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.biquad_eq_calculated_id
        End Function

        Public Function AddRow2(patch_id As System.Int32, a0 As System.Single, a1 As System.Single, a2 As System.Single, b1 As System.Single, b2 As System.Single) As Integer
            Dim R As DataSet_Spectral.biquad_eq_calculatedRow = _DSSPECTRAL.biquad_eq_calculated.Newbiquad_eq_calculatedRow
            With R
                .biquad_eq_calculated_id = GetNewbiquad_eq_calculatedID()
                .patch_id = patch_id
                .a0 = a0
                .a1 = a1
                .a2 = a2
                .b1 = b1
                .b2 = b2
            End With
            _DSSPECTRAL.biquad_eq_calculated.Addbiquad_eq_calculatedRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.biquad_eq_calculated_id
        End Function

        Public Function AddRow3(patch_id As System.Int32, biquad_eq_calculated_id As System.Int32, a0 As System.Single, a1 As System.Single, a2 As System.Single, b1 As System.Single, b2 As System.Single) As Integer
            Dim R As DataSet_Spectral.biquad_eq_calculatedRow = _DSSPECTRAL.biquad_eq_calculated.Newbiquad_eq_calculatedRow
            With R
                .patch_id = patch_id
                .biquad_eq_calculated_id = biquad_eq_calculated_id
                .a0 = a0
                .a1 = a1
                .a2 = a2
                .b1 = b1
                .b2 = b2
            End With
            _DSSPECTRAL.biquad_eq_calculated.Addbiquad_eq_calculatedRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.biquad_eq_calculated_id
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.biquad_eq_calculatedRow() = _DSSPECTRAL.biquad_eq_calculated.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.biquad_eq_calculatedRow() = _DSSPECTRAL.biquad_eq_calculated.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.biquad_eq_calculatedRow() = _DSSPECTRAL.biquad_eq_calculated.Select("biquad_eq_calculated_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_id As Integer, biquad_eq_calculated_id As Integer) As DataSet_Spectral.biquad_eq_calculatedRow
            Return _DSSPECTRAL.biquad_eq_calculated.FindBypatch_idbiquad_eq_calculated_id(patch_id, biquad_eq_calculated_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.biquad_eq_calculatedRow() = _DSSPECTRAL.biquad_eq_calculated.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.biquad_eq_calculated_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.biquad_eq_calculatedRow
            Dim RowSet As DataSet_Spectral.biquad_eq_calculatedRow() = _DSSPECTRAL.biquad_eq_calculated.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("biquad_eq_calculated", _CurrentRow.biquad_eq_calculated_id)
        End Function

        Public Sub DeleteRow(patch_id As Integer, biquad_eq_calculated_id As Integer)
            Dim R As DataSet_Spectral.biquad_eq_calculatedRow = GetRow(patch_id, biquad_eq_calculated_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.biquad_eq_calculatedRow = GetRow(CurrentRow.patch_id, CurrentRow.biquad_eq_calculated_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.biquad_eq_calculatedRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.biquad_eq_calculatedRow In RowsToDelete
                DeleteRow(R.patch_id, R.biquad_eq_calculated_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .biquad_eq_calculated_id = DGV.CurrentRow.Cells("biquad_eq_calculated_id").Value
                    .a0 = DGV.CurrentRow.Cells("a0").Value
                    .a1 = DGV.CurrentRow.Cells("a1").Value
                    .a2 = DGV.CurrentRow.Cells("a2").Value
                    .b1 = DGV.CurrentRow.Cells("b1").Value
                    .b2 = DGV.CurrentRow.Cells("b2").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.biquad_eq_calculatedRow() = _DSSPECTRAL.biquad_eq_calculated.Select("biquad_eq_calculated_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_id = RowSet.First.patch_id
                    .biquad_eq_calculated_id = RowSet.First.biquad_eq_calculated_id
                    .a0 = RowSet.First.a0
                    .a1 = RowSet.First.a1
                    .a2 = RowSet.First.a2
                    .b1 = RowSet.First.b1
                    .b2 = RowSet.First.b2
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.biquad_eq_calculated_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewbiquad_eq_calculatedID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.biquad_eq_calculated.Compute("MAX(biquad_eq_calculated_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_body_resonance_filter ------------------------------"
    Public Class TableClass_body_resonance_filter
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.body_resonance_filterDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim body_resonance_filter_id As System.Int32
            Dim body_resonance_filter_guid8 As System.String
            Dim body_resonance_filter_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public body_resonance_filter_guid8 As System.String = ""
            Public body_resonance_filter_name As System.String = ""
        End Class

        Public Structure ColNames
            Const body_resonance_filter_id = "body_resonance_filter_id"
            Const body_resonance_filter_guid8 = "body_resonance_filter_guid8"
            Const body_resonance_filter_name = "body_resonance_filter_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "body_resonance_filter"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.body_resonance_filterDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.body_resonance_filter
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.body_resonance_filter.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.body_resonance_filterRow = _DSSPECTRAL.body_resonance_filter.Newbody_resonance_filterRow
            With R
                .body_resonance_filter_id = GetNewbody_resonance_filterID()
                If _DefaultRowValues.body_resonance_filter_guid8 IsNot Nothing Then .body_resonance_filter_guid8 = _DefaultRowValues.body_resonance_filter_guid8
                If _DefaultRowValues.body_resonance_filter_name IsNot Nothing Then .body_resonance_filter_name = _DefaultRowValues.body_resonance_filter_name
            End With
            _DSSPECTRAL.body_resonance_filter.Addbody_resonance_filterRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.body_resonance_filter_id
        End Function

        Public Function AddRow2(body_resonance_filter_guid8 As System.String, body_resonance_filter_name As System.String) As Integer
            Dim R As DataSet_Spectral.body_resonance_filterRow = _DSSPECTRAL.body_resonance_filter.Newbody_resonance_filterRow
            With R
                .body_resonance_filter_id = GetNewbody_resonance_filterID()
                .body_resonance_filter_guid8 = body_resonance_filter_guid8
                .body_resonance_filter_name = body_resonance_filter_name
            End With
            _DSSPECTRAL.body_resonance_filter.Addbody_resonance_filterRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.body_resonance_filter_id
        End Function

        Public Function AddRow3(body_resonance_filter_id As System.Int32, body_resonance_filter_guid8 As System.String, body_resonance_filter_name As System.String) As Integer
            Dim R As DataSet_Spectral.body_resonance_filterRow = _DSSPECTRAL.body_resonance_filter.Newbody_resonance_filterRow
            With R
                .body_resonance_filter_id = body_resonance_filter_id
                .body_resonance_filter_guid8 = body_resonance_filter_guid8
                .body_resonance_filter_name = body_resonance_filter_name
            End With
            _DSSPECTRAL.body_resonance_filter.Addbody_resonance_filterRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.body_resonance_filter_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.body_resonance_filterRow() = _DSSPECTRAL.body_resonance_filter.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.body_resonance_filterRow() = _DSSPECTRAL.body_resonance_filter.Select("body_resonance_filter_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(body_resonance_filter_name As String) As DataSet_Spectral.body_resonance_filterRow
            For Each r As DataSet_Spectral.body_resonance_filterRow In DT.Rows
                If r.body_resonance_filter_name = body_resonance_filter_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(body_resonance_filter_id As Integer) As DataSet_Spectral.body_resonance_filterRow
            Return _DSSPECTRAL.body_resonance_filter.FindBybody_resonance_filter_id(body_resonance_filter_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.body_resonance_filterRow() = _DSSPECTRAL.body_resonance_filter.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.body_resonance_filter_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.body_resonance_filterRow
            Dim RowSet As DataSet_Spectral.body_resonance_filterRow() = _DSSPECTRAL.body_resonance_filter.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("body_resonance_filter", _CurrentRow.body_resonance_filter_id)
        End Function

        Public Sub DeleteRow(body_resonance_filter_id As Integer)
            Dim R As DataSet_Spectral.body_resonance_filterRow = GetRow(body_resonance_filter_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_body_resonance_filter_band.DeleteRows("body_resonance_filter_id = " & body_resonance_filter_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.body_resonance_filterRow = GetRow(CurrentRow.body_resonance_filter_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_body_resonance_filter_band.DeleteRows("body_resonance_filter_id = " & R.body_resonance_filter_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.body_resonance_filterRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.body_resonance_filterRow In RowsToDelete
                DeleteRow(R.body_resonance_filter_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .body_resonance_filter_id = DGV.CurrentRow.Cells("body_resonance_filter_id").Value
                    .body_resonance_filter_guid8 = DGV.CurrentRow.Cells("body_resonance_filter_guid8").Value.ToString
                    .body_resonance_filter_name = DGV.CurrentRow.Cells("body_resonance_filter_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.body_resonance_filterRow() = _DSSPECTRAL.body_resonance_filter.Select("body_resonance_filter_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .body_resonance_filter_id = RowSet.First.body_resonance_filter_id
                    .body_resonance_filter_guid8 = RowSet.First.body_resonance_filter_guid8
                    .body_resonance_filter_name = RowSet.First.body_resonance_filter_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.body_resonance_filter_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewbody_resonance_filterID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.body_resonance_filter.Compute("MAX(body_resonance_filter_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_body_resonance_filter_band ------------------------------"
    Public Class TableClass_body_resonance_filter_band
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.body_resonance_filter_bandDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim body_resonance_filter_id As System.Int32
            Dim body_resonance_filter_band_id As System.Int32
            Dim level As System.Int32
            Dim slope As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public body_resonance_filter_id As System.Int32 = 0
            Public level As System.Int32 = 0
            Public slope As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const body_resonance_filter_id = "body_resonance_filter_id"
            Const body_resonance_filter_band_id = "body_resonance_filter_band_id"
            Const level = "level"
            Const slope = "slope"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "body_resonance_filter_band"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.body_resonance_filter_bandDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.body_resonance_filter_band
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.body_resonance_filter_band.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.body_resonance_filter_bandRow = _DSSPECTRAL.body_resonance_filter_band.Newbody_resonance_filter_bandRow
            With R
                .body_resonance_filter_band_id = GetNewbody_resonance_filter_bandID()
                .body_resonance_filter_id = _DefaultRowValues.body_resonance_filter_id
                .level = _DefaultRowValues.level
                .slope = _DefaultRowValues.slope
            End With
            _DSSPECTRAL.body_resonance_filter_band.Addbody_resonance_filter_bandRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.body_resonance_filter_band_id
        End Function

        Public Function AddRow2(body_resonance_filter_id As System.Int32, level As System.Int32, slope As System.Int32) As Integer
            Dim R As DataSet_Spectral.body_resonance_filter_bandRow = _DSSPECTRAL.body_resonance_filter_band.Newbody_resonance_filter_bandRow
            With R
                .body_resonance_filter_band_id = GetNewbody_resonance_filter_bandID()
                .body_resonance_filter_id = body_resonance_filter_id
                .level = level
                .slope = slope
            End With
            _DSSPECTRAL.body_resonance_filter_band.Addbody_resonance_filter_bandRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.body_resonance_filter_band_id
        End Function

        Public Function AddRow3(body_resonance_filter_id As System.Int32, body_resonance_filter_band_id As System.Int32, level As System.Int32, slope As System.Int32) As Integer
            Dim R As DataSet_Spectral.body_resonance_filter_bandRow = _DSSPECTRAL.body_resonance_filter_band.Newbody_resonance_filter_bandRow
            With R
                .body_resonance_filter_id = body_resonance_filter_id
                .body_resonance_filter_band_id = body_resonance_filter_band_id
                .level = level
                .slope = slope
            End With
            _DSSPECTRAL.body_resonance_filter_band.Addbody_resonance_filter_bandRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.body_resonance_filter_band_id
        End Function

        Public Function body_resonance_filter_id_ForeignKeyUsed(body_resonance_filter_id) As Boolean
            Dim RowSet As DataSet_Spectral.body_resonance_filter_bandRow() = _DSSPECTRAL.body_resonance_filter_band.Select("body_resonance_filter_id = " & body_resonance_filter_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.body_resonance_filter_bandRow() = _DSSPECTRAL.body_resonance_filter_band.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.body_resonance_filter_bandRow() = _DSSPECTRAL.body_resonance_filter_band.Select("body_resonance_filter_band_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(body_resonance_filter_id As Integer, body_resonance_filter_band_id As Integer) As DataSet_Spectral.body_resonance_filter_bandRow
            Return _DSSPECTRAL.body_resonance_filter_band.FindBybody_resonance_filter_idbody_resonance_filter_band_id(body_resonance_filter_id, body_resonance_filter_band_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.body_resonance_filter_bandRow() = _DSSPECTRAL.body_resonance_filter_band.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.body_resonance_filter_band_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.body_resonance_filter_bandRow
            Dim RowSet As DataSet_Spectral.body_resonance_filter_bandRow() = _DSSPECTRAL.body_resonance_filter_band.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("body_resonance_filter_band", _CurrentRow.body_resonance_filter_band_id)
        End Function

        Public Sub DeleteRow(body_resonance_filter_id As Integer, body_resonance_filter_band_id As Integer)
            Dim R As DataSet_Spectral.body_resonance_filter_bandRow = GetRow(body_resonance_filter_id, body_resonance_filter_band_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.body_resonance_filter_bandRow = GetRow(CurrentRow.body_resonance_filter_id, CurrentRow.body_resonance_filter_band_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.body_resonance_filter_bandRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.body_resonance_filter_bandRow In RowsToDelete
                DeleteRow(R.body_resonance_filter_id, R.body_resonance_filter_band_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .body_resonance_filter_id = DGV.CurrentRow.Cells("body_resonance_filter_id").Value
                    .body_resonance_filter_band_id = DGV.CurrentRow.Cells("body_resonance_filter_band_id").Value
                    .level = DGV.CurrentRow.Cells("level").Value
                    .slope = DGV.CurrentRow.Cells("slope").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.body_resonance_filter_bandRow() = _DSSPECTRAL.body_resonance_filter_band.Select("body_resonance_filter_band_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .body_resonance_filter_id = RowSet.First.body_resonance_filter_id
                    .body_resonance_filter_band_id = RowSet.First.body_resonance_filter_band_id
                    .level = RowSet.First.level
                    .slope = RowSet.First.slope
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_body_resonance_filter_id(body_resonance_filter_id As String)
            _Table_BindingSource.Filter = "body_resonance_filter_id = " & body_resonance_filter_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "body_resonance_filter_id"
                    DefaultRowValues.body_resonance_filter_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.body_resonance_filter_band_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewbody_resonance_filter_bandID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.body_resonance_filter_band.Compute("MAX(body_resonance_filter_band_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_envelope_control ------------------------------"
    Public Class TableClass_envelope_control
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.envelope_controlDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_id As System.Int32
            Dim envelope_control_id As System.Int32
            Dim depth_initial_level As System.Single
            Dim gain_cc_source As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_id As System.Int32 = 0
            Public depth_initial_level As System.Single = 0
            Public gain_cc_source As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_id = "patch_id"
            Const envelope_control_id = "envelope_control_id"
            Const depth_initial_level = "depth_initial_level"
            Const gain_cc_source = "gain_cc_source"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "envelope_control"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.envelope_controlDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.envelope_control
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.envelope_control.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.envelope_controlRow = _DSSPECTRAL.envelope_control.Newenvelope_controlRow
            With R
                .envelope_control_id = GetNewenvelope_controlID()
                .patch_id = _DefaultRowValues.patch_id
                .depth_initial_level = _DefaultRowValues.depth_initial_level
                .gain_cc_source = _DefaultRowValues.gain_cc_source
            End With
            _DSSPECTRAL.envelope_control.Addenvelope_controlRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_control_id
        End Function

        Public Function AddRow2(patch_id As System.Int32, depth_initial_level As System.Single, gain_cc_source As System.Int32) As Integer
            Dim R As DataSet_Spectral.envelope_controlRow = _DSSPECTRAL.envelope_control.Newenvelope_controlRow
            With R
                .envelope_control_id = GetNewenvelope_controlID()
                .patch_id = patch_id
                .depth_initial_level = depth_initial_level
                .gain_cc_source = gain_cc_source
            End With
            _DSSPECTRAL.envelope_control.Addenvelope_controlRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_control_id
        End Function

        Public Function AddRow3(patch_id As System.Int32, envelope_control_id As System.Int32, depth_initial_level As System.Single, gain_cc_source As System.Int32) As Integer
            Dim R As DataSet_Spectral.envelope_controlRow = _DSSPECTRAL.envelope_control.Newenvelope_controlRow
            With R
                .patch_id = patch_id
                .envelope_control_id = envelope_control_id
                .depth_initial_level = depth_initial_level
                .gain_cc_source = gain_cc_source
            End With
            _DSSPECTRAL.envelope_control.Addenvelope_controlRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_control_id
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.envelope_controlRow() = _DSSPECTRAL.envelope_control.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.envelope_controlRow() = _DSSPECTRAL.envelope_control.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.envelope_controlRow() = _DSSPECTRAL.envelope_control.Select("envelope_control_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_id As Integer, envelope_control_id As Integer) As DataSet_Spectral.envelope_controlRow
            Return _DSSPECTRAL.envelope_control.FindBypatch_idenvelope_control_id(patch_id, envelope_control_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.envelope_controlRow() = _DSSPECTRAL.envelope_control.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.envelope_control_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.envelope_controlRow
            Dim RowSet As DataSet_Spectral.envelope_controlRow() = _DSSPECTRAL.envelope_control.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("envelope_control", _CurrentRow.envelope_control_id)
        End Function

        Public Sub DeleteRow(patch_id As Integer, envelope_control_id As Integer)
            Dim R As DataSet_Spectral.envelope_controlRow = GetRow(patch_id, envelope_control_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.envelope_controlRow = GetRow(CurrentRow.patch_id, CurrentRow.envelope_control_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.envelope_controlRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.envelope_controlRow In RowsToDelete
                DeleteRow(R.patch_id, R.envelope_control_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .envelope_control_id = DGV.CurrentRow.Cells("envelope_control_id").Value
                    .depth_initial_level = DGV.CurrentRow.Cells("depth_initial_level").Value
                    .gain_cc_source = DGV.CurrentRow.Cells("gain_cc_source").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.envelope_controlRow() = _DSSPECTRAL.envelope_control.Select("envelope_control_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_id = RowSet.First.patch_id
                    .envelope_control_id = RowSet.First.envelope_control_id
                    .depth_initial_level = RowSet.First.depth_initial_level
                    .gain_cc_source = RowSet.First.gain_cc_source
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.envelope_control_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewenvelope_controlID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.envelope_control.Compute("MAX(envelope_control_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_lfo_envelope_config ------------------------------"
    Public Class TableClass_lfo_envelope_config
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.lfo_envelope_configDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_id As System.Int32
            Dim lfo_envelope_config_id As System.Int32
            Dim enabled As System.Int32
            Dim lfo_wave_type_id As System.Int32
            Dim default_wt_inc_q11_5 As System.Single
            Dim freq_cc_source As System.Int32
            Dim depth_cc_source As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_id As System.Int32 = 0
            Public enabled As System.Int32 = 0
            Public lfo_wave_type_id As System.Int32 = 0
            Public default_wt_inc_q11_5 As System.Single = 0
            Public freq_cc_source As System.Int32 = 0
            Public depth_cc_source As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_id = "patch_id"
            Const lfo_envelope_config_id = "lfo_envelope_config_id"
            Const enabled = "enabled"
            Const lfo_wave_type_id = "lfo_wave_type_id"
            Const default_wt_inc_q11_5 = "default_wt_inc_q11_5"
            Const freq_cc_source = "freq_cc_source"
            Const depth_cc_source = "depth_cc_source"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "lfo_envelope_config"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.lfo_envelope_configDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.lfo_envelope_config
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.lfo_envelope_config.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.lfo_envelope_configRow = _DSSPECTRAL.lfo_envelope_config.Newlfo_envelope_configRow
            With R
                .lfo_envelope_config_id = GetNewlfo_envelope_configID()
                .patch_id = _DefaultRowValues.patch_id
                .enabled = _DefaultRowValues.enabled
                .lfo_wave_type_id = _DefaultRowValues.lfo_wave_type_id
                .default_wt_inc_q11_5 = _DefaultRowValues.default_wt_inc_q11_5
                .freq_cc_source = _DefaultRowValues.freq_cc_source
                .depth_cc_source = _DefaultRowValues.depth_cc_source
            End With
            _DSSPECTRAL.lfo_envelope_config.Addlfo_envelope_configRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_envelope_config_id
        End Function

        Public Function AddRow2(patch_id As System.Int32, enabled As System.Int32, lfo_wave_type_id As System.Int32, default_wt_inc_q11_5 As System.Single, freq_cc_source As System.Int32, depth_cc_source As System.Int32) As Integer
            Dim R As DataSet_Spectral.lfo_envelope_configRow = _DSSPECTRAL.lfo_envelope_config.Newlfo_envelope_configRow
            With R
                .lfo_envelope_config_id = GetNewlfo_envelope_configID()
                .patch_id = patch_id
                .enabled = enabled
                .lfo_wave_type_id = lfo_wave_type_id
                .default_wt_inc_q11_5 = default_wt_inc_q11_5
                .freq_cc_source = freq_cc_source
                .depth_cc_source = depth_cc_source
            End With
            _DSSPECTRAL.lfo_envelope_config.Addlfo_envelope_configRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_envelope_config_id
        End Function

        Public Function AddRow3(patch_id As System.Int32, lfo_envelope_config_id As System.Int32, enabled As System.Int32, lfo_wave_type_id As System.Int32, default_wt_inc_q11_5 As System.Single, freq_cc_source As System.Int32, depth_cc_source As System.Int32) As Integer
            Dim R As DataSet_Spectral.lfo_envelope_configRow = _DSSPECTRAL.lfo_envelope_config.Newlfo_envelope_configRow
            With R
                .patch_id = patch_id
                .lfo_envelope_config_id = lfo_envelope_config_id
                .enabled = enabled
                .lfo_wave_type_id = lfo_wave_type_id
                .default_wt_inc_q11_5 = default_wt_inc_q11_5
                .freq_cc_source = freq_cc_source
                .depth_cc_source = depth_cc_source
            End With
            _DSSPECTRAL.lfo_envelope_config.Addlfo_envelope_configRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_envelope_config_id
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.lfo_envelope_configRow() = _DSSPECTRAL.lfo_envelope_config.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function lfo_wave_type_id_ForeignKeyUsed(lfo_wave_type_id) As Boolean
            Dim RowSet As DataSet_Spectral.lfo_envelope_configRow() = _DSSPECTRAL.lfo_envelope_config.Select("lfo_wave_type_id = " & lfo_wave_type_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.lfo_envelope_configRow() = _DSSPECTRAL.lfo_envelope_config.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.lfo_envelope_configRow() = _DSSPECTRAL.lfo_envelope_config.Select("lfo_envelope_config_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_id As Integer, lfo_envelope_config_id As Integer) As DataSet_Spectral.lfo_envelope_configRow
            Return _DSSPECTRAL.lfo_envelope_config.FindBypatch_idlfo_envelope_config_id(patch_id, lfo_envelope_config_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.lfo_envelope_configRow() = _DSSPECTRAL.lfo_envelope_config.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.lfo_envelope_config_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.lfo_envelope_configRow
            Dim RowSet As DataSet_Spectral.lfo_envelope_configRow() = _DSSPECTRAL.lfo_envelope_config.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("lfo_envelope_config", _CurrentRow.lfo_envelope_config_id)
        End Function

        Public Sub DeleteRow(patch_id As Integer, lfo_envelope_config_id As Integer)
            Dim R As DataSet_Spectral.lfo_envelope_configRow = GetRow(patch_id, lfo_envelope_config_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.lfo_envelope_configRow = GetRow(CurrentRow.patch_id, CurrentRow.lfo_envelope_config_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.lfo_envelope_configRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.lfo_envelope_configRow In RowsToDelete
                DeleteRow(R.patch_id, R.lfo_envelope_config_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .lfo_envelope_config_id = DGV.CurrentRow.Cells("lfo_envelope_config_id").Value
                    .enabled = DGV.CurrentRow.Cells("enabled").Value
                    .lfo_wave_type_id = DGV.CurrentRow.Cells("lfo_wave_type_id").Value
                    .default_wt_inc_q11_5 = DGV.CurrentRow.Cells("default_wt_inc_q11_5").Value
                    .freq_cc_source = DGV.CurrentRow.Cells("freq_cc_source").Value
                    .depth_cc_source = DGV.CurrentRow.Cells("depth_cc_source").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.lfo_envelope_configRow() = _DSSPECTRAL.lfo_envelope_config.Select("lfo_envelope_config_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_id = RowSet.First.patch_id
                    .lfo_envelope_config_id = RowSet.First.lfo_envelope_config_id
                    .enabled = RowSet.First.enabled
                    .lfo_wave_type_id = RowSet.First.lfo_wave_type_id
                    .default_wt_inc_q11_5 = RowSet.First.default_wt_inc_q11_5
                    .freq_cc_source = RowSet.First.freq_cc_source
                    .depth_cc_source = RowSet.First.depth_cc_source
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetBSFilterForForeignKey_lfo_wave_type_id(lfo_wave_type_id As String)
            _Table_BindingSource.Filter = "lfo_wave_type_id = " & lfo_wave_type_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
                Case "lfo_wave_type_id"
                    DefaultRowValues.lfo_wave_type_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.lfo_envelope_config_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewlfo_envelope_configID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.lfo_envelope_config.Compute("MAX(lfo_envelope_config_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_patch ------------------------------"
    Public Class TableClass_patch
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.patchDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_id As System.Int32
            Dim patch_guid8 As System.String
            Dim patch_name As System.String
            Dim patch_type_id As System.Int32
            Dim patch_category_id As System.Int32
            Dim waveform_set_id As System.Int32
            Dim body_resonance_filter_id As System.Int32
            Dim sustain_enabled As System.Int32
            Dim pitch_bend_enabled As System.Int32
            Dim portamento_enabled As System.Int32
            Dim portamento_rate As System.Single
            Dim degree_of_regular_detuning As System.Single
            Dim degree_of_random_detuning As System.Single
            Dim degree_of_random_phase As System.Single
            Dim active_layers As System.Int32
            Dim detuning_mode_id As System.Int32
            Dim layer0_st_inc_q11_5_detune As System.Single
            Dim layer1_st_inc_q11_5_detune As System.Single
            Dim layer2_st_inc_q11_5_detune As System.Single
            Dim key_scale_split_note_id As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_guid8 As System.String = ""
            Public patch_name As System.String = ""
            Public patch_type_id As System.Int32 = 0
            Public patch_category_id As System.Int32 = 0
            Public waveform_set_id As System.Int32 = 0
            Public body_resonance_filter_id As System.Int32 = 0
            Public sustain_enabled As System.Int32 = 0
            Public pitch_bend_enabled As System.Int32 = 0
            Public portamento_enabled As System.Int32 = 0
            Public portamento_rate As System.Single = 0
            Public degree_of_regular_detuning As System.Single = 0
            Public degree_of_random_detuning As System.Single = 0
            Public degree_of_random_phase As System.Single = 0
            Public active_layers As System.Int32 = 0
            Public detuning_mode_id As System.Int32 = 0
            Public layer0_st_inc_q11_5_detune As System.Single = 0
            Public layer1_st_inc_q11_5_detune As System.Single = 0
            Public layer2_st_inc_q11_5_detune As System.Single = 0
            Public key_scale_split_note_id As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_id = "patch_id"
            Const patch_guid8 = "patch_guid8"
            Const patch_name = "patch_name"
            Const patch_type_id = "patch_type_id"
            Const patch_category_id = "patch_category_id"
            Const waveform_set_id = "waveform_set_id"
            Const body_resonance_filter_id = "body_resonance_filter_id"
            Const sustain_enabled = "sustain_enabled"
            Const pitch_bend_enabled = "pitch_bend_enabled"
            Const portamento_enabled = "portamento_enabled"
            Const portamento_rate = "portamento_rate"
            Const degree_of_regular_detuning = "degree_of_regular_detuning"
            Const degree_of_random_detuning = "degree_of_random_detuning"
            Const degree_of_random_phase = "degree_of_random_phase"
            Const active_layers = "active_layers"
            Const detuning_mode_id = "detuning_mode_id"
            Const layer0_st_inc_q11_5_detune = "layer0_st_inc_q11_5_detune"
            Const layer1_st_inc_q11_5_detune = "layer1_st_inc_q11_5_detune"
            Const layer2_st_inc_q11_5_detune = "layer2_st_inc_q11_5_detune"
            Const key_scale_split_note_id = "key_scale_split_note_id"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "patch"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.patchDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.patch
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.patch.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.patchRow = _DSSPECTRAL.patch.NewpatchRow
            With R
                .patch_id = GetNewpatchID()
                If _DefaultRowValues.patch_guid8 IsNot Nothing Then .patch_guid8 = _DefaultRowValues.patch_guid8
                If _DefaultRowValues.patch_name IsNot Nothing Then .patch_name = _DefaultRowValues.patch_name
                .patch_type_id = _DefaultRowValues.patch_type_id
                .patch_category_id = _DefaultRowValues.patch_category_id
                .waveform_set_id = _DefaultRowValues.waveform_set_id
                .body_resonance_filter_id = _DefaultRowValues.body_resonance_filter_id
                .sustain_enabled = _DefaultRowValues.sustain_enabled
                .pitch_bend_enabled = _DefaultRowValues.pitch_bend_enabled
                .portamento_enabled = _DefaultRowValues.portamento_enabled
                .portamento_rate = _DefaultRowValues.portamento_rate
                .degree_of_regular_detuning = _DefaultRowValues.degree_of_regular_detuning
                .degree_of_random_detuning = _DefaultRowValues.degree_of_random_detuning
                .degree_of_random_phase = _DefaultRowValues.degree_of_random_phase
                .active_layers = _DefaultRowValues.active_layers
                .detuning_mode_id = _DefaultRowValues.detuning_mode_id
                .layer0_st_inc_q11_5_detune = _DefaultRowValues.layer0_st_inc_q11_5_detune
                .layer1_st_inc_q11_5_detune = _DefaultRowValues.layer1_st_inc_q11_5_detune
                .layer2_st_inc_q11_5_detune = _DefaultRowValues.layer2_st_inc_q11_5_detune
                .key_scale_split_note_id = _DefaultRowValues.key_scale_split_note_id
            End With
            _DSSPECTRAL.patch.AddpatchRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_id
        End Function

        Public Function AddRow2(patch_guid8 As System.String, patch_name As System.String, patch_type_id As System.Int32, patch_category_id As System.Int32, waveform_set_id As System.Int32, body_resonance_filter_id As System.Int32, sustain_enabled As System.Int32, pitch_bend_enabled As System.Int32, portamento_enabled As System.Int32, portamento_rate As System.Single, degree_of_regular_detuning As System.Single, degree_of_random_detuning As System.Single, degree_of_random_phase As System.Single, active_layers As System.Int32, detuning_mode_id As System.Int32, layer0_st_inc_q11_5_detune As System.Single, layer1_st_inc_q11_5_detune As System.Single, layer2_st_inc_q11_5_detune As System.Single, key_scale_split_note_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.patchRow = _DSSPECTRAL.patch.NewpatchRow
            With R
                .patch_id = GetNewpatchID()
                .patch_guid8 = patch_guid8
                .patch_name = patch_name
                .patch_type_id = patch_type_id
                .patch_category_id = patch_category_id
                .waveform_set_id = waveform_set_id
                .body_resonance_filter_id = body_resonance_filter_id
                .sustain_enabled = sustain_enabled
                .pitch_bend_enabled = pitch_bend_enabled
                .portamento_enabled = portamento_enabled
                .portamento_rate = portamento_rate
                .degree_of_regular_detuning = degree_of_regular_detuning
                .degree_of_random_detuning = degree_of_random_detuning
                .degree_of_random_phase = degree_of_random_phase
                .active_layers = active_layers
                .detuning_mode_id = detuning_mode_id
                .layer0_st_inc_q11_5_detune = layer0_st_inc_q11_5_detune
                .layer1_st_inc_q11_5_detune = layer1_st_inc_q11_5_detune
                .layer2_st_inc_q11_5_detune = layer2_st_inc_q11_5_detune
                .key_scale_split_note_id = key_scale_split_note_id
            End With
            _DSSPECTRAL.patch.AddpatchRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_id
        End Function

        Public Function AddRow3(patch_id As System.Int32, patch_guid8 As System.String, patch_name As System.String, patch_type_id As System.Int32, patch_category_id As System.Int32, waveform_set_id As System.Int32, body_resonance_filter_id As System.Int32, sustain_enabled As System.Int32, pitch_bend_enabled As System.Int32, portamento_enabled As System.Int32, portamento_rate As System.Single, degree_of_regular_detuning As System.Single, degree_of_random_detuning As System.Single, degree_of_random_phase As System.Single, active_layers As System.Int32, detuning_mode_id As System.Int32, layer0_st_inc_q11_5_detune As System.Single, layer1_st_inc_q11_5_detune As System.Single, layer2_st_inc_q11_5_detune As System.Single, key_scale_split_note_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.patchRow = _DSSPECTRAL.patch.NewpatchRow
            With R
                .patch_id = patch_id
                .patch_guid8 = patch_guid8
                .patch_name = patch_name
                .patch_type_id = patch_type_id
                .patch_category_id = patch_category_id
                .waveform_set_id = waveform_set_id
                .body_resonance_filter_id = body_resonance_filter_id
                .sustain_enabled = sustain_enabled
                .pitch_bend_enabled = pitch_bend_enabled
                .portamento_enabled = portamento_enabled
                .portamento_rate = portamento_rate
                .degree_of_regular_detuning = degree_of_regular_detuning
                .degree_of_random_detuning = degree_of_random_detuning
                .degree_of_random_phase = degree_of_random_phase
                .active_layers = active_layers
                .detuning_mode_id = detuning_mode_id
                .layer0_st_inc_q11_5_detune = layer0_st_inc_q11_5_detune
                .layer1_st_inc_q11_5_detune = layer1_st_inc_q11_5_detune
                .layer2_st_inc_q11_5_detune = layer2_st_inc_q11_5_detune
                .key_scale_split_note_id = key_scale_split_note_id
            End With
            _DSSPECTRAL.patch.AddpatchRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_id
        End Function

        Public Function patch_type_id_ForeignKeyUsed(patch_type_id) As Boolean
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("patch_type_id = " & patch_type_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function patch_category_id_ForeignKeyUsed(patch_category_id) As Boolean
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("patch_category_id = " & patch_category_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function waveform_set_id_ForeignKeyUsed(waveform_set_id) As Boolean
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("waveform_set_id = " & waveform_set_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function body_resonance_filter_id_ForeignKeyUsed(body_resonance_filter_id) As Boolean
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("body_resonance_filter_id = " & body_resonance_filter_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function detuning_mode_id_ForeignKeyUsed(detuning_mode_id) As Boolean
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("detuning_mode_id = " & detuning_mode_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function key_scale_split_note_id_ForeignKeyUsed(key_scale_split_note_id) As Boolean
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("key_scale_split_note_id = " & key_scale_split_note_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("patch_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(patch_name As String) As DataSet_Spectral.patchRow
            For Each r As DataSet_Spectral.patchRow In DT.Rows
                If r.patch_name = patch_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(patch_id As Integer) As DataSet_Spectral.patchRow
            Return _DSSPECTRAL.patch.FindBypatch_id(patch_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.patch_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.patchRow
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("patch", _CurrentRow.patch_id)
        End Function

        Public Sub DeleteRow(patch_id As Integer)
            Dim R As DataSet_Spectral.patchRow = GetRow(patch_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_section.DeleteRows("patch_id = " & patch_id)
            _ParentClass.Table_adsr_section_envelope_config.DeleteRows("patch_id = " & patch_id)
            _ParentClass.Table_biquad_eq.DeleteRows("patch_id = " & patch_id)
            _ParentClass.Table_biquad_eq_calculated.DeleteRows("patch_id = " & patch_id)
            _ParentClass.Table_envelope_control.DeleteRows("patch_id = " & patch_id)
            _ParentClass.Table_lfo_envelope_config.DeleteRows("patch_id = " & patch_id)
            _ParentClass.Table_patch_set_patches.DeleteRows("patch_id = " & patch_id)
            _ParentClass.Table_performance_channel.DeleteRows("patch_id = " & patch_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.patchRow = GetRow(CurrentRow.patch_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_section.DeleteRows("patch_id = " & R.patch_id)
            _ParentClass.Table_adsr_section_envelope_config.DeleteRows("patch_id = " & R.patch_id)
            _ParentClass.Table_biquad_eq.DeleteRows("patch_id = " & R.patch_id)
            _ParentClass.Table_biquad_eq_calculated.DeleteRows("patch_id = " & R.patch_id)
            _ParentClass.Table_envelope_control.DeleteRows("patch_id = " & R.patch_id)
            _ParentClass.Table_lfo_envelope_config.DeleteRows("patch_id = " & R.patch_id)
            _ParentClass.Table_patch_set_patches.DeleteRows("patch_id = " & R.patch_id)
            _ParentClass.Table_performance_channel.DeleteRows("patch_id = " & R.patch_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.patchRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.patchRow In RowsToDelete
                DeleteRow(R.patch_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .patch_guid8 = DGV.CurrentRow.Cells("patch_guid8").Value.ToString
                    .patch_name = DGV.CurrentRow.Cells("patch_name").Value.ToString
                    .patch_type_id = DGV.CurrentRow.Cells("patch_type_id").Value
                    .patch_category_id = DGV.CurrentRow.Cells("patch_category_id").Value
                    .waveform_set_id = DGV.CurrentRow.Cells("waveform_set_id").Value
                    .body_resonance_filter_id = DGV.CurrentRow.Cells("body_resonance_filter_id").Value
                    .sustain_enabled = DGV.CurrentRow.Cells("sustain_enabled").Value
                    .pitch_bend_enabled = DGV.CurrentRow.Cells("pitch_bend_enabled").Value
                    .portamento_enabled = DGV.CurrentRow.Cells("portamento_enabled").Value
                    .portamento_rate = DGV.CurrentRow.Cells("portamento_rate").Value
                    .degree_of_regular_detuning = DGV.CurrentRow.Cells("degree_of_regular_detuning").Value
                    .degree_of_random_detuning = DGV.CurrentRow.Cells("degree_of_random_detuning").Value
                    .degree_of_random_phase = DGV.CurrentRow.Cells("degree_of_random_phase").Value
                    .active_layers = DGV.CurrentRow.Cells("active_layers").Value
                    .detuning_mode_id = DGV.CurrentRow.Cells("detuning_mode_id").Value
                    .layer0_st_inc_q11_5_detune = DGV.CurrentRow.Cells("layer0_st_inc_q11_5_detune").Value
                    .layer1_st_inc_q11_5_detune = DGV.CurrentRow.Cells("layer1_st_inc_q11_5_detune").Value
                    .layer2_st_inc_q11_5_detune = DGV.CurrentRow.Cells("layer2_st_inc_q11_5_detune").Value
                    .key_scale_split_note_id = DGV.CurrentRow.Cells("key_scale_split_note_id").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.patchRow() = _DSSPECTRAL.patch.Select("patch_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_id = RowSet.First.patch_id
                    .patch_guid8 = RowSet.First.patch_guid8
                    .patch_name = RowSet.First.patch_name
                    .patch_type_id = RowSet.First.patch_type_id
                    .patch_category_id = RowSet.First.patch_category_id
                    .waveform_set_id = RowSet.First.waveform_set_id
                    .body_resonance_filter_id = RowSet.First.body_resonance_filter_id
                    .sustain_enabled = RowSet.First.sustain_enabled
                    .pitch_bend_enabled = RowSet.First.pitch_bend_enabled
                    .portamento_enabled = RowSet.First.portamento_enabled
                    .portamento_rate = RowSet.First.portamento_rate
                    .degree_of_regular_detuning = RowSet.First.degree_of_regular_detuning
                    .degree_of_random_detuning = RowSet.First.degree_of_random_detuning
                    .degree_of_random_phase = RowSet.First.degree_of_random_phase
                    .active_layers = RowSet.First.active_layers
                    .detuning_mode_id = RowSet.First.detuning_mode_id
                    .layer0_st_inc_q11_5_detune = RowSet.First.layer0_st_inc_q11_5_detune
                    .layer1_st_inc_q11_5_detune = RowSet.First.layer1_st_inc_q11_5_detune
                    .layer2_st_inc_q11_5_detune = RowSet.First.layer2_st_inc_q11_5_detune
                    .key_scale_split_note_id = RowSet.First.key_scale_split_note_id
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_type_id(patch_type_id As String)
            _Table_BindingSource.Filter = "patch_type_id = " & patch_type_id
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_category_id(patch_category_id As String)
            _Table_BindingSource.Filter = "patch_category_id = " & patch_category_id
        End Sub

        Public Sub SetBSFilterForForeignKey_waveform_set_id(waveform_set_id As String)
            _Table_BindingSource.Filter = "waveform_set_id = " & waveform_set_id
        End Sub

        Public Sub SetBSFilterForForeignKey_body_resonance_filter_id(body_resonance_filter_id As String)
            _Table_BindingSource.Filter = "body_resonance_filter_id = " & body_resonance_filter_id
        End Sub

        Public Sub SetBSFilterForForeignKey_detuning_mode_id(detuning_mode_id As String)
            _Table_BindingSource.Filter = "detuning_mode_id = " & detuning_mode_id
        End Sub

        Public Sub SetBSFilterForForeignKey_key_scale_split_note_id(key_scale_split_note_id As String)
            _Table_BindingSource.Filter = "key_scale_split_note_id = " & key_scale_split_note_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_type_id"
                    DefaultRowValues.patch_type_id = KeyValue
                Case "patch_category_id"
                    DefaultRowValues.patch_category_id = KeyValue
                Case "waveform_set_id"
                    DefaultRowValues.waveform_set_id = KeyValue
                Case "body_resonance_filter_id"
                    DefaultRowValues.body_resonance_filter_id = KeyValue
                Case "detuning_mode_id"
                    DefaultRowValues.detuning_mode_id = KeyValue
                Case "key_scale_split_note_id"
                    DefaultRowValues.key_scale_split_note_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.patch_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewpatchID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.patch.Compute("MAX(patch_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_patch_set ------------------------------"
    Public Class TableClass_patch_set
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.patch_setDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_set_id As System.Int32
            Dim patch_set_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public patch_set_name As System.String = ""
        End Class

        Public Structure ColNames
            Const patch_set_id = "patch_set_id"
            Const patch_set_name = "patch_set_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "patch_set"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.patch_setDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.patch_set
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.patch_set.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.patch_setRow = _DSSPECTRAL.patch_set.Newpatch_setRow
            With R
                .patch_set_id = GetNewpatch_setID()
                If _DefaultRowValues.patch_set_name IsNot Nothing Then .patch_set_name = _DefaultRowValues.patch_set_name
            End With
            _DSSPECTRAL.patch_set.Addpatch_setRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_set_id
        End Function

        Public Function AddRow2(patch_set_name As System.String) As Integer
            Dim R As DataSet_Spectral.patch_setRow = _DSSPECTRAL.patch_set.Newpatch_setRow
            With R
                .patch_set_id = GetNewpatch_setID()
                .patch_set_name = patch_set_name
            End With
            _DSSPECTRAL.patch_set.Addpatch_setRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_set_id
        End Function

        Public Function AddRow3(patch_set_id As System.Int32, patch_set_name As System.String) As Integer
            Dim R As DataSet_Spectral.patch_setRow = _DSSPECTRAL.patch_set.Newpatch_setRow
            With R
                .patch_set_id = patch_set_id
                .patch_set_name = patch_set_name
            End With
            _DSSPECTRAL.patch_set.Addpatch_setRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_set_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.patch_setRow() = _DSSPECTRAL.patch_set.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.patch_setRow() = _DSSPECTRAL.patch_set.Select("patch_set_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(patch_set_name As String) As DataSet_Spectral.patch_setRow
            For Each r As DataSet_Spectral.patch_setRow In DT.Rows
                If r.patch_set_name = patch_set_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(patch_set_id As Integer) As DataSet_Spectral.patch_setRow
            Return _DSSPECTRAL.patch_set.FindBypatch_set_id(patch_set_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.patch_setRow() = _DSSPECTRAL.patch_set.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.patch_set_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.patch_setRow
            Dim RowSet As DataSet_Spectral.patch_setRow() = _DSSPECTRAL.patch_set.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("patch_set", _CurrentRow.patch_set_id)
        End Function

        Public Sub DeleteRow(patch_set_id As Integer)
            Dim R As DataSet_Spectral.patch_setRow = GetRow(patch_set_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_patch_set_patches.DeleteRows("patch_set_id = " & patch_set_id)
            _ParentClass.Table_performance.DeleteRows("patch_set_id = " & patch_set_id)
            _ParentClass.Table_performance_channel.DeleteRows("patch_set_id = " & patch_set_id)
            _ParentClass.Table_performance_processor.DeleteRows("patch_set_id = " & patch_set_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.patch_setRow = GetRow(CurrentRow.patch_set_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_patch_set_patches.DeleteRows("patch_set_id = " & R.patch_set_id)
            _ParentClass.Table_performance.DeleteRows("patch_set_id = " & R.patch_set_id)
            _ParentClass.Table_performance_channel.DeleteRows("patch_set_id = " & R.patch_set_id)
            _ParentClass.Table_performance_processor.DeleteRows("patch_set_id = " & R.patch_set_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.patch_setRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.patch_setRow In RowsToDelete
                DeleteRow(R.patch_set_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_set_id = DGV.CurrentRow.Cells("patch_set_id").Value
                    .patch_set_name = DGV.CurrentRow.Cells("patch_set_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.patch_setRow() = _DSSPECTRAL.patch_set.Select("patch_set_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_set_id = RowSet.First.patch_set_id
                    .patch_set_name = RowSet.First.patch_set_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.patch_set_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewpatch_setID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.patch_set.Compute("MAX(patch_set_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_patch_set_patches ------------------------------"
    Public Class TableClass_patch_set_patches
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.patch_set_patchesDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_set_id As System.Int32
            Dim patch_set_patches_id As System.Int32
            Dim patch_id As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_set_id As System.Int32 = 0
            Public patch_id As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_set_id = "patch_set_id"
            Const patch_set_patches_id = "patch_set_patches_id"
            Const patch_id = "patch_id"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "patch_set_patches"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.patch_set_patchesDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.patch_set_patches
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.patch_set_patches.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.patch_set_patchesRow = _DSSPECTRAL.patch_set_patches.Newpatch_set_patchesRow
            With R
                .patch_set_patches_id = GetNewpatch_set_patchesID()
                .patch_set_id = _DefaultRowValues.patch_set_id
                .patch_id = _DefaultRowValues.patch_id
            End With
            _DSSPECTRAL.patch_set_patches.Addpatch_set_patchesRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_set_patches_id
        End Function

        Public Function AddRow2(patch_set_id As System.Int32, patch_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.patch_set_patchesRow = _DSSPECTRAL.patch_set_patches.Newpatch_set_patchesRow
            With R
                .patch_set_patches_id = GetNewpatch_set_patchesID()
                .patch_set_id = patch_set_id
                .patch_id = patch_id
            End With
            _DSSPECTRAL.patch_set_patches.Addpatch_set_patchesRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_set_patches_id
        End Function

        Public Function AddRow3(patch_set_id As System.Int32, patch_set_patches_id As System.Int32, patch_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.patch_set_patchesRow = _DSSPECTRAL.patch_set_patches.Newpatch_set_patchesRow
            With R
                .patch_set_id = patch_set_id
                .patch_set_patches_id = patch_set_patches_id
                .patch_id = patch_id
            End With
            _DSSPECTRAL.patch_set_patches.Addpatch_set_patchesRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_set_patches_id
        End Function

        Public Function patch_set_id_ForeignKeyUsed(patch_set_id) As Boolean
            Dim RowSet As DataSet_Spectral.patch_set_patchesRow() = _DSSPECTRAL.patch_set_patches.Select("patch_set_id = " & patch_set_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.patch_set_patchesRow() = _DSSPECTRAL.patch_set_patches.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.patch_set_patchesRow() = _DSSPECTRAL.patch_set_patches.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.patch_set_patchesRow() = _DSSPECTRAL.patch_set_patches.Select("patch_set_patches_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_set_id As Integer, patch_set_patches_id As Integer) As DataSet_Spectral.patch_set_patchesRow
            Return _DSSPECTRAL.patch_set_patches.FindBypatch_set_idpatch_set_patches_id(patch_set_id, patch_set_patches_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.patch_set_patchesRow() = _DSSPECTRAL.patch_set_patches.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.patch_set_patches_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.patch_set_patchesRow
            Dim RowSet As DataSet_Spectral.patch_set_patchesRow() = _DSSPECTRAL.patch_set_patches.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("patch_set_patches", _CurrentRow.patch_set_patches_id)
        End Function

        Public Sub DeleteRow(patch_set_id As Integer, patch_set_patches_id As Integer)
            Dim R As DataSet_Spectral.patch_set_patchesRow = GetRow(patch_set_id, patch_set_patches_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.patch_set_patchesRow = GetRow(CurrentRow.patch_set_id, CurrentRow.patch_set_patches_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.patch_set_patchesRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.patch_set_patchesRow In RowsToDelete
                DeleteRow(R.patch_set_id, R.patch_set_patches_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_set_id = DGV.CurrentRow.Cells("patch_set_id").Value
                    .patch_set_patches_id = DGV.CurrentRow.Cells("patch_set_patches_id").Value
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.patch_set_patchesRow() = _DSSPECTRAL.patch_set_patches.Select("patch_set_patches_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_set_id = RowSet.First.patch_set_id
                    .patch_set_patches_id = RowSet.First.patch_set_patches_id
                    .patch_id = RowSet.First.patch_id
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_set_id(patch_set_id As String)
            _Table_BindingSource.Filter = "patch_set_id = " & patch_set_id
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_set_id"
                    DefaultRowValues.patch_set_id = KeyValue
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.patch_set_patches_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewpatch_set_patchesID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.patch_set_patches.Compute("MAX(patch_set_patches_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_performance ------------------------------"
    Public Class TableClass_performance
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.performanceDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_set_id As System.Int32
            Dim performance_id As System.Int32
            Dim performance_name As System.String
            Dim haas_delay_ms As System.Single
        End Structure

        Public Class Default_Row_Values
            Public patch_set_id As System.Int32 = 0
            Public performance_name As System.String = ""
            Public haas_delay_ms As System.Single = 0
        End Class

        Public Structure ColNames
            Const patch_set_id = "patch_set_id"
            Const performance_id = "performance_id"
            Const performance_name = "performance_name"
            Const haas_delay_ms = "haas_delay_ms"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "performance"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.performanceDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.performance
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.performance.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.performanceRow = _DSSPECTRAL.performance.NewperformanceRow
            With R
                .performance_id = GetNewperformanceID()
                .patch_set_id = _DefaultRowValues.patch_set_id
                If _DefaultRowValues.performance_name IsNot Nothing Then .performance_name = _DefaultRowValues.performance_name
                .haas_delay_ms = _DefaultRowValues.haas_delay_ms
            End With
            _DSSPECTRAL.performance.AddperformanceRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_id
        End Function

        Public Function AddRow2(patch_set_id As System.Int32, performance_name As System.String, haas_delay_ms As System.Single) As Integer
            Dim R As DataSet_Spectral.performanceRow = _DSSPECTRAL.performance.NewperformanceRow
            With R
                .performance_id = GetNewperformanceID()
                .patch_set_id = patch_set_id
                .performance_name = performance_name
                .haas_delay_ms = haas_delay_ms
            End With
            _DSSPECTRAL.performance.AddperformanceRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_id
        End Function

        Public Function AddRow3(patch_set_id As System.Int32, performance_id As System.Int32, performance_name As System.String, haas_delay_ms As System.Single) As Integer
            Dim R As DataSet_Spectral.performanceRow = _DSSPECTRAL.performance.NewperformanceRow
            With R
                .patch_set_id = patch_set_id
                .performance_id = performance_id
                .performance_name = performance_name
                .haas_delay_ms = haas_delay_ms
            End With
            _DSSPECTRAL.performance.AddperformanceRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_id
        End Function

        Public Function patch_set_id_ForeignKeyUsed(patch_set_id) As Boolean
            Dim RowSet As DataSet_Spectral.performanceRow() = _DSSPECTRAL.performance.Select("patch_set_id = " & patch_set_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.performanceRow() = _DSSPECTRAL.performance.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.performanceRow() = _DSSPECTRAL.performance.Select("performance_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(performance_name As String) As DataSet_Spectral.performanceRow
            For Each r As DataSet_Spectral.performanceRow In DT.Rows
                If r.performance_name = performance_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(patch_set_id As Integer, performance_id As Integer) As DataSet_Spectral.performanceRow
            Return _DSSPECTRAL.performance.FindBypatch_set_idperformance_id(patch_set_id, performance_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.performanceRow() = _DSSPECTRAL.performance.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.performance_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.performanceRow
            Dim RowSet As DataSet_Spectral.performanceRow() = _DSSPECTRAL.performance.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("performance", _CurrentRow.performance_id)
        End Function

        Public Sub DeleteRow(patch_set_id As Integer, performance_id As Integer)
            Dim R As DataSet_Spectral.performanceRow = GetRow(patch_set_id, performance_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_performance_channel.DeleteRows("patch_set_id = " & patch_set_id & " AND " & "performance_id = " & performance_id)
            _ParentClass.Table_performance_processor.DeleteRows("patch_set_id = " & patch_set_id & " AND " & "performance_id = " & performance_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.performanceRow = GetRow(CurrentRow.patch_set_id, CurrentRow.performance_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_performance_channel.DeleteRows("patch_set_id = " & R.patch_set_id & " AND " & "performance_id = " & R.performance_id)
            _ParentClass.Table_performance_processor.DeleteRows("patch_set_id = " & R.patch_set_id & " AND " & "performance_id = " & R.performance_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.performanceRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.performanceRow In RowsToDelete
                DeleteRow(R.patch_set_id, R.performance_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_set_id = DGV.CurrentRow.Cells("patch_set_id").Value
                    .performance_id = DGV.CurrentRow.Cells("performance_id").Value
                    .performance_name = DGV.CurrentRow.Cells("performance_name").Value.ToString
                    .haas_delay_ms = DGV.CurrentRow.Cells("haas_delay_ms").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.performanceRow() = _DSSPECTRAL.performance.Select("performance_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_set_id = RowSet.First.patch_set_id
                    .performance_id = RowSet.First.performance_id
                    .performance_name = RowSet.First.performance_name
                    .haas_delay_ms = RowSet.First.haas_delay_ms
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_set_id(patch_set_id As String)
            _Table_BindingSource.Filter = "patch_set_id = " & patch_set_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_set_id"
                    DefaultRowValues.patch_set_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.performance_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewperformanceID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.performance.Compute("MAX(performance_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_performance_channel ------------------------------"
    Public Class TableClass_performance_channel
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.performance_channelDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_set_id As System.Int32
            Dim performance_id As System.Int32
            Dim performance_channel_id As System.Int32
            Dim patch_id As System.Int32
            Dim volume As System.Single
            Dim note_range_low As System.Int32
            Dim note_range_high As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_set_id As System.Int32 = 0
            Public performance_id As System.Int32 = 0
            Public patch_id As System.Int32 = 0
            Public volume As System.Single = 0
            Public note_range_low As System.Int32 = 0
            Public note_range_high As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_set_id = "patch_set_id"
            Const performance_id = "performance_id"
            Const performance_channel_id = "performance_channel_id"
            Const patch_id = "patch_id"
            Const volume = "volume"
            Const note_range_low = "note_range_low"
            Const note_range_high = "note_range_high"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "performance_channel"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.performance_channelDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.performance_channel
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.performance_channel.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.performance_channelRow = _DSSPECTRAL.performance_channel.Newperformance_channelRow
            With R
                .performance_channel_id = GetNewperformance_channelID()
                .patch_set_id = _DefaultRowValues.patch_set_id
                .performance_id = _DefaultRowValues.performance_id
                .patch_id = _DefaultRowValues.patch_id
                .volume = _DefaultRowValues.volume
                .note_range_low = _DefaultRowValues.note_range_low
                .note_range_high = _DefaultRowValues.note_range_high
            End With
            _DSSPECTRAL.performance_channel.Addperformance_channelRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_channel_id
        End Function

        Public Function AddRow2(patch_set_id As System.Int32, performance_id As System.Int32, patch_id As System.Int32, volume As System.Single, note_range_low As System.Int32, note_range_high As System.Int32) As Integer
            Dim R As DataSet_Spectral.performance_channelRow = _DSSPECTRAL.performance_channel.Newperformance_channelRow
            With R
                .performance_channel_id = GetNewperformance_channelID()
                .patch_set_id = patch_set_id
                .performance_id = performance_id
                .patch_id = patch_id
                .volume = volume
                .note_range_low = note_range_low
                .note_range_high = note_range_high
            End With
            _DSSPECTRAL.performance_channel.Addperformance_channelRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_channel_id
        End Function

        Public Function AddRow3(patch_set_id As System.Int32, performance_id As System.Int32, performance_channel_id As System.Int32, patch_id As System.Int32, volume As System.Single, note_range_low As System.Int32, note_range_high As System.Int32) As Integer
            Dim R As DataSet_Spectral.performance_channelRow = _DSSPECTRAL.performance_channel.Newperformance_channelRow
            With R
                .patch_set_id = patch_set_id
                .performance_id = performance_id
                .performance_channel_id = performance_channel_id
                .patch_id = patch_id
                .volume = volume
                .note_range_low = note_range_low
                .note_range_high = note_range_high
            End With
            _DSSPECTRAL.performance_channel.Addperformance_channelRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_channel_id
        End Function

        Public Function patch_set_id_ForeignKeyUsed(patch_set_id) As Boolean
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select("patch_set_id = " & patch_set_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function performance_id_ForeignKeyUsed(performance_id) As Boolean
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select("performance_id = " & performance_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function patch_id_ForeignKeyUsed(patch_id) As Boolean
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select("patch_id = " & patch_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select("performance_channel_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_set_id As Integer, performance_id As Integer, performance_channel_id As Integer) As DataSet_Spectral.performance_channelRow
            Return _DSSPECTRAL.performance_channel.FindBypatch_set_idperformance_idperformance_channel_id(patch_set_id, performance_id, performance_channel_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.performance_channel_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.performance_channelRow
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("performance_channel", _CurrentRow.performance_channel_id)
        End Function

        Public Sub DeleteRow(patch_set_id As Integer, performance_id As Integer, performance_channel_id As Integer)
            Dim R As DataSet_Spectral.performance_channelRow = GetRow(patch_set_id, performance_id, performance_channel_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.performance_channelRow = GetRow(CurrentRow.patch_set_id, CurrentRow.performance_id, CurrentRow.performance_channel_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.performance_channelRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.performance_channelRow In RowsToDelete
                DeleteRow(R.patch_set_id, R.performance_id, R.performance_channel_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_set_id = DGV.CurrentRow.Cells("patch_set_id").Value
                    .performance_id = DGV.CurrentRow.Cells("performance_id").Value
                    .performance_channel_id = DGV.CurrentRow.Cells("performance_channel_id").Value
                    .patch_id = DGV.CurrentRow.Cells("patch_id").Value
                    .volume = DGV.CurrentRow.Cells("volume").Value
                    .note_range_low = DGV.CurrentRow.Cells("note_range_low").Value
                    .note_range_high = DGV.CurrentRow.Cells("note_range_high").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.performance_channelRow() = _DSSPECTRAL.performance_channel.Select("performance_channel_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_set_id = RowSet.First.patch_set_id
                    .performance_id = RowSet.First.performance_id
                    .performance_channel_id = RowSet.First.performance_channel_id
                    .patch_id = RowSet.First.patch_id
                    .volume = RowSet.First.volume
                    .note_range_low = RowSet.First.note_range_low
                    .note_range_high = RowSet.First.note_range_high
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_set_id(patch_set_id As String)
            _Table_BindingSource.Filter = "patch_set_id = " & patch_set_id
        End Sub

        Public Sub SetBSFilterForForeignKey_performance_id(performance_id As String)
            _Table_BindingSource.Filter = "performance_id = " & performance_id
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_id(patch_id As String)
            _Table_BindingSource.Filter = "patch_id = " & patch_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_set_id"
                    DefaultRowValues.patch_set_id = KeyValue
                Case "performance_id"
                    DefaultRowValues.performance_id = KeyValue
                Case "patch_id"
                    DefaultRowValues.patch_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.performance_channel_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewperformance_channelID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.performance_channel.Compute("MAX(performance_channel_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_performance_processor ------------------------------"
    Public Class TableClass_performance_processor
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.performance_processorDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_set_id As System.Int32
            Dim performance_id As System.Int32
            Dim performance_processor_id As System.Int32
            Dim channel_id As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_set_id As System.Int32 = 0
            Public performance_id As System.Int32 = 0
            Public channel_id As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_set_id = "patch_set_id"
            Const performance_id = "performance_id"
            Const performance_processor_id = "performance_processor_id"
            Const channel_id = "channel_id"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "performance_processor"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.performance_processorDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.performance_processor
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.performance_processor.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.performance_processorRow = _DSSPECTRAL.performance_processor.Newperformance_processorRow
            With R
                .performance_processor_id = GetNewperformance_processorID()
                .patch_set_id = _DefaultRowValues.patch_set_id
                .performance_id = _DefaultRowValues.performance_id
                .channel_id = _DefaultRowValues.channel_id
            End With
            _DSSPECTRAL.performance_processor.Addperformance_processorRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_processor_id
        End Function

        Public Function AddRow2(patch_set_id As System.Int32, performance_id As System.Int32, channel_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.performance_processorRow = _DSSPECTRAL.performance_processor.Newperformance_processorRow
            With R
                .performance_processor_id = GetNewperformance_processorID()
                .patch_set_id = patch_set_id
                .performance_id = performance_id
                .channel_id = channel_id
            End With
            _DSSPECTRAL.performance_processor.Addperformance_processorRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_processor_id
        End Function

        Public Function AddRow3(patch_set_id As System.Int32, performance_id As System.Int32, performance_processor_id As System.Int32, channel_id As System.Int32) As Integer
            Dim R As DataSet_Spectral.performance_processorRow = _DSSPECTRAL.performance_processor.Newperformance_processorRow
            With R
                .patch_set_id = patch_set_id
                .performance_id = performance_id
                .performance_processor_id = performance_processor_id
                .channel_id = channel_id
            End With
            _DSSPECTRAL.performance_processor.Addperformance_processorRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.performance_processor_id
        End Function

        Public Function patch_set_id_ForeignKeyUsed(patch_set_id) As Boolean
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select("patch_set_id = " & patch_set_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function performance_id_ForeignKeyUsed(performance_id) As Boolean
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select("performance_id = " & performance_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function channel_id_ForeignKeyUsed(channel_id) As Boolean
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select("channel_id = " & channel_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select("performance_processor_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(patch_set_id As Integer, performance_id As Integer, performance_processor_id As Integer) As DataSet_Spectral.performance_processorRow
            Return _DSSPECTRAL.performance_processor.FindBypatch_set_idperformance_idperformance_processor_id(patch_set_id, performance_id, performance_processor_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.performance_processor_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.performance_processorRow
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("performance_processor", _CurrentRow.performance_processor_id)
        End Function

        Public Sub DeleteRow(patch_set_id As Integer, performance_id As Integer, performance_processor_id As Integer)
            Dim R As DataSet_Spectral.performance_processorRow = GetRow(patch_set_id, performance_id, performance_processor_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.performance_processorRow = GetRow(CurrentRow.patch_set_id, CurrentRow.performance_id, CurrentRow.performance_processor_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.performance_processorRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.performance_processorRow In RowsToDelete
                DeleteRow(R.patch_set_id, R.performance_id, R.performance_processor_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_set_id = DGV.CurrentRow.Cells("patch_set_id").Value
                    .performance_id = DGV.CurrentRow.Cells("performance_id").Value
                    .performance_processor_id = DGV.CurrentRow.Cells("performance_processor_id").Value
                    .channel_id = DGV.CurrentRow.Cells("channel_id").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.performance_processorRow() = _DSSPECTRAL.performance_processor.Select("performance_processor_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_set_id = RowSet.First.patch_set_id
                    .performance_id = RowSet.First.performance_id
                    .performance_processor_id = RowSet.First.performance_processor_id
                    .channel_id = RowSet.First.channel_id
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_patch_set_id(patch_set_id As String)
            _Table_BindingSource.Filter = "patch_set_id = " & patch_set_id
        End Sub

        Public Sub SetBSFilterForForeignKey_performance_id(performance_id As String)
            _Table_BindingSource.Filter = "performance_id = " & performance_id
        End Sub

        Public Sub SetBSFilterForForeignKey_channel_id(channel_id As String)
            _Table_BindingSource.Filter = "channel_id = " & channel_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "patch_set_id"
                    DefaultRowValues.patch_set_id = KeyValue
                Case "performance_id"
                    DefaultRowValues.performance_id = KeyValue
                Case "channel_id"
                    DefaultRowValues.channel_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.performance_processor_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewperformance_processorID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.performance_processor.Compute("MAX(performance_processor_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_system_settings ------------------------------"
    Public Class TableClass_system_settings
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.system_settingsDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim system_settings_id As System.Int32
            Dim default_performance_bank As System.Int32
            Dim default_patch_bank As System.Int32
            Dim data_schema_version As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public default_performance_bank As System.Int32 = 0
            Public default_patch_bank As System.Int32 = 0
            Public data_schema_version As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const system_settings_id = "system_settings_id"
            Const default_performance_bank = "default_performance_bank"
            Const default_patch_bank = "default_patch_bank"
            Const data_schema_version = "data_schema_version"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "system_settings"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.system_settingsDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.system_settings
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.system_settings.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.system_settingsRow = _DSSPECTRAL.system_settings.Newsystem_settingsRow
            With R
                .system_settings_id = GetNewsystem_settingsID()
                .default_performance_bank = _DefaultRowValues.default_performance_bank
                .default_patch_bank = _DefaultRowValues.default_patch_bank
                .data_schema_version = _DefaultRowValues.data_schema_version
            End With
            _DSSPECTRAL.system_settings.Addsystem_settingsRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.system_settings_id
        End Function

        Public Function AddRow2(default_performance_bank As System.Int32, default_patch_bank As System.Int32, data_schema_version As System.Int32) As Integer
            Dim R As DataSet_Spectral.system_settingsRow = _DSSPECTRAL.system_settings.Newsystem_settingsRow
            With R
                .system_settings_id = GetNewsystem_settingsID()
                .default_performance_bank = default_performance_bank
                .default_patch_bank = default_patch_bank
                .data_schema_version = data_schema_version
            End With
            _DSSPECTRAL.system_settings.Addsystem_settingsRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.system_settings_id
        End Function

        Public Function AddRow3(system_settings_id As System.Int32, default_performance_bank As System.Int32, default_patch_bank As System.Int32, data_schema_version As System.Int32) As Integer
            Dim R As DataSet_Spectral.system_settingsRow = _DSSPECTRAL.system_settings.Newsystem_settingsRow
            With R
                .system_settings_id = system_settings_id
                .default_performance_bank = default_performance_bank
                .default_patch_bank = default_patch_bank
                .data_schema_version = data_schema_version
            End With
            _DSSPECTRAL.system_settings.Addsystem_settingsRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.system_settings_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.system_settingsRow() = _DSSPECTRAL.system_settings.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.system_settingsRow() = _DSSPECTRAL.system_settings.Select("system_settings_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(system_settings_id As Integer) As DataSet_Spectral.system_settingsRow
            Return _DSSPECTRAL.system_settings.FindBysystem_settings_id(system_settings_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.system_settingsRow() = _DSSPECTRAL.system_settings.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.system_settings_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.system_settingsRow
            Dim RowSet As DataSet_Spectral.system_settingsRow() = _DSSPECTRAL.system_settings.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("system_settings", _CurrentRow.system_settings_id)
        End Function

        Public Sub DeleteRow(system_settings_id As Integer)
            Dim R As DataSet_Spectral.system_settingsRow = GetRow(system_settings_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.system_settingsRow = GetRow(CurrentRow.system_settings_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.system_settingsRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.system_settingsRow In RowsToDelete
                DeleteRow(R.system_settings_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .system_settings_id = DGV.CurrentRow.Cells("system_settings_id").Value
                    .default_performance_bank = DGV.CurrentRow.Cells("default_performance_bank").Value
                    .default_patch_bank = DGV.CurrentRow.Cells("default_patch_bank").Value
                    .data_schema_version = DGV.CurrentRow.Cells("data_schema_version").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.system_settingsRow() = _DSSPECTRAL.system_settings.Select("system_settings_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .system_settings_id = RowSet.First.system_settings_id
                    .default_performance_bank = RowSet.First.default_performance_bank
                    .default_patch_bank = RowSet.First.default_patch_bank
                    .data_schema_version = RowSet.First.data_schema_version
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.system_settings_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewsystem_settingsID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.system_settings.Compute("MAX(system_settings_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_waveform ------------------------------"
    Public Class TableClass_waveform
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.waveformDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim waveform_set_id As System.Int32
            Dim note_sector_id As System.Int32
            Dim intensity_layer_id As System.Int32
            Dim waveform_id As System.Int32
            Dim description As System.String
        End Structure

        Public Class Default_Row_Values
            Public waveform_set_id As System.Int32 = 0
            Public note_sector_id As System.Int32 = 0
            Public intensity_layer_id As System.Int32 = 0
            Public description As System.String = ""
        End Class

        Public Structure ColNames
            Const waveform_set_id = "waveform_set_id"
            Const note_sector_id = "note_sector_id"
            Const intensity_layer_id = "intensity_layer_id"
            Const waveform_id = "waveform_id"
            Const description = "description"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "waveform"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.waveformDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.waveform
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.waveform.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.waveformRow = _DSSPECTRAL.waveform.NewwaveformRow
            With R
                .waveform_id = GetNewwaveformID()
                .waveform_set_id = _DefaultRowValues.waveform_set_id
                .note_sector_id = _DefaultRowValues.note_sector_id
                .intensity_layer_id = _DefaultRowValues.intensity_layer_id
                If _DefaultRowValues.description IsNot Nothing Then .description = _DefaultRowValues.description
            End With
            _DSSPECTRAL.waveform.AddwaveformRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_id
        End Function

        Public Function AddRow2(waveform_set_id As System.Int32, note_sector_id As System.Int32, intensity_layer_id As System.Int32, description As System.String) As Integer
            Dim R As DataSet_Spectral.waveformRow = _DSSPECTRAL.waveform.NewwaveformRow
            With R
                .waveform_id = GetNewwaveformID()
                .waveform_set_id = waveform_set_id
                .note_sector_id = note_sector_id
                .intensity_layer_id = intensity_layer_id
                .description = description
            End With
            _DSSPECTRAL.waveform.AddwaveformRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_id
        End Function

        Public Function AddRow3(waveform_set_id As System.Int32, note_sector_id As System.Int32, intensity_layer_id As System.Int32, waveform_id As System.Int32, description As System.String) As Integer
            Dim R As DataSet_Spectral.waveformRow = _DSSPECTRAL.waveform.NewwaveformRow
            With R
                .waveform_set_id = waveform_set_id
                .note_sector_id = note_sector_id
                .intensity_layer_id = intensity_layer_id
                .waveform_id = waveform_id
                .description = description
            End With
            _DSSPECTRAL.waveform.AddwaveformRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_id
        End Function

        Public Function waveform_set_id_ForeignKeyUsed(waveform_set_id) As Boolean
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select("waveform_set_id = " & waveform_set_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function note_sector_id_ForeignKeyUsed(note_sector_id) As Boolean
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select("note_sector_id = " & note_sector_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function intensity_layer_id_ForeignKeyUsed(intensity_layer_id) As Boolean
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select("intensity_layer_id = " & intensity_layer_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select("waveform_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(waveform_set_id As Integer, note_sector_id As Integer, intensity_layer_id As Integer, waveform_id As Integer) As DataSet_Spectral.waveformRow
            Return _DSSPECTRAL.waveform.FindBywaveform_set_idnote_sector_idintensity_layer_idwaveform_id(waveform_set_id, note_sector_id, intensity_layer_id, waveform_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.waveform_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.waveformRow
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("waveform", _CurrentRow.waveform_id)
        End Function

        Public Sub DeleteRow(waveform_set_id As Integer, note_sector_id As Integer, intensity_layer_id As Integer, waveform_id As Integer)
            Dim R As DataSet_Spectral.waveformRow = GetRow(waveform_set_id, note_sector_id, intensity_layer_id, waveform_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_waveform_harmonic.DeleteRows("waveform_set_id = " & waveform_set_id & " AND " & "note_sector_id = " & note_sector_id & " AND " & "intensity_layer_id = " & intensity_layer_id & " AND " & "waveform_id = " & waveform_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.waveformRow = GetRow(CurrentRow.waveform_set_id, CurrentRow.note_sector_id, CurrentRow.intensity_layer_id, CurrentRow.waveform_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_waveform_harmonic.DeleteRows("waveform_set_id = " & R.waveform_set_id & " AND " & "note_sector_id = " & R.note_sector_id & " AND " & "intensity_layer_id = " & R.intensity_layer_id & " AND " & "waveform_id = " & R.waveform_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.waveformRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.waveformRow In RowsToDelete
                DeleteRow(R.waveform_set_id, R.note_sector_id, R.intensity_layer_id, R.waveform_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .waveform_set_id = DGV.CurrentRow.Cells("waveform_set_id").Value
                    .note_sector_id = DGV.CurrentRow.Cells("note_sector_id").Value
                    .intensity_layer_id = DGV.CurrentRow.Cells("intensity_layer_id").Value
                    .waveform_id = DGV.CurrentRow.Cells("waveform_id").Value
                    .description = DGV.CurrentRow.Cells("description").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.waveformRow() = _DSSPECTRAL.waveform.Select("waveform_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .waveform_set_id = RowSet.First.waveform_set_id
                    .note_sector_id = RowSet.First.note_sector_id
                    .intensity_layer_id = RowSet.First.intensity_layer_id
                    .waveform_id = RowSet.First.waveform_id
                    .description = RowSet.First.description
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_waveform_set_id(waveform_set_id As String)
            _Table_BindingSource.Filter = "waveform_set_id = " & waveform_set_id
        End Sub

        Public Sub SetBSFilterForForeignKey_note_sector_id(note_sector_id As String)
            _Table_BindingSource.Filter = "note_sector_id = " & note_sector_id
        End Sub

        Public Sub SetBSFilterForForeignKey_intensity_layer_id(intensity_layer_id As String)
            _Table_BindingSource.Filter = "intensity_layer_id = " & intensity_layer_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "waveform_set_id"
                    DefaultRowValues.waveform_set_id = KeyValue
                Case "note_sector_id"
                    DefaultRowValues.note_sector_id = KeyValue
                Case "intensity_layer_id"
                    DefaultRowValues.intensity_layer_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.waveform_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewwaveformID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.waveform.Compute("MAX(waveform_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_waveform_harmonic ------------------------------"
    Public Class TableClass_waveform_harmonic
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.waveform_harmonicDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim waveform_set_id As System.Int32
            Dim note_sector_id As System.Int32
            Dim intensity_layer_id As System.Int32
            Dim waveform_id As System.Int32
            Dim waveform_harmonic_id As System.Int32
            Dim level As System.Int32
            Dim phase_offset As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public waveform_set_id As System.Int32 = 0
            Public note_sector_id As System.Int32 = 0
            Public intensity_layer_id As System.Int32 = 0
            Public waveform_id As System.Int32 = 0
            Public level As System.Int32 = 0
            Public phase_offset As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const waveform_set_id = "waveform_set_id"
            Const note_sector_id = "note_sector_id"
            Const intensity_layer_id = "intensity_layer_id"
            Const waveform_id = "waveform_id"
            Const waveform_harmonic_id = "waveform_harmonic_id"
            Const level = "level"
            Const phase_offset = "phase_offset"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "waveform_harmonic"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.waveform_harmonicDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.waveform_harmonic
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.waveform_harmonic.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.waveform_harmonicRow = _DSSPECTRAL.waveform_harmonic.Newwaveform_harmonicRow
            With R
                .waveform_harmonic_id = GetNewwaveform_harmonicID()
                .waveform_set_id = _DefaultRowValues.waveform_set_id
                .note_sector_id = _DefaultRowValues.note_sector_id
                .intensity_layer_id = _DefaultRowValues.intensity_layer_id
                .waveform_id = _DefaultRowValues.waveform_id
                .level = _DefaultRowValues.level
                .phase_offset = _DefaultRowValues.phase_offset
            End With
            _DSSPECTRAL.waveform_harmonic.Addwaveform_harmonicRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_harmonic_id
        End Function

        Public Function AddRow2(waveform_set_id As System.Int32, note_sector_id As System.Int32, intensity_layer_id As System.Int32, waveform_id As System.Int32, level As System.Int32, phase_offset As System.Int32) As Integer
            Dim R As DataSet_Spectral.waveform_harmonicRow = _DSSPECTRAL.waveform_harmonic.Newwaveform_harmonicRow
            With R
                .waveform_harmonic_id = GetNewwaveform_harmonicID()
                .waveform_set_id = waveform_set_id
                .note_sector_id = note_sector_id
                .intensity_layer_id = intensity_layer_id
                .waveform_id = waveform_id
                .level = level
                .phase_offset = phase_offset
            End With
            _DSSPECTRAL.waveform_harmonic.Addwaveform_harmonicRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_harmonic_id
        End Function

        Public Function AddRow3(waveform_set_id As System.Int32, note_sector_id As System.Int32, intensity_layer_id As System.Int32, waveform_id As System.Int32, waveform_harmonic_id As System.Int32, level As System.Int32, phase_offset As System.Int32) As Integer
            Dim R As DataSet_Spectral.waveform_harmonicRow = _DSSPECTRAL.waveform_harmonic.Newwaveform_harmonicRow
            With R
                .waveform_set_id = waveform_set_id
                .note_sector_id = note_sector_id
                .intensity_layer_id = intensity_layer_id
                .waveform_id = waveform_id
                .waveform_harmonic_id = waveform_harmonic_id
                .level = level
                .phase_offset = phase_offset
            End With
            _DSSPECTRAL.waveform_harmonic.Addwaveform_harmonicRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_harmonic_id
        End Function

        Public Function waveform_set_id_ForeignKeyUsed(waveform_set_id) As Boolean
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select("waveform_set_id = " & waveform_set_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function note_sector_id_ForeignKeyUsed(note_sector_id) As Boolean
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select("note_sector_id = " & note_sector_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function intensity_layer_id_ForeignKeyUsed(intensity_layer_id) As Boolean
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select("intensity_layer_id = " & intensity_layer_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function waveform_id_ForeignKeyUsed(waveform_id) As Boolean
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select("waveform_id = " & waveform_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select("waveform_harmonic_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(waveform_set_id As Integer, note_sector_id As Integer, intensity_layer_id As Integer, waveform_id As Integer, waveform_harmonic_id As Integer) As DataSet_Spectral.waveform_harmonicRow
            Return _DSSPECTRAL.waveform_harmonic.FindBywaveform_set_idnote_sector_idintensity_layer_idwaveform_idwaveform_harmonic_id(waveform_set_id, note_sector_id, intensity_layer_id, waveform_id, waveform_harmonic_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.waveform_harmonic_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.waveform_harmonicRow
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("waveform_harmonic", _CurrentRow.waveform_harmonic_id)
        End Function

        Public Sub DeleteRow(waveform_set_id As Integer, note_sector_id As Integer, intensity_layer_id As Integer, waveform_id As Integer, waveform_harmonic_id As Integer)
            Dim R As DataSet_Spectral.waveform_harmonicRow = GetRow(waveform_set_id, note_sector_id, intensity_layer_id, waveform_id, waveform_harmonic_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.waveform_harmonicRow = GetRow(CurrentRow.waveform_set_id, CurrentRow.note_sector_id, CurrentRow.intensity_layer_id, CurrentRow.waveform_id, CurrentRow.waveform_harmonic_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.waveform_harmonicRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.waveform_harmonicRow In RowsToDelete
                DeleteRow(R.waveform_set_id, R.note_sector_id, R.intensity_layer_id, R.waveform_id, R.waveform_harmonic_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .waveform_set_id = DGV.CurrentRow.Cells("waveform_set_id").Value
                    .note_sector_id = DGV.CurrentRow.Cells("note_sector_id").Value
                    .intensity_layer_id = DGV.CurrentRow.Cells("intensity_layer_id").Value
                    .waveform_id = DGV.CurrentRow.Cells("waveform_id").Value
                    .waveform_harmonic_id = DGV.CurrentRow.Cells("waveform_harmonic_id").Value
                    .level = DGV.CurrentRow.Cells("level").Value
                    .phase_offset = DGV.CurrentRow.Cells("phase_offset").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.waveform_harmonicRow() = _DSSPECTRAL.waveform_harmonic.Select("waveform_harmonic_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .waveform_set_id = RowSet.First.waveform_set_id
                    .note_sector_id = RowSet.First.note_sector_id
                    .intensity_layer_id = RowSet.First.intensity_layer_id
                    .waveform_id = RowSet.First.waveform_id
                    .waveform_harmonic_id = RowSet.First.waveform_harmonic_id
                    .level = RowSet.First.level
                    .phase_offset = RowSet.First.phase_offset
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_waveform_set_id(waveform_set_id As String)
            _Table_BindingSource.Filter = "waveform_set_id = " & waveform_set_id
        End Sub

        Public Sub SetBSFilterForForeignKey_note_sector_id(note_sector_id As String)
            _Table_BindingSource.Filter = "note_sector_id = " & note_sector_id
        End Sub

        Public Sub SetBSFilterForForeignKey_intensity_layer_id(intensity_layer_id As String)
            _Table_BindingSource.Filter = "intensity_layer_id = " & intensity_layer_id
        End Sub

        Public Sub SetBSFilterForForeignKey_waveform_id(waveform_id As String)
            _Table_BindingSource.Filter = "waveform_id = " & waveform_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "waveform_set_id"
                    DefaultRowValues.waveform_set_id = KeyValue
                Case "note_sector_id"
                    DefaultRowValues.note_sector_id = KeyValue
                Case "intensity_layer_id"
                    DefaultRowValues.intensity_layer_id = KeyValue
                Case "waveform_id"
                    DefaultRowValues.waveform_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.waveform_harmonic_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewwaveform_harmonicID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.waveform_harmonic.Compute("MAX(waveform_harmonic_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_waveform_set ------------------------------"
    Public Class TableClass_waveform_set
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRAL As DataSet_Spectral
        Private _ParentClass As CodeGen_DS_Spectral
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral.waveform_setDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim waveform_set_id As System.Int32
            Dim waveform_set_guid8 As System.String
            Dim waveform_set_name As System.String
            Dim timbre_mode As System.Int32
            Dim intensity_controller_source As System.Int32
            Dim waveform_controller_source As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public waveform_set_guid8 As System.String = ""
            Public waveform_set_name As System.String = ""
            Public timbre_mode As System.Int32 = 0
            Public intensity_controller_source As System.Int32 = 0
            Public waveform_controller_source As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const waveform_set_id = "waveform_set_id"
            Const waveform_set_guid8 = "waveform_set_guid8"
            Const waveform_set_name = "waveform_set_name"
            Const timbre_mode = "timbre_mode"
            Const intensity_controller_source = "intensity_controller_source"
            Const waveform_controller_source = "waveform_controller_source"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "waveform_set"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral.waveform_setDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRAL As DataSet_Spectral, ByRef ParentClass As CodeGen_DS_Spectral)
            _DSSPECTRAL = DSSPECTRAL
            _DT = _DSSPECTRAL.waveform_set
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRAL.waveform_set.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral.waveform_setRow = _DSSPECTRAL.waveform_set.Newwaveform_setRow
            With R
                .waveform_set_id = GetNewwaveform_setID()
                If _DefaultRowValues.waveform_set_guid8 IsNot Nothing Then .waveform_set_guid8 = _DefaultRowValues.waveform_set_guid8
                If _DefaultRowValues.waveform_set_name IsNot Nothing Then .waveform_set_name = _DefaultRowValues.waveform_set_name
                .timbre_mode = _DefaultRowValues.timbre_mode
                .intensity_controller_source = _DefaultRowValues.intensity_controller_source
                .waveform_controller_source = _DefaultRowValues.waveform_controller_source
            End With
            _DSSPECTRAL.waveform_set.Addwaveform_setRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_set_id
        End Function

        Public Function AddRow2(waveform_set_guid8 As System.String, waveform_set_name As System.String, timbre_mode As System.Int32, intensity_controller_source As System.Int32, waveform_controller_source As System.Int32) As Integer
            Dim R As DataSet_Spectral.waveform_setRow = _DSSPECTRAL.waveform_set.Newwaveform_setRow
            With R
                .waveform_set_id = GetNewwaveform_setID()
                .waveform_set_guid8 = waveform_set_guid8
                .waveform_set_name = waveform_set_name
                .timbre_mode = timbre_mode
                .intensity_controller_source = intensity_controller_source
                .waveform_controller_source = waveform_controller_source
            End With
            _DSSPECTRAL.waveform_set.Addwaveform_setRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_set_id
        End Function

        Public Function AddRow3(waveform_set_id As System.Int32, waveform_set_guid8 As System.String, waveform_set_name As System.String, timbre_mode As System.Int32, intensity_controller_source As System.Int32, waveform_controller_source As System.Int32) As Integer
            Dim R As DataSet_Spectral.waveform_setRow = _DSSPECTRAL.waveform_set.Newwaveform_setRow
            With R
                .waveform_set_id = waveform_set_id
                .waveform_set_guid8 = waveform_set_guid8
                .waveform_set_name = waveform_set_name
                .timbre_mode = timbre_mode
                .intensity_controller_source = intensity_controller_source
                .waveform_controller_source = waveform_controller_source
            End With
            _DSSPECTRAL.waveform_set.Addwaveform_setRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_set_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral.waveform_setRow() = _DSSPECTRAL.waveform_set.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.waveform_setRow() = _DSSPECTRAL.waveform_set.Select("waveform_set_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(waveform_set_name As String) As DataSet_Spectral.waveform_setRow
            For Each r As DataSet_Spectral.waveform_setRow In DT.Rows
                If r.waveform_set_name = waveform_set_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(waveform_set_id As Integer) As DataSet_Spectral.waveform_setRow
            Return _DSSPECTRAL.waveform_set.FindBywaveform_set_id(waveform_set_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral.waveform_setRow() = _DSSPECTRAL.waveform_set.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.waveform_set_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral.waveform_setRow
            Dim RowSet As DataSet_Spectral.waveform_setRow() = _DSSPECTRAL.waveform_set.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("waveform_set", _CurrentRow.waveform_set_id)
        End Function

        Public Sub DeleteRow(waveform_set_id As Integer)
            Dim R As DataSet_Spectral.waveform_setRow = GetRow(waveform_set_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_waveform.DeleteRows("waveform_set_id = " & waveform_set_id)
            _ParentClass.Table_waveform_harmonic.DeleteRows("waveform_set_id = " & waveform_set_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral.waveform_setRow = GetRow(CurrentRow.waveform_set_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_waveform.DeleteRows("waveform_set_id = " & R.waveform_set_id)
            _ParentClass.Table_waveform_harmonic.DeleteRows("waveform_set_id = " & R.waveform_set_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral.waveform_setRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral.waveform_setRow In RowsToDelete
                DeleteRow(R.waveform_set_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .waveform_set_id = DGV.CurrentRow.Cells("waveform_set_id").Value
                    .waveform_set_guid8 = DGV.CurrentRow.Cells("waveform_set_guid8").Value.ToString
                    .waveform_set_name = DGV.CurrentRow.Cells("waveform_set_name").Value.ToString
                    .timbre_mode = DGV.CurrentRow.Cells("timbre_mode").Value
                    .intensity_controller_source = DGV.CurrentRow.Cells("intensity_controller_source").Value
                    .waveform_controller_source = DGV.CurrentRow.Cells("waveform_controller_source").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral.waveform_setRow() = _DSSPECTRAL.waveform_set.Select("waveform_set_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .waveform_set_id = RowSet.First.waveform_set_id
                    .waveform_set_guid8 = RowSet.First.waveform_set_guid8
                    .waveform_set_name = RowSet.First.waveform_set_name
                    .timbre_mode = RowSet.First.timbre_mode
                    .intensity_controller_source = RowSet.First.intensity_controller_source
                    .waveform_controller_source = RowSet.First.waveform_controller_source
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.waveform_set_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewwaveform_setID() As Integer
            Dim MaxID As Object = _DSSPECTRAL.waveform_set.Compute("MAX(waveform_set_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#End Region

End Class

#End Region















