﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Spectral1_VBClassLibrary;
using Spectral1.DATA_ACCESS;

namespace Spectral1.PRESENTATION
{
    public partial class UC_body_resonance_graph : UserControl
    {
        CodeGen_DS_Spectral _CGS;
        float[] dashValues = { 2, 5, 2, 5 };
        Pen white_pen = new Pen(Color.White);
        Pen dimgray_pen = new Pen(Color.DimGray);
        Pen dashed_white_pen = new Pen(Color.White);
        Pen thin_dashed_pen = new Pen(Color.DimGray,(float)0.5);
        Pen filter1_pen = new Pen(Color.Blue,1);
        Pen filter2_pen = new Pen(Color.Green, 1);
        Pen filter_overall_pen = new Pen(Color.White, 4);
        SolidBrush white_brush = new SolidBrush(Color.White);

        const Int32 left_border = 70;
        const Int32 right_border = 40;
        const Int32 bottom_border = 50;
        const Int32 top_border = 40;

        const Int32 max_diplay_freq = 20000;
        bool _enabled = false;

        public UC_body_resonance_graph()
        {
            InitializeComponent();
            dashed_white_pen.DashPattern = dashValues;
            thin_dashed_pen.DashPattern = dashValues;
        }

        public void Initialise_graph(ref CodeGen_DS_Spectral CGS)
        {
            _CGS = CGS;
            
        }

        public void DisplayEnabled(bool isEnabled,bool DoARefresh)
        {
            _enabled = isEnabled;
            if (DoARefresh == true) { this.Refresh(); }
        }
        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            if ((_CGS == null)||(_enabled == false)) { return; }
            if (_CGS.Table_biquad_eq.CurrentRow.RowIsEmpty == true){ return; }

            ((TableLayoutPanel)this.Parent).Cursor = Cursors.WaitCursor;

            const Int32 freq_steps = 10;
            const Int32 gain_steps = 6;

            float graph_height = panel1.ClientRectangle.Height - (top_border + bottom_border);
            float graph_width = panel1.ClientRectangle.Width - (left_border + right_border);
            float pixels_per_unit_X = graph_width / max_diplay_freq;
         
            float max_graph_gain = 30;
            float min_graph_gain = -30;
            float pixels_per_unit_Y = graph_height / (max_graph_gain - min_graph_gain);

            //============= DRAW GRAPH AXIS LINES =======================================

            e.Graphics.DrawLine(dashed_white_pen, left_border, graph_height + top_border, left_border + graph_width, graph_height + top_border);
            e.Graphics.DrawLine(dashed_white_pen, left_border, top_border, left_border + graph_width, top_border);

            float temp_X = left_border;
            for (Int32 f = 0; f <= max_diplay_freq; f += (max_diplay_freq/ freq_steps))
            {
                e.Graphics.DrawString(f.ToString("##,##0"), new Font("Segoe UI", 8), white_brush, temp_X - (f.ToString().Length * 5), top_border + graph_height);
                e.Graphics.DrawLine(thin_dashed_pen, temp_X, top_border, temp_X, graph_height + top_border);
                temp_X += (max_diplay_freq / freq_steps) * pixels_per_unit_X;
            }

            e.Graphics.DrawString("Frequency (Hz)", new Font("Segoe UI", 8), white_brush, (panel1.ClientRectangle.Width/2) - 40, panel1.ClientRectangle.Height - 30);

            float temp_Y = top_border;
            for (float g = max_graph_gain; g >= min_graph_gain; g -= ((max_graph_gain - min_graph_gain) /gain_steps))
            {
                e.Graphics.DrawString(g.ToString() + "  -", new Font("Segoe UI", 8), white_brush, left_border - 20 - (g.ToString().Length * 5), temp_Y - 9);

                if (g != 0)
                {
                    e.Graphics.DrawLine(thin_dashed_pen, left_border, temp_Y, left_border + graph_width, temp_Y);
                }
                else
                {
                    e.Graphics.DrawLine(dimgray_pen, left_border, temp_Y, left_border + graph_width, temp_Y);
                }

                temp_Y += ((max_graph_gain - min_graph_gain) / gain_steps) *pixels_per_unit_Y;
            }

            e.Graphics.DrawString("dB", new Font("Segoe UI", 8), white_brush, 10, panel1.ClientRectangle.Height/2);


            e.Graphics.DrawString("Filter 0", new Font("Segoe UI", 8), white_brush, left_border + 10, panel1.ClientRectangle.Height - 30);
            e.Graphics.DrawLine(filter1_pen, left_border + 60, panel1.ClientRectangle.Height - 20, left_border + 100, panel1.ClientRectangle.Height - 20);
            e.Graphics.DrawString("Filter 1", new Font("Segoe UI", 8), white_brush, left_border + 120, panel1.ClientRectangle.Height - 30);
            e.Graphics.DrawLine(filter2_pen, left_border + 170, panel1.ClientRectangle.Height - 20, left_border + 210, panel1.ClientRectangle.Height - 20);
            e.Graphics.DrawString("Overall", new Font("Segoe UI", 8), white_brush, left_border + 230, panel1.ClientRectangle.Height - 30);
            e.Graphics.DrawLine(filter_overall_pen, left_border + 280, panel1.ClientRectangle.Height - 20, left_border + 330, panel1.ClientRectangle.Height - 20);

            //========================= DRAW GRAPH ============================================

            Double w;
            Double cos1;
            Double cos2;
            Double sin1;
            Double sin2;
            Double realZeroes;
            Double imagZeroes;
            Double realPoles;
            Double imagPoles;
            Double divider;
            Double realHw;
            Double imagHw;
            Double magnitude;
            Double gain_db;
            Point p_start;
            Point p_end = new Point(left_border, Convert.ToInt32(top_border + graph_height));
            const Int32 freq_graphing_step = 10;
            const Int32 num_points = (max_diplay_freq / freq_graphing_step) + 1;
            Int32 x;
            Int32 y;

            Double[,] filter_array = new Double[2,num_points];
            
            for (Int32 b = 0; b < DA_Spectral.max_biquad_filters; b++)
            {
                p_start = new Point(left_border, Convert.ToInt32(top_border + (max_graph_gain * pixels_per_unit_Y)));
                p_end = new Point(left_border, Convert.ToInt32(top_border + (max_graph_gain * pixels_per_unit_Y)));
                Int32 patch_id = _CGS.Table_biquad_eq.CurrentRow.patch_id;
                Double a0 = _CGS.Table_biquad_eq_calculated.GetRow(patch_id,b).a0;
                Double a1 = _CGS.Table_biquad_eq_calculated.GetRow(patch_id,b).a1;
                Double a2 = _CGS.Table_biquad_eq_calculated.GetRow(patch_id,b).a2;
                Double b1 = _CGS.Table_biquad_eq_calculated.GetRow(patch_id,b).b1;
                Double b2 = _CGS.Table_biquad_eq_calculated.GetRow(patch_id,b).b2;
                if ((Double.IsNaN(a0)== false) && (Double.IsNaN(a1) == false) && (Double.IsNaN(a2) == false) && (Double.IsNaN(b1) == false) && (Double.IsNaN(b2) == false)  )
                {
                    for (Int32 f = 0; f <= max_diplay_freq; f += freq_graphing_step)
                    {
                        /*
                         Z = e^jw 
                         w = 2*Pi*(f/sample rate)
                         e^jw = cos(w) + jsin(w)

                         H(e^jw) ={ [a0*e^(0jw)] + [a1*e^(-1jw)] + [a2*e^(-2jw)] }
                                / { [b0*e^(0jw)] + [b1*e^(-1jw)] + [b2*e^(-2jw)] }

                                 = { [a0] + [a1*e^(-1jw)] + [a2*e^(-2jw)] }
                                /  { 1 + [b1*e^(-1jw)] + [b2*e^(-2jw)] }    
                                
                        b0, the direct output gain, is usually set to 1.

                        Division refresher for complex numbers :
                        http://www.mesacc.edu/~scotz47781/mat120/notes/complex/dividing/dividing_complex.html

                        The result will be complex. 
                        Taking the absolute value gives us the magnitude response at that frequency.                      

                         */
                        w = 2 * Math.PI * f / DA_Spectral.sample_rate;
                        cos1 = Math.Cos(-1 * w);
                        sin1 = Math.Sin(-1 * w);
                        cos2 = Math.Cos(-2 * w);
                        sin2 = Math.Sin(-2 * w);
                        realZeroes = a0 + a1 * cos1 + a2 * cos2;
                        imagZeroes = a1 * sin1 + a2 * sin2;
                        realPoles = 1 + b1 * cos1 + b2 * cos2;
                        imagPoles = b1 * sin1 + b2 * sin2;

                        //NOTE: From division refresher above, (A+jB)/(C+jD) = [(AC + BD)/(C^2 + D^2)] + [(BC - AD)/(C^2 + D^2)]   
                        divider = realPoles * realPoles + imagPoles * imagPoles;
                        realHw = (realZeroes * realPoles + imagZeroes * imagPoles) / divider;
                        imagHw = (imagZeroes * realPoles - realZeroes * imagPoles) / divider;

                        if ((realHw * realHw + imagHw * imagHw) != 0)
                        {
                            magnitude = Math.Sqrt(realHw * realHw + imagHw * imagHw);
                            gain_db = 20 * Math.Log(magnitude);
                            x = Convert.ToInt32(left_border + (pixels_per_unit_X * f));
                            y = Convert.ToInt32(top_border + (max_graph_gain * pixels_per_unit_Y) - (gain_db * pixels_per_unit_Y));
                            filter_array[b, f / freq_graphing_step] = gain_db;

                            if ((y >= top_border) && (y <= top_border + graph_height))
                            {
                                p_start = new Point(x, y);
                                if (b == 0)
                                { e.Graphics.DrawLine(filter1_pen, p_start, p_end); }
                                else
                                { e.Graphics.DrawLine(filter2_pen, p_start, p_end); }
                            }
                            else
                            {
                                if (y < top_border)
                                { p_start = new Point(x, top_border); }
                                else
                                { p_start = new Point(x, Convert.ToInt32(top_border + graph_height)); }
                            }     
                        }
                        
                        p_end = p_start;
                    }
                }
            }

            //Draw overall gain
            p_start = new Point(left_border, Convert.ToInt32(top_border + (max_graph_gain * pixels_per_unit_Y)));
            p_end = new Point(left_border, Convert.ToInt32(top_border + (max_graph_gain * pixels_per_unit_Y)));
            for (Int32 f = 0; f <= max_diplay_freq; f += freq_graphing_step)
            {
                gain_db = filter_array[0, f / freq_graphing_step] + filter_array[1, f / freq_graphing_step];
                x = Convert.ToInt32(left_border + (pixels_per_unit_X * f));
                y = Convert.ToInt32(top_border + (max_graph_gain * pixels_per_unit_Y) - (gain_db * pixels_per_unit_Y));
                if ((y >= top_border) && (y <= top_border + graph_height))
                {
                    p_start = new Point(x, y);
                    e.Graphics.DrawLine(filter_overall_pen, p_start, p_end);
                }
                else
                {
                    if (y < top_border)
                    { p_start = new Point(x, top_border); }
                    else
                    { p_start = new Point(x, Convert.ToInt32(top_border + graph_height)); }
                }
                p_end = p_start;
            }

            ((TableLayoutPanel)this.Parent).Cursor = Cursors.Default;
        }
    }
}
