﻿using System;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Windows.Forms;
using Spectral1.DATA_ACCESS;
using System.Reflection;
using static Spectral1.DATA_ACCESS.DA_3DWireframe;
using static Spectral1.DATA_ACCESS.DA_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class UC_3D_Visualiser : UserControl
    {


        #region "======================= DECLARATIONS ==========================="
        PL_Main _plm;
        bool flag_initialising = true;
        DA_3DWireframe w = new DA_3DWireframe();
        Pen vp_pen = new Pen(Color.DimGray, 2);
        float dpi = 900;
        const int rotYmin = 20;
        const int rotYmax = 35;
        const int rotXmin = 20;
        const int rotXmax = 35;

        bool fill_mode = false;
        Brush fill_brush;

        Pen waveform_pen = new Pen(Color.Green, 4);
        Pen harmonic_pen = new Pen(Color.Green, 4);
        Pen text_pen = new Pen(Color.White, 2);
        Pen axis_pen = new Pen(Color.YellowGreen, 1);

        Pen highlighted_waveform_pen = new Pen(Color.LightGreen, 4);
        Pen interpolated_waveform_pen = new Pen(Color.DarkOliveGreen, 2);
        Pen highlighted_interpolated_waveform_pen = new Pen(Color.Olive, 2);
        Pen highlighted_harmonic_pen = new Pen(Color.LightGreen, 4);
        Pen interpolated_harmonic_pen = new Pen(Color.DarkOliveGreen, 2);
        Pen highlighted_interpolated_harmonic_pen = new Pen(Color.Olive, 2);

        visual3d_modes _visual_3d_mode;
        visual3d_across_modes _visual3d_across_mode = visual3d_across_modes.waveform_block;
        #endregion

        #region "======================= EVENTS ================================="
        private void button_animateY_Click(object sender, EventArgs e)
        {
            for (int n = rotYmin; n <= rotYmax; n++) { numericUpDown_rotY.Value = n; }
            for (int n = rotYmax; n >= 0; n--) { numericUpDown_rotY.Value = n; }
            for (int n = 0; n <= rotYmin; n++) { numericUpDown_rotY.Value = n; }
        }

        private void button_AnimateX_Click(object sender, EventArgs e)
        {
            for (int n = rotXmin; n <= rotXmax; n++) { numericUpDown_rotX.Value = n; }
            for (int n = rotXmax; n >= 0; n--) { numericUpDown_rotX.Value = n; }
            for (int n = 0; n <= rotXmin; n++) { numericUpDown_rotX.Value = n; }
        }

        private void numericUpDown_rotX_ValueChanged(object sender, EventArgs e)
        {
            if (flag_initialising == true) { return; }
            panel_visualise.Refresh();
        }

        private void numericUpDown_rotY_ValueChanged(object sender, EventArgs e)
        {
            if (flag_initialising == true) { return; }
            panel_visualise.Refresh();
        }

        private void numericUpDown_rotZ_ValueChanged(object sender, EventArgs e)
        {
            if (flag_initialising == true) { return; }
            panel_visualise.Refresh();
        }

        private void panel_visualise_Paint(object sender, PaintEventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_saving_or_loading) return;

            e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.High;
            e.Graphics.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;

            const int vb = 20;
            Point centre = new Point();
            centre.X = panel_visualise.Right / 2;
            centre.Y = panel_visualise.Bottom / 2;
            w.w2d.rotateX = (float)numericUpDown_rotX.Value;
            w.w2d.rotateY = (float)numericUpDown_rotY.Value;
            w.w2d.rotateZ = (float)numericUpDown_rotZ.Value;
            w.w2d.ViewPort = new Rectangle(-(centre.X - vb), -(centre.Y - vb), (centre.X - vb) * 2, (centre.Y - vb) * 2);
            w.RefreshWorld2D();

            foreach (PolyLine2D PL in w.w2d.PolyLinesList)
            {
                if (PL.PointList.Count > 0)
                {
                    Point ps = PL.PointList[0];
                    ps.Offset(centre.X, centre.Y);
                    Point pe;
                    for (int i = 1; i < PL.PointList.Count(); i++)
                    {
                        pe = PL.PointList[i];
                        pe.Offset(centre.X, centre.Y);
                        if (ps.Y < pe.Y)
                        { e.Graphics.DrawLine(PL.HighlightedLinePen, ps, pe); }
                        else
                        { e.Graphics.DrawLine(PL.LinePen, ps, pe); }

                        ps = pe;
                    }
                    if (fill_mode)
                    {
                        e.Graphics.FillPolygon(fill_brush, PL.PointList.Select(p => new PointF(p.X + centre.X - 1, p.Y + centre.Y)).ToArray());
                    }
                }
            }

            e.Graphics.DrawRectangle(vp_pen, vb, vb, panel_visualise.Right - 2 * vb, panel_visualise.Bottom - 2 * vb);

        }

        private void panel_visualise_Resize(object sender, EventArgs e)
        {
            this.Refresh();
        }

        private void checkBox_add_interpolated_CheckedChanged(object sender, EventArgs e)
        {
            Cursor entry_cursor = _plm.Cursor;
            _plm.Cursor = Cursors.WaitCursor;
            refresh_world_for_3d_mode();
            _plm.Cursor = entry_cursor;
        }

        #endregion

        #region "======================= METHODS ================================="
        public UC_3D_Visualiser()
        {
            InitializeComponent();
        }

        public void SetInterpolate()
        { checkBox_add_interpolated.Checked = true; }

        public void SetAcrossMode(visual3d_across_modes visual3d_across_mode)
        {
            _visual3d_across_mode = visual3d_across_mode;
            refresh_world_for_3d_mode();
        }

        public void initialise(PL_Main plm, visual3d_modes visual_3d_mode)
        {
            _plm = plm;
            _visual_3d_mode = visual_3d_mode;

           typeof(Panel).InvokeMember("DoubleBuffered",
            BindingFlags.SetProperty | BindingFlags.Instance | BindingFlags.NonPublic,
            null, panel_visualise, new object[] { true });

            numericUpDown_rotX.Value = rotXmin;
            numericUpDown_rotY.Value = rotYmin;
            numericUpDown_rotZ.Value = 0;

            flag_initialising = false;

           // w.w2d.ViewPortDistance = default_viewport_distance;
            PolyLine3D pl3d = new PolyLine3D();
            refresh_world_for_3d_mode();
        }

        public void refresh_world_for_3d_mode()
        {
            switch (_visual_3d_mode)
            {
                case visual3d_modes.waveforms:
                    switch (_visual3d_across_mode)
                    {
                        case visual3d_across_modes.waveform_block:
                            load_3d_waveforms_for_waveform_block();
                            break;
                        case visual3d_across_modes.note_sector:
                            load_3d_waveforms_for_note_sectors();
                            break;
                        case visual3d_across_modes.intensity_layer:
                            load_3d_waveforms_for_intensity_layers();
                            break;
                    }
                    
                    break;
                case visual3d_modes.harmonics:
                    switch (_visual3d_across_mode)
                    {
                        case visual3d_across_modes.waveform_block:
                            load_3d_harmonics_for_waveform_block(); ;
                            break;
                        case visual3d_across_modes.note_sector:
                            load_3d_harmonics_for_note_sectors();
                            break;
                        case visual3d_across_modes.intensity_layer:
                            load_3d_harmonics_for_intensity_layers();
                            break;
                    }

                    break;
            }
        }

        private void initialise_world_for_waveforms()
        {
            w.w2d.ViewPortDistance = waveform_viewport_distance;
            w.w2d.ZoomPerc = waveform_viewport_zoom;
            w.ClearWorld();
            fill_mode = false;
        }

        private void load_3d_waveforms_for_waveform_block()
        {
            initialise_world_for_waveforms();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.AddPolyLine3DWaveforms(ref w, this.ClientRectangle, dpi, text_pen, waveform_pen, highlighted_waveform_pen, interpolated_waveform_pen, highlighted_interpolated_waveform_pen, checkBox_add_interpolated.Checked);
            this.Refresh();
        }

        private void load_3d_waveforms_for_note_sectors()
        {
            initialise_world_for_waveforms();
            _plm.BL.BLWaveSet.current_waveform_set.AddPolyLine3DWaveformsAcrossNS(ref w, this.ClientRectangle, dpi, text_pen, waveform_pen, highlighted_waveform_pen, interpolated_waveform_pen, highlighted_interpolated_waveform_pen, checkBox_add_interpolated.Checked);
            this.Refresh();
        }

        private void load_3d_waveforms_for_intensity_layers()
        {
            initialise_world_for_waveforms();
            _plm.BL.BLWaveSet.current_waveform_set.AddPolyLine3DWaveformsAcrossIL(ref w, this.ClientRectangle, dpi, text_pen, waveform_pen, highlighted_waveform_pen, interpolated_waveform_pen, highlighted_interpolated_waveform_pen, checkBox_add_interpolated.Checked);
            this.Refresh();
        }

        private void initialise_world_for_harmonics()
        {
            w.w2d.ViewPortDistance = harmonic_viewport_distance;
            w.w2d.ZoomPerc = harmonic_viewport_zoom;
            w.ClearWorld();
            fill_mode = true;
            fill_brush = new SolidBrush(Color.Black);
        }

        private void load_3d_harmonics_for_waveform_block()
        {
            initialise_world_for_harmonics();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.AddPolyLine3DHarmonics(ref w, this.ClientRectangle, dpi, text_pen, harmonic_pen, highlighted_harmonic_pen, interpolated_waveform_pen, highlighted_interpolated_harmonic_pen, harmonic_overall_scaling, checkBox_add_interpolated.Checked);
            this.Refresh();
        }

        private void load_3d_harmonics_for_note_sectors()
        {
            initialise_world_for_harmonics();
            _plm.BL.BLWaveSet.current_waveform_set.AddPolyLine3DHarmonicsAcrossNS(ref w, this.ClientRectangle, dpi, text_pen, harmonic_pen, highlighted_harmonic_pen, interpolated_harmonic_pen, highlighted_interpolated_harmonic_pen, checkBox_add_interpolated.Checked);
            this.Refresh();
        }

        private void load_3d_harmonics_for_intensity_layers()
        {
            initialise_world_for_harmonics();
            _plm.BL.BLWaveSet.current_waveform_set.AddPolyLine3DHarmonicsAcrossIL(ref w, this.ClientRectangle, dpi, text_pen, harmonic_pen, highlighted_harmonic_pen, interpolated_harmonic_pen, highlighted_interpolated_harmonic_pen, checkBox_add_interpolated.Checked);
            this.Refresh();
        }

        #endregion


    }
}
