﻿using System;
using System.Windows.Forms;
using static Spectral1_VBClassLibrary.DataSet_Spectral_System;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using System.Threading;
using Spectral1.DATA_ACCESS;
using Spectral1.PARSER;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_Patch_Envelopes : UserControl
    {

        #region "=============================== DECLARATIONS =============================================="
        private PL_Main _plm;
        #endregion

        #region "=============================== EVENTS =============================================="

        private void button_SectionKS_Click(object sender, EventArgs e)
        {
            Int32 item_index = _plm.BL.DA.CGS.Table_adsr_section.CurrentRow.adsr_section_id;
            using (PL_KeyScaleVisualiser PLKSV = new PL_KeyScaleVisualiser(ks_types.section,_plm, item_index))
            {
                PLKSV.ShowDialog();
            }
        }

        private void button_EnvKS_Click(object sender, EventArgs e)
        {
            Int32 item_index = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.adsr_section_envelope_config_id;
            using (PL_KeyScaleVisualiser PLKSV = new PL_KeyScaleVisualiser(ks_types.envelope, _plm, item_index))
            {
                PLKSV.ShowDialog();
            }
        }

        private void button_animate_Click(object sender, EventArgs e)
        {
            string entry_note_text = comboBox_envelope_note.Text;
            for (int note_id = min_note_number; note_id <= max_note_number; note_id++)
            {
                String note_id_text = _plm.BL.DA.CGSS.Table_midi_note.DT.FindBymidi_note_id(note_id).midi_note_name;
                comboBox_envelope_note.Text = note_id_text;
                Thread.Sleep(100);
            }
            comboBox_envelope_note.Text = entry_note_text;
        }

        private void Table_adsr_section_row_changed(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_saving_or_loading == true) { return; }

             Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            _plm.BL.DA.DASpectral.data_changed.patch.set_adsr_section(_plm.BL.DA.CGS.Table_adsr_section.CurrentRow.adsr_section_id,true);
            _plm.SyncVisible();

            if (_plm.BL.DA.DASystem.flag_initialising_system == false) { uC_Envelope1.Refresh(); }

            int patch_id = _plm.BL.BLPatch.current_patch.patch_id;
            int adsr_section_id = _plm.BL.BLPatch.current_patch.current_adsr_section_id;
            string Section= _plm.BL.BLPatch.current_patch.get_string_adsr_section_name(patch_id,adsr_section_id);
            string Enabled = _plm.BL.BLPatch.current_patch.get_string_adsr_section_active(patch_id, adsr_section_id);
            string Duration = _plm.BL.BLPatch.current_patch.get_string_adsr_section_end_time_ms(patch_id, adsr_section_id);
            string EndKSU = _plm.BL.BLPatch.current_patch.get_string_adsr_section_end_KSU(patch_id, adsr_section_id);
            string EndKSL = _plm.BL.BLPatch.current_patch.get_string_adsr_section_end_KSL(patch_id, adsr_section_id);
            string Sample = _plm.BL.BLPatch.current_patch.get_string_adsr_section_sample_name(patch_id, adsr_section_id);
            string SampleMode = _plm.BL.BLPatch.current_patch.get_string_adsr_section_sample_mode(patch_id, adsr_section_id);

            _plm.spectral_parser.add_code_p_a_ConfigureSection(Section, Enabled, Duration, EndKSU, EndKSL, Sample, SampleMode);

            _plm.Cursor = entry_cursor;
        }

        private void Table_adsr_section_envelope_config_row_changed(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_saving_or_loading == true) { return; }
            if (_plm.BL.DA.DASystem.flag_suppress_patch_events == true) { return; }

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            _plm.BL.DA.DASpectral.data_changed.patch.set_adsr_section_envelope_config(_plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.adsr_section_id, _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.adsr_section_envelope_config_id,true);
            _plm.SyncVisible();

            if (_plm.BL.DA.DASystem.flag_initialising_system == false) { uC_Envelope1.Refresh(); }

            int patch_id = _plm.BL.BLPatch.current_patch.patch_id;
            int adsr_section_id = _plm.BL.BLPatch.current_patch.current_adsr_section_id;
            int adsr_section_envelope_config_id = _plm.BL.BLPatch.current_patch.current_adsr_section_envelope_config_id;
            _plm.spectral_parser.add_code_p_a_ConfigureEnvelope_DERIVED(patch_id, adsr_section_id, adsr_section_envelope_config_id);

            _plm.Cursor = entry_cursor;
        }

        private void pL_UC_AddDeleteDGV_ADSR_SelectionChanged(object sender, EventArgs e)
        {
            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            label_EnvSettingsTitle.Text = "'" + DA_Spectral.GetSectionNameFromID((adsr_sections)_plm.BL.DA.CGS.Table_adsr_section.CurrentRow.adsr_section_id) + "' envelope settings :";

            int os = pL_UC_AddDeleteDGV_ADSREnvelopes.DGV.FirstDisplayedScrollingRowIndex;
            _plm.BL.DA.CGS.Table_adsr_section_envelope_config.SetDefaultViewFilter("[patch_id] = " + _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id.ToString() + " AND [adsr_section_id] = " + _plm.BL.DA.CGS.Table_adsr_section.CurrentRow.adsr_section_id.ToString() + " AND [adsr_section_envelope_config_id] <> " + Convert.ToInt32(envelope.env_portamento).ToString());

            if (os > -1)
            {
                pL_UC_AddDeleteDGV_ADSREnvelopes.DGV.FirstDisplayedScrollingRowIndex = os;
            }
  
            _plm.Cursor = entry_cursor;
        }


        private void comboBox_envelope_note_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_suppress_patch_events == false) { uC_Envelope1.DisplayEnabled(true, true); }
        }

        #endregion

        #region "=============================== METHODS =============================================="

        public PL_UC_Patch_Envelopes()
        {
            InitializeComponent();
        }

        public void Initialise(ref PL_Main plm)
        {
            _plm = plm;

            BindingSource mn1bs = new BindingSource();
            mn1bs.DataSource = _plm.BL.DA.CGSS.Table_midi_note.DT;
            comboBox_envelope_note.DataSource = mn1bs;
            comboBox_envelope_note.DisplayMember = "midi_note_name";
            comboBox_envelope_note.ValueMember = "midi_note_id";
            comboBox_envelope_note.SelectedValue = c4_note_number;

            //ADSR Section Config
            _plm.BL.BLDGV.InitialiseADSRSectionConfigDGV(ref pL_UC_AddDeleteDGV_ADSR);
            _plm.BL.DA.CGS.Table_adsr_section.DT.RowChanged += Table_adsr_section_row_changed;
            pL_UC_AddDeleteDGV_ADSR.EVENT_DGVSelectionChanged += pL_UC_AddDeleteDGV_ADSR_SelectionChanged;

            //ADSR Section Envelope Config
            _plm.BL.BLDGV.InitialiseADSRSectionEnvelopeConfigDGV(ref pL_UC_AddDeleteDGV_ADSREnvelopes);
            _plm.BL.DA.CGS.Table_adsr_section_envelope_config.DT.RowChanged += Table_adsr_section_envelope_config_row_changed;
            uC_Envelope1.Initialise(plm);
        }

        public void DisplayEnabled(bool isEnabled,bool DoARefresh)
        {
            uC_Envelope1.DisplayEnabled(isEnabled, DoARefresh);
        }

        public void RefreshEnvelope()
        {
            uC_Envelope1.Refresh();
        }

        public Int32 envelope_note_for()
        {
            return Convert.ToInt32(comboBox_envelope_note.SelectedValue);
        }



        #endregion


    }
}
