﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using WarmBreeze_DataLibrary;
using static Spectral1_VBClassLibrary.DataSet_Spectral_System;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1.BUSINESS_LOGIC.BL_Spectral;
using Spectral1.BUSINESS_LOGIC;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_Patch : UserControl
    {

        #region "============================== DECLARATIONS ========================================"
        private PL_Main _plm;
        #endregion

        #region "========================== PROPERTIES ==================================="
        
        #endregion

        #region "============================== EVENTS ========================================"

        private void ts_patch_import_Click(object sender, EventArgs e)
        {
            using (PL_Import pli = new PL_Import(_plm))
            {
                pli.ShowDialog();
            }
        }

        private void ts_p_export_Click(object sender, EventArgs e)
        {
            using (PL_Export ple = new PL_Export(_plm))
            {
                ple.ShowDialog();
            }
        }

        private void pL_UC_AddDeleteDGV_Patch_EVENT_BeforeRowDeleted(object sender, EventArgs_BeforeRowDelete e)
        {
            Int32 current_patch_id = _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id;

            if (_plm.BL.DA.CGS.Table_patch_set_patches.DT.Select("patch_id = " + current_patch_id.ToString(), null, DataViewRowState.CurrentRows).Count() > 0)
            {
                _plm.PLInfo.DisplayExclamation("Row can't be deleted because PatchSet(s) refer to this patch. Delete PatchSet(s) first");
                e.OkToDelete = false;
                return;
            }

            if (_plm.BL.DA.CGS.Table_performance_channel.DT.Select("patch_id = " + current_patch_id.ToString(), null, DataViewRowState.CurrentRows).Count() > 0)
            {
                _plm.PLInfo.DisplayExclamation("Row can't be deleted because PatchSet(s) refer to this patch. Delete PatchSet(s) first");
                e.OkToDelete = false;
                return;
            }


            _plm.BL.DA.DASystem.flag_suppress_patch_events = true;
            _plm.Cursor = Cursors.WaitCursor;

            //Envelope config
            for (Int32 i = 0; i < max_lfos; i++)
            {
                _plm.BL.DA.CGS.Table_lfo_envelope_config.GetRow(current_patch_id, i).Delete();
            }

            //ADSR section and section envelope config
            for (Int32 a = 0; a < max_adsr_sections; a++)
            {
                _plm.BL.DA.CGS.Table_adsr_section.GetRow(current_patch_id, a).Delete();
                for (Int32 v = 0; v < max_envelopes; v++)
                {
                    _plm.BL.DA.CGS.Table_adsr_section_envelope_config.GetRow(current_patch_id, a, v).Delete();
                }
            }

            //Biquad
            for (Int32 b = 0; b < max_biquad_filters; b++)
            {
                _plm.BL.DA.CGS.Table_biquad_eq.GetRow(current_patch_id, b).Delete();
                _plm.BL.DA.CGS.Table_biquad_eq_calculated.GetRow(current_patch_id, b).Delete();
            }

            //Envelope control
            for (Int32 ec = 0; ec < max_envelopes; ec++)
            {
                _plm.BL.DA.CGS.Table_envelope_control.GetRow(current_patch_id, ec).Delete();
            }

            _plm.BL.DA.DASystem.flag_suppress_patch_events = false;
            _plm.Cursor = Cursors.Default;
        }

        public void InitialisePatchRelatedViewsForCurrentPatch()
        {
            _plm.BL.DA.CGS.Table_adsr_section.SetDefaultViewFilter("patch_id = " + _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id);
            _plm.BL.DA.CGS.Table_lfo_envelope_config.SetDefaultViewFilter("patch_id = " + _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id.ToString());
            _plm.BL.DA.CGS.Table_adsr_section.DefaultRowValues.patch_id = _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id;
            _plm.BL.DA.CGS.Table_biquad_eq.SetDefaultViewFilter("patch_id = " + _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id);
            _plm.BL.DA.CGS.Table_envelope_control.SetDefaultViewFilter("patch_id = " + _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id + " AND envelope_control_id <> " + Convert.ToInt32(envelope.env_portamento).ToString());
            _plm.BL.DA.CGS.Table_adsr_section_envelope_config.SetDefaultViewFilter("[patch_id] = " + _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id.ToString() + " AND [adsr_section_id] = " + _plm.BL.DA.CGS.Table_adsr_section.CurrentRow.adsr_section_id.ToString() + " AND [adsr_section_envelope_config_id] <> " + Convert.ToInt32(envelope.env_portamento).ToString());
            pL_UC_Patch_General2.LoadPatchGeneralFields();

            if ((_plm.BL.DA.DASystem.flag_initialising_system == false)||(_plm.BL.DA.DASystem.flag_importing_exporting == true)) { pL_UC_Patch_Envelopes2.DisplayEnabled(true,true); }
        }

        private void pL_UC_AddDeleteDGV_Patch_EVENT_DGVSelectionChanged(object sender, EventArgs e)
        {
            InitialiseForSelectedPatch(); 
        }

        private void pL_UC_AddDeleteDGV_Patch_EVENT_RowDeleted(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_importing_exporting == true) { return; }

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            _plm.BL.DA.DASystem.flag_suppress_patch_events = false;
            pL_UC_Patch_Envelopes2.RefreshEnvelope();
            _plm.RefreshUI();

            _plm.Cursor = entry_cursor;
        }

        private void ts_p_save_to_module_Click(object sender, EventArgs e)
        {
            if (_plm.BL.DA.CGS.Table_patch_set_patches.CurrentRow.RowIsEmpty == true)
            {
                _plm.PLInfo.DisplayExclamation("You must define a PatchSet before you can save the patch to the Module");
                return;
            }

            Int32 patch_id = _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id;
            string patch_name = _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_name;
            Int32 patch_set_id = _plm.BL.DA.CGS.Table_patch_set_patches.CurrentRow.patch_set_id;

            string filter_expression = "patch_id = " + patch_id.ToString() + " AND " + "patch_set_id = " + patch_set_id.ToString();
            patch_set_patchesRow[] rows = (patch_set_patchesRow[])_plm.BL.DA.CGS.Table_patch_set_patches.DT.Select(filter_expression, "", DataViewRowState.CurrentRows);

            for (Int32 r = 0; r < rows.Count(); r++)
            {
                if (rows[r].patch_id == patch_id)
                {
                    if (_plm.PLInfo.DisplayConfirm("Save patch '" + patch_name + "' to the module at PastchSetPatchID = " + rows[r].patch_set_patches_id.ToString()) == false)
                    {
                        return;
                    }
                    _plm.Cursor = Cursors.WaitCursor;
                    _plm.SetStatus("Saving patch to Module");
                    _plm.BL.DA.DAUSBComms.send_to_module_stop_play_mode();
                    _plm.BL.DA.DAUSBComms.send_to_module_save_patch_to_module(rows[r].patch_set_patches_id);
                    _plm.BL.DA.DAUSBComms.send_to_module_start_play_mode();
                    _plm.ClearStatus();
                    _plm.Cursor = Cursors.Default;
                    return;
                }
            }
            _plm.PLInfo.DisplayExclamation("The selected Patch is not defined in the current PatchSet. Patch can't be saved to the Module.");

        }

        private void ts_p_clone_Click(object sender, EventArgs e)
        {
            _plm.Cursor = Cursors.WaitCursor;
            _plm.SetStatus("Cloning Patch");
            _plm.BL.DA.DASystem.flag_suppress_patch_events = true;
            _plm.BL.BLPatch.current_patch.ClonePatch(_plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id);
            _plm.BL.DA.DASystem.flag_suppress_patch_events = false;
            _plm.Cursor = Cursors.Default;
            _plm.ClearStatus();
        }

        private void Table_patch_row_changed(object sender, EventArgs e)
        {
            if ((_plm.BL.DA.DASystem.flag_saving_or_loading == true)|| (_plm.BL.DA.DASystem.flag_importing_exporting == true)) { return; }

            _plm.BL.DA.DASpectral.data_changed.patch.set_misc(true);
            _plm.SyncVisible();

            if (_plm.BL.DA.DASystem.flag_saving_or_loading == false) { _plm.ClearStatus(); }
        }

        private void Table_patch_NewRowAdded(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_importing_exporting == true) { return; }

            patchRow PR = (patchRow)sender;
            PR.patch_guid8 = BL_Spectral.GetNewGuid8();

            if (_plm.BL.DA.DASystem.flag_suppress_patch_events == true) { return; }
            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;
            _plm.SetStatus("Creating Patch");

            pL_UC_Patch_Envelopes2.DisplayEnabled(false, false);
            _plm.BL.DA.DASystem.flag_suppress_patch_events = true;
            _plm.BL.BLPatch.current_patch.InitialisePatchRelatedTables(PR.patch_id, -1);
            _plm.BL.DA.DASystem.flag_suppress_patch_events = false;
            pL_UC_Patch_Envelopes2.DisplayEnabled(true, true);

            if (_plm.BL.DA.DASystem.flag_saving_or_loading == false) { _plm.ClearStatus(); }
            _plm.Cursor = entry_cursor;
            _plm.RefreshUI();
        }


        #endregion

        #region "============================== METHODS ========================================"

        public PL_UC_Patch()
        {
            InitializeComponent();
            tabControl_patch_config.Visible = false;
        }

        public void InitialiseForSelectedPatch()
        {
            if (_plm.BL.DA.DASystem.flag_importing_exporting == true) { return; }

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            InitialisePatchRelatedViewsForCurrentPatch();

            _plm.remote_SetDGVWaveSetToPatchesWaveSet();
            _plm.remote_SetDGVFilterToPatchFilter();

            if (_plm.BL.DA.DASystem.flag_saving_or_loading == false)
            {
                _plm.BL.DA.DASpectral.data_changed.set_all(true);
                _plm.SyncVisible();
            }

            if (_plm.BL.DA.DASystem.flag_saving_or_loading == false) { _plm.ClearStatus(); }
            _plm.Cursor = entry_cursor;
        }

        public void RefreshPatchCurrentValuesFromDGV()
        {
            DataGridView DGV = pL_UC_AddDeleteDGV_Patch.DGV;
            _plm.BL.DA.CGS.Table_patch.RefreshCurrentRowValuesFromDGV(ref DGV);
        }

        public void Initialise(PL_Main plm)
        {
            _plm = plm;

            pL_UC_Patch_Envelopes2.Initialise(ref _plm);
            pL_UC_Patch_General2.Initialise(ref _plm);

            //Patch
            _plm.BL.BLDGV.InitialisePatchDGV(ref pL_UC_AddDeleteDGV_Patch);
            _plm.BL.DA.CGS.Table_patch.DT.RowChanged += Table_patch_row_changed;
            _plm.BL.DA.CGS.Table_patch.Event_NewRowAdded += Table_patch_NewRowAdded;
  
        }

        public void SetIsConnectedInAnotherThread(bool IsConnected)
        {
            if (this.InvokeRequired)
            {
                this.Invoke((Action)(() => {
                    ts_p_save_to_module.Enabled = IsConnected;
                }));
            }
        }

        public void RefreshUI()
        {
            bool has_patches = (_plm.BL.DA.CGS.Table_patch.RowCount() > 0);
            pL_UC_Patch_Envelopes2.RefreshEnvelope();
            tabControl_patch_config.Visible = has_patches;
            ts_p_save_to_module.Enabled = has_patches;
            ts_p_clone.Enabled = has_patches;
            ts_p_save_to_module.Enabled = (_plm.BL.DA.DAUSBComms.IsConnected() && has_patches);
            ts_p_export.Enabled = has_patches;
        }

        public void DisplayEnabled(bool isEnabled,bool DoARefresh)
        {
            pL_UC_Patch_Envelopes2.DisplayEnabled(isEnabled, DoARefresh);
        }

        #endregion

        private void pL_UC_Patch_General2_Load(object sender, EventArgs e)
        {

        }

        public void InitialiseForLoadedFile()
        {
            pL_UC_Patch_General2.LoadPatchGeneralFields();
        }

        public Int32 envelope_note_for()
        {
            return pL_UC_Patch_Envelopes2.envelope_note_for();
        }

        public void remote_enable_envelope_display(bool e)
        {
            if (e)
            {
                pL_UC_Patch_Envelopes2.DisplayEnabled(true, true);
            }
            else
            {
                pL_UC_Patch_Envelopes2.DisplayEnabled(true, true);
            }
        }

        private void pL_UC_Patch_Envelopes2_Load(object sender, EventArgs e)
        {

        }
    }
}
