﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using WarmBreeze_DataLibrary;
using static Spectral1_VBClassLibrary.DataSet_Spectral_System;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1.BUSINESS_LOGIC.BL_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_Filters : UserControl
    {
        #region "============================ DECLARATIONS =========================================="
        private PL_Main _plm;
        #endregion

        #region "============================ EVENTS =========================================="
        private void pL_UC_AddDeleteOrderDGV_Filter_selection_changed(object sender, EventArgs e)
        {
            _plm.BL.BLFilter.set_current_body_resonance_filter(_plm.BL.DA.CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id);
            pL_UC_Filter_Graphic_EQ1.InitialiseForCurrentFilter();
            _plm.RefreshUI();
        }

        private void button_update_module_Click(object sender, EventArgs e)
        {
            pL_UC_Filter_Graphic_EQ1.SaveTrackBarLevelSettings();
            pL_UC_Filter_Graphic_EQ1.SendAllFilterValues();
        }

        private void pL_UC_AddDeleteOrderDGV_Filter_RowAdded(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_importing_exporting == true) { return; }

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;_plm.Refresh();
            _plm.SetStatus("Creating Filter");

            body_resonance_filterRow R = (body_resonance_filterRow)(sender);
            R.body_resonance_filter_guid8 = GetNewGuid8();
            Int32 body_resonance_filter_id = R.body_resonance_filter_id;
            for (Int32 b = 0; b < max_body_resonance_filter_bands; b++)
            {
                _plm.BL.DA.CGS.Table_body_resonance_filter_band.DeleteRow(body_resonance_filter_id, b);//Ensure any existing row is deleted
                _plm.BL.DA.CGS.Table_body_resonance_filter_band.AddRow3(body_resonance_filter_id, b, 255,0);
            }

            pL_UC_Filter_Graphic_EQ1.InitialiseForCurrentFilter();
            _plm.RefreshUI();

            _plm.ClearStatus();
            _plm.Cursor = entry_cursor;
        }

        private void pL_UC_AddDeleteOrderDGV_Filter_RowDeleted(object sender, EventArgs e)
        {
            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;
            pL_UC_Filter_Graphic_EQ1.InitialiseForCurrentFilter();

            Int32 body_resonance_filter_id = _plm.BL.DA.CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id;
            for (Int32 b = 0; b < max_body_resonance_filter_bands; b++)
            {
                body_resonance_filter_bandRow r = _plm.BL.DA.CGS.Table_body_resonance_filter_band.GetRow(body_resonance_filter_id, b);
                if(r != null) r.Delete();
            }

            _plm.RefreshUI();
            _plm.Cursor = entry_cursor;
        }

        private void button_view_module_version_Click(object sender, EventArgs e)
        {
            using (PL_Module_Filter_Visualiser PLMFV = new PL_Module_Filter_Visualiser(ref _plm))
            {
                PLMFV.ShowDialog();
            }
        }
        #endregion

        #region "============================ METHODS =========================================="
        public PL_UC_Filters()
        {
            InitializeComponent();
        }

        public void SetDGVFilterToPatchFilter()
        {
            if (_plm.BL.BLPatch.current_patch == null) return;

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            for (Int32 i = 0; i < pL_UC_AddDeleteDGV_Filter.DGV.Rows.Count; i++)
            {
                if (Convert.ToInt32(pL_UC_AddDeleteDGV_Filter.DGV.Rows[i].Cells["body_resonance_filter_id"].Value) == _plm.BL.BLPatch.current_patch.body_resonance_filter_id)
                {
                    pL_UC_AddDeleteDGV_Filter.DGV.CurrentCell = pL_UC_AddDeleteDGV_Filter.DGV.Rows[i].Cells[2];
                    DataGridView DGV = pL_UC_AddDeleteDGV_Filter.DGV;
                    _plm.BL.BLFilter.set_current_body_resonance_filter(_plm.BL.BLPatch.current_patch.body_resonance_filter_id);
                    _plm.BL.DA.CGS.Table_body_resonance_filter.RefreshCurrentRowValuesFromDGV(ref DGV);
                    break;
                }
            }

            pL_UC_Filter_Graphic_EQ1.InitialiseForCurrentFilter();

            _plm.Cursor = entry_cursor;
        }

        public void Initialise(PL_Main plm)
        {
            _plm = plm;

            //Body resonance filters
            _plm.BL.BLDGV.InitialiseFilterDGV(ref pL_UC_AddDeleteDGV_Filter);
            pL_UC_AddDeleteDGV_Filter.EVENT_DGVSelectionChanged += pL_UC_AddDeleteOrderDGV_Filter_selection_changed;
            _plm.BL.DA.CGS.Table_body_resonance_filter.Event_NewRowAdded += pL_UC_AddDeleteOrderDGV_Filter_RowAdded;
            pL_UC_AddDeleteDGV_Filter.EVENT_RowDeleted += pL_UC_AddDeleteOrderDGV_Filter_RowDeleted;

            pL_UC_Filter_Graphic_EQ1.Initialise(_plm);
        }

        public void RefreshUI()
        {
            if (_plm.BL.DA.CGS.Table_body_resonance_filter.RowCount() > 1) //1 because using --None-- as row 0
            {
                SetGraphicEQVisibility(true);
                button_view_module_version.Enabled = true;
            }
            else
            {
                SetGraphicEQVisibility(false);
                button_view_module_version.Enabled = false;
            }
        }

        private void SetGraphicEQVisibility(bool ISVisible)
        {
            pL_UC_Filter_Graphic_EQ1.Visible = ISVisible;
        }

        #endregion

        private void pL_UC_Filter_Graphic_EQ1_Load(object sender, EventArgs e)
        {

        }


    }
}
