﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Spectral1_VBClassLibrary;
using WarmBreeze_DataLibrary;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using Spectral1.DATA_ACCESS;
using static Spectral1.BUSINESS_LOGIC.BL_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_Filter_Graphic_EQ : UserControl
    {
        const int max_fader_value = 8191;
        const int min_fader_value = -8192;

        const int dbPlus3value = 362;
        const int dbPlus6value = 511;
        const int dbPlus12value = 1023;
        const int dbPlus24value = 4095;

        const int dbMinus3value = 181;
        const int dbMinus6value = 128;
        const int dbMinus12value = 64;
        const int dbMinus24value = 16;

        const double Scaling_Factor = 13606.22;
        const double dBPoint5Divisor = 1.019373486;
        const double dB1Divisor = 1.039122304;
        const double dB1Point5Divisor = 1.059253725;
        const double dB2Divisor = 1.079775162;
        const double dB3Divisor = 1.122018454;
        const double dB6Divisor = 1.258925412;
        const double dB12Divisor = 1.584893192;

        PL_Info PLInfo = new PL_Info();
        PL_Main _plm;
        CodeGen_DS_Spectral _CGS;
        CodeGen_DS_Spectral_System _CGSS;

        public PL_UC_Filter_Graphic_EQ()
        {
            InitializeComponent();
        }

        #region "========================= Methods - General ============================================="

        public void Initialise(PL_Main plm)
        {
            SetStyle(ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint | ControlStyles.DoubleBuffer, true);

            _plm = plm;
            _CGS = _plm.BL.DA.CGS;
            _CGSS = _plm.BL.DA.CGSS;

            comboBox_shelve.Items.Add("Low-pass");
            comboBox_shelve.Items.Add("High-pass");
            comboBox_shelve.Text = "Low-pass";

            comboBox_level.Items.Add("-12dB");
            comboBox_level.Items.Add("-6dB");
            comboBox_level.Items.Add("-3dB");
            comboBox_level.Items.Add("0dB");
            comboBox_level.Items.Add("+3dB");
            comboBox_level.Items.Add("+6dB");
            comboBox_level.Items.Add("+12dB");
            comboBox_level.Text = "0dB";

            comboBox_shleve_rate.Items.Add("12dB");
            comboBox_shleve_rate.Items.Add("6dB");
            comboBox_shleve_rate.Items.Add("3dB");
            comboBox_shleve_rate.Items.Add("2dB");
            comboBox_shleve_rate.Items.Add("1.5dB");
            comboBox_shleve_rate.Items.Add("1dB");
            comboBox_shleve_rate.Items.Add("0.5dB");
            comboBox_shleve_rate.Text = "12dB";

            comboBox_cutoff.Items.Add("16");
            comboBox_cutoff.Items.Add("20");
            comboBox_cutoff.Items.Add("25");
            comboBox_cutoff.Items.Add("31");
            comboBox_cutoff.Items.Add("40");
            comboBox_cutoff.Items.Add("50");
            comboBox_cutoff.Items.Add("63");
            comboBox_cutoff.Items.Add("80");
            comboBox_cutoff.Items.Add("100");
            comboBox_cutoff.Items.Add("126");
            comboBox_cutoff.Items.Add("160");
            comboBox_cutoff.Items.Add("200");
            comboBox_cutoff.Items.Add("250");
            comboBox_cutoff.Items.Add("315");
            comboBox_cutoff.Items.Add("400");
            comboBox_cutoff.Items.Add("500");
            comboBox_cutoff.Items.Add("630");
            comboBox_cutoff.Items.Add("800");
            comboBox_cutoff.Items.Add("1k");
            comboBox_cutoff.Items.Add("1k6");
            comboBox_cutoff.Items.Add("2k");
            comboBox_cutoff.Items.Add("2k5");
            comboBox_cutoff.Items.Add("3k1");
            comboBox_cutoff.Items.Add("4k");
            comboBox_cutoff.Items.Add("5k");
            comboBox_cutoff.Items.Add("6k3");
            comboBox_cutoff.Items.Add("8k");
            comboBox_cutoff.Items.Add("10k");
            comboBox_cutoff.Items.Add("12k");
            comboBox_cutoff.Items.Add("16k");
            comboBox_cutoff.Items.Add("20k");
            comboBox_cutoff.Text = "5k";

            timerB.Interval = 100;
            timerB.Start();

            if (_plm.BL.DA.CGS.Table_body_resonance_filter.RowCount() == 0) { return; }
            InitialiseForCurrentFilter();

        }


        private Int32 DB2V(Int32 tbv)
        {
            //Translates trackbar value to the table level value (0 to 65535)

            const double multiplier = 256.0;

            return (Int32)(Math.Pow(10, tbv / Scaling_Factor) * multiplier);
        }

        private Double V2DB(Int32 v)
        {
            //Translates table value (0 to 65535) to trackbar value(-8192 to 8191)
            /*
            
            TABLE VALUE     |   TRACKBAR VALUE
            ==================================
                    1       |       -32,767  
                    256     |       0
                    65536   |       32767
              
            */


            if (v < 1) { v = 1; }
            Int32 result_value = (Int32)(Math.Log10((Double)v / (Double)256.0) * Scaling_Factor);
            if (result_value > max_fader_value) { result_value = max_fader_value; }
            else if (result_value < min_fader_value) { result_value = min_fader_value; }
            return result_value;
        }

        public void SendAllFilterValues()
        {
            Int32 body_resonance_filter_id = _CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id;
            double filter_scaling_factor;
            if (_plm.BL.BLFilter.current_body_resonance_filter != null)
            { filter_scaling_factor = _plm.BL.BLFilter.current_body_resonance_filter.GetFilterScalingFactor(); }
            else
            { filter_scaling_factor = 1; } 

            _plm.BL.DA.DAUSBComms.RecalcFilterSlopes(body_resonance_filter_id, filter_scaling_factor);
            SendFilterBands();
        }


        public void InitialiseForCurrentFilter()
        {
            trackBar_0.Maximum = max_fader_value;
            trackBar_0.Minimum = min_fader_value;
            trackBar_0.Value = Convert.ToInt32(V2DB(GetBandLevelValue(0)));

            trackBar_1.Maximum = max_fader_value;
            trackBar_1.Minimum = min_fader_value;
            trackBar_1.Value = Convert.ToInt32(V2DB(GetBandLevelValue(1)));

            trackBar_2.Maximum = max_fader_value;
            trackBar_2.Minimum = min_fader_value;
            trackBar_2.Value = Convert.ToInt32(V2DB(GetBandLevelValue(2)));

            trackBar_3.Maximum = max_fader_value;
            trackBar_3.Minimum = min_fader_value;
            trackBar_3.Value = Convert.ToInt32(V2DB(GetBandLevelValue(3)));

            trackBar_4.Maximum = max_fader_value;
            trackBar_4.Minimum = min_fader_value;
            trackBar_4.Value = Convert.ToInt32(V2DB(GetBandLevelValue(4)));

            trackBar_5.Maximum = max_fader_value;
            trackBar_5.Minimum = min_fader_value;
            trackBar_5.Value = Convert.ToInt32(V2DB(GetBandLevelValue(5)));

            trackBar_6.Maximum = max_fader_value;
            trackBar_6.Minimum = min_fader_value;
            trackBar_6.Value = Convert.ToInt32(V2DB(GetBandLevelValue(6)));

            trackBar_7.Maximum = max_fader_value;
            trackBar_7.Minimum = min_fader_value;
            trackBar_7.Value = Convert.ToInt32(V2DB(GetBandLevelValue(7)));

            trackBar_8.Maximum = max_fader_value;
            trackBar_8.Minimum = min_fader_value;
            trackBar_8.Value = Convert.ToInt32(V2DB(GetBandLevelValue(8)));

            trackBar_9.Maximum = max_fader_value;
            trackBar_9.Minimum = min_fader_value;
            trackBar_9.Value = Convert.ToInt32(V2DB(GetBandLevelValue(9)));

            trackBar_10.Maximum = max_fader_value;
            trackBar_10.Minimum = min_fader_value;
            trackBar_10.Value = Convert.ToInt32(V2DB(GetBandLevelValue(10)));

            trackBar_11.Maximum = max_fader_value;
            trackBar_11.Minimum = min_fader_value;
            trackBar_11.Value = Convert.ToInt32(V2DB(GetBandLevelValue(11)));

            trackBar_12.Maximum = max_fader_value;
            trackBar_12.Minimum = min_fader_value;
            trackBar_12.Value = Convert.ToInt32(V2DB(GetBandLevelValue(12)));

            trackBar_13.Maximum = max_fader_value;
            trackBar_13.Minimum = min_fader_value;
            trackBar_13.Value = Convert.ToInt32(V2DB(GetBandLevelValue(13)));

            trackBar_14.Maximum = max_fader_value;
            trackBar_14.Minimum = min_fader_value;
            trackBar_14.Value = Convert.ToInt32(V2DB(GetBandLevelValue(14)));

            trackBar_15.Maximum = max_fader_value;
            trackBar_15.Minimum = min_fader_value;
            trackBar_15.Value = Convert.ToInt32(V2DB(GetBandLevelValue(15)));

            trackBar_16.Maximum = max_fader_value;
            trackBar_16.Minimum = min_fader_value;
            trackBar_16.Value = Convert.ToInt32(V2DB(GetBandLevelValue(16)));

            trackBar_17.Maximum = max_fader_value;
            trackBar_17.Minimum = min_fader_value;
            trackBar_17.Value = Convert.ToInt32(V2DB(GetBandLevelValue(17)));

            trackBar_18.Maximum = max_fader_value;
            trackBar_18.Minimum = min_fader_value;
            trackBar_18.Value = Convert.ToInt32(V2DB(GetBandLevelValue(18)));

            trackBar_19.Maximum = max_fader_value;
            trackBar_19.Minimum = min_fader_value;
            trackBar_19.Value = Convert.ToInt32(V2DB(GetBandLevelValue(19)));

            trackBar_20.Maximum = max_fader_value;
            trackBar_20.Minimum = min_fader_value;
            trackBar_20.Value = Convert.ToInt32(V2DB(GetBandLevelValue(20)));

            trackBar_21.Maximum = max_fader_value;
            trackBar_21.Minimum = min_fader_value;
            trackBar_21.Value = Convert.ToInt32(V2DB(GetBandLevelValue(21)));

            trackBar_22.Maximum = max_fader_value;
            trackBar_22.Minimum = min_fader_value;
            trackBar_22.Value = Convert.ToInt32(V2DB(GetBandLevelValue(22)));

            trackBar_23.Maximum = max_fader_value;
            trackBar_23.Minimum = min_fader_value;
            trackBar_23.Value = Convert.ToInt32(V2DB(GetBandLevelValue(23)));

            trackBar_24.Maximum = max_fader_value;
            trackBar_24.Minimum = min_fader_value;
            trackBar_24.Value = Convert.ToInt32(V2DB(GetBandLevelValue(24)));

            trackBar_25.Maximum = max_fader_value;
            trackBar_25.Minimum = min_fader_value;
            trackBar_25.Value = Convert.ToInt32(V2DB(GetBandLevelValue(25)));

            trackBar_26.Maximum = max_fader_value;
            trackBar_26.Minimum = min_fader_value;
            trackBar_26.Value = Convert.ToInt32(V2DB(GetBandLevelValue(26)));

            trackBar_27.Maximum = max_fader_value;
            trackBar_27.Minimum = min_fader_value;
            trackBar_27.Value = Convert.ToInt32(V2DB(GetBandLevelValue(27)));

            trackBar_28.Maximum = max_fader_value;
            trackBar_28.Minimum = min_fader_value;
            trackBar_28.Value = Convert.ToInt32(V2DB(GetBandLevelValue(28)));

            trackBar_29.Maximum = max_fader_value;
            trackBar_29.Minimum = min_fader_value;
            trackBar_29.Value = Convert.ToInt32(V2DB(GetBandLevelValue(29)));

            trackBar_30.Maximum = max_fader_value;
            trackBar_30.Minimum = min_fader_value;
            trackBar_30.Value = Convert.ToInt32(V2DB(GetBandLevelValue(30)));

            trackBar_31.Maximum = max_fader_value;
            trackBar_31.Minimum = min_fader_value;
            trackBar_31.Value = Convert.ToInt32(V2DB(GetBandLevelValue(31)));

            SendAllFilterValues();
        }

        private TrackBar GetTrackBar(int index)
        {
            switch (index)
            {
                case 0:
                    return trackBar_0;
                case 1:
                    return trackBar_1;
                case 2:
                    return trackBar_2;
                case 3:
                    return trackBar_3;
                case 4:
                    return trackBar_4;
                case 5:
                    return trackBar_5;
                case 6:
                    return trackBar_6;
                case 7:
                    return trackBar_7;
                case 8:
                    return trackBar_8;
                case 9:
                    return trackBar_9;
                case 10:
                    return trackBar_10;
                case 11:
                    return trackBar_11;
                case 12:
                    return trackBar_12;
                case 13:
                    return trackBar_13;
                case 14:
                    return trackBar_14;
                case 15:
                    return trackBar_15;
                case 16:
                    return trackBar_16;
                case 17:
                    return trackBar_17;
                case 18:
                    return trackBar_18;
                case 19:
                    return trackBar_19;
                case 20:
                    return trackBar_20;
                case 21:
                    return trackBar_21;
                case 22:
                    return trackBar_22;
                case 23:
                    return trackBar_23;
                case 24:
                    return trackBar_24;
                case 25:
                    return trackBar_25;
                case 26:
                    return trackBar_26;
                case 27:
                    return trackBar_27;
                case 28:
                    return trackBar_28;
                case 29:
                    return trackBar_29;
                case 30:
                    return trackBar_30;
                case 31:
                    return trackBar_31;
                default:
                    return trackBar_0;
            }
        }

        public void SaveTrackBarLevelSettings()
        {
            TrackBar t;
            Int32 i;
            for (i = 0; i < DA_Spectral.max_body_resonance_filter_bands; i++)
            {
                t = GetTrackBar(i);
                _CGS.Table_body_resonance_filter_band.GetRow(_CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id, i).level = DB2V(t.Value);
            }
        }

        private void SendFilterBands()
        {
            Int32 current_patch_body_resonance_filter_id = _CGS.Table_patch.CurrentRow.body_resonance_filter_id;
            if(current_patch_body_resonance_filter_id == 0){ return;}
            _plm.BL.DA.DASpectral.data_changed.filter.set_all(true);
            _plm.SyncVisible();
        }

        private Int32 GetBandLevelValue(Int32 b)
        {
            body_resonance_filter_bandRow R = _CGS.Table_body_resonance_filter_band.GetRow(_CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id, b);
            if (R == null)
            {
                return 0;
            }
            else
            {
                return R.level;
            }
        }

  

        private void SetBandLevelValue(Int32 b, Int32 L)
        {
            Int32 body_resonance_filter_id = _CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id;
            body_resonance_filter_bandRow r = _CGS.Table_body_resonance_filter_band.GetRow(body_resonance_filter_id, b);
            if (r != null)
            {
                r.level = L;
            }

        }

        #endregion

        #region "===================== Events - Fader Scroll =========================================="
        private void trackBar_0_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(0,true);
            _plm.SyncVisible();
        }

        private void trackBar_1_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(1,true);
            _plm.SyncVisible();
        }

        private void trackBar_2_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(2,true);
            _plm.SyncVisible();
        }

        private void trackBar_3_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(3, true);
            _plm.SyncVisible();
        }

        private void trackBar_4_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(4, true);
            _plm.SyncVisible();
        }

        private void trackBar_5_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(5, true);
            _plm.SyncVisible();
        }

        private void trackBar_6_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(6, true);
            _plm.SyncVisible();
        }

        private void trackBar_7_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(7, true);
            _plm.SyncVisible();
        }

        private void trackBar_8_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(8, true);
            _plm.SyncVisible();
        }

        private void trackBar_9_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(9, true);
            _plm.SyncVisible();
        }

        private void trackBar_10_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(10, true);
            _plm.SyncVisible();
        }

        private void trackBar_11_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(11, true);
            _plm.SyncVisible();
        }

        private void trackBar_12_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(12, true);
            _plm.SyncVisible();
        }

        private void trackBar_13_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(13, true);
            _plm.SyncVisible();
        }

        private void trackBar_14_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(14, true);
            _plm.SyncVisible();
        }

        private void trackBar_15_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(15, true);
            _plm.SyncVisible();
        }

        private void trackBar_16_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(16, true);
            _plm.SyncVisible();
        }

        private void trackBar_17_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(17, true);
            _plm.SyncVisible();
        }

        private void trackBar_18_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(18, true);
            _plm.SyncVisible();
        }

        private void trackBar_19_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(19, true);
            _plm.SyncVisible();
        }

        private void trackBar_20_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(20, true);
            _plm.SyncVisible();
        }

        private void trackBar_21_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(21, true);
            _plm.SyncVisible();
        }

        private void trackBar_22_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(22, true);
            _plm.SyncVisible();
        }

        private void trackBar_23_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(23, true);
            _plm.SyncVisible();
        }

        private void trackBar_24_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(24, true);
            _plm.SyncVisible();
        }

        private void trackBar_25_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(25, true);
            _plm.SyncVisible();
        }

        private void trackBar_26_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(26, true);
            _plm.SyncVisible();
        }

        private void trackBar_27_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(27, true);
            _plm.SyncVisible();
        }

        private void trackBar_28_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(28, true);
            _plm.SyncVisible();
        }

        private void trackBar_29_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(29, true);
            _plm.SyncVisible();
        }

        private void trackBar_30_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(30, true);
            _plm.SyncVisible();
        }

        private void trackBar_31_Scroll(object sender, EventArgs e)
        {
            _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(31, true);
            _plm.SyncVisible();
        }

        #endregion

        #region "===================== Events - other ============================================"

        private void timerB_Tick(object sender, EventArgs e)
        {
            Int32 body_resonance_filter_id = _CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id;
            for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                if (_plm.BL.DA.DASpectral.data_changed.filter.get_body_resonance_filter_band(b) == true)
                {
                    SetBandLevelValue(b, DB2V(GetTrackBar(b).Value));
                }
            }
            double filter_scaling_factor;
            if (_plm.BL.BLFilter.current_body_resonance_filter != null)
            { filter_scaling_factor = _plm.BL.BLFilter.current_body_resonance_filter.GetFilterScalingFactor(); }
            else
            { filter_scaling_factor = 1; }
            _plm.BL.DA.DAUSBComms.RecalcFilterSlopes(body_resonance_filter_id, filter_scaling_factor);
        }

        private void SetBandsTo(Int32 v)
        {
            for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                GetTrackBar(b).Value = Convert.ToInt32(V2DB(v)); ;
                _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(b,true);
                _plm.SyncVisible();
                SetBandLevelValue(b, DB2V(GetTrackBar(b).Value));
            }
        }

        private void button_set_dynamic_range_Click(object sender, EventArgs e)
        {
            Int32 body_resonance_filter_id = _plm.BL.DA.CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id;
            Double[] vdB = new Double[DA_Spectral.max_body_resonance_filter_bands];
            Double max_level = 0;
            Double min_level = 0;

            for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                vdB[b] = V2DB(_plm.BL.DA.CGS.Table_body_resonance_filter_band.GetRow(body_resonance_filter_id, b).level);
                if (vdB[b] > max_level) { max_level = vdB[b]; }
                if (vdB[b] < min_level) { min_level = vdB[b]; }
            }

            Double range_adj_perc = 1 + (Double)numericUpDown_dynamicRange.Value/100.0;
            for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                GetTrackBar(b).Value = bounded_int16(Convert.ToInt32(vdB[b] * range_adj_perc));
                _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(b,true);
                _plm.SyncVisible();
                SetBandLevelValue(b, DB2V(GetTrackBar(b).Value));
            }
        }

        private void button_SetShelf_Click(object sender, EventArgs e)
        {
            Int32 start_b = comboBox_cutoff.SelectedIndex;
            Double v;
            string svt = comboBox_shleve_rate.Text;
            Double divisor = 1;
            switch (svt)
            {
                case "0.5dB":
                    divisor = dBPoint5Divisor;
                    break;
                case "1dB":
                    divisor = dB1Divisor;
                    break;
                case "1.5dB":
                    divisor = dB1Point5Divisor;
                    break;
                case "2dB":
                    divisor = dB2Divisor;
                    break;
                case "3dB":
                    divisor = dB3Divisor;
                    break;
                case "6dB":
                    divisor = dB6Divisor;
                    break;
                case "12dB":
                    divisor = dB12Divisor;
                    break;
            }
            v = 1024;
            if (comboBox_shelve.Text == "High-pass")
            {
                for (Int32 b = start_b; b >= 0; b--)
                {
                    GetTrackBar(b).Value = Convert.ToInt32(V2DB((Int32)v)); ;
                    _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(b, true);
                    _plm.SyncVisible();
                    SetBandLevelValue(b, DB2V(GetTrackBar(b).Value));
                    v = v / divisor;
                }
                if (start_b < 31)
                {
                    for (Int32 b = start_b; b < DA_Spectral.max_body_resonance_filter_bands; b++)
                    {
                        GetTrackBar(b).Value = Convert.ToInt32(V2DB(1024)); ;
                        _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(b, true);
                        _plm.SyncVisible();
                        SetBandLevelValue(b, DB2V(GetTrackBar(b).Value));
                    }
                }
            }
            else
            {
                for (Int32 b = start_b; b < DA_Spectral.max_body_resonance_filter_bands; b++)
                {
                    GetTrackBar(b).Value = Convert.ToInt32(V2DB((Int32)v)); ;
                    _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(b, true);
                    _plm.SyncVisible();
                    SetBandLevelValue(b, DB2V(GetTrackBar(b).Value));
                    v = v / divisor;
                }
                if (start_b > 0)
                {
                    for (Int32 b = start_b; b >= 0; b--)
                    {
                        GetTrackBar(b).Value = Convert.ToInt32(V2DB(1024)); ;
                        _plm.BL.DA.DASpectral.data_changed.filter.set_body_resonance_filter_band(b, true);
                        _plm.SyncVisible();
                        SetBandLevelValue(b, DB2V(GetTrackBar(b).Value));
                    }
                }
            }
        }

        private void button_set_level_Click(object sender, EventArgs e)
        {
            switch (comboBox_level.Text)
            {
                case "-12dB":
                    SetBandsTo(dbMinus12value);
                    break;
                case "-6dB":
                    SetBandsTo(dbMinus6value);
                    break;
                case "-3dB":
                    SetBandsTo(dbMinus3value);
                    break;
                case "0dB":
                    SetBandsTo(256);
                    break;
                case "+3dB":
                    SetBandsTo(dbPlus3value);
                    break;
                case "+6dB":
                    SetBandsTo(dbPlus6value);
                    break;
                case "+12dB":
                    SetBandsTo(dbPlus12value);
                    break;
            }
        }




        #endregion


    }
}
