﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1.BUSINESS_LOGIC.BL_KeyScaling;

namespace Spectral1.PRESENTATION
{
    public partial class PL_KeyScaleVisualiser : Form
    {
        ks_types _ks_type;
        PL_Main _plm;
        Int32 _item_index;
        Int16 ks_swx32;
        Double ks_sp0to100;

        public PL_KeyScaleVisualiser(ks_types ks_type, PL_Main plm,Int32 item_index)
        {
            InitializeComponent();
            _plm = plm;
            _ks_type = ks_type;
            _item_index = item_index;
            initialise_chart();
        }

        private void panel_keyscaling_Paint(object sender, PaintEventArgs e)
        {

        }

        private void button_close_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void initialise_chart()
        {
            Int32 key_scale_split_note_id = _plm.BL.BLPatch.current_patch.key_scale_split_note_id;
            Int32 diff_from_split;
            Int32 value;

            this.chart1.Series.Clear();
            this.chart1.Palette = ChartColorPalette.EarthTones;
            this.chart1.ChartAreas["ChartArea1"].AxisY.LabelAutoFitStyle = LabelAutoFitStyles.None;
            this.chart1.ChartAreas["ChartArea1"].AxisX.LabelStyle.Font = new System.Drawing.Font("Segoe UI", 7, System.Drawing.FontStyle.Regular);
            this.chart1.ChartAreas["ChartArea1"].Position.X = 0;
            this.chart1.ChartAreas["ChartArea1"].Position.Width = (float)98.9;
            this.chart1.ChartAreas["ChartArea1"].Position.Height = 100;
            this.chart1.ChartAreas["ChartArea1"].Position.Y = 0;

            this.chart1.ChartAreas["ChartArea1"].AxisX.LabelStyle.Enabled = false;
            this.chart1.ChartAreas["ChartArea1"].AxisX.Interval = 12;
            this.chart1.ChartAreas["ChartArea1"].AxisX.IntervalAutoMode = IntervalAutoMode.FixedCount;
            this.chart1.ChartAreas["ChartArea1"].AxisX.IntervalOffset = 3;
            this.chart1.ChartAreas["ChartArea1"].AxisX.Minimum = a0_note_number;
            this.chart1.ChartAreas["ChartArea1"].AxisX.Maximum = c8_note_number;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.Enabled = true;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.Interval = 1;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.LineColor = Color.Gainsboro;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.LineDashStyle = ChartDashStyle.Solid;
            this.chart1.Legends[0].BackColor = Color.AntiqueWhite;

            if (_ks_type == ks_types.section)
            {
                string item_name = "Key-scaling for : " + _plm.BL.DA.CGSS.Table_adsr_section.GetRow(_item_index).adsr_section_name;
                label_Value.Text = item_name + " ► End-Time";

                Int32 end_time_ms = _plm.BL.DA.CGS.Table_adsr_section.CurrentRow.end_time_ms;
                Double end_time_ms_keyscale_lower = _plm.BL.BLPatch.current_patch.current_adsr_section_row.end_time_ms_keyscale_lower;
                Double end_time_ms_keyscale_upper = _plm.BL.BLPatch.current_patch.current_adsr_section_row.end_time_ms_keyscale_upper;
                string[] section_seriesArray = { "section end-time ms" };
                Series series = this.chart1.Series.Add(section_seriesArray[0]);
                series.YValueType = ChartValueType.Int32;
                series.MarkerStyle = MarkerStyle.Circle;
                series.MarkerSize = 5;
                series.MarkerColor = Color.Red;
                series.IsValueShownAsLabel = false;
                series.SmartLabelStyle.Enabled = false;
                series.ChartType = SeriesChartType.Line;
                series.Color = Color.Red;
                series.BorderWidth = 3;

                for (Int32 midi_note_id = a0_note_number; midi_note_id < c8_note_number; midi_note_id++)
                {
                    diff_from_split = midi_note_id - key_scale_split_note_id;
                    if (midi_note_id >= key_scale_split_note_id)
                    {
                        ks_swx32 = get_ks_swx32_for_value_usw((UInt16)end_time_ms, end_time_ms_keyscale_upper);
                        value = (Int32)(end_time_ms + (diff_from_split *  (ks_swx32 / 32)));
                    }
                    else
                    {
                        ks_swx32 = get_ks_swx32_for_value_usw((UInt16)end_time_ms, end_time_ms_keyscale_lower);
                        value = (Int32)(end_time_ms + (-diff_from_split * (ks_swx32 / 32)));
                    }
                    if (value < 0) { value = 0; }
                    else if (value > 65535) { value = 65535; }

                    series.Points.AddXY(midi_note_id, value);
                    if (((midi_note_id - a0_note_number) % 12 == 0) || (midi_note_id == key_scale_split_note_id))
                    {
                        series.Points[midi_note_id - a0_note_number].Label = value.ToString() + "ms";
                        series.Points[midi_note_id - a0_note_number].MarkerColor = Color.Black;
                    }
                    else
                    {
                        series.Points[midi_note_id - a0_note_number].MarkerSize = 3;
                    }
                }
            }
            else
            {
                string item_name = _plm.BL.DA.CGSS.Table_envelope.GetRow(_item_index).envelope_name;
                Int32 adsr_section_id = _plm.BL.DA.CGS.Table_adsr_section.CurrentRow.adsr_section_id;
                label_Value.Text = "Key-scaling for : " + _plm.BL.DA.CGSS.Table_adsr_section.GetRow(adsr_section_id).adsr_section_name + " ► " + item_name + " envelope";

                Double depth_env_target_usp0to100 = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_target;
                Double depth_env_target_keyscale_lower_sp0to100 = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_target_keyscale_lower;
                Double depth_env_target_keyscale_upper_sp0to100 = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_target_keyscale_upper;
                Double depth_env_target_value_usp0to100;

                Double depth_env_lin_delta = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_lin_delta;
                Double depth_env_lin_delta_keyscale_lower = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_lin_delta_keyscale_lower;
                Double depth_env_lin_delta_keyscale_upper = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_lin_delta_keyscale_upper;
                Double depth_env_lin_delta_value;

                Double depth_env_exp_multiplier_usp0to100 = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_exp_multiplier;
                Double depth_env_exp_multiplier_keyscale_lower_sp0to100 = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_exp_multiplier_keyscale_lower;
                Double depth_env_exp_multiplier_keyscale_upper_sp0to100 = _plm.BL.DA.CGS.Table_adsr_section_envelope_config.CurrentRow.depth_env_exp_multiplier_keyscale_upper;
                Double depth_env_exp_multiplier_value_usp0to100;
                string[] envelope_seriesArray = { "target%","linear delta","exponential delta%'"};

                Series series_target = this.chart1.Series.Add(envelope_seriesArray[0]);
                series_target.YValueType = ChartValueType.Int32;
                series_target.MarkerStyle = MarkerStyle.Circle;
                series_target.MarkerSize = 5;
                series_target.MarkerColor = Color.Green;
                series_target.IsValueShownAsLabel = false;
                series_target.SmartLabelStyle.Enabled = false;
                series_target.ChartType = SeriesChartType.Line;
                series_target.Color = Color.Green;
                series_target.BorderWidth = 3;

                Series series_linear_delta = this.chart1.Series.Add(envelope_seriesArray[1]);
                series_linear_delta.YValueType = ChartValueType.Int32;
                series_linear_delta.MarkerStyle = MarkerStyle.Circle;
                series_linear_delta.MarkerSize = 5;
                series_linear_delta.MarkerColor = Color.Blue;
                series_linear_delta.IsValueShownAsLabel = false;
                series_linear_delta.SmartLabelStyle.Enabled = false;
                series_linear_delta.ChartType = SeriesChartType.Line;
                series_linear_delta.Color = Color.Blue;
                series_linear_delta.BorderWidth = 3;

                Series series_exp_mult = this.chart1.Series.Add(envelope_seriesArray[2]);
                series_exp_mult.YValueType = ChartValueType.Int32;
                series_exp_mult.MarkerStyle = MarkerStyle.Circle;
                series_exp_mult.MarkerSize = 5;
                series_exp_mult.MarkerColor = Color.Orange;
                series_exp_mult.IsValueShownAsLabel = false;
                series_exp_mult.SmartLabelStyle.Enabled = false;
                series_exp_mult.ChartType = SeriesChartType.Line;
                series_exp_mult.Color = Color.Orange;
                series_exp_mult.BorderWidth = 3;

                for (Int32 midi_note_id = a0_note_number; midi_note_id < c8_note_number; midi_note_id++)
                {
                    diff_from_split = midi_note_id - key_scale_split_note_id;

                    //-------- Target--------
                    if (midi_note_id >= key_scale_split_note_id)
                    {
                        depth_env_target_value_usp0to100 = (Int32)(depth_env_target_usp0to100 + (diff_from_split * (depth_env_target_keyscale_upper_sp0to100/100.0)* depth_env_target_usp0to100));
                    }
                    else
                    {
                        depth_env_target_value_usp0to100 = (Int32)(depth_env_target_usp0to100 + (-diff_from_split * (depth_env_target_keyscale_lower_sp0to100 / 100.0) * depth_env_target_usp0to100));
                    }
                    if (depth_env_target_value_usp0to100 < 0) { depth_env_target_value_usp0to100 = 0; }
                    else if (depth_env_target_value_usp0to100 > 100) { depth_env_target_value_usp0to100 = 100; }

                    series_target.Points.AddXY(midi_note_id, depth_env_target_value_usp0to100);

                    if (((midi_note_id - a0_note_number) % 12 == 0) || (midi_note_id == key_scale_split_note_id))
                    {
                        series_target.Points[midi_note_id - a0_note_number].Label = depth_env_target_value_usp0to100.ToString() + "%";
                        series_target.Points[midi_note_id - a0_note_number].MarkerColor = Color.Black;
                    }
                    else
                    {
                        series_target.Points[midi_note_id - a0_note_number].MarkerSize = 3;
                    }

                    //-------- Linear Delta--------
                    if (midi_note_id >= key_scale_split_note_id)
                    {
                        depth_env_lin_delta_value = (Int32)(depth_env_lin_delta + (diff_from_split * depth_env_lin_delta_keyscale_upper));
                    }
                    else
                    {
                        depth_env_lin_delta_value = (Int32)(depth_env_lin_delta + (-diff_from_split * depth_env_lin_delta_keyscale_lower));
                    }
                    if (depth_env_lin_delta_value < 0) { depth_env_lin_delta_value = 0; }
                    else if (depth_env_lin_delta_value > 2048) { depth_env_lin_delta_value = 2048; }//65536/32 = 2048

                    series_linear_delta.Points.AddXY(midi_note_id, depth_env_lin_delta_value);

                    if (((midi_note_id - a0_note_number) % 12 == 0) || (midi_note_id == key_scale_split_note_id))
                    {
                        series_linear_delta.Points[midi_note_id - a0_note_number].Label = depth_env_lin_delta_value.ToString() + "";
                        series_linear_delta.Points[midi_note_id - a0_note_number].MarkerColor = Color.Black;
                    }
                    else
                    {
                        series_linear_delta.Points[midi_note_id - a0_note_number].MarkerSize = 3;
                    }

                    //-------- depth_env_exp_multiplier --------
                    if (midi_note_id >= key_scale_split_note_id)
                    {
                        ks_swx32 = get_ks_swx32_for_value_sp0to100(depth_env_exp_multiplier_usp0to100, depth_env_exp_multiplier_keyscale_upper_sp0to100);
                        ks_sp0to100 = (ks_swx32 >> 5) / 327.67;
                        depth_env_exp_multiplier_value_usp0to100 = (double)(depth_env_exp_multiplier_usp0to100 + (diff_from_split *  (ks_sp0to100/100.0) * depth_env_exp_multiplier_usp0to100));
                    }
                    else
                    {
                        ks_swx32 = get_ks_swx32_for_value_sp0to100(depth_env_exp_multiplier_usp0to100, depth_env_exp_multiplier_keyscale_lower_sp0to100);
                        ks_sp0to100 = (ks_swx32 >> 5) / 327.67;
                        depth_env_exp_multiplier_value_usp0to100 = (double)(depth_env_exp_multiplier_usp0to100 + (-diff_from_split * (ks_sp0to100 / 100.0) * depth_env_exp_multiplier_usp0to100));
                    }
                    if (depth_env_exp_multiplier_value_usp0to100 < 0) { depth_env_exp_multiplier_value_usp0to100 = 0; }
                    else if (depth_env_exp_multiplier_value_usp0to100 > 100) { depth_env_exp_multiplier_value_usp0to100 = 100; }

                    series_exp_mult.Points.AddXY(midi_note_id, depth_env_exp_multiplier_value_usp0to100);

                    if (((midi_note_id - a0_note_number) % 12 == 0) || (midi_note_id == key_scale_split_note_id))
                    {
                        series_exp_mult.Points[midi_note_id - a0_note_number].Label = depth_env_exp_multiplier_value_usp0to100.ToString("N3") + "%";
                        series_exp_mult.Points[midi_note_id - a0_note_number].MarkerColor = Color.Black;
                    }
                    else
                    {
                        series_exp_mult.Points[midi_note_id - a0_note_number].MarkerSize = 3;
                    }

                }
            }
        }

        private void chart1_Paint(object sender, PaintEventArgs e)
        {
            Double cx = this.chart1.ChartAreas["ChartArea1"].AxisX.ValueToPixelPosition(a0_note_number);
            float new_width = (float)cx - (float)(pictureBox1.Width * (42.0 / 1216.0));
            if (new_width < 0) { return; }
            tableLayoutPanel1.ColumnStyles[0].Width = new_width;
        }

        private void PL_KeyScaleVisualiser_Shown(object sender, EventArgs e)
        {
            this.Refresh();
        }
    }
}
