﻿using Spectral1.DATA_ACCESS;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static Spectral1.DATA_ACCESS.DA_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_HarmonicShapingSettings : Form
    {
        c_harmonic_level_shaping_action _ilsa;

        public PL_HarmonicShapingSettings(ref c_harmonic_level_shaping_action ilsa)
        {
            InitializeComponent();
            _ilsa = ilsa;
            _ilsa.flag_cancelled = false;

            for (int h = 0; h < 32; h++)
            {
                comboBox_start_harmonic.Items.Add(h.ToString());
            }
            comboBox_start_harmonic.SelectedIndex = 8;

            comboBox_direction.Items.Add("Up");
            comboBox_direction.Items.Add("Down");
            comboBox_direction.SelectedIndex = 0;

            comboBox_slope.Items.Add("+24db");
            comboBox_slope.Items.Add("+12db");
            comboBox_slope.Items.Add("+6db");
            comboBox_slope.Items.Add("+3db");
            comboBox_slope.Items.Add("-3db");
            comboBox_slope.Items.Add("-6db");
            comboBox_slope.Items.Add("-12db");
            comboBox_slope.Items.Add("-24db");
            comboBox_slope.SelectedIndex = 6;
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            _ilsa.flag_cancelled = false;
            if (comboBox_direction.Text == "Up")
            { _ilsa.direction = directions.up; }
            else
            { _ilsa.direction = directions.down; }

            _ilsa.start_harmonic = Convert.ToInt32(comboBox_start_harmonic.Text);
            switch (comboBox_slope.Text)
            {
                case "+24db":
                    _ilsa.db_per_octave = dbchanges.plus_24db;
                    break;
                case "+12db":
                    _ilsa.db_per_octave = dbchanges.plus_12db;
                    break;
                case "+6db":
                    _ilsa.db_per_octave = dbchanges.plus_6db ;
                    break;
                case "+3db":
                    _ilsa.db_per_octave = dbchanges.plus_3db;
                    break;
                case "-3db":
                    _ilsa.db_per_octave = dbchanges.minus_3db;
                    break;
                case "-6db":
                    _ilsa.db_per_octave = dbchanges.minus_6db;
                    break;
                case "-12db":
                    _ilsa.db_per_octave = dbchanges.minus_12db;
                    break;
                case "-24db":
                    _ilsa.db_per_octave = dbchanges.minus_24db;
                    break;
            }
            this.Close();
        }

        private void button_cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            _ilsa.flag_cancelled = true;
            this.Close();
        }
    }
}
