﻿using Spectral1_VBClassLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;
using WarmBreeze_DataLibrary;

namespace Spectral1.PRESENTATION
{
    public partial class PL_Export : Form
    {
        PL_Main _plm;
        private volatile CodeGen_DS_Spectral fCGS ;
        private volatile CodeGen_DS_Spectral eCGS = new CodeGen_DS_Spectral();
        string FilePathToSaveTo = "";

        public PL_Export(PL_Main plm)
        {
            InitializeComponent();
            _plm = plm;
        }


        private void ExportFile()
        {
            this.Cursor = Cursors.WaitCursor;

            string error_text = _plm.BL.DA.ExportToFile(pL_UC_AddDeleteDGV_PatchToExport.DGV.Rows, FilePathToSaveTo);
            if (error_text == "")
            {
                _plm.PLInfo.DisplayInfo("Patches exported successfully");
            }
            else
            {
                _plm.PLInfo.DisplayMinorError(error_text);
            }

            _plm.ClearStatus();
            this.Cursor = Cursors.Default;
        }
  
        private void InitialiseForSelectedFile()
        {
            fCGS = new CodeGen_DS_Spectral();
            fCGS.DSSPECTRAL.Tables["patch"].Merge(_plm.BL.DA.CGS.DSSPECTRAL.Tables["patch"]);
            fCGS.DSSPECTRAL.AcceptChanges();


            I_GenericCodeGenNonSortableTable i_tcp = (I_GenericCodeGenNonSortableTable)fCGS.Table_patch;

            DGVColumnConfigs PC = _plm.BL.BLDGV.get_patch_dgv_column_configs(); 
           
            pL_UC_AddDeleteDGV_PatchToExport.ColumnConfigs = PC;
            pL_UC_AddDeleteDGV_PatchToExport.DGVConfig.HeaderRowHeight = 32;
            pL_UC_AddDeleteDGV_PatchToExport.DGVConfig.MultiSelect = true;
            pL_UC_AddDeleteDGV_PatchToExport.EX_Initialise(ref i_tcp, "Patch", 500, false);
            pL_UC_AddDeleteDGV_PatchToExport.HideAddDelete();
        }

        private void button_select_file_Click(object sender, EventArgs e)
        {
            using (System.Windows.Forms.SaveFileDialog saveFileDialog1 = new System.Windows.Forms.SaveFileDialog())
            {
                try
                {
                    if (Properties.Settings.Default.last_opened_filepath != null && Properties.Settings.Default.last_opened_filepath != "")
                    {
                        saveFileDialog1.InitialDirectory = Path.GetFullPath(Properties.Settings.Default.last_opened_filepath);
                    }

                    saveFileDialog1.RestoreDirectory = true;
                    saveFileDialog1.Title = "Save Export to";
                    saveFileDialog1.DefaultExt = "spectral";
                    saveFileDialog1.Filter = "Spectral Sound Module files (*.spectral)|*.spectral";

                    if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                    {
                        FilePathToSaveTo = saveFileDialog1.FileName;
                        textBox_file_path.Text = saveFileDialog1.FileName;
                        InitialiseForSelectedFile();
                    }
                }
                catch (Exception ex)
                {
                    _plm.PLInfo.DisplayMinorError("Error selecting file : " + ex.Message);
                }
            }
        }

        private void RefreshUI()
        {
            button_export.Enabled = (textBox_file_path.Text != "");
            pL_UC_AddDeleteDGV_PatchToExport.Enabled = (textBox_file_path.Text != "");
        }

        private void PL_Import_Shown(object sender, EventArgs e)
        {
            RefreshUI();
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button_export_Click(object sender, EventArgs e)
        {
            ExportFile();
            this.Close();
        }
    }
}
