﻿using System;
using System.Collections.Generic;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== METHODS - PRIVATE =========================="
        private void WaveformBlockFunction()
        {
            DiscardToken(TokenType.CurrentWaveformBlock);
            DiscardToken(TokenType.Dot);
            if (is_waveform_block_function_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.SetCurrentWaveform:
                        wsd_wbf_SetCurrentWaveform(); break;
                    case TokenType.MorphWaveforms:
                        wsd_wbf_MorphWaveforms(); break;
                    case TokenType.CopyTo:
                        wsd_wbf_CopyTo(); break;
                    case TokenType.CopyAcrossNoteSectors:
                        wsd_wbf_CopyAcrossNoteSectors(); break;
                    case TokenType.CopyAcrossIntensityLayers:
                        wsd_wbf_CopyAcrossIntensityLayers(); break;
                    case TokenType.CopyAcrossAllDimensions:
                        wsd_wbf_CopyAcrossAllDimensions(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedIntensityLayerFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private void wsd_wbf_SetCurrentWaveform()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetCurrentWaveform);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Waveform);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveformBlock, functions.W_WB_SetCurrentWaveform, p, _lookaheadFirst.start_position);
        }

        private void wsd_wbf_MorphWaveforms()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphWaveforms);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.WaveformFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.WaveformTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.MorphType);
            DiscardToken(TokenType.Colon);
            p.Add(GetMorphTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveformBlock, functions.W_WB_MorphWaveforms, p, _lookaheadFirst.start_position);
        }

        private void wsd_wbf_CopyTo()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyTo);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSector);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.IntensityLayer);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveformBlock, functions.W_WB_CopyTo, p, _lookaheadFirst.start_position);
        }

        private void wsd_wbf_CopyAcrossNoteSectors()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyAcrossNoteSectors);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSectorFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.NoteSectorTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveformBlock, functions.W_WB_CopyAcrossNoteSectors, p, _lookaheadFirst.start_position);
        }

        private void wsd_wbf_CopyAcrossIntensityLayers()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyAcrossIntensityLayers);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayerFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.IntensityLayerTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveformBlock, functions.W_WB_CopyAcrossIntensityLayers, p, _lookaheadFirst.start_position);
        }

        private void wsd_wbf_CopyAcrossAllDimensions()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyAcrossAllDimensions);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveformBlock, functions.W_WB_CopyAcrossAllDimensions, p, _lookaheadFirst.start_position);
        }
        #endregion
    }
}
