﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== METHODS - PRIVATE =========================="
        private void IntensityLayerFunction()
        {
            DiscardToken(TokenType.CurrentIntensityLayer);
            DiscardToken(TokenType.Dot);
            if (is_intensity_layer_function_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.CopyTo:
                        wsd_ilf_CopyTo(); break;
                    case TokenType.CopyToRange:
                        wsd_ilf_CopyToRange(); break;
                    case TokenType.ShapeTheHarmonics:
                        wsd_ilf_ShapeTheHarmonics(); break;
                    case TokenType.MorphWaveformBlocks:
                        wsd_ilf_MorphWaveformBlocks(); break;
                    case TokenType.MorphWaveforms:
                        wsd_ilf_MorphWaveforms(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedIntensityLayerFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private void wsd_ilf_CopyTo()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyTo);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayerTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerRangeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentIntensityLayer, functions.W_IL_CopyTo, p, _lookaheadFirst.start_position);
        }

        private void wsd_ilf_CopyToRange()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyToRange);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayerFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.IntensityLayerTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentIntensityLayer, functions.W_IL_CopyToRange, p, _lookaheadFirst.start_position);
        }

        private void wsd_ilf_ShapeTheHarmonics()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.ShapeTheHarmonics);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Direction);
            DiscardToken(TokenType.Colon);
            p.Add(GetDirectionValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.HarmonicIDFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.Slope);
            DiscardToken(TokenType.Colon);
            p.Add(GetDBSlopeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentIntensityLayer, functions.W_IL_ShapeTheHarmonics, p, _lookaheadFirst.start_position);
        }

        private void wsd_ilf_MorphWaveformBlocks()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphWaveformBlocks);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSectorFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.NoteSectorTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.WaveSet, functions.W_IL_MorphWaveformBlocks, p, _lookaheadFirst.start_position);
        }

        private void wsd_ilf_MorphWaveforms()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphWaveforms);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSectorFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.NoteSectorTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.Waveform);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.WaveSet, functions.W_IL_MorphWaveforms, p, _lookaheadFirst.start_position);
        }
        #endregion

    }
}
