﻿using Spectral1.DATA_ACCESS;
using System;
using System.Collections.Generic;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== DECLARATIONS ============================================="
        public string ExpectedDefinitionObjectErrorText = "Expecting a definition object but found ";

        public string ExpectedWaveSetDefinitionObjectErrorText = "Expecting a WaveSet definition object but found ";
        public string ExpectedWaveSetFunctionErrorText = "Expecting a WaveSet function name but found ";
        public string ExpectedIntensityLayerFunctionErrorText = "Expecting an Intensity Layer function name but found ";
        public string ExpectedNoteSectorFunctionErrorText = "Expecting a Note Sector function name but found ";
        public string ExpectedWaveformBlockFunctionErrorText = "Expecting a WaveformBlock function name but found ";
        public string ExpectedWaveformFunctionErrorText = "Expecting a Waveform function name but found ";
        public string ExpectedHarmonicFunctionErrorText = "Expecting an harmonic function name but found ";

        public string InvalidNoteSectorRangeErrorText = "Invalid Note Sector Range value  ";
        public string InvalidNoteSectorIDErrorText = "Invalid Note Sector ID  ";

        public string InvalidIntensityLayerRangeErrorText = "Invalid Intensity Layer Range value  ";
        public string InvalidIntensityLayerIDErrorText = "Invalid Intensity Layer ID  ";

        public string InvalidHarmonicIDErrorText = "Invalid Harmonic ID  ";
        public string InvalidHarmonicRangeErrorText = "Invalid Harmonic range  ";
        public string InvalidHarmonicLevelErrorText = "Invalid Harmonic level  ";
        public string InvalidHarmonicPhaseErrorText = "Invalid Harmonic phase  ";
        public string InvalidHarmonicLevelShapeTypeErrorText = "Invalid Harmonic level shape type  ";
        public string InvalidHarmonicPhaseShapeTypeErrorText = "Invalid Harmonic phase shape type  ";

        public string InvalidWavefromIDErrorText = "Invalid Waveform ID  ";
        public string InvalidWavefromRangeErrorText = "Invalid Waveform range  ";
        public string InvalidWavefromNameErrorText = "Invalid Waveform name  ";
        public string InvalidWavefromShapeTypeErrorText = "Invalid Waveform shape type  ";

        public string InvalidDirectionErrorText = "Invalid direction value  ";
        public string InvalidDBSlopeErrorText = "Invalid filter slope value  ";
        public string InvalidMorphTypeErrorText = "Invalid morph type value  ";

        public string InvalidInstrumentTypeErrorText = "Invalid Instrument type  ";
        #endregion


        #region "==================== METHODS - WAVESET GET TOKEN =============================="

        private string GetNoteSectorRangeValue(c_lexer_token token)
        {
            if (is_note_sector_range_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidNoteSectorRangeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetNoteSectorIDValue(c_lexer_token token)
        {
            if (is_note_sector_id_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidNoteSectorIDErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetWaveFormIDValue(c_lexer_token token)
        {
            if (is_waveform_id_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidWavefromIDErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetWaveFormRangeValue(c_lexer_token token)
        {
            if (is_waveform_range_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidWavefromRangeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetWaveFormNameValue(c_lexer_token token)
        {
            if ((token.TokenType == TokenType.NameString))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidWavefromNameErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetWaveFormShapeTypeValue(c_lexer_token token)
        {
            if (is_waveform_shape_type_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidWavefromNameErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetMorphTypeValue(c_lexer_token token)
        {
            if ((token.TokenType == TokenType.Linear) || (token.TokenType == TokenType.Exponential))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidMorphTypeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetIntensityLayerRangeValue(c_lexer_token token)
        {
            if (is_intensity_layer_range_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidIntensityLayerRangeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetIntensityLayerIDValue(c_lexer_token token)
        {
            if (is_intensity_layer_id_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidIntensityLayerIDErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetDirectionValue(c_lexer_token token)
        {
            if (is_direction_value_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidDirectionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetHarmonicRangeValue(c_lexer_token token)
        {
            if (is_harmonic_range_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidHarmonicRangeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetHarmonicIDValue(c_lexer_token token)
        {
            if (is_harmonic_id_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidHarmonicIDErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetHarmonicLevelValue(c_lexer_token token)
        {
            if (is_harmonic_level_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidHarmonicLevelErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetHarmonicPhaseValue(c_lexer_token token)
        {
            if (is_harmonic_phase_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidHarmonicPhaseErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetHarmonicLevelShapeTypeValue(c_lexer_token token)
        {
            if (is_harmonic_level_shape_type_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidHarmonicLevelShapeTypeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetHarmonicPhaseShapeTypeValue(c_lexer_token token)
        {
            if (is_harmonic_phase_shape_type_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidHarmonicPhaseShapeTypeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetInstrumentTypeValue(c_lexer_token token)
        {
            if (is_instrument_type_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidHarmonicLevelErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetDBSlopeValue(c_lexer_token token)
        {
            if (is_db_slope_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidDBSlopeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        #endregion

        #region "==================== METHODS - OTHER =========================="
        private void WaveSetDefinition()
        {
            //WaveSetDefinition -> waveset OpenCurlyParenthesis WaveSetFunction CloseCurlyParenthesis
            DiscardToken(TokenType.WaveSet);
            DiscardToken(TokenType.OpenCurlyParenthesis);
            while (_lookaheadFirst.TokenType != TokenType.CloseCurlyParenthesis)
            {
                WaveSetDefinitionItem();
            }
            DiscardToken(TokenType.CloseCurlyParenthesis);
        }

        private void WaveSetDefinitionItem()
        {
            //WaveSetFunction|IntensityLayerFunction|NoteSectorFunction|WaveformBlockFunction|WaveformFunction SemiColon
            if (is_waveset_definition_object_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.WaveSet:
                        WaveSetFunction(); break;
                    case TokenType.CurrentNoteSector:
                        NoteSectorFunction(); break;
                    case TokenType.CurrentIntensityLayer:
                        IntensityLayerFunction(); break;
                    case TokenType.CurrentWaveformBlock:
                        WaveformBlockFunction(); break;
                    case TokenType.CurrentWaveform:
                        WaveformFunction(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedWaveSetFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
            DiscardToken(TokenType.SemiColon);
        }
        #endregion

        #region "=============================== METHODS - AUTO-GENERATE ========================="
        public string generate_code_from_current_waveset(ref PL_Main plm, PL_UC_SpectralParser wave_set_parser)
        {
            string error_text = "";

            try
            {
                for (int ns = 0; ns < DA_Spectral.max_note_sectors; ns++)
                {
                    wave_set_parser.add_blank_line();
                    wave_set_parser.add_code_comment("##### NOTE SECTOR " + ns.ToString() + " ################################################");
                    wave_set_parser.add_code_ws_wsf_setCurrentNoteSector(ns);
                    for (int il = 0; il < DA_Spectral.max_intensity_layers; il++)
                    {
                        wave_set_parser.add_blank_line();
                        wave_set_parser.add_code_comment("===== INTENSITY LAYER  " + il.ToString() + " ==========");
                        wave_set_parser.add_code_ws_wsf_setCurrentIntensityLayer(il);
                        for (int w = 0; w < DA_Spectral.max_waveforms; w++)
                        {
                            wave_set_parser.add_blank_line();
                            wave_set_parser.add_code_comment("----- Waveform  " + w.ToString() + " ----------");
                            wave_set_parser.add_code_ws_wbf_setCurrentWaveform(w);
                            List<int> level_list = new List<int>();
                            List<DA_Spectral.phases> phase_list = new List<DA_Spectral.phases>();
                            for (int h = 0; h < DA_Spectral.max_harmonics; h++)
                            {
                                level_list.Add(plm.BL.BLWaveSet.current_waveform_set.block[ns, il].waveform[w].get_harmonic_level(h));
                                phase_list.Add(plm.BL.BLWaveSet.current_waveform_set.block[ns, il].waveform[w].get_harmonic_phase_enum(h));
                            }
                            wave_set_parser.add_code_ws_wf_setHarmonicLevelsFromCSV(level_list);
                            //Decided to remove since not used in module at the moment : wave_set_parser.add_code_ws_wf_setHarmonicPhasesFromCSV(phase_list);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                error_text = "Error generating code :" + ex.Message;
            }

            return error_text;
        }
        #endregion
    }

}
