﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== METHODS - PRIVATE =========================="

        private void PatchADSRFunction()
        {
            DiscardToken(TokenType.ADSR);
            DiscardToken(TokenType.Dot);
            if (is_patch_adsr_function_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.ConfigureSection:
                        pd_adsr_ConfigureSection(); break;
                    case TokenType.ConfigureEnvelope:
                        pd_adsr_ConfigureEnvelope(); break;
                    case TokenType.LoadPreset:
                        pd_adsr_LoadPreset(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedPatchADSRFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private void pd_adsr_ConfigureSection()
        {
            //ADSR.ConfigureSection(Section:Attack,Enabled:True,Duration:25,
            //EndKSU:0.0,EndKSL:0.0,Sample:None,SampleMode:One-shot);
            List<String> p = new List<String>();

            DiscardToken(TokenType.ConfigureSection);
            DiscardToken(TokenType.OpenParenthesis);

            DiscardToken(TokenType.Section);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchADSRSectionName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.Enabled);
            DiscardToken(TokenType.Colon);
            p.Add(GetEnabledValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.Duration);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntegerValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.EndKSU);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.EndKSL);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.Sample);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchSampleName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.SampleMode);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchSampleMode(_lookaheadFirst));
            DiscardToken();

            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.ADSR, functions.P_ADSR_ConfigureSection, p, _lookaheadFirst.start_position);
        }

        private void pd_adsr_ConfigureEnvelope()
        {
            //ADSR.ConfigureEnvelope(Section:Attack,Envelope:Amplitude,EnvelopeType:None,
            //Target:0.0,TargetKSU:0.00,TargetKSL:0.00,LinearDelta:0,LinearDeltaKSU:0.0,
            //LinearDeltaKSL:0.0,ExpMult:3.00,ExpMultKSU:0.0,ExpMultKSL:0.0);
            List<String> p = new List<String>();

            DiscardToken(TokenType.ConfigureEnvelope);
            DiscardToken(TokenType.OpenParenthesis);

            DiscardToken(TokenType.Section);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchADSRSectionName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.Envelope);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchEnvelopeName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.EnvelopeType);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchEnvelopeType(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.Target);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.TargetKSU);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.TargetKSL);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.LinearDelta);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntegerValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.LinearDeltaKSU);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.LinearDeltaKSL);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.ExpMult);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.ExpMultKSU);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.ExpMultKSL);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();

            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.ADSR, functions.P_ADSR_ConfigureEnvelope, p, _lookaheadFirst.start_position);
        }

        private void pd_adsr_LoadPreset()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.LoadPreset);
            DiscardToken(TokenType.OpenParenthesis);

            DiscardToken(TokenType.PresetName);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchADSRPresetName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.BulkValue);
            DiscardToken(TokenType.Colon);
            p.Add(GetDecimalValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.ADSR, functions.P_ADSR_LoadPreset, p, _lookaheadFirst.start_position);
        }

        #endregion

    }
}
