﻿using Spectral1.DATA_ACCESS;
using System;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1.PARSER.c_dsl_functions;

namespace Spectral1.PARSER
{

    class c_dsl_waveset_execute
    {
        #region "======================== DECLARATIONS ==================================="
        PL_Main _plm;
        #endregion

        #region "======================== METHODS ==================================="
        public c_dsl_waveset_execute(PL_Main plm)
        {
            _plm = plm;
        }

        public void execute_sdl(c_dsl_functions dslf,extended_rtb rtb)
        {

            c_parser_dsl_function f = null;
            try
            {
                for (int i = 0; i < dslf.list_of_functions.Count; i++)
                {
                    f = dslf.list_of_functions[i];
                    if (f.definition_object == definition_objects.WaveSet)
                    {
                        c_from_to_range ftr = new DATA_ACCESS.c_from_to_range();
                        waveform_shapes ws;
                        c_harmonic_level_shaping_action hlsa;
                        harmonic_level_shape_types lst;
                        instrument_types it;
                        bool p;
                        int h;
                        int l;

                        switch (f.function)
                        {
                        case functions.W_WS_MorphAcrossNoteSectors:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, -1, -1);
                                break;
                        case functions.W_WS_MorphAcrossIntensityLayers:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, -1, -1);
                                break;
                        case functions.W_WS_SetCurrentIntensityLayer:
                                _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id = Convert.ToInt32(f.parameter_values[0]);
                                break;
                        case functions.W_WS_SetCurrentNoteSector:
                                _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id = Convert.ToInt32(f.parameter_values[0]);
                                break;
                        case functions.W_NS_CopyTo:
                                ftr.from_id = _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id;
                                ftr.to_id = Convert.ToInt32(f.parameter_values[0]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, -1, -1);
                                break;
                        case functions.W_NS_CopyToRange:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, -1, -1);
                                break;
                        case functions.W_NS_MorphWaveformBlocks:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                        case functions.W_NS_MorphWaveforms:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                        case functions.W_IL_CopyTo:
                                ftr.from_id = _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id;
                                ftr.to_id = Convert.ToInt32(f.parameter_values[0]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, -1, -1);
                                break;
                        case functions.W_IL_CopyToRange:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, -1, -1);
                                break;
                        case functions.W_IL_ShapeTheHarmonics:
                                hlsa = new c_harmonic_level_shaping_action();
                                hlsa.direction = (DA_Spectral.directions)(Convert.ToInt32(f.parameter_values[0]));
                                hlsa.start_harmonic = (Convert.ToInt32(f.parameter_values[1]));
                                hlsa.db_per_octave = (DA_Spectral.dbchanges)(Convert.ToInt32(f.parameter_values[2]));
                                _plm.BL.BLWaveSet.current_waveform_set.shape_harmonics(hlsa);
                                break;
                        case functions.W_IL_MorphWaveformBlocks:
                            ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                            ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                            _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                            break;
                        case functions.W_IL_MorphWaveforms:
                            ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                            ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                            _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                            break;
                        case functions.W_WB_CopyTo:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_block_harmonics(_plm.BL.BLWaveSet.current_waveform_set.block[Convert.ToInt32(f.parameter_values[0]), Convert.ToInt32(f.parameter_values[1])]);
                                break;
                        case functions.W_WB_MorphWaveforms:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.morph_waveforms(ftr, (morph_modes)(Convert.ToInt32(f.parameter_values[2])));
                                break;
                        case functions.W_WB_SetCurrentWaveform:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id = Convert.ToInt32(f.parameter_values[0]);
                                break;
                        case functions.W_WB_CopyAcrossNoteSectors:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id, -1);
                                break;
                        case functions.W_WB_CopyAcrossIntensityLayers:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                        case functions.W_WB_CopyAcrossAllDimensions:
                                _plm.BL.BLWaveSet.current_waveform_set.copy_waveform_block_in_all_dimensions();
                                break;
                        case functions.W_WF_CopyTo:
                                ftr.from_id = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id;
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_waveform_harmonics(_plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id, ftr.from_id, ftr.to_id);
                                break;
                        case functions.W_WF_CopyToRange:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_waveform_harmonics(_plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id, ftr.from_id, ftr.to_id);
                                break;
                        case functions.W_WF_SetWaveformName:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.description = f.parameter_values[0];
                                break;
                        case functions.W_WF_CopyAcrossNoteSectors:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id, _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id);
                                break;
                        case functions.W_WF_CopyAcrossIntensityLayers:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id);
                                break;
                        case functions.W_WF_CopyAcrossAllDimensions:
                                _plm.BL.BLWaveSet.current_waveform_set.copy_waveform_in_all_dimensions();
                                break;
                        case functions.W_WF_SetHarmonicLevelsFromCSV:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonics_from_csv_list2(f.parameter_values);
                                break;
                        case functions.W_WF_SetHarmonicLevelsFromHarmonicLevelShapeType:
                                lst = (harmonic_level_shape_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_level_shape_type(lst);
                                break;
                        case functions.W_WF_SetHarmonicLevelsFromInstrumentType:
                                it = (instrument_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(it);
                                break;
                        case functions.W_WF_SetHarmonicLevelsFromWaveShape:
                                ws = (waveform_shapes)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_waveform_shape(ws);
                                break;
                        case functions.W_WF_SetHarmonicLevel:
                                h = Convert.ToInt32(f.parameter_values[0]);
                                l = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level(h, l);
                                break;
                        case functions.W_WF_MorphHarmonicLevels:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.morph_harmonics(ftr);
                                break;
                        case functions.W_WF_SetHarmonicPhasesFromCSV:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phases_from_list(f.parameter_values);
                                break;
                        case functions.W_WF_SetHarmonicPhasesFromInstrumentType:
                                it = (instrument_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(it);
                                break;
                        case functions.W_WF_SetHarmonicPhasesFromHarmonicPhaseShapeType:
                                harmonic_phase_shape_types pst = (harmonic_phase_shape_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_phase_shape_type(pst);
                                break;
                        case functions.W_WF_SetHarmonicPhasesFromWaveShape:
                                ws = (waveform_shapes)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_waveform_shape(ws);
                                break;
                        case functions.W_WF_SetHarmonicPhase:
                                h = Convert.ToInt32(f.parameter_values[0]);
                                if ((Convert.ToInt32(f.parameter_values[1])) == 1)
                                { p = true; }
                                else
                                { p = false; }
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase(h, p);
                                break;
                            case functions.W_WF_SetHarmonicPhases:
                                p = (Convert.ToInt32(f.parameter_values[0])==1);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phases(p);
                                break;
                    }
                }
                }
                _plm.PLInfo.DisplayInfo("WaveSet updated successfully");
            }
            catch (Exception Ex)
            {
                rtb.highlight_line(f.start_position, System.Drawing.Color.Red);
                _plm.PLInfo.DisplayMinorError("Error running SDL code. \r\n\r\n" + "Function : " + f.function.ToString() + "\r\nError : " + Ex.Message);
            }


        }

        #endregion


    }



}
