﻿using Spectral1.BUSINESS_LOGIC;
using Spectral1.DATA_ACCESS;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.PARSER
{
    class c_dsl_execute
    {
        #region "======================== DECLARATIONS ==================================="
        PL_Main _plm;
        #endregion

        #region "======================== METHODS ==================================="
        public c_dsl_execute(PL_Main plm)
        {
            _plm = plm;
        }

        public void execute_sdl_from_text(string sdl_text,bool notify_result)
        {
            c_parser parser = new c_parser();
            RichTextBox rtb = new RichTextBox();

            try
            {
                _plm.Cursor = Cursors.WaitCursor;
                rtb.Text = sdl_text;
                List<c_lexer_token> list_of_tokens = parser.lexer.Tokenize(ref rtb);
                parser.Parse(ref rtb, list_of_tokens);
                execute_sdl(parser.parsed_list_of_functions, null, notify_result);
            }
            catch (Exception Ex)
            {
                _plm.PLInfo.DisplayMinorError("Error trying to run SDL : " + Ex.Message);
            }
            finally
            {
                rtb.Dispose();
                _plm.Cursor = Cursors.Default;
            }
        }

        public Int32 convert_friendly_target_to_65535(string target_percent)
        {
            return (int)(65535.0 * Convert.ToDouble(target_percent));
        }

        public void execute_sdl(c_dsl_functions dslf, extended_rtb rtb, bool notify_result)
        {
            int section_id;
            int envelope_id;
            int lfo_id;

            c_parser_dsl_function f = null;
            try
            {
                _plm.BL.DA.DASystem.flag_executing_sdl_code = true;

                for (int i = 0; i < dslf.list_of_functions.Count; i++)
                {
                    f = dslf.list_of_functions[i];
                    if (f.definition_object == definition_objects.WaveSet)
                    {
                        c_from_to_range ftr = new DATA_ACCESS.c_from_to_range();
                        waveform_shapes ws;
                        c_harmonic_level_shaping_action hlsa;
                        harmonic_level_shape_types lst;
                        instrument_types it;
                        bool p;
                        int h;
                        int l;

                        switch (f.function)
                        {
                            case functions.W_WS_MorphAcrossNoteSectors:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, -1, -1);
                                break;
                            case functions.W_WS_MorphAcrossIntensityLayers:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, -1, -1);
                                break;
                            case functions.W_WS_SetCurrentIntensityLayer:
                                _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id = Convert.ToInt32(f.parameter_values[0]);
                                break;
                            case functions.W_WS_SetCurrentNoteSector:
                                _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id = Convert.ToInt32(f.parameter_values[0]);
                                break;
                            case functions.W_NS_CopyTo:
                                ftr.from_id = _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id;
                                ftr.to_id = Convert.ToInt32(f.parameter_values[0]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, -1, -1);
                                break;
                            case functions.W_NS_CopyToRange:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, -1, -1);
                                break;
                            case functions.W_NS_MorphWaveformBlocks:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                            case functions.W_NS_MorphWaveforms:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                            case functions.W_IL_CopyTo:
                                ftr.from_id = _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id;
                                ftr.to_id = Convert.ToInt32(f.parameter_values[0]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, -1, -1);
                                break;
                            case functions.W_IL_CopyToRange:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, -1, -1);
                                break;
                            case functions.W_IL_ShapeTheHarmonics:
                                hlsa = new c_harmonic_level_shaping_action();
                                hlsa.direction = (DA_Spectral.directions)(Convert.ToInt32(f.parameter_values[0]));
                                hlsa.start_harmonic = (Convert.ToInt32(f.parameter_values[1]));
                                hlsa.db_per_octave = (DA_Spectral.dbchanges)(Convert.ToInt32(f.parameter_values[2]));
                                _plm.BL.BLWaveSet.current_waveform_set.shape_harmonics(hlsa);
                                break;
                            case functions.W_IL_MorphWaveformBlocks:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                            case functions.W_IL_MorphWaveforms:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                            case functions.W_WB_CopyTo:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_block_harmonics(_plm.BL.BLWaveSet.current_waveform_set.block[Convert.ToInt32(f.parameter_values[0]), Convert.ToInt32(f.parameter_values[1])]);
                                break;
                            case functions.W_WB_MorphWaveforms:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.morph_waveforms(ftr, (morph_modes)(Convert.ToInt32(f.parameter_values[2])));
                                break;
                            case functions.W_WB_SetCurrentWaveform:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id = Convert.ToInt32(f.parameter_values[0]);
                                break;
                            case functions.W_WB_CopyAcrossNoteSectors:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id, -1);
                                break;
                            case functions.W_WB_CopyAcrossIntensityLayers:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);
                                break;
                            case functions.W_WB_CopyAcrossAllDimensions:
                                _plm.BL.BLWaveSet.current_waveform_set.copy_waveform_block_in_all_dimensions();
                                break;
                            case functions.W_WF_CopyTo:
                                ftr.from_id = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id;
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_waveform_harmonics(_plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id, ftr.from_id, ftr.to_id);
                                break;
                            case functions.W_WF_CopyToRange:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_waveform_harmonics(_plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id, ftr.from_id, ftr.to_id);
                                break;
                            case functions.W_WF_SetWaveformName:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.description = f.parameter_values[0];
                                break;
                            case functions.W_WF_CopyAcrossNoteSectors:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id, _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id);
                                break;
                            case functions.W_WF_CopyAcrossIntensityLayers:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id);
                                break;
                            case functions.W_WF_CopyAcrossAllDimensions:
                                _plm.BL.BLWaveSet.current_waveform_set.copy_waveform_in_all_dimensions();
                                break;
                            case functions.W_WF_SetHarmonicLevelsFromCSV:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonics_from_csv_list2(f.parameter_values);
                                break;
                            case functions.W_WF_SetHarmonicLevelsFromHarmonicLevelShapeType:
                                lst = (harmonic_level_shape_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_level_shape_type(lst);
                                break;
                            case functions.W_WF_SetHarmonicLevelsFromInstrumentType:
                                it = (instrument_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(it);
                                break;
                            case functions.W_WF_SetHarmonicLevelsFromWaveShape:
                                ws = (waveform_shapes)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_waveform_shape(ws);
                                break;
                            case functions.W_WF_SetHarmonicLevel:
                                h = Convert.ToInt32(f.parameter_values[0]);
                                l = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level(h, l);
                                break;
                            case functions.W_WF_MorphHarmonicLevels:
                                ftr.from_id = Convert.ToInt32(f.parameter_values[0]);
                                ftr.to_id = Convert.ToInt32(f.parameter_values[1]);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.morph_harmonics(ftr);
                                break;
                            case functions.W_WF_SetHarmonicPhasesFromCSV:
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phases_from_list(f.parameter_values);
                                break;
                            case functions.W_WF_SetHarmonicPhasesFromInstrumentType:
                                it = (instrument_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(it);
                                break;
                            case functions.W_WF_SetHarmonicPhasesFromHarmonicPhaseShapeType:
                                harmonic_phase_shape_types pst = (harmonic_phase_shape_types)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_phase_shape_type(pst);
                                break;
                            case functions.W_WF_SetHarmonicPhasesFromWaveShape:
                                ws = (waveform_shapes)(Convert.ToInt32(f.parameter_values[0]));
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_waveform_shape(ws);
                                break;
                            case functions.W_WF_SetHarmonicPhase:
                                h = Convert.ToInt32(f.parameter_values[0]);
                                if ((Convert.ToInt32(f.parameter_values[1])) == 1)
                                { p = true; }
                                else
                                { p = false; }
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase(h, p);
                                break;
                            case functions.W_WF_SetHarmonicPhases:
                                p = (Convert.ToInt32(f.parameter_values[0]) == 1);
                                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phases(p);
                                break;
                        }
                    }
                    else if (f.definition_object == definition_objects.Patch)
                    {
                        int patch_id = _plm.BL.BLPatch.current_patch.patch_id;

                        switch (f.function)
                        {
                            case functions.P_GEN_SetActiveOscillators:
                                _plm.BL.BLPatch.current_patch.active_layers = check_integer(f.parameter_values[0], 0, DA_Spectral.max_oscillators, "Not a valid Oscillator count !");
                                break;
                            case functions.P_GEN_SetDetuning:
                                if (f.parameter_values[0] == "Regular")
                                { _plm.BL.BLPatch.current_patch.degree_of_regular_detuning = check_float(f.parameter_values[1], 0, DA_Spectral.max_regular_and_random_detuning, "Not a valid detuning value"); }
                                else
                                { _plm.BL.BLPatch.current_patch.degree_of_random_detuning = check_float(f.parameter_values[1], 0, DA_Spectral.max_regular_and_random_detuning, "Not a valid detuning value"); }

                                break;
                            case functions.P_GEN_SetDetuningMode:
                                _plm.BL.BLPatch.current_patch.detuning_mode_id = GetDetuningModeIDFromName(f.parameter_values[0]);
                                break;
                            case functions.P_GEN_SetEnvelopeGainControllero:
                                envelope_id = GetEnvelopeIDFromName(f.parameter_values[0]);
                                envelope_controlRow ecr = _plm.BL.BLPatch.current_patch.envelope_control_row(patch_id, envelope_id);
                                ecr.depth_initial_level = check_integer(f.parameter_values[1], 0, 65535, "Invalid level !");
                                ecr.gain_cc_source = GetCCIDFromName(f.parameter_values[2]);
                                _plm.BL.DA.DASpectral.data_changed.patch.set_envelope_control_config(envelope_id, true);
                                break;
                            case functions.P_GEN_SetLFO:
                                //General.SetLFO(LFOType:Tremolo,Enabled:False,WaveType:Sine,Frequency:0.0,FrequencyCC:None,DepthCC:None);
                                lfo_id = GetLFOIDFromName(f.parameter_values[0]);
                                lfo_envelope_configRow lecr = _plm.BL.BLPatch.current_patch.lfo_envelope_config_row(patch_id, lfo_id);
                                lecr.lfo_envelope_config_id = GetLFOIDFromName(f.parameter_values[0]);
                                lecr.enabled = bool_string_to_int(f.parameter_values[1]);
                                lecr.lfo_wave_type_id = GetWaveShapeIDFromName(f.parameter_values[2]);
                                lecr.default_wt_inc_q11_5 = check_float(f.parameter_values[3], 0, 100, "Invalid frequency !");
                                lecr.freq_cc_source = GetCCIDFromName(f.parameter_values[4]);
                                lecr.depth_cc_source = GetCCIDFromName(f.parameter_values[5]);
                                _plm.BL.DA.DASpectral.data_changed.patch.set_lfo_envelope_config(lfo_id, true);
                                break;
                            case functions.P_GEN_SetOscillatorDetuning:
                                switch (f.parameter_values[0])
                                {
                                    case "0":
                                        _plm.BL.BLPatch.current_patch.layer0_st_inc_q11_5_detune = check_float(f.parameter_values[1], 0, max_oscillator_detuning, "Not a valid detuning value !");
                                        break;
                                    case "1":
                                        _plm.BL.BLPatch.current_patch.layer1_st_inc_q11_5_detune = check_float(f.parameter_values[1], 0, max_oscillator_detuning, "Not a valid detuning value !");
                                        break;
                                    case "2":
                                        _plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune = check_float(f.parameter_values[1], 0, max_oscillator_detuning, "Not a valid detuning value !");
                                        break;
                                }

                                break;
                            case functions.P_GEN_SetPatchGain:
                                _plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune = convert_friendly_percent_to_real100(f.parameter_values[0]);
                                break;
                            case functions.P_GEN_SetPortamento:
                                _plm.BL.BLPatch.current_patch.portamento_enabled = bool_string_to_int(f.parameter_values[0]);
                                _plm.BL.BLPatch.current_patch.portamento_rate = convert_friendly_percent_to_real100(f.parameter_values[1]);
                                break;
                            case functions.P_GEN_SetScalingSplit:
                                _plm.BL.BLPatch.current_patch.key_scale_split_note_id = BL_MIDI.NoteNameToNumber(f.parameter_values[0]);
                                break;
                            case functions.P_ADSR_ConfigureEnvelope:
                                //ADSR.ConfigureEnvelope(Section:Attack,Envelope:Amplitude,EnvelopeType:None,
                                //Target:0.0,TargetKSU:0.00,TargetKSL:0.00,LinearDelta:0,LinearDeltaKSU:0.0,
                                //LinearDeltaKSL:0.0,ExpMult:3.00,ExpMultKSU:0.0,ExpMultKSL:0.0);
                                section_id = GetSectionIDFromName(f.parameter_values[0]);
                                envelope_id = GetEnvelopeIDFromName(f.parameter_values[1]);
                                adsr_section_envelope_configRow asecr = _plm.BL.BLPatch.current_patch.adsr_section_envelope_config_row(patch_id, section_id, envelope_id);
                                asecr.depth_env_type_id = GetEnvelopeTypeIDFromName(f.parameter_values[2]);
                                asecr.depth_env_target = check_unsigned_percentage(f.parameter_values[3]);//OLD 030122: convert_friendly_target_to_65535(check_unsigned_percentage(f.parameter_values[3]).ToString());
                                asecr.depth_env_target_keyscale_upper = check_signed_percentage(f.parameter_values[4]);
                                asecr.depth_env_target_keyscale_lower = check_signed_percentage(f.parameter_values[5]);
                                asecr.depth_env_lin_delta = check_integer(f.parameter_values[6], -10000, 10000, "Invalid delta value !");
                                asecr.depth_env_lin_delta_keyscale_upper = check_signed_percentage(f.parameter_values[7]);
                                asecr.depth_env_lin_delta_keyscale_lower = check_signed_percentage(f.parameter_values[8]);
                                asecr.depth_env_exp_multiplier = check_unsigned_percentage(f.parameter_values[9]);
                                asecr.depth_env_exp_multiplier_keyscale_upper = check_signed_percentage(f.parameter_values[10]);
                                asecr.depth_env_exp_multiplier_keyscale_lower = check_signed_percentage(f.parameter_values[11]);
                                _plm.BL.DA.DASpectral.data_changed.patch.set_adsr_section_envelope_config(section_id,envelope_id,true);
                                break;
                            case functions.P_ADSR_ConfigureSection:
                                // ADSR.ConfigureSection(Section:Attack,Enabled:True,Duration:25,EndKSU:0.0,EndKSL:0.0,Sample:None,SampleMode:One-shot);
                                section_id = GetSectionIDFromName(f.parameter_values[0]);
                                adsr_sectionRow asr = _plm.BL.BLPatch.current_patch.adsr_section_row(patch_id, section_id);
                                asr.adsr_section_id = GetSectionIDFromName(f.parameter_values[0]);
                                asr.flag_active = bool_string_to_int(f.parameter_values[1]);
                                asr.end_time_ms = check_integer(f.parameter_values[2], 10, 60000, "Invalid end duration !");
                                asr.end_time_ms_keyscale_upper = check_signed_percentage(f.parameter_values[3]);
                                asr.end_time_ms_keyscale_lower = check_signed_percentage(f.parameter_values[4]);
                                asr.inharmonic_sample_id = GetSampleIDFromName(f.parameter_values[5]);
                                asr.inharmonic_sample_playback_mode_id = GetSampleModeIDFromName(f.parameter_values[6]);
                                _plm.BL.DA.DASpectral.data_changed.patch.set_adsr_section(section_id, true);
                                break;
                            case functions.P_ADSR_LoadPreset:
                                string preset_name = f.parameter_values[0];
                                Int32 adsr_preset_id = DA_Spectral.GetADSRPresetIDFromName(preset_name);
                                float bulk_value = check_float(f.parameter_values[1], 0, 100, "Invalid bulk value !");
                                _plm.BL.BLPatch.load_preset(adsr_preset_id, bulk_value);

                                break;
                        }
                    }

                }
                _plm.remote_InitialisePatchRelatedViewsForCurrentPatch();
                if (notify_result) _plm.PLInfo.DisplayInfo("SDL code executed successfully");
            }
            catch (Exception Ex)
            {
                if (rtb != null)
                {
                    rtb.highlight_line(f.start_position, System.Drawing.Color.Red);
                }
                _plm.PLInfo.DisplayMinorError("Error running SDL code. \r\n\r\n" + "Function : " + f.function.ToString() + "\r\nError : " + Ex.Message);
            }
            finally 
            {
                _plm.BL.DA.DASystem.flag_executing_sdl_code = false;
            }
        }
        #endregion
    }
}
