﻿using System;
using System.Drawing;
using System.Windows.Forms;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using WarmBreeze_DataLibrary;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using Spectral1.DATA_ACCESS;

namespace Spectral1.PRESENTATION
{
    public partial class UC_HarmonicFaders : UserControl
    {
        #region "================ DECLARATIONS ================"
        const int max_fader_value = 65535;
        const int waveform_horizontal_pixels = 628;

        PL_Info PLInfo = new PL_Info();
        PL_Main _plm;
        UC_Waveform _ucw;
        PL_UC_Waveforms _plucwaveforms;
        Int32[] waveform = new Int32[waveform_horizontal_pixels];
        bool flag_enable_waveform_refresh = true;

        Double level_scaling = 1;
        bool[] data_changed = new bool[max_harmonics];
        Int32 note_sector_id = 0;
        Int32 intensity_layer_id = 0;
        public bool flag_auto_update_from_trackbars = true;

        #endregion


        #region "===================== Events - Phase =================================================="
        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(0, checkBox1.Checked);
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(1, checkBox2.Checked);
        }

        private void checkBox3_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(2, checkBox3.Checked);
        }

        private void checkBox4_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(3, checkBox4.Checked);
        }

        private void checkBox5_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(4, checkBox5.Checked);
        }

        private void checkBox6_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(5, checkBox6.Checked);
        }

        private void checkBox7_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(6, checkBox7.Checked);
        }

        private void checkBox8_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(7, checkBox8.Checked);
        }

        private void checkBox9_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(8, checkBox9.Checked);
        }

        private void checkBox10_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(9, checkBox10.Checked);
        }

        private void checkBox11_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(10, checkBox11.Checked);
        }

        private void checkBox12_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(11, checkBox12.Checked);
        }

        private void checkBox13_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(12, checkBox13.Checked);
        }

        private void checkBox14_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(13, checkBox14.Checked);
        }

        private void checkBox15_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(14, checkBox15.Checked);
        }

        private void checkBox16_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(15, checkBox16.Checked);
        }

        private void checkBox17_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(16, checkBox17.Checked);
        }

        private void checkBox18_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(17, checkBox18.Checked);
        }

        private void checkBox19_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(18, checkBox19.Checked);
        }

        private void checkBox20_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(19, checkBox20.Checked);
        }

        private void checkBox21_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(20, checkBox21.Checked);
        }

        private void checkBox22_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(21, checkBox22.Checked);
        }

        private void checkBox23_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(22, checkBox23.Checked);
        }

        private void checkBox24_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(23, checkBox24.Checked);
        }

        private void checkBox25_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(24, checkBox25.Checked);
        }

        private void checkBox26_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(25, checkBox26.Checked);
        }

        private void checkBox27_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(26, checkBox27.Checked);
        }

        private void checkBox28_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(27, checkBox28.Checked);
        }

        private void checkBox29_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(28, checkBox29.Checked);
        }

        private void checkBox30_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(29, checkBox30.Checked);
        }

        private void checkBox31_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(30, checkBox31.Checked);
        }

        private void checkBox32_CheckedChanged(object sender, EventArgs e)
        {
            SetHarmonicPhaseValue(31, checkBox32.Checked);
        }
        #endregion

        #region "===================== Events - Fader Scroll =========================================="
        private void trackBar_0_Scroll(object sender, EventArgs e)
        {
            data_changed[0] = true;
        }

        private void trackBar_1_Scroll(object sender, EventArgs e)
        {
            data_changed[1] = true;
        }

        private void trackBar_2_Scroll(object sender, EventArgs e)
        {
            data_changed[2] = true;
        }

        private void trackBar_3_Scroll(object sender, EventArgs e)
        {
            data_changed[3] = true;
        }

        private void trackBar_4_Scroll(object sender, EventArgs e)
        {
            data_changed[4] = true;
        }

        private void trackBar_5_Scroll(object sender, EventArgs e)
        {
            data_changed[5] = true;
        }

        private void trackBar_6_Scroll(object sender, EventArgs e)
        {
            data_changed[6] = true;
        }

        private void trackBar_7_Scroll(object sender, EventArgs e)
        {
            data_changed[7] = true;
        }

        private void trackBar_8_Scroll(object sender, EventArgs e)
        {
            data_changed[8] = true;
        }

        private void trackBar_9_Scroll(object sender, EventArgs e)
        {
            data_changed[9] = true;
        }

        private void trackBar_10_Scroll(object sender, EventArgs e)
        {
            data_changed[10] = true;
        }

        private void trackBar_11_Scroll(object sender, EventArgs e)
        {
            data_changed[11] = true;
        }

        private void trackBar_12_Scroll(object sender, EventArgs e)
        {
            data_changed[12] = true;
        }

        private void trackBar_13_Scroll(object sender, EventArgs e)
        {
            data_changed[13] = true;
        }

        private void trackBar_14_Scroll(object sender, EventArgs e)
        {
            data_changed[14] = true;
        }

        private void trackBar_15_Scroll(object sender, EventArgs e)
        {
            data_changed[15] = true;
        }

        private void trackBar_16_Scroll(object sender, EventArgs e)
        {
            data_changed[16] = true;
        }

        private void trackBar_17_Scroll(object sender, EventArgs e)
        {
            data_changed[17] = true;
        }

        private void trackBar_18_Scroll(object sender, EventArgs e)
        {
            data_changed[18] = true;
        }

        private void trackBar_19_Scroll(object sender, EventArgs e)
        {
            data_changed[19] = true;
        }

        private void trackBar_20_Scroll(object sender, EventArgs e)
        {
            data_changed[20] = true;
        }

        private void trackBar_21_Scroll(object sender, EventArgs e)
        {
            data_changed[21] = true;
        }

        private void trackBar_22_Scroll(object sender, EventArgs e)
        {
            data_changed[22] = true;
        }

        private void trackBar_23_Scroll(object sender, EventArgs e)
        {
            data_changed[23] = true;
        }

        private void trackBar_24_Scroll(object sender, EventArgs e)
        {
            data_changed[24] = true;
        }

        private void trackBar_25_Scroll(object sender, EventArgs e)
        {
            data_changed[25] = true;
        }

        private void trackBar_26_Scroll(object sender, EventArgs e)
        {
            data_changed[26] = true;
        }

        private void trackBar_27_Scroll(object sender, EventArgs e)
        {
            data_changed[27] = true;
        }

        private void trackBar_28_Scroll(object sender, EventArgs e)
        {
            data_changed[28] = true;
        }

        private void trackBar_29_Scroll(object sender, EventArgs e)
        {
            data_changed[29] = true;
        }

        private void trackBar_30_Scroll(object sender, EventArgs e)
        {
            data_changed[30] = true;
        }

        private void trackBar_31_Scroll(object sender, EventArgs e)
        {
            data_changed[31] = true;
        }

        #endregion

        #region "===================== Events - other ============================================"
        private void timer_H_Tick(object sender, EventArgs e)
        {
            bool has_changed = false;
            for (Int32 h = 0; h < max_harmonics; h++)
            {
                if (data_changed[h] == true)
                {
                    has_changed = true;
                    toolTip1.SetToolTip(GetTrackBar(h), GetTrackBar(h).Value.ToString() + " | " + ((double)GetTrackBar(h).Value / (double)65535).ToString("P0"));

                    if(flag_auto_update_from_trackbars)SetHarmonicLevelValue(h, FF(GetTrackBar(h).Value));
                    
                }
            }
            if (has_changed) { _plm.SyncVisible(); }
        }

        #endregion


        #region "========================= Methods - General ============================================="
        public UC_HarmonicFaders()
        {
            InitializeComponent();
        }

        public void Initialise(PL_Main plm, UC_Waveform ucw, PL_UC_Waveforms plucwaveforms)
        {
            SetStyle(ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint | ControlStyles.DoubleBuffer, true);

            _plm = plm;
            _ucw = ucw;
            _plucwaveforms = plucwaveforms;

            _ucw.Initialise(waveform, _plm);

            ClearDataChanged();
            timer_H.Interval = 200;
            timer_H.Enabled = true;
            timer_H.Start();
        }

        public void set_note_sector_and_intensity(Int32 n, Int32 l)
        {
            note_sector_id = n;
            intensity_layer_id = l;
        }

        public void InitialiseForCurrentWaveform(Int32 n,Int32 l)
        {
            if((_plm.BL.BLWaveSet.current_waveform_set == null)|| (_plm.BL.BLWaveSet.current_waveform_set.waveform_set_id ==0)) { return; }
            if (_plm.BL.DA.DASystem.flag_initialising_system == true){ return; }
            if (_plm.BL.DA.DASystem.flag_suppress_patch_events == true) { return; }
            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;
  
            note_sector_id = n;
            intensity_layer_id = l;
            flag_enable_waveform_refresh = false;

            for (Int32 h = 0; h < max_harmonics; h++)
            {
                TrackBar tb = GetTrackBar(h);
                CheckBox cb = GetPhaseCheckBox(h);
                tb.Value = InvFF(_plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.get_harmonic_level(h));
                tb.Maximum = max_fader_value;
                tb.Minimum = 0;
                cb.Checked = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.get_harmonic_phase(h);
                toolTip1.SetToolTip(tb, tb.Value.ToString() + " | " + ((double)tb.Value / (double)65535).ToString("P0"));
            }

            flag_enable_waveform_refresh = true;
            if (_ucw != null) {
                UpdateWaveformArray();
                _ucw.Initialise(waveform,_plm);
            }
            _plm.Cursor = entry_cursor;

            flag_auto_update_from_trackbars = true;
        }

        public void DisableWaveformRefresh()
        {
            flag_enable_waveform_refresh = false;
        }

        public void EnableWaveformRefresh()
        {
            flag_enable_waveform_refresh = true;
            if (_ucw != null) {
                UpdateWaveformArray();
                _ucw.Initialise(waveform,_plm);
            }
        }

        #endregion

        #region "===================== Methods - Private ============================================="
   

        private void ClearDataChanged()
        {
            for (Int32 h = 0; h < max_harmonics; h++) { data_changed[h] = false; }
        }

        private Int32 FF(Int32 L)
        {
            return (Int32)(((double)L * (double)L) / (double)max_fader_value);
        }

        private Int32 InvFF(Int32 X)
        {
            Int32 return_value;
            return_value = (Int32)(Math.Sqrt((double)X * (double)max_fader_value));
            return return_value;
        }

        private CheckBox GetPhaseCheckBox(int index)
        {
            switch (index)
            {
                case 0:
                    return checkBox1;
                case 1:
                    return checkBox2;
                case 2:
                    return checkBox3;
                case 3:
                    return checkBox4;
                case 4:
                    return checkBox5;
                case 5:
                    return checkBox6;
                case 6:
                    return checkBox7;
                case 7:
                    return checkBox8;
                case 8:
                    return checkBox9;
                case 9:
                    return checkBox10;
                case 10:
                    return checkBox11;
                case 11:
                    return checkBox12;
                case 12:
                    return checkBox13;
                case 13:
                    return checkBox14;
                case 14:
                    return checkBox15;
                case 15:
                    return checkBox16;
                case 16:
                    return checkBox17;
                case 17:
                    return checkBox18;
                case 18:
                    return checkBox19;
                case 19:
                    return checkBox20;
                case 20:
                    return checkBox21;
                case 21:
                    return checkBox22;
                case 22:
                    return checkBox23;
                case 23:
                    return checkBox24;
                case 24:
                    return checkBox25;
                case 25:
                    return checkBox26;
                case 26:
                    return checkBox27;
                case 27:
                    return checkBox28;
                case 28:
                    return checkBox29;
                case 29:
                    return checkBox30;
                case 30:
                    return checkBox31;
                case 31:
                    return checkBox32;
                default:
                    return checkBox1;
            }
        }

        private TrackBar GetTrackBar(int index)
        {
            switch (index)
            {
                case 0:
                    return trackBar_0;
                case 1:
                    return trackBar_1;
                case 2:
                    return trackBar_2;
                case 3:
                    return trackBar_3;
                case 4:
                    return trackBar_4;
                case 5:
                    return trackBar_5;
                case 6:
                    return trackBar_6;
                case 7:
                    return trackBar_7;
                case 8:
                    return trackBar_8;
                case 9:
                    return trackBar_9;
                case 10:
                    return trackBar_10;
                case 11:
                    return trackBar_11;
                case 12:
                    return trackBar_12;
                case 13:
                    return trackBar_13;
                case 14:
                    return trackBar_14;
                case 15:
                    return trackBar_15;
                case 16:
                    return trackBar_16;
                case 17:
                    return trackBar_17;
                case 18:
                    return trackBar_18;
                case 19:
                    return trackBar_19;
                case 20:
                    return trackBar_20;
                case 21:
                    return trackBar_21;
                case 22:
                    return trackBar_22;
                case 23:
                    return trackBar_23;
                case 24:
                    return trackBar_24;
                case 25:
                    return trackBar_25;
                case 26:
                    return trackBar_26;
                case 27:
                    return trackBar_27;
                case 28:
                    return trackBar_28;
                case 29:
                    return trackBar_29;
                case 30:
                    return trackBar_30;
                case 31:
                    return trackBar_31;
                default:
                    return trackBar_0;
            }
        }

        private void SaveTrackBarLevelSettings()
        {
            for (Int32 h = 0; h < max_harmonics; h++)
            {
                _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level(h, FF(GetTrackBar(h).Value));
            }
        }

        private void SetHarmonicLevelValue(Int32 h, Int32 L)
        {
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level(h, L);
            _plucwaveforms.remote_add_code_change_harmonic_level(h, L);

            UpdateWaveformArray();

            if (flag_enable_waveform_refresh == true)
            {
                UpdateWaveformArray();
                _ucw.Initialise(waveform, _plm);
            }
            data_changed[h] = false;
        }

        private void SetHarmonicPhaseValue(Int32 h, bool phase_inverted)
        {
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase(h, phase_inverted);
            if (flag_enable_waveform_refresh == true)
            {
                UpdateWaveformArray();
                _ucw.Initialise(waveform, _plm);
            }
        }

        private void UpdateWaveformArray()
        {
            Double AngleStep = (Double)(Math.PI * 2 / waveform_horizontal_pixels);
            Double AngleRad;
            Double SinAR;
            bool inv_phase = false;
            int level;

            for (int a_index = 0; a_index < waveform_horizontal_pixels; a_index++)
            { waveform[a_index] = 0; }

            for (int h_index = 0; h_index < max_harmonics; h_index++)
            {
                level = FF(GetTrackBar(h_index).Value);
                inv_phase = GetPhaseCheckBox(h_index).Checked;

                for (int a_index = 0; a_index < waveform_horizontal_pixels; a_index++)
                {
                    AngleRad = AngleStep * a_index * (h_index + 1);
                    if (inv_phase == true)
                    {
                        SinAR = Math.Sin(AngleRad + Math.PI);
                    }
                    else
                    {
                        SinAR = Math.Sin(AngleRad);
                    }

                    waveform[a_index] += Convert.ToInt32(SinAR * level);
                }
            }

            //Calculate a level scaling value to 'normalize' the waveform 

            if (_plm.BL.BLWaveSet.current_waveform_set != null && _plm.BL.DA.CGS.Table_waveform.CurrentRow.RowIsEmpty == false)
            {
                level_scaling = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.CalcLevelScaling();
            }
            else
            {
                level_scaling = 1;
            }
        }



        #endregion

 
    }
}
