﻿using System;
using System.Windows.Forms;
using WarmBreeze_DataLibrary;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using Spectral1.DATA_ACCESS;
using System.Collections.Generic;
using Spectral1.SPECTRUM_ANALYSER;
using Spectral1.BUSINESS_LOGIC;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_Waveforms : UserControl
    {
        #region "============================== DECLARATIONS ========================================"
        private PL_Main _plm;
        private bool flag_initialising = true;

        #endregion

        #region "========================== PROPERTIES ==================================="

        #endregion

        #region "============================== EVENTS ========================================"
        private void comboBox_vb_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (flag_initialising) return;

            SetVisualiserAcrossMode();
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            CheckForVisualiserRefresh();
        }

        private void Table_waveform_set_row_changed(object sender, EventArgs e)
        {
            //if ((_plm.BL.DA.DASystem.flag_initialising_system == true) || (_plm.BL.DA.DASystem.flag_suppress_patch_events == true)) { return; }
            //InitForCurrentWaveSet();
        }

        private void pL_UC_AddDeleteDGV_WS_selection_changed(object sender, EventArgs e)
        {
            if ((_plm.BL.DA.DASystem.flag_suppress_patch_events == true)||(_plm.BL.DA.DASystem.flag_suppress_ws_selection_change == true)){ return; }
            _plm.BL.BLWaveSet.set_current_waveform_set_from_table_waveform_set_current_row(Convert.ToInt32(comboBox_note_sector.SelectedValue), Convert.ToInt32(comboBox_intensity_layer.SelectedValue));
            InitForCurrentWaveSet();
        }

        private void pL_UC_AddDeleteDGV_WS_RowDeleted(object sender, EventArgs e)
        {
            InitForCurrentWaveSet();
            _plm.BL.DA.DASystem.flag_suppress_patch_events = false;
            _plm.Cursor = Cursors.Default;
        }

        private void pL_UC_AddDeleteDGV_WS_BeforeRowDeleted(object sender, EventArgs_BeforeRowDelete e)
        {
            _plm.Cursor = Cursors.WaitCursor;_plm.BL.DA.DASystem.flag_suppress_patch_events = true;

            if (_plm.BL.BLWaveSet.current_waveform_set.is_referred_to() == true)
            {
                _plm.PLInfo.DisplayExclamation("Can't delete this Waveform set because it is referred to in patch(s)");
                e.OkToDelete = false;
                _plm.Cursor = Cursors.Default;
                return;
            }

            _plm.BL.BLWaveSet.current_waveform_set.delete_associated_data_rows();
        }

        private void Table_waveform_set_NewRowAdded(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_importing_exporting == true) { return; }

            _plm.SetStatus("Creating WaveSet");_plm.Cursor = Cursors.WaitCursor;

           waveform_setRow WSR = (waveform_setRow)sender;

            _plm.BL.BLWaveSet.set_current_waveform_set(((waveform_setRow)sender).waveform_set_id, Convert.ToInt32(comboBox_note_sector.SelectedValue), Convert.ToInt32(comboBox_intensity_layer.SelectedValue));
            _plm.BL.BLWaveSet.current_waveform_set.guid8 = BL_Spectral.GetNewGuid8();//Added 070122

            _plm.BL.DA.DASystem.flag_initialising_waveset = true; _plm.BL.DA.DASystem.flag_disable_waveform_update = true;
            _plm.BL.BLWaveSet.current_waveform_set.create_associated_data_rows();
            _plm.BL.DA.DASystem.flag_initialising_waveset = false; _plm.BL.DA.DASystem.flag_disable_waveform_update = false;

            InitForCurrentWaveForm();

            RefreshUI();

            _plm.ClearStatus();_plm.Cursor = Cursors.Default;
        }

        private void Table_waveform_row_changed(object sender, EventArgs e)
        {
            InitForCurrentWaveForm();
        }

        private void pL_UC_AddDeleteOrderDGV_AW_selection_changed(object sender, EventArgs e)
        {
            InitForCurrentWaveForm();
        }

        private void pL_UC_AddDeleteOrderDGV_AW_RowDeleted(object sender, EventArgs e)
        {
            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

           uC_HarmonicFaders2.Initialise(_plm, uC_Waveform1,this);
            RefreshUI();

            _plm.Cursor = entry_cursor;
        }

        private void refresh_note_sector_and_intensity(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_initialising_system == true) { return; }
            _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id = Convert.ToInt32(comboBox_note_sector.SelectedValue);
            _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id = Convert.ToInt32(comboBox_intensity_layer.SelectedValue);
            uC_HarmonicFaders2.set_note_sector_and_intensity(_plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id);
        }
        #endregion

        #region "===================== EVENTS - WAVESET MENU =================================="
        private void m_ws_mans_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr =new c_from_to_range();

            using (PL_SetNoteSectorRange plsnsr = new PL_SetNoteSectorRange(ref _plm, ref ftr, note_sector_range_contexts.MorphWholeSector))
            {plsnsr.ShowDialog();
             if (plsnsr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr,-1,-1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_wsf_morphAcrossNoteSectors(ftr.from_id, ftr.to_id); }

            post_edit_tasks();
        }

        private void m_ws_mail_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetIntensityLayerRange plsilr = new PL_SetIntensityLayerRange(ref _plm, ref ftr, intensity_layer_range_contexts.MorphWholeLayer))
            {plsilr.ShowDialog();
             if (plsilr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr,-1,-1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_wsf_morphAcrossIntensityLayers(ftr.from_id, ftr.to_id); }
            post_edit_tasks();
        }

        private void m_ws_clo_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.DA.DASystem.flag_cloning_waveset = true;
            _plm.BL.BLWaveSet.current_waveform_set.clone();
            _plm.BL.DA.DASystem.flag_cloning_waveset = false;
            post_edit_tasks();
        }

        private void m_ws_cle_Click(object sender, EventArgs e)
        {
            if (_plm.PLInfo.DisplayConfirm("Are you sure you want to clear the whole WaveSet ?") == true)
            {
                pre_edit_tasks();
                _plm.BL.BLWaveSet.current_waveform_set.clear();
                post_edit_tasks();
            }
        }


        #endregion

        #region "===================== EVENTS - NOTE-SECTOR MENU =================================="

        private void copy_note_sector_to(int i)
        {
            pre_edit_tasks();
            c_from_to_range copy_range = new c_from_to_range();
            if (i == -1)
            {
                copy_range.from_id = 0;
                copy_range.to_id = max_note_sectors - 1;
            }
            else
            {
                copy_range.from_id = i;
                copy_range.to_id = i;
            }
            string error_text = _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(copy_range, -1, -1);


            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            {
                _plm.spectral_parser.add_code_ws_nsf_copyTo(i);
            }
            post_edit_tasks();
        }

        private void m_ns_cc_ts0_Click(object sender, EventArgs e)
        {
            copy_note_sector_to(0);
        }

        private void m_ns_cc_ts1_Click(object sender, EventArgs e)
        {
            copy_note_sector_to(1);
        }

        private void m_ns_cc_ts2_Click(object sender, EventArgs e)
        {
            copy_note_sector_to(2);
        }

        private void m_ns_cc_ts3_Click(object sender, EventArgs e)
        {
            copy_note_sector_to(3);
        }

        private void m_ns_cc_ts4_Click(object sender, EventArgs e)
        {
            copy_note_sector_to(4);
        }

        private void m_ns_cc_tas_Click(object sender, EventArgs e)
        {
            copy_note_sector_to(-1);
        }

        private void m_ns_mwb_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetIntensityLayerRange plsilr = new PL_SetIntensityLayerRange(ref _plm, ref ftr,intensity_layer_range_contexts.MorphCurrentNoteSectorBlocks))
            { plsilr.ShowDialog();
              if (plsilr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id,-1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_nsf_morphWaveformBlocks(ftr.from_id, ftr.to_id); }
            post_edit_tasks();
        }

        private void m_ns_mw_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetIntensityLayerRange plsilr = new PL_SetIntensityLayerRange(ref _plm, ref ftr, intensity_layer_range_contexts.MorphCurrentNoteSectorWaveforms))
            { plsilr.ShowDialog();
              if (plsilr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_intensity_layers(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, -1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_nsf_morphWaveforms(ftr.from_id, ftr.to_id, ftr.waveform_id); }
            post_edit_tasks();
        }

        #endregion

        #region "===================== EVENTS - INTENSITY-LAYER MENU =================================="
        private void copy_intensity_layer_to(int i)
        {
            pre_edit_tasks();
            c_from_to_range copy_range = new c_from_to_range();
            if (i == -1)
            {
                copy_range.from_id = 0;
                copy_range.to_id = max_intensity_layers - 1;
            }
            else
            {
                copy_range.from_id = i;
                copy_range.to_id = i;
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(copy_range, -1,-1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_ilf_copyTo(i); }
            post_edit_tasks();
        }

        private void m_il_cc_tll_Click(object sender, EventArgs e)
        {
            copy_intensity_layer_to(0);
        }

        private void m_il_cc_tml_Click(object sender, EventArgs e)
        {
            copy_intensity_layer_to(1);
        }

        private void m_il_cc_thl_Click(object sender, EventArgs e)
        {
            copy_intensity_layer_to(2);
        }

        private void m_il_cc_ta_Click(object sender, EventArgs e)
        {
            copy_intensity_layer_to(-1);
        }

        private void m_il_sth_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_harmonic_level_shaping_action hlsa = new c_harmonic_level_shaping_action();
            using (PL_HarmonicShapingSettings plhss = new PL_HarmonicShapingSettings(ref hlsa))
            {plhss.ShowDialog();
             if (plhss.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.shape_harmonics(hlsa);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            {
                _plm.spectral_parser.add_code_ws_ilf_shapeTheHarmonics(hlsa.direction, hlsa.start_harmonic, hlsa.db_per_octave);
            }
            post_edit_tasks();
        }

        private void m_il_mwb_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetNoteSectorRange plsnsr = new PL_SetNoteSectorRange(ref _plm, ref ftr,  note_sector_range_contexts.MorphCurrentIntensityLayerBlocks))
            { plsnsr.ShowDialog();
              if (plsnsr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id, -1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_ilf_morphWaveformBlocks(ftr.from_id, ftr.to_id); }
            post_edit_tasks();
        }

        private void m_il_mw_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetNoteSectorRange plsnsr = new PL_SetNoteSectorRange(ref _plm, ref ftr,  note_sector_range_contexts.MorphCurrentIntensityLayerWaveforms))
            { plsnsr.ShowDialog();
              if (plsnsr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.morph_harmonics_across_note_sectors(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id, -1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_ilf_morphWaveforms(ftr.from_id, ftr.to_id, ftr.waveform_id); }
            post_edit_tasks();
        }

        #endregion

        #region "===================== EVENTS - WAVEFORM BLOCK MENU =================================="
        private void m_wb_cc_twb_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();

            c_nsil_pair nsil = new c_nsil_pair(0,0);

            using (PL_SelectWaveformBlock plswb = new PL_SelectWaveformBlock(ref _plm, ref nsil))
            {
                plswb.ShowDialog();
                if (plswb.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_block_harmonics(_plm.BL.BLWaveSet.current_waveform_set.block[nsil.note_sector, nsil.intensity_layer]);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_wbf_copyTo(nsil.note_sector, nsil.intensity_layer); }

            pre_edit_tasks();
        }

        private void m_wb_cc_ans_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetNoteSectorRange plsnsr = new PL_SetNoteSectorRange(ref _plm, ref ftr,  note_sector_range_contexts.CopyCurrentBlock))
            {
                plsnsr.ShowDialog();
                if (plsnsr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id,-1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_wbf_copyAcrossNoteSectors(ftr.from_id, ftr.to_id); }
            post_edit_tasks();
        }

        private void m_wb_cc_ail_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetIntensityLayerRange plsilr = new PL_SetIntensityLayerRange(ref _plm, ref ftr, intensity_layer_range_contexts.CopyCurrentBlock))
            {
                plsilr.ShowDialog();
                if (plsilr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id,-1);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_wbf_copyAcrossIntensityLayers(ftr.from_id, ftr.to_id); }
            post_edit_tasks();
        }

        private void m_wb_cc_aad_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.copy_waveform_block_in_all_dimensions();
            _plm.spectral_parser.add_code_wbf_copyAcrossAllDimensions();
            post_edit_tasks();
        }

        private void m_wb_mw_do(morph_modes m)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetWaveformRange plswr = new PL_SetWaveformRange(ref _plm, ref ftr,"Morph waveforms"))
            {
                plswr.ShowDialog();
                if (plswr.DialogResult == DialogResult.Cancel) { return; }
            }

            _plm.BL.BLWaveSet.current_waveform_set.current_block.morph_waveforms(ftr, m);
            _plm.spectral_parser.add_code_ws_wbf_morphWaveforms(ftr.from_id, ftr.to_id,m); 
            post_edit_tasks();
        }

        private void m_wb_mw_l_Click(object sender, EventArgs e)
        {
            m_wb_mw_do(morph_modes.linear);
        }

        private void m_wb_mw_e_Click(object sender, EventArgs e)
        {
            m_wb_mw_do(morph_modes.exponential);
        }

        private void m_wb_visualise_Click(object sender, EventArgs e)
        {

        }

        #endregion

        #region "===================== EVENTS - WAVEFORM MENU>COPY =================================="
        private void mw_cc_tw_do(Int32 i)
        {
            pre_edit_tasks();
            c_from_to_range copy_range = new c_from_to_range();
            if (i == -1)
            {
                copy_range.from_id = 0;
                copy_range.to_id = DA_Spectral.max_waveforms - 1;
            }
            else
            {
                copy_range.from_id = i;
                copy_range.to_id = i;
            }

            _plm.BL.BLWaveSet.current_waveform_set.current_block.copy_waveform_harmonics(_plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id, copy_range.from_id, copy_range.to_id);
            if (i == -1)
            {
                _plm.spectral_parser.add_code_ws_wf_copyToRange(copy_range.from_id, copy_range.to_id);
            }
            else
            {
                _plm.spectral_parser.add_code_ws_wf_copyTo(i);
            }
            post_edit_tasks();
        }

        private void mw_cc_tw0_Click(object sender, EventArgs e)
        {
            mw_cc_tw_do(0);
        }

        private void mw_cc_tw1_Click(object sender, EventArgs e)
        {
            mw_cc_tw_do(1);
        }

        private void mw_cc_tw2_Click(object sender, EventArgs e)
        {
            mw_cc_tw_do(2);
        }

        private void mw_cc_tw3_Click(object sender, EventArgs e)
        {
            mw_cc_tw_do(3);
        }

        private void mw_cc_tw4_Click(object sender, EventArgs e)
        {
            mw_cc_tw_do(4);
        }

        private void mw_cc_ta_Click(object sender, EventArgs e)
        {
            mw_cc_tw_do(-1);
        }

        private void mw_cc_ans_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetNoteSectorRange plsnsr = new PL_SetNoteSectorRange(ref _plm, ref ftr,  note_sector_range_contexts.CopyCurrentWaveform))
            {
                plsnsr.ShowDialog();
                if (plsnsr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.copy_note_sector_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id, _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            else 
            { _plm.spectral_parser.add_code_ws_wf_copyAcrossNoteSectors(ftr.from_id, ftr.to_id); }
            post_edit_tasks();
        }

        private void mw_cc_ail_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range ftr = new c_from_to_range();

            using (PL_SetIntensityLayerRange plsnsr = new PL_SetIntensityLayerRange(ref _plm, ref ftr, intensity_layer_range_contexts.CopyCurrentWaveform))
            {
                plsnsr.ShowDialog();
                if (plsnsr.DialogResult == DialogResult.Cancel) { return; }
            }

            string error_text = _plm.BL.BLWaveSet.current_waveform_set.copy_intensity_layer_to(ftr, _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id, _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id);

            if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            _plm.spectral_parser.add_code_ws_wf_copyAcrossIntensityLayers(ftr.from_id, ftr.to_id);
            post_edit_tasks();
        }

        private void mw_cc_aad_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.copy_waveform_in_all_dimensions();
            _plm.spectral_parser.add_code_ws_wf_copyAcrossAllDimensions();
            post_edit_tasks();
        }

        #endregion

        #region "===================== EVENTS - WAVEFORM MENU>SET H LEVEL =================================="
        private void mw_shl_flst_ahz_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_level_shape_type(harmonic_level_shape_types.all_harmonics_zero);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromLevelShapeType(harmonic_level_shape_types.all_harmonics_zero); 
            post_edit_tasks();
        }

        private void mw_shl_flst_ahm_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_level_shape_type(harmonic_level_shape_types.all_harmonics_max);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromLevelShapeType(harmonic_level_shape_types.all_harmonics_max); 
            post_edit_tasks();
        }

        private void mw_shl_flst_ld_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_level_shape_type(harmonic_level_shape_types.linearly_descreasing);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromLevelShapeType(harmonic_level_shape_types.linearly_descreasing); 
            post_edit_tasks();
        }

        private void mw_shl_flst_ea_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_level_shape_type(harmonic_level_shape_types.exponential_all);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromLevelShapeType(harmonic_level_shape_types.exponential_all); 
            post_edit_tasks();
        }

        private void mw_shl_flst_eo_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_level_shape_type(harmonic_level_shape_types.exponential_odd);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromLevelShapeType(harmonic_level_shape_types.exponential_odd); 
            post_edit_tasks();
        }

        private void mw_shl_fit_v_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type( instrument_types.violin);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromInstrumentType(instrument_types.violin); 
            post_edit_tasks();
        }

        private void mw_shl_fit_c_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(instrument_types.cello);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromInstrumentType(instrument_types.cello); 
            post_edit_tasks();
        }

        private void mw_shl_fit_cl_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(instrument_types.clarinet);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromInstrumentType(instrument_types.clarinet); 
            post_edit_tasks();
        }

        private void mw_shl_fit_t_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(instrument_types.trumpet);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromInstrumentType(instrument_types.trumpet); 
            post_edit_tasks();
        }

        private void mw_shl_fit_f_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(instrument_types.flute);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromInstrumentType(instrument_types.flute); 
            post_edit_tasks();
        }

        private void mw_shl_fit_g_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(instrument_types.guitar);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromInstrumentType(instrument_types.guitar); 
            post_edit_tasks();
        }

        private void mw_shl_fit_mg_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_instrument_type(instrument_types.muted_guitar);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromInstrumentType(instrument_types.muted_guitar); 
            post_edit_tasks();
        }

        private void mw_shl_fws_sw_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_waveform_shape(waveform_shapes.square);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromWaveformShape(waveform_shapes.square); 
            post_edit_tasks();
        }

        private void mw_shl_fws_tw_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_waveform_shape(waveform_shapes.triangle);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromWaveformShape(waveform_shapes.triangle); 
            post_edit_tasks();
        }

        private void mw_shl_fws_saw_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level_shape_from_waveform_shape(waveform_shapes.saw);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromWaveformShape(waveform_shapes.saw); 
            post_edit_tasks();
        }

        private void mw_shl_fsa_Click(object sender, EventArgs e)
        {
            using (PL_Spectrum_Analyser plsa = new PL_Spectrum_Analyser(_plm))
            {
                plsa.ShowDialog();
                if (plsa.DialogResult == DialogResult.OK)
                {
                    int max_level = 0;
                    for (int h = 0; h < DA_Spectral.max_harmonics; h++)
                    {
                        if (plsa.result_timbre_harmonics[h] > max_level)
                        { max_level = plsa.result_timbre_harmonics[h]; }
                    }
                    double scaling = 65535.0 / max_level;
                    pre_edit_tasks();
                    int level;
                    for (int h = 0; h < DA_Spectral.max_harmonics; h++)
                    {
                        level = (int)(plsa.result_timbre_harmonics[h] * scaling);
                        plsa.result_timbre_harmonics[h] = level;
                        _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level(h, level);
                    }
                    _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromCSV(plsa.result_timbre_harmonics);
                    post_edit_tasks();
                }
            }
        }

        #endregion

        #region "===================== EVENTS - WAVEFORM MENU>SET H PHASE =================================="
        private void mw_shp_fpst_ie_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_phase_shape_type(harmonic_phase_shape_types.invert_even);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromPhaseShapeType(harmonic_phase_shape_types.invert_even); 
            post_edit_tasks();
        }

        private void mw_shp_fpst_io_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_phase_shape_type(harmonic_phase_shape_types.invert_odd);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromPhaseShapeType(harmonic_phase_shape_types.invert_odd); 
            post_edit_tasks();
        }

        private void mw_shp_fpst_i3711_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_phase_shape_type(harmonic_phase_shape_types.invert_3711);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromPhaseShapeType(harmonic_phase_shape_types.invert_3711); 
            post_edit_tasks();
        }

        private void mw_shp_fpst_aip_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_phase_shape_type(harmonic_phase_shape_types.all_in_phase);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromPhaseShapeType(harmonic_phase_shape_types.all_in_phase); 
            post_edit_tasks();
        }

        private void mw_shp_fit_v_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(instrument_types.violin);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromInstrumentType(instrument_types.violin); 
            post_edit_tasks();
        }

        private void mw_shp_fit_c_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(instrument_types.cello);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromInstrumentType(instrument_types.cello); 
            post_edit_tasks();
        }

        private void mw_shp_fit_cl_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(instrument_types.clarinet);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromInstrumentType(instrument_types.clarinet); 
            post_edit_tasks();
        }

        private void mw_shp_fit_tr_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(instrument_types.trumpet);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromInstrumentType(instrument_types.trumpet); 
            post_edit_tasks();
        }

        private void mw_shp_fit_f_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(instrument_types.flute);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromInstrumentType(instrument_types.flute); 
            post_edit_tasks();
        }

        private void mw_shp_fit_g_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(instrument_types.guitar);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromInstrumentType(instrument_types.guitar); 
            post_edit_tasks();
        }

        private void mw_shp_fit_mg_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_instrument_type(instrument_types.muted_guitar);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromInstrumentType(instrument_types.muted_guitar); 
            post_edit_tasks();
        }

        private void mw_shp_fws_sw_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_waveform_shape(waveform_shapes.square);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromWaveformShape(waveform_shapes.square); 
            post_edit_tasks();
        }

        private void mw_shp_fws_tw_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_waveform_shape(waveform_shapes.triangle);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromWaveformShape(waveform_shapes.triangle); 
            post_edit_tasks();
        }

        private void mw_shp_fws_sa_w_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_phase_shape_from_waveform_shape(waveform_shapes.saw);
            _plm.spectral_parser.add_code_ws_wf_setHarmonicPhasesFromWaveformShape(waveform_shapes.saw); 
            post_edit_tasks();
        }

        #endregion

        #region "===================== EVENTS - WAVEFORM MENU> ..other =================================="
        private void mw_shl_ih_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            string level_csv = "";
            string error_text = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.input_harmonic_levels(ref level_csv);
            if ((level_csv !="") && (error_text == ""))
            {
                string[] in_array;
                in_array = level_csv.Split(',');
                List<int> l = new List<int>();
                for(int i = 0; i < in_array.Length; i++){ l.Add(Convert.ToInt32(in_array[i])); }
                _plm.spectral_parser.add_code_ws_wf_setHarmonicLevelsFromCSV(l); 
            }
            else if (error_text != "")
            { _plm.PLInfo.DisplayMinorError(error_text); }
            post_edit_tasks();
        }

        private void mw_shl_eh_Click(object sender, EventArgs e)
        {
            string export_string = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.get_csv_list_of_harmonics();
            System.Windows.Forms.Clipboard.SetText(export_string);
            _plm.PLInfo.DisplayInfo("Harmonic levels have been copied to the Clipboard");
        }

        private void mw_shl_mhl_Click(object sender, EventArgs e)
        {
            pre_edit_tasks();
            c_from_to_range r = new c_from_to_range();
            using (PL_SetHarmonicRange plshr = new PL_SetHarmonicRange(ref _plm, ref r,"Morph harmonic levels"))
            {
                if (plshr.ShowDialog() == DialogResult.OK)
                {
                    _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.morph_harmonics(r);
                    _plm.spectral_parser.add_code_ws_wf_morphHarmonicLevels(r.from_id,r.to_id); 
                }
            }
            post_edit_tasks();
        }


        #endregion

        #region "===================== EVENTS - OTHER =========================="

        private void comboBox_note_sector_SelectedIndexChanged(object sender, EventArgs e)
        {
            InitForCurrentWaveSet();
            _plm.spectral_parser.add_code_ws_wsf_setCurrentNoteSector(comboBox_note_sector.SelectedIndex); 
        }

        private void comboBox_intensity_layer_SelectedIndexChanged(object sender, EventArgs e)
        {
            InitForCurrentWaveSet();
            _plm.spectral_parser.add_code_ws_wsf_setCurrentIntensityLayer(comboBox_intensity_layer.SelectedIndex); 
        }
        #endregion


        #region "============================== METHODS ========================================"
        private void pre_edit_tasks()
        {
            uC_HarmonicFaders2.flag_auto_update_from_trackbars = false;
        }

        private void post_edit_tasks()
        {
            uC_HarmonicFaders2.InitialiseForCurrentWaveform(comboBox_note_sector.SelectedIndex, comboBox_intensity_layer.SelectedIndex);
            _plm.SyncVisible();
        }

        public PL_UC_Waveforms()
        {
            InitializeComponent();
        }

        public void remote_add_code_change_harmonic_level(int h, int l)
        {
            _plm.spectral_parser.add_code_ws_wf_setHarmonicLevel(h, l);
        }

        public void Initialise(PL_Main plm)
        {
            flag_initialising = true;
            _plm = plm;
            _plm.spectral_parser.initialise(_plm, PARSER.c_parser.parser_modes.waveset);

            uC_3D_Visualiser_W.initialise(plm, visual3d_modes.waveforms);
            uC_3D_Visualiser_H.initialise(plm, visual3d_modes.harmonics);
            uC_3D_Visualiser_H.SetInterpolate();
            comboBox_vb.Items.Add("Waveform block");
            comboBox_vb.Items.Add("Note sector");
            comboBox_vb.Items.Add("Intensity layer");
            comboBox_vb.Text = "Waveform block";
            SetVisualiserAcrossMode();

            //Note sector
            comboBox_note_sector.DataSource = _plm.BL.DA.CGSS.Table_note_sector.Table_BindingSource;
            comboBox_note_sector.DisplayMember = "note_sector_name";
            comboBox_note_sector.ValueMember = "note_sector_id";

            //Intensity layer
            comboBox_intensity_layer.DataSource = _plm.BL.DA.CGSS.Table_intensity_layer.Table_BindingSource;
            comboBox_intensity_layer.DisplayMember = "intensity_layer_name";
            comboBox_intensity_layer.ValueMember = "intensity_layer_id";

            //Waveform Set
            _plm.BL.BLDGV.InitialiseWaveFormSetDGV(ref pL_UC_AddDeleteDGV_WS);
            _plm.BL.DA.CGS.Table_waveform_set.DT.RowChanged += Table_waveform_set_row_changed;
            pL_UC_AddDeleteDGV_WS.EVENT_DGVSelectionChanged += pL_UC_AddDeleteDGV_WS_selection_changed;
            pL_UC_AddDeleteDGV_WS.EVENT_RowDeleted += pL_UC_AddDeleteDGV_WS_RowDeleted;
            pL_UC_AddDeleteDGV_WS.EVENT_BeforeRowDeleted += pL_UC_AddDeleteDGV_WS_BeforeRowDeleted;
            _plm.BL.DA.CGS.Table_waveform_set.Event_NewRowAdded += Table_waveform_set_NewRowAdded;

            //Waveform
            _plm.BL.BLDGV.InitialiseWaveFormDGV(ref pL_UC_AddDeleteDGV_AW);
            _plm.BL.DA.CGS.Table_waveform.DT.RowChanged += Table_waveform_row_changed;
            pL_UC_AddDeleteDGV_AW.EVENT_DGVSelectionChanged += pL_UC_AddDeleteOrderDGV_AW_selection_changed;
            pL_UC_AddDeleteDGV_AW.EVENT_RowDeleted += pL_UC_AddDeleteOrderDGV_AW_RowDeleted;
            pL_UC_AddDeleteDGV_AW.HideAddDelete();

            uC_HarmonicFaders2.Initialise(_plm, uC_Waveform1, this);
            flag_initialising = false;

        }

        private void SetVisualiserAcrossMode()
        {
            Cursor entry_cursor = _plm.Cursor;
            _plm.Cursor = Cursors.WaitCursor;

            visual3d_across_modes m = visual3d_across_modes.intensity_layer;
            switch (comboBox_vb.Text)
            {
                case "Waveform block":
                    m = visual3d_across_modes.waveform_block;
                    break;
                case "Note sector":
                    m = visual3d_across_modes.note_sector;
                    break;

                case "Intensity layer":
                    m = visual3d_across_modes.intensity_layer;
                    break;
            }
            uC_3D_Visualiser_H.SetAcrossMode(m);
            uC_3D_Visualiser_W.SetAcrossMode(m);

            _plm.Cursor = entry_cursor;
        }

        public void ClearCode()
        {
            //pL_UC_SpectralParser1.clear_code();
        }

        public void InitForCurrentWaveSet()
        {
            if (_plm.BL.BLWaveSet.current_waveform_set == null) return;
            if (_plm.BL.DA.DASystem.flag_initialising_system == true) return;

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            Int32 waveform_set_id = _plm.BL.BLWaveSet.current_waveform_set.waveform_set_id;
            _plm.BL.BLWaveSet.set_current_waveform_set(waveform_set_id, Convert.ToInt32(comboBox_note_sector.SelectedValue), Convert.ToInt32(comboBox_intensity_layer.SelectedValue));
            InitForCurrentWaveForm();

            RefreshUI(); _plm.Cursor = entry_cursor;
        }

        public void InitForCurrentWaveForm()
        {
            if ((_plm.BL.DA.DASystem.flag_initialising_system == true) || (_plm.BL.DA.DASystem.flag_initialising_waveset == true)) { return; }

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id = _plm.BL.DA.CGS.Table_waveform.CurrentRow.waveform_id;

            if (_plm.BL.DA.DASystem.flag_saving_or_loading == false)
            {
                _plm.BL.BLWaveSet.current_waveform_set.all_changed(true);
            }

            if (_plm.BL.DA.DASystem.flag_disable_waveform_update == false)
            {
                uC_HarmonicFaders2.InitialiseForCurrentWaveform(Convert.ToInt32(comboBox_note_sector.SelectedValue), Convert.ToInt32(comboBox_intensity_layer.SelectedValue));
            }

            label_harmonics.Text = "Harmonics in Waveform " + _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id.ToString() + " :";
            label_wf.Text = "Single cycle for waveform " + _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform_id.ToString() + " :";

            CheckForVisualiserRefresh();

            RefreshUI();

            _plm.Cursor = entry_cursor;
        }

        public void SetDGVWaveSetToPatchesWaveSet(bool suppress_event)
        {
            if (_plm.BL.BLPatch.current_patch == null) return;

            _plm.BL.DA.DASystem.flag_suppress_ws_selection_change = suppress_event; Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            for (Int32 i = 0; i < pL_UC_AddDeleteDGV_WS.DGV.Rows.Count; i++)
            {
                int scanned_waveformset_id = Convert.ToInt32(pL_UC_AddDeleteDGV_WS.DGV.Rows[i].Cells["waveform_set_id"].Value);

                if (scanned_waveformset_id == _plm.BL.BLPatch.current_patch.waveform_set_id)
                {
                    pL_UC_AddDeleteDGV_WS.DGV.CurrentCell = pL_UC_AddDeleteDGV_WS.DGV.Rows[i].Cells[2];
                    DataGridView DGV = pL_UC_AddDeleteDGV_WS.DGV;
                    _plm.BL.BLWaveSet.set_current_waveform_set(_plm.BL.BLPatch.current_patch.waveform_set_id, Convert.ToInt32(comboBox_note_sector.SelectedValue), Convert.ToInt32(comboBox_intensity_layer.SelectedValue));

                    _plm.BL.BLWaveSet.refresh_current_waveform_set_from_DGV(ref DGV);
                    break;
                }
            }

            InitForCurrentWaveSet();

            _plm.BL.DA.DASystem.flag_suppress_ws_selection_change = false; _plm.Cursor = entry_cursor;
        }

        public void RefreshUI()
        {
            if (_plm.BL.DA.DASystem.flag_initialising_waveset == true) { return; }
            bool has_wavesets = (_plm.BL.DA.CGS.Table_waveform_set.RowCount() > 1);
            label_wsfsw.Visible = has_wavesets;
            label_wf.Visible = has_wavesets;
            pL_UC_AddDeleteDGV_AW.Visible = has_wavesets;
            uC_Waveform1.Visible = has_wavesets;
            uC_HarmonicFaders2.Visible = has_wavesets;
            label_harmonics.Visible = has_wavesets;

            m_ws.Enabled = has_wavesets;
            m_wb.Enabled = has_wavesets;
            m_waveform.Enabled = has_wavesets;
            m_ns.Enabled = has_wavesets;
            m_il.Enabled = has_wavesets;
            tabControl1.TabPages[1].Enabled = has_wavesets; //Visualise WaveSets
            tabControl1.TabPages[2].Enabled = has_wavesets; //Visualise Harmonics

            comboBox_note_sector.Visible = has_wavesets;
            comboBox_intensity_layer.Visible = has_wavesets;
            label_note_sector.Visible = has_wavesets;
            label_intensity_layer.Visible = has_wavesets;

            _plm.spectral_parser.Enabled = has_wavesets;
        }

        private void CheckForVisualiserRefresh()
        {
            if (_plm.BL.DA.DASystem.flag_saving_or_loading) return;

            if (tabControl1.SelectedIndex == 1) //Visualise Waveforms
            {
                uC_3D_Visualiser_W.refresh_world_for_3d_mode();
            }
            else if (tabControl1.SelectedIndex == 2) //Visualise Hamonics
            {
                uC_3D_Visualiser_H.refresh_world_for_3d_mode();
            }
        }

        public void Fix_PerformLayout()
        {
            //This is a fix, because otherwise after loading a file, the vertical scroll can not show, when it should.
            pL_UC_AddDeleteDGV_WS.DGV.PerformLayout();
            pL_UC_AddDeleteDGV_AW.DGV.PerformLayout();
        }





        #endregion

    }
}
