﻿using Spectral1.PRESENTATION;
using Spectral1_VBClassLibrary;
using System;
using System.Data;
using System.Linq;
using System.Windows.Forms;
using WarmBreeze_DataLibrary;
using System.IO;
using Spectral1.DATA_ACCESS;
using System.Management;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using System.Diagnostics;
using System.Runtime.Serialization.Formatters.Binary;
using Spectral1.BUSINESS_LOGIC;
using static Spectral1.PRESENTATION.PL_Indicator;
using Spectral1.PARSER;
using System.Collections.Generic;

namespace Spectral1
{
    public partial class PL_Main : Form
    {
        #region "==================== DECLARATIONS ====================================="
        const Int32 splash_duration_ms = 2000;
        string default_title = "Spectral Additive Synthesis Module - Patch Editor";

        public PL_Info PLInfo = new PL_Info();
        public BL_All BL;

        PL_Splash PLSplash = new PL_Splash();


        ManagementEventWatcher EventWatcher = new ManagementEventWatcher();
        WqlEventQuery EventQuery = new WqlEventQuery("SELECT * FROM Win32_DeviceChangeEvent WHERE EventType = 2 or EventType = 3"); //Device arrival = 2, Device REmoval = 3

        delegate void UpdateLabelTextDelegate(Label lbl, string text);
        #endregion

        #region "==================== Properties ======================================="
        public PL_UC_SpectralParser spectral_parser
        {
            get { return pL_UC_SpectralParser1; }
        }

        #endregion

        #region "==================== EVENTS - GENERAL ================================="

        private void PL_Shown(object sender, EventArgs e)
        {
            RefreshRecentlyUsed();
            AddPresetMenuItems(null, Properties.Settings.Default.presets_path);
        }

        private void PL_Main_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (CheckForSave() == false) { e.Cancel = true; };
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            timer1.Stop();
            this.Enabled = true;

            //Show all tab pages to force contols to be initialised. A TabControl by design doesn't initialise controls until a tab page is selected, but this isn't ideal for this app.
            tabControl1.Visible = true;
            for (Int32 i = tabControl1.TabPages.Count - 1; i >= 0; i--)
            {
                tabControl1.TabPages[i].Show();
            }
            tabControl1.SelectedTab = tabPatch;

            PLSplash.Hide();
            PLSplash.Dispose();

            this.Cursor = Cursors.Default;
            BL.DA.DASystem.flag_initialising_system = false;
            BL.DA.DASystem.flag_suppress_patch_events = false;
            RefreshUI();
            this.Opacity = 1.0;
            this.Visible = true;
        }

        private void PL_Main_Load(object sender, EventArgs e)
        {
            this.Visible = false;
            SyncHidden();
            BL.DA.DASystem.flag_initialising_system = true;
            tabControl1.SelectedTab = tabPatch;

            tabControl1.Visible = false;

            pL_Indicator_active_comms.SetStatus(PL_Indicator.indicator_statuses.Idle, "");
            SetStyle(ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint | ControlStyles.DoubleBuffer, true);
            Properties.Settings.Default.last_saved_filepath = "";
            label_version.Text = "Version : " + BL.DA.DASystem.GetProductVersionNumber(true);

            //Add Patch,WaveSet and Filter, just to get the user started
            BL.BLPatch.add_new_patch_with_related_data("Patch 1");
            int new_waveform_set_id = BL.BLWaveSet.add_new_waveset("WaveSet 1");
            BL.BLWaveSet.current_waveform_set.current_block.current_waveform.set_harmonic_level(0, 65535);
            BL.BLWaveSet.current_waveform_set.copy_waveform_in_all_dimensions();
            int new_body_resonance_filter_id = BL.BLFilter.add_new_body_resonance_filter("Filter 1");
            BL.BLPatch.set_patch_waveset_and_filter(new_waveform_set_id, new_body_resonance_filter_id);
            pL_UC_Patch1.InitialisePatchRelatedViewsForCurrentPatch();
            BL.execute_sdl_for_hammered_string_envelope();
            pL_UC_Patch1.DisplayEnabled(true, true);
            RefreshUI();

            RefreshUSBConnectionStatus();
        }

        #endregion

        #region "==================== EVENTS - USB ====================================="
        private void InvokeUI(Action a)
        {
            this.BeginInvoke(new MethodInvoker(a));
        }

        public void SetAllDataChangedInAnotherThread()
        {
            if (this.InvokeRequired)
            {
                this.Invoke((Action)(() => {
                    BL.DA.DASpectral.data_changed.set_all(true);//Added to ensure that it forces a complete refresh of data on the Module, on the next comms.
                    SyncVisible();
                }));
            }
        }

        private void RefreshUSBConnectionStatus()
        {
            try
            {
                //Filtered for event types : Device arrival = 2, Device Removal = 3
                USBDeviceInfo UDI = BL.DA.DAUSBComms.FindSpectralSMDevice();
                if (UDI != null)
                {
                    //Connected
                    BL.DA.DAUSBComms.InitialiseSerialPort(UDI);
                    pL_Indicator1.SetStatusInAnotherThread(PL_Indicator.indicator_statuses.Connected, "Connected");
                    pL_UC_Patch1.SetIsConnectedInAnotherThread(true);
                    pL_UC_PatchSet1.SetIsConnectedInAnotherThread(true);
                    SetAllDataChangedInAnotherThread();
                }
                else
                {
                    //Disconnected
                    BL.DA.DAUSBComms.Disconnect();
                    SyncHiddenByOtherThread();
                    pL_Indicator1.SetStatusInAnotherThread(PL_Indicator.indicator_statuses.Disconnected, "Disconnected");
                    pL_UC_Patch1.SetIsConnectedInAnotherThread(false);
                    pL_UC_PatchSet1.SetIsConnectedInAnotherThread(false);
                }
            }
            catch (Exception ex)
            {
                PLInfo.DisplayMinorError("Comms error refreshing USB connection status. Please try again.   Detail:" + ex.Message);
            }
        }

        private void EventWatcher_EventArrived(object sender, EventArgs e)
        {
            RefreshUSBConnectionStatus();
        }
        #endregion

        #region "==================== EVENTS - APP MENU ===================================="
        private void toolStripMenuItem_help_doc_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, AppDomain.CurrentDomain.BaseDirectory + "\\Resources\\SpectralSoundModule_UserGuide.chm");//, HelpNavigator.Topic, "Welcome.htm");
        }

        private void sync_module()
        {
            if (BL.BLWaveSet.current_waveform_set.intensitycc == used_midi_cc.ucc_none)
            {
                PLInfo.DisplayMinorError("The currently selected WaveSet does not have a controller set for its Intensity. " + Environment.NewLine + Environment.NewLine + "Please set this on the WaveSet tab from the options available.");
                return;
            }

            string error_text = BL.BLPatch.check_lfo_timbre_config();

            if (error_text != "")
            {
                PLInfo.DisplayMinorError("Can't sync because of the following errors relating to the Timbre LFO : " + Environment.NewLine + Environment.NewLine + error_text);
                return;
            }


            Cursor = Cursors.WaitCursor;
            SetStatus("Updating Module");
            indicator_statuses ind_status = GetActiveCommsIndicatorStatus();
            SetActiveCommsIndicator(indicator_statuses.Sending, "*");

            double level_scaling = BL.BLWaveSet.current_waveform_set.current_block.current_waveform.CalcLevelScaling();
            double filter_scaling_factor = BL.BLFilter.current_body_resonance_filter.GetFilterScalingFactor();
            BL.DA.sync_module(level_scaling, filter_scaling_factor);

            ClearStatus();
            Cursor = Cursors.Default;
            SetActiveCommsIndicator(ind_status, "*");
            SyncHidden();
        }

        private void button_sync_Click(object sender, EventArgs e)
        {
            sync_module();
        }

        private void synchroniseDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sync_module();
        }


        private void settingsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (PL_AppSettings pls = new PL_AppSettings())
            {
                pls.ShowDialog();
            }
            //default_performance_bank
        }

        private void newToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (CheckForSave() == false) { return; }

            BL.DA.reset();
            pL_UC_SpectralParser1.clear_code();
            RefreshUI();
        }

        private void toolStripMenuItem_CloseFile_Click(object sender, EventArgs e)
        {
            if (CheckForSave() == false) { return; }

            BL.DA.reset();
            this.Text = default_title;
            pL_UC_Patch1.Initialise(this);
            pL_UC_PatchSet1.Initialise(this);
            pL_UC_Waveforms1.Initialise(this);
            pL_UC_Filters1.Initialise(this);
            pL_UC_SpectralParser1.initialise(this, PARSER.c_parser.parser_modes.all);

            RefreshUI();
        }

        private void apply_preset_click(object sender, EventArgs e)
        {
            ToolStripMenuItem MenuItem = (ToolStripMenuItem)sender;
            BL.execute_sdl_from_file(MenuItem.Tag.ToString(),true);
            RefreshUI();
        }
        private void RecentFileClick(object sender, EventArgs e)
        {
            Cursor entry_cursor = this.Cursor; this.Cursor = Cursors.WaitCursor;

            {
                ToolStripMenuItem MenuItem = (ToolStripMenuItem)sender;
                string FilePath = MenuItem.Text;
                if (File.Exists(FilePath) == false)
                {
                    PLInfo.DisplayInfo("The file '" + FilePath + "' no longer exists. It will be removed from the recent file list.");
                    BL.DA.DASystem.RemoveFileFromRecentFileList(FilePath);
                }
                else
                {
                    OpenFile(FilePath);
                    Properties.Settings.Default.last_saved_filepath = FilePath;
                    Properties.Settings.Default.last_opened_filepath = FilePath;
                }
            }

            this.Cursor = entry_cursor;
        }

        private void toolStripButton_refresh_Click(object sender, EventArgs e)
        {
            sync_module();
        }

        private void toolStripButton_open_Click(object sender, EventArgs e)
        {
            SelectFileToOpen();
        }

        private void toolStripButton_save_Click(object sender, EventArgs e)
        {
            Save(false);
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Save(false);
        }

        private void saveAsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Save(true);
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SelectFileToOpen();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string version_number = BL.DA.DASystem.GetProductVersionNumber(false);
            using (PL_HelpAbout PLHA = new PL_HelpAbout(version_number))
            {
                PLHA.ShowDialog();
            }
        }

        #endregion

        #region "==================== METHODS =========================================="


        public void SyncVisible()
        {
            if ((BL.DA.DASystem.flag_saving_or_loading == false))
            {
                if ((BL.DA.DASystem.flag_saving_or_loading == false)&&(BL.DA.DAUSBComms.IsConnected() == true))
                {
                    toolStripButton_refresh.Enabled = true;
                    synchroniseDataToolStripMenuItem.Enabled = true;
                }
            }

        }

        public void SyncHidden()
        {
            toolStripButton_refresh.Enabled = false;
            synchroniseDataToolStripMenuItem.Enabled = false;
        }

        public void SyncHiddenByOtherThread()
        {
            if (this.InvokeRequired)
            {
                this.Invoke((Action)(() => {
                    SyncHidden();
                }));
            }
        }

        public bool InstanceAlreadyRunning()
        {
            foreach (Process proc in Process.GetProcesses())
            {
                if (proc.MainWindowTitle == this.Text)
                    return true;
            }
            return false;
        }

        public void SetStatus(string s)
        {
            label_status.Text = s + " ...";
            label_status.Refresh();
        }

        public void ClearStatus()
        {
            label_status.Text = "";
        }

        public PL_Main()
        {
            InitializeComponent();
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);

            BL = new BL_All(this);
            this.Enabled = false;

            if (InstanceAlreadyRunning())
            {
                PLInfo.DisplayExclamation("This app is already running on your device - you can only run one instance");
                Application.Exit();
            }

            BL.DA.DASystem.flag_suppress_patch_events = true;
            pL_UC_Patch1.Initialise(this);
            pL_UC_PatchSet1.Initialise(this);
            pL_UC_Waveforms1.Initialise(this);
            pL_UC_Filters1.Initialise(this);
            BL.DA.DASystem.flag_suppress_patch_events = false;

            timer1.Interval = splash_duration_ms;
            timer1.Start();
            PLSplash.Show();
            PLSplash.Refresh();

            EventWatcher.EventArrived += new EventArrivedEventHandler(EventWatcher_EventArrived);
            EventWatcher.Query = EventQuery;
            EventWatcher.Start();
            Debug.WriteLine("---------------------------------------------------");
        }



        private void SelectFileToOpen()
        {
            using (System.Windows.Forms.OpenFileDialog openFileDialog1 = new System.Windows.Forms.OpenFileDialog())
            {
                try
                {
                    if (Properties.Settings.Default.last_opened_filepath != null && Properties.Settings.Default.last_opened_filepath != "")
                    {
                        openFileDialog1.InitialDirectory = Path.GetFullPath(Properties.Settings.Default.last_opened_filepath);
                    }

                    openFileDialog1.RestoreDirectory = true;
                    openFileDialog1.Title = "Open";
                    openFileDialog1.DefaultExt = "spectral";
                    openFileDialog1.Filter = "Spectral Sound Module files (*.spectral)|*.spectral";

                    if (openFileDialog1.ShowDialog() == DialogResult.OK)
                    {
                        OpenFile(openFileDialog1.FileName);
                    }
                }
                catch (Exception ex)
                {
                    PLInfo.DisplayMinorError("Error opening file : " + ex.Message);
                }
            }
        }

        public void SetActiveCommsIndicator(PL_Indicator.indicator_statuses status,string status_text)
        {
            pL_Indicator_active_comms.SetStatus(status, status_text);
        }

        public PL_Indicator.indicator_statuses GetActiveCommsIndicatorStatus()
        {
            return pL_Indicator_active_comms.GetStatus();
        }

        public bool CheckForSave()
        {
            bool status = true;
            
            if (pL_UC_SpectralParser1.got_code)
            {
                if (PLInfo.DisplayExclamation2("The current SDL Code will be lost unless you save it!" + Environment.NewLine + Environment.NewLine + "Are you sure you want to continue?") == false)
                { return false; }
            }

            if(BL.DA.DASpectral.data_changed.get_changed_since_last_save())//OLD 271221: if (BL.DA.CGS.DataHasChanged() == true)
            {
                DialogResult d = PLInfo.DisplayConfirmWithCancel("Changes have been made. Do you want to save them?");
                if (d == DialogResult.Yes)
                {
                    Save(false);
                }
                else if (d == DialogResult.Cancel)
                    { status = false; }
            }

            return status;
        }

        private bool Save(bool flag_save_as)
        {
            bool status = true;
            Cursor entry_cursor = Cursor; Cursor = Cursors.WaitCursor;

            tabControl1.Focus(); //To force leaving edit mode of any control
            Cursor = Cursors.WaitCursor;
            SetStatus("Saving");
            tabControl1.Visible = false;
            pL_UC_Patch1.DisplayEnabled(false, false);

            string error_text = "";
            if (flag_save_as)
            {
                error_text = BL.DA.SaveAs();
            }
            else
            { error_text = BL.DA.Save(); }

            if (error_text != "")
            {
                PLInfo.DisplayMinorError(error_text);
                status = false;
                this.Text = default_title;
            }
            else
            {
                this.Text = default_title + "  :  " + BL.DA.current_file_name;
            }

            pL_UC_Patch1.DisplayEnabled(true, true);
            tabControl1.Visible = true;
            RefreshUI();
            ClearStatus();
            RefreshRecentlyUsed();
            Cursor = entry_cursor;

            return status;
        }

        private void OpenFile(string filename)
        {
            string error_text = "";
        
            SetStatus("Loading");
            tabControl1.Visible = false;
            Cursor = Cursors.WaitCursor;
            Enabled = false;
            pL_UC_Patch1.DisplayEnabled(false, false);

            BL.DA.DASystem.flag_suppress_patch_set_events = true;

            if (BL.DA.OpenFile(filename) != "")
            {
                PLInfo.DisplayMinorError(error_text);
                this.Text = default_title;
            }
            else
            {
                this.Text = default_title + "  :  " + BL.DA.current_file_name;
                BL.DA.DASpectral.data_changed.set_all(true);
            }

            pL_UC_Patch1.RefreshPatchCurrentValuesFromDGV();
            BL.BLPatch.set_current_patch(BL.DA.CGS.Table_patch.CurrentRow.patch_id);
            remote_SetDGVWaveSetToPatchesWaveSet();
            remote_SetDGVFilterToPatchFilter();

            RefreshRecentlyUsed();
            pL_UC_Patch1.DisplayEnabled(true, true);
            pL_UC_Waveforms1.SetDGVWaveSetToPatchesWaveSet(true);
            pL_UC_Filters1.SetDGVFilterToPatchFilter();

            Enabled = true;
            pL_UC_Patch1.InitialiseForLoadedFile();
            tabControl1.Visible = true;
            PerformLayoutOnControlAndSubControls(this); //To make sure vertical scroll bars show

            RefreshUI();
            Cursor = Cursors.Default;
            SyncVisible();
            ClearStatus();

            BL.DA.DASystem.flag_suppress_patch_set_events = false;
        }

        private void RefreshRecentlyUsed()
        {
            ToolStripMenuItem parent_menuitem = RecentFilesToolStripMenuItem;

            // Remove any existing handlers
            for (int i = 0; i < parent_menuitem.DropDownItems.Count; i++)
                parent_menuitem.DropDownItems[i].Click -= RecentFileClick;

            // Clear and populate
            parent_menuitem.DropDownItems.Clear();
            DataSet_System.FileListTableRow[] RecentFilesRows = BL.DA.DASystem.RecentlyUsedFileRows;
            for (int i = 0; i < BL.DA.DASystem.RecentlyUsedFileRows.Count(); i++)
            {
                ToolStripMenuItem sub_item = new ToolStripMenuItem(RecentFilesRows[i].FilePath);
                sub_item.DisplayStyle = ToolStripItemDisplayStyle.Text;
                parent_menuitem.DropDownItems.Add(sub_item);
                parent_menuitem.DropDownItems[i].Click += RecentFileClick;
            }
        }

        private void AddPresetMenuItems(ToolStripMenuItem root_menu_item, string folder_path)
        {
            string[] file_list = Directory.GetFiles(folder_path,"*.txt");
            string[] folder_list = Directory.GetDirectories(folder_path);

            //Add files
            for (int i = 0; i < file_list.Count(); i++)
            {
                ToolStripMenuItem sub_item = new ToolStripMenuItem(Path.GetFileName(file_list[i]));
                sub_item.DisplayStyle = ToolStripItemDisplayStyle.ImageAndText;
                sub_item.Image = Properties.Resources.execute;
                sub_item.ImageTransparentColor = System.Drawing.Color.Magenta;
                sub_item.Tag = file_list[i];
                if (root_menu_item == null)
                {
                    tsb_apply_preset.DropDownItems.Add(sub_item);
                    tsb_apply_preset.DropDownItems[i].Click += apply_preset_click;
                }
                else
                {
                    root_menu_item.DropDownItems.Add(sub_item);
                    root_menu_item.DropDownItems[i].Click += apply_preset_click;
                }
            }
            if ((file_list.Count() > 0) && (folder_list.Count() > 0))
            {
                if (root_menu_item == null)
                {
                    tsb_apply_preset.DropDownItems.Add("-");
                }
                else
                {
                    root_menu_item.DropDownItems.Add("-");
                }
             
            }

            //Add folders
            for (int i = 0; i < folder_list.Count(); i++)
            {
                ToolStripMenuItem sub_item = new ToolStripMenuItem(folder_list[i].Split(Path.DirectorySeparatorChar).Last()); 
                sub_item.DisplayStyle = ToolStripItemDisplayStyle.Text;
                sub_item.Tag = folder_list[i];
                if (root_menu_item == null)
                {
                    tsb_apply_preset.DropDownItems.Add(sub_item);
                }
                else
                {
                    root_menu_item.DropDownItems.Add(sub_item);
                }

                AddPresetMenuItems(sub_item, folder_list[i]);
            }
        }

        public void RefreshUI()
        {
            if ((BL.DA.DASystem.flag_initialising_system == true)|| (BL.DA.DASystem.flag_suppress_patch_events == true)) { return; }

            Cursor entry_cursor = this.Cursor; this.Cursor = Cursors.WaitCursor;

            tsb_apply_preset.Enabled = BL.patch_and_waveset_exists;

            pL_UC_Patch1.RefreshUI();
            pL_UC_PatchSet1.RefreshUI();
            pL_UC_Waveforms1.RefreshUI();
            pL_UC_Filters1.RefreshUI();
            pL_UC_SpectralParser1.RefreshUI();

            this.Cursor = entry_cursor;
        }



        #endregion

        #region "==================== METHODS - PATCH =================================="
        public void remote_InitialisePatchRelatedViewsForCurrentPatch()
        {
            pL_UC_Patch1.RefreshPatchCurrentValuesFromDGV();
            pL_UC_Patch1.InitialisePatchRelatedViewsForCurrentPatch();
        }

        public void remote_InitForCurrentWaveSet()
        {
            pL_UC_Waveforms1.InitForCurrentWaveSet();
        }

        public void remote_SetDGVWaveSetToPatchesWaveSet()
        {
            pL_UC_Waveforms1.SetDGVWaveSetToPatchesWaveSet(true);
        }

        public void remote_SetDGVFilterToPatchFilter()
        {
            pL_UC_Filters1.SetDGVFilterToPatchFilter();
        }

        public void remote_enable_envelope_display(bool e)
        {
            pL_UC_Patch1.remote_enable_envelope_display(e);
        }

        public Int32 envelope_note_for()
        {
            return pL_UC_Patch1.envelope_note_for();
        }

        #endregion

        #region "==================== OTHER ============================================"
        [System.Security.Permissions.PermissionSet(System.Security.Permissions.SecurityAction.Demand, Name = "FullTrust")]

        protected override void WndProc(ref Message m)
        {
            // Listen for operating system messages
            const Int32 SC_MINIMIZE = 0XF020;
            const Int32 SC_MAXIMIZE = 0XF030;
            const Int32 SC_RESTORE = 0XF120;

            switch (m.Msg)
            {
                case SC_RESTORE:
                    this.SuspendLayout();
                    this.WindowState = FormWindowState.Normal;
                    this.ResumeLayout();
                    break;
                case SC_MAXIMIZE:
                    this.SuspendLayout();
                    this.WindowState = FormWindowState.Maximized;
                    this.ResumeLayout();
                    break;
                case SC_MINIMIZE:
                    this.SuspendLayout();
                    this.WindowState = FormWindowState.Maximized;
                    this.ResumeLayout();
                    break;
            }
            base.WndProc(ref m);
        }


        private void PerformLayoutOnControlAndSubControls(Control c)
        {
            c.PerformLayout();
            foreach (Control i in c.Controls)
            {
                PerformLayoutOnControlAndSubControls(i);
            }
        }

        private void PL_Main_ResizeBegin(object sender, EventArgs e)
        {
            BeginControlUpdate(this);
        }


        private void PL_Main_ResizeEnd(object sender, EventArgs e)
        {
            EndControlUpdate(this);
        }
        #endregion

        #region "==================== WINDOWS SPECIAL =================================="
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                cp.ExStyle |= 0x02000000;  // Turn on WS_EX_COMPOSITED
                return cp;
            }
        }

        /// An application sends the WM_SETREDRAW message to a window to allow changes in that 
        /// window to be redrawn or to prevent changes in that window from being redrawn.
        /// </summary>
        private const int WM_SETREDRAW = 11;

        /// <summary>
        /// Suspends painting for the target control. Do NOT forget to call EndControlUpdate!!!
        /// </summary>
        /// <param name="control">visual control</param>
        public static void BeginControlUpdate(Control control)
        {
            Message msgSuspendUpdate = Message.Create(control.Handle, WM_SETREDRAW, IntPtr.Zero,
                  IntPtr.Zero);

            NativeWindow window = NativeWindow.FromHandle(control.Handle);
            window.DefWndProc(ref msgSuspendUpdate);
        }

        /// <summary>
        /// Resumes painting for the target control. Intended to be called following a call to BeginControlUpdate()
        /// </summary>
        /// <param name="control">visual control</param>
        public static void EndControlUpdate(Control control)
        {
            // Create a C "true" boolean as an IntPtr
            IntPtr wparam = new IntPtr(1);
            Message msgResumeUpdate = Message.Create(control.Handle, WM_SETREDRAW, wparam,
                  IntPtr.Zero);

            NativeWindow window = NativeWindow.FromHandle(control.Handle);
            window.DefWndProc(ref msgResumeUpdate);
            control.Invalidate();
            control.Refresh();
        }










        #endregion


    }
}
