﻿namespace Spectral1.PARSER
{
    public partial class c_lexer
    {
        #region "====================== METHODS - PATCH TOKEN LOGIC ======================"

        public static bool is_patch_definition_object_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.General
                   || token.TokenType == TokenType.ADSR;
        }

        public static bool is_patch_general_function_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.SetPortamento
              || token.TokenType == TokenType.SetScalingSplit
              || token.TokenType == TokenType.SetPatchGain
              || token.TokenType == TokenType.SetDetuning
              || token.TokenType == TokenType.SetActiveOscillators
              || token.TokenType == TokenType.SetDetuningMode
              || token.TokenType == TokenType.SetOscillatorDetuning
              || token.TokenType == TokenType.SetLFO
              || token.TokenType == TokenType.SetEnvelopeGainController;
        }

        public static bool is_patch_adsr_function_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.ConfigureSection
            || token.TokenType == TokenType.ConfigureEnvelope
            || token.TokenType == TokenType.LoadPreset;
        }

        public static bool is_detuning_type_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Random || token.TokenType == TokenType.Regular;
        }

        public static bool is_detuning_mode_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Cents || token.TokenType == TokenType.Hz;
        }

        public static bool is_lfo_type_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Tremolo ||
                token.TokenType == TokenType.Vibrato ||
                token.TokenType == TokenType.TimbreLFO;
        }

        public static bool is_CC_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Modulation ||
                token.TokenType == TokenType.BreathController ||
                token.TokenType == TokenType.FootController ||
                token.TokenType == TokenType.Expression ||
                token.TokenType == TokenType.Velocity||
                token.TokenType == TokenType.None; 
        }

        public static bool is_adsr_section_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Attack ||
                token.TokenType == TokenType.Decay ||
                token.TokenType == TokenType.Sustain ||
                token.TokenType == TokenType.Release;
        }

        public static bool is_adsr_preset_name_token(c_lexer_token token)
        {
            return
                token.TokenType == TokenType.amplitude_HammeredString ||
                token.TokenType == TokenType.amplitude_SlowAttack ||
                token.TokenType == TokenType.amplitude_VerySlowAttack ||
                token.TokenType == TokenType.amplitude_Organlike ||
                token.TokenType == TokenType.tremolo_DeepAndSlow ||
                token.TokenType == TokenType.tremolo_ShallowAndSlow ||
                token.TokenType == TokenType.tremolo_DeepAndFast ||
                token.TokenType == TokenType.tremolo_ShallowAndFast ||
                token.TokenType == TokenType.tremolo_BulkSetLinearDSR ||
                token.TokenType == TokenType.tremolo_BulkSetExpDSR ||
                token.TokenType == TokenType.tremolo_Clear ||
                token.TokenType == TokenType.vibrato_DeepAndSlow ||
                token.TokenType == TokenType.vibrato_ShallowAndSlow ||
                token.TokenType == TokenType.vibrato_DeepAndFast ||
                token.TokenType == TokenType.vibrato_ShallowAndFast ||
                token.TokenType == TokenType.vibrato_BulkSetLinearADSR ||
                token.TokenType == TokenType.vibrato_BulkSetExpADSR ||
                token.TokenType == TokenType.vibrato_Clear ||
                token.TokenType == TokenType.timbre_FastSweepUp ||
                token.TokenType == TokenType.timbre_SlowSweepUp ||
                token.TokenType == TokenType.timbre_ExpVeryFastSweepUp ||
                token.TokenType == TokenType.timbre_FastSweepDown ||
                token.TokenType == TokenType.timbre_SlowSweepDown ||
                token.TokenType == TokenType.timbre_ExpVeryFastSweepDown ||
                token.TokenType == TokenType.timbre_ExpFastSweepUp ||
                token.TokenType == TokenType.timbre_ExpSlowSweepUp ||
                token.TokenType == TokenType.timbre_ExpFastSweepDown ||
                token.TokenType == TokenType.timbre_ExpSlowSweepDown ||
                token.TokenType == TokenType.timbre_BulkSetLinearADSR ||
                token.TokenType == TokenType.timbre_BulkSetExpADSR ||
                token.TokenType == TokenType.timbre_Clear ||
                token.TokenType == TokenType.noise_QuickSoftPuff ||
                token.TokenType == TokenType.noise_SlowSoftPuff ||
                token.TokenType == TokenType.noise_QuickHardPuff ||
                token.TokenType == TokenType.noise_SlowHardPuff ||
                token.TokenType == TokenType.noise_Clear ||
                token.TokenType == TokenType.noise_co_apply_lpf_exp_fast ||
                token.TokenType == TokenType.noise_co_apply_lpf_exp_slow ||
                token.TokenType == TokenType.noise_co_BulkSetLinearADSR ||
                token.TokenType == TokenType.noise_co_BulkSetExpADSR ||
                token.TokenType == TokenType.noise_co_Clear ||
                token.TokenType == TokenType.pitch_fast_linear_drop ||
                token.TokenType == TokenType.pitch_slow_linear_drop ||
                token.TokenType == TokenType.pitch_fast_linear_rise ||
                token.TokenType == TokenType.pitch_slow_linear_rise ||
                token.TokenType == TokenType.pitch_fast_exp_drop ||
                token.TokenType == TokenType.pitch_slow_exp_drop ||
                token.TokenType == TokenType.pitch_fast_exp_rise ||
                token.TokenType == TokenType.pitch_slow_exp_rise ||
                token.TokenType == TokenType.pitch_BulkSetLinearADSR ||
                token.TokenType == TokenType.pitch_BulkSetExpADSR ||
                token.TokenType == TokenType.pitch_Clear ||
                token.TokenType == TokenType.sample_AttackOnLevel100 ||
                token.TokenType == TokenType.sample_AttackOnLevel75 ||
                token.TokenType == TokenType.sample_AttackOnLevel50 ||
                token.TokenType == TokenType.sample_AttackOnLevel25 ||
                token.TokenType == TokenType.sample_SustainOnLevel25 ||
                token.TokenType == TokenType.sample_ReleaseOnLevel25 ||
                token.TokenType == TokenType.sample_AttackOnLevel10 ||
                token.TokenType == TokenType.sample_SustainOnLevel10 ||
                token.TokenType == TokenType.sample_ReleaseOnLevel10 ||
                token.TokenType == TokenType.sample_AttackOnLevel5 ||
                token.TokenType == TokenType.sample_SustainOnLevel5 ||
                token.TokenType == TokenType.sample_ReleaseOnLevel5 ||
                token.TokenType == TokenType.sample_KS_100 ||
                token.TokenType == TokenType.sample_KS_75 ||
                token.TokenType == TokenType.sample_KS_50 ||
                token.TokenType == TokenType.sample_KS_25 ||
                token.TokenType == TokenType.sample_Clear ||
                token.TokenType == TokenType.timbre_lfo_DeepAndSlow ||
                token.TokenType == TokenType.timbre_lfo_ShallowAndSlow ||
                token.TokenType == TokenType.timbre_lfo_DeepAndFast ||
                token.TokenType == TokenType.timbre_lfo_ShallowAndFast ||
                token.TokenType == TokenType.timbre_lfo_BulkSetLinearDSR ||
                token.TokenType == TokenType.timbre_lfo_BulkSetExpDSR ||
                token.TokenType == TokenType.timbre_lfo_Clear;
        }

        public static bool is_sample_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.KeyHammer1 ||
                token.TokenType == TokenType.KeyHammer2 ||
                token.TokenType == TokenType.KeyHammer3 ||
                token.TokenType == TokenType.KeyHammer4 ||
                token.TokenType == TokenType.BowScrape1 ||
                token.TokenType == TokenType.BowScrape2 ||
                token.TokenType == TokenType.KeyClick ||
                token.TokenType == TokenType.KeyUp ||
                token.TokenType == TokenType.KSVLong ||
                token.TokenType == TokenType.KSLong ||
                token.TokenType == TokenType.KSStd ||
                token.TokenType == TokenType.KSShort ||
                token.TokenType == TokenType.KSVShort ||
                token.TokenType == TokenType.KSVLongF ||
                token.TokenType == TokenType.KSLongF ||
                token.TokenType == TokenType.KSStdF ||
                token.TokenType == TokenType.KSShortF ||
                token.TokenType == TokenType.KSVShortF ||
                token.TokenType == TokenType.None;
        }

        public static bool is_sample_mode_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Looped ||
                token.TokenType == TokenType.OneShot;
        }

        public static bool is_envelope_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Amplitude ||
                token.TokenType == TokenType.NoiseGain ||
                token.TokenType == TokenType.NoiseCutoffFrequency ||
                token.TokenType == TokenType.TimbreMorph ||
                token.TokenType == TokenType.SampleGain ||
                token.TokenType == TokenType.PitchShift ||
                token.TokenType == TokenType.TremoloDepth ||
                token.TokenType == TokenType.VibratoDepth ||
                token.TokenType == TokenType.TimbreLFODepth;
        }

        public static bool is_envelope_type_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Linear ||
                token.TokenType == TokenType.Exponential||
                token.TokenType == TokenType.None;
        }

        #endregion
    }
}
