﻿using Spectral1.BUSINESS_LOGIC;
using Spectral1.DATA_ACCESS;
using System;
using System.Windows.Forms;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.PARSER
{
    public class c_dsl_patch_execute
    {
        #region "======================== DECLARATIONS ==================================="
        PL_Main _plm;
        #endregion

        #region "======================== METHODS ==================================="
        public c_dsl_patch_execute(PL_Main plm)
        {
            _plm = plm;
        }

        public Int32 convert_friendly_target_to_65535(string target_percent)
        {
            return (int)(65535.0 * Convert.ToDouble(target_percent));
        }

        public void execute_sdl(c_dsl_functions dslf,extended_rtb rtb)
        {
            c_parser_dsl_function f = null;
            try
            {
                for (int i = 0; i < dslf.list_of_functions.Count; i++)
                {
                    f = dslf.list_of_functions[i];
                    if (f.definition_object == definition_objects.Patch)
                    {
                        int patch_id = _plm.BL.BLPatch.current_patch.patch_id;

                        switch (f.function)
                        {
                            case functions.P_GEN_SetActiveOscillators:
                                _plm.BL.BLPatch.current_patch.active_layers = check_integer(f.parameter_values[0],0,DA_Spectral.max_oscillators,"Not a valid Oscillator count !");
                                break;
                            case functions.P_GEN_SetDetuning:
                                if (f.parameter_values[0] == "Regular")
                                { _plm.BL.BLPatch.current_patch.degree_of_regular_detuning = check_float(f.parameter_values[1],0, DA_Spectral.max_regular_and_random_detuning,"Not a valid detuning value"); }
                                else
                                { _plm.BL.BLPatch.current_patch.degree_of_random_detuning = check_float(f.parameter_values[1], 0, DA_Spectral.max_regular_and_random_detuning, "Not a valid detuning value"); }

                                break;
                            case functions.P_GEN_SetDetuningMode:
                                _plm.BL.BLPatch.current_patch.detuning_mode_id = GetDetuningModeIDFromName(f.parameter_values[0]);
                                break;
                            case functions.P_GEN_SetEnvelopeGainControllero:
                                envelope_controlRow ecr =_plm.BL.BLPatch.current_patch.envelope_control_row(patch_id, GetEnvelopeIDFromName(f.parameter_values[0]));
                                ecr.depth_initial_level = check_integer(f.parameter_values[1],0,65535,"Invalid level !");
                                ecr.gain_cc_source = GetCCIDFromName(f.parameter_values[2]);
                                break;
                            case functions.P_GEN_SetLFO:
                                //General.SetLFO(LFOType:Tremolo,Enabled:False,WaveType:Sine,Frequency:0.0,FrequencyCC:None,DepthCC:None);
                                lfo_envelope_configRow lecr = _plm.BL.BLPatch.current_patch.lfo_envelope_config_row(patch_id, GetLFOIDFromName(f.parameter_values[0]));
                                lecr.lfo_envelope_config_id = GetLFOIDFromName(f.parameter_values[0]);
                                lecr.enabled = bool_string_to_int(f.parameter_values[1]);
                                lecr.lfo_wave_type_id = GetWaveShapeIDFromName(f.parameter_values[2]);
                                lecr.default_wt_inc_q11_5 = check_float(f.parameter_values[3],0,100,"Invalid frequency !");
                                lecr.freq_cc_source = GetCCIDFromName(f.parameter_values[4]);
                                lecr.depth_cc_source = GetCCIDFromName(f.parameter_values[5]);
                                break;
                            case functions.P_GEN_SetOscillatorDetuning:
                                switch (f.parameter_values[0])
                                {
                                    case "0":
                                        _plm.BL.BLPatch.current_patch.layer0_st_inc_q11_5_detune = check_float(f.parameter_values[1],0, max_oscillator_detuning,"Not a valid detuning value !");
                                        break;
                                    case "1":
                                        _plm.BL.BLPatch.current_patch.layer1_st_inc_q11_5_detune = check_float(f.parameter_values[1], 0, max_oscillator_detuning, "Not a valid detuning value !");
                                        break;
                                    case "2":
                                        _plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune = check_float(f.parameter_values[1], 0, max_oscillator_detuning, "Not a valid detuning value !");
                                        break;
                                }
                                
                                break;
                            case functions.P_GEN_SetPatchGain:
                                _plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune = convert_friendly_percent_to_real100(f.parameter_values[0]);
                                break;
                            case functions.P_GEN_SetPortamento:
                                _plm.BL.BLPatch.current_patch.portamento_enabled = bool_string_to_int(f.parameter_values[0]);
                                _plm.BL.BLPatch.current_patch.portamento_rate = convert_friendly_percent_to_real100(f.parameter_values[1]);
                                break;
                            case functions.P_GEN_SetScalingSplit:
                                _plm.BL.BLPatch.current_patch.key_scale_split_note_id = BL_MIDI.NoteNameToNumber(f.parameter_values[0]);
                                break;
                            case functions.P_ADSR_ConfigureEnvelope:
                                //ADSR.ConfigureEnvelope(Section:Attack,Envelope:Amplitude,EnvelopeType:None,
                                //Target:0.0,TargetKSU:0.00,TargetKSL:0.00,LinearDelta:0,LinearDeltaKSU:0.0,
                                //LinearDeltaKSL:0.0,ExpMult:3.00,ExpMultKSU:0.0,ExpMultKSL:0.0);
                                adsr_section_envelope_configRow asecr = _plm.BL.BLPatch.current_patch.adsr_section_envelope_config_row(patch_id, GetSectionIDFromName(f.parameter_values[0]), GetEnvelopeIDFromName(f.parameter_values[1]));
                                asecr.depth_env_type_id = GetEnvelopeTypeIDFromName(f.parameter_values[2]);
                                asecr.depth_env_target = check_unsigned_percentage(f.parameter_values[3]);//OLD 030122: convert_friendly_target_to_65535(check_unsigned_percentage(f.parameter_values[3]).ToString());
                                asecr.depth_env_target_keyscale_upper = check_signed_percentage(f.parameter_values[4]);
                                asecr.depth_env_target_keyscale_lower = check_signed_percentage(f.parameter_values[5]);
                                asecr.depth_env_lin_delta = check_integer(f.parameter_values[6],-10000,10000,"Invalid delta value !");
                                asecr.depth_env_lin_delta_keyscale_upper = check_signed_percentage(f.parameter_values[7]);
                                asecr.depth_env_lin_delta_keyscale_lower = check_signed_percentage(f.parameter_values[8]);
                                asecr.depth_env_exp_multiplier = check_unsigned_percentage(f.parameter_values[9]);
                                asecr.depth_env_exp_multiplier_keyscale_upper = check_signed_percentage(f.parameter_values[10]);
                                asecr.depth_env_exp_multiplier_keyscale_lower = check_signed_percentage(f.parameter_values[11]);
                                break;
                            case functions.P_ADSR_ConfigureSection:
                                // ADSR.ConfigureSection(Section:Attack,Enabled:True,Duration:25,EndKSU:0.0,EndKSL:0.0,Sample:None,SampleMode:One-shot);
                                adsr_sectionRow asr = _plm.BL.BLPatch.current_patch.adsr_section_row(patch_id, GetSectionIDFromName(f.parameter_values[0]));
                                asr.adsr_section_id = GetSectionIDFromName(f.parameter_values[0]);
                                asr.flag_active = bool_string_to_int(f.parameter_values[1]);
                                asr.end_time_ms = check_integer(f.parameter_values[2],10,60000,"Invalid end duration !");
                                asr.end_time_ms_keyscale_upper = check_signed_percentage(f.parameter_values[3]);
                                asr.end_time_ms_keyscale_lower = check_signed_percentage(f.parameter_values[4]);
                                asr.inharmonic_sample_id = GetSampleIDFromName(f.parameter_values[5]);
                                asr.inharmonic_sample_playback_mode_id = GetSampleModeIDFromName(f.parameter_values[6]);
                                break;
                            case functions.P_ADSR_LoadPreset:
                                string preset_name = f.parameter_values[0];
                                Int32 adsr_preset_id = DA_Spectral.GetADSRPresetIDFromName(preset_name);
                                float bulk_value = check_float(f.parameter_values[1],0,100,"Invalid bulk value !");
                                _plm.BL.BLPatch.load_preset(adsr_preset_id, bulk_value);

                                break;
                        }
                    }
                }
                _plm.remote_InitialisePatchRelatedViewsForCurrentPatch();
                _plm.PLInfo.DisplayInfo("Patch updated successfully");
            }
            catch (Exception Ex)
            {
                rtb.highlight_line(f.start_position, System.Drawing.Color.Red);
                _plm.PLInfo.DisplayMinorError("Error running SDL code. \r\n\r\n" + "Function : " + f.function.ToString() + "\r\nError : " + Ex.Message);
            }
        }

        #endregion

    }
}
