/*
 * File:   main.c
 * Author: Jeremy Leach
 */

// DSPIC33EP512MC502 Configuration Bit Settings

// 'C' source line config statements

// FICD
#pragma config ICS = PGD3               // ICD Communication Channel Select bits (Communicate on PGEC3 and PGED3)
#pragma config JTAGEN = OFF             // JTAG Enable bit (JTAG is disabled)

// FPOR
#pragma config ALTI2C1 = OFF            // Alternate I2C1 pins (I2C1 mapped to SDA1/SCL1 pins)
#pragma config ALTI2C2 = OFF            // Alternate I2C2 pins (I2C2 mapped to SDA2/SCL2 pins)
#pragma config WDTWIN = WIN25           // Watchdog Window Select bits (WDT Window is 25% of WDT period)

// FWDT
#pragma config WDTPOST = PS32768        // Watchdog Timer Postscaler bits (1:32,768)
#pragma config WDTPRE = PR128           // Watchdog Timer Prescaler bit (1:128)
#pragma config PLLKEN = ON              // PLL Lock Enable bit (Clock switch to PLL source will wait until the PLL lock signal is valid.)
#pragma config WINDIS = OFF             // Watchdog Timer Window Enable bit (Watchdog Timer in Non-Window mode)
#pragma config FWDTEN = OFF             // Watchdog Timer Enable bit (Watchdog timer enabled/disabled by user software)

// FOSC
#pragma config POSCMD = EC              // Primary Oscillator Mode Select bits (EC (External Clock) Mode)
#pragma config OSCIOFNC = ON            // OSC2 Pin Function bit (OSC2 is general purpose digital I/O pin)
#pragma config IOL1WAY = OFF            // Peripheral pin select configuration (Allow multiple reconfigurations)
#pragma config FCKSM = CSECME           // Clock Switching Mode bits (Both Clock switching and Fail-safe Clock Monitor are enabled)

// FOSCSEL
#pragma config FNOSC = PRIPLL           // Oscillator Source Selection (Primary Oscillator with PLL module (XT + PLL, HS + PLL, EC + PLL))
#pragma config PWMLOCK = OFF            // PWM Lock Enable bit (PWM registers may be written without key sequence)
#pragma config IESO = ON                // Two-speed Oscillator Start-up Enable bit (Start up device with FRC, then switch to user-selected oscillator source)

// FGS
#pragma config GWRP = OFF               // General Segment Write-Protect bit (General Segment may be written)
#pragma config GCP = OFF                // General Segment Code-Protect bit (General Segment Code protect is Disabled)

// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

#define  FCY  70000000UL    // Instruction cycle frequency, Hz - required for __delayXXX() to work

#include <xc.h>
#include "Spectral_Pins.h"
#include "Spectral_Interrupts.h"
#include "Spectral_Sounds.h"
#include "Spectral_SPI_1.h"
#include "Spectral_Timer1.h"

#include <libpic30.h>        // __delayXXX() functions macros defined here

int main(void) {
    //===========Set the instruction frequency to 70MHz (MIPS)=================
    CLKDIVbits.PLLPRE = 0;  //(0 + offset 2 = 2). Options are 2,3 ..33)16MHz external clock / 2 = 8 MHz. which is within the acceptable range of 0.8-8 MHz.
    PLLFBDbits.PLLDIV = 33; //(33 + offset 2 = 20)8MHz * 35 = 280MHz. which is within the 120-340 MHz ranged needed. 
    CLKDIVbits.PLLPOST = 0; 
    while(!OSCCONbits.LOCK);//Wait for PLL ready
    //FPLLO = FIN * (PLLDIV + 2)/[(PLLPRE + 2) * 2(PLLPOST + 1)] = 16MHz * 35/(2 * 2 * 1)) = 140
    //FCY = FPLLO/ 2 = 70 MIPS
    
    //===========Set core calculation options =================================
    CORCONbits.US = 0; //0 = DSP engine multiplies are signed
    CORCONbits.IF = 0; //0 = Fractional mode enabled for DSP multiply ops
    
    //============Disable selected peripherals to reduce power consumption. 1 = Disable.========
    PMD1bits.AD1MD = 1; //ADC1 Module Disable bit
    PMD1bits.C1MD = 1; //ECAN1 Module Disable bit
    PMD1bits.I2C1MD = 1; //I2C1 Module Disable bit
    PMD1bits.SPI1MD = 0; //SPI1 Module Disable bit
    PMD1bits.SPI2MD = 1; //SPI2 Module Disable bit
    PMD1bits.T1MD = 0; //Timer1 Module Disable bit
    PMD1bits.T2MD = 0; //Timer2 Module Disable bit
    PMD1bits.T3MD = 1; //Timer3 Module Disable bit
    PMD1bits.T4MD = 1; //Timer4 Module Disable bit
    PMD1bits.T5MD = 1; //Timer5 Module Disable bit
    PMD1bits.U1MD = 1; //UART1 Module Disable bit
    PMD1bits.U2MD = 1; //UART2 Module Disable bit
    PMD1bits.QEI1MD = 1; //QEI1 Module Disable bit.
    PMD1bits.PWMMD = 1; //PWMMD Module Disable bit.   
    
    PMD2bits.IC1MD = 1; //Input Capture 1 Module Disable bit
    PMD2bits.IC2MD = 1; //Input Capture 2 Module Disable bit
    PMD2bits.IC3MD = 1; //Input Capture 3 Module Disable bit
    PMD2bits.IC4MD = 1; //Input Capture 4 Module Disable bit
    PMD2bits.OC1MD = 1; //Output Compare 1 Module Disable bit
    PMD2bits.OC2MD = 1; //Output Compare 1 Module Disable bit   
    PMD2bits.OC3MD = 1; //Output Compare 1 Module Disable bit
    PMD2bits.OC4MD = 1; //Output Compare 1 Module Disable bit
    
    PMD3bits.CMPMD = 1; //Comparator Module Disable bit
    PMD3bits.CRCMD = 1; //CRC Module Disable bit
    PMD3bits.I2C2MD= 1; //I2C2 Module Disable bit
    
    PMD4bits.CTMUMD = 1; //CTMU Module Disable bit
    PMD4bits.REFOMD = 1; //Reference clock Module Disable bit
    
    PMD6bits.PWM1MD = 1; //PWM1 Module Disable bit
    PMD6bits.PWM2MD = 1; //PWM2 Module Disable bit
    PMD6bits.PWM3MD = 1; //PWM3 Module Disable bit
    
    PMD7bits.DMA0MD = 1; //DMA0 Module Disable bit
    PMD7bits.DMA1MD = 1; //DMA1 Module Disable bit
    PMD7bits.DMA2MD = 1; //DMA2 Module Disable bit
    PMD7bits.DMA3MD = 1; //DMA3 Module Disable bit
    PMD7bits.PTGMD = 1;  //PTG Module Disable bit
    
    Spectral_Pins_Initialize();
    SPI1_Initialize();
    Sounds_Initialize();
    Timer_Initialize();
    Interrupts_Initialize();

    uint16_t i = 0;
    int16_t note_on_instance_id;
    while(1)
        { 
        note_on_instance_id = ProcessSPIRxBuffer();
        if (note_on_instance_id != -1){i = note_on_instance_id;}//Forces immediate calculation if a note on message is received
        TimbreUpdate(i);

        i++; if (i==max_instances){i=0;}
        }
  
    return 1;
}
