/* 
 * File:   Spectral_Interrupts.c
 * Author: Jeremy Leach
 */

#include "Spectral_Timer1.h"
#include "Spectral_Pins.h"

volatile uint16_t ms_counter;
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/

void Timer_Initialize (void)
{
    /*
     When the timer is enabled, it increments by one on every rising edge of the input clock and generates 
     an interrupt on a period match.
     
     Fcy = 40MHz.
     
     The PRn register resets one timer clock period only after the TnIF bit is set.
     The TnIF bit is set one instruction cycle after a period match.
     */
    
    //==== Timer 2======
    T2CONbits.TON = 0;      // Disable Timer
    T2CONbits.TCS = 0;      // Select internal instruction cycle clock
    T2CONbits.TGATE = 0;    // Disable Gated Timer mode
    T2CONbits.T32 = 0 ;     // Using 16bit mode
    T2CONbits.TCKPS = 0b11; // Select 1:256 Prescaler
    TMR2 = 0x00;            // Clear timer register
    PR2 = 156;//1ms period. // Load the period value into 16-bit Period Register. 40MIPS/(156 * 256) = 1000Hz.
    IFS0bits.T2IF = 0;      // Clear Timer1 Interrupt Flag     

    T2CONbits.TON = 1; // Start Timer
}

void delay_for_ms(uint16_t ms)
{
ms_counter = ms;
while(ms_counter != 0){};
}
