﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Spectral1.PRESENTATION
{
    public partial class PL_WaveForm : Form
    {
        Double[] _waveform;
        public PL_WaveForm(Double[] waveform)
        {
            _waveform = waveform;
            InitializeComponent();
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void PL_WaveForm_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = panel1.CreateGraphics();
            const float border = 5;
            float graph_height = panel1.Height - border;
            float graph_width = panel1.Width - border;
            float x_step = ((graph_width - border - border) / 628);
            float[] dashValues = { 2, 5, 2, 5 };
            Pen white_pen = new Pen(Color.White);
            white_pen.DashPattern = dashValues;
            Pen green_pen = new Pen(Color.LightGreen,2);

            g.DrawLine(white_pen, border, graph_height/2, graph_width - border, graph_height / 2);
            g.DrawLine(white_pen, border, border, border, graph_height );
            g.DrawLine(white_pen, graph_width - border, border, graph_width - border, graph_height);
            g.DrawLine(white_pen, graph_width/2, border, graph_width/2, graph_height);

            float x1;
            float y1;
            float x2;
            float y2;
            float max_amplitude = 0;
            for (int a_index = 0; a_index < 628; a_index++)
            {
                if ((float)(_waveform[a_index]) > max_amplitude) { max_amplitude = (float)(_waveform[a_index]); };
            }

            float scaling;
            if (max_amplitude == 0)
            {
                scaling = 1;
            }
            else
            {
            scaling= ((graph_height - border - border)/2) / max_amplitude;  
            }
                
            for (int a_index = 1; a_index < 628; a_index++)
            {
                x1 = border + (x_step * (a_index - 1));
                x2 = x1 + x_step;
                y1 = border + (graph_height/2) - ((float)(_waveform[a_index - 1]) * scaling);
                y2 = border + (graph_height / 2) - ((float)(_waveform[a_index]) * scaling);
                g.DrawLine(green_pen, x1,y1,x2,y2);
            }
        }
    }
}
