﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_Performance : UserControl
    {
        #region "============================ DECLARATIONS =========================================="
        private PL_Main _plm;
        #endregion

        #region "============================ EVENTS =========================================="

        private void pL_UC_AddDeleteOrderDGV_Performance_RowAdded(object sender, EventArgs e)
        {
            performanceRow R = (performanceRow)(sender);
            Int32 patch_set_id = R.patch_set_id;
            Int32 performance_id = R.performance_id;
            for (Int32 c = 0; c < max_midi_channels; c++)
            {
                _plm.BL.DA.CGS.Table_performance_channel.DeleteRow(patch_set_id, performance_id,c);//Ensure any existing row is deleted
                _plm.BL.DA.CGS.Table_performance_channel.AddRow3(patch_set_id,performance_id, c, 0, 100, min_note_number, max_note_number);
            }

            for (Int32 p = 0; p < max_tone_processors; p++)
            {
                _plm.BL.DA.CGS.Table_performance_processor.DeleteRow(patch_set_id, performance_id, p);//Ensure any existing row is deleted
                _plm.BL.DA.CGS.Table_performance_processor.AddRow3(patch_set_id,performance_id, p,0);
            }
        }

        private void pL_UC_AddDeleteDGV_Performance_EVENT_DGVSelectionChanged(object sender, EventArgs e)
        {
            InitialiseForCurrentPerformance();
            if (_plm.BL.DA.DAUSBComms.IsConnected() && !_plm.BL.DA.DASystem.flag_saving_or_loading && !_plm.BL.DA.DASystem.flag_suppress_patch_set_events)
            {
                _plm.BL.DA.DAUSBComms.send_to_module_stop_play_mode();
                _plm.BL.DA.DAUSBComms.send_to_module_select_performance(_plm.BL.DA.CGS.Table_performance.CurrentRow.performance_id);
                _plm.BL.DA.DAUSBComms.send_to_module_start_play_mode();
            }
        }

        private void pL_UC_AddDeleteDGV_Performance_EVENT_RowDeleted(object sender, EventArgs e)
        {
            RefreshUI();

            //DONT NEED THIS BECAUSE AUTOMATICALLY TAKEN CARE OF IN CLASS LIBRARY
            //Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;
            //Int32 performance_id = _plm.BL.DA.CGS.Table_performance.CurrentRow.performance_id;

            ////for (Int32 c = 0; c < max_midi_channels; c++)
            ////{
            ////    _plm.BL.DA.CGS.Table_performance_channel.GetRow(performance_id, c).Delete();
            ////}

            ////for (Int32 p = 0; p < max_tone_processors; p++)
            ////{
            ////    _plm.BL.DA.CGS.Table_performance_processor.GetRow(p, performance_id).Delete();
            ////}
            //_plm.Cursor = entry_cursor;
        }

        #endregion

        #region "============================ METHODS =========================================="
        public PL_UC_Performance()
        {
            InitializeComponent();
        }

        public void Initialise(PL_Main plm)
        {
            _plm = plm;
            _plm.BL.DA.CGS.Table_performance.Event_NewRowAdded += pL_UC_AddDeleteOrderDGV_Performance_RowAdded;

            _plm.BL.BLDGV.InitialisePerformanceDGV(ref pL_UC_AddDeleteDGV_Performance);
            _plm.BL.BLDGV.InitialisePerformanceChannelDGV(ref pL_UC_AddDeleteDGV_PerformanceChannel);
            _plm.BL.BLDGV.InitialisePerformanceProcessorDGV(ref pL_UC_AddDeleteDGV_PerformanceProcessors);

            RefreshUI();
        }

        public void InitialiseForCurrentPerformance()
        {
            if ((_plm.BL.DA.CGS.Table_performance.CurrentRow.RowIsEmpty == true)|| (_plm.BL.DA.CGS.Table_patch_set.CurrentRow.RowIsEmpty == true)) { return; }

            Int32 performance_id = _plm.BL.DA.CGS.Table_performance.CurrentRow.performance_id;
            Int32 patch_set_id = _plm.BL.DA.CGS.Table_patch_set.CurrentRow.patch_set_id;
            _plm.BL.DA.CGS.Table_performance_channel.SetDefaultViewFilter("performance_id = " + performance_id.ToString() + " AND patch_set_id = " + patch_set_id.ToString() );
            _plm.BL.DA.CGS.Table_performance_processor.SetDefaultViewFilter("performance_id = " + performance_id.ToString() + " AND patch_set_id = " + patch_set_id.ToString());
        }

        public void RefreshUI()
        {
            this.Visible = ((_plm.BL.DA.CGS.Table_patch.RowCount() > 0) && (_plm.BL.DA.CGS.Table_patch_set.CurrentRow.RowIsEmpty == false));

            if ((_plm.BL.DA.CGS.Table_performance.RowCount() > 0) && (_plm.BL.DA.CGS.Table_patch_set.CurrentRow.RowIsEmpty == false)) 
            {
                pL_UC_AddDeleteDGV_PerformanceChannel.Visible = true;
                pL_UC_AddDeleteDGV_PerformanceProcessors.Visible = true;
            }
            else
            {
                pL_UC_AddDeleteDGV_PerformanceChannel.Visible = false;
                pL_UC_AddDeleteDGV_PerformanceProcessors.Visible = false;
            }
        }


        #endregion


    }
}
