﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static Spectral1_VBClassLibrary.DataSet_Spectral_System;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using Spectral1.PARSER;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_Patch_General : UserControl
    {
        #region "=========================== DECLARATIONS ==============================================="
        private PL_Main _plm;
        bool flag_loading_patch_general_fields = false;
        #endregion

        #region "=========================== EVENTS ==============================================="
        private void Table_lfo_envelope_config_row_changed(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_saving_or_loading == true) { return; }

            _plm.BL.DA.DASpectral.data_changed.patch.set_lfo_envelope_config(_plm.BL.DA.CGS.Table_lfo_envelope_config.CurrentRow.lfo_envelope_config_id,true);
            _plm.SyncVisible();

            int patch_id = _plm.BL.BLPatch.current_patch.patch_id;
            int lfo_envelope_config_id = _plm.BL.BLPatch.current_patch.current_lfo_envelope_config_id;
            string LFOType = _plm.BL.BLPatch.current_patch.get_string_lfo_type(patch_id, lfo_envelope_config_id);
            string Enabled = _plm.BL.BLPatch.current_patch.get_string_lfo_enabled(patch_id, lfo_envelope_config_id);
            string WaveType =_plm.BL.BLPatch.current_patch.get_string_lfo_wave_type(patch_id, lfo_envelope_config_id);
            string Frequency = _plm.BL.BLPatch.current_patch.get_string_lfo_frequency(patch_id, lfo_envelope_config_id);
            string FrequencyCC = _plm.BL.BLPatch.current_patch.get_string_lfo_freq_cc_source(patch_id, lfo_envelope_config_id);
            string DepthCC = _plm.BL.BLPatch.current_patch.get_string_lfo_depth_cc_source(patch_id, lfo_envelope_config_id);
            _plm.spectral_parser.add_code_p_g_SetLFO(LFOType,Enabled, WaveType, Frequency, FrequencyCC, DepthCC);
        }

        private void Table_envelope_gain_control_row_changed(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_saving_or_loading == true) { return; }

            int patch_id = _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id;
            int envelope_control_id = _plm.BL.DA.CGS.Table_envelope_control.CurrentRow.envelope_control_id;

            _plm.BL.DA.DASpectral.data_changed.patch.set_envelope_control_config(_plm.BL.DA.CGS.Table_envelope_control.CurrentRow.envelope_control_id,true);
            _plm.SyncVisible();

            string EnvType = _plm.BL.BLPatch.current_patch.get_string_envelope_control_envelope_type(patch_id,envelope_control_id);
            string GainCC = _plm.BL.BLPatch.current_patch.get_string_envelope_control_gain_cc_source(patch_id, envelope_control_id);
            string InitialLevel = _plm.BL.BLPatch.current_patch.get_string_envelope_control_initial_level(patch_id, envelope_control_id);

            _plm.spectral_parser.add_code_p_g_SetEnvelopeGainControllero(EnvType, InitialLevel, GainCC);
        }


        private void PatchGeneralDataChanged(object sender, EventArgs e)
        {
            if((_plm.BL.DA.DASystem.flag_saving_or_loading == true)||(flag_loading_patch_general_fields == true)) { return; }

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            UpdatePatchFromGeneralFields();
            _plm.BL.DA.DASpectral.data_changed.patch.set_misc(true);
            _plm.Cursor = entry_cursor;
        }

        private void PatchGeneralDataChangedWF(object sender, EventArgs e)
        {
            if ((_plm.BL.DA.DASystem.flag_saving_or_loading == true) || (flag_loading_patch_general_fields == true)) { return; }

            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor;

            UpdatePatchFromGeneralFields();
            _plm.BL.DA.DASpectral.data_changed.patch.set_misc(true);
            _plm.BL.DA.DASpectral.data_changed.waveset.set_all(true);//NOTE: THIS IS EXTRA
            _plm.BL.DA.DASpectral.data_changed.filter.set_all(true);//NOTE: THIS IS EXTRA
            _plm.Cursor = entry_cursor;
        }

        #endregion

        #region "=========================== METHODS ==============================================="

        public PL_UC_Patch_General()
        {
            InitializeComponent();
        }

        public void Initialise(ref PL_Main plm)
        {
            _plm = plm;

            //Initialise Combos
            comboBox_PatchType.DataSource = _plm.BL.DA.CGSS.Table_patch_type.Table_BindingSource;
            comboBox_PatchType.DisplayMember = "patch_type_name";
            comboBox_PatchType.ValueMember = "patch_type_id";

            comboBox_WaveformSet.DataSource =_plm.BL.DA.CGS.Table_waveform_set.AlternativeView;
            comboBox_WaveformSet.DisplayMember = "waveform_set_name";
            comboBox_WaveformSet.ValueMember = "waveform_set_id";

            comboBox_PatchCategory.DataSource =_plm.BL.DA.CGSS.Table_patch_category.Table_BindingSource;
            comboBox_PatchCategory.DisplayMember = "patch_category_name";
            comboBox_PatchCategory.ValueMember = "patch_category_id";

            comboBox_BodyFilter.DataSource =_plm.BL.DA.CGS.Table_body_resonance_filter.AlternativeView;
            comboBox_BodyFilter.DisplayMember = "body_resonance_filter_name";
            comboBox_BodyFilter.ValueMember = "body_resonance_filter_id";

            comboBox_key_sclaing_split.DataSource = _plm.BL.DA.CGSS.Table_midi_note.Table_BindingSource;
            comboBox_key_sclaing_split.DisplayMember = "midi_note_name";
            comboBox_key_sclaing_split.ValueMember = "midi_note_id";
            comboBox_key_sclaing_split.SelectedValue = c4_note_number;

            comboBox_detuning_mode.DataSource = _plm.BL.DA.CGSS.Table_detuning_mode.Table_BindingSource;
            comboBox_detuning_mode.DisplayMember = "detuning_mode_name";
            comboBox_detuning_mode.ValueMember = "detuning_mode_id";
            comboBox_detuning_mode.SelectedValue = detune_modes.dm_cents;

            comboBox_active_oscillators.Items.Add("1");
            comboBox_active_oscillators.Items.Add("2");
            comboBox_active_oscillators.SelectedIndex = 0;

            numericUpDown_regular_detuning.Maximum = max_regular_and_random_detuning;
            numericUpDown_random_detuning.Maximum = max_regular_and_random_detuning;
            numericUpDown_layer1_detune.Maximum = max_oscillator_detuning;
            numericUpDown_layer2_detune.Maximum = max_oscillator_detuning;
            //LFOs
            _plm.BL.BLDGV.InitialiseLFOsDGV(ref pL_UC_AddDeleteDGV_LFOs);
           _plm.BL.DA.CGS.Table_lfo_envelope_config.DT.RowChanged += Table_lfo_envelope_config_row_changed;

            //Envelope gain control
            _plm.BL.BLDGV.InitialiseEnvelopeGainControlDGV(ref pL_UC_AddDeleteDGV_envelope_gain);
            _plm.BL.DA.CGS.Table_envelope_control.DT.RowChanged += Table_envelope_gain_control_row_changed;
        }

        public void LoadPatchGeneralFields()
        {
            if (_plm.BL.DA.CGS.Table_patch.CurrentRow.RowIsEmpty == true) { return; }
            if (comboBox_WaveformSet.SelectedValue == null) { return; }

            flag_loading_patch_general_fields = true;

            //Misc
            if((int)(comboBox_PatchCategory.SelectedValue) != _plm.BL.BLPatch.current_patch.patch_category_id) comboBox_PatchCategory.SelectedValue = _plm.BL.BLPatch.current_patch.patch_category_id;
            if((int)(comboBox_PatchType.SelectedValue) != _plm.BL.BLPatch.current_patch.patch_type_id) comboBox_PatchType.SelectedValue = _plm.BL.BLPatch.current_patch.patch_type_id;
            if ((int)(comboBox_WaveformSet.SelectedValue) != _plm.BL.BLPatch.current_patch.waveform_set_id)comboBox_WaveformSet.SelectedValue =_plm.BL.BLPatch.current_patch.waveform_set_id;
            if((int)(comboBox_BodyFilter.SelectedValue) != _plm.BL.BLPatch.current_patch.body_resonance_filter_id) comboBox_BodyFilter.SelectedValue = _plm.BL.BLPatch.current_patch.body_resonance_filter_id;
            if((int)(comboBox_key_sclaing_split.SelectedValue) != _plm.BL.BLPatch.current_patch.key_scale_split_note_id)comboBox_key_sclaing_split.SelectedValue = _plm.BL.BLPatch.current_patch.key_scale_split_note_id;
            if((int)(comboBox_detuning_mode.SelectedValue) != _plm.BL.BLPatch.current_patch.detuning_mode_id) comboBox_detuning_mode.SelectedValue = _plm.BL.BLPatch.current_patch.detuning_mode_id;

            if (_plm.BL.BLPatch.current_patch.sustain_enabled == 1)
            {
                if (checkBox_sustain_enabled.Checked == false) checkBox_sustain_enabled.Checked = true;
            }
            else
            {
                if (checkBox_sustain_enabled.Checked == true) checkBox_sustain_enabled.Checked = false;
            }

            if (_plm.BL.BLPatch.current_patch.portamento_enabled == 1)
            {
                if (checkBox_portamento_enabled.Checked == false) checkBox_portamento_enabled.Checked = true;
            }
            else
            {
                if (checkBox_portamento_enabled.Checked == true) checkBox_portamento_enabled.Checked = false;
            }


            if(numericUpDown_portamento_rate.Value != (decimal)(_plm.BL.BLPatch.current_patch.portamento_rate)) numericUpDown_portamento_rate.Value = (decimal)(_plm.BL.BLPatch.current_patch.portamento_rate);

            //Analog feel
            if (numericUpDown_regular_detuning.Value != (decimal)(_plm.BL.BLPatch.current_patch.degree_of_regular_detuning)) numericUpDown_regular_detuning.Value = (decimal)(_plm.BL.BLPatch.current_patch.degree_of_regular_detuning);
            if(numericUpDown_random_detuning.Value != (decimal)(_plm.BL.BLPatch.current_patch.degree_of_random_detuning)) numericUpDown_random_detuning.Value = (decimal)(_plm.BL.BLPatch.current_patch.degree_of_random_detuning);
            if(numericUpDown_random_phase_shift.Value != (decimal)(_plm.BL.BLPatch.current_patch.degree_of_random_phase)) numericUpDown_random_phase_shift.Value = (decimal)(_plm.BL.BLPatch.current_patch.degree_of_random_phase);

            //Oscillator layers
            if(comboBox_active_oscillators.Text != _plm.BL.BLPatch.current_patch.active_layers.ToString()) comboBox_active_oscillators.Text = _plm.BL.BLPatch.current_patch.active_layers.ToString();
            if(numericUpDown_layer1_detune.Value != (decimal)(_plm.BL.BLPatch.current_patch.layer0_st_inc_q11_5_detune)) numericUpDown_layer1_detune.Value = (decimal)(_plm.BL.BLPatch.current_patch.layer0_st_inc_q11_5_detune);
            if(numericUpDown_layer2_detune.Value != (decimal)(_plm.BL.BLPatch.current_patch.layer1_st_inc_q11_5_detune)) numericUpDown_layer2_detune.Value = (decimal)(_plm.BL.BLPatch.current_patch.layer1_st_inc_q11_5_detune);

            //Patch gain
            if(numericUpDown_patch_gain.Value != (decimal)(_plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune)) numericUpDown_patch_gain.Value = (decimal)(_plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune);

            flag_loading_patch_general_fields = false;
        }

        public void UpdatePatchFromGeneralFields()
        {
            if ((_plm.BL.DA.CGS.Table_patch.CurrentRow.RowIsEmpty == true) || (_plm.BL.DA.DASystem.flag_suppress_patch_events == true) || (flag_loading_patch_general_fields == true)) { return; }

            Int32 p = _plm.BL.DA.CGS.Table_patch.CurrentRow.patch_id;
            //Misc
            if (_plm.BL.BLPatch.current_patch.patch_category_id != Convert.ToInt32(comboBox_PatchCategory.SelectedValue))
            { _plm.BL.BLPatch.current_patch.patch_category_id = Convert.ToInt32(comboBox_PatchCategory.SelectedValue); }
            if (_plm.BL.BLPatch.current_patch.patch_type_id != Convert.ToInt32(comboBox_PatchType.SelectedValue))
            { _plm.BL.BLPatch.current_patch.patch_type_id = Convert.ToInt32(comboBox_PatchType.SelectedValue); }

            if (_plm.BL.BLPatch.current_patch.waveform_set_id != Convert.ToInt32(comboBox_WaveformSet.SelectedValue))
            {
                _plm.BL.BLPatch.current_patch.waveform_set_id = Convert.ToInt32(comboBox_WaveformSet.SelectedValue);
                _plm.BL.BLPatch.current_patch.waveform_set_id = Convert.ToInt32(comboBox_WaveformSet.SelectedValue);
                _plm.remote_SetDGVWaveSetToPatchesWaveSet();
                double level_scaling = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.CalcLevelScaling();

                _plm.BL.DA.DASpectral.data_changed.waveset.set_all(true);//Force harmonics to update, because the gain scales the harmonics
                //_plm.BL.DA.DAUSBComms.SendAllWaveformHarmonics(_plm.BL.BLPatch.current_patch.waveform_set_id, _plm.BL.BLPatch.current_patch.patch_id, level_scaling);
                _plm.remote_SetDGVFilterToPatchFilter();
            }

            if (_plm.BL.BLPatch.current_patch.body_resonance_filter_id != Convert.ToInt32(comboBox_BodyFilter.SelectedValue))
            { 
                _plm.BL.BLPatch.current_patch.body_resonance_filter_id = Convert.ToInt32(comboBox_BodyFilter.SelectedValue);
                _plm.BL.BLPatch.current_patch.body_resonance_filter_id = Convert.ToInt32(comboBox_BodyFilter.SelectedValue);
                _plm.remote_SetDGVFilterToPatchFilter();
            }

            if (_plm.BL.BLPatch.current_patch.key_scale_split_note_id != Convert.ToInt32(comboBox_key_sclaing_split.SelectedValue))
            {
                _plm.BL.BLPatch.current_patch.key_scale_split_note_id = Convert.ToInt32(comboBox_key_sclaing_split.SelectedValue);
                _plm.spectral_parser.add_code_p_g_SetScalingSplit(comboBox_key_sclaing_split.Text);
            }

            if (_plm.BL.BLPatch.current_patch.detuning_mode_id != Convert.ToInt32(comboBox_detuning_mode.SelectedValue))
            {
                _plm.BL.BLPatch.current_patch.detuning_mode_id = Convert.ToInt32(comboBox_detuning_mode.SelectedValue);
                _plm.spectral_parser.add_code_p_g_SetDetuningMode(comboBox_detuning_mode.Text);
            }

            if (checkBox_sustain_enabled.Checked == true)
            {
                if (_plm.BL.BLPatch.current_patch.sustain_enabled != 1)
                { _plm.BL.BLPatch.current_patch.sustain_enabled = 1; }
            }
            else
            {
                if (_plm.BL.BLPatch.current_patch.sustain_enabled != 0)
                { _plm.BL.BLPatch.current_patch.sustain_enabled = 0; }
            }

            if (checkBox_portamento_enabled.Checked == true)
            {
                if (_plm.BL.BLPatch.current_patch.portamento_enabled != 1)
                {
                    _plm.BL.BLPatch.current_patch.portamento_enabled = 1;
                    _plm.spectral_parser.add_code_p_g_SetPortamento("True", numericUpDown_portamento_rate.Value.ToString());
                }
            }
            else
            {
                if (_plm.BL.BLPatch.current_patch.portamento_enabled != 0)
                {
                    _plm.BL.BLPatch.current_patch.portamento_enabled = 0;
                    _plm.spectral_parser.add_code_p_g_SetPortamento("False", numericUpDown_portamento_rate.Value.ToString());
                }
            }

            if (_plm.BL.BLPatch.current_patch.portamento_rate != (float)(numericUpDown_portamento_rate.Value))
            {
                _plm.BL.BLPatch.current_patch.portamento_rate = (float)(numericUpDown_portamento_rate.Value);
                _plm.spectral_parser.add_code_p_g_SetPortamento((_plm.BL.BLPatch.current_patch.portamento_enabled == 1).ToString(), numericUpDown_portamento_rate.Value.ToString());
            }

            //Analog feel
            if (_plm.BL.BLPatch.current_patch.degree_of_regular_detuning != (float)(numericUpDown_regular_detuning.Value))
            {
                _plm.BL.BLPatch.current_patch.degree_of_regular_detuning = (float)(numericUpDown_regular_detuning.Value);
                _plm.spectral_parser.add_code_p_g_SetDetuning("Regular", numericUpDown_regular_detuning.Value.ToString());
            }

            if (_plm.BL.BLPatch.current_patch.degree_of_random_detuning != (float)(numericUpDown_random_detuning.Value))
            {
                _plm.BL.BLPatch.current_patch.degree_of_random_detuning = (float)(numericUpDown_random_detuning.Value);
                _plm.spectral_parser.add_code_p_g_SetDetuning("Random", numericUpDown_random_detuning.Value.ToString());
            }

            if (_plm.BL.BLPatch.current_patch.degree_of_random_phase != (float)(numericUpDown_random_phase_shift.Value))
            {
                _plm.BL.BLPatch.current_patch.degree_of_random_phase = (float)(numericUpDown_random_phase_shift.Value);
            }

            //Oscillator layers
            if (_plm.BL.BLPatch.current_patch.active_layers != Convert.ToInt32(comboBox_active_oscillators.Text))
            {
                _plm.BL.BLPatch.current_patch.active_layers = Convert.ToInt32(comboBox_active_oscillators.Text);
                _plm.spectral_parser.add_code_p_g_SetActiveOscillators(comboBox_active_oscillators.Text);
            }

            if (_plm.BL.BLPatch.current_patch.layer0_st_inc_q11_5_detune != (float)(numericUpDown_layer1_detune.Value))
            {
                _plm.BL.BLPatch.current_patch.layer0_st_inc_q11_5_detune = (float)(numericUpDown_layer1_detune.Value);
                _plm.spectral_parser.add_code_p_g_SetOscillatorDetuning("0", numericUpDown_layer1_detune.Value.ToString());
            }

            if (_plm.BL.BLPatch.current_patch.layer1_st_inc_q11_5_detune != (float)(numericUpDown_layer2_detune.Value))
            {
                _plm.BL.BLPatch.current_patch.layer1_st_inc_q11_5_detune = (float)(numericUpDown_layer2_detune.Value);
                _plm.spectral_parser.add_code_p_g_SetOscillatorDetuning("1", numericUpDown_layer2_detune.Value.ToString());
            }

            //Patch gain
            if(_plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune != (float)(numericUpDown_patch_gain.Value))
            {
                _plm.BL.DA.DASpectral.data_changed.waveset.set_all(true);//Force harmonics to update, because the gain scales the harmonics
                _plm.BL.BLPatch.current_patch.layer2_st_inc_q11_5_detune = (float)(numericUpDown_patch_gain.Value);
                _plm.spectral_parser.add_code_p_g_SetPatchGain(numericUpDown_patch_gain.Value.ToString());
            }
        }
        #endregion

 
    }
}
