﻿using Spectral1.DATA_ACCESS;
using System;
using System.Windows.Forms;

namespace Spectral1.PRESENTATION
{
    public partial class PL_SetWaveformRange : Form
    {
        c_from_to_range _r;
        PL_Main _plm;

        public PL_SetWaveformRange(ref PL_Main plm, ref c_from_to_range r,string context)
        {
            InitializeComponent();
            _plm = plm;
            _r = r;
            this.Text = context;

            BindingSource wfbs = new BindingSource(); wfbs.DataSource = plm.BL.DA.CGSS.Table_waveform.Table_BindingSource;
            BindingSource wtbs = new BindingSource(); wtbs.DataSource = plm.BL.DA.CGSS.Table_waveform.Table_BindingSource;


            comboBox_NSF.DisplayMember = "waveform_name";
            comboBox_NSF.ValueMember = "waveform_id";
            comboBox_NSF.DataSource = wfbs;
            comboBox_NSF.SelectedValue = 0;

            comboBox_NST.DisplayMember = "waveform_name";
            comboBox_NST.ValueMember = "waveform_id";
            comboBox_NST.DataSource = wtbs;
            comboBox_NST.SelectedValue = DA_Spectral.max_waveforms - 1;
        }

        private void button_OK_Click_1(object sender, EventArgs e)
        {
            _r.from_id = Convert.ToInt32(comboBox_NSF.SelectedValue);
            _r.to_id = Convert.ToInt32(comboBox_NST.SelectedValue);

            if (_r.to_id <= _r.from_id)
            {
                _plm.PLInfo.DisplayExclamation("The 'From' value must be less than the 'To' value and separated by at least one !");
            }
            else
            {
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }

        private void button_Cancel_Click_1(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }
    }
}
