﻿using Spectral1.DATA_ACCESS;
using Spectral1.Properties;
using System;
using System.Windows.Forms;
using static Spectral1.DATA_ACCESS.DA_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_SetNoteSectorRange : Form
    {
        c_from_to_range _r;
        PL_Main _plm;

        public PL_SetNoteSectorRange(ref PL_Main plm,ref c_from_to_range r, note_sector_range_contexts context)
        {
            InitializeComponent();
            _plm = plm;
            _r = r;

            bool select_waveform =false;

            switch (context)
            {
                case note_sector_range_contexts.MorphWholeSector:
                    this.Text = "Morph all harmonics across note sectors";
                    pictureBox1.Image = Resources.Morph_WaveSet_AcrossNoteSectors;
                    break;
                case note_sector_range_contexts.MorphCurrentIntensityLayerBlocks:
                    this.Text = "Morph current intensity layer waveform blocks across note sectors";
                    pictureBox1.Image = Resources.Morph_CurrentILBlocksAcrossNoteSectors;
                    break;
                case note_sector_range_contexts.MorphCurrentIntensityLayerWaveforms:
                    this.Text = "Morph current intensity layer waveforms across note sectors";
                    select_waveform = true;
                    pictureBox1.Image = Resources.Morph_CurrentILWaveformsAcrossNoteSectors;
                    break;
                case note_sector_range_contexts.CopyCurrentBlock:
                    this.Text = "Copy current waveform block across note sectors";
                    select_waveform = false;
                    pictureBox1.Image = Resources.Copy_CurrentILBlockAcrossNoteSectors;
                    break;
                case note_sector_range_contexts.CopyCurrentWaveform:
                    this.Text = "Copy current waveform across note sectors";
                    select_waveform = false;
                    pictureBox1.Image = Resources.Copy_CurrentILWaveformAcrossNoteSectors;
                    break;
            }

            BindingSource nsfbs = new BindingSource(); nsfbs.DataSource = plm.BL.DA.CGSS.Table_note_sector.Table_BindingSource;
            BindingSource nstbs = new BindingSource(); nstbs.DataSource = plm.BL.DA.CGSS.Table_note_sector.Table_BindingSource;
            BindingSource wtbs = new BindingSource(); wtbs.DataSource = plm.BL.DA.CGSS.Table_waveform.Table_BindingSource;

            comboBox_NSF.DisplayMember = "note_sector_name";
            comboBox_NSF.ValueMember = "note_sector_id";
            comboBox_NSF.DataSource = nsfbs;
            comboBox_NSF.SelectedValue = 0;

            comboBox_NST.DisplayMember = "note_sector_name";
            comboBox_NST.ValueMember = "note_sector_id";
            comboBox_NST.DataSource = nstbs;
            comboBox_NST.SelectedValue = max_note_sectors - 1;

            comboBox_W.DisplayMember = "waveform_name";
            comboBox_W.ValueMember = "waveform_id";
            comboBox_W.DataSource = wtbs;
            comboBox_W.SelectedValue = DA_Spectral.max_waveforms - 1;

            comboBox_W.Visible = select_waveform;
            label_waveform.Visible = select_waveform;
        }

        private void button_OK_Click(object sender, EventArgs e)
        {

            _r.from_id = Convert.ToInt32(comboBox_NSF.SelectedValue);
            _r.to_id = Convert.ToInt32(comboBox_NST.SelectedValue);
            _r.waveform_id = Convert.ToInt32(comboBox_W.SelectedValue);

            if (_r.to_id <=_r.from_id )
            {
                _plm.PLInfo.DisplayExclamation("The 'From' value must be less than the 'To' value and separated by at least one !");
            }
            else
            {
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }

        private void button_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

    }
}
