﻿using Spectral1.DATA_ACCESS;
using System;
using System.Windows.Forms;

namespace Spectral1.PRESENTATION
{
    public partial class PL_SelectWaveformBlock : Form
    {
        PL_Main _plm;
        c_nsil_pair _nsil;

        public PL_SelectWaveformBlock(ref PL_Main plm,ref c_nsil_pair nsil)
        {
            InitializeComponent();
            _plm = plm;
            _nsil = nsil;

            BindingSource ilbs = new BindingSource(); ilbs.DataSource = plm.BL.DA.CGSS.Table_intensity_layer.Table_BindingSource;
            BindingSource nsbs = new BindingSource(); nsbs.DataSource = plm.BL.DA.CGSS.Table_note_sector.Table_BindingSource;

            comboBox_NS.DisplayMember = "note_sector_name";
            comboBox_NS.ValueMember = "note_sector_id";
            comboBox_NS.DataSource = nsbs;
            comboBox_NS.SelectedValue = 0;

            comboBox_IL.DisplayMember = "intensity_layer_name";
            comboBox_IL.ValueMember = "intensity_layer_id";
            comboBox_IL.DataSource = ilbs;
            comboBox_IL.SelectedValue = 0;
        }

        private void button_OK_Click(object sender, EventArgs e)
        {
            _nsil.note_sector = Convert.ToInt32(comboBox_NS.SelectedValue);
            _nsil.intensity_layer = Convert.ToInt32(comboBox_IL.SelectedValue);

            if ((_nsil.note_sector == _plm.BL.BLWaveSet.current_waveform_set.current_note_sector_id) && (_nsil.intensity_layer == _plm.BL.BLWaveSet.current_waveform_set.current_intensity_layer_id))
            {
                _plm.PLInfo.DisplayExclamation("Can't select current waveform block !");
            }
            else
            {
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }

        private void button_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }
    }
}
