﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;
using Spectral1.DATA_ACCESS;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.BUSINESS_LOGIC.BL_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_Module_Filter_Visualiser : Form
    {
        PL_Main _plm;
        public PL_Module_Filter_Visualiser(ref PL_Main plm)
        {
            InitializeComponent();
            _plm = plm;
            initialise_graph();
        }

        private void initialise_graph()
        {
            const Int32 small_marker_size = 12;
            const Int32 big_marker_size = 14;

            Int32 body_resonance_filter_id = _plm.BL.BLFilter.current_body_resonance_filter.body_resonance_filter_id;//OLD 211221: _plm.BL.DA.CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id;

            double filter_scaling_factor = _plm.BL.BLFilter.current_body_resonance_filter.GetFilterScalingFactor(); //OLD 211221: 64 * _plm.BL.BLFilter.current_body_resonance_filter.GetFilterScalingFactor();
            _plm.BL.DA.DAUSBComms.RecalcFilterSlopes(body_resonance_filter_id, filter_scaling_factor);

            this.chart1.Series.Clear();
            this.chart1.Palette = ChartColorPalette.EarthTones;
            this.chart1.ChartAreas["ChartArea1"].AxisY.LabelAutoFitStyle = LabelAutoFitStyles.None;
            this.chart1.ChartAreas["ChartArea1"].AxisX.LabelStyle.Font = new System.Drawing.Font("Segoe UI", 7, System.Drawing.FontStyle.Regular);
            this.chart1.ChartAreas["ChartArea1"].Position.X = 0;
            this.chart1.ChartAreas["ChartArea1"].Position.Width = (float)98.9;
            this.chart1.ChartAreas["ChartArea1"].Position.Height = 90;
            this.chart1.ChartAreas["ChartArea1"].Position.Y = 2;
            this.chart1.Legends[0].Docking = Docking.Bottom;

            this.chart1.ChartAreas["ChartArea1"].AxisX.LabelStyle.Enabled = true;
            this.chart1.ChartAreas["ChartArea1"].AxisX.Interval = 1;
            this.chart1.ChartAreas["ChartArea1"].AxisX.IntervalAutoMode = IntervalAutoMode.FixedCount;
            this.chart1.ChartAreas["ChartArea1"].AxisX.IntervalOffset = 0;
            this.chart1.ChartAreas["ChartArea1"].AxisX.Minimum = 16;
            this.chart1.ChartAreas["ChartArea1"].AxisX.IsLogarithmic = true;
            this.chart1.ChartAreas["ChartArea1"].AxisX.LogarithmBase = 2;
            this.chart1.ChartAreas["ChartArea1"].AxisX.Maximum = calc_band_freq(DA_Spectral.max_body_resonance_filter_bands) ;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.Enabled = true;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.Interval = 1/8;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.LineColor = Color.Gainsboro;
            this.chart1.ChartAreas["ChartArea1"].AxisX.MinorGrid.LineDashStyle = ChartDashStyle.Solid;
            this.chart1.ChartAreas["ChartArea1"].AxisX.LabelStyle.Format = "N0";
            this.chart1.ChartAreas["ChartArea1"].AxisX.Title = "Hz (Logarithmic scale)";
            this.chart1.Legends[0].BackColor = Color.AntiqueWhite;

            this.chart1.ChartAreas["ChartArea1"].AxisY.Maximum = 65536;
            this.chart1.ChartAreas["ChartArea1"].AxisY.Minimum = 4096;

            this.chart1.ChartAreas["ChartArea1"].AxisY.MinorGrid.Enabled = true;
            this.chart1.ChartAreas["ChartArea1"].AxisY.Interval = 1;
            this.chart1.ChartAreas["ChartArea1"].AxisY.IsLogarithmic = true;
            this.chart1.ChartAreas["ChartArea1"].AxisY.LogarithmBase = 2;
            this.chart1.ChartAreas["ChartArea1"].AxisY.MinorGrid.Enabled = true;
            this.chart1.ChartAreas["ChartArea1"].AxisY.MinorGrid.Interval = 1/8;
            this.chart1.ChartAreas["ChartArea1"].AxisY.MinorGrid.LineColor = Color.Gainsboro;
            this.chart1.ChartAreas["ChartArea1"].AxisY.Title = "Gain (Binary Word, logarithmic scale)";

            string[] section_seriesArray = { "Ideal","Actual approximation (Red markers where >=5% gain error)" };

            //=========== Ideal ====================
            Series series_ideal = this.chart1.Series.Add(section_seriesArray[0]);
            series_ideal.YValueType = ChartValueType.Int32;
            series_ideal.IsValueShownAsLabel = false;
            series_ideal.SmartLabelStyle.Enabled = false;
            series_ideal.ChartType = SeriesChartType.Line;
            series_ideal.Color = Color.Blue;
            series_ideal.BorderWidth = 3;

            for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                Int32 f = calc_band_freq(b);
                Int32 level = _plm.BL.DA.CGS.Table_body_resonance_filter_band.GetRow(body_resonance_filter_id, b).level;
                series_ideal.Points.AddXY(f, level * filter_scaling_factor); 
            }

            //=============== Approximation ======================
            Series series_approximation = this.chart1.Series.Add(section_seriesArray[1]);
            series_approximation.YValueType = ChartValueType.Int32;
            series_approximation.MarkerStyle = MarkerStyle.Circle;
            series_approximation.MarkerSize = small_marker_size;//OLD 211221 8;
            series_approximation.MarkerColor = Color.Black;
            series_approximation.IsValueShownAsLabel = false;
            series_approximation.SmartLabelStyle.Enabled = false;
            series_approximation.ChartType = SeriesChartType.Line;
            series_approximation.Color = Color.Red;
            series_approximation.BorderWidth = 3;

            Int32 point_index = -1;
            label_error.Visible = false;

            for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                try
                {
                    Int32 f = calc_band_freq(b);
                    body_resonance_filter_bandRow brfbr = _plm.BL.DA.CGS.Table_body_resonance_filter_band.GetRow(body_resonance_filter_id, b);
                    Int32 level = brfbr.level;
                    Int32 slope = brfbr.slope;
                    series_approximation.Points.AddXY(f, level * filter_scaling_factor); point_index++;
                    series_approximation.Points[point_index].Label = b.ToString();
                    series_approximation.Points[point_index].MarkerSize = 1;
                    series_approximation.Points[point_index].MarkerColor = Color.Red;

                    if (b < (DA_Spectral.max_body_resonance_filter_bands - 1))
                    {
                        body_resonance_filter_bandRow brfbrplus1 = _plm.BL.DA.CGS.Table_body_resonance_filter_band.GetRow(body_resonance_filter_id, b + 1);
                        Int32 f1 = calc_band_freq(b + 1);
                        Int32 level_approx = (Int32)((level * filter_scaling_factor) + (((f1 - f) * slope) >> 5));
                        Int32 levelplus1 = (Int32)(brfbrplus1.level * filter_scaling_factor);
                        if (level_approx > 65535)
                        {
                            level_approx = 65535;
                            label_error.Visible = true;
                        }
                        else if (level_approx < 0)
                        {
                            level_approx = 0;
                            label_error.Visible = true;
                        }
                        series_approximation.Points.AddXY(f1, (Int32)level_approx); point_index++;
                        string output_db = (20 * Math.Log10((level * filter_scaling_factor) / 65536.0)).ToString("N1") + "dB";
                        series_approximation.Points[point_index - 1].ToolTip ="Band " + b.ToString() + ", " + f.ToString() + "Hz, Slope = " + (slope >> 5).ToString() + "+(" + (slope % 32).ToString() + "/32)  Attentuation = " + output_db + ", gain absolute = " + level_approx.ToString();
                        if (Math.Abs(1.0 - Math.Abs(1.0 * levelplus1/ level_approx)) < 0.05)
                        {
                            series_approximation.Points[point_index].MarkerSize = small_marker_size;
                            series_approximation.Points[point_index].MarkerColor =  Color.Black;
                        }
                        else
                        {
                            series_approximation.Points[point_index].MarkerSize = big_marker_size;
                            series_approximation.Points[point_index].MarkerColor = Color.Red;
                        }
                    }
                }
                catch (Exception e)
                {
                    _plm.PLInfo.DisplayExclamation("Filter Graph error : " + e.Message);
                }
  
            }

        }

        private void button_close_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
