﻿using Spectral1.DATA_ACCESS;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== METHODS - PRIVATE =========================="
        private void WaveformFunction()
        {
            DiscardToken(TokenType.CurrentWaveform);
            DiscardToken(TokenType.Dot);
            if (is_waveform_function_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.CopyTo:
                        wsd_wf_CopyTo(); break;
                    case TokenType.CopyToRange:
                        wsd_wf_CopyToRange(); break;
                    case TokenType.CopyAcrossNoteSectors:
                        wsd_wf_CopyAcrossNoteSectors(); break;
                    case TokenType.CopyAcrossIntensityLayers:
                        wsd_wf_CopyAcrossIntensityLayers(); break;
                    case TokenType.CopyAcrossAllDimensions:
                        wsd_wf_CopyAcrossAllDimensions(); break;
                    case TokenType.SetName:
                        wsd_wf_SetName(); break;

                    case TokenType.SetHarmonicLevels:
                        wsd_wf_SetHarmonicLevels(); break;
                    case TokenType.SetHarmonicLevelsFromCSV:
                        wsd_wf_SetHarmonicLevelsFromCSV(); break;
                    case TokenType.SetHarmonicLevelsFromLevelShapeType:
                        wsd_wf_SetHarmonicLevelsFromLevelShapeType(); break;
                    case TokenType.SetHarmonicLevelsFromInstrumentType:
                        wsd_wf_SetHarmonicLevelsFromInstrumentType(); break;
                    case TokenType.SetHarmonicLevelsFromWaveFormShape:
                        wsd_wf_SetHarmonicLevelsFromWaveShape(); break;
                    case TokenType.SetHarmonicLevel:
                        wsd_wf_SetHarmonicLevel(); break;
                    case TokenType.MorphHarmonicLevels:
                        wsd_wf_MorphHarmonicLevels(); break;
                    case TokenType.SetHarmonicPhases:
                        wsd_wf_SetHarmonicPhases(); break;
                    case TokenType.SetHarmonicPhasesFromCSV:
                        wsd_wf_SetHarmonicPhasesFromCSV(); break;
                    case TokenType.SetHarmonicPhasesFromPhaseShapeType:
                        wsd_wf_SetHarmonicPhasesFromPhaseShapeType(); break;
                    case TokenType.SetHarmonicPhasesFromInstrumentType:
                        wsd_wf_SetHarmonicPhasesFromInstrumentType(); break;
                    case TokenType.SetHarmonicPhasesFromWaveFormShape:
                        wsd_wf_SetHarmonicPhasesFromWaveShape(); break;
                    case TokenType.SetHarmonicPhase:
                        wsd_wf_SetHarmonicPhase(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedWaveformFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }


        private void wsd_wf_CopyTo()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyTo);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.WaveformTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_CopyTo, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_CopyToRange()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyToRange);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.WaveformFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.WaveformTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_CopyToRange, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_CopyAcrossNoteSectors()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyAcrossNoteSectors);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSectorFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.NoteSectorTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_CopyAcrossNoteSectors, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_CopyAcrossIntensityLayers()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyAcrossIntensityLayers);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayerFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.IntensityLayerTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_CopyAcrossIntensityLayers, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_CopyAcrossAllDimensions()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyAcrossAllDimensions);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_CopyAcrossAllDimensions, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetName()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetName);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.WaveformName);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormNameValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetWaveformName, p, _lookaheadFirst.start_position);
        }

        //=============================================

        private void wsd_wf_SetHarmonicLevels()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicLevels);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Level);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicLevelValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicLevel, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicLevelsFromCSV()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicLevelsFromCSV);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.LevelCSV);
            DiscardToken(TokenType.Colon);
            for (int i = 0; i < DA_Spectral.max_harmonics; i++)
            {
                p.Add(GetHarmonicLevelValue(_lookaheadFirst));
                DiscardToken();
                if (i !=(DA_Spectral.max_harmonics-1))DiscardToken(TokenType.Comma);
            }

            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicLevelsFromCSV, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicLevelsFromLevelShapeType()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicLevelsFromLevelShapeType);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.HarmonicLevelShapeType);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicLevelShapeTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicLevelsFromHarmonicLevelShapeType, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicLevelsFromInstrumentType()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicLevelsFromInstrumentType);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.InstrumentType);
            DiscardToken(TokenType.Colon);
            p.Add(GetInstrumentTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicLevelsFromInstrumentType, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicLevelsFromWaveShape()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicLevelsFromWaveFormShape);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.WaveformShape);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormShapeTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicLevelsFromWaveShape, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicLevel()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicLevel);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.HarmonicID);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.Level);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicLevelValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicLevel, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_MorphHarmonicLevels()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphHarmonicLevels);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.HarmonicIDFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.HarmonicIDTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicIDValue(_lookaheadFirst));
            DiscardToken();
            //DiscardToken(TokenType.Comma);
            //DiscardToken(TokenType.MorphType);
            //DiscardToken(TokenType.Colon);
            //p.Add(GetMorphTypeValue(_lookaheadFirst));
            //DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_MorphHarmonicLevels, p, _lookaheadFirst.start_position);
        }

        //==============================================

        private void wsd_wf_SetHarmonicPhases()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicPhases);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Phase);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicPhaseValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicPhases, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicPhasesFromCSV()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicPhasesFromCSV);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.PhasesCSV);
            DiscardToken(TokenType.Colon);
            for (int i = 0; i < DA_Spectral.max_harmonics; i++)
            {
                p.Add(GetHarmonicPhaseValue(_lookaheadFirst));
                DiscardToken();
                if (i != (DA_Spectral.max_harmonics - 1)) DiscardToken(TokenType.Comma);
            }

            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicPhasesFromCSV, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicPhasesFromPhaseShapeType()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicPhasesFromPhaseShapeType);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.HarmonicPhaseShapeType);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicPhaseShapeTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicPhasesFromHarmonicPhaseShapeType, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicPhasesFromInstrumentType()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicPhasesFromInstrumentType);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.InstrumentType);
            DiscardToken(TokenType.Colon);
            p.Add(GetInstrumentTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicPhasesFromInstrumentType, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicPhasesFromWaveShape()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicPhasesFromWaveFormShape);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.WaveformShape);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormShapeTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicPhasesFromWaveShape, p, _lookaheadFirst.start_position);
        }

        private void wsd_wf_SetHarmonicPhase()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetHarmonicPhase);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.HarmonicID);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.Phase);
            DiscardToken(TokenType.Colon);
            p.Add(GetHarmonicPhaseValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentWaveform, functions.W_WF_SetHarmonicPhase, p, _lookaheadFirst.start_position);
        }
        #endregion

    }
}
