﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_lexer;
using static Spectral1.PARSER.PL_UC_SpectralParser;

namespace Spectral1.PARSER
{
    public class c_lexer_token_definition
    {

        private Regex _regex;
        private readonly TokenType _returnsToken;

        public c_lexer_token_definition(TokenType returnsToken, string regexPattern)
        {
            _regex = new Regex(regexPattern, RegexOptions.IgnoreCase);
            _returnsToken = returnsToken;
        }

        public c_lexer_token_match Match(string inputString)
        {
            var match = _regex.Match(inputString);
            if (match.Success)
            {
                string remainingText = string.Empty;
                if (match.Length != inputString.Length)
                    remainingText = inputString.Substring(match.Length);

                return new c_lexer_token_match()
                {
                    IsMatch = true,
                    RemainingText = remainingText,
                    TokenType = _returnsToken,
                    Value = match.Value
                };
            }
            else
            {
                return new c_lexer_token_match() { IsMatch = false };
            }

        }
    }
}
