/* 
 * File:   Spectral_Sounds.c
 * Author: Jeremy Leach
 */

#include <xc.h>
#include "Spectral_Sounds.h"
#include "Spectral_Pins.h"
#include "Spectral_Messaging.h" 

/******************************************************************************/
/***** Declarations ***********************************************************/
/******************************************************************************/
static const uint16_t band_freq_lookup[max_body_resonance_filter_bands]={16,20,25,32,40,51,64,81,102,128,161,203,256,323,406,512,645,813,1024,1290,1625,2048,2580,3251,4096,5161,6502,8192,10321,13004,16384,20643};

static const uint16_t bass_atten_lookup[400] = {0,3457,3613,3769,3924,4080,4236,4392,4548,4704,4860,5016,5172,5328,5484,5640,5796,5952,6108,6264,6420,6576,6732,6888,7044,7200,7356,7512,7668,7824,7980,8136,8292,8448,8604,8760,8916,9072,9228,9384,9540,9696,9852,10007,10163,10319,10475,10631,10787,10943,11099,11255,11411,11567,11723,11879,12035,12191,12347,12503,12659,12815,12971,13127,13283,13439,13595,13751,13907,14063,14219,14375,14531,14687,14843,14999,15155,15311,15467,15623,15779,15935,16091,16246,16402,16558,16714,16870,17026,17182,17338,17494,17650,17806,17962,18118,18274,18430,18586,18742,18898,19054,19210,19366,19522,19678,19834,19990,20146,20302,20458,20614,20770,20926,21082,21238,21394,21550,21706,21862,22018,22174,22330,22485,22641,22797,22953,23109,23265,23421,23577,23733,23889,24045,24201,24357,24513,24669,24825,24981,25137,25293,25449,25605,25761,25917,26073,26229,26385,26541,26697,26853,27009,27165,27321,27477,27633,27789,27945,28101,28257,28413,28568,28724,28880,29036,29192,29348,29504,29660,29816,29972,30128,30284,30440,30596,30752,30908,31064,31220,31376,31532,31688,31844,32000,32156,32312,32468,32624,32780,32936,33092,33248,33404,33560,33716,33872,34028,34184,34340,34496,34652,34807,34963,35119,35275,35431,35587,35743,35899,36055,36211,36367,36523,36679,36835,36991,37147,37303,37459,37615,37771,37927,38083,38239,38395,38551,38707,38863,39019,39175,39331,39487,39643,39799,39955,40111,40267,40423,40579,40735,40890,41046,41202,41358,41514,41670,41826,41982,42138,42294,42450,42606,42762,42918,43074,43230,43386,43542,43698,43854,44010,44166,44322,44478,44634,44790,44946,45102,45258,45414,45570,45726,45882,46038,46194,46350,46506,46662,46818,46974,47129,47285,47441,47597,47753,47909,48065,48221,48377,48533,48689,48845,49001,49157,49313,49469,49625,49781,49937,50093,50249,50405,50561,50717,50873,51029,51185,51341,51497,51653,51809,51965,52121,52277,52433,52589,52745,52901,53057,53212,53368,53524,53680,53836,53992,54148,54304,54460,54616,54772,54928,55084,55240,55396,55552,55708,55864,56020,56176,56332,56488,56644,56800,56956,57112,57268,57424,57580,57736,57892,58048,58204,58360,58516,58672,58828,58984,59140,59296,59451,59607,59763,59919,60075,60231,60387,60543,60699,60855,61011,61167,61323,61479,61635,61791,61947,62103,62259,62415,62571,62727,62883,63039,63195,63351,63507,63663,63819,63975,64131,64287,64443,64599,64755,64911,65067,65223,65379,65535};

static const int16_t SineLookup[wavetable_samples]={
0,	101,	201,	302,	402,	503,	603,	704,
804,	905,	1005,	1106,	1206,	1307,	1407,	1507,
1608,	1708,	1809,	1909,	2009,	2110,	2210,	2310,
2410,	2511,	2611,	2711,	2811,	2911,	3012,	3112,
3212,	3312,	3412,	3512,	3612,	3712,	3811,	3911,
4011,	4111,	4210,	4310,	4410,	4509,	4609,	4708,
4808,	4907,	5007,	5106,	5205,	5305,	5404,	5503,
5602,	5701,	5800,	5899,	5998,	6096,	6195,	6294,
6393,	6491,	6590,	6688,	6786,	6885,	6983,	7081,
7179,	7277,	7375,	7473,	7571,	7669,	7767,	7864,
7962,	8059,	8157,	8254,	8351,	8448,	8545,	8642,
8739,	8836,	8933,	9030,	9126,	9223,	9319,	9416,
9512,	9608,	9704,	9800,	9896,	9992,	10087,	10183,
10278,	10374,	10469,	10564,	10659,	10754,	10849,	10944,
11039,	11133,	11228,	11322,	11417,	11511,	11605,	11699,
11793,	11886,	11980,	12074,	12167,	12260,	12353,	12446,
12539,	12632,	12725,	12817,	12910,	13002,	13094,	13187,
13279,	13370,	13462,	13554,	13645,	13736,	13828,	13919,
14010,	14101,	14191,	14282,	14372,	14462,	14553,	14643,
14732,	14822,	14912,	15001,	15090,	15180,	15269,	15358,
15446,	15535,	15623,	15712,	15800,	15888,	15976,	16063,
16151,	16238,	16325,	16413,	16499,	16586,	16673,	16759,
16846,	16932,	17018,	17104,	17189,	17275,	17360,	17445,
17530,	17615,	17700,	17784,	17869,	17953,	18037,	18121,
18204,	18288,	18371,	18454,	18537,	18620,	18703,	18785,
18868,	18950,	19032,	19113,	19195,	19276,	19357,	19438,
19519,	19600,	19680,	19761,	19841,	19921,	20000,	20080,
20159,	20238,	20317,	20396,	20475,	20553,	20631,	20709,
20787,	20865,	20942,	21019,	21096,	21173,	21250,	21326,
21403,	21479,	21554,	21630,	21705,	21781,	21856,	21930,
22005,	22079,	22154,	22227,	22301,	22375,	22448,	22521,
22594,	22667,	22739,	22812,	22884,	22956,	23027,	23099,
23170,	23241,	23311,	23382,	23452,	23522,	23592,	23662,
23731,	23801,	23870,	23938,	24007,	24075,	24143,	24211,
24279,	24346,	24413,	24480,	24547,	24613,	24680,	24746,
24811,	24877,	24942,	25007,	25072,	25137,	25201,	25265,
25329,	25393,	25456,	25519,	25582,	25645,	25708,	25770,
25832,	25893,	25955,	26016,	26077,	26138,	26198,	26259,
26319,	26378,	26438,	26497,	26556,	26615,	26674,	26732,
26790,	26848,	26905,	26962,	27019,	27076,	27133,	27189,
27245,	27300,	27356,	27411,	27466,	27521,	27575,	27629,
27683,	27737,	27790,	27843,	27896,	27949,	28001,	28053,
28105,	28157,	28208,	28259,	28310,	28360,	28411,	28460,
28510,	28560,	28609,	28658,	28706,	28755,	28803,	28850,
28898,	28945,	28992,	29039,	29085,	29131,	29177,	29223,
29268,	29313,	29358,	29403,	29447,	29491,	29534,	29578,
29621,	29664,	29706,	29749,	29791,	29832,	29874,	29915,
29956,	29997,	30037,	30077,	30117,	30156,	30195,	30234,
30273,	30311,	30349,	30387,	30424,	30462,	30498,	30535,
30571,	30607,	30643,	30679,	30714,	30749,	30783,	30818,
30852,	30885,	30919,	30952,	30985,	31017,	31050,	31082,
31113,	31145,	31176,	31206,	31237,	31267,	31297,	31327,
31356,	31385,	31414,	31442,	31470,	31498,	31526,	31553,
31580,	31607,	31633,	31659,	31685,	31710,	31736,	31760,
31785,	31809,	31833,	31857,	31880,	31903,	31926,	31949,
31971,	31993,	32014,	32036,	32057,	32077,	32098,	32118,
32137,	32157,	32176,	32195,	32213,	32232,	32250,	32267,
32285,	32302,	32318,	32335,	32351,	32367,	32382,	32397,
32412,	32427,	32441,	32455,	32469,	32482,	32495,	32508,
32521,	32533,	32545,	32556,	32567,	32578,	32589,	32599,
32609,	32619,	32628,	32637,	32646,	32655,	32663,	32671,
32678,	32685,	32692,	32699,	32705,	32711,	32717,	32722,
32728,	32732,	32737,	32741,	32745,	32748,	32752,	32755,
32757,	32759,	32761,	32763,	32765,	32766,	32766,	32767,
32767,	32767,	32766,	32766,	32765,	32763,	32761,	32759,
32757,	32755,	32752,	32748,	32745,	32741,	32737,	32732,
32728,	32722,	32717,	32711,	32705,	32699,	32692,	32685,
32678,	32671,	32663,	32655,	32646,	32637,	32628,	32619,
32609,	32599,	32589,	32578,	32567,	32556,	32545,	32533,
32521,	32508,	32495,	32482,	32469,	32455,	32441,	32427,
32412,	32397,	32382,	32367,	32351,	32335,	32318,	32302,
32285,	32267,	32250,	32232,	32213,	32195,	32176,	32157,
32137,	32118,	32098,	32077,	32057,	32036,	32014,	31993,
31971,	31949,	31926,	31903,	31880,	31857,	31833,	31809,
31785,	31760,	31736,	31710,	31685,	31659,	31633,	31607,
31580,	31553,	31526,	31498,	31470,	31442,	31414,	31385,
31356,	31327,	31297,	31267,	31237,	31206,	31176,	31145,
31113,	31082,	31050,	31017,	30985,	30952,	30919,	30885,
30852,	30818,	30783,	30749,	30714,	30679,	30643,	30607,
30571,	30535,	30498,	30462,	30424,	30387,	30349,	30311,
30273,	30234,	30195,	30156,	30117,	30077,	30037,	29997,
29956,	29915,	29874,	29832,	29791,	29749,	29706,	29664,
29621,	29578,	29534,	29491,	29447,	29403,	29358,	29313,
29268,	29223,	29177,	29131,	29085,	29039,	28992,	28945,
28898,	28850,	28803,	28755,	28706,	28658,	28609,	28560,
28510,	28460,	28411,	28360,	28310,	28259,	28208,	28157,
28105,	28053,	28001,	27949,	27896,	27843,	27790,	27737,
27683,	27629,	27575,	27521,	27466,	27411,	27356,	27300,
27245,	27189,	27133,	27076,	27019,	26962,	26905,	26848,
26790,	26732,	26674,	26615,	26556,	26497,	26438,	26378,
26319,	26259,	26198,	26138,	26077,	26016,	25955,	25893,
25832,	25770,	25708,	25645,	25582,	25519,	25456,	25393,
25329,	25265,	25201,	25137,	25072,	25007,	24942,	24877,
24811,	24746,	24680,	24613,	24547,	24480,	24413,	24346,
24279,	24211,	24143,	24075,	24007,	23938,	23870,	23801,
23731,	23662,	23592,	23522,	23452,	23382,	23311,	23241,
23170,	23099,	23027,	22956,	22884,	22812,	22739,	22667,
22594,	22521,	22448,	22375,	22301,	22227,	22154,	22079,
22005,	21930,	21856,	21781,	21705,	21630,	21554,	21479,
21403,	21326,	21250,	21173,	21096,	21019,	20942,	20865,
20787,	20709,	20631,	20553,	20475,	20396,	20317,	20238,
20159,	20080,	20000,	19921,	19841,	19761,	19680,	19600,
19519,	19438,	19357,	19276,	19195,	19113,	19032,	18950,
18868,	18785,	18703,	18620,	18537,	18454,	18371,	18288,
18204,	18121,	18037,	17953,	17869,	17784,	17700,	17615,
17530,	17445,	17360,	17275,	17189,	17104,	17018,	16932,
16846,	16759,	16673,	16586,	16499,	16413,	16325,	16238,
16151,	16063,	15976,	15888,	15800,	15712,	15623,	15535,
15446,	15358,	15269,	15180,	15090,	15001,	14912,	14822,
14732,	14643,	14553,	14462,	14372,	14282,	14191,	14101,
14010,	13919,	13828,	13736,	13645,	13554,	13462,	13370,
13279,	13187,	13094,	13002,	12910,	12817,	12725,	12632,
12539,	12446,	12353,	12260,	12167,	12074,	11980,	11886,
11793,	11699,	11605,	11511,	11417,	11322,	11228,	11133,
11039,	10944,	10849,	10754,	10659,	10564,	10469,	10374,
10278,	10183,	10087,	9992,	9896,	9800,	9704,	9608,
9512,	9416,	9319,	9223,	9126,	9030,	8933,	8836,
8739,	8642,	8545,	8448,	8351,	8254,	8157,	8059,
7962,	7864,	7767,	7669,	7571,	7473,	7375,	7277,
7179,	7081,	6983,	6885,	6786,	6688,	6590,	6491,
6393,	6294,	6195,	6096,	5998,	5899,	5800,	5701,
5602,	5503,	5404,	5305,	5205,	5106,	5007,	4907,
4808,	4708,	4609,	4509,	4410,	4310,	4210,	4111,
4011,	3911,	3811,	3712,	3612,	3512,	3412,	3312,
3212,	3112,	3012,	2911,	2811,	2711,	2611,	2511,
2410,	2310,	2210,	2110,	2009,	1909,	1809,	1708,
1608,	1507,	1407,	1307,	1206,	1106,	1005,	905,
804,	704,	603,	503,	402,	302,	201,	101,
0,	-101,	-201,	-302,	-402,	-503,	-603,	-704,
-804,	-905,	-1005,	-1106,	-1206,	-1307,	-1407,	-1507,
-1608,	-1708,	-1809,	-1909,	-2009,	-2110,	-2210,	-2310,
-2410,	-2511,	-2611,	-2711,	-2811,	-2911,	-3012,	-3112,
-3212,	-3312,	-3412,	-3512,	-3612,	-3712,	-3811,	-3911,
-4011,	-4111,	-4210,	-4310,	-4410,	-4509,	-4609,	-4708,
-4808,	-4907,	-5007,	-5106,	-5205,	-5305,	-5404,	-5503,
-5602,	-5701,	-5800,	-5899,	-5998,	-6096,	-6195,	-6294,
-6393,	-6491,	-6590,	-6688,	-6786,	-6885,	-6983,	-7081,
-7179,	-7277,	-7375,	-7473,	-7571,	-7669,	-7767,	-7864,
-7962,	-8059,	-8157,	-8254,	-8351,	-8448,	-8545,	-8642,
-8739,	-8836,	-8933,	-9030,	-9126,	-9223,	-9319,	-9416,
-9512,	-9608,	-9704,	-9800,	-9896,	-9992,	-10087,	-10183,
-10278,	-10374,	-10469,	-10564,	-10659,	-10754,	-10849,	-10944,
-11039,	-11133,	-11228,	-11322,	-11417,	-11511,	-11605,	-11699,
-11793,	-11886,	-11980,	-12074,	-12167,	-12260,	-12353,	-12446,
-12539,	-12632,	-12725,	-12817,	-12910,	-13002,	-13094,	-13187,
-13279,	-13370,	-13462,	-13554,	-13645,	-13736,	-13828,	-13919,
-14010,	-14101,	-14191,	-14282,	-14372,	-14462,	-14553,	-14643,
-14732,	-14822,	-14912,	-15001,	-15090,	-15180,	-15269,	-15358,
-15446,	-15535,	-15623,	-15712,	-15800,	-15888,	-15976,	-16063,
-16151,	-16238,	-16325,	-16413,	-16499,	-16586,	-16673,	-16759,
-16846,	-16932,	-17018,	-17104,	-17189,	-17275,	-17360,	-17445,
-17530,	-17615,	-17700,	-17784,	-17869,	-17953,	-18037,	-18121,
-18204,	-18288,	-18371,	-18454,	-18537,	-18620,	-18703,	-18785,
-18868,	-18950,	-19032,	-19113,	-19195,	-19276,	-19357,	-19438,
-19519,	-19600,	-19680,	-19761,	-19841,	-19921,	-20000,	-20080,
-20159,	-20238,	-20317,	-20396,	-20475,	-20553,	-20631,	-20709,
-20787,	-20865,	-20942,	-21019,	-21096,	-21173,	-21250,	-21326,
-21403,	-21479,	-21554,	-21630,	-21705,	-21781,	-21856,	-21930,
-22005,	-22079,	-22154,	-22227,	-22301,	-22375,	-22448,	-22521,
-22594,	-22667,	-22739,	-22812,	-22884,	-22956,	-23027,	-23099,
-23170,	-23241,	-23311,	-23382,	-23452,	-23522,	-23592,	-23662,
-23731,	-23801,	-23870,	-23938,	-24007,	-24075,	-24143,	-24211,
-24279,	-24346,	-24413,	-24480,	-24547,	-24613,	-24680,	-24746,
-24811,	-24877,	-24942,	-25007,	-25072,	-25137,	-25201,	-25265,
-25329,	-25393,	-25456,	-25519,	-25582,	-25645,	-25708,	-25770,
-25832,	-25893,	-25955,	-26016,	-26077,	-26138,	-26198,	-26259,
-26319,	-26378,	-26438,	-26497,	-26556,	-26615,	-26674,	-26732,
-26790,	-26848,	-26905,	-26962,	-27019,	-27076,	-27133,	-27189,
-27245,	-27300,	-27356,	-27411,	-27466,	-27521,	-27575,	-27629,
-27683,	-27737,	-27790,	-27843,	-27896,	-27949,	-28001,	-28053,
-28105,	-28157,	-28208,	-28259,	-28310,	-28360,	-28411,	-28460,
-28510,	-28560,	-28609,	-28658,	-28706,	-28755,	-28803,	-28850,
-28898,	-28945,	-28992,	-29039,	-29085,	-29131,	-29177,	-29223,
-29268,	-29313,	-29358,	-29403,	-29447,	-29491,	-29534,	-29578,
-29621,	-29664,	-29706,	-29749,	-29791,	-29832,	-29874,	-29915,
-29956,	-29997,	-30037,	-30077,	-30117,	-30156,	-30195,	-30234,
-30273,	-30311,	-30349,	-30387,	-30424,	-30462,	-30498,	-30535,
-30571,	-30607,	-30643,	-30679,	-30714,	-30749,	-30783,	-30818,
-30852,	-30885,	-30919,	-30952,	-30985,	-31017,	-31050,	-31082,
-31113,	-31145,	-31176,	-31206,	-31237,	-31267,	-31297,	-31327,
-31356,	-31385,	-31414,	-31442,	-31470,	-31498,	-31526,	-31553,
-31580,	-31607,	-31633,	-31659,	-31685,	-31710,	-31736,	-31760,
-31785,	-31809,	-31833,	-31857,	-31880,	-31903,	-31926,	-31949,
-31971,	-31993,	-32014,	-32036,	-32057,	-32077,	-32098,	-32118,
-32137,	-32157,	-32176,	-32195,	-32213,	-32232,	-32250,	-32267,
-32285,	-32302,	-32318,	-32335,	-32351,	-32367,	-32382,	-32397,
-32412,	-32427,	-32441,	-32455,	-32469,	-32482,	-32495,	-32508,
-32521,	-32533,	-32545,	-32556,	-32567,	-32578,	-32589,	-32599,
-32609,	-32619,	-32628,	-32637,	-32646,	-32655,	-32663,	-32671,
-32678,	-32685,	-32692,	-32699,	-32705,	-32711,	-32717,	-32722,
-32728,	-32732,	-32737,	-32741,	-32745,	-32748,	-32752,	-32755,
-32757,	-32759,	-32761,	-32763,	-32765,	-32766,	-32766,	-32767,
-32767,	-32767,	-32766,	-32766,	-32765,	-32763,	-32761,	-32759,
-32757,	-32755,	-32752,	-32748,	-32745,	-32741,	-32737,	-32732,
-32728,	-32722,	-32717,	-32711,	-32705,	-32699,	-32692,	-32685,
-32678,	-32671,	-32663,	-32655,	-32646,	-32637,	-32628,	-32619,
-32609,	-32599,	-32589,	-32578,	-32567,	-32556,	-32545,	-32533,
-32521,	-32508,	-32495,	-32482,	-32469,	-32455,	-32441,	-32427,
-32412,	-32397,	-32382,	-32367,	-32351,	-32335,	-32318,	-32302,
-32285,	-32267,	-32250,	-32232,	-32213,	-32195,	-32176,	-32157,
-32137,	-32118,	-32098,	-32077,	-32057,	-32036,	-32014,	-31993,
-31971,	-31949,	-31926,	-31903,	-31880,	-31857,	-31833,	-31809,
-31785,	-31760,	-31736,	-31710,	-31685,	-31659,	-31633,	-31607,
-31580,	-31553,	-31526,	-31498,	-31470,	-31442,	-31414,	-31385,
-31356,	-31327,	-31297,	-31267,	-31237,	-31206,	-31176,	-31145,
-31113,	-31082,	-31050,	-31017,	-30985,	-30952,	-30919,	-30885,
-30852,	-30818,	-30783,	-30749,	-30714,	-30679,	-30643,	-30607,
-30571,	-30535,	-30498,	-30462,	-30424,	-30387,	-30349,	-30311,
-30273,	-30234,	-30195,	-30156,	-30117,	-30077,	-30037,	-29997,
-29956,	-29915,	-29874,	-29832,	-29791,	-29749,	-29706,	-29664,
-29621,	-29578,	-29534,	-29491,	-29447,	-29403,	-29358,	-29313,
-29268,	-29223,	-29177,	-29131,	-29085,	-29039,	-28992,	-28945,
-28898,	-28850,	-28803,	-28755,	-28706,	-28658,	-28609,	-28560,
-28510,	-28460,	-28411,	-28360,	-28310,	-28259,	-28208,	-28157,
-28105,	-28053,	-28001,	-27949,	-27896,	-27843,	-27790,	-27737,
-27683,	-27629,	-27575,	-27521,	-27466,	-27411,	-27356,	-27300,
-27245,	-27189,	-27133,	-27076,	-27019,	-26962,	-26905,	-26848,
-26790,	-26732,	-26674,	-26615,	-26556,	-26497,	-26438,	-26378,
-26319,	-26259,	-26198,	-26138,	-26077,	-26016,	-25955,	-25893,
-25832,	-25770,	-25708,	-25645,	-25582,	-25519,	-25456,	-25393,
-25329,	-25265,	-25201,	-25137,	-25072,	-25007,	-24942,	-24877,
-24811,	-24746,	-24680,	-24613,	-24547,	-24480,	-24413,	-24346,
-24279,	-24211,	-24143,	-24075,	-24007,	-23938,	-23870,	-23801,
-23731,	-23662,	-23592,	-23522,	-23452,	-23382,	-23311,	-23241,
-23170,	-23099,	-23027,	-22956,	-22884,	-22812,	-22739,	-22667,
-22594,	-22521,	-22448,	-22375,	-22301,	-22227,	-22154,	-22079,
-22005,	-21930,	-21856,	-21781,	-21705,	-21630,	-21554,	-21479,
-21403,	-21326,	-21250,	-21173,	-21096,	-21019,	-20942,	-20865,
-20787,	-20709,	-20631,	-20553,	-20475,	-20396,	-20317,	-20238,
-20159,	-20080,	-20000,	-19921,	-19841,	-19761,	-19680,	-19600,
-19519,	-19438,	-19357,	-19276,	-19195,	-19113,	-19032,	-18950,
-18868,	-18785,	-18703,	-18620,	-18537,	-18454,	-18371,	-18288,
-18204,	-18121,	-18037,	-17953,	-17869,	-17784,	-17700,	-17615,
-17530,	-17445,	-17360,	-17275,	-17189,	-17104,	-17018,	-16932,
-16846,	-16759,	-16673,	-16586,	-16499,	-16413,	-16325,	-16238,
-16151,	-16063,	-15976,	-15888,	-15800,	-15712,	-15623,	-15535,
-15446,	-15358,	-15269,	-15180,	-15090,	-15001,	-14912,	-14822,
-14732,	-14643,	-14553,	-14462,	-14372,	-14282,	-14191,	-14101,
-14010,	-13919,	-13828,	-13736,	-13645,	-13554,	-13462,	-13370,
-13279,	-13187,	-13094,	-13002,	-12910,	-12817,	-12725,	-12632,
-12539,	-12446,	-12353,	-12260,	-12167,	-12074,	-11980,	-11886,
-11793,	-11699,	-11605,	-11511,	-11417,	-11322,	-11228,	-11133,
-11039,	-10944,	-10849,	-10754,	-10659,	-10564,	-10469,	-10374,
-10278,	-10183,	-10087,	-9992,	-9896,	-9800,	-9704,	-9608,
-9512,	-9416,	-9319,	-9223,	-9126,	-9030,	-8933,	-8836,
-8739,	-8642,	-8545,	-8448,	-8351,	-8254,	-8157,	-8059,
-7962,	-7864,	-7767,	-7669,	-7571,	-7473,	-7375,	-7277,
-7179,	-7081,	-6983,	-6885,	-6786,	-6688,	-6590,	-6491,
-6393,	-6294,	-6195,	-6096,	-5998,	-5899,	-5800,	-5701,
-5602,	-5503,	-5404,	-5305,	-5205,	-5106,	-5007,	-4907,
-4808,	-4708,	-4609,	-4509,	-4410,	-4310,	-4210,	-4111,
-4011,	-3911,	-3811,	-3712,	-3612,	-3512,	-3412,	-3312,
-3212,	-3112,	-3012,	-2911,	-2811,	-2711,	-2611,	-2511,
-2410,	-2310,	-2210,	-2110,	-2009,	-1909,	-1809,	-1708,
-1608,	-1507,	-1407,	-1307,	-1206,	-1106,	-1005,	-905,
-804,	-704,	-603,	-503,	-402,	-302,	-201,	-101
};

/*
 Sine Table increment lookup for MIDI notes 21	(A0	freq 27.5Hz) and upwards. 88 note keyboard.
 The word values are Q11.5 format. So the value in the table =  increment x 32.
 */ 
static const uint16_t NoteSTIncLookup[midi_note_range]={
43,	46,	49,	51,	54,	58,	61,	65,
69,	73,	77,	82,	87,	92,	97,	103,
109,	115,	122,	130,	137,	145,	154,	163,
173,	183,	194,	206,	218,	231,	245,	259,
275,	291,	308,	327,	346,	367,	388,	412,
436,	462,	489,	518,	549,	582,	617,	653,
692,	733,	777,	823,	872,	924,	979,	1037,
1099,	1164,	1233,	1306,	1384,	1466,	1554,	1646,
1744,	1848,	1957,	2074,	2197,	2328,	2466,	2613,
2768,	2933,	3107,	3292,	3488,	3695,	3915,	4148,
4394,	4656,	4932,	5226,	5536,	5866,	6214,	6584
};

static const uint16_t NoteHzLookup[midi_note_range]={
28,	29,	31,	33,	35,	37,	39,	41,
44,	46,	49,	52,	55,	58,	62,	65,
69,	73,	78,	82,	87,	92,	98,	104,
110,	117,	123,	131,	139,	147,	156,	165,
175,	185,	196,	208,	220,	233,	247,	262,
277,	294,	311,	330,	349,	370,	392,	415,
440,	466,	494,	523,	554,	587,	622,	659,
698,	740,	784,	831,	880,	932,	988,	1047,
1109,	1175,	1245,	1319,	1397,	1480,	1568,	1661,
1760,	1865,	1976,	2093,	2217,	2349,	2489,	2637,
2794,	2960,	3136,	3322,	3520,	3729,	3951,	4186
};

//==============================================================================
//static const int16_t SAMPLE_key_hammer1[sample_length]={
__eds__ __attribute__((space(prog))) int16_t SAMPLE_key_hammer1[sample_length] = {
9664,	10089,	10600,	11084,	11690,	12618,	13526,	14236,
14947,	15576,	16005,	16260,	16562,	17562,	19318,	20878,
21935,	22865,	23487,	23931,	25031,	26551,	27543,	28160,
28835,	29327,	29635,	29952,	30150,	30237,	30301,	30286,
30220,	30133,	29979,	29775,	29512,	29191,	28809,	28372,
27879,	27325,	26718,	26058,	25306,	24447,	23482,	22419,
21234,	19926,	18505,	16789,	14484,	11298,	8063,	6554,
5392,	1599,	-3017,	-5689,	-7275,	-7965,	-7640,	-7452,
-7821,	-10197,	-14628,	-17467,	-18325,	-19811,	-21340,	-22230,
-23250,	-24093,	-24640,	-25271,	-25784,	-26224,	-26704,	-27086,
-27391,	-27653,	-27818,	-27938,	-28011,	-27999,	-27991,	-27923,
-27493,	-26964,	-26896,	-27155,	-27248,	-27057,	-26746,	-26466,
-26184,	-25765,	-25240,	-24678,	-24015,	-23246,	-22396,	-21377,
-20192,	-18804,	-16927,	-14678,	-12339,	-9740,	-7204,	-5392,
-4106,	-3144,	-2631,	-2097,	-1169,	6,	1599,	3809,
6323,	8698,	10773,	12625,	14256,	15522,	16379,	16816,
16760,	16539,	16833,	17773,	18847,	19635,	19980,	20125,
20660,	21580,	22271,	22554,	22672,	22703,	22630,	22467,
22202,	21826,	21328,	20677,	19856,	18776,	17395,	15827,
13931,	11437,	8687,	6317,	4683,	3887,	3443,	2787,
2228,	2074,	1889,	1089,	-531,	-2580,	-4602,	-6564,
-8105,	-8781,	-9035,	-9177,	-8641,	-7381,	-6267,	-5776,
-5636,	-5528,	-5387,	-5453,	-5794,	-6008,	-5892,	-5543,
-4726,	-3402,	-2071,	-1014,	-76,	1049,	2602,	4548,
6680,	8728,	10514,	12198,	13972,	15674,	17037,	17868,
18104,	18143,	18569,	19317,	19954,	20478,	21093,	22036,
23352,	24460,	24985,	25346,	25739,	25963,	26096,	26200,
26188,	26119,	26019,	25823,	25597,	25316,	24922,	24527,
24020,	23247,	22581,	22143,	21496,	20609,	19705,	18666,
17443,	16053,	14417,	12584,	10448,	7727,	4610,	1690,
-727,	-2910,	-5362,	-8281,	-11337,	-13936,	-15811,	-17196,
-18430,	-19524,	-20293,	-20811,	-21205,	-21547,	-22176,	-23004,
-23473,	-23647,	-23646,	-23254,	-22913,	-22873,	-22568,	-21936,
-21329,	-20708,	-20010,	-19175,	-18140,	-17111,	-16176,	-15176,
-14129,	-13157,	-12257,	-11402,	-10711,	-10283,	-10047,	-9810,
-9468,	-9172,	-9279,	-10030,	-11348,	-12795,	-13816,	-14156,
-14021,	-13857,	-13972,	-14424,	-15215,	-16308,	-17477,	-18471,
-19225,	-19844,	-20555,	-21473,	-22361,	-22814,	-22650,	-22023,
-21312,	-20813,	-20684,	-20970,	-21516,	-22057,	-22507,	-22984,
-23573,	-24131,	-24407,	-24240,	-23541,	-22324,	-20759,	-19147,
-17714,	-16534,	-15603,	-14852,	-14189,	-13643,	-13486,	-13941,
-14876,	-15965,	-17048,	-18111,	-19085,	-19826,	-20290,	-20627,
-21120,	-21841,	-22505,	-22789,	-22646,	-22269,	-21835,	-21357,
-20826,	-20380,	-20098,	-19841,	-19485,	-19091,	-18818,	-18763,
-18899,	-19014,	-18824,	-18175,	-17176,	-16124,	-15174,	-14214,
-13162,	-12045,	-10889,	-9735,	-8590,	-7478,	-6521,	-5771,
-5149,	-4616,	-4059,	-3176,	-1818,	-116,	1871,	4096,
6365,	8562,	10715,	12925,	15178,	17065,	18325,	19300,
20226,	20948,	21501,	21937,	22119,	22123,	22190,	22267,
22174,	22016,	21961,	21923,	21831,	21831,	21982,	22131,
22199,	22167,	21944,	21525,	20984,	20156,	18929,	17546,
16261,	15197,	14488,	14095,	13777,	13315,	12610,	11734,
10856,	10032,	9306,	8806,	8458,	8003,	7400,	6748,
6084,	5549,	5322,	5406,	5772,	6343,	6963,	7577,
8183,	8710,	9174,	9668,	10132,	10421,	10513,	10411,
10117,	9769,	9562,	9613,	9948,	10519,	11210,	11896,
12497,	13003,	13404,	13703,	13950,	14157,	14225,	14049,
13638,	13101,	12550,	12042,	11652,	11525,	11773,	12336,
13061,	13839,	14558,	15094,	15438,	15638,	15651,	15403,
14973,	14525,	14095,	13537,	12730,	11677,	10438,	9095,
7760,	6481,	5165,	3802,	2610,	1720,	900,	-148,
-1393,	-2572,	-3552,	-4470,	-5545,	-6863,	-8288,	-9658,
-10951,	-12219,	-13444,	-14646,	-15863,	-17078,	-18245,	-19436,
-20782,	-22185,	-23639,	-25249,	-26683,	-27600,	-28299,	-29014,
-29553,	-29977,	-30390,	-30586,	-30560,	-30629,	-30896,	-31179,
-31377,	-31533,	-31638,	-31747,	-31891,	-31950,	-31871,	-31727,
-31495,	-31146,	-30763,	-30380,	-29987,	-29649,	-29292,	-28682,
-27758,	-26720,	-25765,	-24902,	-24055,	-23207,	-22436,	-21773,
-21188,	-20649,	-20040,	-19205,	-18145,	-16941,	-15530,	-13820,
-11908,	-9988,	-8095,	-6110,	-4070,	-2246,	-787,	468,
1712,	2935,	4016,	4868,	5475,	5882,	6151,	6378,
6664,	6991,	7284,	7627,	8186,	8975,	9783,	10425,
10909,	11348,	11744,	12014,	12143,	12236,	12312,	12204,
11747,	11016,	10325,	9938,	9735,	9399,	8906,	8497,
8261,	8165,	8221,	8296,	8274,	8344,	8537,	8614,
8557,	8460,	8477,	8999,	9990,	10781,	11253,	11883,
12612,	13087,	13342,	13247,	12748,	12583,	13298,	14231,
14429,	14321,	15466,	17943,	19742,	19948,	19862,	20355,
20979,	21304,	21233,	20737,	20192,	19973,	19477,	18083,
16410,	14885,	12939,	10820,	9313,	7885,	6071,	4987,
4932,	4731,	4270,	3946,	3395,	2998,	3341,	3933,
4524,	5200,	5419,	5436,	5910,	5845,	4520,	3438,
3587,	4105,	4195,	3664,	2692,	2038,	1880,	1932,
2473,	3310,	3607,	3522,	3751,	4182,	4498,	4974,
5455,	5154,	4019,	2927,	2155,	1328,	648,	603,
574,	-418,	-1743,	-2117,	-2125,	-3115,	-4623,	-5473,
-6081,	-7075,	-7798,	-7964,	-8572,	-9960,	-11184,	-11588,
-11473,	-11391,	-11369,	-11273,	-11325,	-11407,	-11255,	-11094,
-10645,	-9573,	-8719,	-8392,	-7949,	-7506,	-7219,	-6677,
-6256,	-6339,	-6165,	-5799,	-6363,	-7454,	-7853,	-7447,
-6584,	-5697,	-5019,	-4444,	-4373,	-4912,	-5176,	-5090,
-5107,	-4911,	-4552,	-4507,	-4593,	-4525,	-4588,	-4946,
-5274,	-5334,	-5388,	-5873,	-6635,	-7306,	-8359,	-9839,
-10645,	-10771,	-11187,	-11811,	-12526,	-13398,	-13795,	-13595,
-13435,	-13352,	-12863,	-11636,	-10020,	-8954,	-8593,	-8098,
-7090,	-5916,	-4971,	-4444,	-4043,	-3075,	-1669,	-707,
-262,	187,	690,	1155,	1646,	2178,	2440,	2442,
2984,	3955,	4288,	4402,	5019,	5385,	5386,	5726,
5975,	5783,	5779,	5854,	5453,	4981,	4765,	4304,
3479,	2803,	2757,	3447,	4326,	4758,	4769,	4816,
5337,	6037,	6285,	6628,	7602,	8331,	8186,	7705,
7498,	7611,	7462,	6723,	6023,	5826,	5664,	5315,
5062,	4872,	4510,	3842,	2877,	2365,	2668,	2726,
2094,	1630,	1503,	1280,	701,	-483,	-1972,	-3067,
-3801,	-4476,	-4972,	-5288,	-5593,	-5708,	-5511,	-5391,
-5681,	-6251,	-6614,	-6442,	-6132,	-6290,	-6800,	-7134,
-7160,	-7156,	-7184,	-6883,	-6293,	-6000,	-6133,	-6225,
-5912,	-5257,	-4602,	-4202,	-4094,	-4326,	-4832,	-5197,
-5183,	-5042,	-4974,	-4931,	-4868,	-4555,	-3698,	-2568,
-1757,	-1407,	-1304,	-1145,	-602,	232,	895,	1472,
2402,	3597,	4700,	5561,	5946,	5775,	5478,	5382,
5432,	5641,	5816,	5594,	5190,	5088,	5379,	5867,
6189,	6213,	6326,	6715,	7241,	8033,	9025,	9816,
10543,	11535,	12380,	12797,	13342,	14100,	14284,	13620,
12921,	12960,	13342,	13421,	13455,	13593,	13412,	13157,
13317,	13458,	13231,	13057,	13051,	12695,	11658,	10168,
8708,	7540,	6458,	5321,	4303,	3507,	2955,	2697,
2500,	2257,	2084,	1745,	948,	132,	-157,	-220,
-624,	-1315,	-1874,	-2156,	-2399,	-2915,	-3772,	-4824,
-5899,	-6674,	-6846,	-6615,	-6445,	-6379,	-6242,	-6078,
-5968,	-5900,	-5860,	-5789,	-5590,	-5264,	-4880,	-4755,
-5258,	-5945,	-6055,	-5658,	-5165,	-4805,	-4823,	-4913,
-4620,	-4445,	-4756,	-4891,	-4881,	-5429,	-6145,	-6661,
-7743,	-9469,	-11058,	-12390,	-13676,	-15105,	-16737,	-18082,
-18818,	-19135,	-19164,	-19144,	-19172,	-19087,	-19103,	-19332,
-19381,	-18997,	-18304,	-17643,	-17237,	-16897,	-16509,	-16165,
-15633,	-14607,	-13303,	-12106,	-11163,	-10446,	-9657,	-8527,
-7331,	-6254,	-5073,	-3812,	-2566,	-1178,	390,	2070,
3665,	4729,	5317,	5924,	6440,	6610,	6902,	7608,
8167,	8146,	7788,	7557,	7729,	8196,	8740,	9370,
10044,	10742,	11661,	12729,	13563,	13891,	13748,	13524,
13427,	13157,	12695,	12456,	12440,	12373,	12258,	11977,
11292,	10548,	10254,	10215,	10014,	9669,	9404,	9310,
9404,	9692,	9894,	9627,	9098,	8636,	8051,	7517,
7612,	8068,	8122,	7778,	7616,	7771,	7823,	7579,
7365,	7370,	7460,	7621,	7865,	7971,	7811,	7496,
7171,	7135,	7325,	7185,	6836,	6784,	6790,	6723,
6832,	6809,	6258,	5274,	4124,	3274,	2943,	2737,
2527,	2658,	2972,	3188,	3474,	3664,	3566,	3715,
4318,	4939,	5214,	4908,	4339,	4085,	3838,	3122,
2220,	1303,	295,	-543,	-1211,	-1969,	-2452,	-2386,
-2306,	-2385,	-2260,	-2060,	-2034,	-2039,	-1941,	-1876,
-2085,	-2598,	-3131,	-3606,	-4100,	-4414,	-4302,	-4097,
-4356,	-4821,	-4826,	-4598,	-4748,	-4875,	-4303,	-3455,
-3072,	-2998,	-2816,	-2725,	-2969,	-3186,	-2851,	-2250,
-2141,	-2345,	-2185,	-1921,	-2008,	-2091,	-1920,	-1661,
-1383,	-1189,	-1270,	-1523,	-1725,	-1846,	-2005,	-2408,
-2976,	-3283,	-3323,	-3392,	-3388,	-3282,	-3303,	-3262,
-3033,	-2975,	-3202,	-3534,	-3975,	-4252,	-3886,	-3228,
-3078,	-3403,	-3503,	-3074,	-2605,	-2569,	-2643,	-2364,
-1973,	-1630,	-1063,	-461,	-76,	581,	1548,	1773,
937,	-32,	-620,	-1169,	-1865,	-2391,	-2497,	-2531,
-3152,	-4357,	-5525,	-6322,	-6777,	-7061,	-7601,	-8534,
-9349,	-9870,	-10406,	-11014,	-11730,	-12811,	-14057,	-15026,
-15596,	-15719,	-15731,	-16462,	-17679,	-18181,	-17785,	-17298,
-17097,	-16994,	-16747,	-16412,	-16004,	-15519,	-15133,	-14640,
-13616,	-12679,	-12309,	-11398,	-9245,	-7068,	-5590,	-3985,
-1958,	-228,	942,	1847,	2763,	3576,	3942,	3991,
4343,	5045,	5633,	5979,	6513,	7493,	8600,	9379,
9883,	10253,	10220,	9807,	9611,	9809,	10080,	10260,
10287,	10435,	11341,	12583,	12778,	11901,	11230,	11059,
10852,	10716,	10900,	11220,	11613,	12143,	12638,	12929,
12913,	12769,	12998,	13366,	13124,	12553,	12260,	12026,
11830,	11962,	12088,	12225,	12813,	13309,	13284,	13535,
14030,	13682,	12785,	12316,	11842,	10993,	10285,	9528,
8400,	7779,	7965,	7773,	7076,	6983,	6973,	5841,
4385,	3635,	2873,	1476,	-5,	-1083,	-1850,	-2588,
-3482,	-4337,	-4921,	-5464,	-6086,	-6375,	-6146,	-5993,
-6489,	-7225,	-7327,	-7061,	-7393,	-8021,	-7933,	-7298,
-6769,	-6388,	-6057,	-5714,	-5085,	-4098,	-3075,	-2199,
-1466,	-1074,	-1061,	-882,	-263,	184,	113,	278,
1115,	1876,	2032,	1977,	2047,	2352,	2993,	3626,
3756,	3599,	3591,	3787,	4244,	4897,	5119,	4701,
4405,	4518,	4417,	3957,	3327,	2277,	779,	-700,
-1729,	-2224,	-2587,	-3140,	-3537,	-3755,	-4386,	-5117,
-5309,	-5645,	-6585,	-7180,	-7174,	-7311,	-7620,	-7897,
-8307,	-8648,	-8729,	-8762,	-8829,	-9060,	-9695,	-10308,
-10294,	-10158,	-10664,	-11222,	-10935,	-10249,	-10142,	-10632,
-11102,	-11168,	-10715,	-9850,	-9017,	-8445,	-7822,	-6997,
-6239,	-5715,	-5153,	-4389,	-3870,	-3927,	-4029,	-3777,
-3559,	-3599,	-3640,	-3486,	-3107,	-2593,	-2017,	-1474,
-1237,	-1346,	-1198,	-536,	60,	361,	639,	704,
434,	105,	-95,	98,	590,	615,	105,	-187,
-114,	-21,	-59,	-232,	-45,	1076,	2438,	2953,
2896,	2853,	2597,	1988,	1300,	853,	790,	829,
638,	177,	-436,	-727,	-347,	39,	-217,	-664,
-730,	-549,	-184,	488,	1148,	1335,	1032,	610,
392,	134,	-405,	-874,	-900,	-503,	-14,	81,
40,	478,	1113,	1346,	1450,	1793,	2245,	2677,
2939,	2881,	2931,	3386,	3889,	4243,	4496,	4417,
4032,	3585,	3163,	2908,	2947,	3117,	3278,	3331,
3136,	2741,	2476,	2578,	2968,	3388,	3862,	4637,
5356,	5419,	5368,	5994,	6757,	6985,	7114,	7505,
7759,	7567,	7057,	6428,	5952,	5818,	5901,	6055,
6416,	6972,	7416,	7751,	8410,	9393,	9991,	9817,
9432,	9537,	10042,	10141,	9344,	8102,	7077,	6254,
5219,	3841,	2373,	1181,	322,	-471,	-1191,	-1585,
-1864,	-2413,	-2961,	-3080,	-3009,	-3051,	-3153,	-3392,
-3927,	-4466,	-4806,	-5366,	-6439,	-7501,	-8068,	-8417,
-9049,	-9811,	-10077,	-9694,	-9222,	-8898,	-8359,	-7622,
-7312,	-7524,	-7702,	-7546,	-7253,	-7015,	-6902,	-6881,
-6966,	-7156,	-7242,	-6960,	-6470,	-6049,	-5711,	-5319,
-4879,	-4417,	-3989,	-3683,	-3502,	-3235,	-2689,	-2014,
-1621,	-1593,	-1665,	-1732,	-1834,	-1846,	-1694,	-1520,
-1538,	-1843,	-2203,	-2283,	-2106,	-1961,	-1959,	-2018,
-2071,	-2090,	-2108,	-2089,	-1944,	-1866,	-2095,	-2364,
-2354,	-2334,	-2679,	-3200,	-3311,	-2845,	-2295,	-2041,
-1926,	-1741,	-1393,	-804,	-96,	513,	1080,	1627,
2061,	2573,	3218,	3644,	3708,	3555,	3343,	3454,
4003,	4438,	4599,	5075,	6014,	6949,	7627,	8034,
8198,	8317,	8454,	8502,	8575,	8700,	8471,	7772,
7054,	6666,	6547,	6567,	6608,	6480,	6071,	5475,
4922,	4638,	4545,	4409,	4233,	4206,	4348,	4505,
4469,	4111,	3624,	3408,	3437,	3344,	3124,	3062,
3082,	2960,	2901,	3083,	3291,	3451,	3656,	3676,
3431,	3308,	3446,	3566,	3624,	3658,	3502,	3159,
2757,	2265,	1732,	1223,	603,	-48,	-522,	-1109,
-2126,	-3155,	-3695,	-4028,	-4616,	-5250,	-5643,	-5946,
-6290,	-6613,	-6954,	-7379,	-7911,	-8605,	-9277,	-9521,
-9422,	-9472,	-9744,	-9908,	-9846,	-9624,	-9279,	-8918,
-8627,	-8339,	-7969,	-7526,	-7021,	-6429,	-5921,	-5698,
-5532,	-5080,	-4308,	-3312,	-2264,	-1286,	-335,	426,
764,	920,	1275,	1886,	2670,	3416,	3917,	4382,
5028,	5666,	6466,	7498,	8097,	8266,	8702,	9237,
9664,	10437,	11350,	11753,	11823,	12047,	12444,	12771,
12628,	11961,	11446,	11429,	11519,	11407,	10924,	10119,
9475,	9021,	8389,	7750,	7329,	6968,	6683,	6469,
5993,	5155,	4178,	3096,	1966,	998,	200,	-489,
-884,	-989,	-1142,	-1612,	-2365,	-3214,	-4035,	-4807,
-5589,	-6463,	-7224,	-7738,	-8265,	-8968,	-9730,	-10414,
-10767,	-10811,	-10991,	-11308,	-11367,	-11318,	-11468,	-11641,
-11676,	-11679,	-11646,	-11743,	-12217,	-12704,	-12681,	-12258,
-11828,	-11521,	-11307,	-11308,	-11566,	-11691,	-11499,	-11338,
-11113,	-10359,	-9330,	-8565,	-8003,	-7410,	-6836,	-6321,
-5984,	-5905,	-5742,	-5201,	-4438,	-3792,	-3560,	-3644,
-3568,	-3258,	-2852,	-2176,	-1442,	-1169,	-1126,	-733,
-108,	460,	949,	1328,	1803,	2536,	3138,	3508,
4062,	4663,	4933,	5151,	5594,	6104,	6604,	6999,
7213,	7638,	8427,	8887,	8679,	8367,	8428,	8899,
9682,	10344,	10290,	9572,	8904,	8703,	8529,	7951,
7465,	7749,	8356,	8431,	8053,	7629,	7044,	6257,
5607,	5112,	4427,	3630,	3257,	3569,	4059,	4038,
3508,	3058,	2958,	2911,	2590,	2146,	1984,	2087,
1993,	1696,	1685,	1989,	2216,	2336,	2560,	2987,
3547,	3918,	3908,	3898,	4204,	4548,	4659,	4449,
3825,	3186,	3176,	3753,	4505,	5175,	5551,	5636,
5591,	5329,	4972,	4919,	4937,	4729,	4762,	4955,
4647,	4217,	4195,	3881,	3003,	2179,	1364,	410,
22,	174,	-125,	-910,	-1399,	-1586,	-2029,	-2912,
-3980,	-4860,	-5511,	-6262,	-7113,	-7892,	-8677,	-9347,
-9531,	-9522,	-9934,	-10527,	-10899,	-11269,	-11571,	-11461,
-11367,	-11803,	-12327,	-12477,	-12361,	-12032,	-11556,	-11292,
-11175,	-10544,	-9220,	-7898,	-7095,	-6551,	-5962,	-5491,
-5189,	-4772,	-4246,	-3854,	-3454,	-2838,	-2197,	-1832,
-1676,	-1297,	-511,	212,	452,	441,	650,	1286,
2223,	3168,	3952,	4512,	4674,	4424,	4173,	4207,
4360,	4519,	4718,	4836,	4805,	4806,	4979,	5128,
5083,	5099,	5268,	5178,	4926,	5128,	5707,	5985,
5791,	5617,	5825,	6157,	6131,	5842,	5652,	5406,
5091,	5056,	4923,	4250,	3762,	3862,	3842,	3405,
2832,	2103,	1255,	531,	-207,	-1149,	-2033,	-2560,
-2786,	-3109,	-3745,	-4236,	-4243,	-4307,	-4811,	-5423,
-5881,	-6182,	-6352,	-6386,	-6267,	-6223,	-6520,	-6932,
-7130,	-7247,	-7315,	-7160,	-7003,	-7018,	-6970,	-6943,
-7019,	-6746,	-6120,	-5781,	-5902,	-6008,	-5766,	-5407,
-5216,	-4994,	-4468,	-3874,	-3518,	-3276,	-2900,	-2473,
-2147,	-1968,	-1930,	-2032,	-2155,	-1974,	-1391,	-778,
-308,	62,	281,	558,	1098,	1565,	1819,	2131,
2459,	2762,	3330,	4020,	4304,	4168,	3931,	3625,
3305,	3164,	3184,	3143,	2946,	2835,	3007,	3294,
3667,	4129,	4271,	3999,	3758,	3572,	3244,	3025,
2943,	2688,	2468,	2509,	2299,	1640,	1119,	926,
618,	30,	-541,	-803,	-780,	-847,	-1379,	-2207,
-2710,	-2777,	-3007,	-3676,	-4399,	-4904,	-5345,	-5835,
-6209,	-6210,	-5872,	-5646,	-5760,	-5728,	-5284,	-4980,
-5092,	-5015,	-4494,	-4051,	-3924,	-3717,	-3195,	-2445,
-1623,	-925,	-483,	-95,	319,	539,	555,	767,
1324,	1872,	2123,	2393,	3104,	4112,	5042,	5932,
6891,	7766,	8444,	8951,	9205,	9102,	8734,	8288,
7971,	7781,	7404,	6773,	6406,	6625,	7012,	7142,
7135,	7200,	7182,	6820,	6157,	5586,	5404,	5362,
5027,	4463,	3964,	3563,	3210,	3037,	3169,	3497,
3695,	3613,	3435,	3256,	2926,	2459,	1948,	1302,
525,	-183,	-788,	-1197,	-1238,	-1095,	-1069,	-1103,
-1202,	-1519,	-1890,	-2127,	-2379,	-2567,	-2401,	-2168,
-2428,	-3006,	-3417,	-3807,	-4458,	-5090,	-5329,	-5251,
-5242,	-5455,	-5644,	-5623,	-5599,	-5645,	-5511,	-5241,
-5023,	-4702,	-4309,	-4156,	-4035,	-3610,	-3053,	-2597,
-2257,	-1987,	-1500,	-749,	-216,	-37,	187,	534,
857,	1291,	1806,	2118,	2284,	2530,	2924,	3445,
3951,	4226,	4095,	3598,	3144,	3027,	3012,	2786,
2413,	2050,	1641,	1063,	459,	121,	-35,	-456,
-1085,	-1437,	-1506,	-1613,	-1803,	-2087,	-2343,	-2314,
-2197,	-2420,	-2872,	-3206,	-3367,	-3391,	-3273,	-3156,
-3178,	-3269,	-3291,	-3197,	-3107,	-3174,	-3318,	-3425,
-3574,	-3792,	-3956,	-3989,	-3937,	-3835,	-3631,	-3409,
-3430,	-3637,	-3651,	-3492,	-3533,	-3703,	-3611,	-3185,
-2538,	-1815,	-1251,	-861,	-461,	-44,	344,	765,
1163,	1401,	1532,	1670,	1771,	1771,	1701,	1661,
1691,	1770,	1993,	2400,	2718,	2897,	3274,	3801,
4115,	4384,	4916,	5355,	5291,	5001,	4827,	4638,
4306,	4049,	4002,	3988,	3895,	3913,	4068,	4157,
4106,	3988,	3900,	3895,	3833,	3619,	3442,	3317,
2970,	2463,	2107,	1774,	1249,	861,	943,	1207,
1104,	525,	-123,	-555,	-799,	-965,	-1282,	-1809,
-2160,	-2213,	-2319,	-2541,	-2624,	-2609,	-2642,	-2602,
-2397,	-2031,	-1559,	-1138,	-787,	-453,	-306,	-379,
-416,	-269,	67,	527,	974,	1330,	1542,	1634,
1813,	2051,	2075,	1978,	2054,	2127,	1997,	1843,
1681,	1305,	821,	391,	26,	-206,	-298,	-432,
-728,	-1112,	-1409,	-1594,	-1772,	-2064,	-2585,	-3254,
-3852,	-4352,	-4713,	-4698,	-4363,	-4066,	-3871,	-3701,
-3675,	-3744,	-3672,	-3530,	-3447,	-3324,	-3137,	-2980,
-2862,	-2766,	-2640,	-2520,	-2556,	-2738,	-2917,	-2984,
-2866,	-2552,	-2088,	-1592,	-1319,	-1369,	-1478,	-1430,
-1434,	-1641,	-1831,	-1782,	-1524,	-1263,	-1108,	-857,
-346,	233,	680,	947,	990,	885,	812,	914,
1210,	1536,	1753,	1922,	1997,	1808,	1513,	1463,
1665,	1926,	2180,	2402,	2621,	2833,	2852,	2701,
2709,	2943,	3125,	3121,	3182,	3608,	4234,	4514,
4232,	3823,	3793,	4033,	4057,	3755,	3371,	2962,
2460,	2062,	1875,	1649,	1307,	1089,	1024,	1007,
965,	835,	700,	768,	953,	1017,	915,	737,
559,	440,	324,	141,	-33,	-74,	-38,	-81,
-364,	-758,	-703,	-77,	239,	-294,	-857,	-745,
-585,	-940,	-1295,	-1237,	-995,	-785,	-737,	-861,
-907,	-846,	-903,	-858,	-455,	-82,	-57,	-184,
-324,	-433,	-432,	-541,	-905,	-1187,	-1214,	-1222,
-1210,	-962,	-678,	-808,	-1133,	-984,	-414,	-115,
-67,	293,	861,	1094,	959,	559,	-37,	-462,
-481,	-344,	-255,	-185,	-95,	148,	598,	1051,
1453,	1846,	2063,	2119,	2274,	2431,	2462,	2638,
2843,	2609,	2206,	2220,	2389,	2262,	2033,	1849,
1492,	1036,	703,	377,	-69,	-458,	-625,	-657,
-703,	-876,	-1145,	-1307,	-1363,	-1513,	-1657,	-1584,
-1474,	-1460,	-1273,	-900,	-793,	-1088,	-1549,	-1930,
-1940,	-1622,	-1460,	-1637,	-1804,	-1676,	-1245,	-729,
-327,	73,	567,	840,	763,	683,	731,	764,
940,	1353,	1685,	1749,	1789,	1977,	2064,	1839,
1524,	1273,	945,	592,	454,	468,	386,	252,
334,	608,	706,	481,	161,	-142,	-505,	-797,
-870,	-963,	-1392,	-2127,	-2816,	-3021,	-2775,	-2572,
-2552,	-2480,	-2293,	-2021,	-1709,	-1508,	-1481,	-1587,
-1831,	-2169,	-2399,	-2362,	-2150,	-1995,	-1916,	-1696,
-1352,	-1233,	-1420,	-1673,	-1883,	-2073,	-2273,	-2283,
-1747,	-1042,	-856,	-934,	-788,	-748,	-909,	-775,
-452,	-405,	-500,	-510,	-429,	-147,	195,	304,
259,	119,	-178,	-368,	-234,	86,	515,	935,
1075,	1049,	1194,	1321,	1124,	851,	774,	787,
812,	871,	811,	491,	123,	95,	427,	771,
978,	1197,	1434,	1554,	1659,	1860,	1986,	2022,
2295,	2834,	3255,	3363,	3319,	3307,	3353,	3416,
3554,	3840,	4121,	4262,	4456,	4863,	5302,	5570,
5774,	6054,	6307,	6350,	6172,	5922,	5681,	5518,
5504,	5463,	5223,	4977,	4879,	4853,	4934,	5104,
5140,	5058,	4950,	4624,	4171,	3937,	3633,	2905,
2188,	1847,	1547,	1078,	619,	286,	79,	-24,
-121,	-245,	-329,	-400,	-577,	-919,	-1386,	-1860,
-2352,	-2904,	-3434,	-3914,	-4307,	-4407,	-4328,	-4547,
-5103,	-5589,	-5955,	-6399,	-6701,	-6574,	-6286,	-6195,
-6133,	-5811,	-5452,	-5388,	-5483,	-5485,	-5507,	-5643,
-5760,	-5706,	-5408,	-4948,	-4514,	-4204,	-3880,	-3336,
-2649,	-2165,	-1960,	-1795,	-1655,	-1746,	-2001,	-2189,
-2288,	-2372,	-2407,	-2338,	-2159,	-1990,	-1925,	-1913,
-1947,	-2077,	-2169,	-2106,	-1970,	-1881,	-1834,	-1697,
-1453,	-1257,	-1070,	-778,	-573,	-608,	-670,	-679,
-741,	-746,	-697,	-820,	-955,	-900,	-883,	-992,
-1037,	-1008,	-1054,	-1316,	-1741,	-2070,	-2314,	-2661,
-2913,	-2817,	-2529,	-2125,	-1507,	-934,	-647,	-392,
125,	831,	1340,	1319,	992,	777,	638,	480,
542,	905,	1396,	1912,	2477,	2975,	3283,	3496,
3720,	3816,	3718,	3707,	3944,	4145,	4132,	4034,
3894,	3691,	3539,	3465,	3418,	3423,	3485,	3552,
3624,	3709,	3760,	3724,	3627,	3550,	3526,	3491,
3346,	3170,	3190,	3316,	3290,	3174,	3104,	2968,
2748,	2485,	2087,	1740,	1764,	1847,	1566,	1167,
954,	840,	830,	886,	806,	644,	535,	338,
10,	-221,	-270,	-437,	-839,	-1182,	-1411,	-1766,
-2123,	-2227,	-2271,	-2521,	-2830,	-2967,	-2892,	-2766,
-2889,	-3191,	-3291,	-3193,	-3098,	-3017,	-3041,	-3173,
-3200,	-3265,	-3510,	-3553,	-3251,	-3021,	-3054,	-3144,
-3208,	-3256,	-3211,	-3082,	-2915,	-2661,	-2437,	-2472,
-2728,	-2956,	-3058,	-3110,	-3074,	-2886,	-2677,	-2569,
-2502,	-2386,	-2185,	-1968,	-1763,	-1609,	-1694,	-1980,
-2001,	-1691,	-1473,	-1424,	-1324,	-1198,	-1097,	-964,
-894,	-1078,	-1416,	-1641,	-1632,	-1490,	-1303,	-1055,
-800,	-624,	-478,	-465,	-704,	-925,	-885,	-686,
-367,	-17,	193,	351,	552,	676,	831,	1210,
1513,	1322,	885,	775,	1078,	1359,	1298,	1037,
838,	765,	768,	728,	516,	222,	-35,	-208,
-205,	-109,	-95,	-48,	182,	434,	558,	687,
943,	1203,	1309,	1279,	1151,	962,	865,	970,
1162,	1280,	1277,	1193,	1168,	1315,	1465,	1445,
1337,	1179,	1020,	1016,	1141,	1305,	1531,	1762,
1894,	1886,	1723,	1631,	1860,	2238,	2449,	2466,
2384,	2293,	2280,	2306,	2307,	2358,	2368,	2141,
1727,	1328,	1135,	1243,	1463,	1674,	1943,	2127,
2059,	1918,	1859,	1846,	1748,	1355,	677,	178,
130,	167,	-45,	-225,	-46,	313,	519,	631,
864,	1148,	1299,	1290,	1189,	1235,	1586,	2034,
2362,	2596,	2790,	3063,	3463,	3745,	3815,	3937,
4115,	4022,	3651,	3293,	3050,	2833,	2548,	2186,
1889,	1738,	1572,	1309,	1064,	813,	404,	-60,
-363,	-625,	-969,	-1192,	-1285,	-1549,	-1959,	-2296,
-2590,	-2921,	-3217,	-3419,	-3496,	-3430,	-3265,	-3058,
-2865,	-2699,	-2505,	-2311,	-2275,	-2397,	-2436,	-2281,
-2106,	-2147,	-2354,	-2399,	-2268,	-2239,	-2220,	-1846,
-1244,	-927,	-885,	-565,	85,	455,	443,	603,
1018,	1222,	1155,	1199,	1496,	1795,	1830,	1734,
1968,	2550,	3037,	3331,	3654,	3943,	4079,	4159,
4245,	4242,	4065,	3793,	3670,	3822,	4065,	4196,
4233,	4262,	4267,	4131,	3798,	3482,	3403,	3454,
3501,	3588,	3660,	3550,	3241,	2876,	2599,	2361,
1905,	1184,	595,	388,	287,	31,	-279,	-478,
-596,	-766,	-1007,	-1248,	-1479,	-1792,	-2215,	-2742,
-3363,	-3937,	-4378,	-4777,	-5096,	-5312,	-5673,	-6182,
-6488,	-6645,	-6942,	-7144,	-7012,	-6863,	-6925,	-7071,
-7156,	-7007,	-6619,	-6310,	-6226,	-6169,	-5988,	-5600,
-5052,	-4684,	-4567,	-4265,	-3702,	-3299,	-3107,	-2872,
-2600,	-2358,	-2159,	-2017,	-1841,	-1507,	-1175,	-1077,
-1136,	-1099,	-864,	-487,	-19,	476,	874,	1133,
1408,	1748,	1948,	1917,	1763,	1567,	1423,	1473,
1630,	1722,	1822,	2045,	2287,	2519,	2818,	3184,
3555,	3841,	3908,	3852,	3908,	4033,	4090,	4118,
4105,	4053,	4123,	4280,	4352,	4358,	4386,	4407,
4345,	4108,	3780,	3640,	3566,	3164,	2607,	2248,
1991,	1753,	1562,	1255,	822,	436,	144,	-36,
-117,	-258,	-478,	-659,	-797,	-871,	-835,	-826,
-771,	-509,	-326,	-402,	-466,	-536,	-735,	-828,
-751,	-748,	-858,	-969,	-1007,	-904,	-799,	-899,
-1044,	-1060,	-1073,	-1079,	-934,	-634,	-169,	401,
841,	1120,	1480,	1870,	2003,	1831,	1616,	1592,
1688,	1602,	1337,	1264,	1391,	1333,	1109,	1053,
1136,	1164,	1249,	1493,	1745,	1844,	1892,	2090,
2381,	2484,	2319,	1984,	1487,	922,	525,	242,
-212,	-792,	-1195,	-1364,	-1494,	-1800,	-2273,	-2701,
-2959,	-3161,	-3452,	-3817,	-4103,	-4322,	-4653,	-5045,
-5312,	-5544,	-5869,	-6132,	-6263,	-6401,	-6493,	-6406,
-6237,	-6031,	-5724,	-5413,	-5229,	-5163,	-5187,	-5287,
-5328,	-5148,	-4865,	-4764,	-4769,	-4575,	-4151,	-3710,
-3362,	-3100,	-2879,	-2707,	-2686,	-2771,	-2646,	-2196,
-1679,	-1270,	-932,	-656,	-404,	-55,	496,	1174,
1722,	1965,	2005,	2052,	2262,	2634,	2995,	3220,
3399,	3697,	4123,	4509,	4753,	4861,	4789,	4555,
4431,	4598,	4825,	4911,	4877,	4739,	4664,	4844,
5026,	4950,	4805,	4734,	4642,	4509,	4336,	4173,
4105,	3941,	3490,	3087,	3030,	3011,	2748,	2423,
2312,	2481,	2708,	2748,	2643,	2515,	2381,	2409,
2665,	2859,	2858,	2887,	2917,	2796,	2654,	2530,
2267,	1926,	1536,	938,	316,	29,	-29,	-166,
-472,	-922,	-1310,	-1349,	-1230,	-1334,	-1569,	-1725,
-1869,	-2027,	-2120,	-2196,	-2271,	-2278,	-2203,	-2088,
-2035,	-2133,	-2160,	-1906,	-1662,	-1708,	-1758,	-1553,
-1419,	-1615,	-1843,	-1884,	-1850,	-1801,	-1813,	-2010,
-2184,	-2068,	-1844,	-1727,	-1649,	-1680,	-1880,	-1986,
-1988,	-2157,	-2386,	-2436,	-2381,	-2302,	-2217,	-2214,
-2291,	-2402,	-2523,	-2533,	-2390,	-2287,	-2294,	-2346,
-2556,	-2905,	-3066,	-2951,	-2765,	-2641,	-2647,	-2783,
-2891,	-2900,	-2897,	-2909,	-2946,	-3043,	-3075,	-2982,
-2917,	-2867,	-2644,	-2323,	-2126,	-2109,	-2240,	-2444,
-2585,	-2672,	-2740,	-2698,	-2625,	-2710,	-2867,	-2925,
-2928,	-2935,	-2912,	-2865,	-2817,	-2762,	-2658,	-2473,
-2225,	-1915,	-1474,	-947,	-540,	-312,	-132,	67,
251,	367,	493,	763,	1155,	1554,	1865,	1987,
2059,	2381,	2823,	2996,	2994,	3156,	3330,	3261,
3097,	3009,	2906,	2758,	2652,	2647,	2747,	2848,
2767,	2516,	2358,	2368,	2297,	2028,	1652,	1233,
892,	735,	645,	605,	758,	961,	918,	688,
513,	396,	203,	4,	-77,	-132,	-270,	-337,
-233,	-151,	-190,	-213,	-263,	-409,	-462,	-276,
31,	228,	271,	419,	696,	772,	622,	496,
421,	415,	546,	692,	760,	892,	1102,	1324,
1646,	2086,	2500,	2776,	2801,	2690,	2676,	2676,
2565,	2554,	2718,	2898,	2974,	2979,	3059,	3312,
3601,	3759,	3822,	3859,	3831,	3735,	3650,	3637,
3711,	3794,	3821,	3786,	3643,	3443,	3382,	3500,
3708,	3928,	4081,	4126,	4028,	3779,	3494,	3325,
3368,	3633,	3958,	4111,	4092,	4003,	3807,	3580,
3537,	3679,	3860,	4039,	4156,	4122,	3943,	3622,
3147,	2597,	2071,	1618,	1134,	479,	-217,	-736,
-1152,	-1626,	-2081,	-2384,	-2590,	-2826,	-3034,	-3068,
-2951,	-2897,	-2998,	-3129,	-3177,	-3173,	-3205,	-3300,
-3371,	-3355,	-3254,	-3042,	-2693,	-2270,	-1894,	-1721,
-1794,	-1876,	-1770,	-1623,	-1603,	-1651,	-1715,	-1823,
-1882,	-1802,	-1639,	-1458,	-1260,	-1063,	-910,	-802,
-671,	-549,	-623,	-923,	-1187,	-1232,	-1147,	-1046,
-973,	-978,	-1076,	-1201,	-1250,	-1172,	-1084,	-1132,
-1209,	-1164,	-1120,	-1219,	-1391,	-1565,	-1731,	-1837,
-1913,	-2074,	-2283,	-2400,	-2437,	-2522,	-2692,	-2840,
-2870,	-2806,	-2708,	-2606,	-2502,	-2377,	-2241,	-2138,
-2030,	-1863,	-1703,	-1599,	-1491,	-1412,	-1438,	-1452,
-1318,	-1088,	-831,	-553,	-327,	-181,	-13,	222,
482,	764,	1038,	1162,	1088,	907,	643,	284,
-93,	-436,	-747,	-939,	-957,	-965,	-1092,	-1279,
-1444,	-1486,	-1248,	-834,	-576,	-555,	-594,	-620,
-613,	-504,	-394,	-417,	-450,	-386,	-355,	-328,
-85,	349,	705,	861,	883,	903,	972,	941,
691,	397,	275,	261,	150,	-139,	-495,	-748,
-877,	-1003,	-1156,	-1215,	-1143,	-1083,	-1157,	-1268,
-1280,	-1285,	-1411,	-1560,	-1576,	-1514,	-1547,	-1699,
-1802,	-1755,	-1674,	-1675,	-1689,	-1676,	-1670,	-1643,
-1572,	-1462,	-1204,	-820,	-566,	-577,	-689,	-699,
-539,	-292,	-97,	26,	173,	346,	472,	513,
483,	454,	612,	1007,	1429,	1693,	1876,	2078,
2330,	2673,	3104,	3473,	3652,	3685,	3694,	3746,
3853,	4017,	4190,	4278,	4290,	4317,	4339,	4266,
4168,	4149,	4216,	4357,	4558,	4780,	5004,	5207,
5387,	5527,	5546,	5463,	5469,	5503,	5279,	4921,
4835,	5009,	5198,	5344,	5395,	5291,	5094,	4784,
4259,	3625,	3042,	2465,	1837,	1258,	846,	580,
306,	-52,	-392,	-671,	-1001,	-1355,	-1628,	-1919,
-2335,	-2831,	-3411,	-4058,	-4611,	-5023,	-5355,	-5515
};

__eds__ __attribute__((space(prog))) int16_t SAMPLE_key_hammer2[sample_length] = {
1248,	1109,	1089,	1109,	1208,	1010,	892,	1228,
1169,	1288,	1367,	1367,	931,	931,	1347,	1446,
1288,	1327,	1426,	1288,	1030,	1327,	1605,	1347,
1228,	1426,	1486,	1347,	1367,	1406,	1426,	1307,
1367,	1466,	1307,	1288,	1545,	1466,	1288,	1406,
1565,	1347,	1248,	1486,	1387,	1268,	1367,	1426,
1486,	1169,	1109,	1347,	1406,	1387,	1406,	1406,
1327,	1129,	1149,	1387,	1327,	1208,	1208,	1169,
1149,	1169,	1288,	1327,	1149,	1208,	1169,	1050,
1109,	1070,	1208,	1089,	951,	1030,	1030,	872,
634,	812,	951,	872,	674,	931,	1129,	911,
753,	1129,	1506,	1961,	2972,	4021,	4972,	5804,
5567,	3942,	1921,	1862,	3724,	4497,	3328,	1763,
1268,	2417,	3922,	3863,	1406,	-3071,	-8479,	-12500,
-13431,	-11747,	-7983,	-3506,	-297,	-872,	-3982,	-7072,
-8756,	-8538,	-7845,	-5408,	-1803,	0,	-1030,	297,
2853,	2338,	4695,	6081,	5943,	5329,	1941,	-218,
277,	1010,	2991,	9033,	12896,	11767,	11589,	13292,
12836,	9746,	6062,	2615,	-812,	-4893,	-6775,	-4358,
-139,	3605,	6438,	7607,	7270,	7963,	8954,	8161,
6319,	3783,	832,	-1446,	-3764,	-6814,	-10875,	-11549,
-5052,	5903,	15749,	19037,	16858,	14698,	8201,	-1050,
-5012,	-3447,	2694,	5725,	2496,	6022,	19611,	29397,
28189,	20800,	21355,	31200,	32765,	19116,	-2357,	-22068,
-24861,	-5289,	18344,	19354,	7349,	6339,	8716,	3328,
-1288,	4279,	15115,	17016,	6517,	-2436,	-3189,	-574,
2258,	3169,	753,	-2991,	-4279,	-2972,	-4219,	-5725,
-6557,	-5052,	3803,	8161,	-872,	-8459,	-6874,	-6121,
-8043,	-5666,	-614,	574,	-2357,	-2694,	-2793,	-10756,
-17056,	-14005,	-8756,	-6616,	-3863,	1763,	6458,	6022,
1625,	-3348,	-6874,	-10222,	-17551,	-21474,	-15253,	-6478,
-2436,	792,	6240,	7943,	-812,	-16402,	-22860,	-18007,
-12836,	-10063,	-5547,	277,	1803,	-1882,	-5111,	-4556,
-2040,	-178,	2555,	6933,	6379,	1981,	2239,	6101,
6280,	4160,	2754,	-515,	-4200,	-6022,	-4378,	674,
2476,	-2139,	-9806,	-16026,	-18106,	-16244,	-11371,	-7528,
-4616,	1070,	7151,	6735,	-1743,	-8399,	-7448,	-6596,
-10281,	-11707,	-5943,	-297,	614,	2496,	5071,	3071,
-1307,	-79,	6181,	9291,	8498,	5666,	2298,	-59,
-3387,	-7726,	-9786,	-7112,	-872,	5448,	10638,	14322,
13530,	8300,	3744,	1347,	-3387,	-8716,	-9291,	-6834,
-6715,	-9548,	-10737,	-6418,	1743,	8795,	12896,	12619,
8479,	3823,	0,	-2674,	-2436,	-753,	-79,	-2080,
-6557,	-8479,	-4893,	2972,	10479,	13688,	13748,	13728,
12361,	4675,	-8894,	-18562,	-20404,	-18363,	-15273,	-9390,
-1882,	1882,	792,	-1347,	-1188,	-1030,	-2001,	-2734,
-2833,	-2694,	-4437,	-9409,	-14620,	-15848,	-13351,	-9231,
-5824,	-1208,	6240,	10677,	8181,	2674,	-436,	-713,
-1149,	-3368,	-4734,	-4200,	-3090,	-3229,	-4834,	-6220,
-7369,	-6914,	-5131,	-4734,	-6596,	-7805,	-7151,	-7805,
-11866,	-13887,	-11212,	-8994,	-9509,	-10974,	-10103,	-7627,
-6062,	-4576,	-2318,	-1149,	-2694,	-5745,	-7171,	-6181,
-5131,	-3902,	-1387,	792,	1208,	297,	-2674,	-6517,
-8597,	-8241,	-6260,	-3586,	-258,	2734,	3268,	-99,
-4259,	-5903,	-6339,	-6755,	-5467,	-1644,	2159,	3962,
3189,	1188,	-1010,	-3189,	-3487,	-1743,	-713,	-1644,
-2377,	-971,	1981,	3863,	4279,	4695,	6497,	8300,
7587,	4616,	1387,	-574,	-1605,	-2338,	-2813,	-3605,
-5190,	-5844,	-4378,	-753,	4437,	9013,	11390,	11529,
9509,	5289,	218,	-3427,	-5210,	-6379,	-6993,	-5883,
-2674,	40,	198,	-931,	-1228,	-812,	555,	2060,
1248,	-1030,	-2456,	-2239,	-2001,	-2496,	-2456,	-1822,
-1208,	852,	3566,	4675,	3665,	2219,	2338,	2298,
555,	-1941,	-2714,	-2040,	-2199,	-2952,	-2120,	456,
2575,	3229,	2833,	1842,	-59,	-2853,	-4061,	-3962,
-4834,	-6517,	-6577,	-4457,	-2496,	-1902,	-1862,	-832,
1248,	3150,	3724,	2813,	1605,	218,	-2040,	-4418,
-5646,	-4834,	-3110,	-1862,	-892,	40,	238,	733,
2932,	5725,	6973,	6399,	6181,	6478,	4853,	1208,
-1961,	-3407,	-3764,	-3288,	-1704,	277,	1149,	951,
555,	-198,	-1545,	-2397,	-1862,	-59,	1783,	2179,
1565,	971,	1050,	1089,	634,	574,	1288,	1208,
-40,	-654,	-119,	1743,	4239,	6795,	8399,	8181,
6260,	4101,	2773,	2872,	4101,	5923,	7746,	8023,
6260,	2773,	-317,	-1506,	-1466,	-872,	99,	1089,
1327,	911,	436,	277,	317,	396,	475,	574,
674,	1149,	1981,	2754,	2674,	1803,	1188,	1268,
1763,	2001,	2397,	3268,	4279,	4992,	5289,	5507,
4655,	2991,	1981,	1704,	1704,	1426,	773,	-238,
-892,	-1347,	-1169,	-931,	-674,	59,	178,	-297,
-1050,	-2159,	-3090,	-3011,	-2298,	-1446,	-456,	436,
436,	-337,	-1149,	-1585,	-1149,	-356,	-356,	-1149,
-1783,	-2060,	-1644,	-713,	594,	1466,	1129,	654,
733,	674,	396,	832,	1664,	1605,	139,	-2278,
-4655,	-6636,	-7706,	-7508,	-7329,	-6914,	-5745,	-4041,
-2773,	-872,	1406,	2516,	2853,	2001,	376,	-991,
-3803,	-7171,	-8023,	-6993,	-4576,	-1981,	-872,	-277,
356,	1129,	2674,	3467,	3546,	3546,	2417,	40,
-2397,	-3546,	-4338,	-5150,	-5666,	-4794,	-2892,	-1822,
-1842,	-1169,	99,	674,	515,	-356,	-1129,	-2080,
-3506,	-5309,	-6299,	-5606,	-4358,	-2239,	535,	1565,
436,	-1208,	-1446,	-456,	376,	-436,	-2674,	-4219,
-4279,	-3308,	-2872,	-3268,	-3348,	-2773,	-1327,	297,
1129,	1347,	1288,	971,	258,	-1188,	-3823,	-6161,
-7211,	-6715,	-5507,	-4834,	-3685,	-2001,	-1387,	-1109,
258,	1763,	2060,	1188,	-515,	-2833,	-4893,	-5883,
-5982,	-5725,	-4794,	-3031,	-1486,	-1367,	-1803,	-1921,
-2258,	-1506,	-59,	1585,	2001,	119,	-2714,	-5150,
-6656,	-7310,	-7547,	-6577,	-4101,	-1525,	-178,	-971,
-2120,	-2179,	-1486,	-713,	-475,	-456,	-1188,	-2853,
-4358,	-4259,	-2635,	-733,	515,	574,	79,	-317,
139,	535,	59,	-832,	-475,	654,	773,	159,
-436,	-753,	-832,	-693,	-337,	198,	317,	-317,
-1129,	-1585,	-1743,	-1565,	-1426,	-1149,	-198,	376,
178,	376,	1426,	1842,	991,	-416,	-1684,	-2476,
-3150,	-3526,	-3447,	-2199,	-416,	1783,	3685,	4576,
4675,	4081,	3110,	2159,	872,	-376,	-674,	-337,
495,	1664,	3110,	4516,	6161,	7508,	7389,	6596,
6399,	6280,	4734,	2754,	1506,	1288,	1129,	1030,
1070,	1208,	1704,	2338,	3348,	4299,	5408,	6280,
6260,	5408,	3705,	1803,	-277,	-1803,	-1921,	-991,
277,	1188,	2694,	4616,	5586,	5626,	5269,	4952,
4516,	3962,	3447,	2674,	1268,	356,	495,	1169,
1902,	3110,	4358,	4952,	4853,	4140,	3189,	2516,
2298,	2476,	2417,	1763,	1327,	1149,	991,	1030,
1684,	2773,	3744,	4279,	4021,	3328,	2773,	2436,
2120,	2258,	2595,	2674,	2694,	2952,	3288,	3566,
3744,	3783,	3922,	4041,	4021,	3566,	2833,	1822,
1129,	971,	1446,	2159,	2199,	1486,	396,	-515,
-832,	-594,	277,	1347,	1941,	1981,	1605,	991,
238,	-297,	-674,	-416,	0,	475,	1050,	1426,
2120,	2536,	2575,	1981,	1426,	1426,	1426,	951,
436,	614,	1288,	1684,	1763,	1882,	2179,	2714,
2793,	2654,	2100,	1644,	1525,	1010,	416,	218,
218,	99,	99,	495,	773,	693,	594,	911,
1169,	971,	812,	376,	-376,	-654,	-396,	-59,
277,	1010,	2001,	2436,	2436,	2456,	1664,	733,
297,	-139,	-713,	-1208,	-991,	-614,	-674,	-792,
-594,	-614,	-475,	-515,	-456,	-495,	-1089,	-1743,
-2139,	-1862,	-1585,	-1426,	-1426,	-1208,	-495,	475,
1050,	1466,	1763,	1664,	1010,	0,	-594,	-792,
-1030,	-1050,	-654,	-139,	139,	594,	1684,	3031,
3447,	2952,	2456,	1842,	852,	-832,	-2417,	-3031,
-2417,	-1327,	-753,	-495,	277,	1406,	2120,	2714,
2258,	1109,	456,	297,	-297,	-1684,	-2536,	-2377,
-1466,	-416,	79,	317,	535,	753,	1050,	1129,
1426,	1466,	634,	-456,	-812,	-555,	-356,	-515,
-911,	-852,	-79,	20,	-594,	-337,	297,	475,
178,	-20,	-416,	-832,	-931,	-832,	-159,	20,
-991,	-1921,	-1664,	-594,	773,	1783,	2080,	1704,
1030,	456,	238,	0,	-317,	-436,	-297,	456,
1248,	1644,	1070,	832,	1525,	1941,	1387,	376,
0,	436,	1030,	733,	-396,	-1367,	-1763,	-1862,
-1842,	-1545,	-812,	-238,	-119,	-436,	-456,	-139,
-218,	-693,	-1327,	-1486,	-1347,	-1367,	-1228,	-852,
-277,	20,	40,	258,	337,	396,	258,	456,
931,	1010,	416,	-99,	178,	456,	436,	436,
416,	495,	475,	555,	1109,	1426,	1268,	852,
218,	-277,	-1089,	-1684,	-1446,	-654,	-119,	-79,
-139,	-40,	59,	-139,	-436,	-1010,	-1625,	-1882,
-1704,	-1327,	-1506,	-1921,	-1783,	-1030,	-337,	-119,
-40,	-99,	-634,	-1684,	-2853,	-3308,	-3268,	-2654,
-1664,	-733,	-317,	-574,	-1149,	-1446,	-1664,	-2139,
-2456,	-2734,	-2932,	-3090,	-3229,	-3110,	-2793,	-2377,
-1723,	-1169,	-951,	-1010,	-1268,	-1981,	-2456,	-2496,
-2496,	-2318,	-2080,	-1921,	-2120,	-1941,	-1347,	-773,
-40,	574,	971,	1010,	475,	-277,	-1208,	-2021,
-2476,	-2516,	-2338,	-1902,	-1664,	-1486,	-1268,	-951,
-535,	-456,	-634,	-753,	-1050,	-1486,	-1605,	-1882,
-2120,	-2516,	-2714,	-2496,	-2001,	-1605,	-1525,	-1466,
-1248,	-1169,	-1109,	-1169,	-1347,	-1565,	-1902,	-1684,
-1248,	-1129,	-1208,	-991,	-852,	-1208,	-1625,	-1961,
-1704,	-1466,	-1545,	-1684,	-1941,	-2100,	-1941,	-1426,
-753,	-495,	-376,	-159,	-79,	-376,	-872,	-1288,
-1605,	-1565,	-1605,	-1565,	-1030,	-614,	-594,	-317,
317,	892,	1050,	555,	119,	-218,	-238,	-297,
-238,	-218,	-337,	-872,	-1506,	-1842,	-1803,	-1030,
-178,	436,	475,	356,	0,	-614,	-971,	-1129,
-1605,	-2159,	-2417,	-2357,	-2080,	-1446,	-634,	198,
753,	555,	-258,	-892,	-1446,	-1763,	-1565,	-1109,
-832,	-614,	-356,	-277,	-139,	-79,	337,	951,
1347,	1307,	852,	-59,	-555,	-495,	-396,	-535,
-931,	-852,	-654,	-356,	79,	376,	416,	337,
396,	198,	-574,	-1248,	-1466,	-1288,	-1307,	-1288,
-1188,	-1149,	-1169,	-1347,	-812,	-238,	-178,	-297,
-773,	-1288,	-1664,	-2001,	-2258,	-2159,	-1625,	-1050,
-1010,	-1248,	-1188,	-1109,	-1545,	-2040,	-2357,	-2060,
-1446,	-1268,	-1466,	-1525,	-1288,	-1129,	-1387,	-1684,
-1188,	-416,	-20,	-119,	59,	218,	20,	-654,
-1367,	-1743,	-1803,	-1545,	-1446,	-1248,	-713,	277,
1010,	991,	456,	-258,	-1089,	-1605,	-1882,	-1961,
-1902,	-2298,	-2219,	-1723,	-1208,	-1188,	-1268,	-1387,
-1188,	-852,	-1129,	-1625,	-2278,	-2892,	-3169,	-2972,
-2436,	-2139,	-2258,	-1941,	-1486,	-971,	-872,	-1030,
-1089,	-1268,	-1723,	-2080,	-2021,	-1961,	-2021,	-2357,
-2635,	-2239,	-1506,	-872,	-218,	317,	396,	0,
-674,	-1268,	-1902,	-2476,	-2654,	-2258,	-1723,	-1426,
-1466,	-1446,	-1089,	-634,	-99,	-79,	-139,	-99,
-495,	-1208,	-1625,	-1783,	-1822,	-1921,	-1723,	-1486,
-1129,	-792,	-515,	-20,	376,	674,	832,	436,
-119,	-773,	-1466,	-1842,	-1822,	-1466,	-1070,	-376,
495,	1030,	1208,	1347,	1050,	832,	674,	277,
-59,	-436,	-792,	-773,	-555,	-337,	-20,	713,
1387,	1664,	1248,	911,	634,	535,	654,	535,
317,	218,	614,	733,	535,	515,	594,	892,
1327,	1921,	1822,	1585,	1347,	1188,	1010,	872,
753,	594,	852,	1050,	1149,	1149,	1426,	1842,
1862,	1466,	1248,	1188,	1169,	792,	515,	436,
555,	832,	1070,	971,	634,	594,	654,	713,
812,	1109,	1426,	1486,	1089,	991,	852,	337,
79,	99,	416,	654,	991,	1169,	1109,	713,
396,	258,	555,	892,	594,	297,	0,	-159,
-20,	356,	792,	1347,	1347,	1228,	1030,	515,
-40,	-139,	238,	495,	852,	911,	1149,	1288,
1188,	1030,	654,	376,	515,	456,	20,	-396,
-198,	178,	396,	574,	892,	991,	852,	753,
515,	515,	416,	178,	40,	-59,	-218,	-238,
-119,	-99,	119,	396,	515,	475,	277,	258,
376,	337,	218,	-20,	-258,	-456,	-396,	0,
356,	674,	773,	753,	594,	475,	594,	713,
713,	356,	79,	-79,	-218,	-258,	-40,	555,
1268,	1585,	1565,	1426,	1288,	1545,	1684,	1605,
1426,	1070,	594,	119,	-297,	-614,	-436,	-139,
337,	951,	1347,	1506,	1565,	1625,	1367,	911,
436,	99,	-79,	-178,	-198,	-139,	159,	555,
594,	495,	693,	693,	594,	614,	535,	178,
-317,	-317,	-59,	20,	-139,	-436,	-277,	159,
495,	713,	713,	911,	1010,	991,	674,	139,
0,	-297,	-495,	-713,	-654,	-416,	0,	79,
-159,	-277,	-416,	-674,	-1070,	-1188,	-1109,	-872,
-812,	-951,	-1208,	-1466,	-1486,	-1486,	-1288,	-654,
139,	376,	356,	-99,	-812,	-1208,	-1525,	-1446,
-1288,	-1169,	-753,	-515,	-594,	-614,	-456,	-337,
-238,	-297,	-258,	-59,	-79,	-654,	-1109,	-1089,
-991,	-792,	-693,	-535,	-574,	-693,	-911,	-1208,
-1050,	-515,	79,	198,	-99,	-297,	-753,	-1248,
-1684,	-1882,	-1288,	-495,	159,	277,	-59,	-356,
-495,	-356,	-99,	218,	693,	852,	396,	0,
-79,	79,	218,	356,	693,	1188,	1426,	1109,
535,	119,	139,	238,	456,	555,	792,	911,
753,	634,	674,	634,	376,	277,	218,	238,
-40,	-258,	-218,	119,	139,	40,	218,	614,
991,	931,	931,	1010,	1070,	792,	674,	376,
178,	99,	79,	139,	139,	475,	911,	872,
515,	238,	218,	198,	258,	317,	178,	277,
356,	277,	59,	99,	-99,	-535,	-832,	-535,
-277,	-99,	-139,	-20,	317,	139,	-40,	-555,
-852,	-713,	-416,	-178,	198,	456,	317,	20,
-59,	40,	119,	-119,	-139,	-59,	-277,	-297,
-258,	-40,	59,	0,	59,	0,	-40,	-20,
-20,	-99,	79,	297,	40,	-456,	-792,	-753,
-475,	-337,	-396,	-139,	159,	376,	376,	594,
812,	1129,	1228,	1070,	991,	931,	634,	159,
-99,	-119,	416,	1030,	1169,	991,	713,	594,
674,	832,	1208,	1565,	1684,	1129,	59,	-634,
-852,	-733,	-594,	-218,	297,	792,	1089,	1149,
1070,	1248,	1288,	951,	376,	-20,	-79,	-218,
-258,	-20,	396,	991,	1109,	832,	495,	258,
159,	159,	198,	258,	258,	198,	139,	297,
555,	614,	574,	436,	99,	-119,	139,	594,
832,	574,	376,	218,	0,	-238,	-79,	376,
693,	832,	1010,	991,	495,	-218,	-396,	-139,
297,	892,	1208,	1089,	634,	59,	-238,	-317,
-238,	-159,	-79,	-198,	-436,	-535,	-436,	0,
555,	713,	416,	159,	-317,	-971,	-1545,	-1644,
-1367,	-1050,	-892,	-1149,	-1406,	-1248,	-436,	139,
258,	317,	277,	59,	-356,	-693,	-872,	-951,
-1307,	-1466,	-1506,	-1367,	-1010,	-436,	159,	555,
674,	555,	79,	-753,	-1288,	-1822,	-2120,	-2258,
-2258,	-1981,	-1466,	-1030,	-971,	-832,	-654,	-634,
-832,	-1268,	-1605,	-1882,	-2080,	-2021,	-2001,	-2001,
-1664,	-1188,	-792,	-456,	-119,	139,	238,	139,
-356,	-693,	-951,	-1208,	-1426,	-1882,	-2199,	-2080,
-1684,	-1387,	-991,	-713,	-198,	79,	-218,	-931,
-1664,	-2179,	-2199,	-2001,	-2021,	-1783,	-1268,	-951,
-654,	-713,	-832,	-951,	-1030,	-1149,	-1169,	-832,
-594,	-515,	-872,	-1406,	-1605,	-1347,	-971,	-872,
-911,	-574,	-178,	-40,	99,	218,	119,	-198,
-634,	-812,	-852,	-1030,	-1228,	-1545,	-1862,	-1941,
-1842,	-1605,	-1426,	-1288,	-1109,	-1030,	-1129,	-1426,
-1644,	-1743,	-1961,	-2179,	-2219,	-2338,	-2179,	-2060,
-2040,	-1664,	-1030,	-139,	456,	317,	-159,	-574,
-1109,	-1625,	-2159,	-2338,	-2179,	-2060,	-2040,	-1723,
-1050,	-198,	119,	-20,	-178,	-693,	-1406,	-2179,
-2595,	-2872,	-2754,	-2258,	-1882,	-1506,	-1228,	-911,
-396,	-297,	-337,	-119,	-79,	-456,	-1109,	-1248,
-1307,	-1347,	-1347,	-1050,	-456,	258,	971,	1387,
1387,	1248,	852,	317,	-119,	-416,	-614,	-535,
-258,	-198,	277,	693,	1050,	1387,	1605,	1684,
1525,	1109,	614,	59,	-436,	-574,	-535,	-218,
-20,	277,	812,	1089,	1268,	1288,	1347,	1228,
1129,	911,	555,	396,	119,	0,	178,	515,
911,	1089,	1149,	1149,	1010,	951,	1030,	1248,
1268,	1089,	753,	376,	139,	139,	535,	1050,
1426,	1723,	2060,	1882,	1347,	1089,	1208,	1406,
1050,	693,	654,	931,	1288,	1327,	1466,	1822,
2021,	1981,	1882,	1644,	1605,	1822,	1763,	1585,
1327,	1129,	951,	951,	872,	1109,	1506,	1684,
2060,	2199,	2239,	2001,	1684,	1625,	1565,	1347,
1010,	792,	832,	951,	1089,	1248,	1723,	2139,
2595,	2635,	2219,	1763,	1625,	1565,	1387,	1149,
892,	1109,	1347,	1565,	1743,	1941,	2219,	2615,
2714,	2417,	1921,	1387,	1248,	1149,	1367,	1466,
1268,	1466,	1565,	1783,	1902,	2040,	2456,	2793,
2773,	2516,	1921,	1288,	832,	238,	-277,	-159,
218,	713,	1169,	1545,	2159,	2456,	2496,	2357,
1921,	1426,	1030,	594,	654,	773,	852,	1010,
1228,	1545,	1743,	2120,	2456,	2714,	2754,	2536,
2179,	1902,	1803,	1763,	1783,	1426,	1248,	1288,
1605,	2298,	3011,	3249,	3288,	3209,	2991,	2476,
1664,	1109,	931,	971,	1169,	1664,	2080,	2635,
2813,	2694,	2654,	2793,	3011,	2575,	1763,	1169,
1169,	1288,	1486,	1783,	1941,	2357,	2575,	2872,
2892,	2892,	2754,	2516,	2536,	2377,	1921,	1149,
654,	614,	931,	1208,	1446,	1862,	2318,	2516,
2575,	2456,	2060,	1704,	1248,	713,	277,	-119,
-555,	-555,	-99,	356,	971,	1585,	1981,	2060,
1822,	1426,	971,	416,	-178,	-674,	-792,	-753,
-574,	-159,	356,	654,	674,	753,	832,	792,
574,	238,	20,	-238,	-574,	-911,	-911,	-495,
-79,	277,	693,	1030,	1169,	1149,	1010,	911,
773,	337,	-396,	-674,	-951,	-1208,	-1109,	-792,
-119,	555,	1089,	1188,	991,	872,	733,	535,
436,	159,	-337,	-991,	-1347,	-1486,	-1585,	-1446,
-911,	178,	812,	1030,	1010,	971,	832,	535,
317,	-40,	-475,	-1129,	-1803,	-2001,	-1545,	-852,
119,	1109,	1684,	1763,	1406,	931,	456,	-59,
-614,	-832,	-892,	-733,	-634,	-535,	-317,	198,
812,	1406,	1268,	812,	436,	40,	-79,	-356,
-456,	-555,	-475,	-139,	99,	59,	79,	337,
535,	931,	1070,	1010,	753,	317,	-258,	-555,
-634,	-594,	-139,	79,	337,	416,	376,	198,
99,	139,	99,	-218,	-356,	-515,	-812,	-1050,
-991,	-614,	-297,	59,	416,	713,	773,	634,
337,	376,	456,	376,	-59,	-178,	218,	733,
1248,	1109,	693,	535,	416,	515,	852,	852,
515,	297,	436,	872,	832,	475,	456,	634,
1030,	1188,	1089,	951,	832,	773,	654,	594,
456,	396,	317,	119,	198,	693,	1307,	1545,
1268,	1050,	892,	733,	693,	416,	20,	-119,
178,	337,	277,	356,	634,	812,	1109,	1248,
1268,	1367,	1327,	1268,	852,	773,	872,	832,
674,	792,	1030,	1070,	1070,	1188,	1327,	1188,
1208,	1585,	1704,	1605,	1506,	1307,	1169,	971,
693,	416,	574,	951,	1307,	1248,	1010,	812,
971,	1089,	892,	654,	436,	674,	773,	574,
614,	693,	495,	258,	139,	436,	931,	1070,
931,	852,	971,	911,	297,	-436,	-832,	-594,
-297,	0,	258,	555,	654,	396,	475,	535,
574,	495,	59,	-396,	-555,	-535,	-555,	-674,
-515,	-139,	277,	495,	436,	297,	198,	0,
-159,	-456,	-674,	-555,	-416,	-634,	-674,	-753,
-614,	-20,	317,	396,	277,	-40,	-654,	-1070,
-1149,	-971,	-911,	-892,	-931,	-773,	-317,	-119,
-119,	-198,	-535,	-872,	-951,	-872,	-773,	-812,
-971,	-773,	-416,	-178,	317,	832,	1109,	1208,
1228,	852,	238,	-535,	-1327,	-1545,	-1327,	-991,
-654,	-198,	277,	238,	119,	40,	178,	258,
297,	159,	-59,	-198,	-317,	-456,	-713,	-713,
-356,	-40,	0,	20,	-198,	-159,	0,	-40,
-218,	-574,	-852,	-1268,	-1684,	-1743,	-1426,	-733,
-198,	20,	-238,	-674,	-911,	-1188,	-1387,	-1486,
-1387,	-1367,	-1545,	-1822,	-1862,	-1902,	-1981,	-2001,
-1743,	-1387,	-1070,	-1070,	-1248,	-1525,	-1902,	-2120,
-2080,	-2040,	-2001,	-2179,	-2357,	-2338,	-2199,	-2120,
-1981,	-1466,	-1010,	-812,	-713,	-1129,	-1506,	-1723,
-1842,	-1941,	-2080,	-2120,	-2139,	-2120,	-2080,	-2139,
-2060,	-1961,	-1921,	-1842,	-1723,	-1644,	-1803,	-1981,
-2239,	-2456,	-2773,	-2872,	-2872,	-2555,	-2080,	-1426,
-872,	-773,	-693,	-733,	-733,	-892,	-1010,	-1268,
-1565,	-1902,	-2120,	-2021,	-1446,	-892,	-238,	139,
218,	119,	99,	-178,	-634,	-852,	-1129,	-1089,
-1070,	-1327,	-1307,	-991,	-495,	198,	753,	1109,
1010,	852,	812,	555,	277,	-59,	-456,	-832,
-1109,	-1169,	-1030,	-594,	99,	911,	1783,	2219,
2080,	1664,	1070,	594,	238,	0,	-178,	-198,
-198,	-139,	218,	574,	1228,	1763,	2179,	2199,
2001,	1763,	1248,	376,	-79,	-159,	-119,	198,
396,	535,	733,	1070,	1545,	2080,	2397,	2397,
2100,	1446,	872,	258,	-20,	159,	515,	951,
1466,	1704,	1921,	2120,	2456,	2615,	2674,	2694,
2318,	1644,	892,	376,	436,	773,	1070,	1327,
1565,	1902,	2219,	2338,	2338,	2397,	2120,	1763,
1387,	852,	475,	317,	574,	792,	911,	1109,
1268,	1387,	1605,	1822,	1902,	1981,	1783,	1585,
1188,	773,	475,	218,	297,	713,	991,	1070,
1169,	1248,	1426,	1367,	1426,	1605,	1605,	1367,
1089,	773,	614,	614,	574,	693,	832,	872,
812,	792,	832,	971,	1050,	1089,	1050,	1089,
1089,	951,	892,	792,	674,	713,	971,	1248,
1644,	1803,	1921,	1684,	1387,	991,	614,	436,
495,	1010,	1387,	1545,	1605,	1565,	1367,	1307,
1486,	1842,	1842,	1367,	1070,	931,	852,	753,
733,	1089,	1327,	1426,	1387,	1387,	1406,	1426,
1387,	1288,	1406,	1406,	1367,	1268,	1208,	1169,
1466,	1743,	1921,	2001,	1882,	1525,	1268,	1228,
1169,	1367,	1387,	1426,	1268,	931,	931,	1070,
1188,	1089,	1149,	1307,	1228,	1030,	733,	594,
555,	594,	535,	535,	555,	792,	951,	792,
713,	654,	812,	991,	931,	911,	832,	792,
773,	634,	594,	495,	178,	0,	79,	119,
0,	258,	654,	892,	892,	555,	515,	654,
693,	594,	555,	634,	733,	654,	277,	-40,
-258,	-238,	-238,	-79,	356,	1010,	1248,	1188,
1089,	991,	892,	753,	674,	555,	297,	119,
-139,	-376,	-396,	-119,	416,	1109,	1565,	1525,
1109,	436,	139,	119,	198,	139,	178,	119,
139,	396,	594,	812,	971,	1268,	1486,	1506,
1288,	852,	139,	-198,	-277,	-238,	79,	475,
931,	1288,	1466,	1506,	1327,	1089,	1188,	951,
693,	416,	238,	40,	-20,	317,	812,	1486,
1743,	1862,	1941,	1822,	1466,	971,	634,	356,
436,	436,	614,	792,	951,	1129,	1288,	1565,
1644,	1664,	1446,	1208,	1050,	654,	396,	337,
376,	594,	892,	1070,	1109,	872,	574,	416,
396,	436,	574,	654,	436,	198,	59,	59,
119,	297,	317,	475,	713,	733,	634,	475,
495,	654,	535,	634,	713,	515,	139,	-40,
-99,	-20,	0,	20,	178,	258,	139,	40,
119,	258,	456,	475,	376,	99,	40,	-277,
-475,	-317,	-277,	-20,	139,	198,	159,	59,
99,	79,	-40,	-159,	-178,	-337,	-376,	-119,
218,	436,	614,	614,	614,	515,	416,	396,
317,	258,	258,	198,	258,	436,	555,	555,
376,	356,	495,	674,	812,	1089,	971,	634,
297,	20,	-198,	-297,	20,	594,	1149,	1367,
1248,	1169,	1050,	931,	1307,	1585,	1585,	1188,
773,	535,	356,	416,	753,	1208,	1367,	1525,
1644,	1446,	1387,	1367,	1426,	1525,	1466,	1406,
1030,	634,	594,	515,	693,	1070,	1525,	1585,
1367,	1109,	773,	792,	753,	733,	911,	1010,
951,	872,	832,	911,	1030,	1248,	1525,	1525,
1525,	1446,	1188,	931,	773,	614,	436,	456,
614,	852,	1089,	1268,	1307,	1367,	1268,	1169,
911,	574,	317,	258,	396,	456,	416,	238,
258,	258,	218,	59,	-79,	79,	159,	356,
337,	0,	-119,	-198,	-356,	-258,	-178,	-139,
-159,	-40,	-20,	-99,	-317,	-654,	-574,	-574,
-693,	-872,	-872,	-792,	-892,	-753,	-555,	-218,
119,	79,	20,	-119,	-258,	-515,	-773,	-1010,
-1129,	-991,	-792,	-495,	-277,	-159,	-159,	-198,
-238,	-218,	-337,	-634,	-773,	-812,	-991,	-1010,
-773,	-773,	-614,	-515,	-456,	-139,	-99,	-20,
-159,	-297,	-337,	-574,	-852,	-1268,	-1307,	-1030,
-654,	-159,	99,	159,	159,	-99,	-337,	-693,
-792,	-792,	-773,	-832,	-1070,	-1050,	-951,	-1010,
-1010,	-1169,	-1109,	-892,	-614,	-515,	-713,	-951,
-1030,	-1070,	-1188,	-1387,	-1565,	-1704,	-1862,	-1625,
-1367,	-1089,	-951,	-951,	-1149,	-1506,	-1585,	-1426,
-1525,	-1664,	-1763,	-1783,	-1961,	-2159,	-2199,	-2199,
-1961,	-1803,	-1486,	-1169,	-1268,	-1466,	-1822,	-2179,
-2575,	-2635,	-2496,	-2338,	-2179,	-2239,	-2318,	-2377,
-2179,	-2001,	-2139,	-2139,	-2139,	-2258,	-2674,	-2773,
-2674,	-2357,	-2080,	-1842,	-1961,	-2318,	-2694,	-2793,
-2536,	-2179,	-1684,	-1545,	-1605,	-1723,	-1803,	-1981,
-2100,	-1941,	-1882,	-1822,	-1902,	-2239,	-2179,	-1862,
-1565,	-1367,	-1248,	-1208,	-1248,	-1406,	-1664,	-1684,
-1783,	-1684,	-1545,	-1228,	-1129,	-1089,	-911,	-931,
-892,	-773,	-515,	-574,	-872,	-1248,	-1585,	-1704,
-1664,	-1446,	-1129,	-713,	-376,	-376,	-475,	-654,
-911,	-1050,	-1149,	-1248,	-1169,	-1050,	-1010,	-1030,
-753,	-456,	-159,	99,	277,	317,	-59,	-356,
-654,	-911,	-971,	-872,	-574,	-317,	99,	475,
594,	594,	297,	119,	-159,	-396,	-495,	-753,
-852,	-654,	-376,	-218,	-59,	20,	139,	337,
574,	396,	376,	337,	238,	59,	-258,	-475,
-594,	-555,	-614,	-654,	-356,	0,	396,	792,
1030,	1109,	931,	614,	297,	159,	-79,	-337,
-456,	-535,	-456,	-337,	-40,	297,	436,	416,
277,	178,	99,	20,	-99,	-218,	-119,	-198,
-178,	-297,	-337,	-277,	-218,	-277,	-238,	-258,
-258,	-178,	-337,	-535,	-812,	-971,	-1070,	-931,
-634,	-416,	-218,	-99,	178,	258,	178,	-59,
-198,	-337,	-456,	-535,	-674,	-753,	-812,	-614,
-297,	-79,	59,	159,	59,	-79,	-258,	-594,
-614,	-436,	-258,	-297,	-456,	-475,	-495,	-594,
-733,	-892,	-812,	-614,	-436,	-178,	-79,	-20,
-20,	59,	119,	-119,	-356,	-456,	-297,	-258,
-258,	-20,	277,	317,	416,	218,	119,	258,
317,	99,	-20,	79,	40,	0,	-79,	-99,
-139,	40,	139,	59,	-99,	-159,	-119,	-79,
-79,	139,	258,	238,	40,	-79,	-178,	-40,
198,	198,	218,	238,	218,	198,	258,	297,
416,	495,	198,	159,	218,	198,	218,	159,
59,	79,	119,	-20,	-79,	-59,	79,	40,
40,	-40,	-20,	-238,	-416,	-753,	-991,	-1030,
-911,	-614,	-396,	-277,	-99,	-178,	-356,	-495,
-911,	-1188,	-1268,	-1149,	-991,	-911,	-792,	-574,
-356,	-59,	0,	-238,	-495,	-634,	-674,	-574,
-654,	-733,	-753,	-872,	-733,	-693,	-872,	-832,
-634,	-495,	-396,	-456,	-574,	-674,	-892,	-1050,
-951,	-951,	-931,	-991,	-1070,	-892,	-713,	-555,
-456,	-574,	-654,	-733,	-674,	-832,	-1129,	-1050,
-991,	-733,	-674,	-654,	-555,	-198,	-40,	-178,
-317,	-416,	-475,	-535,	-634,	-792,	-713,	-555,
-416,	-396,	-356,	-436,	-495,	-456,	-317,	-99,
139,	297,	356,	238,	79,	-59,	-79,	-159,
-356,	-396,	-119,	20,	-99,	-159,	-198,	-159,
-297,	-356,	-297,	-238,	-79,	178,	376,	396,
337,	79,	79,	-79,	-258,	-376,	-376,	-376,
-515,	-535,	-337,	-178,	-40,	-99,	-40,	178,
238,	218,	59,	-139,	-238,	-159,	-198,	-317,
-475,	-654,	-574,	-574,	-515,	-159,	20,	99,
-79,	-159,	-79,	40,	178,	159,	218,	79,
-218,	-555,	-1089,	-1268,	-812,	-317,	0,	178,
297,	376,	356,	297,	159,	-40,	-337,	-515,
-594,	-634,	-674,	-535,	-317,	99,	218,	317,
178,	20,	-99,	-356,	-297,	-356,	-356,	-535,
-634,	-614,	-515,	-178,	139,	495,	574,	515,
317,	20,	-198,	-515,	-773,	-812,	-812,	-733,
-535,	-20,	337,	555,	574,	456,	218,	-139,
-337,	-594,	-594,	-495,	-436,	-238,	-20,	178,
456,	654,	773,	753,	654,	535,	79,	-258,
-297,	-277,	-376,	-356,	-277,	-218,	119,	456,
872,	1030,	971,	773,	317,	-59,	-515,	-852,
-931,	-911,	-753,	-495,	-277,	0,	238,	218,
178,	159,	198,	20,	-198,	-416,	-594,	-555,
-555,	-396,	-198,	-99,	-20,	20,	40,	-59,
-198,	-297,	-456,	-674,	-931,	-1169,	-1288,	-1188,
-773,	-515,	-99,	218,	159,	-20,	-356,	-475,
-535,	-674,	-753,	-753,	-654,	-614,	-574,	-258,
-198,	-99,	59,	238,	277,	317,	178,	0
};

__eds__ __attribute__((space(prog))) int16_t SAMPLE_key_hammer3[sample_length] = {
-635,	-741,	-801,	-907,	-983,	-1013,	-1104,	-1119,
-1058,	-1119,	-1104,	-983,	-877,	-907,	-892,	-726,
-696,	-801,	-953,	-1058,	-968,	-937,	-998,	-983,
-1058,	-1028,	-1255,	-1376,	-1361,	-1452,	-1542,	-1497,
-1467,	-1391,	-1073,	-968,	-937,	-983,	-922,	-877,
-862,	-892,	-922,	-847,	-1089,	-1255,	-1452,	-1391,
-1104,	-1104,	-1058,	-1179,	-1391,	-1482,	-1482,	-1527,
-1572,	-1527,	-1482,	-1588,	-1663,	-1678,	-1693,	-1739,
-1739,	-1724,	-1678,	-1799,	-2041,	-1981,	-1935,	-1815,
-1905,	-2071,	-1920,	-1769,	-1709,	-2011,	-2011,	-1890,
-1905,	-1815,	-1769,	-1830,	-1799,	-1678,	-1527,	-1557,
-1588,	-1572,	-1633,	-1724,	-1557,	-1285,	-1089,	-1073,
-1119,	-1119,	-1164,	-1195,	-1179,	-998,	-1058,	-953,
-832,	-801,	-756,	-726,	-696,	-756,	-559,	-605,
-529,	-423,	-469,	-529,	-514,	-484,	-590,	-635,
-484,	-469,	-438,	-484,	-665,	-756,	-832,	-801,
-817,	-847,	-907,	-771,	-711,	-817,	-968,	-1028,
-953,	-892,	-862,	-922,	-1028,	-953,	-922,	-968,
-1225,	-1346,	-1346,	-1467,	-1527,	-1693,	-1935,	-2313,
-2979,	-3402,	-3674,	-4083,	-4657,	-5186,	-5776,	-6048,
-6063,	-5958,	-5640,	-5277,	-4627,	-3825,	-3236,	-2465,
-1920,	-1784,	-1709,	-2132,	-2918,	-3659,	-4340,	-5141,
-6063,	-6638,	-6728,	-6880,	-6819,	-6229,	-5368,	-4642,
-4128,	-3417,	-2450,	-1331,	-378,	302,	544,	499,
741,	832,	559,	121,	-212,	-151,	76,	45,
106,	741,	1316,	1860,	2404,	3190,	3825,	4158,
4385,	4264,	4264,	4037,	3720,	3644,	3614,	3841,
4128,	4355,	4839,	5080,	5201,	5126,	5156,	5247,
5035,	4612,	4113,	3961,	4113,	4234,	4748,	5489,
6381,	7228,	8301,	9450,	10342,	11068,	11658,	12066,
12051,	11794,	11688,	11567,	11703,	11990,	12338,	12943,
13593,	14032,	14183,	14183,	14122,	14243,	14138,	13533,
12777,	12081,	11431,	11824,	12172,	11854,	11537,	11945,
12807,	13336,	13321,	13472,	14002,	13986,	12550,	10962,
10342,	9813,	8694,	7046,	5262,	3735,	2752,	1830,
983,	469,	393,	514,	862,	1663,	2646,	3689,
4733,	5821,	6713,	7424,	8090,	8422,	8316,	7847,
7439,	6487,	5111,	4128,	3402,	2223,	862,	-242,
-998,	-1043,	-1013,	-1270,	-892,	0,	968,	1557,
1890,	2601,	3584,	4113,	4098,	3931,	3659,	3039,
2207,	1179,	272,	-469,	-1512,	-2404,	-3236,	-4052,
-4763,	-5413,	-5791,	-6109,	-6139,	-5942,	-5594,	-5201,
-4975,	-4627,	-4098,	-3584,	-3009,	-1981,	-665,	-45,
-121,	-166,	-45,	-469,	-1754,	-2873,	-3523,	-4007,
-4899,	-5731,	-6199,	-6623,	-6834,	-7001,	-6789,	-6320,
-5958,	-5489,	-4612,	-3931,	-3357,	-3054,	-2797,	-2359,
-1799,	-1300,	-892,	-423,	-423,	-575,	-847,	-998,
-1542,	-2268,	-2646,	-2933,	-3372,	-3659,	-3856,	-4158,
-4370,	-4703,	-4703,	-4808,	-4959,	-4839,	-4778,	-4672,
-4839,	-5413,	-5942,	-6502,	-6895,	-7001,	-6956,	-6759,
-6305,	-6048,	-5761,	-5247,	-4597,	-4007,	-3402,	-2404,
-1542,	-1149,	-1255,	-1134,	-892,	-590,	-423,	-182,
182,	469,	650,	605,	363,	0,	-423,	-756,
-862,	-922,	-922,	-1134,	-1421,	-1572,	-1618,	-1709,
-1935,	-2117,	-2313,	-2510,	-2752,	-3024,	-3251,	-3372,
-3478,	-3281,	-2873,	-2313,	-1512,	-756,	-61,	499,
1058,	1739,	2162,	2117,	2313,	2812,	3221,	3417,
3145,	3039,	2827,	2601,	2374,	2177,	2283,	2313,
2162,	1830,	1452,	1134,	756,	559,	287,	197,
242,	242,	302,	197,	-76,	-590,	-1149,	-1784,
-1996,	-2344,	-2873,	-3659,	-4294,	-4823,	-5610,	-6093,
-6472,	-6396,	-6381,	-6532,	-6789,	-6956,	-7092,	-7288,
-7560,	-7651,	-7591,	-7621,	-7711,	-7999,	-8316,	-8755,
-9117,	-9420,	-9556,	-9571,	-9556,	-9465,	-9526,	-9844,
-9949,	-9874,	-9859,	-9980,	-9964,	-9889,	-9919,	-10312,
-10856,	-11280,	-11854,	-12157,	-12323,	-12504,	-12988,	-13306,
-13790,	-14380,	-14757,	-15287,	-15786,	-16073,	-16345,	-16391,
-16224,	-15892,	-15589,	-15483,	-15090,	-14637,	-14077,	-13533,
-12943,	-12323,	-11945,	-11749,	-11658,	-11718,	-11718,	-11658,
-11507,	-11234,	-10887,	-10766,	-10690,	-10539,	-10433,	-10251,
-9889,	-9526,	-8997,	-8467,	-7983,	-7409,	-7076,	-6577,
-6048,	-5534,	-5186,	-5005,	-4778,	-4748,	-4839,	-5020,
-5353,	-5594,	-5625,	-5670,	-5640,	-5625,	-5262,	-5020,
-4733,	-4294,	-3961,	-3432,	-3085,	-2737,	-2253,	-1799,
-1361,	-1134,	-1134,	-1119,	-1149,	-1179,	-1240,	-1270,
-1376,	-1512,	-1663,	-1724,	-1754,	-1830,	-1709,	-1678,
-1618,	-1331,	-1195,	-998,	-756,	-499,	-151,	318,
892,	1542,	2223,	3024,	3735,	4113,	4551,	4990,
5398,	5806,	6048,	6366,	6789,	7182,	7454,	7666,
7817,	7787,	7893,	8195,	8301,	8437,	8377,	8211,
8346,	8271,	8211,	8256,	8271,	8256,	8407,	8392,
8558,	8679,	8694,	8876,	8846,	9057,	9254,	9465,
9722,	10010,	10131,	10236,	10509,	10766,	10856,	10947,
11083,	11129,	11204,	11234,	11250,	11098,	10947,	10826,
10811,	10705,	10418,	10176,	10040,	9768,	9345,	8951,
8437,	8074,	7727,	7258,	6789,	6245,	5715,	5111,
4400,	3795,	3402,	2888,	2450,	2313,	2192,	2071,
2147,	2147,	2268,	2616,	2722,	2797,	2843,	2964,
2933,	3039,	3160,	3115,	3070,	2918,	2918,	2858,
2540,	2344,	2026,	1603,	1149,	469,	-121,	-650,
-1104,	-1572,	-2283,	-2918,	-3523,	-4037,	-4612,	-5217,
-5897,	-6547,	-6910,	-7152,	-7485,	-7878,	-8044,	-8150,
-8180,	-8150,	-8256,	-8362,	-8226,	-8135,	-8165,	-8331,
-8649,	-9012,	-9329,	-9632,	-9919,	-10116,	-10312,	-10630,
-11023,	-11401,	-11824,	-12233,	-12565,	-12807,	-12928,	-13079,
-13427,	-13699,	-13805,	-13850,	-13866,	-13820,	-14002,	-13956,
-13866,	-13956,	-13941,	-13744,	-13472,	-13351,	-13382,	-13215,
-12807,	-12384,	-12021,	-11628,	-11310,	-10978,	-10599,	-10251,
-10040,	-9481,	-8936,	-8634,	-8482,	-8165,	-7802,	-7651,
-7303,	-6728,	-6199,	-5761,	-5232,	-4597,	-4158,	-3856,
-3553,	-3130,	-2691,	-2041,	-1588,	-1240,	-907,	-484,
-30,	0,	121,	212,	363,	650,	1013,	1331,
1376,	1346,	1270,	1512,	1709,	1618,	1663,	1724,
1739,	1724,	1769,	1754,	1633,	1890,	2238,	2419,
2691,	2752,	2661,	2450,	2268,	2207,	2102,	1815,
1512,	1179,	711,	469,	121,	-318,	-469,	-227,
-30,	-136,	-197,	-151,	-272,	-484,	-484,	-484,
-650,	-544,	-378,	-333,	-318,	-378,	-484,	-529,
-696,	-681,	-544,	-650,	-726,	-756,	-711,	-832,
-1028,	-1179,	-1134,	-1331,	-1512,	-1754,	-2268,	-2616,
-3100,	-3538,	-3735,	-4113,	-4460,	-4536,	-4491,	-4566,
-4778,	-5217,	-5534,	-5519,	-5428,	-5594,	-5852,	-5791,
-5882,	-6048,	-6124,	-6184,	-5973,	-5927,	-6335,	-6441,
-6290,	-6502,	-6577,	-6623,	-6728,	-6880,	-6834,	-6865,
-6834,	-6668,	-6971,	-7243,	-7364,	-7379,	-7591,	-7681,
-7893,	-8346,	-8725,	-8770,	-8679,	-8800,	-9087,	-9284,
-8981,	-8710,	-8392,	-8029,	-7636,	-7348,	-7031,	-6774,
-6366,	-5806,	-5292,	-5035,	-4854,	-4264,	-3871,	-3417,
-3175,	-3085,	-3070,	-2949,	-2918,	-3039,	-3115,	-3190,
-3326,	-3508,	-3523,	-3417,	-3190,	-3221,	-3266,	-3236,
-2994,	-2661,	-2435,	-2329,	-2268,	-1815,	-1436,	-1058,
-484,	76,	287,	499,	847,	1225,	1467,	1482,
1316,	1028,	937,	922,	907,	847,	544,	363,
484,	559,	514,	529,	453,	544,	665,	922,
1149,	1270,	1527,	1512,	1542,	1890,	2056,	2056,
1905,	1769,	1693,	1678,	1724,	1739,	1905,	1860,
1663,	1512,	1557,	1527,	1648,	1709,	1663,	1709,
1875,	2313,	2691,	3009,	3115,	3221,	3599,	3886,
3916,	3931,	3916,	3553,	3160,	2843,	2570,	2253,
1769,	1467,	1482,	1603,	1331,	1225,	1376,	1633,
2056,	2555,	2994,	3281,	3825,	4234,	4703,	4854,
4823,	4914,	4808,	4476,	4294,	4430,	4007,	3357,
3296,	3372,	3266,	3281,	3614,	4188,	4733,	4899,
5126,	5504,	5897,	6320,	6834,	7092,	7228,	7787,
7817,	7530,	7727,	8543,	8770,	8513,	8588,	9224,
10010,	10267,	10040,	9677,	9859,	10176,	10055,	9541,
9345,	9254,	9269,	9012,	8785,	8710,	8482,	8150,
7439,	6834,	6199,	5594,	4914,	4506,	4113,	3584,
2827,	2359,	2435,	2207,	2177,	1618,	786,	151,
-453,	-1225,	-1769,	-1981,	-2661,	-3296,	-3841,	-4975,
-5761,	-6199,	-6502,	-7031,	-8044,	-8725,	-8785,	-8966,
-9616,	-10282,	-10494,	-10599,	-11325,	-12112,	-12353,	-12142,
-11885,	-12278,	-12973,	-13306,	-13684,	-14017,	-14304,	-14425,
-13820,	-13790,	-14561,	-14894,	-15000,	-14909,	-15015,	-15453,
-15544,	-15786,	-16194,	-16270,	-15876,	-15559,	-15665,	-16149,
-16012,	-15196,	-14803,	-14516,	-14319,	-13866,	-13049,	-12883,
-12233,	-10251,	-8649,	-8135,	-7303,	-5927,	-5217,	-5277,
-4400,	-3281,	-3009,	-2918,	-3100,	-3054,	-2661,	-2207,
-1210,	182,	1179,	1875,	2102,	2525,	3266,	4324,
5458,	5942,	6759,	8241,	9889,	11461,	12792,	12988,
13805,	15317,	16421,	17116,	17086,	17177,	17434,	17782,
17570,	16844,	16406,	16436,	16330,	16330,	16315,	15907,
15786,	15468,	15362,	15105,	14319,	13457,	12610,	12051,
11310,	10403,	9677,	8664,	7228,	6487,	6199,	5776,
5307,	5201,	5746,	6214,	6245,	6335,	6849,	7061,
7122,	6925,	6638,	6124,	5761,	5171,	4324,	3750,
3085,	2283,	1361,	620,	272,	-91,	-786,	-1391,
-1875,	-2329,	-2646,	-3054,	-3523,	-3886,	-3992,	-3977,
-4581,	-5141,	-5307,	-5368,	-5640,	-5897,	-6426,	-7076,
-7469,	-7182,	-6728,	-6668,	-6577,	-6351,	-5988,	-5700,
-5413,	-5338,	-5489,	-5731,	-6033,	-6502,	-7182,	-7575,
-7999,	-8755,	-9269,	-9511,	-9768,	-10312,	-11250,	-11839,
-12142,	-12565,	-12837,	-12686,	-12399,	-12051,	-12051,	-12233,
-11900,	-11431,	-11431,	-11174,	-10418,	-9798,	-9511,	-9057,
-8377,	-7530,	-6849,	-6834,	-6880,	-5973,	-4703,	-4022,
-3644,	-3341,	-2994,	-2238,	-1754,	-1799,	-1920,	-1678,
-1693,	-2117,	-2238,	-2525,	-2782,	-2903,	-2888,	-2949,
-2994,	-3387,	-3780,	-3689,	-3569,	-3750,	-3871,	-3810,
-3720,	-3508,	-3569,	-3705,	-4113,	-4309,	-4204,	-4234,
-4733,	-5549,	-5882,	-6063,	-6320,	-6759,	-7182,	-7318,
-7409,	-7636,	-7681,	-7832,	-8226,	-8407,	-8528,	-8513,
-8770,	-8861,	-8634,	-8467,	-8710,	-8830,	-8543,	-8513,
-8346,	-8211,	-8105,	-8044,	-7983,	-7893,	-7908,	-8014,
-8059,	-8135,	-8286,	-8573,	-8906,	-9163,	-9571,	-9828,
-9904,	-10176,	-10236,	-10010,	-9768,	-9224,	-8725,	-8377,
-8120,	-7802,	-7454,	-7122,	-6895,	-6849,	-6819,	-6834,
-6683,	-6698,	-6819,	-6940,	-7092,	-7273,	-7666,	-8135,
-8558,	-9117,	-9722,	-9919,	-10282,	-10766,	-10993,	-10962,
-10978,	-11129,	-11098,	-11098,	-11098,	-10902,	-10796,	-10705,
-10630,	-10494,	-10146,	-9601,	-9087,	-8785,	-8377,	-7621,
-6744,	-5821,	-4990,	-4370,	-3735,	-2949,	-2132,	-1406,
-756,	-151,	302,	453,	529,	756,	801,	635,
711,	1028,	1179,	1270,	1436,	1754,	2071,	2525,
2873,	3205,	3765,	4143,	4793,	5715,	6441,	7258,
8271,	9208,	10448,	11673,	12626,	13503,	14455,	15151,
15740,	16300,	16572,	16859,	16950,	16980,	17313,	17600,
17691,	17948,	18462,	18870,	19052,	19384,	19793,	19868,
20322,	20730,	21002,	21335,	21773,	22287,	23013,	23769,
24510,	25266,	25962,	26415,	26854,	27277,	27172,	27292,
27534,	27610,	27534,	27791,	28063,	27988,	27549,	27580,
27610,	27852,	27837,	27398,	27096,	26567,	25765,	25055,
24646,	24344,	24284,	23739,	23210,	23089,	23150,	22983,
22363,	22091,	22227,	22106,	21804,	21532,	21290,	21093,
20776,	20262,	19536,	18885,	18160,	17419,	16466,	15392,
14576,	13684,	12656,	11688,	11008,	10388,	9571,	8770,
8059,	7409,	6577,	5746,	5020,	4173,	3130,	2132,
1240,	333,	-257,	-726,	-1376,	-2147,	-2903,	-3856,
-4566,	-5610,	-6728,	-7802,	-8679,	-9586,	-10660,	-11401,
-12157,	-13185,	-14122,	-15060,	-15831,	-16436,	-17162,	-17903,
-18508,	-19233,	-19944,	-20277,	-20488,	-20579,	-20397,	-20292,
-20443,	-20034,	-19339,	-18764,	-18175,	-17494,	-16829,	-16285,
-15544,	-14818,	-14122,	-13367,	-12898,	-12384,	-11930,	-11552,
-10947,	-10161,	-9616,	-9239,	-8785,	-8271,	-7681,	-7152,
-6668,	-5912,	-5353,	-4657,	-3856,	-3024,	-2177,	-1134,
106,	1119,	2192,	3024,	4113,	5080,	5776,	6562,
7182,	7817,	8467,	9284,	10040,	10872,	11885,	12837,
13639,	14712,	15695,	16632,	17812,	18568,	18885,	19581,
20292,	20881,	21305,	21925,	22771,	23361,	23830,	24238,
24646,	25327,	25720,	25599,	25402,	25191,	25175,	25024,
24571,	24208,	24117,	24011,	23845,	23860,	23785,	23588,
23588,	23603,	23497,	23285,	23285,	23331,	23225,	23180,
23255,	23180,	23074,	22862,	22530,	21894,	21048,	20171,
19445,	18855,	18190,	17645,	17086,	16602,	16270,	16028,
15816,	15786,	15604,	15211,	14969,	14576,	13956,	13140,
12444,	11885,	11401,	10826,	10055,	9405,	8800,	7968,
7122,	6335,	5504,	4627,	3871,	3070,	2465,	2071,
1467,	1119,	771,	242,	-272,	-499,	-922,	-1572,
-2147,	-2812,	-3538,	-4249,	-4808,	-5292,	-5927,	-6320,
-6547,	-6713,	-7031,	-7348,	-7545,	-7893,	-8029,	-8195,
-8407,	-8694,	-8830,	-9072,	-9314,	-9722,	-10131,	-10433,
-10705,	-10902,	-11325,	-11854,	-12338,	-12671,	-13170,	-13623,
-13669,	-13578,	-13608,	-13684,	-13729,	-14122,	-14440,	-14606,
-14682,	-14561,	-14637,	-14894,	-15075,	-14909,	-14667,	-14455,
-14364,	-14470,	-14289,	-14062,	-14122,	-14304,	-14213,	-14017,
-13926,	-13820,	-13790,	-13578,	-13049,	-12580,	-12172,	-12142,
-12172,	-12006,	-11598,	-10811,	-10206,	-9571,	-9027,	-8588,
-8044,	-7485,	-6683,	-6003,	-5640,	-5156,	-4657,	-4128,
-3659,	-3130,	-2313,	-1618,	-1073,	-529,	-15,	438,
1210,	1769,	1935,	2223,	2646,	2949,	2994,	3130,
3175,	3372,	3720,	3795,	3780,	3946,	4022,	4037,
4309,	4733,	5186,	5625,	5897,	6487,	7243,	7863,
8649,	9511,	10267,	11098,	12036,	12535,	13246,	14258,
15332,	16239,	16754,	17313,	17948,	18810,	19626,	20428,
20912,	21184,	21516,	22046,	22378,	22726,	23165,	23361,
23785,	24163,	24208,	24435,	24676,	24858,	24919,	24828,
24480,	23936,	23649,	23527,	23527,	23165,	22696,	22378,
22287,	22121,	22106,	21940,	21532,	21229,	20942,	20624,
20110,	19672,	19339,	19158,	18976,	18568,	18190,	18175,
18099,	17857,	17933,	17782,	17252,	17026,	16965,	16814,
16421,	15786,	15241,	15196,	15121,	14954,	14697,	14243,
13926,	13623,	13367,	13019,	12489,	11824,	11370,	10856,
10146,	9314,	8664,	8135,	7666,	7137,	6593,	6063,
5655,	5277,	4703,	4098,	3614,	3115,	2676,	2223,
1709,	1028,	469,	45,	-151,	-484,	-1058,	-1739,
-2570,	-3281,	-3916,	-4491,	-5156,	-6139,	-7092,	-7787,
-8301,	-8800,	-9390,	-9768,	-10116,	-10267,	-10418,	-10690,
-10660,	-10630,	-10569,	-10463,	-10388,	-10161,	-9904,	-9601,
-9511,	-9360,	-9390,	-9496,	-9632,	-9768,	-10010,	-10463,
-10781,	-11144,	-11582,	-11885,	-12504,	-13124,	-13578,	-14062,
-14395,	-14727,	-15060,	-15574,	-15892,	-15892,	-15967,	-15876,
-15876,	-15680,	-15529,	-15211,	-14712,	-14380,	-13986,	-13487,
-12822,	-12217,	-11809,	-11446,	-11129,	-10645,	-10267,	-10206,
-10010,	-9995,	-9949,	-9934,	-10070,	-10161,	-10267,	-10282,
-10116,	-9980,	-9813,	-9526,	-9117,	-8755,	-8392,	-7832,
-7409,	-7076,	-6396,	-5715,	-5111,	-4718,	-4324,	-4083,
-3674,	-3266,	-2933,	-2601,	-2419,	-2253,	-2132,	-2071,
-2147,	-2041,	-1920,	-1693,	-1467,	-1482,	-1255,	-847,
-212,	378,	937,	1815,	2752,	3538,	4173,	4823,
5171,	5489,	5715,	6154,	6366,	6290,	6441,	6502,
6381,	6275,	6214,	6018,	5655,	5368,	5080,	4778,
4385,	4264,	4264,	4083,	3886,	4037,	4279,	4370,
4657,	5005,	5277,	5458,	5988,	6517,	6880,	7122,
7364,	7878,	8362,	8755,	8966,	9526,	10161,	10796,
11234,	11522,	11869,	12142,	12323,	12535,	12837,	13049,
13004,	12928,	12913,	13019,	13230,	13276,	13306,	13124,
13019,	13049,	13291,	13563,	13503,	13593,	13744,	13805,
14122,	14697,	15166,	15589,	15786,	15846,	16149,	16511,
16859,	17192,	17298,	17237,	17131,	17162,	17222,	17146,
17101,	16859,	16572,	16527,	16330,	16345,	16481,	16572,
16799,	16890,	17056,	17389,	17721,	18145,	18508,	18764,
18916,	18855,	18976,	19052,	18991,	18946,	18749,	18568,
18356,	18190,	17933,	17766,	17525,	17116,	16935,	16648,
16345,	16058,	15892,	15771,	15710,	15529,	15166,	14878,
14803,	14546,	14122,	13714,	13155,	12762,	12142,	11552,
11068,	10630,	10236,	9874,	9450,	8936,	8422,	7893,
7439,	6940,	6638,	6275,	5837,	5277,	4899,	4536,
4037,	3644,	3266,	2979,	2540,	1890,	1164,	559,
30,	-469,	-1149,	-1845,	-2555,	-3070,	-3629,	-4128,
-4581,	-5458,	-6078,	-6638,	-7197,	-7983,	-8498,	-8981,
-9692,	-10312,	-10705,	-11144,	-11507,	-11779,	-12202,	-12520,
-12973,	-13397,	-13744,	-14122,	-14516,	-14742,	-15075,	-15453,
-15635,	-15816,	-16103,	-16375,	-16678,	-16950,	-17252,	-17464,
-17736,	-18024,	-18024,	-18009,	-18054,	-18145,	-18190,	-18145,
-18205,	-18160,	-18024,	-17933,	-17918,	-17827,	-17615,	-17434,
-17026,	-16723,	-16285,	-15801,	-15468,	-14954,	-14380,	-14107,
-13669,	-13064,	-12565,	-11839,	-11144,	-10342,	-9616,	-8861,
-8165,	-7545,	-6895,	-6411,	-5882,	-5458,	-5005,	-4612,
-4219,	-3841,	-3417,	-2933,	-2465,	-2041,	-1482,	-1028,
-575,	-61,	529,	1119,	1799,	2404,	3160,	3871,
4657,	5428,	6305,	7288,	8135,	8891,	9616,	10463,
11340,	12187,	12973,	13986,	14833,	15650,	16345,	16965,
17661,	18371,	19052,	19778,	20397,	21048,	21713,	22257,
23074,	23845,	24616,	25433,	26400,	27247,	28003,	28714,
29243,	29817,	30468,	31073,	31511,	31889,	32025,	32343,
32494,	32630,	32690,	32766,	32721,	32524,	32328,	32252,
31995,	31677,	31541,	31330,	31194,	31073,	30800,	30604,
30422,	29939,	29440,	28895,	28457,	27943,	27338,	26914,
26189,	25538,	24994,	24329,	23724,	23089,	22378,	21698,
21063,	20594,	20065,	19611,	19203,	18870,	18538,	18280,
18039,	17812,	17404,	17116,	16678,	16118,	15559,	14939,
14395,	13790,	13155,	12535,	11794,	11068,	10251,	9556,
8876,	7968,	7001,	6139,	5398,	4597,	3795,	3100,
2465,	1845,	1436,	1013,	590,	91,	-544,	-1195,
-1830,	-2313,	-2873,	-3447,	-3992,	-4536,	-5186,	-5564,
-5897,	-6260,	-6623,	-6925,	-7273,	-7666,	-7908,	-7983,
-8044,	-8316,	-8482,	-8619,	-8694,	-8725,	-8740,	-8725,
-8891,	-9102,	-9390,	-9465,	-9345,	-9314,	-9329,	-9299,
-9254,	-9314,	-9178,	-8906,	-8815,	-8619,	-8498,	-8150,
-7923,	-7923,	-7832,	-7454,	-7167,	-7031,	-6789,	-6532,
-6547,	-6623,	-6698,	-6683,	-6759,	-7092,	-7394,	-7500,
-7621,	-7817,	-7953,	-8135,	-8241,	-8528,	-8710,	-8876,
-9072,	-9435,	-9707,	-9919,	-10146,	-10191,	-10312,	-10297,
-10085,	-9859,	-9722,	-9345,	-8921,	-8543,	-8074,	-7530,
-7092,	-6653,	-6109,	-5564,	-4990,	-4204,	-3599,	-2994,
-2192,	-1633,	-998,	-197,	453,	1089,	1815,	2404,
3100,	3599,	4204,	4839,	5353,	5806,	6472,	6910,
7439,	8044,	8498,	9133,	9859,	10403,	10811,	11204,
11522,	12006,	12384,	12716,	12943,	13185,	13336,	13639,
13790,	14032,	14319,	14501,	14727,	15045,	15377,	15514,
15831,	16255,	16799,	17374,	17797,	18356,	18946,	19475,
19944,	20579,	21078,	21471,	21879,	22227,	22575,	22817,
22983,	23180,	23437,	23542,	23618,	23558,	23588,	23633,
23467,	23391,	23255,	22953,	22711,	22635,	22560,	22393,
22091,	21925,	21788,	21532,	21274,	20881,	20518,	20125,
19687,	19203,	18810,	18265,	17676,	17237,	16905,	16542,
16043,	15786,	15423,	15075,	14773,	14364,	14017,	13714,
13336,	12973,	12565,	12112,	11567,	10978,	10494,	9859,
9133,	8482,	7938,	7379,	6865,	6229,	5821,	5534,
5217,	5050,	4884,	4672,	4506,	4445,	4234,	4067,
3750,	3311,	2858,	2510,	2177,	1678,	1149,	544,
-45,	-544,	-1149,	-1830,	-2555,	-3296,	-4067,	-5020,
-5897,	-6623,	-7575,	-8482,	-9254,	-10206,	-11174,	-11915,
-12686,	-13472,	-14349,	-15181,	-15846,	-16617,	-17222,	-17827,
-18432,	-18855,	-19188,	-19520,	-19626,	-19898,	-20156,	-20171,
-20367,	-20549,	-20609,	-20654,	-20760,	-20730,	-20609,	-20670,
-20972,	-21108,	-21123,	-21199,	-21214,	-21108,	-21093,	-21108,
-21017,	-20760,	-20533,	-20307,	-19883,	-19399,	-19022,	-18598,
-18009,	-17434,	-16814,	-16103,	-15377,	-14591,	-13729,	-12988,
-12096,	-11370,	-10735,	-10025,	-9269,	-8543,	-7893,	-7273,
-6577,	-5973,	-5398,	-4884,	-4324,	-3659,	-3190,	-2540,
-1920,	-1179,	-559,	257,	892,	1557,	2268,	2843,
3538,	4264,	4959,	5670,	6351,	6986,	7742,	8528,
9375,	10131,	10947,	12006,	12928,	13639,	14501,	15302,
15967,	16754,	17782,	18764,	19626,	20473,	21396,	22151,
22802,	23452,	24056,	24616,	25009,	25327,	25448,	25433,
25523,	25538,	25614,	25795,	25841,	25841,	25932,	26038,
25992,	25886,	25977,	25917,	25977,	26113,	26158,	26022,
25932,	25886,	25690,	25659,	25523,	25327,	25175,	24903,
24616,	24495,	24374,	24193,	24102,	23981,	23830,	23664,
23421,	23150,	22953,	22590,	22227,	21910,	21516,	21048,
20760,	20518,	20186,	19823,	19324,	18764,	18265,	17721,
17192,	16632,	16012,	15347,	14727,	14198,	13593,	13109,
12474,	12112,	11643,	11144,	10599,	10116,	9677,	9208,
9027,	8800,	8422,	8256,	8271,	8165,	8090,	8120,
8029,	7968,	7878,	7787,	7772,	7560,	7333,	7107,
6956,	6819,	6577,	6441,	6381,	6290,	6109,	6154,
6320,	6517,	6668,	6834,	7076,	7288,	7530,	7847,
8180,	8422,	8740,	8951,	9193,	9360,	9571,	9692,
10025,	10221,	10297,	10418,	10569,	10872,	10962,	11114,
11250,	11476,	11688,	11930,	12338,	12610,	12852,	13351,
13623,	13941,	14364,	14757,	15166,	15438,	15740,	15997,
16270,	16511,	16542,	16451,	16451,	16330,	16255,	15997,
15695,	15408,	14969,	14470,	13941,	13246,	12747,	12263,
11779,	11234,	10660,	10085,	9526,	9208,	8558,	8150,
7621,	7001,	6426,	5776,	5247,	4581,	4083,	3584,
3100,	2661,	2298,	1951,	1572,	1331,	968,	817,
590,	227,	-45,	-348,	-620,	-907,	-1013,	-1316,
-1648,	-1996,	-2298,	-2601,	-2933,	-3130,	-3281,	-3463,
-3810,	-3871,	-3916,	-3977,	-3916,	-3961,	-3961,	-4037,
-4067,	-4204,	-4264,	-4324,	-4370,	-4234,	-4264,	-4249,
-4415,	-4460,	-4415,	-4370,	-4294,	-4491,	-4581,	-4627,
-4551,	-4551,	-4672,	-4672,	-4718,	-4672,	-4612,	-4536,
-4521,	-4476,	-4476,	-4400,	-4279,	-4355,	-4294,	-4324,
-4204,	-4022,	-3780,	-3614,	-3387,	-2949,	-2601,	-2283,
-1845,	-1421,	-907,	-378,	-61,	363,	877,	1497,
1935,	2344,	2722,	3145,	3493,	3795,	4022,	4219,
4309,	4309,	4385,	4340,	4219,	4083,	3916,	3705,
3599,	3629,	3599,	3825,	3916,	4007,	4113,	4340,
4612,	5020,	5307,	5640,	6124,	6426,	6849,	7107,
7424,	7666,	7983,	8029,	8014,	7999,	8029,	8090,
8014,	8150,	8044,	8074,	8211,	8271,	8346,	8437,
8528,	8785,	8936,	9087,	9269,	9435,	9556,	9692,
9874,	9874,	9904,	9904,	9889,	9934,	9995,	9949,
9874,	9844,	9783,	9571,	9465,	9329,	9178,	9133,
9012,	8846,	8876,	8770,	8467,	8407,	8316,	8180,
8090,	7999,	7802,	7621,	7348,	6956,	6804,	6653,
6335,	5973,	5685,	5534,	5398,	5126,	4823,	4491,
4128,	3916,	3584,	3523,	3296,	2933,	2752,	2495,
2268,	1935,	1830,	1588,	1316,	1210,	983,	786,
605,	408,	318,	106,	-91,	-182,	-242,	-257,
-469,	-423,	-438,	-423,	-318,	-212,	-121,	-61,
15,	15,	197,	227,	242,	318,	438,	801,
907,	1104,	1270,	1255,	1452,	1693,	1935,	2071,
2283,	2646,	2918,	3205,	3523,	3810,	4143,	4536,
4839,	5111,	5353,	5368,	5579,	5882,	6033,	6214,
6381,	6562,	6971,	7228,	7469,	7696,	7999,	8256,
8482,	8634,	8740,	8906,	8966,	9193,	9375,	9390,
9284,	9375,	9360,	9314,	9133,	9012,	8921,	8755,
8755,	8664,	8558,	8543,	8634,	8710,	8891,	8981,
9117,	9148,	9299,	9329,	9465,	9662,	9768,	10025,
10206,	10282,	10358,	10312,	10251,	10176,	9859,	9601,
9254,	9027,	8755,	8498,	8195,	7847,	7606,	7318,
7137,	6880,	6517,	6229,	5927,	5625,	5474,	5247,
5080,	4823,	4718,	4476,	4128,	3931,	3614,	3478,
3130,	2827,	2646,	2344,	2147,	2011,	1966,	1830,
1603,	1603,	1572,	1572,	1709,	1663,	1648,	1799,
1754,	1724,	1754,	1693,	1663,	1588,	1467,	1225,
1134,	922,	726,	499,	151,	61,	-121,	-333,
-665,	-968,	-1270,	-1406,	-1648,	-1905,	-2102,	-2359,
-2601,	-2843,	-2858,	-3085,	-3236,	-3417,	-3493,	-3614,
-3765,	-3659,	-3705,	-3659,	-3689,	-3538,	-3508,	-3447,
-3357,	-3221,	-3085,	-2979,	-2797,	-2586,	-2450,	-2480,
-2389,	-2207,	-1966,	-1769,	-1557,	-1557,	-1331,	-1210,
-1104,	-968,	-681,	-514,	-257,	76,	393,	665,
892,	1331,	1663,	2117,	2404,	2752,	3130,	3281,
3523,	3886,	3992,	4204,	4400,	4536,	4703,	4687,
4748,	4763,	4566,	4324,	4264,	4294,	4188,	3977,
3916,	3825,	3599,	3417,	3190,	2964,	2691,	2480,
2359,	2071,	1920,	1693,	1512,	1421,	1255,	1013,
741,	575,	348,	136,	-30,	-227,	-544,	-756,
-983,	-1316,	-1724,	-1981,	-2177,	-2450,	-2722,	-3009,
-3221,	-3402,	-3417,	-3478,	-3538,	-3674,	-3674,	-3674,
-3720,	-3659,	-3765,	-3780,	-3810,	-3841,	-3765,	-3856,
-3886,	-3856,	-3886,	-3946,	-4173,	-4279,	-4460,	-4581,
-4793,	-5020,	-5262,	-5519,	-5579,	-5806,	-5927,	-5867,
-5897,	-5912,	-5852,	-5837,	-5761,	-5564,	-5232,	-5080,
-4823,	-4445,	-4264,	-4113,	-3856,	-3523,	-3326,	-3190,
-2979,	-2827,	-2722,	-2480,	-2404,	-2087,	-1981,	-1875,
-1693,	-1421,	-1119,	-953,	-575,	-348,	-272,	-15,
91,	378,	605,	665,	756,	892,	998,	1058,
892,	711,	514,	453,	423,	212,	76,	121,
121,	-61,	-30,	-121,	-45,	-15,	-121,	-76,
-45,	-30,	45,	136,	-106,	-197,	-287,	-302,
-529,	-832,	-1013,	-1149,	-1149,	-1300,	-1436,	-1482,
-1557,	-1603,	-1512,	-1285,	-998,	-968,	-786,	-590,
-242,	45,	318,	499,	771,	877,	1089,	1270,
1300,	1452,	1482,	1467,	1527,	1618,	1709,	1799,
1784,	1724,	1648,	1603,	1678,	1572,	1467,	1316,
1149,	1225,	1104,	1119,	1089,	1104,	953,	922,
937,	801,	786,	681,	756,	817,	786,	817,
968,	1179,	1240,	1467,	1709,	1860,	1996,	2147,
2404,	2616,	2782,	2918,	3221,	3357,	3463,	3629,
3463,	3584,	3478,	3493,	3402,	3387,	3402,	3417,
3296,	3145,	3100,	2888,	2737,	2540,	2465,	2313,
2087,	1890,	1648,	1421,	1346,	1164,	1043,	817,
590,	348,	61,	-302,	-499,	-620,	-862,	-922,
-1179,	-1406,	-1572,	-1633,	-1754,	-1935,	-1935,	-2011,
-2056,	-2132,	-2298,	-2389,	-2480,	-2601,	-2752,	-2903,
-2979,	-3145,	-3311,	-3372,	-3326,	-3417,	-3447,	-3447,
-3523,	-3508,	-3493,	-3417,	-3417,	-3432,	-3387,	-3417,
-3584,	-3765,	-3795,	-3886,	-3977,	-4173,	-4445,	-4703,
-4823,	-4975,	-5232,	-5458,	-5776,	-6093,	-6260,	-6487,
-6865,	-6971,	-7197,	-7258,	-7575,	-7772,	-7757,	-7923,
-7983,	-8090,	-8241,	-8392,	-8498,	-8664,	-8785,	-8936,
-9193,	-9375,	-9571,	-9707,	-9798,	-9859,	-9859,	-10070,
-10191,	-10373,	-10463,	-10660,	-10826,	-10932,	-11144,	-11250,
-11386,	-11567,	-11658,	-11718,	-11839,	-11869,	-12006,	-12187,
-12278,	-12308,	-12338,	-12489,	-12732,	-12852,	-12792,	-12928,
-13094,	-13170,	-13382,	-13472,	-13608,	-13805,	-13986,	-14168,
-14349,	-14652,	-14773,	-15015,	-15060,	-15090,	-15121,	-15166,
-15287,	-15483,	-15620,	-15816,	-15846,	-15922,	-15967,	-15922,
-16118,	-16088,	-16043,	-15922,	-15892,	-15650,	-15529,	-15529,
-15438,	-15529,	-15483,	-15498,	-15529,	-15483,	-15392,	-15362,
-15181,	-15060,	-15060,	-14954,	-15000,	-14863,	-14803,	-14788,
-14667,	-14637,	-14425,	-14304,	-14258,	-14092,	-13956,	-13760,
-13669,	-13503,	-13472,	-13397,	-13261,	-13185,	-12988,	-12747,
-12580,	-12217,	-11900,	-11507,	-11068,	-10524,	-10070,	-9616,
-9178,	-8800,	-8407,	-8014,	-7530,	-7197,	-6789,	-6457,
-6093,	-5852,	-5610,	-5307,	-5111,	-4869,	-4642,	-4521,
-4234,	-3977,	-3750,	-3553,	-3311,	-2979,	-2797,	-2480,
-2283,	-1951,	-1588,	-1240,	-953,	-696,	-453,	-166,
76,	106,	287,	529,	786,	862,	771,	937,
1119,	1240,	1391,	1482,	1467,	1406,	1391,	1240,
1149,	1013,	1058,	1089,	847,	771,	711,	575,
438,	227,	45,	-212,	-378,	-514,	-756,	-832,
-1028,	-1104,	-1225,	-1300,	-1421,	-1633,	-1709,	-1784,
-1754,	-1769,	-1830,	-1754,	-1799,	-1754,	-1966,	-2041,
-2177,	-2435,	-2616,	-3085,	-3432,	-3614,	-3674,	-3916,
-3992,	-4098,	-4188,	-4279,	-4324,	-4324,	-4340,	-4460,
-4521,	-4264,	-4340,	-4309,	-4249,	-4052,	-3901,	-3841,
-3720,	-3614,	-3447,	-3341,	-3236,	-3236,	-3009,	-2858,
-2706,	-2706,	-2631,	-2525,	-2359,	-2071,	-1875,	-1633,
-1512,	-1316,	-998,	-771,	-711,	-393,	-197,	151,
333,	529,	801,	832,	968,	968,	1240,	1482,
1648,	2011,	2404,	2888,	3341,	3795,	4370,	4823,
5262,	5640,	6018,	6502,	7031,	7485,	7878,	8180,
8346,	8452,	8619,	8861,	8906,	8891,	8800,	8861,
8710,	8513,	8482,	8407,	8271,	8120,	8090,	7938,
7847,	7863,	7923,	7817,	7802,	7666,	7560,	7560,
7333,	7258,	7122,	6925,	6819,	6849,	6517,	6214,
6199,	5942,	5640,	5519,	5292,	4854,	4460,	4324,
4143,	3916,	3765,	3614,	3569,	3447,	3266,	3085,
2812,	2752,	2570,	2359,	2056,	1678,	1361,	1089,
1043,	817,	378,	76,	-136,	-529,	-1013,	-1421,
-1754,	-2207,	-2646,	-2888,	-3266,	-3720,	-4173,	-4536,
-4959,	-5534,	-6199,	-6653,	-7061,	-7636,	-8226,	-8861,
-9360,	-9753,	-10358,	-10841,	-11144,	-11734,	-12172,	-12701,
-13155,	-13397,	-13714,	-14198,	-14637,	-14848,	-15181,	-15544,
-15740,	-16058,	-16391,	-16527,	-16754,	-17146,	-17464,	-17782,
-18054,	-18280,	-18386,	-18613,	-18810,	-18900,	-19052,	-19082,
-18961,	-18855,	-18825,	-18613,	-18477,	-18341,	-18129,	-18054,
-17751,	-17404,	-17252,	-17086,	-16738,	-16481,	-16315,	-16073,
-15907,	-15710,	-15544,	-15302,	-15045,	-14939,	-14818,	-14667,
-14501,	-14334,	-14198,	-13911,	-13382,	-12913,	-12580,	-12127,
-11718,	-11083,	-10479,	-9995,	-9481,	-9117,	-8604,	-8120,
-7530,	-7031,	-6593,	-6018,	-5443,	-4929,	-4294,	-3644,
-2918,	-2162,	-1527,	-892,	-242,	393,	1195,	2056,
2737,	3115,	3674,	4249,	4703,	5277,	5715,	6139,
6638,	7137,	7560,	8090,	8437,	8725,	9117,	9450,
9874,	10100,	10327,	10796,	11114,	11370,	11537,	12051,
12610,	12792,	13200,	13744,	14153,	14334,	14697,	15257,
15650,	16239,	16617,	17101,	17706,	18175,	18583,	19158
};

__eds__ __attribute__((space(prog))) int16_t SAMPLE_key_hammer4[sample_length] = {
-299,	-413,	-440,	-360,	-308,	-378,	-422,	-492,
-448,	-492,	-554,	-659,	-686,	-642,	-695,	-703,
-721,	-650,	-624,	-545,	-545,	-580,	-404,	-97,
176,	413,	528,	580,	668,	668,	686,	528,
-35,	-809,	-1301,	-1204,	-906,	-677,	-686,	-950,
-1002,	-835,	-870,	-879,	-888,	-1125,	-1468,	-1600,
-1627,	-1749,	-1890,	-1600,	-1222,	-2013,	-1099,	2286,
5477,	2163,	-3930,	-3816,	-2506,	-2998,	-3279,	-8941,
-11200,	-3402,	-615,	-3675,	-11974,	-8624,	10550,	13460,
-1072,	-8827,	-7842,	-8554,	-6180,	-3525,	-2163,	-3200,
13117,	30137,	13644,	-4343,	-2620,	10884,	12985,	1776,
-15569,	-27218,	-18708,	-1011,	1415,	554,	5310,	13504,
13934,	-1785,	-7780,	-906,	2558,	-1231,	1653,	-7446,
-20203,	-14611,	6901,	25556,	24150,	4343,	-5890,	-3015,
-8431,	-21038,	-18963,	-3771,	9952,	21319,	15200,	-2356,
-12141,	-3930,	8800,	176,	-3297,	6207,	9468,	8748,
15675,	15561,	-88,	-6541,	-4686,	650,	-3394,	-16572,
-9785,	7754,	13837,	2945,	-7156,	-13152,	-11807,	-10251,
-28932,	-30207,	3903,	32765,	29785,	10409,	-4062,	-6523,
-589,	7033,	7279,	-6831,	-5169,	16115,	26181,	15499,
-4079,	-14383,	-10084,	-7842,	-13811,	-18585,	-12044,	-5248,
-2910,	-1802,	-2453,	-4185,	-4220,	-3305,	-3121,	-5741,
-8870,	-202,	15613,	19455,	5785,	-7024,	-4545,	2339,
-5512,	-13152,	-9943,	-721,	8651,	6110,	-554,	-8457,
-13723,	-12554,	-11402,	-16018,	-12185,	1811,	5486,	0,
-923,	4317,	5134,	18,	835,	5653,	2409,	-1407,
2040,	9372,	11543,	-9,	-7903,	-10048,	-10690,	-10611,
-11649,	-9838,	-5205,	-1556,	-1679,	589,	2541,	1319,
-2673,	536,	8607,	7780,	3015,	2611,	-1987,	-9354,
-9521,	-5468,	-3552,	-8783,	-4941,	6224,	10550,	4484,
-1196,	-2690,	-8071,	-13380,	-15526,	-13108,	-8545,	1820,
11868,	13108,	10268,	9187,	10848,	10690,	5108,	-1486,
-4123,	-3059,	1899,	4026,	-1776,	-8062,	-9319,	-6075,
-3938,	-5486,	-5002,	-360,	3139,	4317,	1424,	-8237,
-13240,	-9319,	-3332,	-1996,	-1776,	4114,	11798,	16862,
16519,	12062,	2321,	-6136,	-4282,	1011,	-62,	-6365,
-4756,	2189,	26,	-12607,	-19649,	-12220,	-3429,	-809,
1319,	5345,	5020,	88,	-3086,	-2945,	-835,	642,
317,	255,	-993,	914,	6892,	7991,	3692,	-3183,
-6998,	-6734,	-5486,	-3508,	-2374,	-1275,	-1459,	-2347,
-3077,	-2400,	-1503,	-1855,	686,	5793,	8431,	3965,
-606,	308,	2470,	1451,	-3051,	-7033,	-6910,	-3015,
510,	-132,	-4466,	-5459,	-1283,	993,	-4053,	-11455,
-12202,	-6004,	1064,	4563,	5600,	4756,	1222,	-1178,
-1055,	580,	826,	1204,	4598,	7262,	6515,	3824,
1143,	-404,	-765,	-2883,	-7367,	-9398,	-5829,	-1240,
-589,	-2980,	-5749,	-5011,	-1477,	1679,	897,	114,
3974,	8563,	8369,	3684,	1688,	2637,	1407,	-2101,
-3956,	-1987,	1301,	4299,	6224,	5152,	2339,	1064,
1723,	132,	-4317,	-6224,	-3596,	484,	2356,	1125,
-1565,	-2901,	334,	5327,	7227,	6304,	4106,	2875,
1908,	1292,	-422,	-3086,	-3930,	-615,	3042,	2207,
202,	1196,	5037,	4923,	-695,	-5881,	-6145,	-2286,
1618,	2242,	343,	97,	2374,	4299,	3279,	3394,
4774,	4615,	4044,	3218,	1187,	-2022,	-3560,	-3341,
-2286,	-1503,	-510,	123,	1240,	2681,	1758,	-18,
-756,	-167,	-1134,	-2787,	-3077,	-1556,	853,	2866,
3886,	2180,	-202,	-352,	457,	-606,	-2497,	-2734,
-1468,	387,	1530,	2171,	2347,	2119,	826,	-2242,
-4703,	-3675,	-184,	1029,	-149,	-44,	1925,	2215,
633,	-88,	18,	668,	2004,	4229,	3895,	1881,
589,	-800,	-2303,	-2752,	-1820,	-1327,	-1020,	-237,
1283,	2435,	2277,	1029,	-237,	-1732,	-3349,	-3094,
-1468,	404,	1838,	2875,	3077,	2417,	1802,	1618,
932,	35,	624,	1653,	1697,	906,	501,	703,
923,	1345,	1881,	1960,	1064,	695,	1785,	1996,
1240,	765,	906,	229,	-976,	-914,	264,	1996,
3349,	3262,	1336,	-642,	-1116,	-413,	-167,	-35,
510,	844,	941,	1178,	246,	-1125,	-1055,	422,
1987,	1407,	273,	-44,	1741,	4071,	3516,	1275,
334,	1064,	1152,	844,	466,	97,	106,	387,
-264,	1125,	-791,	-2646,	-1459,	-2857,	-906,	-765,
-2119,	879,	2848,	2409,	2857,	-598,	-3341,	-2066,
-888,	1556,	3868,	3895,	2400,	1020,	-642,	-1494,
-4607,	-3437,	2057,	3121,	3499,	2092,	1248,	1793,
1758,	-1451,	-6382,	-5011,	-2066,	-721,	2567,	2628,
1538,	4607,	2022,	-1222,	-1618,	-2585,	-950,	-475,
360,	2189,	1442,	-26,	571,	-835,	-1081,	-835,
-2207,	0,	2330,	1820,	-202,	-2637,	-2620,	-308,
317,	-1125,	-1908,	-457,	3446,	4950,	2646,	440,
-2347,	-3112,	-1741,	387,	835,	-774,	-809,	897,
2145,	1283,	-264,	-1890,	-1767,	-1802,	-2057,	-1952,
-2049,	1081,	3183,	343,	-1415,	-1451,	-44,	1793,
1705,	1222,	-9,	97,	343,	-1468,	-3385,	-4097,
-2435,	571,	1283,	-747,	-475,	545,	747,	352,
-1415,	-2013,	-3262,	-3218,	-1090,	-79,	536,	378,
1618,	2892,	1890,	-1292,	-3455,	-3051,	-1820,	-457,
-352,	-650,	-791,	-141,	-281,	88,	-844,	-2075,
-642,	-70,	395,	650,	-79,	-1266,	-1662,	-993,
-308,	-395,	-413,	395,	1292,	1838,	1046,	-114,
-633,	-413,	-1134,	-2936,	-3323,	-1591,	317,	580,
-211,	-642,	-440,	-835,	-202,	-18,	-1345,	-2066,
-484,	1108,	475,	-431,	510,	2233,	1960,	826,
730,	615,	220,	668,	1345,	440,	-818,	-1134,
-510,	809,	1161,	563,	-642,	-519,	-774,	-1363,
-1407,	-501,	967,	1064,	1108,	343,	1336,	2892,
3235,	1494,	-774,	-774,	-484,	-299,	501,	1662,
1705,	70,	-826,	-9,	149,	-9,	1222,	2154,
1600,	114,	-123,	1002,	1442,	1749,	2031,	1679,
1301,	1389,	1389,	1363,	1213,	2110,	2049,	-9,
-1336,	-897,	229,	273,	484,	1600,	1081,	-1424,
-1679,	141,	1099,	782,	1020,	2154,	2127,	1776,
1503,	1072,	642,	334,	44,	-1283,	-1741,	-475,
1222,	1363,	1081,	1283,	1002,	404,	-62,	202,
-97,	-1257,	-1327,	-211,	-44,	53,	387,	870,
1776,	1987,	1793,	1187,	554,	598,	431,	-229,
-431,	-818,	-1266,	-1011,	-563,	70,	633,	747,
387,	-106,	-237,	-369,	-88,	519,	545,	-360,
-1204,	-861,	-202,	44,	193,	1169,	1802,	774,
-835,	-1424,	-624,	-378,	-888,	-950,	-774,	-1196,
-1222,	-18,	1046,	589,	-255,	-703,	-906,	-1152,
-1222,	-861,	-668,	-422,	26,	317,	35,	325,
756,	132,	-1011,	-1503,	-1116,	-686,	-1336,	-2295,
-1627,	615,	1846,	1081,	-184,	-730,	-782,	-791,
-317,	-343,	-395,	-35,	88,	229,	202,	-26,
-404,	-765,	-1134,	-1336,	-1046,	-782,	-220,	580,
53,	-1257,	-1749,	-1099,	-1591,	-2207,	-1319,	9,
941,	1072,	-70,	-1996,	-2004,	-1011,	-62,	879,
659,	615,	1046,	958,	255,	-1090,	-1609,	-1732,
-2136,	-1943,	-2110,	-1978,	-35,	1336,	413,	-826,
-844,	-220,	0,	-1169,	-1459,	-791,	958,	2312,
782,	211,	800,	448,	264,	-44,	-1433,	-2189,
-1020,	325,	-317,	-686,	765,	932,	387,	589,
686,	615,	466,	615,	545,	-317,	-1090,	-879,
677,	1705,	800,	-413,	-290,	360,	466,	308,
-580,	-1055,	106,	1424,	606,	-1046,	-703,	440,
606,	352,	237,	528,	1521,	2189,	1486,	606,
501,	756,	739,	290,	-404,	-809,	-35,	1494,
2673,	3147,	1521,	-870,	-1433,	-1275,	-1037,	-598,
255,	1354,	1881,	1978,	1811,	747,	-176,	62,
-9,	-184,	-360,	211,	1714,	2330,	2004,	1468,
1125,	958,	422,	-211,	589,	1108,	923,	510,
545,	1143,	1319,	844,	-563,	-818,	369,	1363,
1319,	1292,	1829,	2417,	1723,	554,	861,	606,
-369,	-220,	431,	993,	1090,	650,	976,	879,
167,	615,	747,	554,	958,	1372,	1565,	1556,
1723,	2233,	2277,	1556,	1283,	1327,	1072,	1143,
1934,	2075,	809,	167,	413,	1029,	1741,	1477,
1556,	2049,	1266,	677,	1002,	1108,	774,	668,
1266,	2198,	2409,	1749,	1600,	1969,	2013,	1143,
176,	114,	721,	1055,	1231,	1767,	2145,	1662,
273,	-853,	-606,	624,	1538,	2040,	2514,	2330,
1494,	888,	633,	255,	352,	791,	571,	193,
554,	1635,	2198,	1969,	1424,	721,	413,	325,
229,	317,	246,	176,	211,	273,	273,	202,
440,	1002,	1846,	1873,	1029,	334,	79,	800,
1108,	-62,	-1055,	-853,	-88,	642,	668,	677,
1354,	1688,	1398,	650,	-528,	-818,	422,	1679,
1477,	149,	132,	1099,	1266,	1161,	1231,	712,
-431,	-395,	44,	-721,	-1099,	-229,	501,	545,
220,	70,	220,	220,	528,	695,	79,	-721,
-800,	-220,	-97,	-818,	-1161,	-149,	1196,	1565,
1169,	730,	695,	1072,	747,	-246,	-1081,	-1196,
-448,	-35,	-308,	-246,	440,	571,	-220,	-765,
-774,	-536,	-580,	-448,	-79,	-730,	-1776,	-1899,
-941,	-273,	0,	-88,	-88,	352,	668,	369,
-457,	-554,	-70,	-79,	-870,	-1222,	-870,	-571,
-589,	-809,	-782,	-1020,	-1161,	-703,	62,	352,
211,	-62,	-281,	-466,	-835,	-1037,	-739,	167,
1064,	879,	62,	-70,	0,	-70,	-158,	-422,
-888,	-1125,	-484,	299,	273,	-62,	237,	457,
-132,	-765,	-712,	79,	818,	1240,	1283,	914,
237,	-317,	-457,	-369,	-167,	106,	317,	387,
246,	-387,	-1020,	-923,	-528,	-325,	-624,	-1081,
-659,	299,	395,	70,	97,	668,	888,	132,
-193,	9,	492,	1055,	642,	-264,	-413,	-378,
-220,	26,	431,	774,	255,	-114,	-123,	62,
114,	-545,	-1011,	-686,	-70,	431,	677,	1029,
1442,	1143,	800,	861,	853,	528,	88,	35,
1020,	1635,	1125,	422,	88,	220,	123,	-88,
-79,	35,	0,	220,	237,	237,	606,	967,
1064,	888,	844,	606,	747,	1398,	1521,	686,
-18,	-149,	149,	659,	466,	255,	431,	422,
26,	-176,	106,	70,	-123,	-79,	-220,	-422,
-123,	360,	378,	299,	352,	475,	668,	897,
703,	167,	-18,	-18,	88,	-184,	-624,	-695,
-334,	571,	800,	-70,	-360,	-123,	-44,	9,
-106,	-395,	-281,	62,	404,	1020,	1143,	1099,
826,	114,	-492,	-317,	448,	545,	106,	387,
712,	114,	-589,	-519,	-220,	35,	-18,	-422,
-598,	132,	1099,	853,	615,	369,	97,	510,
782,	923,	589,	290,	782,	589,	237,	519,
598,	826,	1231,	1424,	1310,	844,	387,	264,
141,	-35,	-70,	18,	475,	677,	668,	1055,
1644,	1547,	888,	774,	404,	202,	739,	1072,
1037,	1002,	941,	686,	571,	440,	484,	686,
598,	501,	123,	202,	870,	1196,	686,	184,
642,	1767,	2066,	914,	360,	642,	1451,	1662,
1407,	1116,	923,	950,	589,	255,	123,	703,
1583,	1521,	686,	484,	492,	378,	739,	923,
941,	466,	457,	1301,	1881,	1793,	1231,	791,
870,	923,	510,	589,	870,	1231,	1714,	1732,
809,	70,	395,	686,	404,	79,	79,	-106,
-70,	88,	202,	264,	519,	1055,	1116,	650,
184,	457,	1134,	1143,	492,	-202,	-782,	-818,
62,	747,	448,	132,	35,	202,	184,	-334,
-606,	-281,	352,	624,	202,	-545,	-606,	273,
993,	835,	-35,	-395,	-193,	281,	703,	360,
-273,	-554,	-79,	273,	-448,	-756,	-281,	211,
97,	-440,	-932,	-1213,	-633,	299,	914,	457,
-440,	-519,	26,	184,	-132,	-184,	123,	334,
-193,	-747,	-826,	-642,	-88,	290,	62,	-308,
-220,	184,	606,	695,	528,	299,	-35,	-360,
-695,	-774,	-264,	404,	809,	739,	246,	-176,
132,	906,	1090,	598,	290,	132,	132,	-211,
-888,	-853,	-123,	501,	466,	-44,	-888,	-923,
-106,	642,	800,	325,	-149,	-123,	176,	202,
62,	-149,	-9,	18,	-369,	-448,	-9,	492,
809,	1072,	941,	589,	141,	-97,	158,	132,
-211,	-334,	-158,	246,	571,	589,	387,	44,
-167,	106,	246,	-106,	-114,	510,	606,	510,
246,	-193,	-440,	-633,	-334,	-281,	-703,	-870,
-246,	519,	668,	325,	184,	360,	132,	-202,
-44,	220,	281,	633,	791,	18,	-475,	-387,
158,	853,	967,	739,	475,	378,	404,	255,
-229,	-545,	-440,	-211,	-149,	-70,	9,	352,
484,	360,	589,	536,	176,	97,	501,	580,
184,	-149,	-360,	-176,	106,	35,	0,	290,
1187,	1723,	1072,	-70,	-448,	88,	642,	659,
387,	343,	571,	809,	826,	1029,	923,	765,
580,	352,	536,	510,	536,	677,	730,	545,
290,	571,	1301,	1776,	1653,	844,	132,	422,
1064,	747,	-404,	-563,	466,	967,	879,	659,
501,	571,	791,	765,	440,	-44,	26,	484,
800,	686,	264,	44,	528,	615,	-325,	-712,
-325,	686,	1398,	1055,	668,	255,	-202,	-264,
-501,	-730,	-580,	-229,	237,	440,	158,	26,
413,	932,	950,	448,	114,	-193,	-114,	158,
-193,	-554,	-545,	-325,	-264,	-756,	-1240,	-650,
255,	861,	870,	448,	202,	387,	791,	492,
-281,	-659,	-571,	-440,	-26,	149,	-44,	-273,
211,	941,	747,	484,	528,	756,	941,	861,
229,	-580,	-1081,	-818,	18,	290,	-79,	-229,
79,	281,	149,	141,	536,	650,	431,	501,
299,	-26,	70,	633,	932,	343,	-413,	-308,
404,	888,	1002,	774,	747,	739,	343,	-308,
-712,	-237,	615,	809,	395,	-35,	26,	571,
712,	246,	-273,	-536,	-220,	519,	958,	1090,
1072,	721,	246,	-237,	-571,	-730,	-395,	273,
712,	624,	0,	-378,	0,	431,	97,	-510,
-457,	-387,	-519,	-97,	800,	932,	281,	273,
413,	-62,	-360,	176,	484,	114,	-299,	-457,
-563,	-677,	-519,	-492,	-712,	-712,	-141,	545,
528,	26,	-114,	70,	18,	-246,	-325,	-202,
-132,	70,	475,	650,	440,	334,	448,	317,
-176,	-739,	-976,	-879,	-888,	-1204,	-1749,	-1583,
-528,	352,	404,	-123,	-193,	149,	79,	-501,
-650,	-255,	106,	62,	53,	273,	475,	563,
299,	-334,	-571,	-79,	317,	290,	-184,	-791,
-1055,	-1081,	-1090,	-1002,	-765,	-404,	-352,	-237,
202,	369,	237,	123,	202,	106,	-334,	-466,
176,	782,	606,	132,	-44,	-132,	-220,	-229,
-624,	-1134,	-1064,	-422,	-44,	-237,	53,	826,
1169,	791,	466,	712,	1213,	1283,	466,	-123,
-123,	-70,	-308,	-756,	-739,	-246,	387,	879,
835,	387,	18,	-18,	193,	-53,	-967,	-1503,
-888,	246,	598,	484,	484,	580,	950,	1011,
528,	308,	395,	844,	1046,	598,	-141,	-457,
-9,	184,	-255,	-739,	-1072,	-1090,	-571,	-281,
-484,	-677,	-519,	-281,	-484,	-650,	-325,	273,
668,	624,	563,	897,	1178,	598,	-457,	-1046,
-993,	-571,	-395,	-466,	-589,	-686,	-264,	106,
-70,	-545,	-712,	-422,	-334,	-466,	-387,	-519,
-475,	35,	211,	-18,	-281,	-229,	237,	369,
132,	-360,	-695,	-343,	-299,	-571,	-598,	-325,
-53,	-79,	-352,	-492,	-501,	0,	642,	598,
378,	334,	334,	352,	422,	378,	404,	273,
62,	-35,	-220,	26,	545,	528,	-18,	-721,
-888,	-589,	-387,	62,	299,	281,	440,	554,
519,	352,	281,	184,	-9,	-70,	35,	176,
475,	818,	721,	44,	-395,	-255,	-35,	-176,
-369,	-413,	-123,	193,	18,	-220,	-132,	167,
211,	26,	35,	387,	598,	782,	932,	756,
492,	352,	545,	571,	18,	-536,	-536,	-18,
343,	149,	141,	580,	703,	422,	70,	-149,
9,	308,	879,	879,	299,	-35,	88,	571,
870,	800,	580,	563,	897,	932,	431,	-158,
9,	554,	519,	-308,	-941,	-343,	765,	1099,
861,	624,	712,	1152,	1345,	950,	97,	-308,
-26,	554,	1055,	923,	519,	466,	642,	413,
-44,	-395,	-106,	615,	950,	598,	26,	114,
642,	677,	229,	-123,	26,	686,	1011,	870,
756,	879,	967,	861,	545,	255,	-132,	-431,
-26,	457,	431,	184,	184,	501,	633,	88,
-193,	106,	475,	765,	528,	70,	9,	220,
466,	782,	747,	571,	747,	756,	360,	-53,
-317,	-334,	-211,	88,	193,	18,	97,	484,
659,	220,	-53,	184,	519,	404,	-176,	-589,
-440,	-70,	-501,	-1002,	-1020,	-809,	-158,	431,
510,	677,	870,	659,	571,	176,	-642,	-950,
-387,	-18,	-229,	-492,	-352,	193,	703,	791,
422,	158,	97,	-62,	-184,	-281,	-281,	-123,
492,	756,	149,	-97,	308,	299,	360,	246,
-264,	176,	739,	404,	9,	-123,	-79,	26,
-141,	-404,	-580,	-369,	123,	466,	510,	334,
26,	-264,	-281,	26,	325,	378,	598,	985,
967,	413,	-44,	-9,	70,	176,	237,	26,
-334,	-431,	-237,	0,	246,	264,	220,	149,
-62,	-378,	-739,	-360,	466,	914,	800,	106,
-290,	-88,	246,	343,	273,	466,	809,	571,
-246,	-431,	88,	413,	202,	-184,	-466,	-598,
-281,	246,	747,	1011,	932,	756,	668,	387,
-202,	-510,	-281,	211,	633,	932,	1169,	1336,
1363,	1204,	422,	-299,	-422,	-255,	211,	528,
413,	-18,	53,	659,	712,	255,	246,	686,
1055,	888,	545,	360,	457,	782,	993,	1055,
686,	246,	220,	668,	1187,	923,	800,	1204,
1477,	870,	53,	-237,	-35,	211,	123,	-26,
-44,	378,	721,	941,	1354,	1574,	1380,	879,
369,	62,	-193,	-70,	378,	826,	1152,	985,
1037,	1477,	1670,	1433,	747,	325,	184,	26,
-413,	-950,	-519,	501,	1108,	1178,	1161,	1099,
914,	765,	448,	352,	422,	369,	281,	325,
659,	440,	-141,	-62,	202,	299,	378,	554,
774,	765,	563,	290,	299,	448,	615,	624,
712,	721,	606,	818,	1055,	1116,	668,	352,
431,	721,	1283,	1283,	589,	395,	739,	686,
79,	-229,	413,	1248,	1327,	1240,	1064,	932,
668,	149,	264,	571,	492,	352,	703,	1327,
1319,	1116,	1029,	369,	-317,	-563,	-281,	492,
1161,	1521,	1591,	1064,	730,	800,	448,	88,
352,	861,	1055,	387,	-343,	62,	642,	739,
413,	-97,	62,	580,	1002,	712,	53,	9,
431,	642,	387,	598,	1204,	1468,	1257,	1002,
739,	334,	97,	-18,	-53,	-62,	-149,	35,
457,	598,	712,	650,	475,	440,	501,	897,
950,	229,	-79,	97,	229,	528,	897,	888,
466,	44,	325,	826,	897,	800,	747,	941,
633,	193,	44,	-97,	123,	712,	1204,	1002,
554,	457,	686,	624,	475,	431,	220,	62,
-255,	-352,	0,	141,	484,	774,	554,	484,
448,	141,	-184,	-193,	220,	580,	475,	519,
484,	184,	176,	237,	158,	211,	290,	571,
633,	510,	484,	413,	545,	264,	-70,	62,
273,	519,	545,	-79,	-290,	-202,	-598,	-695,
-220,	475,	826,	615,	554,	967,	1222,	1354,
1055,	158,	-642,	-835,	-528,	-132,	457,	958,
1196,	1108,	571,	-70,	-325,	167,	774,	686,
0,	-308,	-97,	184,	431,	325,	123,	193,
686,	923,	668,	528,	739,	906,	413,	-229,
-440,	-457,	-404,	123,	712,	730,	378,	237,
360,	158,	-281,	-606,	-571,	-325,	35,	264,
352,	466,	387,	-62,	-457,	-563,	-264,	317,
440,	114,	-229,	-369,	-712,	-976,	-501,	-158,
0,	202,	404,	132,	-334,	-448,	-528,	-686,
-976,	-1125,	-1072,	-624,	220,	642,	440,	53,
-308,	-739,	-1213,	-1477,	-1530,	-1459,	-1108,	-536,
-149,	-193,	-202,	53,	325,	158,	-290,	-484,
-440,	-202,	-369,	-826,	-932,	-695,	-563,	-554,
-686,	-404,	308,	668,	343,	-53,	-246,	-554,
-941,	-1037,	-809,	-791,	-826,	-703,	-440,	-334,
-167,	167,	281,	343,	193,	-369,	-993,	-941,
-457,	-132,	0,	184,	281,	44,	-79,	123,
141,	-18,	-106,	-237,	-317,	-123,	-88,	-44,
132,	360,	299,	-273,	-536,	-352,	-308,	-466,
-440,	-79,	106,	-264,	-615,	-378,	158,	352,
193,	9,	-246,	-317,	9,	193,	299,	457,
299,	-211,	-818,	-870,	-571,	-44,	440,	545,
413,	-79,	-668,	-730,	-35,	440,	273,	-53,
-176,	-62,	167,	563,	703,	422,	18,	-334,
-457,	-686,	-580,	53,	695,	897,	246,	-554,
-721,	-431,	44,	343,	141,	149,	580,	695,
422,	62,	-184,	-317,	-369,	-308,	-114,	-184,
-18,	422,	765,	782,	352,	-79,	-281,	-325,
-352,	-211,	97,	255,	-9,	-571,	-993,	-1046,
-721,	-519,	-633,	-606,	-378,	-273,	-404,	-317,
53,	457,	149,	-484,	-985,	-914,	-440,	-237,
-334,	-431,	-255,	-18,	-26,	-193,	-325,	-448,
-589,	-633,	-747,	-958,	-1046,	-844,	-642,	-774,
-958,	-941,	-457,	97,	220,	-184,	-229,	18,
114,	-70,	-220,	-88,	44,	123,	0,	-440,
-861,	-624,	-132,	-184,	-774,	-1494,	-1767,	-1213,
-387,	44,	-26,	-132,	-255,	-695,	-1020,	-1037,
-765,	-88,	352,	0,	-765,	-853,	-299,	123,
62,	-422,	-730,	-536,	-44,	-79,	-387,	-290,
-44,	9,	-352,	-897,	-1257,	-941,	53,	650,
431,	167,	431,	739,	624,	44,	-721,	-1002,
-528,	149,	334,	79,	132,	431,	378,	-26,
-606,	-985,	-1196,	-1081,	-554,	-97,	-255,	-528,
-237,	378,	703,	589,	440,	167,	-44,	-273,
-317,	-44,	-18,	-308,	-606,	-695,	-369,	-167,
-387,	-695,	-914,	-861,	-475,	-220,	-123,	-325,
-659,	-545,	-325,	-308,	-492,	-528,	-281,	-132,
-193,	-325,	-352,	-378,	-422,	-492,	-440,	-466,
-791,	-1266,	-1372,	-906,	-299,	-149,	-264,	-246,
-308,	-756,	-1310,	-1231,	-730,	-281,	0,	184,
273,	369,	35,	-395,	-413,	-290,	-404,	-703,
-730,	-299,	114,	-79,	-501,	-536,	-176,	53,
-70,	-273,	-554,	-589,	-62,	492,	317,	-308,
-633,	-528,	-317,	-246,	-246,	-149,	26,	97,
-132,	-554,	-703,	-106,	519,	492,	-106,	-545,
-281,	-44,	-229,	-501,	-352,	26,	299,	334,
184,	114,	325,	571,	448,	-35,	-413,	-246,
264,	404,	53,	-325,	-308,	53,	184,	-141,
-369,	26,	606,	747,	193,	-387,	-519,	-167,
158,	97,	-26,	79,	475,	624,	422,	132,
-149,	-211,	-158,	-158,	-141,	-9,	202,	440,
325,	-202,	-519,	-88,	431,	395,	-18,	-184,
-53,	88,	246,	184,	114,	70,	176,	211,
-53,	-44,	123,	413,	580,	510,	220,	-184,
-378,	-211,	-106,	-202,	-79,	220,	395,	211,
-9,	26,	176,	360,	528,	580,	431,	360,
299,	220,	132,	184,	510,	782,	826,	598,
299,	193,	202,	-9,	-255,	-193,	158,	281,
334,	422,	466,	571,	712,	615,	404,	264,
466,	765,	765,	448,	70,	-26,	246,	545,
659,	739,	747,	897,	1081,	923,	510,	0,
-387,	-317,	-193,	35,	343,	791,	1345,	1679,
1811,	1600,	1248,	1169,	1372,	1222,	703,	448,
484,	484,	747,	1134,	1257,	1046,	879,	809,
650,	510,	448,	448,	563,	484,	325,	343,
528,	818,	1152,	1521,	1530,	950,	484,	273,
273,	492,	879,	932,	510,	158,	53,	88,
141,	211,	466,	624,	440,	18,	-114,	158,
457,	484,	88,	-211,	9,	378,	404,	369,
598,	800,	571,	70,	-475,	-756,	-440,	62,
211,	-193,	-606,	-668,	-580,	-404,	-88,	202,
88,	-9,	202,	299,	53,	-325,	-440,	-299,
-132,	18,	0,	-9,	246,	413,	184,	-360,
-1002,	-1143,	-624,	-317,	-343,	-211,	149,	484,
431,	-167,	-739,	-782,	-536,	-149,	246,	501,
545,	422,	264,	141,	-202,	-334,	-246,	-114,
202,	413,	255,	158,	281,	-44,	-659,	-853,
-352,	510,	897,	721,	598,	536,	229,	-149,
-202,	-202,	-229,	62,	501,	580,	273,	44,
9,	-9,	-70,	-44,	53,	158,	106,	97,
211,	44,	-149,	-281,	-281,	0,	431,	712,
791,	615,	334,	70,	-369,	-580,	-659,	-369,
70,	308,	360,	404,	53,	-114,	264,	598,
818,	809,	721,	633,	448,	501,	413,	88,
-18,	53,	457,	739,	721,	809,	844,	448,
35,	-308,	-484,	-466,	-149,	70,	-167,	-193,
255,	378,	-97,	-237,	-53,	114,	308,	571,
756,	589,	484,	431,	211,	35,	-132,	-158,
-9,	246,	466,	501,	422,	299,	0,	-229,
-211,	-273,	-237,	-158,	-114,	-193,	-299,	-141,
202,	545,	589,	378,	193,	149,	290,	149,
-193,	-440,	-536,	-589,	-431,	-26,	273,	466,
475,	369,	123,	-123,	-308,	-413,	-360,	-79,
106,	-35,	-132,	70,	325,	308,	325,	510,
299,	-317,	-756,	-818,	-756,	-589,	-343,	-9,
114,	-18,	-308,	-554,	-528,	-123,	202,	132,
106,	184,	176,	26,	-149,	-229,	-220,	-62,
114,	9,	-422,	-536,	-264,	-18,	-35,	-97,
-167,	-387,	-668,	-950,	-1108,	-914,	-343,	184,
246,	-97,	-334,	-387,	-395,	-325,	-26,	88,
-97,	-184,	-334,	-580,	-782,	-650,	-220,	-184,
-615,	-1020,	-1143,	-923,	-721,	-879,	-1090,	-1002,
-510,	-106,	-70,	-202,	-229,	-53,	-35,	-123,
-387,	-633,	-712,	-501,	-264,	-290,	-466,	-519,
-378,	-317,	-369,	-484,	-308,	-123,	-97,	-360,
-800,	-1055,	-844,	-563,	-571,	-554,	-184,	360,
360,	-26,	-281,	-237,	-62,	-114,	-475,	-844,
-686,	-237,	97,	18,	-378,	-431,	-246,	-237,
-606,	-826,	-668,	-308,	35,	106,	-290,	-800,
-633,	-18,	404,	255,	0,	62,	308,	246,
-264,	-650,	-791,	-633,	-422,	-237,	-106,	220,
308,	149,	-167,	-395,	-360,	-317,	-246,	-167,
-149,	-176,	-62,	97,	202,	88,	-44,	176,
290,	-18,	-246,	-26,	308,	317,	158,	-176,
-492,	-475,	-308,	-70,	132,	220,	237,	220,
141,	79,	-79,	-132,	-9,	79,	149,	202,
132,	53,	167,	62,	-132,	-167,	53,	378,
220,	-88,	-88,	-44,	-158,	-325,	-290,	-149,
35,	395,	624,	387,	-88,	-246,	9,	220,
106,	-53,	-149,	-18,	220,	484,	475,	193,
9,	-9,	62,	53,	97,	176,	220,	202,
220,	-106,	-633,	-739,	-475,	-343,	-360,	-264,
-18,	149,	123,	-35,	-229,	-387,	-413,	-510,
-528,	-360,	-44,	149,	106,	18,	-141,	-281,
-290,	-325,	-404,	-378,	-395,	-492,	-413,	-273,
-281,	-484,	-563,	-334,	-88,	35,	70,	-123,
-369,	-475,	-448,	-466,	-633,	-633,	-334,	97,
70,	-106,	-70,	9,	-53,	-308,	-536,	-721,
-606,	-413,	-141,	-123,	-352,	-624,	-650,	-554,
-774,	-888,	-606,	-273,	-220,	-229,	-70,	0,
-35,	-97,	-290,	-475,	-466,	-378,	-475,	-369,
-114,	53,	106,	114,	-97,	-615,	-782,	-589,
-317,	-106,	-44,	-132,	-290,	-325,	-202,	-395,
-650,	-615,	-431,	-352,	-255,	-123,	-26,	53,
123,	246,	114,	-123,	-317,	-184,	-123,	-281,
-448,	-589,	-536,	-395,	-395,	-589,	-510,	-334,
-281,	-255,	-149,	44,	53,	-158,	-528,	-1002,
-1152,	-800,	-193,	184,	70,	-97,	-88,	-114,
-343,	-712,	-774,	-554,	-510,	-571,	-650,	-606,
-466,	-325,	-334,	-501,	-826,	-826,	-457,	-123,
-97,	-273,	-413,	-484,	-545,	-571,	-633,	-739,
-712,	-475,	-211,	-317,	-580,	-466,	-273,	-580,
-1072,	-1327,	-1213,	-853,	-360,	-79,	-114,	-237,
-519,	-835,	-1134,	-1125,	-1011,	-800,	-624,	-712,
-844,	-870,	-633,	-457,	-501,	-642,	-774,	-791,
-677,	-475,	-580,	-897,	-958,	-747,	-677,	-950,
-967,	-536,	44,	184,	-79,	-299,	-501,	-615,
-800,	-1064,	-1116,	-906,	-686,	-695,	-906,	-958,
-677,	-448,	-536,	-844,	-932,	-826,	-739,	-659,
-633,	-615,	-756,	-642,	-528,	-642,	-668,	-528,
-360,	-255,	-264,	-492,	-835,	-950,	-888,	-809,
-536,	-149,	26,	-88,	-255,	-317,	-431,	-712,
-923,	-993,	-923,	-721,	-413,	-246,	-352,	-448,
-325,	-184,	-202,	-475,	-765,	-739,	-387,	-149,
-343,	-650,	-712,	-519,	-404,	-290,	-149,	53,
281,	352,	369,	246,	70,	-62,	-299,	-501,
-395,	-70,	229,	352,	440,	237,	-114,	-62,
-53,	-193,	-440,	-519,	-70,	466,	739,	721,
730,	861,	923,	703,	431,	281,	290,	528,
563,	387,	395,	598,	739,	782,	765,	791,
941,	1037,	879,	360,	-88,	-106,	176,	659,
1020,	1354,	1468,	1222,	888,	765,	765,	800,
730,	739,	739,	695,	756,	765,	606,	475,
466,	501,	580,	739,	844,	923,	1002,	923,
571,	264,	264,	308,	413,	440,	528,	774,
1187,	1415,	1178,	756,	492,	413,	387,	492
};

__eds__ __attribute__((space(prog))) int16_t SAMPLE_bowscrape1[sample_length] = {
171,	1616,	-5914,	-8987,	1557,	3032,	-2203,	5382,
-6362,	34,	-3383,	1114,	6591,	2324,	-6876,	264,
-822,	3512,	315,	8452,	-1012,	8660,	13052,	5247,
-841,	4270,	5216,	-6796,	745,	5187,	2309,	-27,
10732,	2370,	-4281,	2563,	6042,	7837,	13836,	8118,
7774,	4657,	141,	9147,	9517,	5724,	6561,	10609,
12544,	11498,	-529,	-7867,	-468,	-1795,	10151,	1800,
-215,	5843,	3678,	823,	2270,	2983,	4621,	7930,
6528,	14876,	4962,	-185,	997,	9518,	6124,	6088,
10823,	8117,	9137,	5167,	10283,	3592,	2793,	1868,
-2788,	8960,	4145,	9707,	9796,	5168,	-3074,	660,
9286,	17307,	7078,	-508,	7594,	8021,	141,	-6674,
-9806,	-6559,	-14194,	-16313,	-1812,	7624,	9797,	-1548,
5425,	11490,	15231,	17414,	19560,	25005,	28147,	15410,
19623,	24330,	12646,	7525,	3437,	3192,	-1098,	-1212,
-7025,	-7794,	-11941,	-10598,	-2198,	7224,	-553,	6496,
1642,	-4380,	-7325,	-6086,	-11161,	-15658,	-16299,	-5186,
-4953,	-15378,	-5997,	-3972,	6112,	7053,	12882,	874,
5952,	-993,	-6414,	-3893,	458,	7412,	10199,	3905,
2226,	9337,	-3050,	3279,	-6441,	3821,	1288,	437,
2694,	2190,	5229,	13920,	10240,	4041,	3325,	-2229,
4094,	-3165,	4894,	13106,	8446,	13491,	13869,	11470,
7309,	8987,	1221,	-736,	-819,	3102,	12560,	13340,
19984,	19522,	10960,	238,	10430,	12379,	13527,	3612,
14445,	3376,	-4049,	6173,	11241,	-2064,	8824,	12987,
14266,	5358,	10999,	1526,	13598,	15363,	581,	-913,
394,	-292,	514,	574,	66,	164,	-110,	444,
385,	585,	-78,	-525,	-663,	249,	282,	-151,
-281,	-125,	-263,	-166,	178,	185,	-143,	-617,
165,	271,	-142,	-338,	-513,	-892,	-845,	-60,
215,	-195,	-348,	-692,	-775,	-456,	75,	-34,
226,	-486,	-239,	-469,	-231,	-257,	-386,	-117,
-213,	199,	-226,	310,	282,	328,	-227,	-496,
-655,	-272,	-643,	-566,	-413,	-222,	-347,	-191,
337,	747,	71,	43,	466,	-345,	-296,	-610,
-962,	-241,	-884,	-972,	-102,	-877,	-442,	-329,
89,	324,	474,	225,	670,	-228,	-267,	86,
-1,	591,	-62,	-27,	-400,	-456,	148,	-498,
-229,	-653,	-383,	-694,	-464,	-753,	-1112,	-965,
-569,	-460,	-179,	-521,	-706,	-407,	-213,	-64,
151,	572,	662,	799,	442,	442,	193,	-40,
-208,	-513,	-784,	-714,	131,	-281,	-250,	151,
567,	296,	-221,	178,	-110,	120,	222,	-209,
-126,	153,	-557,	42,	-641,	-472,	-894,	-1208,
-1178,	-1064,	-1136,	-1155,	-1237,	-1013,	-1275,	-1048,
-1494,	-1349,	-729,	-539,	-83,	66,	343,	-87,
368,	187,	-428,	-425,	-454,	268,	-279,	-510,
-565,	-954,	-1034,	-279,	-117,	239,	-441,	-800,
-1096,	-472,	-925,	-1130,	-663,	-78,	-543,	-51,
266,	-171,	-734,	-876,	-929,	-1093,	-1385,	-1487,
-1466,	-1382,	-1289,	-1118,	-1390,	-1725,	-1018,	-1086,
-677,	-798,	-485,	-2327,	-11135,	-14563,	-7740,	-581,
5361,	1083,	-2631,	1754,	-6199,	-9058,	-1659,	-2847,
-240,	420,	6746,	2731,	2930,	-7191,	-3127,	-47,
-2536,	253,	9334,	-2220,	-1091,	7089,	3456,	11643,
-1896,	-10152,	5273,	-3009,	8436,	5696,	-5184,	-1906,
-6781,	3351,	-3835,	-12892,	2281,	-5667,	-12231,	-18686,
-19255,	-20108,	-23516,	-28510,	-15923,	-20899,	-18032,	-9599,
-4827,	-996,	5201,	671,	-4360,	-3996,	-9105,	-5725,
-7800,	-650,	-4834,	-5867,	-9586,	-13698,	-18076,	-8226,
-16990,	-16516,	-10571,	-18804,	-4479,	-9606,	-7973,	-13869,
-2195,	4374,	4512,	-8605,	680,	-3508,	-5767,	-14934,
-14278,	-1737,	-6226,	-6090,	-14556,	-15574,	-12760,	-12987,
-9582,	-14268,	-13330,	-18933,	-5205,	-10376,	-16582,	-9795,
-10218,	-10962,	-7100,	696,	2171,	555,	2382,	-177,
-8673,	-13406,	-4011,	-15287,	-16421,	-8152,	-7763,	-15055,
-2568,	-919,	-4409,	-15563,	-16247,	-9023,	1448,	-13470,
-14898,	-6133,	-4735,	-15173,	-22047,	-25659,	-25384,	-14310,
-21898,	-25451,	-21051,	-24258,	-31303,	-15313,	-12558,	-12696,
-3767,	-17866,	-22279,	-28391,	-17187,	-20755,	-18753,	-19135,
-23703,	-20832,	-23381,	-13872,	-8527,	-17811,	-20990,	-22925,
-29817,	-32239,	-26720,	-15908,	-10481,	-11681,	-10505,	-1894,
-4737,	-13804,	-17231,	-6794,	-3176,	-4753,	-13212,	-9876,
-18179,	-20434,	-26176,	-28110,	-28608,	-22390,	-19481,	-21852,
-17681,	-21972,	-29358,	-21783,	-13160,	-10699,	-17445,	-15048,
-4735,	744,	-3338,	-15835,	-2901,	-8360,	-10722,	-7605,
-16516,	-4501,	-12577,	-13200,	-14732,	-5119,	-6804,	-18306,
-14378,	-6393,	-1144,	-1071,	-419,	12,	-442,	-1095,
-1181,	-539,	-10,	-934,	-382,	-992,	-752,	-525,
-1049,	-926,	-803,	-1269,	-1245,	-1670,	-1849,	-1616,
-948,	-1262,	-1026,	-1028,	-1208,	-1366,	-1293,	-619,
-337,	-50,	-315,	-68,	-356,	-829,	-895,	-268,
-846,	-864,	-1001,	-837,	-820,	-915,	-1340,	-951,
-1080,	-973,	-352,	-696,	-1207,	-1349,	-849,	-938,
-793,	-1409,	-964,	-921,	-770,	-809,	-1224,	-932,
-1528,	-1749,	-1537,	-1964,	-1556,	-1989,	-2087,	-1461,
-1944,	-2284,	-2123,	-1759,	-1251,	-852,	-1093,	-1694,
-1912,	-1438,	-1410,	-1807,	-1258,	-760,	-592,	-1086,
-1696,	-1525,	-1157,	-744,	-1180,	-1414,	-1079,	-722,
-575,	-1192,	-1411,	-800,	-1123,	-1083,	-1357,	-855,
-844,	-1106,	-1255,	-1198,	-1596,	-829,	-564,	-140,
80,	-879,	-311,	-336,	127,	-700,	-637,	-63,
-254,	-466,	97,	190,	342,	228,	-446,	-105,
145,	-619,	-765,	-145,	-694,	-366,	-492,	-214,
192,	136,	171,	-123,	468,	-410,	-124,	139,
314,	168,	415,	554,	681,	-225,	-192,	48,
-186,	116,	505,	214,	647,	578,	472,	819,
663,	450,	663,	611,	765,	1018,	194,	358,
-88,	582,	716,	585,	123,	780,	200,	-377,
52,	268,	-428,	-5,	40,	-631,	-27,	-474,
-329,	-208,	238,	-521,	-291,	-70,	-261,	-448,
-235,	105,	457,	257,	714,	402,	-129,	386,
-41,	304,	712,	1062,	60,	876,	-2355,	-8635,
-11155,	-6511,	-7912,	-13104,	-4241,	-2189,	-10001,	-2023,
1273,	6415,	-2670,	-2988,	-12842,	1453,	175,	-3418,
3290,	8465,	-5914,	-14256,	-18484,	-19826,	-20839,	-20082,
-7535,	-11197,	-8331,	-6608,	-2482,	589,	4000,	2694,
9384,	14308,	9887,	-2393,	-5649,	-3283,	6947,	11993,
6831,	-556,	1990,	4656,	10219,	1652,	1214,	11183,
-2187,	-1907,	-246,	-5570,	-3205,	512,	-9637,	-10570,
-8837,	-108,	-5577,	-10760,	-16727,	-5792,	-108,	-3936,
-12159,	-10412,	-6287,	-14238,	-15665,	-12732,	-5120,	-4221,
-10721,	-19203,	-19162,	-17518,	-6288,	-12283,	-16921,	-21832,
-25332,	-13830,	-9867,	-12922,	-20706,	-10138,	-13938,	-13429,
-20801,	-15223,	-12575,	-9153,	-20295,	-6706,	-10863,	-21031,
-9751,	-20204,	-22650,	-9736,	-18296,	-15292,	-4048,	-13421,
-21605,	-26899,	-13389,	-16594,	-21096,	-8196,	-13543,	-12684,
-16032,	-7570,	-69,	-3097,	3633,	4148,	-8590,	2646,
9164,	12557,	13370,	8986,	13312,	14060,	9129,	812,
8501,	8719,	3922,	12062,	12133,	15800,	8084,	8860,
14877,	19207,	21866,	10667,	6637,	2275,	14010,	4250,
14375,	4612,	9731,	13036,	5575,	10011,	17451,	5673,
11680,	15945,	16283,	13107,	2138,	11916,	8030,	782,
8111,	8673,	-1630,	2823,	9613,	11157,	4266,	12430,
3983,	11277,	18276,	14294,	19118,	13805,	14289,	13810,
21573,	9756,	9610,	14130,	19865,	26108,	28482,	12456,
3639,	11460,	16682,	23840,	19049,	25648,	10149,	13230,
22710,	28652,	16550,	9851,	16816,	15637,	18289,	18654,
21145,	21399,	17347,	8772,	1434,	1751,	1374,	1128,
594,	967,	1201,	762,	829,	436,	863,	1326,
693,	1128,	1162,	760,	546,	59,	622,	476,
665,	792,	1155,	426,	-49,	841,	1216,	1447,
1157,	1618,	1321,	518,	288,	42,	-95,	-468,
545,	98,	722,	171,	161,	906,	698,	471,
291,	-213,	662,	976,	1087,	525,	498,	2,
500,	959,	1344,	820,	879,	1140,	1467,	637,
917,	1466,	987,	1245,	1436,	1611,	1965,	2147,
2278,	1339,	1537,	2055,	1159,	847,	423,	937,
791,	1377,	1120,	1362,	1388,	1625,	1662,	1415,
1931,	2000,	1911,	1046,	1160,	1669,	1059,	515,
1370,	1188,	1576,	793,	666,	1242,	1269,	912,
388,	257,	545,	220,	68,	815,	746,	388,
-139,	335,	806,	208,	748,	225,	312,	884,
1219,	470,	-19,	-310,	-497,	-352,	225,	763,
1126,	162,	564,	1153,	1313,	485,	350,	541,
250,	-207,	-391,	-460,	344,	-175,	291,	-281,
138,	770,	863,	31,	202,	737,	250,	757,
937,	371,	97,	18,	-358,	-191,	-484,	-330,
-739,	-143,	128,	30,	411,	681,	1007,	676,
228,	767,	117,	13,	31,	-82,	-593,	-349,
35,	-50,	-485,	-491,	-582,	-210,	-594,	-394,
-88,	-598,	-534,	-288,	-345,	-282,	-346,	-232,
-374,	-364,	-200,	-261,	108,	-261,	98,	-92,
-142,	-142,	-539,	61,	-249,	326,	-315,	-2398,
2092,	-5516,	80,	6665,	10996,	3552,	8815,	1880,
447,	2018,	6228,	4134,	-21,	-6682,	-9943,	-1013,
6197,	6142,	-2838,	1893,	5440,	13950,	11148,	18258,
5132,	3482,	15258,	16299,	13042,	10301,	9596,	2368,
3740,	-4478,	-4901,	-5617,	-5550,	-11435,	-13023,	-16768,
-6598,	-479,	-4475,	-565,	-4480,	-13555,	-6976,	1074,
-8136,	-6924,	-6792,	-725,	4041,	1331,	9750,	486,
-3160,	5981,	-693,	-6753,	-9560,	1538,	-10129,	-11262,
-2965,	-4096,	2974,	-2785,	-10759,	-16832,	-19329,	-20270,
-5633,	-723,	1178,	-679,	-7447,	-15407,	-15554,	-20701,
-7548,	-4508,	-13876,	-15079,	-11140,	-6890,	-3982,	164,
4355,	2506,	8865,	-4970,	3015,	11017,	-2389,	-4807,
-11789,	-6753,	-12697,	-8765,	-1520,	-2522,	1177,	-6409,
-9617,	-10948,	2119,	93,	-10128,	-13570,	-10696,	-15911,
-19592,	-9939,	-14519,	-4337,	-1223,	-8035,	-12952,	-13509,
-16950,	-20717,	-14007,	-18521,	-5102,	693,	1796,	2004,
4215,	-9243,	-12268,	-13878,	-17111,	-21668,	-12312,	-14471,
-7527,	-5643,	-7730,	2384,	-6190,	-2796,	3600,	-7842,
-14658,	-6038,	-723,	3470,	-2136,	-313,	1107,	-4986,
4151,	4622,	-5323,	-5562,	1595,	8051,	1953,	-7630,
-1382,	-3856,	-12939,	559,	1688,	-3125,	-6920,	-15245,
-19247,	-8984,	-6906,	-17701,	-14279,	-6024,	-2524,	-4688,
-3944,	-7036,	-4726,	-6277,	2893,	5809,	-1531,	-5067,
6057,	11017,	6517,	-865,	-1374,	-3007,	-9866,	92,
-994,	2537,	2452,	6445,	4682,	-3097,	-4642,	-10151,
704,	-7900,	-3080,	3371,	97,	4915,	778,	-51,
-445,	-622,	-57,	515,	700,	65,	53,	177,
-14,	-197,	6,	-140,	-9,	560,	267,	-52,
424,	521,	792,	1110,	998,	872,	222,	-256,
-220,	-312,	-697,	-643,	-275,	402,	283,	-189,
-470,	-711,	-680,	-457,	-839,	-583,	-375,	-358,
181,	-575,	-781,	-895,	-31,	-465,	-425,	-128,
274,	404,	717,	459,	-227,	114,	88,	-34,
188,	-530,	-525,	-346,	-546,	-323,	48,	63,
555,	-312,	-365,	-742,	73,	-249,	87,	-574,
205,	529,	136,	-357,	221,	-193,	298,	-146,
211,	754,	947,	654,	-41,	303,	697,	372,
594,	995,	1207,	430,	215,	512,	763,	311,
133,	-150,	658,	667,	768,	690,	749,	674,
1058,	338,	-28,	132,	207,	799,	771,	1058,
497,	-99,	657,	914,	397,	-139,	-499,	-116,
-424,	-514,	-577,	-901,	-267,	-387,	-327,	132,
-512,	-93,	-322,	-883,	-927,	-967,	-774,	-351,
-143,	370,	80,	-250,	45,	-49,	71,	262,
-418,	-488,	-878,	-1069,	-682,	-575,	-450,	-142,
-265,	308,	694,	797,	921,	-32,	-43,	-537,
30,	-389,	-192,	402,	126,	125,	527,	555,
8,	-449,	-314,	265,	-97,	-388,	333,	6,
97,	484,	392,	-108,	-621,	-93,	-297,	-461,
156,	98,	144,	-496,	-565,	271,	84,	-186,
-1,	-596,	96,	-614,	-103,	276,	-466,	-932,
-1075,	-329,	-7860,	-21084,	-10173,	-4169,	-9039,	997,
8155,	-3042,	1086,	3164,	-5744,	-2598,	6094,	-7282,
-8761,	-10783,	-2984,	-11493,	873,	6478,	-3202,	-3975,
1324,	-4620,	-3726,	5030,	5236,	2628,	10386,	9134,
12065,	6772,	5736,	10696,	4436,	6844,	-1837,	5906,
-1544,	8580,	8073,	15734,	16540,	5101,	774,	-5957,
1649,	12184,	18321,	10719,	18785,	11241,	14776,	10369,
19103,	16162,	17440,	23953,	8981,	6248,	11443,	19484,
12618,	9143,	19138,	23255,	8447,	14060,	5103,	11774,
1581,	10826,	12175,	11550,	15706,	19650,	4956,	17957,
13554,	5556,	-1891,	-3256,	8070,	5323,	5344,	13039,
20406,	8087,	14672,	14256,	3989,	-3461,	-6822,	1287,
10770,	-271,	1817,	-5749,	7543,	14968,	12914,	-49,
-6684,	187,	-8709,	1707,	-76,	7206,	-891,	5378,
-5492,	-9824,	-2637,	2434,	-4182,	-11402,	-3262,	784,
-6446,	-11853,	-16551,	-19798,	-18623,	-10702,	-5731,	2625,
-10614,	-4260,	-6011,	-15852,	-14076,	-11289,	-8738,	-11060,
-8809,	-7010,	-13181,	-3788,	-7703,	-2155,	-2694,	-187,
22,	1627,	-2904,	6240,	-2483,	-1678,	5748,	-3909,
5256,	-6933,	4675,	5050,	-4459,	-8120,	-11063,	-9808,
-9596,	-3482,	4863,	-5307,	5726,	4354,	-4333,	2778,
1926,	4095,	2455,	7951,	3730,	-2502,	-9215,	-3422,
7940,	-2829,	-10123,	1869,	-7647,	-13653,	-15474,	-16699,
-3480,	-11341,	-4769,	-9963,	-260,	-11192,	-15908,	-797,
-9617,	-8317,	-11946,	-18670,	-9385,	-4124,	-3291,	-1630,
7079,	2728,	-3356,	3775,	6970,	-2087,	1004,	2232,
1614,	952,	721,	419,	313,	125,	73,	630,
-87,	81,	580,	-223,	83,	289,	157,	-362,
-29,	-559,	44,	626,	687,	395,	-85,	579,
424,	218,	-284,	221,	499,	596,	134,	140,
727,	748,	760,	472,	-75,	729,	912,	1012,
156,	512,	897,	1072,	1402,	1027,	1028,	966,
774,	168,	763,	240,	612,	671,	1166,	1336,
1140,	685,	461,	536,	29,	654,	1034,	203,
-17,	772,	172,	306,	-22,	473,	-212,	450,
-259,	398,	-193,	-163,	304,	55,	291,	296,
107,	506,	623,	842,	325,	959,	621,	-1,
114,	465,	329,	691,	897,	1173,	1049,	1188,
1406,	1473,	1767,	1213,	677,	1061,	840,	796,
318,	1118,	489,	586,	68,	-120,	-405,	109,
641,	9,	555,	1009,	745,	891,	911,	1074,
265,	919,	184,	93,	-302,	-145,	-57,	-13,
268,	-382,	471,	303,	541,	1037,	1087,	773,
439,	680,	716,	996,	609,	1238,	1598,	1707,
768,	1190,	1220,	1074,	1371,	1788,	1019,	733,
405,	923,	1030,	1073,	896,	1490,	1285,	857,
517,	122,	-77,	-125,	571,	929,	712,	1285,
665,	98,	921,	1056,	558,	-23,	-383,	257,
-324,	547,	548,	406,	712,	220,	-56,	312,
209,	728,	1002,	386,	835,	634,	1130,	1483,
1666,	705,	678,	1389,	1448,	1498,	1140,	1265,
929,	414,	1049,	1261,	10465,	19697,	14038,	23367,
19613,	19978,	11131,	14126,	8687,	19799,	13665,	3874,
-160,	2883,	557,	2884,	-1350,	6897,	16007,	10396,
19681,	19204,	23435,	29522,	13472,	10875,	23085,	18204,
24429,	16554,	24605,	14805,	6801,	5865,	7635,	13659,
2170,	847,	13251,	9984,	9114,	15593,	18775,	10728,
9182,	5495,	9124,	12653,	1617,	14329,	12560,	3792,
1830,	2087,	3866,	2285,	5491,	2973,	-3688,	7414,
13602,	18445,	20345,	12489,	18479,	20650,	21931,	23626,
29789,	16980,	13053,	19810,	27135,	25287,	14819,	14261,
8459,	21230,	16828,	25685,	31847,	20881,	12270,	25268,
23594,	14030,	11813,	6576,	7362,	15540,	10566,	12613,
2924,	10575,	5573,	3532,	9854,	16446,	21942,	8658,
9504,	5757,	-1810,	13154,	8460,	9145,	17245,	24497,
11473,	15618,	16547,	15340,	24489,	14953,	21757,	11523,
10903,	20130,	17180,	12262,	21184,	20301,	20074,	26421,
12870,	7696,	21537,	11059,	17886,	17001,	8433,	4514,
5588,	-1605,	7003,	7631,	14373,	13840,	13393,	21475,
23375,	12738,	19194,	13624,	7392,	8528,	1096,	1619,
-4902,	5652,	-1199,	7039,	12080,	1344,	3927,	3804,
630,	4626,	10348,	15977,	11401,	20632,	12997,	20276,
14974,	18480,	23467,	22148,	19828,	9256,	13598,	14405,
9932,	2313,	11872,	7204,	2508,	5037,	17035,	14454,
13317,	20305,	15311,	6490,	18476,	20188,	7058,	4064,
15055,	16607,	10657,	5806,	6709,	8632,	15600,	11847,
1323,	-1915,	-3112,	4577,	-1846,	3050,	9984,	9501,
14820,	7460,	1640,	146,	696,	323,	-104,	-132,
433,	925,	745,	272,	604,	1106,	1358,	1348,
1284,	1633,	1424,	731,	939,	1028,	766,	833,
808,	1274,	1134,	1187,	1185,	1251,	1113,	642,
183,	-75,	142,	868,	103,	863,	915,	659,
514,	252,	685,	705,	635,	585,	162,	724,
550,	535,	375,	15,	-243,	432,	294,	-58,
506,	-194,	88,	355,	882,	98,	424,	986,
917,	700,	1029,	1401,	717,	872,	381,	149,
705,	1098,	444,	684,	235,	-10,	240,	509,
647,	113,	306,	954,	816,	1266,	1505,	1782,
1700,	1286,	1796,	1550,	1548,	1764,	1724,	1826,
2198,	2076,	1666,	1970,	1127,	1440,	1918,	1474,
948,	964,	703,	1280,	1551,	868,	505,	1343,
1273,	958,	378,	1268,	1342,	1752,	1154,	1424,
1904,	1689,	1698,	1231,	1200,	1778,	1564,	807,
636,	956,	607,	154,	320,	640,	770,	1364,
1082,	554,	287,	433,	828,	716,	1063,	1334,
812,	443,	990,	1109,	958,	1462,	1213,	1409,
1621,	1562,	1254,	1249,	998,	1313,	1460,	1291,
935,	1014,	553,	1282,	1064,	461,	596,	726,
807,	338,	381,	767,	814,	758,	965,	1080,
1049,	857,	1246,	794,	643,	195,	-59,	542,
427,	341,	-64,	815,	804,	753,	324,	284,
944,	868,	344,	802,	990,	1398,	788,	1289,
1562,	1825,	1116,	1296,	932,	1249,	7342,	13443,
8046,	10498,	3356,	-2375,	12050,	17871,	7011,	14602,
17989,	10096,	14256,	6770,	14943,	3333,	9205,	3882,
8161,	9477,	6845,	11959,	19833,	8115,	6111,	6535,
13721,	19615,	7331,	6971,	-347,	10254,	19327,	9963,
3831,	3807,	9955,	474,	14358,	16489,	6656,	5884,
6327,	4827,	15699,	15117,	17450,	21905,	7155,	-819,
7064,	13508,	18357,	20819,	8875,	17945,	17032,	21514,
15564,	21370,	18425,	23232,	17998,	17005,	16889,	5957,
1070,	14042,	16105,	12462,	19636,	16212,	12260,	13227,
4378,	7957,	19254,	18802,	17503,	23798,	9438,	4743,
-807,	454,	5715,	-3470,	4674,	1858,	-927,	-4556,
1074,	215,	9055,	11826,	-563,	9344,	12109,	14710,
16817,	10325,	2253,	-5260,	8605,	17863,	8857,	8071,
17775,	4410,	10579,	11546,	14968,	5513,	13487,	11897,
16268,	23059,	23011,	14812,	5795,	-893,	2513,	-3680,
-9590,	5005,	7828,	14213,	1330,	10786,	7075,	15565,
19694,	22586,	11953,	14830,	21862,	11731,	5382,	18606,
4997,	-785,	-3379,	2383,	11736,	17857,	23982,	10931,
7825,	18910,	15313,	11838,	8437,	11227,	8717,	7745,
1095,	-3459,	742,	11532,	14470,	18004,	5007,	5752,
16809,	3866,	-1728,	-6495,	6126,	4066,	8358,	327,
-4060,	-1914,	-1765,	4575,	13349,	7844,	14020,	18213,
7583,	5618,	-3097,	-8574,	-1812,	4600,	-3097,	799,
-4594,	3476,	10708,	3942,	9282,	946,	7209,	9838,
4006,	1451,	-6816,	7949,	-3403,	8032,	-2921,	1943,
-6357,	-6584,	-2563,	-9892,	-4505,	-780,	-1073,	-729,
-441,	146,	35,	305,	-321,	-416,	-521,	-716,
-867,	-67,	-266,	-22,	452,	288,	566,	91,
-416,	48,	-388,	240,	-309,	-639,	-887,	-924,
-1186,	-298,	-196,	-419,	-655,	-1096,	-144,	-156,
-361,	219,	-227,	-665,	32,	-15,	226,	181,
624,	402,	618,	112,	52,	300,	104,	77,
-419,	122,	472,	-67,	614,	825,	-22,	-38,
-112,	472,	754,	699,	956,	799,	449,	976,
670,	354,	506,	534,	788,	719,	110,	-161,
660,	1,	253,	66,	488,	186,	-320,	212,
821,	1023,	353,	305,	550,	762,	988,	1214,
1441,	1175,	809,	818,	195,	863,	805,	1005,
488,	962,	1034,	612,	43,	652,	597,	1170,
1094,	1337,	1180,	465,	803,	1006,	1440,	1758,
944,	301,	885,	1167,	1160,	1432,	1399,	1568,
1250,	1790,	1358,	1389,	993,	392,	545,	945,
309,	762,	1289,	1256,	842,	1151,	1041,	795,
337,	648,	603,	757,	188,	899,	932,	929,
1335,	1463,	1528,	1102,	1228,	786,	923,	1273,
1135,	1490,	883,	892,	512,	424,	406,	1006,
302,	1003,	1144,	1263,	1026,	444,	384,	58,
65,	682,	1153,	1338,	884,	618,	372,	318,
-84,	227,	492,	282,	536,	171,	795,	1018,
719,	588,	-9,	279,	612,	150,	39,	433,
-116,	-443,	-202,	75,	209,	556,	548,	340,
3369,	10512,	19157,	19740,	6738,	8874,	11042,	7444,
9387,	1620,	10204,	13947,	20069,	10463,	13006,	5728,
2808,	10987,	2661,	-3159,	-9057,	-7807,	1915,	12422,
15269,	10621,	9956,	974,	-5217,	4934,	6589,	13223,
7710,	-2880,	11860,	-911,	-7076,	-10315,	1336,	-4303,
5218,	-1578,	2634,	-604,	-10121,	3704,	-3323,	5465,
12881,	6425,	15857,	11453,	12860,	5948,	9167,	-436,
6614,	-3425,	-337,	-4102,	2570,	-4492,	-12030,	-7939,
-14926,	-13570,	-14952,	-11100,	-8004,	2648,	3220,	9758,
649,	-8143,	533,	-9652,	89,	7842,	9476,	13732,
-1576,	6138,	11747,	15318,	9381,	184,	2874,	6810,
14682,	6948,	12265,	12969,	6650,	4392,	-1015,	2112,
11013,	10633,	6878,	9880,	15012,	1013,	3581,	11515,
19223,	15775,	13077,	12411,	7400,	123,	8505,	16651,
22672,	20793,	6964,	2227,	2573,	13693,	9313,	13774,
11806,	12937,	20546,	6013,	3918,	14089,	20734,	25396,
23853,	25073,	20994,	9649,	15192,	13874,	4665,	11743,
18762,	11066,	13386,	11076,	1452,	9249,	3372,	15782,
2836,	12579,	3653,	5557,	13106,	17072,	23928,	25803,
14544,	19975,	17376,	26223,	13547,	7974,	11734,	21389,
10532,	4556,	6434,	1695,	-5314,	2322,	10963,	13199,
11200,	9269,	9379,	3462,	8524,	13681,	18976,	14479,
6110,	7652,	9601,	13242,	8315,	2488,	728,	12442,
14046,	7937,	-445,	13353,	14119,	6574,	16821,	4994,
9943,	19426,	6655,	4326,	28,	10868,	10506,	9521,
9101,	18521,	22474,	15078,	3707,	10984,	8073,	534,
214,	397,	766,	645,	1192,	1133,	1560,	796,
395,	662,	438,	332,	1014,	1443,	1072,	922,
605,	1102,	1107,	1193,	1311,	1556,	1561,	804,
1545,	1058,	793,	580,	694,	243,	656,	720,
887,	831,	444,	735,	1081,	1334,	793,	633,
1197,	737,	1207,	956,	743,	680,	280,	479,
-13,	-121,	744,	519,	377,	251,	21,	702,
-12,	458,	496,	-119,	159,	368,	594,	1064,
1267,	1264,	1163,	1224,	797,	912,	1321,	1227,
1268,	510,	480,	513,	790,	1197,	872,	1465,
1413,	757,	444,	760,	612,	386,	681,	871,
685,	89,	-48,	784,	1238,	320,	611,	654,
1212,	389,	424,	88,	-6,	757,	1218,	802,
378,	1140,	983,	703,	965,	1122,	652,	333,
711,	586,	528,	138,	-272,	379,	848,	863,
1026,	1195,	395,	1120,	1390,	943,	1158,	1317,
1554,	648,	547,	636,	970,	1511,	1062,	1254,
547,	1321,	734,	613,	1017,	976,	563,	1077,
694,	511,	1046,	1506,	588,	1285,	1096,	1006,
768,	270,	988,	327,	599,	1080,	1228,	930,
478,	1041,	1465,	1673,	1920,	1043,	996,	1460,
1141,	1106,	501,	421,	312,	9,	152,	796,
896,	1332,	1054,	1291,	877,	612,	844,	521,
466,	956,	739,	281,	858,	998,	331,	970,
817,	535,	1145,	1184,	1061,	1307,	1686,	1366,
947,	1253,	3550,	19014,	17427,	13708,	11996,	20356,
20861,	27703,	26525,	17847,	10780,	10506,	18746,	13885,
20066,	15259,	16271,	26405,	20211,	15859,	18275,	22140,
29062,	14398,	26483,	32766,	24444,	24263,	17615,	27120,
24917,	20068,	24721,	12545,	10334,	5008,	2024,	7434,
15422,	16370,	15264,	4198,	-2343,	9986,	2346,	7790,
2434,	14703,	3775,	31,	8175,	8591,	10837,	213,
6128,	-224,	11484,	14842,	15310,	8691,	5175,	8052,
13974,	22563,	11044,	5871,	953,	10172,	10555,	4899,
8684,	-1329,	-239,	3188,	9007,	7441,	4973,	1895,
-2141,	-2658,	10691,	7408,	-3097,	10618,	-142,	-965,
-2854,	-288,	-408,	11169,	13901,	18753,	13996,	9227,
5246,	10230,	6519,	-1679,	-140,	4611,	8853,	13345,
4424,	12599,	9404,	731,	593,	2335,	8485,	-1527,
-8510,	6033,	-4406,	-7300,	-6864,	-2548,	-810,	-58,
1766,	1665,	-1616,	23,	-289,	218,	7735,	12098,
5008,	-2591,	-8059,	-13427,	737,	-7303,	-8795,	-13653,
-4919,	-8394,	-14671,	-16142,	-16653,	-3550,	2474,	-10447,
-2522,	4559,	-1652,	6431,	3767,	337,	7976,	11945,
14580,	7032,	6532,	-2915,	4180,	-580,	5941,	6849,
12187,	17443,	9642,	6448,	13375,	1514,	6730,	12159,
13793,	9096,	12523,	19080,	5150,	-1619,	-7871,	934,
-6149,	5254,	11207,	12182,	19826,	20400,	16958,	24274,
12103,	19350,	22508,	14887,	19839,	21668,	13703,	22392,
18070,	26556,	15321,	14452,	18512,	10046,	11338,	14827,
21377,	24304,	21273,	15049,	20235,	19836,	7517,	15952,
12561,	1763,	864,	1489,	1045,	452,	1020,	393,
725,	620,	77,	859,	411,	289,	-165,	-127,
464,	-56,	265,	169,	-139,	62,	-316,	-683,
-389,	137,	-356,	-136,	-136,	549,	-24,	222,
-137,	-66,	-185,	284,	250,	652,	-127,	221,
670,	22,	-172,	-411,	435,	794,	-48,	489,
-226,	318,	467,	16,	96,	-366,	-185,	188,
239,	-210,	457,	208,	378,	-237,	-172,	-634,
-318,	267,	119,	-403,	7,	415,	187,	295,
-16,	527,	177,	253,	-320,	-471,	402,	622,
113,	712,	378,	-314,	307,	2,	480,	634,
-6,	394,	36,	513,	-31,	517,	-217,	-677,
-109,	462,	-284,	463,	-32,	423,	547,	80,
-68,	619,	194,	-18,	671,	317,	857,	77,
53,	-45,	-576,	-175,	220,	210,	-327,	38,
461,	364,	624,	379,	-299,	-205,	526,	-201,
-241,	144,	-308,	-651,	238,	629,	832,	382,
899,	613,	73,	453,	111,	272,	440,	817,
-37,	-94,	225,	456,	-36,	23,	520,	226,
-383,	54,	665,	1041,	737,	1195,	1053,	373,
20,	669,	-75,	-111,	598,	110,	493,	-169,
665,	88,	782,	866,	55,	-282,	-338,	215,
195,	766,	405,	-174,	-152,	354,	741,	265,
-343,	-60,	-152,	517,	106,	-479,	-755,	-354,
-420,	64,	332,	-149,	-291,	-556,	-304,	231,
-410,	-309,	226,	-33,	-21,	82,	1235,	6454,
-4518,	6153,	6124,	1274,	4895,	1766,	7747,	-1952,
6492,	2668,	4424,	9919,	1593,	-5144,	3874,	13477,
-1707,	-100,	4591,	2502,	9894,	1083,	12655,	13481,
13829,	7657,	14077,	15115,	4700,	5102,	12935,	6623,
12292,	8989,	6807,	-2692,	7364,	5517,	6377,	-3242,
-7077,	-9508,	-9182,	2854,	1928,	-8877,	214,	2100,
-9063,	-3148,	7604,	1385,	-3110,	-11639,	-7999,	5556,
11314,	7861,	-3320,	-3914,	6368,	8561,	13002,	4519,
-1513,	3900,	-2840,	-430,	7017,	-3579,	5387,	6287,
8233,	2943,	-4712,	-1659,	1846,	3890,	4366,	12143,
-2125,	-926,	10575,	4716,	12024,	5443,	9135,	6836,
11487,	8140,	14522,	3093,	8162,	3094,	14095,	19064,
3571,	-3061,	-4931,	-9672,	5388,	10154,	8577,	11882,
13297,	2313,	10328,	14405,	3732,	14068,	8407,	15719,
10713,	-854,	13442,	16783,	22455,	10347,	1987,	1128,
13486,	622,	-1706,	4844,	14677,	6401,	-3257,	6406,
5940,	-2561,	7020,	-4569,	6248,	-4781,	-356,	8497,
2863,	143,	12006,	15301,	6044,	-1456,	7931,	13709,
8439,	17191,	10602,	14268,	7226,	11612,	12392,	746,
-6483,	9289,	9826,	5771,	4037,	-5169,	-407,	10724,
12712,	13645,	6852,	5361,	1686,	4058,	12309,	13149,
12501,	10956,	9292,	11463,	4181,	9458,	18619,	14687,
2520,	5696,	8622,	3613,	12436,	962,	4852,	10287,
3286,	6715,	-1126,	10333,	17506,	21633,	10966,	19057,
17938,	13137,	6440,	5072,	6161,	-1184,	-4520,	-1049,
-7436,	3270,	-4437,	-2729,	-278,	-807,	-363,	-691,
-1076,	-502,	190,	-4,	442,	640,	988,	868,
1011,	1248,	479,	415,	789,	736,	987,	795,
1057,	954,	1311,	1348,	1377,	1560,	1548,	1588,
1106,	1647,	1422,	1803,	1095,	1522,	1892,	1224,
1755,	2099,	2333,	1539,	829,	1017,	823,	1211,
1111,	1035,	393,	322,	402,	832,	193,	-209,
402,	-116,	544,	431,	848,	1122,	582,	663,
740,	680,	1015,	1441,	755,	1396,	1415,	1569,
773,	1144,	598,	435,	-22,	686,	755,	105,
944,	1019,	247,	493,	665,	358,	579,	108,
363,	426,	440,	99,	515,	378,	-134,	-210,
466,	420,	547,	751,	33,	124,	-119,	-331,
59,	538,	940,	520,	-154,	389,	149,	-59,
340,	214,	435,	182,	152,	21,	91,	706,
360,	-169,	5,	419,	497,	-125,	702,	768,
1196,	1312,	389,	805,	631,	369,	190,	-83,
-23,	582,	967,	253,	249,	38,	381,	271,
738,	379,	88,	413,	87,	-327,	-350,	360,
863,	949,	395,	497,	9,	167,	40,	-418,
4,	532,	933,	576,	258,	926,	421,	1056,
277,	-270,	206,	-272,	513,	605,	23,	668,
457,	642,	370,	115,	521,	996,	236,	800,
1120,	308,	429,	49,	-362,	-167,	639,	-181,
-544,	29,	-216,	-502,	376,	625,	-152,	-386
}; 

__eds__ __attribute__((space(prog))) int16_t SAMPLE_bowscrape2[sample_length] = {
-39,	-8384,	-5918,	-9793,	-7411,	-10007,	-12141,	-396,
6110,	4138,	8305,	-952,	-1711,	-1065,	-5775,	-8372,
1192,	-4935,	-8251,	-6937,	-777,	346,	-9430,	-7922,
-3730,	3585,	-57,	2439,	-3723,	-2083,	-5923,	-8179,
-13573,	-16451,	-9974,	-8059,	-4672,	2823,	-9737,	-2584,
5937,	-1492,	-8644,	2140,	-220,	4195,	6983,	-4737,
-7539,	-7765,	-1497,	-167,	-93,	26,	-169,	-255,
-151,	-28,	-84,	-3,	-145,	39,	9,	-118,
-225,	-11,	76,	-26,	66,	-66,	7,	-11,
-50,	-123,	-122,	-77,	-146,	14,	-103,	-19,
-166,	-11,	-207,	-221,	-205,	-127,	-85,	-214,
-218,	-102,	-76,	-202,	-67,	-73,	29,	144,
63,	92,	91,	90,	112,	10364,	5542,	6601,
-3612,	-4210,	-6120,	-3828,	-299,	-549,	-6435,	3889,
-182,	-2023,	-8433,	-9419,	-14514,	-9971,	-7352,	1238,
-8876,	-5812,	-5341,	-148,	-5875,	-3579,	1962,	1287,
8099,	9316,	3368,	-2600,	-3799,	6800,	-4737,	-3412,
-6067,	-5455,	-9137,	-4912,	-5755,	-8595,	-7643,	-7701,
-6147,	-14425,	-4224,	1051,	2524,	-995,	-6410,	-74,
-48,	-122,	-85,	-137,	-191,	-41,	-44,	-179,
-54,	-60,	-93,	-42,	-235,	-231,	-166,	-317,
-325,	-239,	-154,	-26,	11,	-166,	-216,	-170,
-112,	-152,	24,	116,	87,	190,	107,	234,
23,	183,	-21,	-151,	-98,	-111,	-43,	-60,
47,	-95,	98,	10,	173,	-29,	-78,	-158,
-23,	246,	5987,	5981,	9954,	8852,	4765,	477,
940,	614,	-6848,	2505,	-3416,	6706,	4571,	10360,
-1985,	-2392,	-1054,	-223,	1040,	-5678,	2858,	10194,
10519,	2632,	-5490,	-1410,	4201,	-2190,	-3276,	-1757,
-8970,	-2949,	-9855,	-5054,	-10143,	-2705,	-12101,	-3403,
-2145,	-11318,	-1874,	-9368,	-15688,	-17331,	-5945,	629,
3849,	4404,	6255,	118,	46,	5,	17,	-159,
63,	-125,	1,	-122,	75,	193,	253,	114,
50,	135,	70,	82,	-37,	-151,	-76,	13,
-182,	-243,	-106,	-16,	62,	22,	0,	-124,
-246,	27,	-164,	-55,	46,	-161,	-114,	17,
-106,	-223,	16,	113,	-5,	-167,	-40,	-216,
-177,	16,	123,	130,	147,	6174,	12303,	6657,
6223,	8390,	13456,	11819,	5751,	9818,	13972,	16716,
15537,	8540,	6530,	12065,	5932,	4599,	10022,	222,
-1009,	7636,	6065,	1942,	-6139,	-10099,	-808,	-2851,
-1421,	-4586,	-3457,	-649,	300,	-968,	-3446,	-4996,
-1115,	1304,	7157,	758,	5117,	10836,	9914,	11588,
7212,	11023,	10104,	3530,	6954,	3931,	11059,	6264,
93,	189,	26,	100,	257,	290,	247,	77,
190,	-6,	201,	291,	302,	151,	248,	202,
93,	-48,	126,	106,	-19,	114,	-8,	27,
118,	101,	66,	255,	145,	92,	208,	251,
100,	58,	92,	-69,	-30,	89,	-56,	143,
192,	60,	-102,	-8,	6,	181,	12,	92,
-8,	1817,	9767,	-1545,	-7853,	-4695,	-10037,	-5698,
-4071,	1866,	3315,	-4452,	-5079,	-3353,	3766,	7316,
5962,	-256,	-5753,	-7126,	3389,	7176,	8742,	13630,
16453,	7410,	5581,	14872,	2849,	8198,	2183,	4060,
13022,	8377,	8709,	3639,	8846,	11568,	4830,	14304,
10157,	12872,	16602,	7579,	6305,	-524,	7378,	11734,
11009,	1242,	3678,	-2370,	182,	171,	-10,	-37,
-87,	-130,	10,	109,	-103,	-98,	57,	31,
1,	69,	18,	111,	265,	327,	134,	267,
386,	330,	251,	357,	334,	186,	275,	218,
77,	82,	276,	327,	191,	31,	35,	208,
123,	73,	11,	136,	-58,	-126,	-143,	8,
-33,	61,	219,	30,	94,	196,	13022,	17834,
4061,	10732,	18422,	6332,	2727,	6109,	1788,	1182,
7677,	13551,	14092,	15563,	19609,	21795,	26099,	15534,
17416,	6719,	9281,	1372,	10605,	17622,	9774,	3265,
-858,	7935,	15796,	16922,	14860,	16602,	9010,	14141,
7707,	7996,	12999,	6761,	10955,	2633,	2511,	12858,
12279,	6038,	-1574,	6498,	10394,	230,	-5959,	7158,
-45,	7,	122,	-54,	-30,	-156,	-184,	-78,
36,	-140,	-252,	-25,	-213,	-132,	-231,	-138,
51,	-173,	29,	137,	32,	14,	-27,	-97,
-32,	-116,	87,	124,	250,	75,	154,	-24,
-94,	-148,	-240,	-88,	84,	1,	-12,	-20,
110,	193,	195,	-40,	-118,	0,	24,	21,
-148,	53,	3845,	7597,	-888,	7198,	-1916,	-4643,
-9277,	-4039,	-4039,	-11731,	-14974,	-6551,	2063,	3727,
-764,	-2139,	905,	3104,	3374,	1105,	-5702,	-9053,
-368,	-3496,	-4274,	-6820,	-4588,	4822,	10319,	4820,
-1934,	-3349,	6859,	-2129,	5032,	12095,	11729,	10947,
5754,	-2981,	-1896,	-4452,	-1646,	8429,	9140,	8145,
7292,	9302,	5521,	3811,	230,	22,	72,	185,
148,	281,	212,	305,	285,	404,	211,	44,
184,	319,	371,	248,	176,	363,	410,	464,
256,	240,	288,	156,	352,	259,	318,	194,
131,	124,	75,	111,	90,	243,	205,	54,
188,	303,	144,	47,	19,	136,	177,	260,
190,	5,	-68,	-103,	145,	173,	3878,	344,
-5924,	1951,	8364,	-1653,	-4190,	3045,	9449,	-1883,
7412,	-3155,	-7804,	207,	6884,	8726,	1086,	10485,
11347,	9098,	12792,	3308,	2475,	5840,	11536,	15164,
2624,	-329,	3941,	4355,	12236,	5575,	11992,	14562,
2783,	6939,	9210,	3844,	2181,	-1859,	2299,	-5164,
-7098,	-10689,	-5136,	-10021,	-12874,	-12289,	-12205,	-7094,
-3977,	-187,	-271,	-121,	63,	96,	184,	-2,
70,	-131,	54,	75,	133,	168,	289,	112,
274,	65,	86,	93,	58,	128,	138,	-1,
160,	-7,	-76,	-117,	-109,	-32,	66,	-37,
-75,	53,	-22,	-103,	-129,	34,	-39,	50,
-45,	132,	84,	-113,	-206,	-215,	-315,	-258,
-278,	-327,	-1498,	-1436,	1664,	-1367,	-8801,	-13034,
-17862,	-7624,	-3865,	-2510,	-360,	-7197,	2933,	-7784,
1357,	-6690,	-9643,	-8662,	-2768,	2149,	-8242,	1310,
-1559,	-537,	-9512,	-4210,	-322,	2693,	1896,	-767,
8178,	8984,	-84,	-4974,	4028,	2346,	6712,	819,
3148,	3446,	-674,	-2657,	-1474,	-3147,	3478,	4889,
10750,	-1122,	2867,	-5826,	2048,	4,	-49,	-171,
-169,	-69,	60,	-3,	-9,	44,	84,	104,
219,	264,	198,	149,	37,	-57,	23,	215,
20,	-94,	-21,	24,	-51,	49,	23,	77,
-113,	-233,	-245,	-202,	-267,	-68,	78,	-12,
83,	85,	-79,	105,	125,	212,	235,	324,
207,	158,	10,	27,	150,	95,	224,	2426,
10341,	2697,	3053,	10232,	13328,	7816,	9134,	5849,
5008,	6438,	5824,	12752,	13654,	15280,	18782,	21126,
14137,	10024,	5526,	9936,	8230,	15759,	15813,	4875,
9801,	13805,	20404,	8827,	5718,	12856,	11466,	13910,
13638,	11135,	8333,	17809,	21052,	11048,	7431,	17643,
6361,	3618,	-1574,	-1150,	1198,	1695,	7097,	-2436,
-3498,	-8,	-111,	4,	-89,	56,	102,	80,
-26,	94,	-81,	145,	270,	65,	172,	-9,
149,	165,	37,	-98,	-40,	-34,	153,	31,
3,	122,	20,	99,	87,	134,	76,	56,
-7,	131,	255,	18,	78,	249,	125,	153,
166,	167,	48,	121,	277,	101,	-9,	141,
195,	129,	-36,	179,	5726,	9881,	5540,	-2507,
4181,	7173,	6196,	1494,	-2376,	4178,	-625,	-2240,
8149,	-3150,	-1794,	-98,	-4353,	-1307,	5919,	1440,
5268,	2596,	-2057,	-8607,	-1243,	7592,	10406,	12522,
943,	6712,	9329,	12003,	17291,	15497,	20560,	20259,
20787,	20338,	25141,	24473,	11504,	11523,	3553,	11185,
8256,	-372,	4643,	8751,	557,	-78,	35,	131,
36,	52,	180,	121,	180,	318,	111,	13,
40,	-2,	189,	326,	280,	375,	203,	225,
85,	133,	221,	346,	310,	143,	292,	234,
159,	207,	369,	349,	180,	316,	245,	126,
242,	394,	289,	214,	292,	217,	40,	153,
296,	68,	74,	41,	42,	237,	154,	8688,
-581,	10443,	14439,	20039,	19119,	22584,	13270,	5891,
6292,	10275,	6861,	13991,	16519,	9816,	13315,	9070,
17480,	7853,	12171,	13681,	12911,	19500,	18669,	16591,
8997,	16003,	18135,	9681,	19958,	18860,	22866,	20087,
12083,	15894,	9578,	8617,	6175,	17082,	8985,	2127,
6677,	-977,	-2838,	7456,	-1057,	6578,	15446,	6914,
9480,	1439,	267,	125,	58,	184,	250,	120,
257,	222,	153,	144,	104,	111,	134,	-8,
-71,	2,	125,	204,	122,	79,	-52,	22,
96,	172,	307,	238,	274,	375,	285,	421,
181,	281,	213,	250,	72,	139,	89,	236,
349,	133,	266,	86,	164,	135,	203,	222,
32,	11,	-54,	-2523,	-3452,	1733,	5263,	1496,
-5764,	1955,	-6681,	-9108,	-8193,	4038,	4782,	-2320,
-4315,	3564,	-451,	-2198,	-5858,	-494,	6675,	-4297,
-8363,	-1785,	-5946,	-3594,	5909,	-6175,	5734,	-2346,
1875,	9178,	-1108,	8745,	6415,	8889,	-246,	-1904,
8192,	13740,	11453,	3172,	7864,	12221,	6922,	7709,
13879,	17744,	20643,	14462,	7615,	10525,	165,	196,
372,	119,	319,	183,	293,	174,	227,	322,
247,	139,	61,	140,	138,	39,	-97,	148,
293,	197,	326,	208,	317,	311,	435,	271,
101,	125,	-9,	-114,	83,	34,	183,	242,
186,	129,	-31,	-30,	110,	223,	10,	-78,
13,	-57,	130,	250,	337,	137,	81,	431,
5815,	2878,	12840,	14133,	17947,	11213,	4202,	7695,
14931,	17315,	18058,	16086,	15164,	6821,	3692,	11709,
8446,	13307,	12086,	15861,	11839,	15974,	8970,	13755,
15308,	19401,	15679,	6363,	14459,	9710,	10160,	17927,
19788,	19218,	22050,	20443,	11074,	9595,	3505,	2077,
12336,	11469,	15676,	20719,	19316,	17132,	16514,	17611,
7747,	5585,	112,	21,	188,	258,	204,	317,
169,	13,	28,	87,	-47,	99,	33,	-39,
-38,	32,	-38,	41,	-123,	-52,	-108,	119,
-4,	-127,	102,	-105,	-191,	-103,	-131,	-260,
-148,	-285,	-256,	-307,	-118,	18,	-47,	-55,
-99,	52,	46,	149,	259,	-19,	177,	-56,
19,	-91,	-177,	-67,	-8734,	-10374,	-5786,	-9866,
2064,	-7487,	-510,	-4933,	-9498,	-7778,	-7336,	-6263,
-5179,	-10014,	-12604,	-3056,	-1093,	4745,	-681,	60,
4705,	-1122,	-3114,	-8903,	94,	-975,	-10021,	-3670,
-2209,	648,	-7209,	-1154,	-5263,	-2927,	-4411,	-9011,
-4088,	-12379,	-1104,	-6160,	-7969,	-9502,	-12977,	-13398,
-13435,	-19284,	-11356,	-10728,	-5821,	-14542,	-133,	-74,
20,	-20,	9,	-13,	-179,	8,	13,	-80,
88,	-42,	91,	20,	-52,	139,	72,	212,
70,	62,	159,	261,	47,	120,	48,	67,
-118,	28,	-77,	15,	6,	-131,	-48,	-143,
-48,	8,	-55,	-1,	1,	-42,	-189,	-278,
-361,	-319,	-127,	-137,	-170,	-156,	-318,	-319,
-20707,	-21268,	-11959,	-14191,	-15648,	-12414,	-20258,	-23151,
-23553,	-18394,	-19260,	-21158,	-16578,	-17043,	-22530,	-21305,
-12465,	-9006,	-13909,	-18797,	-8796,	-2180,	-10422,	-8659,
-2845,	2709,	-3814,	2312,	2422,	2132,	-121,	2135,
-4601,	-33,	-9404,	-15377,	-5251,	-5724,	-1359,	-676,
-7427,	-1045,	-4181,	-5241,	1017,	2643,	-5169,	-11754,
-3054,	-12461,	-1533,	-262,	-349,	-163,	-191,	-222,
-9,	-56,	71,	144,	70,	59,	180,	131,
-56,	70,	186,	184,	139,	150,	95,	87,
-86,	61,	113,	114,	-47,	-51,	-202,	-256,
-157,	-46,	24,	-25,	-65,	63,	-83,	67,
158,	59,	104,	-81,	-7,	158,	147,	-51,
15,	-139,	-138,	-126,	1453,	2020,	698,	9395,
2603,	8158,	2711,	2305,	6471,	1797,	-6077,	-11410,
-2725,	-11009,	-10631,	-12664,	-18338,	-14058,	-7881,	-16448,
-15721,	-21409,	-11925,	-13932,	-13131,	-5632,	-7685,	-14297,
-19836,	-16814,	-16107,	-16505,	-22524,	-17024,	-11903,	-20657,
-19313,	-17778,	-15809,	-22416,	-12902,	-21791,	-20595,	-25092,
-17512,	-20925,	-19258,	-17336,	-19221,	-16067,	-11196,	-239,
-426,	-314,	-425,	-276,	-452,	-224,	-223,	-278,
-188,	-203,	-67,	-242,	-173,	-304,	-420,	-359,
-476,	-235,	-393,	-299,	-169,	-269,	-320,	-327,
-327,	-228,	-239,	-223,	-394,	-262,	-140,	-52,
-199,	-91,	14,	29,	-108,	-104,	-101,	-144,
-186,	-241,	-124,	-34,	-154,	-70,	-169,	-81,
-3993,	-6067,	-13585,	-7676,	-10412,	-3812,	-1410,	1621,
-604,	550,	2088,	6663,	9125,	9352,	7826,	7297,
13609,	16102,	15681,	2652,	3381,	474,	-1735,	-2507,
-1368,	-428,	-633,	-5298,	3968,	9294,	1669,	-4283,
-1928,	-1935,	-5619,	-10606,	-13392,	-10177,	-3641,	4757,
-1452,	-1174,	-7711,	-9915,	-4146,	-7169,	-8086,	-9816,
-4334,	-4852,	-3477,	-46,	60,	42,	-37,	-96,
-183,	-279,	-60,	103,	-27,	-200,	-131,	-286,
-229,	-175,	-222,	-356,	-405,	-202,	-19,	-132,
-8,	29,	-214,	-67,	-67,	-93,	-219,	-5,
15,	-188,	36,	38,	125,	-60,	-36,	-164,
-197,	19,	-83,	10,	128,	-131,	-27,	-191,
-180,	-144,	18,	87,	-49,	5160,	2159,	-4988,
-1485,	1150,	-6137,	-662,	2699,	5205,	1214,	-3534,
3740,	-3158,	-1890,	3314,	-3867,	-3719,	5773,	507,
-6074,	5091,	-33,	-912,	4345,	-5492,	5427,	-5916,
-2655,	5573,	1935,	-5506,	5193,	1339,	3726,	795,
6882,	8928,	6623,	8944,	7522,	1849,	-4769,	5837,
7343,	5441,	7778,	10128,	10506,	2466,	-612,	12,
199,	21,	-58,	-25,	-31,	-130,	-247,	-210,
-12,	-70,	-60,	130,	20,	0,	-56,	81,
57,	41,	186,	197,	175,	212,	146,	-8,
25,	81,	203,	211,	33,	210,	170,	142,
86,	124,	4,	-67,	-13,	81,	182,	26,
153,	168,	68,	109,	-24,	110,	177,	298,
115,	5562,	14242,	17645,	14126,	6945,	3037,	-1474,
-6348,	-9212,	-7036,	-13016,	-1736,	-1952,	-8275,	-4615,
3370,	-4098,	-4437,	-819,	2991,	3156,	7242,	9277,
7872,	1450,	-2880,	-1053,	8639,	4428,	3202,	-2374,
-5899,	-7786,	-8657,	-1506,	-6174,	-2800,	-1372,	4339,
10617,	9893,	3471,	217,	8833,	4363,	12656,	3453,
2926,	-3309,	6574,	181,	-40,	-43,	89,	135,
-57,	165,	32,	9,	72,	-22,	59,	101,
-2,	-63,	-72,	120,	145,	264,	322,	353,
207,	52,	247,	241,	306,	305,	159,	9,
213,	148,	178,	332,	274,	404,	457,	394,
433,	359,	343,	326,	151,	209,	273,	128,
4,	2,	106,	128,	-48,	-4708,	-6418,	1471,
-5923,	-9054,	-11881,	-14280,	-16008,	-4813,	-1660,	-4340,
-3457,	-7843,	-6777,	4018,	1185,	-8981,	1730,	7951,
10519,	8875,	-1753,	-5051,	-117,	-8521,	-7186,	-3944,
1142,	7018,	1094,	8204,	6937,	4314,	9456,	9544,
9476,	7785,	12401,	5487,	6620,	13727,	4817,	1653,
770,	6443,	-2051,	5063,	-416,	1205,	6371,	3107,
-26,	-121,	7,	-156,	-121,	-235,	-308,	-339,
-369,	-170,	-41,	-52,	53,	96,	19,	83,
-88,	-218,	5,	150,	-108,	-55,	-73,	-23,
-163,	-262,	-242,	-176,	-206,	-311,	-80,	52,
-203,	-29,	-219,	14,	145,	44,	-25,	-131,
23,	31,	-144,	-111,	-120,	-142,	-189,	-66,
-106,	-1574,	5521,	-4373,	-2775,	3332,	-6891,	3113,
-5411,	-3307,	-309,	3001,	853,	7469,	-1042,	-4876,
1072,	1879,	9435,	787,	8580,	9668,	5107,	10217,
14128,	3528,	-367,	5030,	-4182,	-6551,	3203,	-3241,
5873,	12620,	13363,	5312,	1421,	1093,	2676,	6522,
3533,	348,	2058,	-2355,	696,	2629,	10091,	1711,
10760,	4053,	-5438,	-3883,	-213,	-57,	20,	97,
-55,	-135,	-182,	-44,	46,	89,	-106,	-8,
89,	-78,	94,	220,	200,	142,	97,	-41,
50,	152,	76,	-66,	18,	-33,	78,	-94,
-134,	71,	86,	227,	48,	161,	299,	248,
104,	128,	235,	74,	115,	238,	137,	-7,
123,	-50,	46,	-107,	-158,	54,	9435,	694,
-7159,	-9242,	-3225,	2146,	4777,	10089,	9540,	13860,
12984,	5677,	1758,	-783,	3944,	-3817,	2259,	7756,
-19,	-7673,	2281,	-2813,	3767,	-4953,	-2306,	1625,
-4546,	367,	-1605,	4721,	2395,	4777,	2562,	5810,
6937,	11592,	3950,	7827,	2817,	3629,	-1222,	-117,
9803,	6164,	-313,	2233,	1917,	-5850,	-3435,	-3308,
83,	37,	158,	-51,	93,	63,	100,	216,
86,	234,	165,	202,	117,	204,	323,	90,
-50,	-72,	7,	196,	251,	359,	167,	125,
154,	140,	197,	128,	-14,	142,	83,	44,
88,	198,	160,	40,	-55,	28,	-10,	-47,
116,	221,	-23,	-3,	162,	78,	132,	214,
183,	224,	7255,	10446,	16251,	14799,	4056,	-600,
2644,	1345,	7490,	10667,	1761,	8464,	-1588,	404,
2464,	11033,	3793,	5975,	7614,	4781,	7373,	2827,
-3859,	1665,	-4929,	-9144,	-12512,	-7802,	-7665,	397,
-7957,	-1603,	4371,	-25,	-2384,	-4624,	-5393,	2529,
1206,	-5690,	-3153,	2570,	-2820,	-7390,	-8621,	-12612,
-9057,	-47,	-2097,	-6462,	-273,	-113,	37,	121,
-78,	-167,	-35,	-223,	-230,	-218,	-289,	-355,
-348,	-185,	-146,	-25,	-196,	-196,	-269,	-242,
-382,	-468,	-222,	-76,	-169,	-101,	-137,	-83,
20,	-21,	-72,	-3,	-65,	-62,	80,	153,
165,	190,	178,	211,	318,	369,	292,	161,
75,	6,	31,	-109,	-77,	87,	-4439,	634,
9658,	-2927,	627,	8273,	4954,	1803,	-1583,	-7443,
-510,	-9513,	-9115,	-5735,	4408,	2738,	7718,	12194,
2765,	2227,	8343,	368,	5307,	6820,	6431,	12594,
1111,	8668,	-1135,	-982,	-1916,	-9438,	-13889,	-16491,
-16718,	-13521,	-10284,	-3492,	287,	-10359,	655,	-4843,
170,	-4906,	-9115,	-2715,	-10687,	-15620,	-11943,	-10734,
-1262,	-134,	-2,	-29,	-134,	-117,	-114,	-256,
-292,	-387,	-115,	-154,	-185,	4,	-165,	14,
113,	-41,	-142,	35,	13,	119,	217,	262,
137,	97,	-43,	-2,	-90,	46,	70,	75,
102,	-103,	-101,	-161,	-67,	99,	220,	258,
307,	189,	183,	4,	-64,	-134,	-96,	-112,
-191,	-302,	-8291,	-4820,	-7859,	-4133,	-9284,	-11601,
-3648,	-351,	-11130,	-8378,	-14991,	-3388,	1643,	-3247,
-2332,	-5061,	2193,	7917,	7743,	-4794,	-5920,	-11704,
1490,	3606,	-2545,	-1255,	-2173,	781,	4728,	-4094,
554,	4552,	-2172,	-5862,	2002,	3011,	-4989,	-1185,
-1813,	-8562,	-3309,	-4322,	-6123,	-7619,	1715,	1312,
-2463,	2976,	5553,	6729,	7271,	71,	244,	62,
-103,	-32,	-42,	-134,	-249,	-333,	-105,	-275,
-132,	-2,	-89,	-63,	15,	54,	14,	130,
202,	259,	233,	135,	-10,	-22,	-143,	1,
107,	72,	-1,	136,	87,	217,	329,	295,
125,	116,	-51,	128,	-73,	-71,	-26,	-53,
-125,	-56,	144,	-78,	-201,	-227,	-1670,	-646,
-11150,	-13256,	-2928,	2898,	962,	6365,	-5829,	-12170,
-15780,	-19604,	-5763,	748,	-10438,	-8768,	-3581,	-1357,
-4050,	-6267,	-9091,	-8362,	-5197,	-8639,	-14139,	-11895,
-2341,	-8050,	-12049,	-8477,	903,	-11378,	-8355,	1153,
-1374,	-6083,	-3180,	-5436,	1290,	-5437,	-223,	2394,
-6807,	-3453,	-1948,	1107,	-4364,	-11202,	-1129,	-11419,
-15957,	-51,	-221,	-250,	-333,	-422,	-318,	-406,
-144,	-191,	-299,	-88,	-62,	-86,	-16,	-27,
47,	-8,	-60,	108,	14,	-33,	52,	43,
70,	76,	-24,	-48,	-200,	-132,	-39,	-82,
-119,	-275,	-205,	-332,	-383,	-379,	-208,	-287,
-268,	-256,	-69,	-114,	-77,	11,	-51,	54,
88,	-138,	-42,	2378,	8360,	11134,	12219,	4365,
10750,	8914,	-94,	210,	-2153,	6445,	8018,	3318,
-4251,	-4354,	-9953,	-6550,	-8552,	-13077,	-9963,	-9528,
-849,	757,	-5535,	1778,	-675,	-6430,	-3635,	-2256,
-10636,	-10554,	-7105,	-9808,	-14277,	-8698,	-11025,	-11641,
-4620,	2368,	6101,	1044,	-4047,	-11565,	-16749,	-16905,
-7759,	-1829,	-718,	2124,	-2023,	-58,	-27,	92,
42,	84,	-124,	15,	140,	199,	-23,	-45,
-196,	-60,	-154,	-157,	42,	-155,	29,	161,
206,	-1,	-58,	-31,	-96,	-164,	59,	152,
50,	-40,	128,	12,	21,	51,	41,	125,
14,	200,	303,	148,	225,	74,	199,	258,
208,	157,	240,	24,	4,	27,	78,	-4349,
-2633,	5482,	-4241,	2662,	7534,	177,	-1766,	-5182,
5473,	7361,	-476,	7553,	9862,	2129,	-5270,	7122,
10835,	-485,	4127,	-3722,	-6348,	-3957,	348,	8114,
1056,	-5086,	-8464,	-2145,	546,	-5495,	4666,	2371,
-1420,	-1257,	3945,	7465,	3130,	2030,	254,	7739,
8503,	-3414,	-8175,	-6341,	-5973,	2317,	-1495,	-6776,
-8651,	-85,	-26,	-4,	-48,	-194,	-300,	-66,
-71,	-187,	-221,	-54,	-202,	-143,	-2,	73,
-98,	-22,	84,	-3,	164,	183,	201,	22,
136,	-39,	112,	-70,	106,	-22,	-162,	60,
25,	-148,	-158,	24,	86,	-36,	80,	-22,
-158,	-240,	-16,	-67,	-83,	-229,	-145,	-162,
-257,	-358,	-205,	-3405,	-7388,	-6516,	-7787,	-9237,
687,	-9504,	-4703,	-3169,	2282,	6281,	-3806,	-7067,
-12485,	-14333,	-18818,	-21835,	-11757,	-5844,	-13995,	-4618,
-2989,	-7873,	-4162,	-1848,	-8688,	1103,	3738,	-3964,
-10497,	-12021,	-8392,	-13343,	-4874,	-2218,	1835,	-4075,
-1691,	5779,	6058,	5669,	-5162,	-374,	-8860,	-8497,
-11159,	-6210,	-13617,	-5130,	-13633,	-3222,	-39,	54,
-41,	-56,	-159,	-291,	-278,	-53,	-20,	-84,
-57,	111,	93,	-28,	-50,	46,	127,	180,
236,	238,	10,	17,	10,	-140,	-57,	138,
160,	-75,	-19,	108,	74,	165,	158,	77,
-26,	-118,	-217,	-207,	-67,	-159,	-22,	-10,
54,	192,	-22,	-121,	14,	64,	84,	-176,
-2558,	557,	3835,	-949,	-8392,	-11096,	-159,	2004,
-6138,	-9540,	-6389,	-10126,	-13087,	-11402,	-13326,	-11838,
-6027,	1431,	-279,	-3633,	-2541,	285,	6896,	-3730,
-4495,	5173,	-6719,	3990,	-3373,	-11474,	1570,	-6153,
-4523,	-1189,	-3795,	5625,	-3615,	-3938,	318,	5611,
5335,	9605,	13678,	6906,	-556,	-3899,	-1642,	568,
9326,	4304,	-79,	69,	-61,	-26,	7,	-42,
-175,	-37,	-156,	-238,	-88,	48,	122,	30,
-46,	-208,	50,	-43,	-162,	75,	194,	144,
-91,	81,	117,	252,	263,	230,	194,	88,
267,	164,	264,	351,	113,	168,	93,	48,
237,	-6,	7,	65,	241,	267,	274,	376,
288,	393,	157,	236,	12659,	8957,	3444,	13136,
15005,	19116,	15363,	20697,	16029,	14085,	6722,	16244,
7050,	8453,	16835,	17302,	21781,	13751,	11561,	18158,
19746,	20742,	16951,	10604,	5519,	15144,	12952,	8932,
8391,	10728,	7212,	7390,	1710,	10290,	4096,	4481,
13803,	18991,	8002,	6504,	14643,	6607,	4611,	4540,
9119,	8283,	5360,	3732,	2760,	5055,	62,	73,
264,	294,	42,	110,	93,	229,	152,	-26,
-135,	-120,	-164,	-78,	34,	170,	33,	118,
64,	196,	18,	188,	242,	241,	232,	215,
160,	22,	-63,	-71,	-27,	89,	-53,	33,
133,	272,	199,	21,	-84,	122,	-20,	-77,
154,	12,	-154,	85,	-29,	125,	-69,	143,
7111,	5987,	-3926,	-6216,	-10595,	-8624,	991,	-9375,
526,	-5196,	-12089,	-13471,	-14170,	-4183,	-11448,	-10126,
-1733,	-6375,	-5431,	2447,	4027,	3806,	8930,	13555,
9978,	13539,	2798,	12780,	344,	195,	4197,	-1243,
2688,	11445,	576,	-301,	7970,	710,	-1506,	-7214,
-11046,	-4256,	3609,	-6848,	4232,	-1152,	-9091,	1099,
2730,	6187,	-11,	-177,	75,	15,	-172,	52,
146,	47,	127,	60,	-36,	107,	39,	1,
-94,	-181,	7,	94,	14,	138,	189,	296,
363,	118,	30,	-41,	-150,	-157,	-223,	-104,
-155,	-181,	-276,	-9,	5,	-201,	-136,	-55,
-120,	-162,	52,	-142,	-94,	49,	-67,	-220,
-46,	132,	-47,	134,	-3481,	-7621,	-8453,	-4382,
3085,	4538,	6549,	-2378,	-8738,	-11275,	-79,	-7538,
-5938,	4024,	-5934,	-3034,	920,	4102,	3625,	1488,
-1019,	8479,	10616,	2257,	1388,	8033,	7908,	6980,
3365,	6015,	6326,	11870,	8863,	14718,	8343,	9677,
16892,	8147,	14177,	17125,	17951,	7661,	5972,	13924,
13813,	16844,	12720,	16671,	10115,	8618,	360,	103,
274,	341,	148,	110,	246,	261,	53,	-27,
152,	-3,	164,	203,	103,	-39,	188,	194,
334,	345,	413,	226,	390,	437,	505,	491,
514,	574,	298,	488,	507,	401,	198,	331,
314,	257,	430,	240,	273,	337,	364,	411,
294,	317,	458,	501,	400,	312,	254,	394,
8451,	8752,	6040,	15882,	18478,	12831,	11375,	14918,
17552,	13531,	18727,	20338,	16838,	19273,	25983,	24135,
18745,	10940,	18763,	21645,	24501,	26519,	31422,	17996,
10963,	6935,	14350,	6448,	16420,	22217,	13906,	10546,
6604,	9788,	19361,	14149,	8964,	8754,	19209,	11041,
14821,	13029,	12144,	19881,	8894,	12896,	19650,	22245,
18674,	17877,	10942,	257,	403,	349,	478,	469,
491,	574,	625,	497,	570,	466,	585,	655,
438,	576,	424,	522,	618,	409,	344,	515,
562,	391,	509,	543,	424,	316,	187,	241,
246,	190,	164,	301,	143,	281,	378,	453,
430,	252,	162,	120,	210,	88,	241,	128,
251,	165,	26,	15,	-363,	92,	-301,	7332,
9191,	16302,	9741,	10472,	3905,	14410,	7550,	8044,
5030,	13384,	19700,	18158,	8722,	1253,	1766,	7816,
12536,	3249,	-2453,	-6949,	1408,	8769,	11853,	12317,
17056,	21143,	12970,	9638,	11545,	9993,	10852,	18152,
17251,	21675,	20290,	11648,	14763,	21123,	20073,	23381,
11567,	22095,	22702,	16380,	19933,	16120,	17516,	512,
533,	265,	135,	282,	362,	438,	316,	289,
231,	395,	466,	542,	305,	138,	311,	127,
276,	188,	60,	180,	351,	312,	372,	498,
296,	215,	368,	230,	309,	269,	156,	192,
52,	2,	81,	65,	129,	285,	119,	141,
132,	93,	49,	-89,	79,	83,	-26,	95,
134,	5228,	-3342,	-6792,	-2094,	-7861,	-2180,	-4230,
6344,	3009,	2299,	-5225,	-9334,	-9438,	-13363,	-7559,
-4741,	3432,	4081,	1983,	-4411,	-3015,	-1024,	747,
-4795,	-1488,	-3222,	-10943,	-7222,	-1107,	-1463,	-8132,
-4696,	1512,	2940,	-3451,	4427,	-5356,	-3423,	6499,
-3463,	-7716,	806,	6532,	-2147,	-2208,	-31,	-2266,
4984,	4039,	6956,	201,	190,	89,	229,	63,
13,	131,	126,	139,	179,	-6,	135,	132,
96,	123,	-27,	160,	194,	214,	71,	213,
69,	-1,	110,	240,	109,	-7,	1,	219,
69,	91,	208,	54,	-14,	-135,	-137,	10,
-129,	-209,	-187,	-59,	48,	43,	-14,	90,
-111,	-141,	-82,	-194,	12,	1747,	-8565,	-2416,
-3901,	-3314,	-10558,	-2333,	6683,	-2711,	2557,	-4957,
1464,	-3653,	4147,	-5258,	-4347,	-3119,	-10991,	-13524,
-7856,	-14511,	-1628,	-3632,	-6618,	-2840,	-6959,	-6570,
-4843,	-7887,	-3233,	-4872,	-6357,	-12601,	-10230,	-1058,
-3828,	-1251,	2380,	-3644,	4059,	5423,	-3398,	-3696,
4895,	-3754,	3098,	9548,	10678,	-312,	-7940,	-598,
-140,	40,	119,	55,	-74,	-140,	-1,	-185,
7,	-138,	-96,	-86,	-96,	55,	-3,	85,
179,	147,	73,	127,	214,	130,	172,	-21,
192,	234,	139,	154,	-35,	202,	112,	-38,
61,	207,	306,	217,	61,	233,	122,	210,
203,	90,	217,	65,	25,	-55,	14,	-6,
117,	150,	5445,	876,	7328,	10210,	9470,	3696,
11065,	9010,	6856,	422,	-4446,	2384,	7750,	10693,
7411,	7588,	5867,	7600,	4685,	8380,	2227,	5469,
14141,	5686,	-193,	10001,	8408,	14253,	9459,	9030,
16372,	12477,	4171,	13087,	19560,	12607,	16646,	21784,
10887,	2254,	6475,	-408,	-5267,	-5976,	-7622,	-2736,
-1317,	-4244,	-5316,	-5578,	-290,	-287,	-43,	-101,
72,	67,	-76,	-179,	-38,	-93,	-119,	44,
114,	-27,	-156,	-126,	-39,	53,	-30,	41,
-125,	42,	-117,	104,	-102,	-175,	-280,	-219,
-8,	-34,	-84,	-20,	-38,	-19,	-121,	-29,
150,	236,	105,	138,	136,	59,	239,	225,
136,	138,	286,	62,	-30,	1480,	13018,	17884,
13193,	11124,	13378,	17787,	14289,	18182,	7336,	2243,
7931,	12689,	10109,	1715,	231,	1052,	3408,	8313,
4375,	11643,	2274,	6111,	144,	1081,	-1172,	-5041,
378,	-2271,	6608,	5650,	886,	4961,	5624,	-3136,
-9209,	985,	2248,	9891,	15082,	14553,	14075,	8680,
4389,	6402,	2050,	7082,	-885,	8973,	7299,	11509,
345,	92,	183,	134,	158,	134,	219,	130,
215,	242,	47,	125,	225,	211,	226,	11,
157,	60,	-98,	93,	-76,	-139,	-95,	-91,
-201,	-155,	-159,	29,	121,	169,	20,	112,
-18,	-104,	-142,	-20,	-192,	28,	-118,	68,
165,	130,	123,	19,	14,	189,	281,	204,
178,	209,	1929,	-3289,	2973,	8722,	2018,	-1177,
8423,	13546,	3503,	2415,	2220,	-666,	-1961,	-5341,
-4623,	6582,	11151,	3796,	11598,	13037,	14798,	8179,
11095,	5234,	2683,	-3269,	-963,	5373,	7413,	1649,
10889,	11821,	102,	-4813,	3323,	11409,	12594,	18443,
9510,	12201,	5415,	2556,	-3384,	-4980,	1261,	5874,
-220,	-4943,	1736,	4097,	205,	165,	53,	236,
218,	270,	94,	153,	326,	244,	216,	222,
51,	-28,	92,	-69,	-25,	-25,	91,	-33,
-12,	-22,	101,	215,	-16,	143,	109,	102,
33,	65,	72,	-84,	26,	-3,	99,	190
}; 

__eds__ __attribute__((space(prog))) int16_t SAMPLE_keyclick[sample_length] = {
-40,	-50,	-42,	-39,	-44,	-71,	-71,	-74,
-83,	-71,	-62,	-61,	-68,	-79,	-66,	-63,
-64,	-73,	-75,	-64,	-54,	-63,	-66,	-59,
-66,	-60,	-50,	-65,	-72,	-68,	-71,	-74,
-95,	-99,	-95,	-98,	-99,	-114,	-115,	-110,
-125,	-140,	-136,	-115,	-117,	-132,	-140,	-121,
-118,	-128,	-133,	-125,	-110,	-104,	-112,	-119,
-112,	-125,	-129,	-108,	-113,	-123,	-117,	-105,
-92,	-105,	-114,	-111,	-106,	-132,	-146,	-155,
-165,	-165,	-153,	-141,	-141,	-133,	-117,	-114,
-119,	-130,	-138,	-140,	-146,	-164,	-164,	-169,
-165,	-151,	-166,	-177,	-159,	-155,	-144,	-154,
-163,	-153,	-137,	-139,	-167,	-160,	-158,	-161,
-180,	-174,	-159,	-163,	-178,	-178,	-157,	-150,
-155,	-149,	-120,	-110,	-94,	-87,	-77,	-78,
-73,	-78,	-88,	-96,	-91,	-83,	-71,	-64,
-48,	-38,	-39,	-52,	-70,	-66,	-56,	-58,
-65,	-71,	-87,	-80,	-69,	-57,	-48,	-51,
-37,	-14,	-10,	-29,	-42,	-43,	-63,	-93,
-105,	-100,	-99,	-114,	-129,	-118,	-100,	-123,
-116,	-112,	-119,	-111,	-115,	-104,	-111,	-103,
-83,	-73,	-64,	-61,	-63,	-82,	-87,	-97,
-95,	-73,	-66,	-85,	-78,	-48,	-37,	-24,
-29,	-29,	-29,	-45,	-55,	-42,	-52,	-74,
-77,	-67,	-84,	-67,	-41,	-60,	-66,	-58,
-64,	-83,	-121,	-128,	-103,	-122,	-146,	-121,
-88,	-100,	-97,	-68,	-47,	-49,	-25,	0,
26,	10,	8,	8,	11,	8,	19,	10,
-15,	-18,	-20,	-19,	-9,	-25,	-9,	18,
19,	3,	-4,	-1,	-8,	-28,	-51,	-18,
-17,	-3,	15,	21,	34,	33,	35,	35,
47,	69,	56,	35,	10,	1,	12,	0,
-31,	-46,	-54,	-77,	-89,	-67,	-29,	-42,
-73,	-61,	-57,	-40,	-14,	26,	80,	99,
125,	118,	93,	66,	32,	28,	14,	-6,
-4,	-1,	-29,	-25,	-32,	-4,	16,	12,
-13,	-43,	-74,	-86,	-106,	-149,	-163,	-146,
-147,	-120,	-93,	-92,	-104,	-54,	24,	103,
166,	175,	169,	142,	121,	96,	115,	145,
116,	95,	101,	80,	37,	12,	37,	78,
45,	-73,	-206,	-260,	-186,	-75,	20,	53,
2,	-85,	-182,	-223,	-221,	-178,	-80,	31,
60,	33,	6,	-32,	-29,	83,	189,	222,
213,	153,	65,	25,	59,	81,	80,	62,
34,	-4,	-111,	-202,	-270,	-260,	-182,	-158,
-245,	-364,	-351,	-256,	-211,	-234,	-388,	-402,
-238,	-133,	-97,	-19,	105,	194,	145,	47,
-40,	-172,	-376,	-539,	-542,	-451,	-296,	-113,
52,	221,	265,	161,	104,	52,	49,	-51,
-317,	-560,	-476,	-170,	-30,	-16,	77,	180,
197,	168,	193,	180,	103,	-1,	-1,	77,
158,	192,	220,	187,	78,	-63,	-184,	-213,
-220,	-191,	-95,	29,	12,	-50,	-48,	-132,
-187,	-188,	-120,	-54,	-44,	-144,	-205,	-177,
-120,	21,	239,	410,	425,	406,	407,	320,
160,	176,	310,	330,	269,	163,	69,	0,
-105,	-211,	-218,	-107,	18,	67,	30,	-26,
-31,	-6,	-58,	-190,	-321,	-371,	-385,	-382,
-303,	-100,	51,	42,	-67,	-155,	-122,	-73,
-66,	-12,	76,	127,	189,	181,	112,	92,
74,	-10,	-4,	89,	48,	-114,	-266,	-241,
-155,	-134,	-184,	-245,	-192,	-135,	-268,	-474,
-564,	-569,	-503,	-314,	-262,	-373,	-384,	-270,
-178,	-98,	107,	218,	77,	-191,	-478,	-753,
-770,	-673,	-654,	-577,	-343,	-87,	15,	-19,
-127,	-238,	-403,	-635,	-739,	-685,	-620,	-557,
-427,	-254,	-71,	-3,	15,	150,	124,	-10,
-87,	-85,	-40,	61,	152,	249,	375,	472,
439,	432,	425,	297,	190,	171,	173,	179,
242,	252,	117,	37,	-13,	-60,	-4,	-11,
-62,	-86,	-132,	-187,	-191,	-170,	-179,	-233,
-228,	-215,	-188,	-118,	-43,	75,	184,	189,
134,	107,	132,	212,	258,	279,	266,	255,
223,	161,	173,	221,	218,	163,	118,	101,
122,	16,	-172,	-275,	-289,	-202,	-102,	15,
131,	178,	100,	-31,	-148,	-180,	-157,	-141,
-137,	-91,	7,	113,	188,	265,	279,	173,
49,	-87,	-181,	-218,	-226,	-215,	-134,	-32,
21,	43,	-42,	-171,	-323,	-422,	-474,	-531,
-541,	-514,	-393,	-173,	-62,	-87,	-168,	-227,
-228,	-241,	-222,	-115,	34,	158,	230,	290,
305,	261,	190,	157,	78,	21,	28,	108,
249,	375,	414,	392,	362,	252,	102,	5,
-75,	-126,	-147,	-125,	-51,	-10,	-53,	-107,
-109,	-129,	-195,	-232,	-195,	-151,	-178,	-187,
-172,	-160,	-160,	-190,	-174,	-144,	-168,	-173,
-215,	-245,	-215,	-141,	-74,	-37,	-54,	-105,
-116,	-139,	-154,	-171,	-154,	-74,	-61,	-151,
-210,	-221,	-241,	-223,	-116,	-30,	-22,	-52,
-38,	64,	153,	158,	233,	337,	408,	388,
299,	225,	205,	199,	172,	125,	114,	188,
238,	210,	155,	88,	15,	-47,	-67,	-203,
-355,	-411,	-473,	-402,	-200,	-32,	48,	89,
103,	123,	122,	62,	11,	15,	-51,	-8,
81,	172,	349,	538,	593,	527,	450,	320,
171,	81,	94,	170,	221,	249,	326,	370,
360,	361,	372,	240,	107,	128,	170,	164,
204,	261,	267,	261,	219,	134,	40,	-12,
29,	91,	160,	255,	311,	284,	223,	213,
214,	118,	11,	-93,	-170,	-193,	-139,	-118,
-97,	-98,	-148,	-192,	-240,	-337,	-339,	-300,
-304,	-169,	-25,	41,	29,	23,	-24,	-122,
-179,	-171,	-163,	-138,	-49,	15,	-7,	-63,
-46,	-32,	-68,	-119,	-90,	-29,	33,	34,
9,	26,	27,	-2,	-75,	-147,	-122,	-100,
-58,	-60,	-83,	-97,	-52,	-26,	-79,	-111,
-61,	31,	80,	34,	18,	19,	5,	36,
82,	80,	101,	166,	231,	269,	265,	258,
265,	145,	-31,	-132,	-170,	-252,	-319,	-318,
-262,	-246,	-210,	-133,	-58,	-41,	-90,	-165,
-211,	-202,	-175,	-144,	-133,	-142,	-173,	-261,
-329,	-324,	-309,	-252,	-135,	11,	56,	60,
103,	20,	-104,	-161,	-141,	-126,	-124,	-81,
-31,	-31,	24,	96,	108,	97,	68,	22,
-74,	-109,	-73,	-44,	-54,	-97,	-91,	-63,
-6,	-7,	24,	21,	-34,	-56,	-29,	-12,
47,	108,	106,	150,	180,	179,	160,	160,
179,	112,	13,	-22,	-24,	-48,	16,	125,
256,	328,	323,	308,	297,	260,	312,	276,
153,	122,	221,	307,	279,	241,	251,	269,
241,	240,	268,	293,	260,	161,	84,	50,
124,	247,	290,	383,	512,	482,	468,	517,
563,	626,	664,	670,	737,	780,	651,	465,
331,	262,	147,	84,	174,	256,	275,	314,
322,	372,	502,	517,	492,	509,	471,	341,
59,	-299,	-510,	-582,	-759,	-1008,	-1165,	-1137,
-1096,	-1187,	-1320,	-1413,	-1462,	-1374,	-1188,	-1081,
-1117,	-1268,	-1460,	-1656,	-1805,	-1861,	-1809,	-1659,
-1543,	-1452,	-1493,	-1587,	-1659,	-1619,	-1520,	-1500,
-1588,	-1741,	-1835,	-1858,	-1821,	-1724,	-1668,	-1700,
-1641,	-1447,	-1438,	-1544,	-1500,	-1377,	-1403,	-1566,
-1473,	-1096,	-858,	-861,	-766,	-373,	-307,	-481,
-474,	-410,	-478,	-696,	-911,	-1107,	-1255,	-1344,
-1345,	-1449,	-1711,	-1997,	-2078,	-1880,	-1526,	-1230,
-979,	-678,	-432,	-224,	-63,	124,	287,	587,
875,	1018,	1015,	892,	736,	590,	544,	472,
231,	-109,	-242,	-364,	-467,	-461,	-470,	-449,
-309,	-61,	261,	538,	652,	800,	1001,	1244,
1362,	1288,	1182,	1286,	1417,	1304,	956,	723,
901,	1254,	1365,	1256,	1247,	1375,	1393,	1314,
1329,	1499,	1511,	1288,	1025,	1049,	1124,	928,
590,	446,	519,	551,	505,	570,	722,	696,
608,	612,	556,	335,	131,	146,	258,	161,
-32,	-90,	-161,	-388,	-450,	-320,	-238,	-247,
-166,	108,	274,	351,	425,	361,	432,	621,
761,	721,	576,	641,	748,	709,	747,	991,
1182,	1204,	1242,	1455,	1693,	1881,	1966,	1893,
1711,	1597,	1502,	1301,	981,	645,	288,	-19,
-225,	-423,	-608,	-753,	-804,	-871,	-926,	-831,
-732,	-753,	-890,	-916,	-730,	-469,	-316,	-243,
-79,	227,	410,	343,	301,	517,	805,	889,
770,	735,	852,	890,	733,	720,	820,	911,
981,	1044,	1038,	1077,	1198,	1299,	1351,	1437,
1514,	1571,	1635,	1626,	1613,	1600,	1569,	1453,
1403,	1442,	1491,	1521,	1551,	1647,	1701,	1624,
1470,	1319,	1173,	991,	735,	468,	243,	38,
-74,	-92,	-164,	-371,	-535,	-505,	-340,	-317,
-413,	-412,	-331,	-296,	-231,	-262,	-247,	-164,
-164,	-306,	-546,	-782,	-1038,	-1184,	-1237,	-1283,
-1382,	-1454,	-1457,	-1488,	-1497,	-1433,	-1343,	-1290,
-1152,	-900,	-562,	-231,	-117,	-60,	121,	194,
99,	-13,	-1,	108,	36,	-109,	-177,	-135,
-202,	-413,	-637,	-774,	-932,	-1030,	-1062,	-1171,
-1341,	-1561,	-1747,	-1953,	-2175,	-2269,	-2358,	-2468,
-2597,	-2789,	-2951,	-3007,	-3035,	-3084,	-3071,	-3051,
-3070,	-3149,	-3101,	-2919,	-2845,	-2731,	-2497,	-2236,
-2003,	-1833,	-1613,	-1378,	-1380,	-1509,	-1455,	-1373,
-1465,	-1497,	-1376,	-1264,	-1240,	-1188,	-1155,	-1165,
-1241,	-1285,	-1167,	-1168,	-1265,	-1324,	-1387,	-1442,
-1487,	-1493,	-1525,	-1546,	-1434,	-1249,	-1172,	-1183,
-1082,	-1003,	-958,	-917,	-841,	-847,	-949,	-960,
-1002,	-1042,	-1030,	-1118,	-1321,	-1373,	-1347,	-1343,
-1391,	-1415,	-1392,	-1328,	-1314,	-1249,	-1118,	-1107,
-1136,	-1075,	-981,	-915,	-818,	-732,	-666,	-707,
-605,	-352,	-183,	-190,	-133,	25,	109,	195,
363,	621,	798,	834,	1111,	1465,	1602,	1744,
1945,	2153,	2381,	2624,	2873,	3008,	3104,	3344,
3675,	3804,	3820,	3929,	4050,	4115,	4163,	4282,
4415,	4432,	4531,	4645,	4675,	4702,	4772,	4822,
4751,	4747,	4838,	4899,	4930,	4995,	5048,	5071,
5114,	5149,	5117,	5033,	5030,	5000,	5036,	5185,
5263,	5261,	5375,	5521,	5497,	5455,	5440,	5436,
5504,	5462,	5298,	5238,	5285,	5262,	5271,	5302,
5309,	5408,	5549,	5573,	5538,	5554,	5602,	5577,
5338,	5209,	5189,	4964,	4671,	4482,	4311,	4139,
4010,	3877,	3799,	3811,	3702,	3543,	3458,	3394,
3289,	3187,	3060,	2877,	2595,	2448,	2444,	2160,
1670,	1472,	1428,	1300,	1076,	787,	433,	126,
-78,	-267,	-385,	-403,	-385,	-787,	-1312,	-1521,
-1772,	-2412,	-3406,	-4252,	-4480,	-4357,	-4198,	-4309,
-4452,	-4230,	-3847,	-4011,	-4988,	-5737,	-5838,	-6172,
-6810,	-7204,	-7052,	-6541,	-6550,	-6954,	-6817,	-6190,
-6063,	-6416,	-6552,	-6916,	-6757,	-5152,	-4331,	-5382,
-6435,	-5981,	-5245,	-5421,	-5666,	-5183,	-5073,	-6599,
-7625,	-6532,	-5133,	-5404,	-6346,	-5970,	-4227,	-2822,
-2805,	-3282,	-2576,	-1783,	-1669,	-2221,	-3604,	-5047,
-5692,	-5369,	-5292,	-6490,	-7806,	-8621,	-8427,	-6248,
-4348,	-4236,	-4567,	-3721,	-2108,	-1148,	-1164,	-1885,
-2357,	-1657,	93,	1166,	798,	-414,	-2542,	-4993,
-5179,	-3244,	-1937,	-3154,	-5119,	-4702,	-2813,	-1995,
-2727,	-2845,	-1473,	931,	2840,	2468,	228,	-1905,
-818,	-8,	-3616,	-7913,	-10247,	-10429,	-7736,	-1160,
3276,	-181,	-4944,	-4445,	-2785,	-4753,	-8376,	-8568,
-5200,	263,	5342,	6430,	1125,	-5639,	-4889,	1067,
1069,	-6370,	-9447,	-3604,	3035,	5455,	4218,	-1080,
-7287,	-9056,	-9645,	-11817,	-12717,	-12364,	-10624,	-7360,
-3018,	-1220,	-4598,	-8547,	-6778,	-3987,	-7806,	-12183,
-8107,	2195,	9001,	8328,	4385,	-688,	-7008,	-9346,
-5516,	-4884,	-10933,	-16231,	-10584,	1176,	4008,	-1370,
-3023,	1042,	2436,	-421,	-469,	337,	-2045,	-4325,
-1827,	2497,	2189,	1636,	4979,	6232,	4684,	5828,
9293,	12976,	13290,	10825,	8737,	6726,	6120,	9084,
12632,	15136,	15081,	10044,	4897,	3088,	2634,	2802,
6332,	12034,	12987,	8410,	9353,	16570,	15422,	7015,
3454,	6288,	7158,	2299,	-1436,	-1699,	-4268,	-7666,
-7960,	-6667,	-6366,	-4189,	2693,	9419,	12806,	14255,
14792,	13496,	7684,	1051,	1307,	7020,	13003,	16096,
16563,	16370,	15925,	13896,	12861,	13300,	7777,	446,
1471,	7955,	11503,	6301,	1567,	5822,	8391,	2832,
-1496,	1827,	8595,	11045,	10170,	9252,	7652,	5185,
2649,	3756,	9372,	13089,	10012,	3137,	-1500,	-3296,
-8207,	-16123,	-21295,	-23480,	-24017,	-20301,	-9090,	4247,
10305,	10706,	11064,	10093,	6426,	3026,	2714,	799,
-2425,	-2340,	-2172,	-2573,	-3863,	-7652,	-8252,	-6036,
-3166,	-2358,	-4976,	-6865,	-6572,	-3979,	-1430,	-4870,
-7969,	-5509,	-2674,	-3205,	-7691,	-11574,	-14055,	-17455,
-22049,	-28109,	-31952,	-32766,	-29658,	-21297,	-11111,	-3551,
892,	4551,	7757,	6769,	3021,	-1900,	-7009,	-8596,
-7085,	-6049,	-6553,	-6656,	-4563,	-160,	2864,	3725,
6227,	9864,	10795,	8501,	6138,	7361,	10187,	11050,
10053,	5676,	702,	-613,	-2206,	-6392,	-13332,	-19073,
-17289,	-11325,	-5463,	-1229,	269,	1926,	4610,	7181,
9519,	8349,	3868,	-185,	-1592,	-2047,	-4477,	-6168,
-3690,	867,	3892,	5470,	8873,	12887,	12400,	10293,
11790,	15450,	15824,	12192,	9228,	8300,	5598,	2,
-4468,	-5260,	-6199,	-8762,	-8620,	-4979,	-843,	2089,
4239,	6906,	9760,	10066,	8404,	5564,	1645,	-2610,
-6624,	-9910,	-12273,	-13690,	-13473,	-11214,	-8314,	-4241,
4,	1795,	2464,	3648,	3359,	755,	-1647,	-1123,
1781,	4650,	5058,	4733,	5440,	4604,	-221,	-6785,
-13711,	-18378,	-16244,	-7572,	1669,	5398,	7785,	13065,
16911,	14388,	6907,	-1539,	-8577,	-12096,	-11508,	-7537,
-2089,	986,	2937,	6754,	9772,	8417,	2723,	-3291,
-6304,	-6526,	-5136,	-4068,	-3440,	-392,	5919,	13031,
16647,	16006,	14473,	13340,	11908,	7531,	-458,	-7052,
-9139,	-6881,	-3887,	-3222,	-3118,	-849,	3755,	7953,
7936,	3873,	83,	-766,	686,	2769,	5412,	7959,
8869,	8425,	7874,	6162,	1124,	-4730,	-6491,	-5071,
-3407,	-1494,	1909,	5428,	8506,	11965,	15859,	18484,
16875,	12690,	11379,	10862,	7388,	2439,	-993,	-1083,
2027,	6069,	11174,	17339,	21598,	24958,	26522,	25392,
22089,	15438,	7371,	1185,	-2452,	-3928,	-5490,	-7802,
-7729,	-4652,	-826,	1906,	3335,	3290,	3145,	4809,
7341,	8755,	7387,	4143,	2084,	1834,	726,	-3430,
-9032,	-12698,	-13498,	-11875,	-9542,	-7681,	-4481,	2258,
10746,	16653,	19569,	21623,	22401,	20249,	15090,	8311,
1908,	-4086,	-8505,	-8788,	-5877,	-3450,	-1532,	2441,
7020,	7826,	3124,	-3275,	-5051,	-4279,	-6096,	-9336,
-10647,	-9412,	-6942,	-4262,	-2651,	-3278,	-4400,	-4010,
-2706,	-1786,	-1938,	-1944,	240,	4767,	7980,	7033,
3761,	1360,	122,	-2384,	-6536,	-9970,	-11353,	-10214,
-6559,	-2529,	1045,	4664,	8191,	11420,	12684,	10100,
5634,	2179,	326,	-918,	-2747,	-5148,	-7065,	-7307,
-5756,	-4959,	-6406,	-7971,	-8141,	-7644,	-6862,	-5715,
-4670,	-4528,	-5929,	-7010,	-6206,	-4823,	-4384,	-4040,
-2480,	-374,	-213,	-3070,	-6316,	-7030,	-5695,	-4565,
-4959,	-5582,	-4288,	-3256,	-5735,	-9886,	-12180,	-12416,
-12554,	-12962,	-12008,	-9150,	-6478,	-5395,	-5931,	-7445,
-9403,	-11561,	-13894,	-15439,	-14770,	-12761,	-11802,	-10815,
-7675,	-4516,	-4816,	-7307,	-7176,	-3917,	-1994,	-2789,
-3776,	-2586,	-1230,	-2468,	-3910,	-3884,	-4561,	-6955,
-8527,	-6938,	-3794,	-2435,	-2949,	-3368,	-2291,	-495,
-435,	-2225,	-3517,	-3241,	-3106,	-3877,	-4609,	-5241,
-5756,	-6233,	-6518,	-5639,	-4599,	-5081,	-7299,	-9484,
-9208,	-7493,	-6928,	-7606,	-7666,	-6450,	-5317,	-4937,
-5160,	-6004,	-6467,	-5982,	-5229,	-4196,	-2893,	-1768,
-336,	36,	-1248,	-3013,	-5146,	-6993,	-8138,	-7859,
-6143,	-5103,	-4383,	-3335,	-2665,	-2196,	-2850,	-4557,
-5553,	-5474,	-4581,	-3879,	-3989,	-3850,	-3341,	-3019,
-3666,	-5204,	-6226,	-6536,	-5993,	-3933,	-964,	1533,
2861,	3447,	4294,	4454,	3252,	1494,	-299,	-2037,
-3867,	-5724,	-6804,	-7108,	-8136,	-9431,	-9575,	-8892,
-7915,	-6631,	-5122,	-3433,	-2047,	-1471,	-1600,	-2359,
-3146,	-3885,	-4656,	-5077,	-5386,	-5586,	-4905,	-3016,
-918,	713,	2671,	5101,	6587,	7281,	8344,	10077,
11708,	12535,	12903,	13194,	12732,	10848,	8952,	8590,
9298,	9670,	9046,	8742,	9380,	9613,	8446,	7415,
7701,	7675,	6064,	4166,	3089,	3032,	3488,	4554,
6113,	6714,	6266,	6166,	7330,	9553,	11323,	12207,
13331,	15205,	17457,	18834,	18216,	15862,	13169,	11743,
10951,	9206,	7121,	6106,	6937,	8388,	9063,	9757,
10770,	11062,	10363,	9831,	10708,	11293,	10176,	8545,
7703,	7840,	7664,	5791,	3040,	682,	-899,	-2363,
-3604,	-3592,	-3354,	-2832,	-1285,	425,	1589,	2555,
4169,	6362,	8277,	9351,	9631,	9518,	9320,	9210,
9284,	9786,	10145,	9965,	9921,	9777,	9400,	8721,
7851,	7215,	6845,	6917,	7278,	7402,	7443,	6635,
4313,	2092,	565,	-557,	-1832,	-3056,	-2564,	-63,
2866,	4854,	6005,	7364,	8270,	7861,	7092,	6553,
5953,	5319,	5148,	6166,	7553,	7423,	5795,	4185,
3842,	3455,	1806,	-279,	-1116,	-68,	1159,	1335,
961,	1044,	1761,	1404,	174,	-986,	-2403,	-4121,
-6116,	-8161,	-9408,	-9977,	-10741,	-11380,	-10624,	-9071,
-8100,	-7352,	-6137,	-4637,	-3393,	-2608,	-2183,	-2292,
-2609,	-2432,	-1860,	-1839,	-2450,	-3177,	-3557,	-3721,
-4056,	-4948,	-6494,	-7896,	-8711,	-8964,	-8761,	-8223,
-7959,	-8209,	-8071,	-7266,	-7044,	-8126,	-9819,	-10940,
-11220,	-11791,	-12333,	-12053,	-11348,	-10581,	-9736,	-8551,
-7316,	-6191,	-5089,	-4349,	-3689,	-2845,	-2180,	-1624,
-1495,	-1964,	-2906,	-3830,	-3863,	-3655,	-3848,	-3453,
-2806,	-1954,	-1149,	-1241,	-1945,	-2661,	-2915,	-2807,
-2704,	-2247,	-1693,	-1437,	-1525,	-2345,	-3329,	-3913,
-4519,	-5480,	-6633,	-7071,	-6480,	-6047,	-6210,	-6225,
-5590,	-4304,	-3273,	-2801,	-2425,	-2182,	-2401,	-2971,
-3466,	-3999,	-4872,	-5820,	-6033,	-5079,	-3592,	-2873,
-3134,	-3497,	-3409,	-3327,	-4194,	-5739,	-6392,	-5824,
-4739,	-3880,	-3392,	-2848,	-2664,	-2841,	-2582,	-2215,
-2584,	-3397,	-3861,	-3783,	-3426,	-2934,	-2173,	-1520,
-1410,	-1546,	-1233,	-656,	-593,	-709,	-111,	1134,
2197,	3129,	4208,	4963,	4966,	5053,	5994,	6709,
6243,	5226,	4697,	5179,	6024,	6533,	6704,	6492,
6500,	6916,	7112,	7064,	6718,	6327,	6077,	5822,
5696,	5756,	5873,	6092,	6383,	7138,	7976,	8321,
8418,	8527,	9037,	9900,	10396,	10202,	9544,	8933,
8891,	9373,	10355,	11274,	12045,	12839,	13360,	13561,
13043,	11426,	9482,	8352,	7805,	7304,	6659,	5693,
4516,	3532,	2725,	1729,	400,	-759,	-1090,	-832,
-156,	760,	1809,	2922,	3344,	3016,	2576,	2187,
1522,	525,	-155,	-303,	-728,	-1716,	-2628,	-3199,
-3767,	-4250,	-4115,	-3313,	-2502,	-1934,	-1123,	-221,
200,	-11,	-366,	-342,	31,	525,	1168,	1806,
2081,	1796,	1162,	587,	-114,	-1165,	-2560,	-4035,
-4957,	-5302,	-5645,	-6017,	-5936,	-5075,	-3760,	-2268,
-849,	353,	1472,	2326,	2649,	2600,	2574,	2439,
2033,	1557,	1115,	764,	519,	484,	871,	1223,
1267,	1302,	1347,	1586,	1831,	1713,	1830,	2448,
3128,	3473,	3286,	2819,	2309,	1373,	352,	-196,
-217,	-20,	171,	517,	1053,	1565,	1658,	897,
-239,	-1264,	-2816,	-5003,	-7006,	-7855,	-7388,	-6331,
-5129,	-3832,	-2548,	-1305,	-657,	-714,	-1255,	-2085,
-2937,	-3770,	-4731,	-5760,	-6900,	-8038,	-9206,	-10333,
-10920,	-10969,	-10858,	-10528,	-9820,	-8647,	-7406,	-6674,
-6327,	-5988,	-5664,	-5768,	-6492,	-7629,	-8889,	-10241,
-11663,	-12981,	-14228,	-15347,	-15963,	-15795,	-14987,	-14115,
-13433,	-12986,	-13063,	-13799,	-14794,	-15582,	-16222,	-16370,
-15689,	-14651,	-13772,	-13392,	-13279,	-13182,	-13288,	-13501,
-13369,	-12772,	-11959,	-11440,	-11300,	-11352,	-11580,	-11907,
-12312,	-12869,	-13388,	-13546,	-13105,	-12160,	-11013,	-9880,
-9032,	-8791,	-9143,	-9370,	-9228,	-9044,	-8917,	-8485,
-7575,	-6557,	-6134,	-6509,	-6989,	-7108,	-7021,	-7033,
-7117,	-6950,	-6348,	-5380,	-4164,	-2968,	-2009,	-1078,
-138,	585,	1160,	2037,	3512,	4896,	5369,	5460,
5873,	6125,	5423,	4179,	3621,	3918,	4234,	4318,
4526,	4967,	5477,	6057,	6768,	7496,	8189,	8935,
9660,	10204,	10480,	10642,	10532,	9953,	9167,	8512,
8197,	8098,	7882,	7882,	8550,	9678,	10682,	11449,
12283,	13137,	13644,	13957,	14217,	14382,	14630,	15031,
15507,	15831,	15884,	15975,	16144,	16104,	15865,	15603,
15431,	14984,	14143,	13496,	13510,	13754,	13640,	13401,
13280,	12921,	12338,	11708,	11117,	10468,	9826,	9630,
9847,	10090,	10323,	10510,	10406,	10109,	10039,	10097,
9545,	8308,	7314,	7087,	7089,	6907,	6773,	7153,
7860,	8132,	7981,	7825,	7766,	7531,	6955,	6208,
5443,	4886,	4694,	4703,	5024,	5589,	6161,	6536,
6432,	5988,	5319,	4410,	3436,	2795,	2707,	3030,
3547,	4151,	4830,	5469,	5983,	6335,	6552,	6608,
6578,	6610,	6604,	6611,	6706,	6813,	6865,	6891,
7033,	7231,	7443,	7607,	7634,	7583,	7325,	6848,
6386,	6214,	6205,	6057,	6009,	6304,	6766,	6754,
6019,	5171,	4304,	3230,	2294,	1769,	1517,	1397,
1356,	1621,	2377,	3176,	3425,	2983,	2453,	2053,
1428,	478,	-490,	-1152,	-1256,	-877,	-308,	384,
830,	691,	230,	-138,	-419,	-975,	-1845,	-2458,
-2521,	-2260,	-2140,	-2268,	-2376,	-2580,	-2944,	-3304,
-3681,	-4245,	-4968,	-5424,	-5341,	-5054,	-4923,	-4980,
-5054,	-4950,	-4806,	-5034,	-5697,	-6431,	-7073,	-7785,
-8464,	-8898,	-9110,	-9137,	-8861,	-8201,	-7466,	-7156,
-7239,	-7310,	-7177,	-6998,	-6939,	-6946,	-7118,	-7217,
-6773,	-5957,	-5287,	-4871,	-4579,	-4239,	-4068,	-4354,
-4887,	-5595,	-6382,	-6725,	-6813,	-7191,	-7734,	-7871,
-7432,	-6897,	-6632,	-6395,	-6144,	-6290,	-6774,	-7157,
-7393,	-7558,	-7577,	-7236,	-6380,	-5470,	-4972,	-4617,
-4124,	-3972,	-4338,	-4936,	-5413,	-5746,	-6118,	-6434,
-6431,	-6022,	-5393,	-4808,	-4458,	-4243,	-4082,	-4091,
-4223,	-4314,	-4281,	-4157,	-4090,	-4012,	-3547,	-2942,
-2746,	-2768,	-2645,	-2660,	-2974,	-3355,	-3753,	-4328,
-4849,	-4762,	-4367,	-4160,	-3970,	-3229,	-2083,	-1222,
-976,	-1013,	-884,	-645,	-704,	-1067,	-1280,	-1274,
-1431,	-1786,	-1762,	-1046,	-389,	-403,	-744,	-811,
-548,	-697,	-1349,	-1713,	-1387,	-529,	424,	1137,
1521,	1596,	1421,	1030,	269,	-783,	-1932,	-2936,
-3488,	-3515,	-3154,	-2589,	-2005,	-1484,	-1110,	-884,
-951,	-1301,	-1668,	-1718,	-1387,	-818,	-331,	-107,
-75,	89,	381,	342,	-100,	-583,	-937,	-1201,
-1232,	-967,	-820,	-865,	-699,	-232,	370,	626,
517,	281,	10,	-166,	-296,	-612,	-1167,	-1843,
-2145,	-1654,	-807,	-93,	401,	781,	1304,	1920,
2284,	2247,	1805,	1373,	1467,	1651,	1573,	1527,
1822,	2242,	2499,	2658,	2871,	2978,	2863,	2588,
2489,	2642,	2894,	3108,	3321,	3642,	4056,	4424,
4582,	4451,	4379,	4349,	4008,	3471,	3145,	3157,
3145,	2790,	2488,	2635,	2888,	2848,	2533,	2152,
1775,	1352,	1037,	966,	948,	798,	701,	917,
1216,	1238,	1178,	1096,	964,	892,	700,	202,
-543,	-1250,	-1535,	-1503,	-1584,	-1876,	-2103,	-2040,
-1964,	-2054,	-2114,	-2053,	-1996,	-2016,	-2133,	-2499,
-2866,	-2946,	-2932,	-3061,	-3304,	-3495,	-3768,	-4490,
-5396,	-5881,	-5906,	-5855,	-5925,	-5897,	-5747,	-5718,
-5819,	-5891,	-5872,	-5914,	-6074,	-6328,	-6653,	-6935,
-6995,	-6805,	-6572,	-6470,	-6486,	-6624,	-6892,	-7028,
-6792,	-6251,	-5646,	-5230,	-5017,	-4883,	-4726,	-4561,
-4504,	-4554,	-4506,	-4242,	-3829,	-3385,	-2987,	-2709,
-2300,	-1715,	-1186,	-941,	-902,	-842,	-865,	-918,
-703,	-254,	60,	120,	239,	589,	895,	806,
476,	310,	356,	488,	774,	1223,	1807,	2476,
3057,	3330,	3302,	3179,	3002,	2721,	2569,	2794,
3243,	3809,	4568,	5491,	6074,	5921,	5355,	5011,
5058,	5209,	5310,	5348,	5547,	5981,	6450,	6716,
6658,	6436,	6265,	6103,	5921,	5805,	5722,	5607,
5483,	5621,	5872,	5752,	5222,	4817,	4849,	4875,
4614,	4362,	4313,	4304,	4161,	4030,	4388,	5149,
5811,	6317,	6876,	7330,	7238,	6586,	5951,	5679,
5342,	4775,	4623,	5192,	5997,	6516,	6820,	7110,
7184,	6767,	6128,	5522,	4972,	4507,	4191,	3980,
3841,	3650,	3068,	2146,	1439,	1182,	1078,	789,
535,	847,	1590,	2170,	2389,	2402,	2357,	2014,
1445,	837,	350,	51,	55,	462,	980,	1304,
1324,	1239,	1345,	1594,	1925,	2188,	2353,	2719,
3265,	3764,	4063,	4056,	3745,	3292,	3020,	2830,
2390,	1902,	1734,	1855,	1890,	1675,	1388,	1252,
1097,	688,	205,	-129,	-454,	-801,	-1017,	-1054,
-1157,	-1481,	-1683,	-1640,	-1693,	-1951,	-2102,	-1985,
-1777,	-1823,	-2035,	-2110,	-2176,	-2374,	-2521,	-2458,
-2511,	-2831,	-3047,	-2961,	-2720,	-2567,	-2539,	-2502,
-2485,	-2429,	-2249,	-2154,	-2332,	-2760,	-3165,	-3496,
-3874,	-4264,	-4491,	-4573,	-4585,	-4423,	-4047,	-3527,
-3014,	-2706,	-2542,	-2379,	-2436,	-2793,	-3124,	-3072,
-2743,	-2512,	-2366,	-2323,	-2380,	-2398,	-2328,	-2307,
-2557,	-2842,	-2937,	-3116,	-3381,	-3459,	-3452,	-3326,
-3026,	-2606,	-2329,	-2432,	-2759,	-3162,	-3481,	-3544,
-3501,	-3397,	-3289,	-3165,	-2906,	-2539,	-2356,	-2636,
-3139,	-3432,	-3427,	-3187,	-2723,	-2092,	-1453,	-894,
-469,	-296,	-402,	-639,	-877,	-892,	-710,	-419,
0,	270,	324,	294,	178,	-168,	-707,	-1155,
-1488,	-1904,	-2171,	-2105,	-1732,	-1509,	-1692,	-2089,
-2424,	-2611,	-2768,	-2952,	-3015,	-2807,	-2392,	-1868,
-1492,	-1399,	-1433,	-1398,	-1434,	-1831,	-2357,	-2423,
-2059,	-1674,	-1307,	-868,	-370,	-76,	50,	176,
25,	-525,	-1077,	-1216,	-1085,	-1055,	-1068,	-983,
-876,	-978,	-1299,	-1678,	-2081,	-2443,	-2664,	-2586,
-2210,	-1774,	-1501,	-1203,	-691,	-223,	-187,	-416,
-530,	-427,	-411,	-583,	-628,	-426,	-88,	179,
337,	446,	599,	804,	990,	1118,	1595,	2291,
2750,	2930,	3107,	3309,	3200,	2939,	3076,	3389,
3351,	3150,	3185,	3359,	3367,	3199,	2920,	2488,
2002,	1730,	1702,	1690,	1666,	1685,	1766,	1991,
2278,	2460,	2499,	2469,	2701,	3268,	3740,	3779,
3788,	4179,	4770,	5017,	4891,	4748,	4778,	4938,
4990,	4966,	5153,	5579,	6013,	6323,	6490,	6502,
6468,	6456,	6409,	6228,	6090,	6192,	6285,	6227,
6127,	6139,	6172,	6114,	6039,	6106,	6351,	6494,
6499,	6655,	6766,	6628,	6285,	5755,	5434,	5520,
5727,	5903,	6137,	6564,	6954,	6968,	6807,	6671,
6532,	6347,	6147,	6105,	6268,	6228,	5776,	5296,
5175,	5082,	4610,	3943,	3534,	3535,	3590,	3451,
3414,	3634,	3778,	3437,	2725,	2050,	1529,	925,
154,	-441,	-619,	-537,	-615,	-908,	-1081,	-1100,
-1093,	-1296,	-1650,	-1844,	-1987,	-2355,	-2883,	-3226,
-3341,	-3584,	-3878,	-4126,	-4461,	-4821,	-5034,	-5141,
-5397,	-5551,	-5232,	-4799,	-4762,	-4943,	-4901,	-4711,
-4842,	-5252,	-5479,	-5503,	-5664,	-6046,	-6325,	-6345,
-6428,	-6722,	-7102,	-7325,	-7345,	-7307,	-7133,	-6849,
-6606,	-6346,	-5857,	-5148,	-4666,	-4549,	-4612,	-4675,
-4699,	-4692,	-4628,	-4531,	-4421,	-4205,	-3931,	-3932,
-4209,	-4547,	-4770,	-4861,	-4813,	-4693,	-4512,	-4323,
-4166,	-4001,	-3721,	-3437,	-3236,	-3188,	-3259,	-3394,
-3556,	-3648,	-3645,	-3603,	-3617,	-3623,	-3595,	-3592,
-3667,	-3668,	-3611,	-3619,	-3639,	-3648,	-3705,	-3868,
-3948,	-3800,	-3678,	-3625,	-3475,	-3213,	-3010,	-2881,
-2735,	-2593,	-2633,	-2949,	-3360,	-3541,	-3624,	-3881,
-4167,	-4170,	-3911,	-3804,	-3996,	-4187,	-4215,	-4288,
-4683,	-5070,	-5163,	-5042,	-4925,	-4902,	-4866,	-4767,
-4763,	-5081,	-5721,	-6182,	-6279,	-6400,	-6605,	-6583,
-6232,	-5798,	-5470,	-5219,	-4957,	-4932,	-5121,	-5231,
-5080,	-4872,	-4902,	-5025,	-4836,	-4351,	-4080,	-4272,
-4599,	-4773,	-4947,	-5175,	-5325,	-5228,	-4906,	-4536,
-4262,	-4100,	-4028,	-4097,	-4415,	-4929,	-5245,	-5149,
-4917,	-4903,	-4985,	-4961,	-4748,	-4483,	-4261,	-4081,
-4197,	-4478,	-4635,	-4442,	-3869,	-3184,	-2579,	-2121,
-1706,	-1270,	-1023,	-1021,	-1016,	-911,	-717,	-394,
43,	312,	230,	98,	293,	672,	807,	780,
977,	1408,	1784,	2034,	2208,	2382,	2556,	2668,
2700,	2712,	2870,	3111,	3294,	3499,	3725,	3885,
4000,	4115,	4183,	4142,	3995,	4155,	4652,	5119,
5332,	5445,	5635,	5871,	6092,	6254,	6331,	6353,
6491,	6810,	7248,	7474,	7454,	7402,	7417,	7510,
7557,	7229,	6572,	6023,	5785,	5616,	5394,	5198,
5096,	5056,	5103,	5230,	5252,	5174,	5187,	5241,
4960,	4381,	3933,	3863,	3839,	3596,	3440,	3707,
4108,	4305,	4284,	4252,	4102,	3780,	3545,	3556,
3567,	3414,	3262,	3408,	3823,	4275,	4478,	4532,
4650,	4563,	4178,	3902,	3981,	4058,	3731,	3208,
3018,	3019,	2833,	2546,	2417,	2383,	2361,	2403,
2515,	2536,	2454,	2346,	2298,	2470,	2766,	2879,
2844,	2822,	3040,	3327,	3302,	3086,	2799,	2607,
2590,	2654,	2876,	3346,	3975,	4663,	5245,	5687,
6004,	6089,	5971,	5726,	5522,	5475,	5582,	5675,
5658,	5735,	5916,	5809,	5307,	4943,	4863,	4805,
4716,	4712,	4845,	4966,	4861,	4734,	4836,	4782,
4360,	4088,	4310,	4572,	4364,	4019,	3968,	4027,
3838,	3457,	3052,	2622,	2000,	1800,	1500,	1000,
800,	400,	200,	100,	90,	60,	20,	0
};

__eds__ __attribute__((space(prog))) int16_t SAMPLE_keyup[sample_length] = {
416,	-28,	-73,	144,	-345,	-1305,	-819,	-315,
-891,	-1033,	-1621,	-1351,	-1361,	-2242,	-1662,	-1351,
-1751,	-2411,	-2498,	-2783,	-3503,	-3675,	-4750,	-5714,
-5667,	-6575,	-7605,	-7624,	-7705,	-7954,	-7921,	-7578,
-7736,	-7505,	-7091,	-7434,	-7508,	-5452,	-2486,	-4892,
-13018,	-13462,	-7190,	-15013,	-20911,	-11825,	-4895,	-5081,
-6760,	-5369,	-587,	-2557,	-2567,	9514,	19763,	14210,
3987,	1984,	-4925,	-10491,	-5568,	2339,	-631,	-7635,
-4292,	3459,	10004,	15385,	19878,	21816,	19360,	16377,
10132,	5855,	-256,	-9905,	-19618,	-23553,	-15141,	-690,
9963,	13245,	15946,	20811,	26134,	25247,	19778,	13791,
7148,	172,	-8180,	-16978,	-15428,	-6476,	-1847,	-1226,
3652,	14691,	25924,	31916,	29711,	25015,	17410,	8625,
-231,	-3400,	-3661,	-6745,	-8110,	-8468,	-9213,	-4522,
9732,	25490,	32764,	28203,	15298,	2728,	-502,	1363,
373,	-7420,	-12372,	-10921,	-6043,	-503,	1451,	3644,
11986,	22746,	23929,	15180,	3263,	-780,	4439,	7161,
1550,	-6415,	-5756,	5653,	13165,	11061,	10409,	12756,
12114,	9385,	4709,	-4695,	-14665,	-16264,	-15139,	-12977,
-8939,	-7652,	-10332,	-10449,	-947,	11927,	18255,	14669,
8409,	1163,	-10018,	-19463,	-21828,	-19679,	-16245,	-16536,
-21397,	-22276,	-10090,	9733,	24008,	26698,	23823,	17927,
5812,	-8338,	-16706,	-17539,	-19174,	-23696,	-27227,	-24396,
-15776,	-10863,	-10563,	-7881,	2298,	11195,	10690,	3834,
-5284,	-12542,	-18070,	-22805,	-25662,	-23938,	-23354,	-26175,
-24961,	-13202,	2957,	12040,	12458,	10635,	9141,	2772,
-5657,	-10203,	-11554,	-11337,	-11095,	-13231,	-15846,	-12902,
-5296,	-159,	1122,	3786,	9016,	7778,	-1936,	-10263,
-11036,	-9142,	-8440,	-8524,	-8353,	-7806,	-6159,	-4520,
-3059,	1581,	8021,	11856,	9011,	3575,	301,	-3187,
-8323,	-11871,	-9829,	-3275,	1394,	1607,	618,	3660,
11523,	18229,	19833,	15446,	8494,	433,	-7609,	-11194,
-7836,	-1192,	2154,	1678,	388,	28,	1049,	3371,
7123,	10630,	11916,	9626,	4825,	28,	-4090,	-7278,
-8251,	-5857,	-2167,	-631,	-3144,	-5109,	-919,	8282,
15601,	16504,	13106,	7934,	2328,	-1552,	-3343,	-4379,
-5180,	-4020,	-731,	760,	-15,	188,	1635,	3274,
4563,	5339,	4064,	1418,	-241,	-1079,	-1820,	-2845,
-2107,	1002,	3304,	1735,	-3099,	-6690,	-4693,	1021,
6383,	7438,	3242,	-4263,	-10504,	-10550,	-5769,	-1450,
775,	2125,	3185,	3460,	2957,	3157,	4939,	6499,
5340,	1752,	-1035,	-1892,	-2199,	-2165,	-461,	3417,
5210,	2196,	-2999,	-6246,	-5150,	-89,	4884,	6182,
4310,	484,	-3184,	-3804,	-517,	3114,	3762,	2237,
648,	-160,	-127,	644,	2140,	3917,	5714,	5281,
962,	-3804,	-4937,	-2110,	2239,	6616,	8179,	5083,
-533,	-3415,	-2052,	444,	1035,	-835,	-3126,	-4524,
-3800,	-1554,	1380,	4607,	5525,	1466,	-4768,	-7115,
-4539,	-1532,	-707,	-1504,	-2872,	-4378,	-5195,	-4838,
-3860,	-3129,	-2684,	-1881,	-603,	818,	1853,	1449,
-746,	-3647,	-5324,	-5368,	-4837,	-3143,	-1006,	432,
-303,	-2007,	-2328,	-1060,	-518,	-1909,	-4893,	-7895,
-9616,	-9915,	-8185,	-4459,	-650,	706,	-273,	-1480,
-702,	1750,	4307,	4607,	2498,	-676,	-3759,	-6245,
-6773,	-4665,	-2485,	-1991,	-2316,	-1889,	-2086,	-3068,
-2543,	159,	2842,	4090,	3733,	1420,	-990,	-2024,
-2009,	-776,	1050,	1993,	418,	-2112,	-2940,	-1783,
1051,	4347,	6689,	5885,	2943,	1190,	2168,	4909,
6716,	6289,	4634,	3188,	2366,	2012,	3040,	5199,
6527,	5918,	3756,	1409,	717,	1909,	3991,	6128,
7290,	7450,	5655,	2670,	2081,	4592,	7093,	7217,
5686,	3903,	2540,	1852,	2210,	3058,	3917,	4967,
5827,	5770,	5928,	7634,	8612,	7823,	7118,	6990,
5440,	2755,	791,	-475,	-1463,	-1852,	-1881,	-1247,
214,	1221,	847,	-89,	-326,	556,	1783,	1778,
833,	-690,	-2424,	-3848,	-3989,	-2312,	-430,	-259,
-1520,	-2127,	-772,	414,	-98,	-950,	-1649,	-2038,
-2269,	-3744,	-5744,	-6371,	-5253,	-3934,	-3300,	-2441,
-1966,	-2613,	-4275,	-5054,	-4521,	-3660,	-4148,	-5354,
-5351,	-5545,	-6210,	-7710,	-8610,	-6286,	-1365,	662,
-2169,	-5882,	-7149,	-5985,	-3272,	-1422,	-1276,	-1552,
-2266,	-3474,	-3517,	-1606,	514,	1152,	-692,	-2754,
-3058,	-2397,	-1133,	631,	1435,	43,	-3142,	-4853,
-3644,	-1494,	-746,	-1392,	-2225,	-2195,	-1624,	-1619,
-1941,	-2350,	-1855,	332,	2080,	2025,	387,	-1005,
-774,	500,	1237,	960,	-57,	-1765,	-2240,	-889,
1205,	2469,	2971,	2986,	2038,	673,	103,	-3,
-542,	-1667,	-4034,	-5955,	-5441,	-3085,	-761,	301,
0,	-1018,	-1795,	-1923,	-947,	-704,	-1822,	-2986,
-3947,	-4736,	-5469,	-5741,	-5627,	-4765,	-3201,	-2483,
-2166,	-1395,	-657,	255,	1424,	959,	-1362,	-3287,
-3373,	-2827,	-3388,	-5010,	-6069,	-5529,	-4274,	-3548,
-3027,	-2067,	-1565,	-2813,	-4436,	-4491,	-2973,	-2481,
-4279,	-6472,	-6703,	-5470,	-4950,	-4422,	-3472,	-2255,
-1060,	-1094,	-1275,	-1436,	-1694,	-2095,	-2555,	-2198,
-1159,	-578,	-1532,	-2199,	-1320,	-142,	313,	-68,
-405,	-558,	-661,	-1406,	-2297,	-1736,	56,	1523,
1664,	732,	145,	241,	620,	1146,	1652,	1809,
1463,	660,	-143,	-188,	807,	2494,	3950,	4045,
2743,	1477,	1810,	3759,	4897,	3800,	1640,	240,
233,	1104,	2267,	3662,	4202,	4109,	3600,	2685,
1708,	1492,	1852,	1837,	1665,	947,	188,	-389,
-330,	202,	773,	1624,	2353,	1937,	992,	1003,
1881,	2627,	2812,	2226,	1362,	863,	932,	904,
461,	471,	936,	787,	-157,	-315,	687,	1682,
1519,	777,	745,	1148,	1351,	830,	175,	69,
188,	101,	-1,	245,	759,	662,	214,	16,
-159,	-359,	-372,	-475,	-946,	-1164,	-888,	-59,
661,	660,	243,	189,	1002,	1725,	1519,	461,
-446,	-788,	-862,	-675,	-531,	-847,	-1650,	-1995,
-1522,	-602,	299,	692,	471,	-98,	-662,	-1046,
-735,	-627,	-723,	-210,	82,	-700,	-1883,	-1591,
157,	1808,	1896,	1074,	692,	858,	1525,	2106,
2213,	1821,	1106,	330,	-143,	85,	373,	145,
-161,	-240,	-348,	-141,	859,	1437,	1032,	275,
-45,	417,	976,	1219,	1107,	845,	920,	1162,
933,	588,	288,	315,	588,	591,	25,	-685,
-907,	-501,	-159,	-444,	-847,	-890,	-416,	114,
576,	687,	403,	129,	301,	575,	229,	-918,
-2053,	-2325,	-1321,	173,	775,	215,	-316,	-243,
401,	1307,	1850,	1638,	744,	233,	140,	233,
757,	1224,	986,	105,	-335,	-67,	384,	993,
1219,	1392,	1765,	2197,	2296,	2010,	1406,	789,
374,	186,	-157,	-719,	-845,	-362,	507,	569,
421,	729,	1078,	1578,	2082,	2180,	1783,	1374,
1166,	843,	449,	299,	389,	644,	1451,	1693,
919,	201,	258,	833,	790,	587,	920,	1075,
-42,	-1278,	-1334,	-632,	459,	1019,	288,	-763,
-556,	957,	2272,	2352,	1521,	533,	-318,	-816,
-1092,	-1292,	-1061,	-676,	-444,	-876,	-918,	-187,
573,	748,	587,	604,	431,	-17,	-384,	-707,
-1202,	-1610,	-1448,	-748,	-544,	-1093,	-1001,	-33,
577,	-115,	-1509,	-2452,	-2485,	-2095,	-2325,	-2640,
-2313,	-1719,	-1555,	-1071,	296,	1843,	2679,	2228,
1046,	-659,	-1379,	-673,	-159,	-646,	-1664,	-2126,
-2022,	-1221,	216,	1506,	1953,	1951,	1593,	1510,
1703,	1699,	1086,	-226,	-1351,	-1851,	-1521,	-934,
-645,	-100,	386,	777,	1132,	1623,	2311,	2655,
2425,	1723,	1105,	732,	359,	186,	747,	1191,
933,	244,	-316,	-345,	418,	1519,	1926,	1576,
1480,	1723,	1721,	1493,	1622,	2196,	2283,	1521,
444,	-273,	-543,	-247,	347,	629,	289,	-173,
-502,	-604,	-343,	401,	1766,	2627,	2295,	1064,
-418,	-1276,	-934,	403,	1506,	1608,	703,	-588,
-1207,	-873,	111,	564,	197,	-327,	-791,	-1090,
-762,	260,	1204,	1164,	401,	-272,	-618,	-328,
68,	333,	-44,	-1034,	-1649,	-1666,	-1292,	-960,
-850,	-858,	-877,	-933,	-917,	-562,	102,	388,
-189,	-973,	-1581,	-1851,	-1548,	-1095,	-785,	-721,
-801,	-590,	-201,	115,	488,	1020,	1305,	1092,
687,	419,	427,	507,	397,	134,	-32,	-486,
-719,	-201,	805,	1592,	1537,	1363,	1348,	1265,
830,	491,	973,	1409,	1104,	287,	-473,	-217,
949,	2268,	2913,	2512,	1507,	731,	419,	686,
1265,	1693,	1895,	1607,	1019,	-259,	-1017,	-218,
1152,	1861,	1655,	801,	-172,	-644,	-174,	633,
1018,	1106,	687,	-227,	-964,	-830,	-146,	217,
113,	-285,	-274,	0,	245,	400,	347,	415,
502,	332,	83,	-298,	-835,	-1262,	-1478,	-1278,
-861,	-732,	-919,	-1133,	-934,	-300,	-59,	-544,
-1278,	-1723,	-2051,	-2256,	-2323,	-2211,	-1838,	-1204,
-476,	-156,	-159,	-57,	-29,	-129,	-459,	-818,
-1221,	-1406,	-962,	-373,	-329,	-634,	-759,	-560,
-87,	218,	11,	-313,	-261,	-327,	-592,	-714,
-261,	202,	14,	-215,	-144,	145,	644,	1121,
917,	203,	-303,	-328,	84,	747,	1005,	817,
734,	1032,	1493,	1881,	2137,	2341,	2483,	2353,
1939,	1477,	1264,	1191,	1235,	1061,	633,	530,
832,	1380,	1705,	2113,	2107,	1710,	1334,	1306,
1450,	1377,	1293,	1090,	818,	560,	172,	-85,
329,	1263,	2024,	1737,	948,	501,	690,	874,
892,	1161,	1350,	1133,	374,	-373,	-345,	445,
861,	159,	-604,	-1004,	-948,	-617,	-473,	-374,
-330,	-272,	-360,	-616,	-977,	-1091,	-932,	-1019,
-1077,	-918,	-1062,	-1394,	-1461,	-1251,	-846,	-516,
-518,	-975,	-1148,	-935,	-686,	-634,	-745,	-790,
-1191,	-1680,	-1751,	-1649,	-1596,	-1562,	-1236,	-1191,
-1520,	-1696,	-1821,	-1925,	-1950,	-1825,	-2094,	-2455,
-2426,	-1980,	-1250,	-717,	-717,	-1121,	-1433,	-1366,
-1089,	-849,	-817,	-904,	-933,	-659,	11,	520,
600,	447,	215,	387,	1005,	1435,	1363,	878,
269,	-126,	-261,	-185,	144,	515,	747,	976,
1335,	1508,	1534,	1551,	1708,	1780,	1679,	1608,
1392,	1076,	1178,	1506,	1608,	1867,	2309,	2772,
2825,	2630,	2150,	1853,	2095,	2339,	2527,	2095,
1651,	1420,	1738,	2253,	2654,	2931,	2925,	2872,
2441,	1892,	1783,	1805,	1869,	2037,	1794,	1177,
904,	904,	1365,	2166,	2441,	2166,	1824,	2009,
1937,	1782,	1790,	1986,	2177,	2142,	1835,	1494,
1305,	1422,	1951,	2153,	1809,	1478,	1278,	1046,
1122,	1864,	2627,	2642,	2165,	1423,	560,	457,
1108,	1763,	1667,	1003,	331,	-143,	-102,	504,
1075,	1149,	918,	690,	616,	776,	1032,	1436,
1450,	1291,	934,	344,	-217,	-513,	-406,	32,
458,	545,	546,	345,	415,	633,	1075,	1423,
1447,	1079,	529,	59,	-216,	-29,	475,	644,
447,	385,	692,	1189,	1322,	1419,	1739,	1907,
1896,	1736,	1134,	789,	1034,	1348,	1279,	1076,
961,	833,	961,	1436,	1837,	1837,	1694,	1679,
1651,	1434,	1250,	903,	546,	346,	614,	1051,
987,	721,	615,	806,	1088,	1208,	1118,	934,
876,	846,	675,	502,	387,	288,	287,	416,
718,	746,	402,	171,	218,	370,	535,	355,
-141,	-432,	-444,	-101,	331,	788,	992,	615,
-40,	-305,	-126,	271,	602,	375,	-188,	-416,
-486,	-492,	-211,	556,	1137,	1319,	1335,	1033,
618,	373,	244,	259,	472,	533,	199,	-415,
-618,	-200,	660,	1263,	1320,	1091,	632,	345,
458,	848,	1162,	1106,	917,	605,	299,	218,
213,	317,	530,	489,	316,	473,	833,	1004,
962,	1163,	1392,	1392,	1106,	816,	764,	1058,
1339,	1288,	1281,	1374,	1798,	2021,	1938,	1853,
1806,	1869,	1864,	2023,	2356,	2739,	3103,	3069,
2700,	2339,	2238,	2342,	2523,	2687,	2754,	2670,
2512,	2440,	2554,	2456,	2209,	2240,	2440,	2525,
2628,	2668,	2744,	2839,	2946,	2795,	2443,	2151,
2283,	2483,	2554,	2369,	2067,	1635,	1481,	1704,
2056,	2395,	2183,	2008,	1983,	2107,	2342,	2496,
2354,	1795,	1161,	979,	1100,	1370,	1386,	1340,
1618,	1883,	2022,	1982,	2209,	2642,	2626,	2168,
1736,	1407,	1062,	661,	200,	245,	616,	1437,
2136,	2343,	2394,	2414,	2294,	2240,	2225,	2038,
1492,	834,	256,	-155,	-218,	-42,	460,	989,
1608,	2656,	3343,	3044,	2324,	1766,	1478,	1264,
860,	330,	44,	-87,	274,	960,	1666,	2152,
2227,	2035,	2027,	2423,	2412,	2112,	1589,	908,
199,	-86,	173,	386,	389,	444,	747,	1292,
1965,	2428,	2580,	2502,	1933,	1024,	224,	92,
540,	823,	599,	304,	357,	447,	1002,	1568,
1633,	1309,	859,	518,	359,	501,	576,	529,
375,	344,	129,	0,	-1,	159,	344,	733,
1162,	1018,	389,	-246,	-686,	-735,	-385,	99,
258,	-42,	-331,	-502,	-229,	142,	575,	976,
1034,	601,	32,	-248,	-39,	269,	276,	327,
506,	543,	618,	516,	575,	888,	966,	640,
378,	484,	678,	658,	361,	298,	477,	472,
172,	89,	570,	1223,	1420,	1047,	576,	415,
660,	891,	874,	619,	472,	159,	-116,	188,
875,	1578,	1824,	1463,	1105,	906,	873,	1108,
974,	962,	747,	430,	474,	545,	848,	1190,
1393,	1520,	1825,	2022,	2054,	2108,	2240,	2354,
2440,	2239,	1635,	1150,	817,	832,	907,	1230,
1539,	1937,	2366,	2759,	2868,	2814,	2743,	2795,
2932,	2422,	1725,	1076,	687,	893,	1318,	1509,
1534,	1609,	1779,	1881,	2110,	2525,	2527,	1994,
1294,	514,	232,	429,	559,	218,	-17,	30,
431,	1060,	1884,	2235,	1855,	987,	131,	-57,
-130,	-158,	-258,	-905,	-1764,	-2126,	-1678,	-891,
16,	773,	647,	143,	-272,	-274,	-113,	69,
-26,	-475,	-1178,	-1719,	-1655,	-1345,	-1080,	-1103,
-1221,	-1306,	-1191,	-1135,	-1003,	-490,	-170,	40,
-284,	-850,	-1231,	-1423,	-1434,	-1221,	-1105,	-1105,
-1277,	-1407,	-1305,	-949,	-630,	-461,	-400,	-591,
-629,	-374,	-29,	101,	99,	-42,	-316,	-530,
-375,	-170,	-262,	-627,	-635,	-242,	143,	71,
-300,	-474,	-560,	-517,	-545,	-416,	-330,	-231,
-113,	-160,	-256,	-288,	-245,	-385,	-477,	-413,
-231,	-130,	74,	55,	-128,	-57,	-87,	15,
573,	848,	645,	375,	40,	-284,	-218,	175,
285,	44,	-274,	-702,	-761,	-331,	16,	356,
448,	170,	-114,	-200,	-103,	-97,	-333,	-457,
-275,	-185,	-475,	-444,	173,	343,	86,	-344,
-574,	-603,	-746,	-1034,	-1004,	-661,	-315,	-131,
104,	97,	-227,	-261,	-127,	-173,	-259,	-358,
-431,	-646,	-860,	-734,	-343,	-216,	-28,	229,
360,	256,	146,	300,	418,	385,	88,	-460,
-904,	-746,	-245,	115,	346,	572,	691,	831,
1063,	789,	129,	58,	329,	375,	185,	-28,
-143,	199,	835,	1003,	891,	961,	1005,	875,
891,	774,	661,	502,	345,	200,	145,	385,
534,	429,	216,	258,	516,	977,	1163,	1046,
677,	256,	-13,	72,	70,	46,	-17,	-300,
-589,	-531,	-157,	27,	88,	200,	86,	-243,
-202,	301,	347,	25,	-327,	-490,	-171,	430,
617,	1,	-562,	-686,	-576,	-473,	-359,	-431,
-1176,	-1566,	-1318,	-1065,	-917,	-918,	-1064,	-1533,
-1740,	-1634,	-1163,	-890,	-861,	-1192,	-2080,	-2543,
-2263,	-1757,	-1415,	-1383,	-1575,	-1969,	-1921,	-1495,
-1160,	-1193,	-1607,	-1837,	-1968,	-2308,	-2572,	-2481,
-2211,	-1809,	-1090,	-762,	-1018,	-1292,	-1392,	-1436,
-1320,	-1407,	-1822,	-2182,	-2283,	-2310,	-2225,	-2152,
-2039,	-1837,	-1493,	-1263,	-1118,	-893,	-785,	-881,
-1057,	-1067,	-1101,	-1424,	-1950,	-2283,	-1837,	-1063,
-745,	-820,	-945,	-1006,	-1062,	-1004,	-691,	-543,
-677,	-1160,	-2055,	-2539,	-2369,	-1722,	-1234,	-1092,
-1262,	-1694,	-1680,	-1247,	-706,	-341,	-276,	-471,
-978,	-1391,	-1536,	-1565,	-1536,	-1133,	-776,	-659,
-819,	-1148,	-1264,	-1104,	-518,	16,	70,	-357,
-978,	-1564,	-1793,	-1466,	-1002,	-591,	-430,	-473,
-316,	-274,	-356,	-190,	-55,	-159,	-215,	-445,
-1134,	-1636,	-1594,	-1333,	-1035,	-660,	-358,	-202,
-171,	-72,	85,	288,	416,	87,	-504,	-917,
-949,	-831,	-1077,	-1307,	-1477,	-1293,	-946,	-475,
-200,	-216,	-372,	-705,	-888,	-936,	-728,	-606,
-873,	-1351,	-1478,	-1177,	-874,	-677,	-428,	-305,
-268,	-736,	-944,	-994,	-643,	-304,	-584,	-981,
-1331,	-1380,	-1264,	-873,	-418,	-258,	-373,	-847,
-1321,	-1363,	-1049,	-744,	-850,	-1302,	-1870,	-1921,
-1608,	-1178,	-759,	-547,	-630,	-791,	-788,	-719,
-631,	-761,	-1090,	-1249,	-1191,	-949,	-859,	-963,
-1033,	-1090,	-1079,	-1160,	-1149,	-718,	-244,	-273,
-789,	-1076,	-790,	-602,	-576,	-701,	-963,	-961,
-803,	-892,	-917,	-919,	-746,	-732,	-934,	-1233,
-1307,	-904,	-617,	-561,	-801,	-950,	-889,	-789,
-777,	-843,	-1008,	-1090,	-1292,	-1449,	-1608,	-1607,
-1293,	-760,	-674,	-1006,	-1262,	-1249,	-833,	-285,
-118,	-730,	-1336,	-1304,	-777,	-530,	-747,	-847,
-904,	-961,	-805,	-788,	-662,	-271,	13,	159,
257,	446,	473,	58,	-488,	-689,	-575,	88,
183,	-182,	-692,	-846,	-559,	-217,	317,	646,
730,	735,	643,	691,	1032,	819,	415,	188,
-44,	0,	30,	-103,	-26,	329,	703,	963,
1332,	1755,	1733,	1209,	700,	563,	442,	318,
429,	187,	145,	241,	362,	744,	1134,	1236,
745,	115,	-229,	-289,	-112,	27,	-157,	-547,
-1002,	-1194,	-902,	-246,	432,	531,	-29,	-761,
-1062,	-803,	-403,	-574,	-1176,	-1580,	-1692,	-1924,
-1954,	-1762,	-1511,	-771,	-189,	-143,	-832,	-1365,
-1276,	-661,	-229,	-416,	-1063,	-1794,	-2081,	-2081,
-2037,	-1667,	-1304,	-951,	-670,	-836,	-1146,	-1163,
-590,	-41,	-304,	-1332,	-2284,	-2223,	-1653,	-1161,
-1005,	-1163,	-1319,	-1452,	-1218,	-705,	-300,	-345,
-775,	-1435,	-1738,	-1477,	-1322,	-1462,	-1380,	-688,
-42,	26,	-327,	-677,	-401,	87,	84,	-515,
-1450,	-2067,	-2081,	-1867,	-1549,	-1177,	-918,	-805,
-832,	-417,	73,	258,	431,	272,	-373,	-1163,
-1549,	-1595,	-1576,	-1539,	-1648,	-1522,	-1178,	-831,
-576,	-400,	-1,	331,	99,	-515,	-1078,	-1061,
-791,	-773,	-992,	-1392,	-1578,	-1408,	-960,	-216,
386,	318,	-173,	-877,	-1202,	-937,	-313,	-374,
-849,	-1302,	-1611,	-1404,	-935,	-401,	-230,	-243,
-403,	-517,	-443,	-447,	-558,	-761,	-1193,	-1850,
-2326,	-2282,	-2036,	-1654,	-1102,	-750,	-613,	-692,
-716,	-632,	-258,	273,	115,	-561,	-1162,	-1578,
-1537,	-1204,	-1221,	-1292,	-1161,	-1079,	-988,	-748,
-515,	-260,	-99,	-159,	-157,	-1,	58,	-460,
-1133,	-1507,	-1393,	-1076,	-847,	-604,	-314,	-274,
-200,	114,	474,	932,	848,	401,	-229,	-661,
-587,	-518,	-388,	-270,	-463,	-1001,	-1194,	-501,
315,	804,	934,	615,	189,	-45,	30,	158,
56,	-386,	-748,	-916,	-993,	-630,	-29,	14,
-287,	-458,	-290,	-26,	186,	373,	202,	256,
303,	416,	445,	359,	243,	74,	83,	190,
255,	188,	275,	383,	493,	140,	-172,	-113,
56,	244,	289,	528,	635,	556,	104,	-476,
-544,	-388,	-317,	-586,	-950,	-1160,	-992,	-574,
-300,	-146,	104,	513,	492,	-33,	-412,	-406,
-498,	-478,	-628,	-1007,	-1477,	-1809,	-1650,	-1422,
-1146,	-908,	-656,	-679,	-541,	-318,	-201,	-272,
-705,	-1147,	-1405,	-1424,	-1705,	-2257,	-2523,	-2370,
-1807,	-1337,	-1031,	-906,	-874,	-806,	-672,	-548,
-715,	-1107,	-1335,	-1607,	-1966,	-1781,	-1649,	-1652,
-1721,	-1623,	-1076,	-574,	-288,	-199,	-145,	-329,
-475,	-587,	-619,	-816,	-1178,	-1665,	-1952,	-1823,
-1564,	-1148,	-819,	-402,	-129,	-58,	-70,	-2,
73,	-144,	-546,	-861,	-774,	-547,	-787,	-1022,
-1102,	-707,	-168,	82,	449,	672,	632,	805,
758,	564,	311,	-225,	-894,	-1317,	-1036,	-802,
-388,	-144,	30,	471,	865,	1030,	763,	502,
157,	-14,	-28,	-131,	-256,	-374,	-604,	-974,
-907,	-400,	129,	588,	632,	430,	417,	301,
-14,	-216,	-344,	-287,	-401,	-690,	-703,	-589,
-258,	14,	288,	616,	777,	413,	90,	-133,
-327,	-446,	-489,	-458,	-446,	-214,	-58,	-101,
-86,	43,	159,	443,	706,	643,	446,	16,
-132,	-83,	68,	247,	113,	45,	-45,	-200,
-72,	474,	1090,	1164,	644,	203,	-130,	-44,
288,	502,	330,	188,	357,	618,	947,	1350,
1578,	1436,	1205,	934,	859,	835,	715,	490,
316,	557,	606,	499,	678,	902,	1293,	1564,
1320,	948,	976,	1262,	1237,	972,	837,	684,
521,	442,	490,	730,	1394,	1592,	1306,	1078,
1175,	1394,	1578,	1793,	1768,	1735,	1623,	1362,
1034,	847,	1035,	1231,	1337,	1392,	1262,	1151,
1144,	1296,	1518,	1654,	1590,	1264,	1006,	1059,
1082,	1243,	1596,	1707,	1292,	690,	127,	17,
486,	919,	1077,	888,	879,	902,	1220,	1437,
1274,	880,	728,	635,	744,	1092,	1161,	892,
500,	390,	399,	649,	557,	274,	273,	343,
490,	588,	558,	748,	731,	503,	330,	503,
787,	893,	471,	45,	172,	616,	762,	458,
30,	-144,	202,	471,	491,	615,	777,	875,
1032,	992,	932,	790,	918,	733,	386,	303,
257,	245,	129,	86,	215,	475,	688,	588,
375,	285,	533,	1017,	1394,	1434,	1063,	603,
415,	461,	902,	992,	703,	603,	761,	774,
790,	920,	858,	995,	1172,	1080,	1002,	1107,
1148,	1163,	1305,	1292,	1306,	1293,	1219,	1293,
1275,	1151,	930,	979,	1017,	1034,	933,	775,
1018,	1395,	1374,	1123,	687,	474,	833,	1119,
1120,	1105,	1076,	948,	731,	533,	529,	733,
948,	873,	750,	815,	1121,	1378,	1449,	1321,
1206,	1075,	948,	546,	186,	158,	159,	140,
263,	556,	634,	573,	373,	331,	487,	719,
586,	175,	13,	43,	73,	113,	259,	418,
687,	905,	747,	400,	319,	398,	549,	457,
216,	-43,	-129,	86,	259,	443,	734,	702,
848,	1091,	945,	678,	628,	648,	660,	473,
115,	30,	98,	218,	328,	374,	690,	1059,
1296,	1317,	978,	817,	918,	1122,	887,	606,
383,	320,	543,	762,	875,	790,	701,	764,
873,	1193,	1262,	1092,	788,	361,	69,	3,
141,	217,	258,	128,	-12,	-46,	74,	472,
734,	658,	404,	213,	318,	358,	230,	99,
260,	401,	360,	229,	316,	645,	848,	1061,
1049,	759,	677,	916,	834,	488,	401,	331,
243,	475,	716,	806,	902,	920,	832,	991,
989,	820,	658,	489,	517,	445,	272,	159,
471,	950,	1018,	947,	820,	743,	821,	904,
816,	951,	1029,	893,	488,	213,	419,	772,
1208,	1276,	1150,	758,	390,	429,	847,	1092,
1018,	631,	418,	414,	390,	558,	847,	1207,
1118,	1063,	889,	719,	903,	1279,	1433,	1523,
1507,	1248,	1063,	1004,	1105,	1135,	1118,	1207,
1219,	1063,	932,	977,	1076,	1320,	1652,	1620,
1667,	1577,	1624,	1719,	1554,	1260,	950,	873,
849,	773,	720,	687,	791,	932,	1006,	874,
962,	1278,	1334,	1078,	932,	818,	775,	747,
502,	345,	459,	674,	761,	977,	1219,	1235,
1321,	1361,	1194,	1017,	964,	888,	690,	473,
373,	188,	228,	590,	874,	1034,	876,	645,
791,	1146,	1265,	1175,	964,	601,	518,	271,
146,	213,	533,	874,	818,	791,	917,	978,
1031,	978,	831,	647,	632,	586,	477,	413,
333,	142,	-187,	-372,	-72,	445,	674,	446,
143,	-115,	-127,	68,	190,	156,	-27,	-188,
-142,	69,	117,	-187,	-388,	-401,	-318,	-98,
-17,	89,	255,	391,	284,	332,	459,	516,
260,	-116,	-344,	-417,	1,	272,	259,	-15,
-230,	-358,	-416,	-403,	-257,	-74,	-70,	-244,
-588,	-661,	-516,	-375,	-213,	-245,	-445,	-602,
-447,	-127,	142,	231,	27,	-271,	-418,	-243,
-13,	126,	75,	-189,	-329,	-372,	-434,	-413,
-246,	-100,	-329,	-404,	-372,	-373,	-217,	-170,
-188,	-373,	-343,	-433,	-544,	-733,	-789,	-745,
-648,	-701,	-678,	-571,	-346,	-57,	-29,	29,
-144,	-28,	42,	-42,	-160,	-312,	-506,	-788,
-746,	-676,	-658,	-576,	-372,	-274,	-128,	143,
143,	44,	-72,	-116,	-271,	-403,	-517,	-687,
-793,	-642,	-419,	-70,	243,	358,	434,	411,
566,	798,	894,	615,	359,	131,	-74,	73,
460,	888,	921,	586,	274,	272,	748,	1261,
1394,	1016,	564,	499,	620,	772,	936,	944,
779,	484,	348,	413,	433,	572,	576,	271,
73,	156,	332,	516,	790,	946,	934,	731,
561,	344,	187,	171,	231,	142,	-70,	-130,
-114,	143,	343,	391,	355,	176,	-103,	-459,
-458,	-59,	159,	-1,	-430,	-775,	-876,	-732,
-445,	-186,	-130,	-401,	-460,	-415,	-374,	-215,
-15,	59,	-45,	-155,	-147,	16,	173,	300,
130,	43,	99,	-184,	-404,	-228,	13,	130,
143,	86,	-100,	1,	313,	362,	313,	605,
831,	561,	415,	404,	285,	374,	545,	489,
587,	733,	746,	589,	631,	732,	861,	1321,
1536,	1506,	1322,	945,	764,	872,	1079,	974,
834,	616,	518,	802,	1193,	1348,	1393,	1507,
1679,	1536,	1407,	1478,	1593,	1580,	1462,	1194,
988,	1121,	1190,	1092,	1205,	1435,	1479,	1463,
1364,	1206,	1177,	1248,	1235,	1047,	747,	603,
602,	847,	1077,	1263,	1105,	933,	876,	932,
963,	946,	676,	588,	559,	432,	372,	230,
187,	544,	820,	832,	674,	459,	274,	429,
619,	502,	386,	73,	-215,	-461,	-557,	-319,
-155,	-45,	-28,	-72,	43,	202,	329,	244,
116,	99,	-156,	-231,	-144,	-199,	-404,	-472,
-201,	-73,	116,	85,	-28,	-172,	14,	459,
517,	517,	559,	331,	-43,	-72,	172,	388,
487,	289,	-59,	-185,	-32,	219,	328,	518,
400,	261,	355,	507,	642,	763,	731,	489,
286,	273,	158,	272,	533,	543,	663,	657,
490,	588,	846,	1136,	1102,	1008,	873,	704,
705,	613,	651,	585,	547,	516,	331,	271,
319,	354,	593,	729,	748,	645,	330,	230,
244,	401,	490,	628,	607,	341,	118,	-3,
2,	199,	332,	185,	-214,	-489,	-603,	-400,
-46,	276,	312,	104,	-117,	-242,	-232,	-41,
156,	-113,	-331,	-402,	-473,	-417,	-416,	-573,
-734,	-902,	-763,	-514,	-290,	-55,	-15,	-260,
-686,	-836,	-930,	-877,	-702,	-663,	-628,	-764,
-845,	-774,	-606,	-341,	-419,	-802,	-1062,	-1106,
-948,	-615,	-289,	-41,	-160,	-415,	-489,	-587,
-604,	-401,	-173,	-345,	-731,	-1063,	-1061,	-790,
-345,	0,	145,	70,	73,	172,	214,	490,
630,	590,	142,	-372,	-819,	-746,	-229,	114,
273,	144,	-130,	-185,	84,	518,	746,	846,
619,	84,	-199,	-45,	73,	229,	445,	388,
258,	186,	87,	-72,	14,	244,	402,	517,
559,	446,	357,	232,	127,	245,	258,	202,
-44,	-258,	-374,	-186,	202,	458,	460,	244,
200,	274,	487,	632,	632,	473,	259,	272,
388,	301,	203,	198,	276,	514,	733,	919,
946,	1006,	832,	675,	759,	878,	887,	734,
488,	515,	677,	773,	777,	830,	935,	1031,
1023,	944,	677,	485,	433,	501,	547,	472,
331,	388,	414,	391,	499,	706,	946,	1005,
717,	474,	388,	402,	646,	717,	660,	517,
431,	474,	515,	562,	658,	705,	574,	501,
461,	343,	316,	547,	801,	922,	872,	663,
428,	347,	601,	820,	974,	919,	776,	574,
574,	646,	888,	951,	829,	734,	630,	719,
588,	560,	560,	687,	864,	887,	892,	832,
746,	689,	674,	862,	1104,	1136,	916,	691,
558,	677,	786,	865,	943,	1052,	901,	763,
616,	617,	647,	457,	175,	-60,	60,	184,
275,	342,	289,	214,	303,	342,	491,	657,
678,	657,	562,	372,	332,	212,	176,	282,
336,	268,	76,	139,	319,	558,	776,	904,
933,	846,	733,	458,	274,	388,	530,	589,
544,	275,	157,	273,	401,	504,	587,	647,
545,	430,	546,	732,	818,	819,	658,	534,
485,	448,	399,	476,	486,	590,	760,	789,
704,	603,	545,	488,	517,	458,	490,	573,
503,	301,	144,	186,	446,	602,	488,	115,
-158,	-200,	-102,	174,	371,	231,	29,	-332,
-299,	-318,	-357,	-389,	-473,	-503,	-501,	-446,
-358,	-274,	-272,	-287,	-373,	-473,	-590,	-760,
-918,	-977,	-1075,	-1035,	-947,	-904,	-861,	-947,
-992,	-874,	-647,	-501,	-533,	-686,	-779,	-828,
-879,	-1018,	-1176,	-1308,	-1318,	-1165,	-974,	-548,
-529,	-762,	-946,	-992,	-787,	-721,	-743,	-793,
-944,	-1064,	-1061,	-1006,	-903,	-862,	-789,	-804,
-861,	-761,	-573,	-417,	-360,	-485,	-563,	-543
};

static const uint16_t EqBandLookupOver271Hz[eq_band_lookup_table_length]={0,3,4,6,6,7,8,9,9,9,10,10,11,11,11,12,12,12,12,12,13,13,13,13,13,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,30};
static const uint16_t EqBandLookup271HzAndLess[256]= {0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12};
static const uint16_t KSBufferLengthLookup[73]={637,601,567,535,505,477,450,425,401,378,357,337,318,300,283,267,252,238,225,212,200,189,178,168,159,150,141,133,126,119,112,106,100,94,89,84,79,75,70,66,63,59,56,53,50,47,44,42,39,37,35,33,31,29,28,26,25,23,22,21,19,18,17,16,15,14,14,13,12,11,11,10,9};
static const uint16_t KSNoiseUnfiltered[KS_buffer_size] ={17814,56073,30295,35722,18508,37965,42648,61038,906,10375,15549,2149,4792,28988,3085,52081,5488,55122,22690,62021,27771,50230,8738,40031,25611,56561,63386,61394,12822,41999,3918,64118,15626,49179,36496,30516,31505,8292,64123,5072,10974,23971,4023,59380,3986,60938,11159,63912,55858,12623,1830,10362,13543,51200,40727,27443,56476,29325,20638,49736,15473,2645,39046,39470,5619,13782,26275,46800,8524,8586,53170,55896,37116,1133,7052,12219,23050,31623,42788,18294,25060,60062,19451,59000,49478,26304,15003,12945,30955,47514,32325,26599,55499,56582,32467,57695,37620,12999,25935,6035,38914,49730,58085,52712,60783,32166,52889,30936,36450,3688,15253,36580,34370,32853,61729,13425,33324,53610,35050,38678,26684,21895,28969,52131,9092,52285,37152,40736,26043,63906,7810,39790,33752,36591,50113,30233,3984,7885,47225,29674,36257,5599,13025,2094,43881,21192,44102,9212,33393,62731,47336,26837,37385,36642,10588,10756,19608,36600,23045,22566,32038,35770,57611,36645,7639,30596,14085,52887,21213,61959,936,49400,37218,21753,8042,3885,22537,9819,24374,55861,39015,39584,61592,62195,4089,49673,32091,8633,14382,12562,56283,13393,5550,63125,19911,44571,26357,33328,24125,36939,12903,22404,62865,62892,53669,17829,61984,49663,64718,47897,11540,37176,15334,65448,13130,44608,37093,33190,53216,6249,47581,17473,47636,13133,10153,22628,11240,10329,7627,58314,9377,16410,37129,50393,10599,27933,19977,42398,8297,11542,56810,41286,51500,29985,12347,33001,15268,10881,29859,60290,11384,232,49508,65035,56258,59854,47131,34644,6907,15054,8974,43371,56038,47315,56278,18282,56897,47285,1859,62919,54786,6354,65114,46930,23965,62435,12362,56406,24653,38493,24365,52219,62710,58012,17229,28871,26265,56320,54566,13609,29785,21205,9587,42051,9628,10479,63835,31927,28493,21213,37076,44920,28893,55293,7745,52862,6881,24449,35781,19859,54184,45053,65016,56266,14902,47913,11574,806,10045,13995,11962,44500,59195,20193,1953,41969,33553,55872,29433,60495,21815,7335,48912,15096,46704,34785,35546,33555,41465,3951,6800,62116,33585,51823,33164,18211,30716,39242,65073,11020,9059,30622,18695,20707,33142,41803,53445,62285,17787,6606,28340,15768,45386,17156,56625,22335,22533,3384,12405,35478,10761,50932,39490,45995,39706,2459,12172,49912,13253,45488,26028,64649,55684,41095,56689,24038,54029,64059,35374,13843,6296,60794,29621,50942,48572,65470,49755,59202,38618,20123,51494,34025,16810,44565,25517,54317,29597,2818,56604,43139,54151,49737,4583,795,50705,37513,1542,27118,36457,48675,43401,4707,26768,24950,28003,41228,23445,19122,21236,13466,35963,57743,56078,44424,15575,50317,40053,53862,4225,12257,32598,42146,7807,51971,65370,60928,18266,33309,20760,42415,14422,20328,37348,8622,33528,40812,11922,63293,13822,3212,10252,2639,39478,14119,7596,63707,10649,2331,57433,39257,21410,52087,44108,61338,35543,23778,45446,49536,14239,38953,17178,31553,56011,49265,5518,49695,50765,58914,128,13675,48362,25815,63052,47112,35915,5088,32054,12884,33820,52344,20955,56396,5359,58842,33593,43604,44768,12754,51768,21149,18695,19996,24823,23418,57324,12367,26414,6796,10671,25360,10757,28133,30989,44881,38855,19238,51090,20257,21925,51728,45259,30067,19954,41368,12865,46249,40691,32360,4513,5038,34019,18734,57126,30994,13695,40025,47854,38903,9944,2628,2410,1644,18836,17644,14865,58319,42466,64213,57169,61266,16637,37377,32928,56346,20456,33285,62095,4631,45355,6405,59350,43764,250,9426,39636,50677,33483,1918,20578,11923,45317,25018,11636,29492,56036,24335,12660,1890,41977,25911,14248,6,35450,2710,11430,55126,31888,63348,33184,11112,65012,20354,45987,11330,55088,13016,26170,36296,34659,61279,9916,56760,53896,48289,33800,44636,52144,52863,48637,10884,21958,60706,16449,28888,14824,12001,13115,54089,8993,19843,32467,55944,29081,30652,12202,53842,62655,2853,28710,15428,30787,24520,10390,51406,46708,36427,2293,62422,19248,57058,29668,43875,43785,44828,47876,28495,46011,36750,36444,32781,32484,52842,37468,38916,48765,33486,36269,25582,59997,55363,2877,23569,27836,223,2195,11012,30244,716,29835,54754,54884,6814};
static const uint16_t KSNoiseVeryFiltered[KS_buffer_size] = {26057,27226,26560,28617,33670,40479,37326,16241,18070,35194,32075,30776,32924,19508,7515,11356,30194,42376,28914,22225,43053,59763,49263,24464,12060,12114,10813,11664,27150,45562,42949,26677,22384,37015,42023,34928,41591,42973,29101,24703,32539,46032,56965,59652,60903,52325,33127,26102,33440,30740,27379,36768,27387,13053,15885,18163,16882,23491,39449,47008,40872,38062,46382,50046,51074,45774,31404,24264,28395,45596,47223,39125,40342,37213,45776,45627,35704,44120,51211,42491,23961,26526,36008,23764,20121,32098,34078,25065,25765,38424,46947,45640,36199,23681,22365,34138,50910,50092,36276,34506,36010,31146,27569,28061,23073,24923,38724,40224,21048,19385,38571,34421,28551,39854,36389,28687,37770,39557,32930,31365,22700,16400,21987,37919,56778,50490,24085,13565,16154,14393,20413,27696,28887,41065,52524,40362,21002,24842,40809,39553,36144,40159,31717,21091,17518,26711,40998,34200,26769,39136,43590,37957,34441,28774,30181,38487,40757,39827,35038,18484,14362,22170,28024,28742,15727,13469,33322,45269,32665,28127,42157,38098,29771,36313,31595,25093,37393,50949,42296,30439,42369,50464,41832,39700,47789,56902,56368,38149,17101,22227,39120,45753,54338,53586,32590,13231,13222,25441,30705,33892,47088,44443,31945,45406,53654,33179,15260,22096,29655,19326,16481,31833,43445,40296,36872,28359,26148,43824,51342,40901,28626,29521,30902,18983,20944,26623,26645,38635,46859,49706,54142,51027,38448,24191,19514,24218,24195,28256,39290,32660,27582,45830,56754,40078,21760,16901,9017,3624,15904,25631,19883,16268,12581,13809,33591,47451,45593,49902,52938,38324,20364,22639,41585,49080,34474,14781,8185,23177,45864,53999,49944,49711,52538,44382,36674,37459,33084,31941,33327,23588,14730,20374,28397,32874,44396,43063,35527,31499,14540,6978,10064,8574,21161,36339,37488,40837,35275,31588,34278,30580,29428,29459,32732,22202,20994,47468,61805,48429,29906,30772,33190,24012,12592,5694,14711,33611,47729,52404,51955,49670,41630,40073,35117,21603,21276,31237,32887,31577,37177,39241,41649,38353,37122,36391,29502,26869,18014,22947,38218,30998,28332,35435,35703,35949,21776,12823,19368,19923,29683,37887,27468,25009,38984,45894,29013,10637,10010,11016,9048,16619,32543,34783,26609,26430,23332,23332,30160,33047,28247,13720,18804,42570,46036,38825,41433,41850,40906,50336,58973,58111,55923,48564,28934,12839,11750,17718,29446,36111,24467,15380,21789,32479,33410,20485,24650,42807,42645,37239,28586,20637,27652,38065,42120,38163,37889,32094,15484,18157,40105,47978,39597,33140,26042,25346,28485,18277,6765,4693,17823,45899,53883,30520,20263,33061,31552,27838,44433,44590,25856,20209,17456,23567,32616,29326,32925,34691,23471,23362,32781,29353,26190,36106,37711,21730,22620,41950,54320,53791,43930,37638,31559,24013,28644,31338,26142,36192,47968,36885,23852,35803,38100,22250,22693,24434,23729,36100,46332,49047,56272,61912,58157,42173,26799,34934,40280,29098,36699,40057,30157,36295,34563,26333,24174,28055,38361,37094,33180,32580,32350,36283,31340,30419,37392,35749,38513,32604,25010,41386,54076,43896,28720,31404,33903,29424,42078,56493,56012,51085,52276,44919,22375,11091,12318,24173,35436,22616,22280,37354,36213,39187,44077,38862,34225,27921,27068,30938,22321,13317,25673,37477,25686,16058,28110,42344,30678,12575,12661,27740,40754,28610,20310,31568,39265,33622,30518,40813,44102,39524,30456,30906,43519,40924,28380,28928,34773,22780,17142,35771,43403,37822,30896,14033,7823,24967,39391,39721,44850,48273,37106,29199,24375,24703,42954,51500,35154,28078,34216,37092,35462,29666,33532,34130,26028,23334,24401,25034,23669,26898,28525,34610,43385,30023,17224,24284,36890,36996,23557,18895,21511,35049,44912,30182,18393,17415,19965,32170,43624,35663,15441,20023,35351,25137,21114,39973,49657,35428,30840,46839,39226,12912,15788,28676,16272,17083,41092,54707,50929,37053,30559,38068,50434,55333,49577,41552,42477,51613,51180,48097,42959,21887,15111,35969,56490,56975,42364,33697,27777,26559,28946,27523,32505,28322,24630,29199,30951,42037,40293,27390,32230,32802,25550,34427,38921,22691,18509,36415,42469,24774,12110,22220,43380,46129,36562,34567,29682,33304,44373,51560,47792,33623,37086,51561};

static volatile uint16_t flag_pending_wt_swap;
static volatile uint16_t pending_wt_swap_instance_id;
static volatile uint16_t num_held_on_by_sustain;

//==============================================================================

volatile channel_info channel;
volatile instance_t instance[max_instances]; 
static volatile int16_t wave_table[max_instances + 1][wavetable_samples]; 
//static volatile int16_t __attribute__ ((address(0x3000))) wave_table[max_instances + 1][wavetable_samples];
volatile system_t system;
static volatile fifo_KSBuffer KSB[max_instances];

/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/

int16_t interpolated_sine_lookup(uint16_t st_index_q11_5)
{
    int16_t s0 = SineLookup[st_index_q11_5>>5];
    int16_t s1 = SineLookup[(st_index_q11_5 + 32)>>5]; //NOTE: This subtly wraps round in the WT as necessary
    return (int16_t)
            (
                s0 + 
                (
                (int16_t)(__builtin_mulsu(
                                            s1-s0,
                                            (uint16_t)(st_index_q11_5 & 0x001F)
                                         )>>5
                          )
                )
            );   
}

int16_t interpolated_wt_lookup(uint16_t i,uint16_t y)
{
    int16_t s0 = wave_table[instance[i].wavetable_index][instance[i].layer[y].wt_index_q11_5 >> 5];
    int16_t s1 = wave_table[instance[i].wavetable_index][(instance[i].layer[y].wt_index_q11_5 + 32) >> 5]; //NOTE: This subtly wraps round in the WT as necessary
    return (int16_t)
            (
                s0 + 
                (
                (int16_t)(__builtin_mulsu(
                                            s1-s0,
                                            (uint16_t)(instance[i].layer[y].wt_index_q11_5 & 0x001F)
                                         )>>5
                          )
                )
            );    
}

uint16_t BoundedUSWFromSL(int32_t L)
{
    uint16_t result;
    
    if(L < 0)
        {result = 0;}
    else if (L > 65535)
        {result = 65535;}    
    else
        {result = (uint16_t)((uint32_t)L);} 

    return result;
}

int16_t SquareLookup(uint16_t wt_index)
{
    //Square wave with sloped edges to prevent harsh transients
    if (wt_index < 128)
    {
        return (int16_t)(wt_index<<8); //linear ramp up. 127 * 256 = 32512
    }
    else if (wt_index <= 897){return (int16_t)32760;}
    else if (wt_index < 1151)
    {
        return (int16_t)(32760 -((wt_index - 897)<<8)); //linear ramp down
    }
    else if (wt_index <= 1920){return (int16_t)(0 - 32760);}  
    else
    {
        return (int16_t)(((wt_index - 1920)<<8) - 32760);
    }
}

int16_t SawLookup(uint16_t wt_index)
{
    if (wt_index < 897)
    {
        return (int16_t)(wt_index << 5); 
    }
    else if (wt_index < 1125)
    {
        return (int16_t)28672 - (int16_t)(((int16_t)wt_index - (int16_t)896)<<8);
    }
    else
    {
        return((int16_t)(((int16_t)wt_index - (int16_t)1024) << 5) - (int16_t)32767); 
    } 
}

int16_t TriangleLookup(uint16_t wt_index)
{
    if (wt_index < 1024)
    {
        return (int16_t)(((int32_t)-32767) + ((int32_t)(wt_index << 6))); 
    }
    else
    {
        return (int16_t)(((int32_t)32767) - ((int32_t)(((int16_t)wt_index - (int16_t)1024) << 6))); 
    } 
}

void ProcessControlChange(msg_instance_cc cc)
{
    uint16_t i;
    switch (cc.midi_control)
    {
        case cc_sustain_pedal:
            if (cc.control_value <= 63) //Off
                {
                    channel.flag_sustain_on = 0;
                    for(i=0;i<max_instances;i++)
                        {
                        if (instance[i].flag_held_on_by_sustain == 1)
                            {
                             num_held_on_by_sustain --;
                             instance[i].adsr_section_id = adsr_release;
                             instance[i].adsr_section_elapsed_time_ms = 0;
                             UpdateAmplitudeDepthValue(i);
                             CheckForInharmonicSamplePlayback(i,instance[i].adsr_section_id);
                            }
                        instance[i].flag_held_on_by_sustain = 0;               
                        }
                }
            else
                {channel.flag_sustain_on = 1;}
            break;
    }
}

void CheckForInharmonicSamplePlayback(uint16_t i,uint16_t section_id)
{
    if ((instance[i].midi_note_id >= ks_lowest_midi_note_number) && (channel.patch.adsr_section[adsr_attack].inharmonic_sample_id >= inharmonic_sample_KS_very_long_not_filtered))
        {instance[i].flag_inharmonic_sample_active =1;}
    else if (channel.patch.adsr_section[instance[i].adsr_section_id].inharmonic_sample_id == inharmonic_sample_none)
        {instance[i].flag_inharmonic_sample_active =0;} 
    else
        {
        instance[i].flag_inharmonic_sample_active =1;
        instance[i].inharmonic_elapsed_samples = 0;
        switch(channel.patch.adsr_section[instance[i].adsr_section_id].inharmonic_sample_id)
           {
               case inharmonic_sample_hammer1:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_key_hammer1[0];
                   break;
               case inharmonic_sample_hammer2:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_key_hammer2[0];
                   break;
               case inharmonic_sample_hammer3:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_key_hammer3[0];
                   break;
               case inharmonic_sample_hammer4:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_key_hammer4[0];
                   break;
               case inharmonic_sample_bowscrape1:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_bowscrape1[0];
                   break;
               case inharmonic_sample_bowscrape2:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_bowscrape2[0];
                   break;
               case inharmonic_sample_keyclick:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_keyclick[0];
                   break;
               case inharmonic_sample_keyup:
                   instance[i].inharmonic_sample_ptr = &SAMPLE_keyup[0];
                   break;
           }
        instance[i].inharmonic_sample_ptr_start = instance[i].inharmonic_sample_ptr;
        }
}

void ProcessInstanceNoteOff(uint16_t i)
{
    if ((instance[i].adsr_section_id == adsr_sustain) && (channel.flag_sustain_on ==1) && (num_held_on_by_sustain != max_to_hold_on_by_sustain))
        {
        instance[i].flag_held_on_by_sustain = 1; 
        num_held_on_by_sustain++;
        }
    else
        {
        instance[i].adsr_section_id = adsr_release;
        instance[i].adsr_section_elapsed_time_ms = 0; 
        UpdateAmplitudeDepthValue(i);
        CheckForInharmonicSamplePlayback(i,instance[i].adsr_section_id);
        }
}

void Sounds_Initialize(void)
{
    //=============== Initialise system =========================    
    flag_pending_wt_swap = 0;
    num_held_on_by_sustain = 0;
    
    channel.volume = 65535;
    system.current_rough_wavetable_id = 0;
    system.sample_delta16 = 0;
    system.last_sample = 0;
    system.current_sample = 0;
    system.event_32Sample_trigger_count = 0;
    system.rnd_num = 123;

    //=============== Initialise instances =========================
    uint16_t instance_id;
    uint16_t envelope_id;
    uint16_t lyr;
    uint16_t adsr_section_id; 
    
    for (instance_id = 0; instance_id < max_instances;instance_id++)
    {
        for (adsr_section_id = 0;adsr_section_id < max_adsr_sections;adsr_section_id++)
        {
        instance[instance_id].KS_end_time [adsr_section_id] = 0;
        }
        
        instance[instance_id].adsr_section_elapsed_time_ms = 0;
        instance[instance_id].adsr_section_id = 0;
        instance[instance_id].cutoff_gain = 0;
        instance[instance_id].flag_active = 0;
        instance[instance_id].flag_held_on_by_sustain = 0;
        instance[instance_id].flag_inharmonic_sample_active = 0;
        instance[instance_id].flag_timbre_recalc_pending = 0;
        instance[instance_id].last_timbre_depth_env_value_scaled_by_CC = 12345;
        instance[instance_id].fund_freq_hz = 0;
        instance[instance_id].fund_wt_inc_q11_5 = 0;
        instance[instance_id].intensity_layer_id_low = 0;
        instance[instance_id].intensity_layer_intensity_b = 0;
        instance[instance_id].key_scale_split_diff = 0;
        instance[instance_id].last_timbre_controller1_value = 0;
        instance[instance_id].last_timbre_controller2_value = 0;
        instance[instance_id].lfo_timbre_offset_gain = 0;
        instance[instance_id].midi_note_id = 0;
        instance[instance_id].noise_lpf_output = 0;
        instance[instance_id].note_sector_id_low = 0;
        instance[instance_id].note_sector_note_b = 0;
        instance[instance_id].overall_gain = 0;
        instance[instance_id].trem_offset_gain = 0;
        instance[instance_id].velocity16 = 0;        
        instance[instance_id].wavetable_index = instance_id + 1;
        
        for (envelope_id = 0; envelope_id <max_non_lfo_envelopes;envelope_id++)
            {
            for (adsr_section_id = 0;adsr_section_id < max_adsr_sections;adsr_section_id++)
                {
                instance[instance_id].env_current[envelope_id].KS_depth_delta[adsr_section_id] = 0;
                instance[instance_id].env_current[envelope_id].KS_depth_env_target[adsr_section_id] = 0;
                }
            instance[instance_id].env_current[envelope_id].depth_env_value = 0;
            instance[instance_id].env_current[envelope_id].depth_env_value_scaled_by_CC = 0;
            }
        for (lyr = 0;lyr < max_layers; lyr ++)
        {
        instance[instance_id].layer[lyr].wt_inc_q11_5 = 0;
        instance[instance_id].layer[lyr].wt_index_q11_5 = 0;
        }
        
        for (envelope_id = 0; envelope_id <max_lfos;envelope_id++)
            {
            for (adsr_section_id = 0;adsr_section_id < max_adsr_sections;adsr_section_id++)
                {
                instance[instance_id].lfo_env_current[envelope_id].KS_depth_delta[adsr_section_id] = 0;
                instance[instance_id].lfo_env_current[envelope_id].KS_depth_env_target[adsr_section_id] = 0;          
                }
            instance[instance_id].lfo_env_current[envelope_id].flag_update_pending = 0;
            instance[instance_id].lfo_env_current[envelope_id].depth_env_value = 0;
            instance[instance_id].lfo_env_current[envelope_id].gain = 0;
            instance[instance_id].lfo_env_current[envelope_id].current_wt_inc_q11_5 = 0;
            }
        
        instance[instance_id].portamento_env_config.depth_env_exp_multiplier = 0;
        instance[instance_id].portamento_env_config.depth_delta_KL = 0;
        instance[instance_id].portamento_env_config.depth_delta_KU = 0;
        instance[instance_id].portamento_env_config.depth_env_lin_delta = 0;
        instance[instance_id].portamento_env_config.depth_env_target = 0;
        instance[instance_id].portamento_env_config.depth_env_target_KL = 0;
        instance[instance_id].portamento_env_config.depth_env_target_KU = 0;
        instance[instance_id].portamento_env_config.depth_env_type = 0;
    }

    //============== Initialise Waveform Set =======================
    uint16_t t;
    uint16_t h;
    uint16_t l;
    uint16_t n;
    channel.patch.waveform_set.timbre_controller1_source = 0;
    channel.patch.waveform_set.timbre_controller2_source = 0;
    channel.patch.waveform_set.timbre_mode = timbre_envelope;
    for(n = 0;n < max_note_sectors;n++)
        {
        for(l = 0;l < max_intensity_layers;l++)
            {
            for (t = 0;t < max_waveforms; t++)
                {
                for (h = 0;h < max_harmonics; h++)
                    {
                    channel.patch.waveform_set.waveform_harmonic[n][l][t][h].level = 0; 
                    } 
                }
            }
        }
    
    //============== Initialise Patch =======================
    channel.patch.active_layers = 1;
    channel.patch.detuning_mode_id = 0;
    channel.patch.degree_of_regular_detuning = 0;
    channel.patch.degree_of_random_detuning = 0;
    channel.patch.degree_of_random_phase = 0;
    channel.patch.key_scale_split_note_id = midi_note_number_c3;
    channel.patch.pitch_bend_enabled = 0;
    channel.patch.portamento_enabled = 0;
    channel.patch.portamento_rate = 0;
    channel.patch.sustain_enabled = 1;
    
    uint16_t brb;
    for(brb = 0;brb < max_body_resonance_filter_bands;brb++)
    {
        channel.patch.body_resonance_bands[brb].level = 65535;
    }

    for(lyr = 0;lyr < max_layers;lyr++)
    {
       channel.patch.layer_config[lyr].st_inc_q11_5_detune = 0;
    }
    
    uint16_t lfo_id;
    for(lfo_id = 0;lfo_id<max_lfos;lfo_id++)
        {
        channel.patch.lfo_envelope_config[lfo_id].default_wt_inc_q11_5 = 0;
        channel.patch.lfo_envelope_config[lfo_id].depth_cc_source = 0;
        channel.patch.lfo_envelope_config[lfo_id].enabled = 0;
        channel.patch.lfo_envelope_config[lfo_id].freq_cc_source = 0;
        channel.patch.lfo_envelope_config[lfo_id].lfo_wave_type_id = sine;
        }
   
    for (envelope_id = 0;envelope_id < max_envelopes;envelope_id++)
        {
        channel.patch.env_gain_CC[envelope_id]=0;
        channel.patch.env_initial_depth_value[envelope_id]=0;
        }
    
    for (adsr_section_id = 0;adsr_section_id < max_adsr_sections;adsr_section_id++)
        {
         channel.patch.adsr_section[adsr_section_id].end_time_ms = 100;
         channel.patch.adsr_section[adsr_section_id].flag_active = 0;
         channel.patch.adsr_section[adsr_section_id].inharmonic_sample_playback_mode_id = sample_playback_mode_one_shot;
         channel.patch.adsr_section[adsr_section_id].inharmonic_sample_id = inharmonic_sample_hammer1;
         channel.patch.adsr_section[adsr_section_id].end_time_ms_KL = 0;
         channel.patch.adsr_section[adsr_section_id].end_time_ms_KU = 0;
         for (envelope_id = 0;envelope_id < max_envelopes;envelope_id++)
            {
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_env_exp_multiplier = 1;
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_delta_KL = 0;
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_delta_KU = 0;
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_env_lin_delta = 0;
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_env_target = 1;
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_env_target_KL = 0;
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_env_target_KU = 0;
            channel.patch.adsr_section[adsr_section_id].adsr_section_envelope_config[envelope_id].depth_env_type = env_type_exponential;
            }
        }
    
    //============== Initialise Channel =======================
    channel.flag_sustain_on = 0;
    channel.midi_channel = 0;
    channel.sample_sum = 0;
    
    uint16_t c;
    for (c = 0;c < max_controllers;c++)
    {
        channel.ucc_current_values[c] = 0;
    }
    channel.ucc_current_values[ucc_pitch_bend]=32768;
}

void StepEnvelopeNotKeyScaled(volatile adsr_section_envelope_config_row_t *s,volatile envelope_current_t *c)
{
uint16_t env_delta;    

if (c->depth_env_value < s->depth_env_target)
    {
     switch(s->depth_env_type)
        {
            case env_type_linear:
                env_delta = s->depth_env_lin_delta;
                break;
            case env_type_exponential:
                env_delta = (uint16_t)(__builtin_muluu((s->depth_env_target - c->depth_env_value),s->depth_env_exp_multiplier)>>16);
                break;
            default:
                env_delta = 0;
        }
     if (c->depth_env_value > (s->depth_env_target - env_delta ))
        {c->depth_env_value = s->depth_env_target;}
     else
        {c->depth_env_value += env_delta;}
    }
else if (c->depth_env_value > s->depth_env_target)
    {
    switch(s->depth_env_type)
        {
            case env_type_linear:
                env_delta = s->depth_env_lin_delta;
                break;
            case env_type_exponential:
                env_delta = (uint16_t)(__builtin_muluu((c->depth_env_value - s->depth_env_target),s->depth_env_exp_multiplier)>>16);
                break;
            default:
                env_delta = 0;
        }                    
//OLD:    if (c->depth_env_value < env_delta)
//        {c->depth_env_value = 0;}
     if (c->depth_env_value < (s->depth_env_target + env_delta))
        {c->depth_env_value = s->depth_env_target;}
     else
        {c->depth_env_value -= env_delta;}
    }  
}

void UpdateAmplitudeDepthValue(uint16_t i)
{
    if(instance[i].flag_amplitude_interp_mult32 == 1)
        {
            if (instance[i].amplitude_intermediate_sum >0)
                {
                instance[i].env_current[env_amplitude].depth_env_value += (uint16_t)((int16_t)(instance[i].amplitude_intermediate_sum>>5));
                }
            else
                {
                instance[i].env_current[env_amplitude].depth_env_value -= (uint16_t)((int16_t)(0-(int16_t)(instance[i].amplitude_intermediate_sum>>5)));
                }
        }
    else
        {
            if (instance[i].amplitude_intermediate_sum > 0)
                {
                instance[i].env_current[env_amplitude].depth_env_value += (uint16_t)((int16_t)(instance[i].amplitude_intermediate_sum));
                }
            else
                {
                instance[i].env_current[env_amplitude].depth_env_value -= (uint16_t)((int16_t)(0-(int16_t)(instance[i].amplitude_intermediate_sum)));
                }
        }
       
    //Set sum and delta to zero until they are next calculated.
    instance[i].amplitude_intermediate_sum = 0;
    instance[i].amplitude_intermediate_delta = 0;
}

void StepAmplitudeEnvelope(uint16_t i,uint16_t a)
{
//First update the current amplitude depth_env_value with the result of the last intermediate sum    
UpdateAmplitudeDepthValue(i);
    

/*
Now calculate the amplitude_intermediate_delta value, used for linearly interpolating between the current_depth_env_value
and the new_depth_env_value.  This 'intermediate' linear interpolation is used primarily for exponential envelopes, because
the exponential calculations have to happen at spaced intervals for the maths to work with adequate precision.

NOTE: These are two different methods used for the linear interpolation between the current and new depth values.
If the overall difference > 1024 then it simply divides the overall by 32. Otherwise it uses fractional maths. 
 */
adsr_section_envelope_config_row_t s = channel.patch.adsr_section[a].adsr_section_envelope_config[env_amplitude];
envelope_current_t c = instance[i].env_current[env_amplitude];

uint16_t current_depth_env_value = c.depth_env_value;
uint16_t new_depth_env_value = 0;
uint16_t env_delta; 
uint16_t diff;

if (current_depth_env_value < c.KS_depth_env_target[a])
    {
     switch(s.depth_env_type)
        {
            case env_type_linear:
                env_delta = c.KS_depth_delta[a];
                break;
            case env_type_exponential:
                env_delta = (uint16_t)(__builtin_muluu((c.KS_depth_env_target[a] - current_depth_env_value),c.KS_depth_delta[a])>>16);
                break;
            default:
                env_delta = 0;
        }
     if (current_depth_env_value > (c.KS_depth_env_target[a] - env_delta ))
        {new_depth_env_value = c.KS_depth_env_target[a];}
     else
        {new_depth_env_value = current_depth_env_value + env_delta;}
     
     diff = new_depth_env_value - current_depth_env_value;
     if (diff > 1024)
        {
            diff = diff>>5;
            instance[i].flag_amplitude_interp_mult32 = 0;
        }
     else
        {instance[i].flag_amplitude_interp_mult32 = 1;}
     
      instance[i].amplitude_intermediate_delta = (int16_t)diff; 
    }
else if (current_depth_env_value > c.KS_depth_env_target[a])
    {
    switch(s.depth_env_type)
        {
            case env_type_linear:
                env_delta = c.KS_depth_delta[a];
                break;
            case env_type_exponential:
                env_delta = (uint16_t)(__builtin_muluu((current_depth_env_value - c.KS_depth_env_target[a]),c.KS_depth_delta[a])>>16);
                break;
            default:
                env_delta = 0;
        }                    

     if (current_depth_env_value < (c.KS_depth_env_target[a] + env_delta))
        {new_depth_env_value = c.KS_depth_env_target[a];}
     else
        {new_depth_env_value = current_depth_env_value - env_delta;}
    
    diff = current_depth_env_value - new_depth_env_value;
     if (diff > 1024)
        {
            diff = diff>>5;
            instance[i].flag_amplitude_interp_mult32 = 0;
        }
     else
        {instance[i].flag_amplitude_interp_mult32 = 1;}
    instance[i].amplitude_intermediate_delta = (int16_t)(0 - (int16_t)(diff)); 
    }
    else
    {
    instance[i].amplitude_intermediate_delta = 0;
    }
}

void StepEnvelope(volatile adsr_section_envelope_config_row_t *s,volatile envelope_current_t *c,uint16_t a)
{
uint16_t env_delta;    

if (c->depth_env_value < c->KS_depth_env_target[a])
    {
     switch(s->depth_env_type)
        {
            case env_type_linear:
                env_delta = c->KS_depth_delta[a];
                break;
            case env_type_exponential:
                env_delta = (uint16_t)(__builtin_muluu((c->KS_depth_env_target[a] - c->depth_env_value),c->KS_depth_delta[a])>>16);
                break;
            default:
                env_delta = 0;
        }
     if (c->depth_env_value > (c->KS_depth_env_target[a] - env_delta ))
        {c->depth_env_value = c->KS_depth_env_target[a];}
     else
        {c->depth_env_value += env_delta;}
    }
else if (c->depth_env_value > c->KS_depth_env_target[a])
    {
    switch(s->depth_env_type)
        {
            case env_type_linear:
                env_delta = c->KS_depth_delta[a];
                break;
            case env_type_exponential:
                env_delta = (uint16_t)(__builtin_muluu((c->depth_env_value - c->KS_depth_env_target[a]),c->KS_depth_delta[a])>>16);
                break;
            default:
                env_delta = 0;
        }                    

     if (c->depth_env_value < (c->KS_depth_env_target[a] + env_delta))
        {c->depth_env_value = c->KS_depth_env_target[a];}
     else
        {c->depth_env_value -= env_delta;}
    }
}

void StepLFOEnvelope(volatile lfo_envelope_config_row_t *p,volatile adsr_section_envelope_config_row_t *s,volatile lfo_envelope_current_t *c,uint16_t a,uint16_t i)
{
uint16_t env_delta;

if ((p->enabled == 1) && (s->depth_env_type != env_type_none))
       {   
        if (c->depth_env_value < c->KS_depth_env_target[a])
           {
            switch(s->depth_env_type)
               {
                case env_type_linear:
                    env_delta = c->KS_depth_delta[a];
                    break;
                case env_type_exponential:
                    env_delta = (uint16_t)(__builtin_muluu((c->KS_depth_env_target[a] - c->depth_env_value),c->KS_depth_delta[a])>>16);
                    break;
                default:
                    env_delta = 0;
               }
            if (c->depth_env_value > (c->KS_depth_env_target[a] - env_delta ))
               {c->depth_env_value = c->KS_depth_env_target[a];}
            else
               {c->depth_env_value += env_delta;}
           }
        else if (c->depth_env_value > c->KS_depth_env_target[a])
           {
           switch(s->depth_env_type)
               {
                case env_type_linear:
                    env_delta = c->KS_depth_delta[a];
                    break;
                case env_type_exponential:
                    env_delta = (uint16_t)(__builtin_muluu((c->depth_env_value - c->KS_depth_env_target[a]),c->KS_depth_delta[a])>>16);
                    break;
                default:
                       env_delta = 0;
               }                    
//OLD:           if (c->depth_env_value < env_delta)
//               {c->depth_env_value = 0;}
                                          
            if (c->depth_env_value < (env_delta + c->KS_depth_env_target[a]) )
               {c->depth_env_value = c->KS_depth_env_target[a];}
            else
               {c->depth_env_value -= env_delta;}
            }
        
        //Recalc depth
        uint16_t ucc_id = p->depth_cc_source;
        uint16_t ucc_value;
        if(ucc_id == ucc_none)
            {ucc_value = 65535;}
        else if(ucc_id == ucc_velocity)
            {ucc_value = instance[i].velocity16;}
        else
            {ucc_value = channel.ucc_current_values[ucc_id];}

        uint16_t scaled_depth_env_value = (uint16_t)(__builtin_muluu(c->depth_env_value,ucc_value)>>16);

        //Update WT Index
        c->wt_index_q11_5 += c->current_wt_inc_q11_5;                   

        //Gain
        switch(p->lfo_wave_type_id)
            {
                case sine:
                    c->gain = (int16_t)(__builtin_mulsu(interpolated_sine_lookup(c->wt_index_q11_5),scaled_depth_env_value)>>16);  //NOTE: Have had to lose the +1, otherwise overflow   
                    break;
                case square:
                    c->gain = (int16_t)(__builtin_mulsu(SquareLookup(c->wt_index_q11_5 >> 5),scaled_depth_env_value)>>16);    
                    break;
                case triangle:
                    c->gain = (int16_t)(__builtin_mulsu(TriangleLookup(c->wt_index_q11_5 >> 5),scaled_depth_env_value)>>16); 
                    break;
                case saw:
                    c->gain = (int16_t)(__builtin_mulsu(SawLookup(c->wt_index_q11_5 >> 5),scaled_depth_env_value)>>16);    
                    break;
            }     
        }
    else
        {
        c->gain = 32767;
        c->depth_env_value = 65535;
        }
}

uint16_t GetEnvCCValue16(uint16_t i,uint16_t envelope_id)
{
    uint16_t ucc_id = channel.patch.env_gain_CC[envelope_id];
    if(ucc_id == ucc_none)
        {return 65535;}
    else if(ucc_id == ucc_velocity)
        {return instance[i].velocity16;}
    else
        {return channel.ucc_current_values[ucc_id];}
}

uint16_t GetLFOFreqEnvCCValue16(uint16_t i,uint16_t lfo_envelope_id)
{ 
    uint16_t ucc_id = channel.patch.lfo_envelope_config[lfo_envelope_id].freq_cc_source;
    if(ucc_id == ucc_none)
        {return 65535;}
    else if(ucc_id == ucc_velocity)
        {return instance[i].velocity16;}
    else
        {return channel.ucc_current_values[ucc_id];}
}

void process_10ms_event(void)
{
    uint16_t i;
    uint16_t a;
    uint16_t ucc_value;

    for (i = 0;i < max_instances;i++)
    {
        if(instance[i].flag_active == 1)
            {
            a = instance[i].adsr_section_id;

            //==== Portamento ====
            if(channel.patch.portamento_enabled ==1)
                {
                StepEnvelopeNotKeyScaled(&instance[i].portamento_env_config,&instance[i].env_current[env_portamento]);
                IEC0bits.T2IE = 0;
                instance[i].layer[0].wt_inc_q11_5 = instance[i].env_current[env_portamento].depth_env_value + instance[i].layer[0].calculated_detune;
                instance[i].layer[1].wt_inc_q11_5 = instance[i].env_current[env_portamento].depth_env_value + instance[i].layer[1].calculated_detune;
                IEC0bits.T2IE = 1;
                }

            //==== Timbre LFO ====
            
            //Recalc freq
            ucc_value = GetLFOFreqEnvCCValue16(i,lfo_timbre);
            instance[i].lfo_env_current[lfo_timbre].current_wt_inc_q11_5 = (uint16_t)(__builtin_muluu(channel.patch.lfo_envelope_config[lfo_timbre].default_wt_inc_q11_5,ucc_value)>>16);
               
            StepLFOEnvelope(&channel.patch.lfo_envelope_config[lfo_timbre],&channel.patch.adsr_section[a].adsr_section_envelope_config[env_timbre_lfo],&instance[i].lfo_env_current[lfo_timbre],a,i);
            IEC0bits.T2IE = 0;
            instance[i].lfo_timbre_offset_gain = (uint16_t)((int32_t)instance[i].lfo_env_current[lfo_timbre].gain + ((int32_t)(65535) - ((int32_t)instance[i].lfo_env_current[lfo_timbre].depth_env_value>>1)));                  
            IEC0bits.T2IE = 1;
            
            //==== Vibrato ====
            if (channel.patch.lfo_envelope_config[lfo_vibrato].enabled == 1)
                { 
                //Recalc freq
                ucc_value =  GetLFOFreqEnvCCValue16(i,lfo_vibrato);
                instance[i].lfo_env_current[lfo_vibrato].current_wt_inc_q11_5 = (uint16_t)(__builtin_muluu(channel.patch.lfo_envelope_config[lfo_vibrato].default_wt_inc_q11_5,ucc_value)>>16);
                
                StepLFOEnvelope(&channel.patch.lfo_envelope_config[lfo_vibrato],&channel.patch.adsr_section[a].adsr_section_envelope_config[env_vibrato],&instance[i].lfo_env_current[lfo_vibrato],a,i);    

                uint16_t temp = (uint16_t)((int16_t)instance[i].fund_wt_inc_q11_5 + (int16_t)(__builtin_mulus(instance[i].fund_wt_inc_q11_5,instance[i].lfo_env_current[lfo_vibrato].gain)>>15));   
                IEC0bits.T2IE = 0;
                instance[i].layer[0].wt_inc_q11_5 = temp + instance[i].layer[0].calculated_detune;
                instance[i].layer[1].wt_inc_q11_5 = temp + instance[i].layer[1].calculated_detune;
                IEC0bits.T2IE = 1;
                }
            
            //==== Tremolo ====
            if (channel.patch.lfo_envelope_config[lfo_tremolo].enabled == 1)
                { 
                //Recalc freq (do this here, every 10ms, even though Tremolo gain is actually refreshed every 1ms)
                ucc_value =  GetLFOFreqEnvCCValue16(i,lfo_tremolo);
                instance[i].lfo_env_current[lfo_tremolo].current_wt_inc_q11_5 = (uint16_t)(__builtin_muluu(channel.patch.lfo_envelope_config[lfo_tremolo].default_wt_inc_q11_5,ucc_value)>>16);
                }
            
            //==== Timbre ====
            if(channel.patch.waveform_set.timbre_mode == timbre_envelope)
                {
                StepEnvelope(&channel.patch.adsr_section[a].adsr_section_envelope_config[env_timbre],&instance[i].env_current[env_timbre],a);
                instance[i].env_current[env_timbre].depth_env_value_scaled_by_CC = (uint16_t)(__builtin_muluu(GetEnvCCValue16(i,env_timbre),instance[i].env_current[env_timbre].depth_env_value)>>16);
                if (instance[i].env_current[env_timbre].depth_env_value_scaled_by_CC != instance[i].last_timbre_depth_env_value_scaled_by_CC)
                    {
                    instance[i].flag_timbre_recalc_pending = 1; 
                    }
                }           
            }
    }            
}

void process_1ms_event(void)
{         
    uint16_t i;
    uint16_t a;

    for (i = 0;i < max_instances;i++)
    {
        if(instance[i].flag_active == 1)
            {
            a = instance[i].adsr_section_id;

            //==== Pitch ====
            if ((channel.patch.lfo_envelope_config[lfo_vibrato].enabled == 0) && (channel.patch.portamento_enabled == 0))
                 {
                 StepEnvelope(&channel.patch.adsr_section[a].adsr_section_envelope_config[env_pitch],&instance[i].env_current[env_pitch],a);
                 instance[i].env_current[env_pitch].depth_env_value_scaled_by_CC = (uint16_t)(__builtin_muluu(GetEnvCCValue16(i,env_pitch),instance[i].env_current[env_pitch].depth_env_value)>>16);

                 
                 //Note that the pitch is controlled BOTH by the pitch envelope (which can have a controller) PLUS by pitch bend)
                 uint16_t temp = (uint16_t)(instance[i].fund_wt_inc_q11_5 + (uint16_t)(__builtin_muluu(instance[i].fund_wt_inc_q11_5,instance[i].env_current[env_pitch].depth_env_value_scaled_by_CC)>>16));   
                 
                 uint16_t layer1Temp = (uint16_t)((int16_t)temp + (int16_t)instance[i].layer[0].calculated_detune + (int16_t)(__builtin_mulus(instance[i].max_delta_inc_q11_5_UP,(int16_t)channel.ucc_current_values[ucc_pitch_bend] - 32768)>>14)); //Pitch bend is +/- 2 semitones, which is the loose standard that manufacturers follow
                 uint16_t layer2Temp  = (uint16_t)((int16_t)temp + (int16_t)instance[i].layer[1].calculated_detune + (int16_t)(__builtin_mulus(instance[i].max_delta_inc_q11_5_UP,(int16_t)channel.ucc_current_values[ucc_pitch_bend] - 32768)>>14)); 
                 
                 IEC0bits.T2IE = 0;
                 instance[i].layer[0].wt_inc_q11_5 = layer1Temp;
                 instance[i].layer[1].wt_inc_q11_5 = layer2Temp;
                 IEC0bits.T2IE = 1;     
            }      

            //==== Tremolo ====
            StepLFOEnvelope(&channel.patch.lfo_envelope_config[lfo_tremolo],&channel.patch.adsr_section[a].adsr_section_envelope_config[env_tremolo],&instance[i].lfo_env_current[lfo_tremolo],a,i);
            IEC0bits.T2IE = 0;
            instance[i].trem_offset_gain = (uint16_t)((int32_t)instance[i].lfo_env_current[lfo_tremolo].gain + ((int32_t)(65535) - ((int32_t)instance[i].lfo_env_current[lfo_tremolo].depth_env_value>>1)));                  
            instance[i].trem_offset_gain = (uint16_t)(__builtin_muluu(instance[i].trem_offset_gain,GetEnvCCValue16(i,env_tremolo))>>16);
            instance[i].trem_offset_gain = (uint16_t)(__builtin_muluu(instance[i].trem_offset_gain,channel.volume)>>16);
            IEC0bits.T2IE = 1;
            
            //==== Noise ====
            StepEnvelope(&channel.patch.adsr_section[a].adsr_section_envelope_config[env_noise],&instance[i].env_current[env_noise],a);
            instance[i].env_current[env_noise].depth_env_value_scaled_by_CC = (uint16_t)(__builtin_muluu(GetEnvCCValue16(i,env_noise),instance[i].env_current[env_noise].depth_env_value)>>16);

            //==== Noise cut-off ====
            StepEnvelope(&channel.patch.adsr_section[a].adsr_section_envelope_config[env_noise_cutoff_level],&instance[i].env_current[env_noise_cutoff_level],a);
            instance[i].env_current[env_noise_cutoff_level].depth_env_value_scaled_by_CC = (uint16_t)(__builtin_muluu(GetEnvCCValue16(i,env_noise_cutoff_level),instance[i].env_current[env_noise_cutoff_level].depth_env_value)>>16);

            //==== Sample ====
            StepEnvelope(&channel.patch.adsr_section[a].adsr_section_envelope_config[env_sample],&instance[i].env_current[env_sample],a);
            instance[i].env_current[env_sample].depth_env_value_scaled_by_CC = (uint16_t)(__builtin_muluu(GetEnvCCValue16(i,env_sample),instance[i].env_current[env_sample].depth_env_value)>>16);

            //==== Check if end of section ====
            CheckForEndOfSection(i);
            
            //========Check for wave table swap
            if ((flag_pending_wt_swap == 1) && (pending_wt_swap_instance_id == i)) //&& (instance[i].layer[0].wt_index_q11_5 <= instance[i].layer[0].wt_inc_q11_5))
                {
                    //Swap the rough wavetable with the current one assigned to the instance
                    IEC0bits.T2IE = 0;
                    uint16_t temp_id = system.current_rough_wavetable_id;
                    system.current_rough_wavetable_id = instance[i].wavetable_index;
                    instance[i].wavetable_index = temp_id;

                    flag_pending_wt_swap = 0;
                    IEC0bits.T2IE = 1;
                }           
            }   
    }
}

uint16_t get_filter_gain(uint16_t freq_hz)
{
    uint16_t filter_gain;
    
    uint16_t b;
    if (freq_hz <= 271)
        {b= EqBandLookup271HzAndLess[freq_hz - 16];}
    else
        {b= EqBandLookupOver271Hz[freq_hz>>4];}
    
    uint16_t fdelta= freq_hz - band_freq_lookup[b];
    int16_t slope = channel.patch.body_resonance_bands[b].slope;
    
    if (slope > 0)
        {
        filter_gain = (uint16_t)(channel.patch.body_resonance_bands[b].level + (uint16_t)(__builtin_mulus(fdelta,slope)>>5));
        }
    else
        {
        filter_gain = channel.patch.body_resonance_bands[b].level - (uint16_t)(0 - (int16_t)(__builtin_mulus(fdelta,slope)>>5));
        }
    
    //Attenuate bass frequencies because the module has a harsh LPF to reduce noise. Attenuating bass effectively boosts high frequencies
    if (freq_hz <= 6384){filter_gain = (uint16_t)((__builtin_muluu(filter_gain,bass_atten_lookup[freq_hz>>4])) >> 16);}
    
    return filter_gain;
}

void CalculateInstanceWavetable(uint16_t instance_id)
{
    //OUT_TEST_PORT_SetHigh();//*** TEST
    
    //NOTE: This is only called if flag_pending_wt_swap == 0. Can't recalc another WT if a swap is pending
    
    uint16_t s;    
    uint16_t ih[max_harmonics]; //Interpolated Harmonics
    uint16_t h;
    uint16_t st_inc_q11_5 = 32;
    uint16_t st_index_q11_5;    
    uint16_t hg;
    uint16_t fund_freq_hz;
    uint16_t freq_hz;
    
    /*
     Need to stretch to be in range 0 to 256, otherwise leak of amplitude during interpolation
     */
    
    //Note sector variables :
    uint16_t n0;
    uint16_t n1;
    uint16_t n;
    
    if (instance[instance_id].note_sector_id_low >= (max_note_sectors - 1) )
        {
            n0 = max_note_sectors - 1;
            n1 = n0;
            n = 0;
        }
    else
        {
            n0 = instance[instance_id].note_sector_id_low;
            n1 = n0 + 1;
            n = instance[instance_id].note_sector_note_b;
        }
    
    if(n > 128){n++;}
    uint16_t vn = 256 - n; 
    
    //Intensity layer variables:
    uint16_t i0;
    uint16_t i1;
    uint16_t i;
    uint16_t vi;
    uint16_t intensity;
    switch(channel.patch.waveform_set.timbre_controller1_source)
    {
        case ucc_velocity:
            i0 = instance[instance_id].intensity_layer_id_low;
            i1 = i0 + 1;
            i = instance[instance_id].intensity_layer_intensity_b;
            if(i > 128){i++;}
            vi = 256 - i;           
            break;
        case ucc_none:
            i0 = 0;
            i1 = 1;
            i = 0;
            vi = 256;
            break;
        default:
            intensity = channel.ucc_current_values[channel.patch.waveform_set.timbre_controller1_source];
            i0 = (uint16_t)(intensity >> 15);
            i1 = i0 + 1;
            i = ((uint16_t)intensity - (uint16_t)(i0 << 15))>>7; //Range 0 to 255  
            if(i > 128){i++;}
            vi = 256 - i;
    }

    //Wave variables:
    
    uint16_t timbre_gain = __builtin_muluu(instance[instance_id].lfo_timbre_offset_gain,instance[instance_id].env_current[env_timbre].depth_env_value_scaled_by_CC)>>16;
    
    //(instance[instance_id].env_current[env_timbre].depth_env_value_scaled_by_CC)>>14;
    uint16_t w0 = timbre_gain >>14;
    uint16_t w1 = w0 + 1;
    //uint16_t w = (uint16_t)((instance[instance_id].env_current[env_timbre].depth_env_value_scaled_by_CC - (w0 << 14))>>6); //Range 0 to 255
    uint16_t w = (uint16_t)((timbre_gain - (w0 << 14))>>6); //Range 0 to 255
 
    if(w > 128){w++;}
    uint16_t vw = 256 - w; 
    
    uint16_t h0;
    uint16_t h1;
    uint16_t n0i0w0_n1i0w0;
    uint16_t n0i1w0_n1i1w0;
    uint16_t w0plane;
    uint16_t n0i0w1_n1i0w1;
    uint16_t n0i1w1_n1i1w1;
    uint16_t w1plane;
    
    //Get interpolated value for the harmonics
    switch(channel.patch.waveform_set.timbre_mode)
        {
        case timbre_envelope:
            {                
            for (h = 0;h !=max_harmonics;h++)
                {
                    //Interpolate across the w0 plane
                    h0 = channel.patch.waveform_set.waveform_harmonic[n0][i0][w0][h].level;
                    h1 = channel.patch.waveform_set.waveform_harmonic[n1][i0][w0][h].level;
                    n0i0w0_n1i0w0 = (uint16_t)(((uint16_t)__builtin_muluu(h0,vn) +  (uint16_t)__builtin_muluu(h1,n))>>8);//0 to 255

                    h0 = channel.patch.waveform_set.waveform_harmonic[n0][i1][w0][h].level;
                    h1 = channel.patch.waveform_set.waveform_harmonic[n1][i1][w0][h].level;
                    n0i1w0_n1i1w0 = (uint16_t)(((uint16_t)__builtin_muluu(h0,vn) +  (uint16_t)__builtin_muluu(h1,n))>>8);//0 to 255

                    w0plane = (uint16_t)(((uint16_t)__builtin_muluu(n0i0w0_n1i0w0,vi) +  (uint16_t)__builtin_muluu(n0i1w0_n1i1w0,i))>>8);//0 to 255

                    //Interpolate across the w1 plane
                    h0 = channel.patch.waveform_set.waveform_harmonic[n0][i0][w1][h].level;
                    h1 = channel.patch.waveform_set.waveform_harmonic[n1][i0][w1][h].level;
                    n0i0w1_n1i0w1 = (uint16_t)(((uint16_t)__builtin_muluu(h0,vn) +  (uint16_t)__builtin_muluu(h1,n))>>8);//0 to 255

                    h0 = channel.patch.waveform_set.waveform_harmonic[n0][i1][w1][h].level;
                    h1 = channel.patch.waveform_set.waveform_harmonic[n1][i1][w1][h].level;
                    n0i1w1_n1i1w1 = (uint16_t)(((uint16_t)__builtin_muluu(h0,vn) +  (uint16_t)__builtin_muluu(h1,n))>>8);//0 to 255

                    w1plane = (uint16_t)(((uint16_t)__builtin_muluu(n0i0w1_n1i0w1,vi) +  (uint16_t)__builtin_muluu(n0i1w1_n1i1w1,i))>>8);//0 to 255

                    //Get final result by interpolating between planes
                    //ih[h] = channel.patch.waveform_set.waveform_harmonic[0][0][0][h].level << 8;//1000;//
                    ih[h] = (uint16_t)__builtin_muluu(w0plane,vw) +  (uint16_t)__builtin_muluu(w1plane,w);//0 to 65280. NOTE not >>8 because need to multiply the harmonic level by 256                    
                }            
            break;
            }    
        }
    
     //==== Set the fundamental values in the WaveTable.
     st_inc_q11_5 = 32;
     
     //===== Calc the frequency of the fundamental
     //Because of vibrato and pitch bend, we need to calculate on the fly.
     //Wavetable has 2048 samples. Sampling freq = 41666.66Hz. Lowest freq = 41666.66/2048 = 20.345Hz. WT inc = f/20.345 * 32. f = Inc * 20.345/32 = Inc * 41666.66/65536
     
     freq_hz = (uint16_t)(__builtin_muluu(instance[instance_id].layer[0].wt_inc_q11_5,sampling_freq)>>16);
     fund_freq_hz = freq_hz;
     
     hg = (uint16_t)(__builtin_muluu(ih[0],get_filter_gain(freq_hz))>>16);//0 to 65279
     //hg = ih[0];
     for (s = 0;s != wavetable_samples;s++)
     {
         wave_table[system.current_rough_wavetable_id][s] = (int16_t)(__builtin_mulsu(SineLookup[s],hg)>>16);
     }     

     //==== Add the harmonic values to the WaveTable. 
     freq_hz = freq_hz <<1;
     for (h = 1;h !=max_harmonics;h++)
         {    
         st_inc_q11_5 += 32;
         st_index_q11_5 = 0;
         hg = (uint16_t)(__builtin_muluu(ih[h],get_filter_gain(freq_hz))>>16);
        //hg = ih[h];

         if (freq_hz < max_audio_freq)
            {
            if (hg > 0)
                {
                for (s = 0;s != wavetable_samples;s++)
                    {
                    wave_table[system.current_rough_wavetable_id][s] += (int16_t)(__builtin_mulsu(interpolated_sine_lookup(st_index_q11_5),hg)>>16);
                    st_index_q11_5 += st_inc_q11_5;
                    }        
                }
            //NOTE: Only add to freq_hz if freq_hz < max_audio_freq. otherwise freq_hz can overflow 16 bit 
            //and then very high freqs will be included, plus aliasing !!!
            freq_hz += fund_freq_hz;
            }
        }   
     
     if (instance[instance_id].flag_active == 1)
        {
        flag_pending_wt_swap = 1;
        pending_wt_swap_instance_id = instance_id;     
        }
     else
        {
         //Immediately swap the rough wavetable with the current one assigned to the instance
         uint16_t temp_id = system.current_rough_wavetable_id;
         system.current_rough_wavetable_id = instance[instance_id].wavetable_index;
         instance[instance_id].wavetable_index = temp_id;

         flag_pending_wt_swap = 0;
         instance[instance_id].flag_active = 1; //Only make instance active here if it isn't active already
        }
    
     instance[instance_id].last_timbre_depth_env_value_scaled_by_CC = instance[instance_id].env_current[env_timbre].depth_env_value_scaled_by_CC;
     instance[instance_id].flag_timbre_recalc_pending = 0;
     
     //OUT_TEST_PORT_SetLow();//*** TEST
}

void TimbreUpdate(uint16_t i)
{
    if ((instance[i].flag_timbre_recalc_pending == 1) && (flag_pending_wt_swap == 0))
        {
          CalculateInstanceWavetable(i);
        }
}

void InitialiseInstance(uint16_t i,uint16_t midi_note_number,uint16_t velocity16,uint16_t midi_channel,uint16_t last_midi_note_number)
{    
    /*NOTE: Can re-initialise an instance if it is in it's release section. 
     This is because the release section is after a NOTE OFF is received and we don't want to add
     complexity of returning the release status to the Master. So the easiest solution is to 
     allow a tone to be terminated in the release section. Since the instances are allocated using a method
     that spreads the load across processors then this situation is unlikely to occur statistically 'often'. 
     */ 
    instance[i].flag_active = 0;
    instance[i].flag_timbre_recalc_pending = 0;
    instance[i].flag_inharmonic_sample_active = 0;
    if ((flag_pending_wt_swap == 1) && (pending_wt_swap_instance_id == i)){flag_pending_wt_swap = 0;}
    
    instance[i].flag_amplitude_env_started = 0;
    instance[i].key_scale_split_diff = (int16_t)(midi_note_number - channel.patch.key_scale_split_note_id);        
    channel.midi_channel = midi_channel;
    instance[i].velocity16 = velocity16;
    
    //intensity
    uint16_t intensity = velocity16;
    if (intensity>49151){intensity = 49151;}else if (intensity<16384){intensity = 16384;}
    intensity = intensity - 16384; 
    instance[i].intensity_layer_id_low = (uint16_t)(intensity >> 14);
    instance[i].intensity_layer_intensity_b = ((uint16_t)intensity - (uint16_t)(instance[i].intensity_layer_id_low << 14))>>6; //Range 0 to 255
    
    instance[i].overall_gain = 0;
    
    if (instance[i].flag_held_on_by_sustain == 1)
        {
            instance[i].flag_held_on_by_sustain = 0;
            num_held_on_by_sustain --;
        }  
    
    instance[i].noise_lpf_output = 0;
    
    instance[i].amplitude_intermediate_delta = 0;
    instance[i].amplitude_intermediate_sum = 0;
    instance[i].flag_amplitude_interp_mult32 = 0;
    
    uint16_t e;
    uint16_t lfo_e;
    for(e = 0;e<max_non_lfo_envelopes;e++)
        {
        instance[i].env_current[e].depth_env_value = channel.patch.env_initial_depth_value[e];
        instance[i].env_current[e].depth_env_value_scaled_by_CC = (uint16_t)(__builtin_muluu(GetEnvCCValue16(i,e),instance[i].env_current[e].depth_env_value)>>16);
        }
    
    uint16_t ucc_value;
    for(lfo_e = 0;lfo_e<max_lfos;lfo_e++)
        {
        e = lfo_e + env_tremolo;
        instance[i].lfo_env_current[lfo_e].flag_update_pending = 0;
        instance[i].lfo_env_current[lfo_e].depth_env_value = channel.patch.env_initial_depth_value[e];
        ucc_value =  GetLFOFreqEnvCCValue16(i,lfo_e);
        instance[i].lfo_env_current[lfo_e].current_wt_inc_q11_5 =(uint16_t)(__builtin_muluu(channel.patch.lfo_envelope_config[lfo_e].default_wt_inc_q11_5,ucc_value)>>16);
        
        if (lfo_e == lfo_vibrato)
            {
            instance[i].lfo_env_current[lfo_e].wt_index_q11_5 = 0;
            }
        else
            {
            instance[i].lfo_env_current[lfo_e].wt_index_q11_5 = 512<<5; //MUST start at peak of sine wave
            }
        instance[i].lfo_env_current[lfo_e].gain = 32767;
        }

    instance[i].lfo_timbre_offset_gain = 65535;
    instance[i].trem_offset_gain = instance[i].velocity16; //Was 65535
    instance[i].fund_freq_hz = NoteHzLookup[midi_note_number - midi_note_number_a0];
    instance[i].fund_wt_inc_q11_5 = NoteSTIncLookup[midi_note_number - midi_note_number_a0];
    instance[i].midi_note_id = midi_note_number;
    instance[i].note_sector_id_low = (midi_note_number - midi_note_number_a0)>>4;
    instance[i].note_sector_note_b = (midi_note_number -  midi_note_number_a0 - (instance[i].note_sector_id_low << 4))<<4;//Range 0 to 255
    

    instance[i].max_delta_inc_q11_5_UP = (uint16_t)NoteSTIncLookup[midi_note_number + 1 - midi_note_number_a0] - (uint16_t)instance[i].fund_wt_inc_q11_5;
    uint16_t max_delta_inc_q11_5_DOWN = (uint16_t)instance[i].fund_wt_inc_q11_5 - (uint16_t)NoteSTIncLookup[midi_note_number - 1 - midi_note_number_a0];
    
    if (channel.patch.detuning_mode_id == dm_cents)
    {
        //Detuning is in Cents, meaning 100ths of a semitone. The 'beat frequency' varies across the keyboard (standard in Synths)
        instance[i].layer[0].calculated_detune = (uint16_t)(__builtin_muluu(channel.patch.layer_config[0].st_inc_q11_5_detune,instance[i].max_delta_inc_q11_5_UP)>>16);
        instance[i].layer[1].calculated_detune = (uint16_t)(__builtin_muluu(channel.patch.layer_config[1].st_inc_q11_5_detune,instance[i].max_delta_inc_q11_5_UP)>>16);
    }
    else
    {
        //Detuning is what's called 'linear' meaning in Hz. So a 'beat frequency' will be constant across the keyboard (Sometimes implemented in Synths but is a good thing to have as an option))
        instance[i].layer[0].calculated_detune = channel.patch.layer_config[0].st_inc_q11_5_detune;
        instance[i].layer[1].calculated_detune = channel.patch.layer_config[1].st_inc_q11_5_detune;    
    }

    if (channel.patch.portamento_enabled ==1)
        {
        instance[i].env_current[env_portamento].depth_env_value = NoteSTIncLookup[last_midi_note_number - midi_note_number_a0];;
        instance[i].portamento_env_config.depth_env_lin_delta = channel.patch.portamento_rate;
        instance[i].portamento_env_config.depth_env_target = instance[i].fund_wt_inc_q11_5;
        instance[i].portamento_env_config.depth_env_type = env_type_linear;
        
        instance[i].layer[0].wt_inc_q11_5 = instance[i].env_current[env_portamento].depth_env_value + instance[i].layer[0].calculated_detune;
        instance[i].layer[0].wt_index_q11_5 = 0; 
        instance[i].layer[1].wt_inc_q11_5 = instance[i].env_current[env_portamento].depth_env_value + instance[i].layer[1].calculated_detune;
        instance[i].layer[1].wt_index_q11_5 = 0;
        }
    else
        {
        if ((channel.patch.degree_of_random_detuning > 0) || (channel.patch.degree_of_regular_detuning > 0))
            {
            
            uint16_t delta_inc_q11_5;
            uint16_t max_range;
            uint16_t degree_of_detune;
            if (channel.patch.degree_of_regular_detuning > 0)
                {
                degree_of_detune = channel.patch.degree_of_regular_detuning;
                if ((midi_note_number % 2) == 1)
                    {max_range = 65535;}
                else
                    {max_range = 0;}
                }
            else
                {
                degree_of_detune = channel.patch.degree_of_random_detuning;
                max_range = system.rnd_num; 
                }
            
            if(max_range > 32767)
                {
                delta_inc_q11_5 = (uint16_t)(__builtin_muluu(instance[i].max_delta_inc_q11_5_UP,max_range - 32767)>>15);
                delta_inc_q11_5 = (uint16_t)(__builtin_muluu(delta_inc_q11_5,degree_of_detune)>>16);
                instance[i].layer[0].wt_inc_q11_5 = instance[i].fund_wt_inc_q11_5 + instance[i].layer[0].calculated_detune + delta_inc_q11_5; 
                instance[i].layer[1].wt_inc_q11_5 = instance[i].fund_wt_inc_q11_5 + instance[i].layer[1].calculated_detune + delta_inc_q11_5;
                }
            else
                {
                delta_inc_q11_5 = (uint16_t)(__builtin_muluu(max_delta_inc_q11_5_DOWN,32767 - max_range)>>15);
                delta_inc_q11_5 = (uint16_t)(__builtin_muluu(delta_inc_q11_5,degree_of_detune)>>16);
                instance[i].layer[0].wt_inc_q11_5 = instance[i].fund_wt_inc_q11_5 + instance[i].layer[0].calculated_detune - delta_inc_q11_5;  
                instance[i].layer[1].wt_inc_q11_5 = instance[i].fund_wt_inc_q11_5 + instance[i].layer[1].calculated_detune - delta_inc_q11_5;
                }  
            instance[i].fund_wt_inc_q11_5 = instance[i].layer[0].wt_inc_q11_5;
            }
        else
            {
            instance[i].layer[0].wt_inc_q11_5 = instance[i].fund_wt_inc_q11_5 + instance[i].layer[0].calculated_detune;
            instance[i].layer[1].wt_inc_q11_5 = instance[i].fund_wt_inc_q11_5 + instance[i].layer[1].calculated_detune;
            }
        
        if (channel.patch.degree_of_random_phase > 0)
            {
            uint16_t phase_offset;
            phase_offset = (uint16_t)(__builtin_muluu(system.rnd_num,channel.patch.degree_of_random_phase)>>16); 
            phase_offset = (uint16_t)(__builtin_muluu(instance[i].max_delta_inc_q11_5_UP,phase_offset)>>16);  
            instance[i].layer[0].wt_index_q11_5 = phase_offset;  
            instance[i].layer[1].wt_index_q11_5 = phase_offset;  
            }
        else
            {
            instance[i].layer[0].wt_index_q11_5 = 0;
            instance[i].layer[1].wt_index_q11_5 = 0;
            }        
        }
     
    instance[i].adsr_section_id = adsr_attack;
    instance[i].adsr_section_elapsed_time_ms = 0;
    CheckForInharmonicSamplePlayback(i,adsr_attack);

    //############# Calculate key-scaling ################################
    uint16_t a;
    int32_t diff_value;
    int32_t result_value;
    
    for (a=0;a<max_adsr_sections;a++)
        {
        //End time
        if (instance[i].key_scale_split_diff >= 0)
            {
            diff_value = (__builtin_mulss(instance[i].key_scale_split_diff,channel.patch.adsr_section[a].end_time_ms_KU)>>5);
            }
        else
            {
            diff_value = (__builtin_mulss(0 - instance[i].key_scale_split_diff,channel.patch.adsr_section[a].end_time_ms_KL)>>5);
            }
        result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].end_time_ms + diff_value);
        instance[i].KS_end_time[a] = BoundedUSWFromSL(result_value);
        
        //Non-LFO Envelopes
        for(e = 0;e<max_non_lfo_envelopes;e++)
            {
            if (instance[i].key_scale_split_diff >= 0)
                {
                //Target
                diff_value = __builtin_mulss(instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target_KU);
                result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target + diff_value);
                instance[i].env_current[e].KS_depth_env_target[a] = (uint16_t)(__builtin_muluu(BoundedUSWFromSL(result_value),GetEnvCCValue16(i,e))>>16);//311221: Changed from GetEnvCCValue16(i,env_amplitude))>>16)
                
                //Delta
                diff_value = (__builtin_mulss(instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_delta_KU)>>5);
                if(channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_type == env_type_linear)
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_lin_delta + diff_value);              
                    }
                else
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_exp_multiplier + diff_value);         
                    }
                instance[i].env_current[e].KS_depth_delta[a] = BoundedUSWFromSL(result_value);
                }
            else
                {
                //Target
                diff_value = __builtin_mulss(0 - instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target_KL);
                result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target + diff_value);
                instance[i].env_current[e].KS_depth_env_target[a] = (uint16_t)(__builtin_muluu(BoundedUSWFromSL(result_value),GetEnvCCValue16(i,e))>>16);//311221: Changed from GetEnvCCValue16(i,env_amplitude
                
                //Delta
                diff_value = (__builtin_mulss(0 - instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_delta_KL)>>5);
                if(channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_type == env_type_linear)
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_lin_delta + diff_value);               
                    }
                else
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_exp_multiplier + diff_value);             
                    }
                instance[i].env_current[e].KS_depth_delta[a] = BoundedUSWFromSL(result_value); 
                }         
            }  
                      
        //LFO Envelopes
        for(lfo_e = 0;lfo_e<max_lfos;lfo_e++)
            {
            e = lfo_e + env_tremolo;
            if (instance[i].key_scale_split_diff >= 0)
                {
                //Target                
                diff_value = __builtin_mulss(instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target_KU);
                result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target + diff_value);
                instance[i].lfo_env_current[lfo_e].KS_depth_env_target[a] = BoundedUSWFromSL(result_value);
                
                //Delta
                diff_value = (__builtin_mulss(instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_delta_KU)>>5);
                if(channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_type == env_type_linear)
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_lin_delta + diff_value);            
                    }
                else
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_exp_multiplier + diff_value);             
                    }
                instance[i].lfo_env_current[lfo_e].KS_depth_delta[a] = BoundedUSWFromSL(result_value); 
                }
            else
                {
                //Target
                diff_value = __builtin_mulss(0 - instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target_KL);
                result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_target + diff_value);
                instance[i].lfo_env_current[lfo_e].KS_depth_env_target[a] = BoundedUSWFromSL(result_value);
                
                //Delta
                diff_value = (__builtin_mulss(0 - instance[i].key_scale_split_diff,channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_delta_KL)>>5);
                if(channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_type == env_type_linear)
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_lin_delta + diff_value);              
                    }
                else
                    {
                    result_value = (int32_t)((int32_t)channel.patch.adsr_section[a].adsr_section_envelope_config[e].depth_env_exp_multiplier + diff_value);             
                    }
                instance[i].lfo_env_current[lfo_e].KS_depth_delta[a] = BoundedUSWFromSL(result_value); 
                }
            }
        }

    //--------------------------------------------------------
    
    //####### Calculate Karplus Strong #############
    if ((instance[i].midi_note_id >= ks_lowest_midi_note_number) && (channel.patch.adsr_section[adsr_attack].inharmonic_sample_id >= inharmonic_sample_KS_very_long_not_filtered))
        {
        KSB[i].size = KSBufferLengthLookup[instance[i].midi_note_id - ks_lowest_midi_note_number];
        uint16_t b;
        //Initialise the KS buffer with white noise
        for (b = 0;b < KSB[i].size;b++)
            {
            if (channel.patch.adsr_section[adsr_attack].inharmonic_sample_id >= inharmonic_sample_KS_very_long_filtered)
                {
                KSB[i].buf[b] = KSNoiseVeryFiltered[b];
                }
            else
                {
                KSB[i].buf[b] = KSNoiseUnfiltered[b];
                }     
            }
        KSB[i].index=0;
        
        switch (channel.patch.adsr_section[adsr_attack].inharmonic_sample_id)
            {
                case  inharmonic_sample_KS_very_long_not_filtered:
                    KSB[i].multiplier = 65520;
                    break;
                case  inharmonic_sample_KS_long_not_filtered:
                    KSB[i].multiplier = 65500;
                    break;
                case  inharmonic_sample_KS_normal_not_filtered:
                    KSB[i].multiplier = 65272;
                    break;
                case  inharmonic_sample_KS_short_not_filtered:
                    KSB[i].multiplier = 64500;
                    break;
                case  inharmonic_sample_KS_very_short_not_filtered:
                    KSB[i].multiplier = 62500;
                    break;
                case  inharmonic_sample_KS_very_long_filtered:
                    KSB[i].multiplier = 65520;
                    break;
                case  inharmonic_sample_KS_long_filtered:
                    KSB[i].multiplier = 65500;
                    break;
                case  inharmonic_sample_KS_normal_filtered:
                    KSB[i].multiplier = 65272;
                    break;
                case  inharmonic_sample_KS_short_filtered:
                    KSB[i].multiplier = 64500;
                    break;
                case  inharmonic_sample_KS_very_short_filtered:
                    KSB[i].multiplier = 62500;
                    break;
            }
        }
    
    instance[i].flag_timbre_recalc_pending = 1;
    instance[i].last_timbre_depth_env_value_scaled_by_CC  = 12345;
}

void CheckForEndOfSection(uint16_t i)
{
instance[i].adsr_section_elapsed_time_ms++;
if ((channel.patch.adsr_section[instance[i].adsr_section_id].end_time_ms != 0) && (instance[i].adsr_section_elapsed_time_ms >= instance[i].KS_end_time[instance[i].adsr_section_id]))
//if ((channel.patch.adsr_section[instance[i].adsr_section_id].end_time_ms != 0) && (instance[i].adsr_section_elapsed_time_ms >= channel.patch.adsr_section[instance[i].adsr_section_id].end_time_ms))
    {
    if (instance[i].adsr_section_id == adsr_release)
        {
        instance[i].flag_active = 0;
        instance[i].flag_timbre_recalc_pending = 0;
        instance[i].flag_inharmonic_sample_active = 0;
        if ((flag_pending_wt_swap == 1) && (pending_wt_swap_instance_id == i))
            {flag_pending_wt_swap = 0;} //Don't want WT calculation to occur after inactive
        }
    else
        {
        instance[i].adsr_section_id++;
        instance[i].adsr_section_elapsed_time_ms = 0;
        UpdateAmplitudeDepthValue(i);
        CheckForInharmonicSamplePlayback(i,instance[i].adsr_section_id);
        }
    } 
}

void UpdateSampleValue(void)
{ 
    uint16_t i;
    channel.sample_sum = 0;
    int16_t instance_sample_value = 0;
    uint16_t amplitude_depth_env_value;
    int32_t delta32;
    
    //OUT_TEST_PORT_SetHigh(); //***TEST
    
    //Update random number. See :http://www.retroprogramming.com/2017/07/xorshift-pseudorandom-numbers-in-z80.html
    system.rnd_num ^= system.rnd_num << 7;
    system.rnd_num ^= system.rnd_num >> 9;
    system.rnd_num ^= system.rnd_num << 8;
    
    //Update 32 sample count
    system.event_32Sample_trigger_count ++; if(system.event_32Sample_trigger_count == 32){system.event_32Sample_trigger_count = 0;}

    //Calculate channel.sample_sum, as a sum of the samples from all active instances
    for (i=0;i!=max_instances;i++)
        {        
        //======== Stop or loop inharmonic sample if necessary
        if (channel.patch.adsr_section[adsr_attack].inharmonic_sample_id < inharmonic_sample_KS_very_long_not_filtered)
            {
            if ((instance[i].flag_inharmonic_sample_active == 1) &&(instance[i].inharmonic_elapsed_samples >= sample_length))
                {
                    if (channel.patch.adsr_section[instance[i].adsr_section_id].inharmonic_sample_playback_mode_id == sample_playback_mode_looped)
                        {
                        instance[i].inharmonic_sample_ptr = instance[i].inharmonic_sample_ptr_start;
                        instance[i].inharmonic_elapsed_samples = 0;//030122: Added 
                        //CheckForInharmonicSamplePlayback(i,instance[i].adsr_section_id);
                        }
                    else
                        {instance[i].flag_inharmonic_sample_active = 0;}
                }
            }
        
        if (instance[i].flag_active == 1)
            {               
            //======== Adjust amplitude envelope. ONLY if i = system.event_32Sample_trigger_count. 
            //This staggers execution across samples and only occurs for an instance every 32 samples
            if (i == system.event_32Sample_trigger_count)
                {
                StepAmplitudeEnvelope(i,instance[i].adsr_section_id);
                //NOT REQUIRED>>>>: We scale the targets for the amplitude envelope when the instance is initialised.// instance[i].env_current[env_amplitude].depth_env_value_scaled_by_CC = (uint16_t)(__builtin_muluu(GetEnvCCValue16(i,env_amplitude),instance[i].env_current[env_amplitude].depth_env_value)>>16);
                instance[i].flag_amplitude_env_started = 1;
                }

            //======== Add intermediate amplitude delta and calculate overall gain
            instance[i].amplitude_intermediate_sum += instance[i].amplitude_intermediate_delta;
            
            amplitude_depth_env_value = instance[i].env_current[env_amplitude].depth_env_value;
            
            if (instance[i].flag_amplitude_interp_mult32 == 1) 
                {
                if (instance[i].amplitude_intermediate_sum > 0)
                    {
                    amplitude_depth_env_value +=(uint16_t)(instance[i].amplitude_intermediate_sum>>5);
                    }
                else
                    {
                    amplitude_depth_env_value -=(uint16_t)((int16_t)(0 - (instance[i].amplitude_intermediate_sum>>5)));
                    }
                }
            else
                {
                if (instance[i].amplitude_intermediate_sum > 0)
                    {
                    amplitude_depth_env_value +=(uint16_t)(instance[i].amplitude_intermediate_sum);
                    }
                else
                    {
                    amplitude_depth_env_value -=(uint16_t)((int16_t)(0 - (instance[i].amplitude_intermediate_sum)));
                    }
                }

            instance[i].overall_gain = __builtin_muluu(instance[i].trem_offset_gain,amplitude_depth_env_value)>>16;
            
            //======== Get the raw instance sample from the wave table
            if(channel.patch.active_layers == 1)
                {
                instance_sample_value = interpolated_wt_lookup(i,0); 
                }
            else if (channel.patch.active_layers == 2)     
                {
                instance_sample_value = (interpolated_wt_lookup(i,0)>>1) + (interpolated_wt_lookup(i,1)>>1);
                }   

            //========= Apply overall gain
            instance_sample_value = (int16_t)(__builtin_mulsu(instance_sample_value,instance[i].overall_gain)>>16);
            
            //======== Mix in inharmonic sample, if active
            if(instance[i].flag_inharmonic_sample_active == 1)
                {
                if (channel.patch.adsr_section[adsr_attack].inharmonic_sample_id >= inharmonic_sample_KS_very_long_not_filtered)
                    {
                    int16_t ksv = KSB[i].buf[KSB[i].index];
                    uint16_t ksi = KSB[i].index;
                    instance_sample_value =(int16_t)((__builtin_mulsu(ksv,instance[i].env_current[env_sample].depth_env_value_scaled_by_CC)>>16) + (__builtin_mulsu(instance_sample_value,(uint16_t)(65535 - instance[i].env_current[env_sample].depth_env_value_scaled_by_CC))>>16));
                    KSB[i].index ++; if(KSB[i].index == KSB[i].size){KSB[i].index=0;}
                    KSB[i].buf[ksi] = (int16_t)(__builtin_mulsu((int16_t)((ksv >>1) + (KSB[i].buf[KSB[i].index] >>1)),KSB[i].multiplier)>>16);//Note division by 2 before adding. Although deceases accuracy it stops overflow in 16 bit
                    }
                else
                    {
                    instance_sample_value =(int16_t)((__builtin_mulsu(*instance[i].inharmonic_sample_ptr,instance[i].env_current[env_sample].depth_env_value_scaled_by_CC)>>16) + (__builtin_mulsu(instance_sample_value,(uint16_t)(65535 - instance[i].env_current[env_sample].depth_env_value_scaled_by_CC))>>16));
                    instance[i].inharmonic_sample_ptr++;
                    instance[i].inharmonic_elapsed_samples++;
                    }
                }
            
            //======== Perform low pass filtering of noise based on noise cutoff envelope value
            // Using simple IIR Filter: y[n] = y[n-1] + g(x[n] - y[n-1])
            instance[i].noise_lpf_output += (int16_t)(__builtin_mulus(instance[i].env_current[env_noise_cutoff_level].depth_env_value_scaled_by_CC,system.rnd_num - instance[i].noise_lpf_output)>>16);

            //======== Mix in noise and add this instance sample to the sample_sum
            channel.sample_sum += (int32_t)((__builtin_mulsu(instance[i].noise_lpf_output,instance[i].env_current[env_noise].depth_env_value_scaled_by_CC)>>16) + (__builtin_mulsu(instance_sample_value,(uint16_t)(65535 - instance[i].env_current[env_noise].depth_env_value_scaled_by_CC))>>16));

            //======== Increment sample index
            if (instance[i].flag_amplitude_env_started == 1)
                {
                instance[i].layer[0].wt_index_q11_5 +=instance[i].layer[0].wt_inc_q11_5;
                instance[i].layer[1].wt_index_q11_5 +=instance[i].layer[1].wt_inc_q11_5;
                }
            }
        }
   
    //Calculate the difference between this new sample_sum and the last sample, limiting to int16
    delta32 = (int32_t)(channel.sample_sum - system.last_sample);
    if (delta32 > 32767L){delta32 = 32767L;} else if (delta32 < -32768L){delta32 = -32768L;}
    
    /*Calc temporarily new sample, based on limited delta, here rather than in section below where interrupt disabled.
     This ensures that the SPI1 interrupt is delayed for the minimum
     */
    int32_t temp_current_sample = (int32_t)(system.last_sample + delta32); 
    
    //Update system variables, disabling interrupt first. This is because the interrupt uses these variables also.
    IPC2bits.SPI1IP = 0;//Disable SPI1 interrupt by setting it's priority to zero
    system.current_sample = temp_current_sample;
    system.sample_delta16 = (int16_t)delta32;
    IPC2bits.SPI1IP = spi1_int_priority;

    //OUT_TEST_PORT_SetLow(); //***TEST
}

