/* 
 * File:   Spectral_Pins.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_PINS_H
#define	SPECTRAL_PINS_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <xc.h>

#define INPUT   1
#define OUTPUT  0
    
#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0
    
#define IN_SPI1_SS_PORT PORTBbits.RB0
#define IN_SPI1_CLK_PORT PORTBbits.RB7
#define IN_SPI1_MOSI_PORT PORTBbits.RB9
#define OUT_SPI1_MISO_PORT PORTBbits.RB8

#define OUT_TEST_PORT PORTBbits.RB11
#define OUT_TEST_PORT_SetHigh() do { LATBbits.LATB11 = 1; } while(0)
#define OUT_TEST_PORT_SetLow() do { LATBbits.LATB11 = 0; } while(0)  
#define OUT_TEST_PORT_Toggle() do { LATBbits.LATB11 = ~LATBbits.LATB11; } while(0) 
    
    

/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/ 
        
void Spectral_Pins_Initialize (void);



#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_PINS_H */

