/* 
 * File:   Spectral_Messaging.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_MESSAGING_H
#define	SPECTRAL_MESSAGING_H

#ifdef	__cplusplus
extern "C" {
#endif
 
#include <xc.h>
    
/******************************************************************************/
/***** Declarations ***********************************************************/
/******************************************************************************/    
#define msg_instance_noteon_len 10
#define msg_instance_noteoff_len 5    
#define msg_instance_cc_len 7
    
/******************************************************************************/
/***** Enumerations ***********************************************************/
/******************************************************************************/    
     
 enum msg_types
{
    msg_type_adsr_section = 0,
    msg_type_adsr_section_envelope_config = 1,
    msg_type_biquad_eq_calculated = 2,
    msg_type_lfo_envelope_config = 3,
    msg_type_patch = 4,
    msg_type_waveform = 5,
    msg_type_waveform_harmonic = 6,
    msg_type_waveform_set = 7,
    SaveConfig = 9,
    msg_type_body_resonance_filter_band = 10,
    msg_type_envelope_control = 11,
    InstanceNoteOn = 20,
    InstanceNoteOff = 21,
    InstanceControlChange = 22,
    ChannelVolume = 40,
    StartPlayModeTP = 36860,
    StopPlayModeTP  = 36861
};

enum midi_cc
{
   cc_sustain_pedal = 64
};

enum used_midi_cc
{
    ucc_none = 0,
    ucc_pitch_bend = 1,
    ucc_modulation = 2,
    ucc_breath_controller = 3,
    ucc_expression = 4,
    ucc_foot_controller = 5,
    ucc_sustain = 6,
    ucc_velocity = 7
};


/******************************************************************************/
/***** Types ******************************************************************/
/******************************************************************************/
typedef struct
{   
    uint16_t message_recipient;
    uint16_t message_type;
    uint16_t instance_id;
    uint16_t midi_channel;
    uint16_t patch_id; 
    uint16_t note_id;
    uint16_t last_midi_note_number;
    uint16_t velocity_id;
} msg_instance_noteon;

typedef struct  {
    uint16_t message_recipient;
    uint16_t message_type;
    uint16_t instance_id;
} msg_instance_noteoff;

typedef struct  {
    uint16_t message_recipient;
    uint16_t message_type;
    uint16_t midi_channel;
    uint16_t midi_control;
    uint16_t control_value;
} msg_instance_cc;
    
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/



#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_MESSAGING_H */

