/* 
 * File:   Spectral_Sound.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_SOUND_H
#define	SPECTRAL_SOUND_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <xc.h>
#include "Spectral_Pins.h"
#include "Spectral_Messaging.h"
#include "Spectral_FIFOBuffers.h"
#include "Spectral_SPI_2.h"

/******************************************************************************/
/***** Definitions ************************************************************/
/******************************************************************************/
#define mix_alert_delay_ms 100
#define max_waveforms 5
#define max_lfos 3
#define max_harmonics 32
#define max_adsr_sections 4
#define max_biquad_filters 2
#define max_layers 3
#define max_inharmonic_sample_dur_ms 9
#define max_envelopes 10
#define max_agc_lookup_values 160
#define max_simple_agc_halves 13
#define max_intensity_layers 3
#define max_note_sectors 5
#define max_body_resonance_filter_bands 32
#define reset_sample_threshold 100
    
#define max_midi_channels 6
#define patches_per_patchset 18
#define performances_per_patchset 8
#define temp_max_perf_tone_processors 6
    
#define performance_size 31
    
/******************************************************************************/
/***** Enums ******************************************************************/
/******************************************************************************/ 
enum env_types
    {
        env_type_none = 0,
        env_type_linear = 1,
        env_type_exponential = 2
    };
/******************************************************************************/
/***** Types - Database related ***********************************************/
/******************************************************************************/

typedef struct {
    uint16_t level;
    //uint16_t phase;  
}waveform_harmonic_row_t;

typedef struct  {   
    waveform_harmonic_row_t waveform_harmonic[max_note_sectors][max_intensity_layers][max_waveforms][max_harmonics];
    uint16_t timbre_mode;
    uint16_t timbre_controller1_source;
    uint16_t timbre_controller2_source;
} waveform_set_row_t;

typedef struct  {
    uint16_t enabled;
    uint16_t lfo_wave_type_id;
    uint16_t default_wt_inc_q11_5;
    uint16_t freq_cc_source;    
    uint16_t depth_cc_source;  
} lfo_envelope_config_row_t;

typedef struct  {
    uint16_t depth_env_type;
    uint16_t depth_env_target;
    int16_t depth_env_target_KU;
    int16_t depth_env_target_KL;
    uint16_t depth_env_lin_delta;
    uint16_t depth_env_exp_multiplier;
    int16_t depth_delta_KU;
    int16_t depth_delta_KL;   
} adsr_section_envelope_config_row_t;

typedef struct  {   
    uint16_t flag_active;
    uint16_t end_time_ms;
    int16_t end_time_ms_KU;
    int16_t end_time_ms_KL;
    uint16_t inharmonic_sample_playback_mode_id;
    uint16_t inharmonic_sample_id;
    //-------------------------------------
    adsr_section_envelope_config_row_t adsr_section_envelope_config[max_envelopes];
} adsr_section_row_t;

typedef struct {
   uint16_t st_inc_q11_5_detune;
} layer_config_t;

typedef struct {
    uint16_t level;
    uint16_t slope;
} body_resonance_band_row_t;

typedef struct  { 
    uint16_t sustain_enabled;
    uint16_t active_layers;
    uint16_t degree_of_random_detuning;
    uint16_t degree_of_random_phase;
    uint16_t degree_of_regular_detuning;
    uint16_t pitch_bend_enabled;   
    uint16_t portamento_enabled;
    uint16_t portamento_rate;
    uint16_t detuning_mode_id;
  //----------------------------------
    layer_config_t layer_config[max_layers];
    uint16_t key_scale_split_note_id;
    adsr_section_row_t adsr_section[max_adsr_sections];
    lfo_envelope_config_row_t lfo_envelope_config[max_lfos];
    uint16_t env_gain_CC[max_envelopes];
    uint16_t env_initial_depth_value[max_envelopes];
    body_resonance_band_row_t body_resonance_bands[max_body_resonance_filter_bands];
    waveform_set_row_t waveform_set;
} patch_row_t;

typedef struct { 
    uint16_t module_patch_id;
    uint16_t volume;
    uint16_t note_range_low;
    uint16_t note_range_high; 
} performance_channel_t;

typedef union
{
uint16_t data[performance_size];
struct {
    performance_channel_t pc[max_midi_channels];
    uint16_t haas_delay_ms;   
    uint16_t processor_channel_allocation[temp_max_perf_tone_processors];
};
} performance_t;

/******************************************************************************/
/***** Types ******************************************************************/
/******************************************************************************/


/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/
void set_haas_delay_buffer_to_use(uint16_t value);
void SoundInitialize(void);
void UpdateAGC(void);

#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_SOUND_H */

