/* 
 * File:   Spectral_Pins.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_PINS_H
#define	SPECTRAL_PINS_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0
    
#define OUT_MIXALERT_PORT PORTAbits.RA0
#define OUT_MIXALERT_PORT_SetHigh() do { LATAbits.LATA0 = 1; } while(0)
#define OUT_MIXALERT_PORT_SetLow() do { LATAbits.LATA0 = 0; } while(0)  
#define OUT_MIXALERT_Toggle() do { LATAbits.LATA0 = ~LATAbits.LATA0; } while(0)    
    
#define IN_OSCCLK_PORT PORTAbits.RA2
   
#define OUT_SPI2_MOSI_PORT PORTBbits.RB2
#define OUT_SPI2_CLK_PORT PORTBbits.RB1
#define IN_SPI2_MISO_PORT PORTBbits.RB0  
    
//These are used to efficiently switch two SS lines at a time using XOR. 1_2 and 2_3 are using LATA, rest are LATB
    /*
     *SS1 = RA1
     *SS2 = RA3
     *SS3 = RA4
     *SS4 = RB3
     *SS5 = RB4
     *SS6 = RB5
     */
#define SPI2_P0_from_RA_to_RA1 0b00000010   
#define SPI2_P1_from_RA1_to_RA3 0b00001010   
#define SPI2_P2_from_RA3_to_RA4 0b00011000 
#define SPI2_P3_from_RA4_to_RA 0b00010000
#define SPI2_P3_from_RB_to_RB3 0b00001000
#define SPI2_P4_from_RB3_to_RB4 0b00011000
#define SPI2_P5_from_RB4_to_RB5 0b00110000
   
    
#define OUT_SPI2_SS1_PORT PORTAbits.RA1
#define OUT_SPI2_SS1_PORT_SetHigh() do { LATAbits.LATA1 = 1; } while(0)
#define OUT_SPI2_SS1_PORT_SetLow() do { LATAbits.LATA1 = 0; } while(0)  
    
#define OUT_SPI2_SS2_PORT PORTAbits.RA3
#define OUT_SPI2_SS2_PORT_SetHigh() do { LATAbits.LATA3 = 1; } while(0)
#define OUT_SPI2_SS2_PORT_SetLow() do { LATAbits.LATA3 = 0; } while(0)  
    
#define OUT_SPI2_SS3_PORT PORTAbits.RA4
#define OUT_SPI2_SS3_PORT_SetHigh() do { LATAbits.LATA4 = 1; } while(0)
#define OUT_SPI2_SS3_PORT_SetLow() do { LATAbits.LATA4 = 0; } while(0)  
    
#define OUT_SPI2_SS4_PORT PORTBbits.RB3
#define OUT_SPI2_SS4_PORT_SetHigh() do { LATBbits.LATB3 = 1; } while(0)
#define OUT_SPI2_SS4_PORT_SetLow() do { LATBbits.LATB3 = 0; } while(0)  
    
#define OUT_SPI2_SS5_PORT PORTBbits.RB4
#define OUT_SPI2_SS5_PORT_SetHigh() do { LATBbits.LATB4 = 1; } while(0)
#define OUT_SPI2_SS5_PORT_SetLow() do { LATBbits.LATB4 = 0; } while(0)      
    
#define OUT_SPI2_SS6_PORT PORTBbits.RB5
#define OUT_SPI2_SS6_PORT_SetHigh() do { LATBbits.LATB5 = 1; } while(0)
#define OUT_SPI2_SS6_PORT_SetLow() do { LATBbits.LATB5 = 0; } while(0)      
      
#define OUT_MEM_SCL_PORT PORTBbits.RB8 //  
#define OUT_MEM_SDA_PORT PORTBbits.RB9 // 
    
#define OUT_SPI1_MISO_PORT PORTBbits.RB6 //
#define IN_SPI1_MOSI_PORT PORTBbits.RB7 //
#define IN_SPI1_SCK_PORT PORTBbits.RB10
#define IN_SPI1_SS_PORT PORTBbits.RB11
    
#define OUT_DAC_R_POS_PORT PORTBbits.RB12
#define OUT_DAC_R_NEG_PORT PORTBbits.RB13
#define OUT_DAC_L_POS_PORT PORTBbits.RB14
#define OUT_DAC_L_NEG_PORT PORTBbits.RB15
   

void Spectral_Pins_Initialize(void);


#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_PINS_H */

