/* 
 * File:   Spectral_Messaging.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_MESSAGING_H
#define	SPECTRAL_MESSAGING_H

#ifdef	__cplusplus 
extern "C" {
#endif
#include <xc.h>

/******************************************************************************/
/***** Declarations ***********************************************************/
/******************************************************************************/    
    
/******************************************************************************/
/***** Enumerations ***********************************************************/
/******************************************************************************/
    enum msg_recipients
    {
        processor0 = 0,
        processor1 = 1,
        processor2 = 2,
        processor3 = 3,
        processor4 = 4,
        processor5 = 5,
        all_processors = 6,
        mixer = 9,
        master = 10,
        no_recipient = 100
    }; 
  
    enum msg_types
   {
       msg_type_adsr_section = 0,
       msg_type_adsr_section_envelope_config = 1,
       msg_type_biquad_eq_calculated = 2,
       msg_type_lfo_envelope_config = 3,
       msg_type_patch = 4,
       msg_type_waveform = 5,
       msg_type_waveform_harmonic = 6,
       msg_type_waveform_set = 7,
       msg_type_patch_all = 8,
       msg_type_body_resonance_filter_band = 10,
       msg_type_envelope_control = 11,
       msg_type_save_patch_to_EEPROM = 15,
       msg_type_load_patch_from_EEPROM = 16,
       msg_type_performance = 17,
       msg_type_select_performance = 18,
       msg_type_relay_performances_to_mixer = 19,
       InstanceNoteOn = 20,
       InstanceNoteOff = 21,
       InstanceControlChange = 22,
       ChangeEQ = 30,
       ChangeEffect = 31,
       ChangeVolume = 32,
       ChannelVolume = 40,
       StartPlayMode = 41,
       StopPlayMode  = 42,
       msg_default_banks = 43,
       StartPlayModeTP = 36860,
       StopPlayModeTP = 36861,
       StartStopPlayModeTP_Replacement = 36862
   };
    
    enum midi_controls
    {
        aftertouch = 123,
        somethingelse = 0
    
    };
/******************************************************************************/
/***** Types ******************************************************************/
/******************************************************************************/

    
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/



#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_MESSAGING_H */

