/* 
 * File:   Spectral_Interrupts.c
 * Author: Jeremy Leach
 */

#include "Spectral_Timer1.h"

volatile uint16_t ms_counter;
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/

void Timer_Initialize (void)
{
    /*
     When the timer is enabled, it increments by one on every rising edge of the input clock and generates 
     an interrupt on a period match.
     
     Fcy = 70MHz.
     
     The PRn register resets one timer clock period only after the TnIF bit is set.
     The TnIF bit is set one instruction cycle after a period match.
     */
    
    //==== Timer 1======
    T1CONbits.TON = 0;      // Disable Timer
    T1CONbits.TCS = 0;      // Select internal instruction cycle clock
    T1CONbits.TGATE = 0;    // Disable Gated Timer mode
    T1CONbits.TCKPS = 0b11; // Select 1:256 Prescaler
    TMR1 = 0x00;            // Clear timer register
    PR1 = 273;//Load the period value into 16-bit Period Register. 1ms interval. 70MIPS/(273 * 256) = 1001.6 Hz.
    IFS0bits.T1IF = 0;      // Clear Timer1 Interrupt Flag     
    
    
    //==== Timer 2=====
    T2CONbits.TON = 0;      // Disable Timer
    T2CONbits.T32 = 0;      // 16 bit mode
    T2CONbits.TCS = 0;      // Select internal instruction cycle clock
    T2CONbits.TGATE = 0;    // Disable Gated Timer mode
    T2CONbits.TCKPS = 0b01; // Select 1:8 Prescaler
    TMR2 = 0x00;            // Clear timer register
    PR2 = 196;//Load the period value into 16-bit Period Register. 70MIPS/(196 * 8) = 44,642.857 Hz
    IFS0bits.T2IF = 0;      // Clear Timer2 Interrupt Flag    
    
}



